/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.breadcrumb;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.breadcrumb.BreadcrumbViewer;
import org.jkiss.utils.ArrayUtils;

public class NodeBreadcrumbViewer
extends BreadcrumbViewer {
    private static final Log log = Log.getLog(NodeBreadcrumbViewer.class);

    public NodeBreadcrumbViewer(@NotNull Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new BreadcrumbNodeLabelProvider());
        this.setContentProvider((IContentProvider)new BreadcrumbNodeContentProvider(false));
        this.setDropDownContentProvider(new BreadcrumbNodeContentProvider(true));
        this.addOpenListener(e -> NodeBreadcrumbViewer.openEditor(e.getSelection()));
        this.addDoubleClickListener(e -> NodeBreadcrumbViewer.openEditor(e.getSelection()));
    }

    private static void openEditor(@NotNull ISelection selection) {
        IStructuredSelection ss;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof DBNNode) {
            DBNNode node = (DBNNode)object;
            DBWorkbench.getPlatformUI().openEntityEditor(node, null);
        }
    }

    private static class BreadcrumbNodeLabelProvider
    extends LabelProvider {
        private BreadcrumbNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            return DBeaverIcons.getImage((DBPImage)((DBNNode)element).getNodeIconDefault());
        }

        public String getText(Object element) {
            return ((DBNNode)element).getNodeDisplayName();
        }
    }

    private record BreadcrumbNodeContentProvider(boolean allowFoldersOnly) implements ITreeContentProvider
    {
        public Object[] getElements(Object inputElement) {
            DBNNode child = (DBNNode)inputElement;
            DBNNode parent = child.getParentNode();
            if (parent != null) {
                return this.getChildren(parent);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            DBNNode child = (DBNNode)element;
            if (child instanceof DBNDataSource) {
                return null;
            }
            DBNNode parent = child.getParentNode();
            while (parent instanceof DBNDatabaseFolder) {
                parent = parent.getParentNode();
            }
            return parent;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = BreadcrumbNodeContentProvider.getCachedChildren((DBNNode)parentElement);
            if (children != null) {
                return children;
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (!this.allowFoldersOnly || element instanceof DBNLocalFolder) {
                return !ArrayUtils.isEmpty((Object[])BreadcrumbNodeContentProvider.getCachedChildren((DBNNode)element));
            }
            return false;
        }

        @Nullable
        private static DBNNode[] getCachedChildren(@NotNull DBNNode parent) {
            try {
                return parent.getChildren((DBRProgressMonitor)new LocalCacheProgressMonitor((DBRProgressMonitor)new VoidProgressMonitor()));
            }
            catch (DBException e) {
                log.error((Object)"Error getting children", (Throwable)e);
                return null;
            }
        }
    }
}

