/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.configuration.ConfigurationExportData;
import org.jkiss.dbeaver.tools.configuration.ConfigurationExportWizardPage;

public class ConfigurationExportWizard
extends Wizard
implements IExportWizard {
    private static final Log log = Log.getLog(ConfigurationExportWizard.class);
    private ConfigurationExportWizardPage pageMain;

    public void addPages() {
        super.addPages();
        this.pageMain = new ConfigurationExportWizardPage();
        this.addPage((IWizardPage)this.pageMain);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(CoreMessages.dialog_workspace_export_wizard_window_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final Path workbench = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(".plugins/org.eclipse.core.runtime/.settings");
        if (!(workbench.toFile().exists() && workbench.toFile().isDirectory() && workbench.toFile().canRead())) {
            log.error((Object)"Error reading workspace configuration");
            return false;
        }
        ConfigurationExportData exportData = this.pageMain.getExportData();
        Object path = exportData.getFile();
        if (!exportData.getFile().endsWith(".zip")) {
            path = (String)path + ".zip";
        }
        final Path zipFile = Path.of((String)path, new String[0]);
        new Job(this, "Copying workspace configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean delete;
                Path parent = zipFile.getParent();
                if (parent != null && !parent.toFile().canWrite()) {
                    return Status.error((String)"Can't create a file, because the export destination is read-only");
                }
                if (zipFile.toFile().exists() && !(delete = zipFile.toFile().delete())) {
                    return Status.error((String)"Error deleting previous ZIP file contents");
                }
                try (final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile.toFile()));){
                    Files.walkFileTree(workbench, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            zos.putNextEntry(new ZipEntry(file.toFile().getName()));
                            File confFile = file.toFile();
                            try (FileInputStream fis = new FileInputStream(confFile);){
                                byte[] writeBuffer = new byte[16384];
                                int br = fis.read(writeBuffer);
                                while (br != -1) {
                                    zos.write(writeBuffer, 0, br);
                                    br = fis.read(writeBuffer);
                                }
                                zos.flush();
                            }
                            zos.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            zos.finish();
                            return super.postVisitDirectory(dir, exc);
                        }
                    });
                }
                catch (IOException e) {
                    log.error((Object)("Error copying file configuration:" + String.valueOf(e)));
                    Status.error((String)e.getMessage());
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return true;
    }
}

