/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.session.SQLServerSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.utils.CommonUtils;

public class SQLServerSessionManager
implements DBAServerSessionManager<SQLServerSession>,
DBAServerSessionManagerSQL {
    public static final String OPTION_SHOW_ONLY_CONNECTIONS = "showOnlyConnections";
    private final SQLServerDataSource dataSource;

    public SQLServerSessionManager(SQLServerDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<SQLServerSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
            ArrayList<SQLServerSession> arrayList;
            block15: {
                JDBCResultSet dbResult = dbStat.executeQuery();
                try {
                    ArrayList<SQLServerSession> sessions = new ArrayList<SQLServerSession>();
                    while (dbResult.next()) {
                        sessions.add(new SQLServerSession((ResultSet)dbResult));
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block15;
                }
                catch (Throwable throwable) {
                    if (dbResult != null) {
                        try {
                            dbResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbResult.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull String sessionId, @NotNull Map<String, Object> options) throws DBException {
        try (JDBCStatement dbStat = ((JDBCSession)session).createStatement();){
            dbStat.execute("KILL " + sessionId);
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    @NotNull
    public Map<String, Object> getTerminateOptions() {
        return Map.of();
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        boolean onlyConnections = CommonUtils.getOption(options, (String)OPTION_SHOW_ONLY_CONNECTIONS);
        boolean supportsDatabaseInfo = this.dataSource.isServerVersionAtLeast(11, 0);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT s.*,");
        if (supportsDatabaseInfo) {
            sql.append("db.name as database_name,");
        } else {
            sql.append("NULL as database_name,");
        }
        sql.append("c.connection_id,(select text from sys.dm_exec_sql_text(c.most_recent_sql_handle)) as sql_text\n").append("FROM sys.dm_exec_sessions s\n");
        if (!onlyConnections) {
            sql.append("LEFT OUTER ");
        }
        sql.append("JOIN sys.dm_exec_connections c ON c.session_id=s.session_id\n");
        if (supportsDatabaseInfo) {
            sql.append("LEFT OUTER JOIN sys.sysdatabases db on db.dbid=s.database_id\n");
        }
        sql.append("ORDER BY s.session_id DESC");
        return sql.toString();
    }
}

