# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, Callable, Dict, Generic, Optional, TypeVar
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._cdn_management_client_operations import build_check_endpoint_name_availability_request, build_check_name_availability_request, build_check_name_availability_with_subscription_request, build_validate_probe_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class CdnManagementClientOperationsMixin:

    @distributed_trace_async
    async def check_endpoint_name_availability(
        self,
        resource_group_name: str,
        check_endpoint_name_availability_input: "_models.CheckEndpointNameAvailabilityInput",
        **kwargs: Any
    ) -> "_models.CheckEndpointNameAvailabilityOutput":
        """Check the availability of a resource name. This is needed for resources where name is globally
        unique, such as a afdx endpoint.

        :param resource_group_name: Name of the Resource group within the Azure subscription.
        :type resource_group_name: str
        :param check_endpoint_name_availability_input: Input to check.
        :type check_endpoint_name_availability_input:
         ~azure.mgmt.cdn.models.CheckEndpointNameAvailabilityInput
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckEndpointNameAvailabilityOutput, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.CheckEndpointNameAvailabilityOutput
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CheckEndpointNameAvailabilityOutput"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(check_endpoint_name_availability_input, 'CheckEndpointNameAvailabilityInput')

        request = build_check_endpoint_name_availability_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            content_type=content_type,
            json=_json,
            template_url=self.check_endpoint_name_availability.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AfdErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('CheckEndpointNameAvailabilityOutput', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_endpoint_name_availability.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/checkEndpointNameAvailability'}  # type: ignore


    @distributed_trace_async
    async def check_name_availability(
        self,
        check_name_availability_input: "_models.CheckNameAvailabilityInput",
        **kwargs: Any
    ) -> "_models.CheckNameAvailabilityOutput":
        """Check the availability of a resource name. This is needed for resources where name is globally
        unique, such as a CDN endpoint.

        :param check_name_availability_input: Input to check.
        :type check_name_availability_input: ~azure.mgmt.cdn.models.CheckNameAvailabilityInput
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckNameAvailabilityOutput, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.CheckNameAvailabilityOutput
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CheckNameAvailabilityOutput"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(check_name_availability_input, 'CheckNameAvailabilityInput')

        request = build_check_name_availability_request(
            content_type=content_type,
            json=_json,
            template_url=self.check_name_availability.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('CheckNameAvailabilityOutput', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_name_availability.metadata = {'url': '/providers/Microsoft.Cdn/checkNameAvailability'}  # type: ignore


    @distributed_trace_async
    async def check_name_availability_with_subscription(
        self,
        check_name_availability_input: "_models.CheckNameAvailabilityInput",
        **kwargs: Any
    ) -> "_models.CheckNameAvailabilityOutput":
        """Check the availability of a resource name. This is needed for resources where name is globally
        unique, such as a CDN endpoint.

        :param check_name_availability_input: Input to check.
        :type check_name_availability_input: ~azure.mgmt.cdn.models.CheckNameAvailabilityInput
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckNameAvailabilityOutput, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.CheckNameAvailabilityOutput
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CheckNameAvailabilityOutput"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(check_name_availability_input, 'CheckNameAvailabilityInput')

        request = build_check_name_availability_with_subscription_request(
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.check_name_availability_with_subscription.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('CheckNameAvailabilityOutput', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_name_availability_with_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkNameAvailability'}  # type: ignore


    @distributed_trace_async
    async def validate_probe(
        self,
        validate_probe_input: "_models.ValidateProbeInput",
        **kwargs: Any
    ) -> "_models.ValidateProbeOutput":
        """Check if the probe path is a valid path and the file can be accessed. Probe path is the path to
        a file hosted on the origin server to help accelerate the delivery of dynamic content via the
        CDN endpoint. This path is relative to the origin path specified in the endpoint configuration.

        :param validate_probe_input: Input to check.
        :type validate_probe_input: ~azure.mgmt.cdn.models.ValidateProbeInput
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ValidateProbeOutput, or the result of cls(response)
        :rtype: ~azure.mgmt.cdn.models.ValidateProbeOutput
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ValidateProbeOutput"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(validate_probe_input, 'ValidateProbeInput')

        request = build_validate_probe_request(
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.validate_probe.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ValidateProbeOutput', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_probe.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateProbe'}  # type: ignore

