# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AccessKeys(_serialization.Model):
    """Namespace/EventHub Connection String.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_connection_string: Primary connection string of the created namespace
     AuthorizationRule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the created namespace
     AuthorizationRule.
    :vartype secondary_connection_string: str
    :ivar alias_primary_connection_string: Primary connection string of the alias if GEO DR is
     enabled.
    :vartype alias_primary_connection_string: str
    :ivar alias_secondary_connection_string: Secondary  connection string of the alias if GEO DR is
     enabled.
    :vartype alias_secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the AuthorizationRule.
    :vartype key_name: str
    """

    _validation = {
        "primary_connection_string": {"readonly": True},
        "secondary_connection_string": {"readonly": True},
        "alias_primary_connection_string": {"readonly": True},
        "alias_secondary_connection_string": {"readonly": True},
        "primary_key": {"readonly": True},
        "secondary_key": {"readonly": True},
        "key_name": {"readonly": True},
    }

    _attribute_map = {
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
        "alias_primary_connection_string": {"key": "aliasPrimaryConnectionString", "type": "str"},
        "alias_secondary_connection_string": {"key": "aliasSecondaryConnectionString", "type": "str"},
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_connection_string: Optional[str] = None
        self.secondary_connection_string: Optional[str] = None
        self.alias_primary_connection_string: Optional[str] = None
        self.alias_secondary_connection_string: Optional[str] = None
        self.primary_key: Optional[str] = None
        self.secondary_key: Optional[str] = None
        self.key_name: Optional[str] = None


class ProxyResource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location: Optional[str] = None


class ApplicationGroup(ProxyResource):
    """The Application Group object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar is_enabled: Determines if Application Group is allowed to create connection with
     namespace or not. Once the isEnabled is set to false, all the existing connections of
     application group gets dropped and no new connections will be allowed.
    :vartype is_enabled: bool
    :ivar client_app_group_identifier: The Unique identifier for application group.Supports
     SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid).
    :vartype client_app_group_identifier: str
    :ivar policies: List of group policies that define the behavior of application group. The
     policies can support resource governance scenarios such as limiting ingress or egress traffic.
    :vartype policies: list[~azure.mgmt.eventhub.models.ApplicationGroupPolicy]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "client_app_group_identifier": {"key": "properties.clientAppGroupIdentifier", "type": "str"},
        "policies": {"key": "properties.policies", "type": "[ApplicationGroupPolicy]"},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        client_app_group_identifier: Optional[str] = None,
        policies: Optional[List["_models.ApplicationGroupPolicy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Determines if Application Group is allowed to create connection with
         namespace or not. Once the isEnabled is set to false, all the existing connections of
         application group gets dropped and no new connections will be allowed.
        :paramtype is_enabled: bool
        :keyword client_app_group_identifier: The Unique identifier for application group.Supports
         SAS(SASKeyName=KeyName) or AAD(AADAppID=Guid).
        :paramtype client_app_group_identifier: str
        :keyword policies: List of group policies that define the behavior of application group. The
         policies can support resource governance scenarios such as limiting ingress or egress traffic.
        :paramtype policies: list[~azure.mgmt.eventhub.models.ApplicationGroupPolicy]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.is_enabled = is_enabled
        self.client_app_group_identifier = client_app_group_identifier
        self.policies = policies


class ApplicationGroupListResult(_serialization.Model):
    """The response from the List Application Groups operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Result of the List Application Groups operation.
    :vartype value: list[~azure.mgmt.eventhub.models.ApplicationGroup]
    :ivar next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of Authorization Rules.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ApplicationGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Result of the List Application Groups operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.ApplicationGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ApplicationGroupPolicy(_serialization.Model):
    """Properties of the Application Group policy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ThrottlingPolicy

    All required parameters must be populated in order to send to server.

    :ivar name: The Name of this policy. Required.
    :vartype name: str
    :ivar type: Application Group Policy types. Required. "ThrottlingPolicy"
    :vartype type: str or ~azure.mgmt.eventhub.models.ApplicationGroupPolicyType
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"ThrottlingPolicy": "ThrottlingPolicy"}}

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The Name of this policy. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type: Optional[str] = None


class ArmDisasterRecovery(ProxyResource):
    """Single item in List or Get Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar provisioning_state: Provisioning state of the Alias(Disaster Recovery configuration) -
     possible values 'Accepted' or 'Succeeded' or 'Failed'. Known values are: "Accepted",
     "Succeeded", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventhub.models.ProvisioningStateDR
    :ivar partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is part
     of GEO DR pairing.
    :vartype partner_namespace: str
    :ivar alternate_name: Alternate name specified when alias and namespace names are same.
    :vartype alternate_name: str
    :ivar role: role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating'
     or 'Secondary'. Known values are: "Primary", "PrimaryNotReplicating", and "Secondary".
    :vartype role: str or ~azure.mgmt.eventhub.models.RoleDisasterRecovery
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "role": {"readonly": True},
        "pending_replication_operations_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "partner_namespace": {"key": "properties.partnerNamespace", "type": "str"},
        "alternate_name": {"key": "properties.alternateName", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
        "pending_replication_operations_count": {"key": "properties.pendingReplicationOperationsCount", "type": "int"},
    }

    def __init__(
        self, *, partner_namespace: Optional[str] = None, alternate_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is
         part of GEO DR pairing.
        :paramtype partner_namespace: str
        :keyword alternate_name: Alternate name specified when alias and namespace names are same.
        :paramtype alternate_name: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningStateDR"]] = None
        self.partner_namespace = partner_namespace
        self.alternate_name = alternate_name
        self.role: Optional[Union[str, "_models.RoleDisasterRecovery"]] = None
        self.pending_replication_operations_count: Optional[int] = None


class ArmDisasterRecoveryListResult(_serialization.Model):
    """The result of the List Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Alias(Disaster Recovery configurations).
    :vartype value: list[~azure.mgmt.eventhub.models.ArmDisasterRecovery]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Alias(Disaster Recovery configuration).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ArmDisasterRecovery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ArmDisasterRecovery"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Alias(Disaster Recovery configurations).
        :paramtype value: list[~azure.mgmt.eventhub.models.ArmDisasterRecovery]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AuthorizationRule(ProxyResource):
    """Single item in a List or Get AuthorizationRule operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar rights: The rights associated with the rule.
    :vartype rights: list[str or ~azure.mgmt.eventhub.models.AccessRights]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "rights": {"key": "properties.rights", "type": "[str]"},
    }

    def __init__(self, *, rights: Optional[List[Union[str, "_models.AccessRights"]]] = None, **kwargs: Any) -> None:
        """
        :keyword rights: The rights associated with the rule.
        :paramtype rights: list[str or ~azure.mgmt.eventhub.models.AccessRights]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.rights = rights


class AuthorizationRuleListResult(_serialization.Model):
    """The response from the List namespace operation.

    :ivar value: Result of the List Authorization Rules operation.
    :vartype value: list[~azure.mgmt.eventhub.models.AuthorizationRule]
    :ivar next_link: Link to the next set of results. Not empty if Value contains an incomplete
     list of Authorization Rules.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AuthorizationRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AuthorizationRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Authorization Rules operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.AuthorizationRule]
        :keyword next_link: Link to the next set of results. Not empty if Value contains an incomplete
         list of Authorization Rules.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailableCluster(_serialization.Model):
    """Pre-provisioned and readily available Event Hubs Cluster count per region.

    :ivar location: Location fo the Available Cluster.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location fo the Available Cluster.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class AvailableClustersList(_serialization.Model):
    """The response of the List Available Clusters operation.

    :ivar value: The count of readily available and pre-provisioned Event Hubs Clusters per region.
    :vartype value: list[~azure.mgmt.eventhub.models.AvailableCluster]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableCluster]"},
    }

    def __init__(self, *, value: Optional[List["_models.AvailableCluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The count of readily available and pre-provisioned Event Hubs Clusters per
         region.
        :paramtype value: list[~azure.mgmt.eventhub.models.AvailableCluster]
        """
        super().__init__(**kwargs)
        self.value = value


class CaptureDescription(_serialization.Model):
    """Properties to configure capture description for eventhub.

    :ivar enabled: A value that indicates whether capture description is enabled.
    :vartype enabled: bool
    :ivar encoding: Enumerates the possible values for the encoding format of capture description.
     Note: 'AvroDeflate' will be deprecated in New API Version. Known values are: "Avro" and
     "AvroDeflate".
    :vartype encoding: str or ~azure.mgmt.eventhub.models.EncodingCaptureDescription
    :ivar interval_in_seconds: The time window allows you to set the frequency with which the
     capture to Azure Blobs will happen, value should between 60 to 900 seconds.
    :vartype interval_in_seconds: int
    :ivar size_limit_in_bytes: The size window defines the amount of data built up in your Event
     Hub before an capture operation, value should be between 10485760 to 524288000 bytes.
    :vartype size_limit_in_bytes: int
    :ivar destination: Properties of Destination where capture will be stored. (Storage Account,
     Blob Names).
    :vartype destination: ~azure.mgmt.eventhub.models.Destination
    :ivar skip_empty_archives: A value that indicates whether to Skip Empty Archives.
    :vartype skip_empty_archives: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "encoding": {"key": "encoding", "type": "str"},
        "interval_in_seconds": {"key": "intervalInSeconds", "type": "int"},
        "size_limit_in_bytes": {"key": "sizeLimitInBytes", "type": "int"},
        "destination": {"key": "destination", "type": "Destination"},
        "skip_empty_archives": {"key": "skipEmptyArchives", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        encoding: Optional[Union[str, "_models.EncodingCaptureDescription"]] = None,
        interval_in_seconds: Optional[int] = None,
        size_limit_in_bytes: Optional[int] = None,
        destination: Optional["_models.Destination"] = None,
        skip_empty_archives: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: A value that indicates whether capture description is enabled.
        :paramtype enabled: bool
        :keyword encoding: Enumerates the possible values for the encoding format of capture
         description. Note: 'AvroDeflate' will be deprecated in New API Version. Known values are:
         "Avro" and "AvroDeflate".
        :paramtype encoding: str or ~azure.mgmt.eventhub.models.EncodingCaptureDescription
        :keyword interval_in_seconds: The time window allows you to set the frequency with which the
         capture to Azure Blobs will happen, value should between 60 to 900 seconds.
        :paramtype interval_in_seconds: int
        :keyword size_limit_in_bytes: The size window defines the amount of data built up in your Event
         Hub before an capture operation, value should be between 10485760 to 524288000 bytes.
        :paramtype size_limit_in_bytes: int
        :keyword destination: Properties of Destination where capture will be stored. (Storage Account,
         Blob Names).
        :paramtype destination: ~azure.mgmt.eventhub.models.Destination
        :keyword skip_empty_archives: A value that indicates whether to Skip Empty Archives.
        :paramtype skip_empty_archives: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.encoding = encoding
        self.interval_in_seconds = interval_in_seconds
        self.size_limit_in_bytes = size_limit_in_bytes
        self.destination = destination
        self.skip_empty_archives = skip_empty_archives


class CheckNameAvailabilityParameter(_serialization.Model):
    """Parameter supplied to check Namespace name availability operation.

    All required parameters must be populated in order to send to server.

    :ivar name: Name to check the namespace name availability. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name to check the namespace name availability. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(_serialization.Model):
    """The Result of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: The detailed info regarding the reason associated with the Namespace.
    :vartype message: str
    :ivar name_available: Value indicating Namespace is availability, true if the Namespace is
     available; otherwise, false.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability of a Namespace. Known values are: "None",
     "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown", and
     "TooManyNamespaceInCurrentSubscription".
    :vartype reason: str or ~azure.mgmt.eventhub.models.UnavailableReason
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.UnavailableReason"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Value indicating Namespace is availability, true if the Namespace is
         available; otherwise, false.
        :paramtype name_available: bool
        :keyword reason: The reason for unavailability of a Namespace. Known values are: "None",
         "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown", and
         "TooManyNamespaceInCurrentSubscription".
        :paramtype reason: str or ~azure.mgmt.eventhub.models.UnavailableReason
        """
        super().__init__(**kwargs)
        self.message: Optional[str] = None
        self.name_available = name_available
        self.reason = reason


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class TrackedResource(Resource):
    """Definition of resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class Cluster(TrackedResource):
    """Single Event Hubs Cluster resource in List or Get operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Properties of the cluster SKU.
    :vartype sku: ~azure.mgmt.eventhub.models.ClusterSku
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar created_at: The UTC time when the Event Hubs Cluster was created.
    :vartype created_at: str
    :ivar updated_at: The UTC time when the Event Hubs Cluster was last updated.
    :vartype updated_at: str
    :ivar metric_id: The metric ID of the cluster resource. Provided by the service and not
     modifiable by the user.
    :vartype metric_id: str
    :ivar status: Status of the Cluster resource.
    :vartype status: str
    :ivar supports_scaling: A value that indicates whether Scaling is Supported.
    :vartype supports_scaling: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "metric_id": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ClusterSku"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_at": {"key": "properties.createdAt", "type": "str"},
        "updated_at": {"key": "properties.updatedAt", "type": "str"},
        "metric_id": {"key": "properties.metricId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "supports_scaling": {"key": "properties.supportsScaling", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ClusterSku"] = None,
        supports_scaling: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Properties of the cluster SKU.
        :paramtype sku: ~azure.mgmt.eventhub.models.ClusterSku
        :keyword supports_scaling: A value that indicates whether Scaling is Supported.
        :paramtype supports_scaling: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.system_data: Optional["_models.SystemData"] = None
        self.created_at: Optional[str] = None
        self.updated_at: Optional[str] = None
        self.metric_id: Optional[str] = None
        self.status: Optional[str] = None
        self.supports_scaling = supports_scaling


class ClusterListResult(_serialization.Model):
    """The response of the List Event Hubs Clusters operation.

    :ivar value: The Event Hubs Clusters present in the List Event Hubs operation results.
    :vartype value: list[~azure.mgmt.eventhub.models.Cluster]
    :ivar next_link: Link to the next set of results. Empty unless the value parameter contains an
     incomplete list of Event Hubs Clusters.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Cluster"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The Event Hubs Clusters present in the List Event Hubs operation results.
        :paramtype value: list[~azure.mgmt.eventhub.models.Cluster]
        :keyword next_link: Link to the next set of results. Empty unless the value parameter contains
         an incomplete list of Event Hubs Clusters.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterQuotaConfigurationProperties(_serialization.Model):
    """Contains all settings for the cluster.

    :ivar settings: All possible Cluster settings - a collection of key/value paired settings which
     apply to quotas and configurations imposed on the cluster.
    :vartype settings: dict[str, str]
    """

    _attribute_map = {
        "settings": {"key": "settings", "type": "{str}"},
    }

    def __init__(self, *, settings: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword settings: All possible Cluster settings - a collection of key/value paired settings
         which apply to quotas and configurations imposed on the cluster.
        :paramtype settings: dict[str, str]
        """
        super().__init__(**kwargs)
        self.settings = settings


class ClusterSku(_serialization.Model):
    """SKU parameters particular to a cluster instance.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of this SKU. Required. "Dedicated"
    :vartype name: str or ~azure.mgmt.eventhub.models.ClusterSkuName
    :ivar capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Union[str, "_models.ClusterSkuName"], capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of this SKU. Required. "Dedicated"
        :paramtype name: str or ~azure.mgmt.eventhub.models.ClusterSkuName
        :keyword capacity: The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.capacity = capacity


class ConnectionState(_serialization.Model):
    """ConnectionState information.

    :ivar status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
     and "Disconnected".
    :vartype status: str or ~azure.mgmt.eventhub.models.PrivateLinkConnectionStatus
    :ivar description: Description of the connection state.
    :vartype description: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateLinkConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the connection. Known values are: "Pending", "Approved", "Rejected",
         and "Disconnected".
        :paramtype status: str or ~azure.mgmt.eventhub.models.PrivateLinkConnectionStatus
        :keyword description: Description of the connection state.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description


class ConsumerGroup(ProxyResource):
    """Single item in List or Get Consumer group operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar user_metadata: User Metadata is a placeholder to store user-defined string data with
     maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and
     their contact information also user-defined configuration settings can be stored.
    :vartype user_metadata: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "user_metadata": {"key": "properties.userMetadata", "type": "str"},
    }

    def __init__(self, *, user_metadata: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_metadata: User Metadata is a placeholder to store user-defined string data with
         maximum length 1024. e.g. it can be used to store descriptive data, such as list of teams and
         their contact information also user-defined configuration settings can be stored.
        :paramtype user_metadata: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.user_metadata = user_metadata


class ConsumerGroupListResult(_serialization.Model):
    """The result to the List Consumer Group operation.

    :ivar value: Result of the List Consumer Group operation.
    :vartype value: list[~azure.mgmt.eventhub.models.ConsumerGroup]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Consumer Group.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConsumerGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ConsumerGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Consumer Group operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.ConsumerGroup]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Consumer Group.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Destination(_serialization.Model):
    """Capture storage details for capture description.

    :ivar name: Name for capture destination.
    :vartype name: str
    :ivar storage_account_resource_id: Resource id of the storage account to be used to create the
     blobs.
    :vartype storage_account_resource_id: str
    :ivar blob_container: Blob container Name.
    :vartype blob_container: str
    :ivar archive_name_format: Blob naming convention for archive, e.g.
     {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all
     the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order.
    :vartype archive_name_format: str
    :ivar data_lake_subscription_id: Subscription Id of Azure Data Lake Store.
    :vartype data_lake_subscription_id: str
    :ivar data_lake_account_name: The Azure Data Lake Store name for the captured events.
    :vartype data_lake_account_name: str
    :ivar data_lake_folder_path: The destination folder path for the captured events.
    :vartype data_lake_folder_path: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "storage_account_resource_id": {"key": "properties.storageAccountResourceId", "type": "str"},
        "blob_container": {"key": "properties.blobContainer", "type": "str"},
        "archive_name_format": {"key": "properties.archiveNameFormat", "type": "str"},
        "data_lake_subscription_id": {"key": "properties.dataLakeSubscriptionId", "type": "str"},
        "data_lake_account_name": {"key": "properties.dataLakeAccountName", "type": "str"},
        "data_lake_folder_path": {"key": "properties.dataLakeFolderPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        blob_container: Optional[str] = None,
        archive_name_format: Optional[str] = None,
        data_lake_subscription_id: Optional[str] = None,
        data_lake_account_name: Optional[str] = None,
        data_lake_folder_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name for capture destination.
        :paramtype name: str
        :keyword storage_account_resource_id: Resource id of the storage account to be used to create
         the blobs.
        :paramtype storage_account_resource_id: str
        :keyword blob_container: Blob container Name.
        :paramtype blob_container: str
        :keyword archive_name_format: Blob naming convention for archive, e.g.
         {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all
         the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order.
        :paramtype archive_name_format: str
        :keyword data_lake_subscription_id: Subscription Id of Azure Data Lake Store.
        :paramtype data_lake_subscription_id: str
        :keyword data_lake_account_name: The Azure Data Lake Store name for the captured events.
        :paramtype data_lake_account_name: str
        :keyword data_lake_folder_path: The destination folder path for the captured events.
        :paramtype data_lake_folder_path: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.storage_account_resource_id = storage_account_resource_id
        self.blob_container = blob_container
        self.archive_name_format = archive_name_format
        self.data_lake_subscription_id = data_lake_subscription_id
        self.data_lake_account_name = data_lake_account_name
        self.data_lake_folder_path = data_lake_folder_path


class EHNamespace(TrackedResource):
    """Single Namespace item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Properties of sku resource.
    :vartype sku: ~azure.mgmt.eventhub.models.Sku
    :ivar identity: Properties of BYOK Identity description.
    :vartype identity: ~azure.mgmt.eventhub.models.Identity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
     Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.eventhub.models.TlsVersion
    :ivar provisioning_state: Provisioning state of the Namespace.
    :vartype provisioning_state: str
    :ivar status: Status of the Namespace.
    :vartype status: str
    :ivar created_at: The time the Namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the Namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar cluster_arm_id: Cluster ARM ID of the Namespace.
    :vartype cluster_arm_id: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :ivar is_auto_inflate_enabled: Value that indicates whether AutoInflate is enabled for eventhub
     namespace.
    :vartype is_auto_inflate_enabled: bool
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.eventhub.models.PublicNetworkAccess
    :ivar maximum_throughput_units: Upper limit of throughput units when AutoInflate is enabled,
     value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true).
    :vartype maximum_throughput_units: int
    :ivar kafka_enabled: Value that indicates whether Kafka is enabled for eventhub namespace.
    :vartype kafka_enabled: bool
    :ivar zone_redundant: Enabling this property creates a Standard Event Hubs Namespace in regions
     supported availability zones.
    :vartype zone_redundant: bool
    :ivar encryption: Properties of BYOK Encryption description.
    :vartype encryption: ~azure.mgmt.eventhub.models.Encryption
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.eventhub.models.PrivateEndpointConnection]
    :ivar disable_local_auth: This property disables SAS authentication for the Event Hubs
     namespace.
    :vartype disable_local_auth: bool
    :ivar alternate_name: Alternate name specified when alias and namespace names are same.
    :vartype alternate_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "service_bus_endpoint": {"readonly": True},
        "metric_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "service_bus_endpoint": {"key": "properties.serviceBusEndpoint", "type": "str"},
        "cluster_arm_id": {"key": "properties.clusterArmId", "type": "str"},
        "metric_id": {"key": "properties.metricId", "type": "str"},
        "is_auto_inflate_enabled": {"key": "properties.isAutoInflateEnabled", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "maximum_throughput_units": {"key": "properties.maximumThroughputUnits", "type": "int"},
        "kafka_enabled": {"key": "properties.kafkaEnabled", "type": "bool"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "alternate_name": {"key": "properties.alternateName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        cluster_arm_id: Optional[str] = None,
        is_auto_inflate_enabled: Optional[bool] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        maximum_throughput_units: Optional[int] = None,
        kafka_enabled: Optional[bool] = None,
        zone_redundant: Optional[bool] = None,
        encryption: Optional["_models.Encryption"] = None,
        private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None,
        disable_local_auth: Optional[bool] = None,
        alternate_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Properties of sku resource.
        :paramtype sku: ~azure.mgmt.eventhub.models.Sku
        :keyword identity: Properties of BYOK Identity description.
        :paramtype identity: ~azure.mgmt.eventhub.models.Identity
        :keyword minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
         Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.eventhub.models.TlsVersion
        :keyword cluster_arm_id: Cluster ARM ID of the Namespace.
        :paramtype cluster_arm_id: str
        :keyword is_auto_inflate_enabled: Value that indicates whether AutoInflate is enabled for
         eventhub namespace.
        :paramtype is_auto_inflate_enabled: bool
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.eventhub.models.PublicNetworkAccess
        :keyword maximum_throughput_units: Upper limit of throughput units when AutoInflate is enabled,
         value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true).
        :paramtype maximum_throughput_units: int
        :keyword kafka_enabled: Value that indicates whether Kafka is enabled for eventhub namespace.
        :paramtype kafka_enabled: bool
        :keyword zone_redundant: Enabling this property creates a Standard Event Hubs Namespace in
         regions supported availability zones.
        :paramtype zone_redundant: bool
        :keyword encryption: Properties of BYOK Encryption description.
        :paramtype encryption: ~azure.mgmt.eventhub.models.Encryption
        :keyword private_endpoint_connections: List of private endpoint connections.
        :paramtype private_endpoint_connections:
         list[~azure.mgmt.eventhub.models.PrivateEndpointConnection]
        :keyword disable_local_auth: This property disables SAS authentication for the Event Hubs
         namespace.
        :paramtype disable_local_auth: bool
        :keyword alternate_name: Alternate name specified when alias and namespace names are same.
        :paramtype alternate_name: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.system_data: Optional["_models.SystemData"] = None
        self.minimum_tls_version = minimum_tls_version
        self.provisioning_state: Optional[str] = None
        self.status: Optional[str] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.service_bus_endpoint: Optional[str] = None
        self.cluster_arm_id = cluster_arm_id
        self.metric_id: Optional[str] = None
        self.is_auto_inflate_enabled = is_auto_inflate_enabled
        self.public_network_access = public_network_access
        self.maximum_throughput_units = maximum_throughput_units
        self.kafka_enabled = kafka_enabled
        self.zone_redundant = zone_redundant
        self.encryption = encryption
        self.private_endpoint_connections = private_endpoint_connections
        self.disable_local_auth = disable_local_auth
        self.alternate_name = alternate_name


class EHNamespaceIdContainer(_serialization.Model):
    """The full ARM ID of an Event Hubs Namespace.

    :ivar id: id parameter.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: id parameter.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class EHNamespaceIdListResult(_serialization.Model):
    """The response of the List Namespace IDs operation.

    :ivar value: Result of the List Namespace IDs operation.
    :vartype value: list[~azure.mgmt.eventhub.models.EHNamespaceIdContainer]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EHNamespaceIdContainer]"},
    }

    def __init__(self, *, value: Optional[List["_models.EHNamespaceIdContainer"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Result of the List Namespace IDs operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.EHNamespaceIdContainer]
        """
        super().__init__(**kwargs)
        self.value = value


class EHNamespaceListResult(_serialization.Model):
    """The response of the List Namespace operation.

    :ivar value: Result of the List Namespace operation.
    :vartype value: list[~azure.mgmt.eventhub.models.EHNamespace]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of namespaces.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EHNamespace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.EHNamespace"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List Namespace operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.EHNamespace]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of namespaces.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Encryption(_serialization.Model):
    """Properties to configure Encryption.

    :ivar key_vault_properties: Properties of KeyVault.
    :vartype key_vault_properties: list[~azure.mgmt.eventhub.models.KeyVaultProperties]
    :ivar key_source: Enumerates the possible value of keySource for Encryption. Default value is
     "Microsoft.KeyVault".
    :vartype key_source: str
    :ivar require_infrastructure_encryption: Enable Infrastructure Encryption (Double Encryption).
    :vartype require_infrastructure_encryption: bool
    """

    _attribute_map = {
        "key_vault_properties": {"key": "keyVaultProperties", "type": "[KeyVaultProperties]"},
        "key_source": {"key": "keySource", "type": "str"},
        "require_infrastructure_encryption": {"key": "requireInfrastructureEncryption", "type": "bool"},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional[List["_models.KeyVaultProperties"]] = None,
        key_source: Literal["Microsoft.KeyVault"] = "Microsoft.KeyVault",
        require_infrastructure_encryption: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_properties: Properties of KeyVault.
        :paramtype key_vault_properties: list[~azure.mgmt.eventhub.models.KeyVaultProperties]
        :keyword key_source: Enumerates the possible value of keySource for Encryption. Default value
         is "Microsoft.KeyVault".
        :paramtype key_source: str
        :keyword require_infrastructure_encryption: Enable Infrastructure Encryption (Double
         Encryption).
        :paramtype require_infrastructure_encryption: bool
        """
        super().__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.key_source = key_source
        self.require_infrastructure_encryption = require_infrastructure_encryption


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.eventhub.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.eventhub.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Error response indicates Event Hub service is not able to process the incoming request. The
    reason is provided in the error message.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.eventhub.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.eventhub.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Eventhub(ProxyResource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar message_retention_in_days: Number of days to retain the events for this Event Hub, value
     should be 1 to 7 days.
    :vartype message_retention_in_days: int
    :ivar partition_count: Number of partitions created for the Event Hub, allowed values are from
     1 to 32 partitions.
    :vartype partition_count: int
    :ivar status: Enumerates the possible values for the status of the Event Hub. Known values are:
     "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating", "Deleting",
     "Renaming", and "Unknown".
    :vartype status: str or ~azure.mgmt.eventhub.models.EntityStatus
    :ivar capture_description: Properties of capture description.
    :vartype capture_description: ~azure.mgmt.eventhub.models.CaptureDescription
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "partition_ids": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
        "message_retention_in_days": {"minimum": 1},
        "partition_count": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "partition_ids": {"key": "properties.partitionIds", "type": "[str]"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "updated_at": {"key": "properties.updatedAt", "type": "iso-8601"},
        "message_retention_in_days": {"key": "properties.messageRetentionInDays", "type": "int"},
        "partition_count": {"key": "properties.partitionCount", "type": "int"},
        "status": {"key": "properties.status", "type": "str"},
        "capture_description": {"key": "properties.captureDescription", "type": "CaptureDescription"},
    }

    def __init__(
        self,
        *,
        message_retention_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        status: Optional[Union[str, "_models.EntityStatus"]] = None,
        capture_description: Optional["_models.CaptureDescription"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message_retention_in_days: Number of days to retain the events for this Event Hub,
         value should be 1 to 7 days.
        :paramtype message_retention_in_days: int
        :keyword partition_count: Number of partitions created for the Event Hub, allowed values are
         from 1 to 32 partitions.
        :paramtype partition_count: int
        :keyword status: Enumerates the possible values for the status of the Event Hub. Known values
         are: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
         "Deleting", "Renaming", and "Unknown".
        :paramtype status: str or ~azure.mgmt.eventhub.models.EntityStatus
        :keyword capture_description: Properties of capture description.
        :paramtype capture_description: ~azure.mgmt.eventhub.models.CaptureDescription
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.partition_ids: Optional[List[str]] = None
        self.created_at: Optional[datetime.datetime] = None
        self.updated_at: Optional[datetime.datetime] = None
        self.message_retention_in_days = message_retention_in_days
        self.partition_count = partition_count
        self.status = status
        self.capture_description = capture_description


class EventHubListResult(_serialization.Model):
    """The result of the List EventHubs operation.

    :ivar value: Result of the List EventHubs operation.
    :vartype value: list[~azure.mgmt.eventhub.models.Eventhub]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of EventHubs.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Eventhub]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Eventhub"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List EventHubs operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.Eventhub]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of EventHubs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Identity(_serialization.Model):
    """Properties to configure Identity for Bring your Own Keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: ObjectId from the KeyVault.
    :vartype principal_id: str
    :ivar tenant_id: TenantId from the KeyVault.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.eventhub.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: Properties for User Assigned Identities.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.eventhub.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.eventhub.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: Properties for User Assigned Identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.eventhub.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class KeyVaultProperties(_serialization.Model):
    """Properties to configure keyVault Properties.

    :ivar key_name: Name of the Key from KeyVault.
    :vartype key_name: str
    :ivar key_vault_uri: Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar key_version: Key Version.
    :vartype key_version: str
    :ivar identity:
    :vartype identity: ~azure.mgmt.eventhub.models.UserAssignedIdentityProperties
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
        "identity": {"key": "identity", "type": "UserAssignedIdentityProperties"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        key_version: Optional[str] = None,
        identity: Optional["_models.UserAssignedIdentityProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: Name of the Key from KeyVault.
        :paramtype key_name: str
        :keyword key_vault_uri: Uri of KeyVault.
        :paramtype key_vault_uri: str
        :keyword key_version: Key Version.
        :paramtype key_version: str
        :keyword identity:
        :paramtype identity: ~azure.mgmt.eventhub.models.UserAssignedIdentityProperties
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_vault_uri = key_vault_uri
        self.key_version = key_version
        self.identity = identity


class NetworkRuleSet(ProxyResource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
     Enabled or not.
    :vartype trusted_service_access_enabled: bool
    :ivar default_action: Default Action for Network Rule Set. Known values are: "Allow" and
     "Deny".
    :vartype default_action: str or ~azure.mgmt.eventhub.models.DefaultAction
    :ivar virtual_network_rules: List VirtualNetwork Rules.
    :vartype virtual_network_rules: list[~azure.mgmt.eventhub.models.NWRuleSetVirtualNetworkRules]
    :ivar ip_rules: List of IpRules.
    :vartype ip_rules: list[~azure.mgmt.eventhub.models.NWRuleSetIpRules]
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication
     is controlled by the network security perimeter and profile's access rules. Known values are:
     "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.eventhub.models.PublicNetworkAccessFlag
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "trusted_service_access_enabled": {"key": "properties.trustedServiceAccessEnabled", "type": "bool"},
        "default_action": {"key": "properties.defaultAction", "type": "str"},
        "virtual_network_rules": {"key": "properties.virtualNetworkRules", "type": "[NWRuleSetVirtualNetworkRules]"},
        "ip_rules": {"key": "properties.ipRules", "type": "[NWRuleSetIpRules]"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        trusted_service_access_enabled: Optional[bool] = None,
        default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        virtual_network_rules: Optional[List["_models.NWRuleSetVirtualNetworkRules"]] = None,
        ip_rules: Optional[List["_models.NWRuleSetIpRules"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccessFlag"] = "Enabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword trusted_service_access_enabled: Value that indicates whether Trusted Service Access is
         Enabled or not.
        :paramtype trusted_service_access_enabled: bool
        :keyword default_action: Default Action for Network Rule Set. Known values are: "Allow" and
         "Deny".
        :paramtype default_action: str or ~azure.mgmt.eventhub.models.DefaultAction
        :keyword virtual_network_rules: List VirtualNetwork Rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.eventhub.models.NWRuleSetVirtualNetworkRules]
        :keyword ip_rules: List of IpRules.
        :paramtype ip_rules: list[~azure.mgmt.eventhub.models.NWRuleSetIpRules]
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication
         is controlled by the network security perimeter and profile's access rules. Known values are:
         "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.eventhub.models.PublicNetworkAccessFlag
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.trusted_service_access_enabled = trusted_service_access_enabled
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.public_network_access = public_network_access


class NetworkRuleSetListResult(_serialization.Model):
    """The response of the List NetworkRuleSet operation.

    :ivar value: Result of the List NetworkRuleSet operation.
    :vartype value: list[~azure.mgmt.eventhub.models.NetworkRuleSet]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of NetworkRuleSet.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkRuleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkRuleSet"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List NetworkRuleSet operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.NetworkRuleSet]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of NetworkRuleSet.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkSecurityPerimeter(_serialization.Model):
    """NetworkSecurityPerimeter related information.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar perimeter_guid: Guid of the resource.
    :vartype perimeter_guid: str
    :ivar location: Location of the resource.
    :vartype location: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "perimeter_guid": {"key": "perimeterGuid", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        perimeter_guid: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified identifier of the resource.
        :paramtype id: str
        :keyword perimeter_guid: Guid of the resource.
        :paramtype perimeter_guid: str
        :keyword location: Location of the resource.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.perimeter_guid = perimeter_guid
        self.location = location


class NetworkSecurityPerimeterConfiguration(TrackedResource):
    """Network Security Perimeter related configurations of a given namespace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of NetworkSecurityPerimeter configuration
     propagation. Known values are: "Unknown", "Creating", "Updating", "Accepted",
     "InvalidResponse", "Succeeded", "SucceededWithIssues", "Failed", "Deleting", "Deleted", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventhub.models.NetworkSecurityPerimeterConfigurationProvisioningState
    :ivar provisioning_issues: List of Provisioning Issues if any.
    :vartype provisioning_issues: list[~azure.mgmt.eventhub.models.ProvisioningIssue]
    :ivar network_security_perimeter: NetworkSecurityPerimeter related information.
    :vartype network_security_perimeter: ~azure.mgmt.eventhub.models.NetworkSecurityPerimeter
    :ivar resource_association: Information about resource association.
    :vartype resource_association:
     ~azure.mgmt.eventhub.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation
    :ivar profile: Information about current network profile.
    :vartype profile:
     ~azure.mgmt.eventhub.models.NetworkSecurityPerimeterConfigurationPropertiesProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_security_perimeter": {"readonly": True},
        "resource_association": {"readonly": True},
        "profile": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provisioning_issues": {"key": "properties.provisioningIssues", "type": "[ProvisioningIssue]"},
        "network_security_perimeter": {
            "key": "properties.networkSecurityPerimeter",
            "type": "NetworkSecurityPerimeter",
        },
        "resource_association": {
            "key": "properties.resourceAssociation",
            "type": "NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation",
        },
        "profile": {"key": "properties.profile", "type": "NetworkSecurityPerimeterConfigurationPropertiesProfile"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        provisioning_state: Optional[
            Union[str, "_models.NetworkSecurityPerimeterConfigurationProvisioningState"]
        ] = None,
        provisioning_issues: Optional[List["_models.ProvisioningIssue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword provisioning_state: Provisioning state of NetworkSecurityPerimeter configuration
         propagation. Known values are: "Unknown", "Creating", "Updating", "Accepted",
         "InvalidResponse", "Succeeded", "SucceededWithIssues", "Failed", "Deleting", "Deleted", and
         "Canceled".
        :paramtype provisioning_state: str or
         ~azure.mgmt.eventhub.models.NetworkSecurityPerimeterConfigurationProvisioningState
        :keyword provisioning_issues: List of Provisioning Issues if any.
        :paramtype provisioning_issues: list[~azure.mgmt.eventhub.models.ProvisioningIssue]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = provisioning_state
        self.provisioning_issues = provisioning_issues
        self.network_security_perimeter: Optional["_models.NetworkSecurityPerimeter"] = None
        self.resource_association: Optional[
            "_models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation"
        ] = None
        self.profile: Optional["_models.NetworkSecurityPerimeterConfigurationPropertiesProfile"] = None


class NetworkSecurityPerimeterConfigurationList(_serialization.Model):  # pylint: disable=name-too-long
    """Result of the List NetworkSecurityPerimeterConfiguration operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A collection of NetworkSecurityPerimeterConfigurations.
    :vartype value: list[~azure.mgmt.eventhub.models.NetworkSecurityPerimeterConfiguration]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityPerimeterConfiguration]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.NetworkSecurityPerimeterConfiguration"]] = None


class NetworkSecurityPerimeterConfigurationPropertiesProfile(_serialization.Model):  # pylint: disable=name-too-long
    """Information about current network profile.

    :ivar name: Name of the resource.
    :vartype name: str
    :ivar access_rules_version: Current access rules version.
    :vartype access_rules_version: str
    :ivar access_rules: List of Access Rules.
    :vartype access_rules: list[~azure.mgmt.eventhub.models.NspAccessRule]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_rules_version": {"key": "accessRulesVersion", "type": "str"},
        "access_rules": {"key": "accessRules", "type": "[NspAccessRule]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_rules_version: Optional[str] = None,
        access_rules: Optional[List["_models.NspAccessRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword access_rules_version: Current access rules version.
        :paramtype access_rules_version: str
        :keyword access_rules: List of Access Rules.
        :paramtype access_rules: list[~azure.mgmt.eventhub.models.NspAccessRule]
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_rules_version = access_rules_version
        self.access_rules = access_rules


class NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Information about resource association.

    :ivar name: Name of the resource association.
    :vartype name: str
    :ivar access_mode: Access Mode of the resource association. Known values are:
     "NoAssociationMode", "EnforcedMode", "LearningMode", "AuditMode", and "UnspecifiedMode".
    :vartype access_mode: str or ~azure.mgmt.eventhub.models.ResourceAssociationAccessMode
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_mode": {"key": "accessMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_mode: Optional[Union[str, "_models.ResourceAssociationAccessMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource association.
        :paramtype name: str
        :keyword access_mode: Access Mode of the resource association. Known values are:
         "NoAssociationMode", "EnforcedMode", "LearningMode", "AuditMode", and "UnspecifiedMode".
        :paramtype access_mode: str or ~azure.mgmt.eventhub.models.ResourceAssociationAccessMode
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_mode = access_mode


class NspAccessRule(_serialization.Model):
    """Information of Access Rule in Network Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar properties: Properties of Access Rule.
    :vartype properties: ~azure.mgmt.eventhub.models.NspAccessRuleProperties
    """

    _validation = {
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NspAccessRuleProperties"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified identifier of the resource.
        :paramtype id: str
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties: Optional["_models.NspAccessRuleProperties"] = None


class NspAccessRuleProperties(_serialization.Model):
    """Properties of Access Rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar direction: Direction of Access Rule. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.eventhub.models.NspAccessRuleDirection
    :ivar address_prefixes: Address prefixes in the CIDR format for inbound rules.
    :vartype address_prefixes: list[str]
    :ivar subscriptions: Subscriptions for inbound rules.
    :vartype subscriptions:
     list[~azure.mgmt.eventhub.models.NspAccessRulePropertiesSubscriptionsItem]
    :ivar network_security_perimeters: NetworkSecurityPerimeters for inbound rules.
    :vartype network_security_perimeters:
     list[~azure.mgmt.eventhub.models.NetworkSecurityPerimeter]
    :ivar fully_qualified_domain_names: FQDN for outbound rules.
    :vartype fully_qualified_domain_names: list[str]
    """

    _validation = {
        "network_security_perimeters": {"readonly": True},
        "fully_qualified_domain_names": {"readonly": True},
    }

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
        "subscriptions": {"key": "subscriptions", "type": "[NspAccessRulePropertiesSubscriptionsItem]"},
        "network_security_perimeters": {"key": "networkSecurityPerimeters", "type": "[NetworkSecurityPerimeter]"},
        "fully_qualified_domain_names": {"key": "fullyQualifiedDomainNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        direction: Optional[Union[str, "_models.NspAccessRuleDirection"]] = None,
        address_prefixes: Optional[List[str]] = None,
        subscriptions: Optional[List["_models.NspAccessRulePropertiesSubscriptionsItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword direction: Direction of Access Rule. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.eventhub.models.NspAccessRuleDirection
        :keyword address_prefixes: Address prefixes in the CIDR format for inbound rules.
        :paramtype address_prefixes: list[str]
        :keyword subscriptions: Subscriptions for inbound rules.
        :paramtype subscriptions:
         list[~azure.mgmt.eventhub.models.NspAccessRulePropertiesSubscriptionsItem]
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.address_prefixes = address_prefixes
        self.subscriptions = subscriptions
        self.network_security_perimeters: Optional[List["_models.NetworkSecurityPerimeter"]] = None
        self.fully_qualified_domain_names: Optional[List[str]] = None


class NspAccessRulePropertiesSubscriptionsItem(_serialization.Model):
    """Subscription for inbound rule.

    :ivar id: Fully qualified identifier of subscription.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Fully qualified identifier of subscription.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class NWRuleSetIpRules(_serialization.Model):
    """The response from the List namespace operation.

    :ivar ip_mask: IP Mask.
    :vartype ip_mask: str
    :ivar action: The IP Filter Action. "Allow"
    :vartype action: str or ~azure.mgmt.eventhub.models.NetworkRuleIPAction
    """

    _attribute_map = {
        "ip_mask": {"key": "ipMask", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "_models.NetworkRuleIPAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_mask: IP Mask.
        :paramtype ip_mask: str
        :keyword action: The IP Filter Action. "Allow"
        :paramtype action: str or ~azure.mgmt.eventhub.models.NetworkRuleIPAction
        """
        super().__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class NWRuleSetVirtualNetworkRules(_serialization.Model):
    """The response from the List namespace operation.

    :ivar subnet: Subnet properties.
    :vartype subnet: ~azure.mgmt.eventhub.models.Subnet
    :ivar ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing Vnet
     Service Endpoint.
    :vartype ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "Subnet"},
        "ignore_missing_vnet_service_endpoint": {"key": "ignoreMissingVnetServiceEndpoint", "type": "bool"},
    }

    def __init__(
        self,
        *,
        subnet: Optional["_models.Subnet"] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet: Subnet properties.
        :paramtype subnet: ~azure.mgmt.eventhub.models.Subnet
        :keyword ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing
         Vnet Service Endpoint.
        :paramtype ignore_missing_vnet_service_endpoint: bool
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint


class Operation(_serialization.Model):
    """A Event Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.eventhub.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: JSON
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.eventhub.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """Operation display payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """Result of the request to list Event Hub operations. It contains a list of operations and a URL
    link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Event Hub operations supported by the Microsoft.EventHub resource
     provider.
    :vartype value: list[~azure.mgmt.eventhub.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class PrivateEndpoint(_serialization.Model):
    """PrivateEndpoint information.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM identifier for Private Endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(ProxyResource):
    """Properties of the PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar private_endpoint: The Private Endpoint resource for this Connection.
    :vartype private_endpoint: ~azure.mgmt.eventhub.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Details about the state of the connection.
    :vartype private_link_service_connection_state: ~azure.mgmt.eventhub.models.ConnectionState
    :ivar provisioning_state: Provisioning state of the Private Endpoint Connection. Known values
     are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventhub.models.EndPointProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "ConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "_models.EndPointProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The Private Endpoint resource for this Connection.
        :paramtype private_endpoint: ~azure.mgmt.eventhub.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Details about the state of the connection.
        :paramtype private_link_service_connection_state: ~azure.mgmt.eventhub.models.ConnectionState
        :keyword provisioning_state: Provisioning state of the Private Endpoint Connection. Known
         values are: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", and "Failed".
        :paramtype provisioning_state: str or ~azure.mgmt.eventhub.models.EndPointProvisioningState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :ivar value: A collection of private endpoint connection resources.
    :vartype value: list[~azure.mgmt.eventhub.models.PrivateEndpointConnection]
    :ivar next_link: A link for the next page of private endpoint connection resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private endpoint connection resources.
        :paramtype value: list[~azure.mgmt.eventhub.models.PrivateEndpointConnection]
        :keyword next_link: A link for the next page of private endpoint connection resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(_serialization.Model):
    """Information of the private link resource.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified identifier of the resource.
        :paramtype id: str
        :keyword name: Name of the resource.
        :paramtype name: str
        :keyword type: Type of the resource.
        :paramtype type: str
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword required_members: The private link resource required member names.
        :paramtype required_members: list[str]
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(_serialization.Model):
    """Result of the List private link resources operation.

    :ivar value: A collection of private link resources.
    :vartype value: list[~azure.mgmt.eventhub.models.PrivateLinkResource]
    :ivar next_link: A link for the next page of private link resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A collection of private link resources.
        :paramtype value: list[~azure.mgmt.eventhub.models.PrivateLinkResource]
        :keyword next_link: A link for the next page of private link resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProvisioningIssue(_serialization.Model):
    """Describes Provisioning issue for given NetworkSecurityPerimeterConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the issue.
    :vartype name: str
    :ivar properties: Properties of Provisioning Issue.
    :vartype properties: ~azure.mgmt.eventhub.models.ProvisioningIssueProperties
    """

    _validation = {
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ProvisioningIssueProperties"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the issue.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties: Optional["_models.ProvisioningIssueProperties"] = None


class ProvisioningIssueProperties(_serialization.Model):
    """Properties of Provisioning Issue.

    :ivar issue_type: Type of Issue.
    :vartype issue_type: str
    :ivar description: Description of the issue.
    :vartype description: str
    """

    _attribute_map = {
        "issue_type": {"key": "issueType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, issue_type: Optional[str] = None, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword issue_type: Type of Issue.
        :paramtype issue_type: str
        :keyword description: Description of the issue.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.issue_type = issue_type
        self.description = description


class RegenerateAccessKeyParameters(_serialization.Model):
    """Parameters supplied to the Regenerate Authorization Rule operation, specifies which key needs
    to be reset.

    All required parameters must be populated in order to send to server.

    :ivar key_type: The access key to regenerate. Required. Known values are: "PrimaryKey" and
     "SecondaryKey".
    :vartype key_type: str or ~azure.mgmt.eventhub.models.KeyType
    :ivar key: Optional, if the key value provided, is set for KeyType or autogenerated Key value
     set for keyType.
    :vartype key: str
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.KeyType"], key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_type: The access key to regenerate. Required. Known values are: "PrimaryKey" and
         "SecondaryKey".
        :paramtype key_type: str or ~azure.mgmt.eventhub.models.KeyType
        :keyword key: Optional, if the key value provided, is set for KeyType or autogenerated Key
         value set for keyType.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.key_type = key_type
        self.key = key


class SchemaGroup(ProxyResource):
    """Single item in List or Get Schema Group operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or
     "Microsoft.EventHub/Namespaces/EventHubs".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.eventhub.models.SystemData
    :ivar updated_at_utc: Exact time the Schema Group was updated.
    :vartype updated_at_utc: ~datetime.datetime
    :ivar created_at_utc: Exact time the Schema Group was created.
    :vartype created_at_utc: ~datetime.datetime
    :ivar e_tag: The ETag value.
    :vartype e_tag: str
    :ivar group_properties: dictionary object for SchemaGroup group properties.
    :vartype group_properties: dict[str, str]
    :ivar schema_compatibility: Known values are: "None", "Backward", and "Forward".
    :vartype schema_compatibility: str or ~azure.mgmt.eventhub.models.SchemaCompatibility
    :ivar schema_type: Known values are: "Unknown" and "Avro".
    :vartype schema_type: str or ~azure.mgmt.eventhub.models.SchemaType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "system_data": {"readonly": True},
        "updated_at_utc": {"readonly": True},
        "created_at_utc": {"readonly": True},
        "e_tag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "updated_at_utc": {"key": "properties.updatedAtUtc", "type": "iso-8601"},
        "created_at_utc": {"key": "properties.createdAtUtc", "type": "iso-8601"},
        "e_tag": {"key": "properties.eTag", "type": "str"},
        "group_properties": {"key": "properties.groupProperties", "type": "{str}"},
        "schema_compatibility": {"key": "properties.schemaCompatibility", "type": "str"},
        "schema_type": {"key": "properties.schemaType", "type": "str"},
    }

    def __init__(
        self,
        *,
        group_properties: Optional[Dict[str, str]] = None,
        schema_compatibility: Optional[Union[str, "_models.SchemaCompatibility"]] = None,
        schema_type: Optional[Union[str, "_models.SchemaType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_properties: dictionary object for SchemaGroup group properties.
        :paramtype group_properties: dict[str, str]
        :keyword schema_compatibility: Known values are: "None", "Backward", and "Forward".
        :paramtype schema_compatibility: str or ~azure.mgmt.eventhub.models.SchemaCompatibility
        :keyword schema_type: Known values are: "Unknown" and "Avro".
        :paramtype schema_type: str or ~azure.mgmt.eventhub.models.SchemaType
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.updated_at_utc: Optional[datetime.datetime] = None
        self.created_at_utc: Optional[datetime.datetime] = None
        self.e_tag: Optional[str] = None
        self.group_properties = group_properties
        self.schema_compatibility = schema_compatibility
        self.schema_type = schema_type


class SchemaGroupListResult(_serialization.Model):
    """The result of the List SchemaGroup operation.

    :ivar value: Result of the List SchemaGroups operation.
    :vartype value: list[~azure.mgmt.eventhub.models.SchemaGroup]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Schema Groups.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SchemaGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SchemaGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Result of the List SchemaGroups operation.
        :paramtype value: list[~azure.mgmt.eventhub.models.SchemaGroup]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Schema Groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Sku(_serialization.Model):
    """SKU parameters supplied to the create namespace operation.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of this SKU. Required. Known values are: "Basic", "Standard", and "Premium".
    :vartype name: str or ~azure.mgmt.eventhub.models.SkuName
    :ivar tier: The billing tier of this particular SKU. Known values are: "Basic", "Standard", and
     "Premium".
    :vartype tier: str or ~azure.mgmt.eventhub.models.SkuTier
    :ivar capacity: The Event Hubs throughput units for Basic or Standard tiers, where value should
     be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value should
     be 0 to 10 premium units.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "capacity": {"minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of this SKU. Required. Known values are: "Basic", "Standard", and
         "Premium".
        :paramtype name: str or ~azure.mgmt.eventhub.models.SkuName
        :keyword tier: The billing tier of this particular SKU. Known values are: "Basic", "Standard",
         and "Premium".
        :paramtype tier: str or ~azure.mgmt.eventhub.models.SkuTier
        :keyword capacity: The Event Hubs throughput units for Basic or Standard tiers, where value
         should be 0 to 20 throughput units. The Event Hubs premium units for Premium tier, where value
         should be 0 to 10 premium units.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class Subnet(_serialization.Model):
    """Properties supplied for Subnet.

    :ivar id: Resource ID of Virtual Network Subnet.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of Virtual Network Subnet.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.eventhub.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.eventhub.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.eventhub.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.eventhub.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class ThrottlingPolicy(ApplicationGroupPolicy):
    """Properties of the throttling policy.

    All required parameters must be populated in order to send to server.

    :ivar name: The Name of this policy. Required.
    :vartype name: str
    :ivar type: Application Group Policy types. Required. "ThrottlingPolicy"
    :vartype type: str or ~azure.mgmt.eventhub.models.ApplicationGroupPolicyType
    :ivar rate_limit_threshold: The Threshold limit above which the application group will be
     throttled.Rate limit is always per second. Required.
    :vartype rate_limit_threshold: int
    :ivar metric_id: Metric Id on which the throttle limit should be set, MetricId can be
     discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure
     Portal. Required. Known values are: "IncomingBytes", "OutgoingBytes", "IncomingMessages", and
     "OutgoingMessages".
    :vartype metric_id: str or ~azure.mgmt.eventhub.models.MetricId
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "rate_limit_threshold": {"required": True},
        "metric_id": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rate_limit_threshold": {"key": "rateLimitThreshold", "type": "int"},
        "metric_id": {"key": "metricId", "type": "str"},
    }

    def __init__(
        self, *, name: str, rate_limit_threshold: int, metric_id: Union[str, "_models.MetricId"], **kwargs: Any
    ) -> None:
        """
        :keyword name: The Name of this policy. Required.
        :paramtype name: str
        :keyword rate_limit_threshold: The Threshold limit above which the application group will be
         throttled.Rate limit is always per second. Required.
        :paramtype rate_limit_threshold: int
        :keyword metric_id: Metric Id on which the throttle limit should be set, MetricId can be
         discovered by hovering over Metric in the Metrics section of Event Hub Namespace inside Azure
         Portal. Required. Known values are: "IncomingBytes", "OutgoingBytes", "IncomingMessages", and
         "OutgoingMessages".
        :paramtype metric_id: str or ~azure.mgmt.eventhub.models.MetricId
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "ThrottlingPolicy"
        self.rate_limit_threshold = rate_limit_threshold
        self.metric_id = metric_id


class UserAssignedIdentity(_serialization.Model):
    """Recognized Dictionary value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class UserAssignedIdentityProperties(_serialization.Model):
    """UserAssignedIdentityProperties.

    :ivar user_assigned_identity: ARM ID of user Identity selected for encryption.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(self, *, user_assigned_identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_assigned_identity: ARM ID of user Identity selected for encryption.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity
