﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/IdMappingTable.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CleanRooms {
namespace Model {
class UpdateIdMappingTableResult {
 public:
  AWS_CLEANROOMS_API UpdateIdMappingTableResult() = default;
  AWS_CLEANROOMS_API UpdateIdMappingTableResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLEANROOMS_API UpdateIdMappingTableResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The updated ID mapping table.</p>
   */
  inline const IdMappingTable& GetIdMappingTable() const { return m_idMappingTable; }
  template <typename IdMappingTableT = IdMappingTable>
  void SetIdMappingTable(IdMappingTableT&& value) {
    m_idMappingTableHasBeenSet = true;
    m_idMappingTable = std::forward<IdMappingTableT>(value);
  }
  template <typename IdMappingTableT = IdMappingTable>
  UpdateIdMappingTableResult& WithIdMappingTable(IdMappingTableT&& value) {
    SetIdMappingTable(std::forward<IdMappingTableT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateIdMappingTableResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  IdMappingTable m_idMappingTable;

  Aws::String m_requestId;
  bool m_idMappingTableHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
