/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.DecoderEntry;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerPartialBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerPartialText;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholePong;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeText;
import org.apache.tomcat.websocket.pojo.PojoPathParam;

public class PojoMethodMapping {
    private static final StringManager sm = StringManager.getManager(PojoMethodMapping.class);
    private final Method onOpen;
    private final Method onClose;
    private final Method onError;
    private final PojoPathParam[] onOpenParams;
    private final PojoPathParam[] onCloseParams;
    private final PojoPathParam[] onErrorParams;
    private final List<MessageHandlerInfo> onMessage = new ArrayList<MessageHandlerInfo>();
    private final String wsPath;

    public PojoMethodMapping(Class<?> clazz, List<Class<? extends Decoder>> list, String string, InstanceManager instanceManager) throws DeploymentException {
        Object object;
        this.wsPath = string;
        List<DecoderEntry> list2 = Util.getDecoders(list, instanceManager);
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        Method[] methodArray = null;
        Class<?> clazz2 = clazz;
        while (!clazz2.equals(Object.class)) {
            object = clazz2.getDeclaredMethods();
            if (clazz2 == clazz) {
                methodArray = object;
            }
            for (Object object5 : object) {
                if (((Method)object5).isSynthetic()) continue;
                if (((Method)object5).getAnnotation(OnOpen.class) != null) {
                    this.checkPublic((Method)object5);
                    if (object2 == null) {
                        object2 = object5;
                        continue;
                    }
                    if (clazz2 != clazz && this.isMethodOverride((Method)object2, (Method)object5)) continue;
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateAnnotation", new Object[]{OnOpen.class, clazz2}));
                }
                if (((Method)object5).getAnnotation(OnClose.class) != null) {
                    this.checkPublic((Method)object5);
                    if (object3 == null) {
                        object3 = object5;
                        continue;
                    }
                    if (clazz2 != clazz && this.isMethodOverride((Method)object3, (Method)object5)) continue;
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateAnnotation", new Object[]{OnClose.class, clazz2}));
                }
                if (((Method)object5).getAnnotation(OnError.class) != null) {
                    this.checkPublic((Method)object5);
                    if (object4 == null) {
                        object4 = object5;
                        continue;
                    }
                    if (clazz2 != clazz && this.isMethodOverride((Method)object4, (Method)object5)) continue;
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateAnnotation", new Object[]{OnError.class, clazz2}));
                }
                if (((Method)object5).getAnnotation(OnMessage.class) == null) continue;
                this.checkPublic((Method)object5);
                MessageHandlerInfo messageHandlerInfo = new MessageHandlerInfo((Method)object5, list2);
                boolean bl = false;
                for (MessageHandlerInfo messageHandlerInfo2 : this.onMessage) {
                    if (!messageHandlerInfo.targetsSameWebSocketMessageType(messageHandlerInfo2)) continue;
                    bl = true;
                    if (clazz2 != clazz && this.isMethodOverride(messageHandlerInfo.m, messageHandlerInfo2.m)) continue;
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateAnnotation", new Object[]{OnMessage.class, clazz2}));
                }
                if (bl) continue;
                this.onMessage.add(messageHandlerInfo);
            }
            clazz2 = clazz2.getSuperclass();
        }
        if (object2 != null && ((Method)object2).getDeclaringClass() != clazz && this.isOverridenWithoutAnnotation(methodArray, (Method)object2, OnOpen.class)) {
            object2 = null;
        }
        if (object3 != null && ((Method)object3).getDeclaringClass() != clazz && this.isOverridenWithoutAnnotation(methodArray, (Method)object3, OnClose.class)) {
            object3 = null;
        }
        if (object4 != null && ((Method)object4).getDeclaringClass() != clazz && this.isOverridenWithoutAnnotation(methodArray, (Method)object4, OnError.class)) {
            object4 = null;
        }
        object = new ArrayList();
        for (MessageHandlerInfo messageHandlerInfo : this.onMessage) {
            if (messageHandlerInfo.m.getDeclaringClass() == clazz || !this.isOverridenWithoutAnnotation(methodArray, messageHandlerInfo.m, OnMessage.class)) continue;
            object.add(messageHandlerInfo);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MessageHandlerInfo messageHandlerInfo = (MessageHandlerInfo)iterator.next();
            this.onMessage.remove(messageHandlerInfo);
        }
        this.onOpen = object2;
        this.onClose = object3;
        this.onError = object4;
        this.onOpenParams = PojoMethodMapping.getPathParams(this.onOpen, MethodType.ON_OPEN);
        this.onCloseParams = PojoMethodMapping.getPathParams(this.onClose, MethodType.ON_CLOSE);
        this.onErrorParams = PojoMethodMapping.getPathParams(this.onError, MethodType.ON_ERROR);
    }

    private void checkPublic(Method method) throws DeploymentException {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new DeploymentException(sm.getString("pojoMethodMapping.methodNotPublic", new Object[]{method.getName()}));
        }
    }

    private boolean isMethodOverride(Method method, Method method2) {
        return method.getName().equals(method2.getName()) && method.getReturnType().equals(method2.getReturnType()) && Arrays.equals(method.getParameterTypes(), method2.getParameterTypes());
    }

    private boolean isOverridenWithoutAnnotation(Method[] methodArray, Method method, Class<? extends Annotation> clazz) {
        for (Method method2 : methodArray) {
            if (!this.isMethodOverride(method2, method) || method2.getAnnotation(clazz) != null) continue;
            return true;
        }
        return false;
    }

    public String getWsPath() {
        return this.wsPath;
    }

    public Method getOnOpen() {
        return this.onOpen;
    }

    public Object[] getOnOpenArgs(Map<String, String> map, Session session, EndpointConfig endpointConfig) throws DecodeException {
        return PojoMethodMapping.buildArgs(this.onOpenParams, map, session, endpointConfig, null, null);
    }

    public Method getOnClose() {
        return this.onClose;
    }

    public Object[] getOnCloseArgs(Map<String, String> map, Session session, CloseReason closeReason) throws DecodeException {
        return PojoMethodMapping.buildArgs(this.onCloseParams, map, session, null, null, closeReason);
    }

    public Method getOnError() {
        return this.onError;
    }

    public Object[] getOnErrorArgs(Map<String, String> map, Session session, Throwable throwable) throws DecodeException {
        return PojoMethodMapping.buildArgs(this.onErrorParams, map, session, null, throwable, null);
    }

    public boolean hasMessageHandlers() {
        return !this.onMessage.isEmpty();
    }

    public Set<MessageHandler> getMessageHandlers(Object object, Map<String, String> map, Session session, EndpointConfig endpointConfig) {
        HashSet<MessageHandler> hashSet = new HashSet<MessageHandler>();
        for (MessageHandlerInfo messageHandlerInfo : this.onMessage) {
            hashSet.addAll(messageHandlerInfo.getMessageHandlers(object, map, session, endpointConfig));
        }
        return hashSet;
    }

    private static PojoPathParam[] getPathParams(Method method, MethodType methodType) throws DeploymentException {
        if (method == null) {
            return new PojoPathParam[0];
        }
        boolean bl = false;
        Class<?>[] classArray = method.getParameterTypes();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        PojoPathParam[] pojoPathParamArray = new PojoPathParam[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            Annotation[] annotationArray2;
            Class<?> clazz = classArray[i];
            if (clazz.equals(Session.class)) {
                pojoPathParamArray[i] = new PojoPathParam(clazz, null);
                continue;
            }
            if (methodType == MethodType.ON_OPEN && clazz.equals(EndpointConfig.class)) {
                pojoPathParamArray[i] = new PojoPathParam(clazz, null);
                continue;
            }
            if (methodType == MethodType.ON_ERROR && clazz.equals(Throwable.class)) {
                bl = true;
                pojoPathParamArray[i] = new PojoPathParam(clazz, null);
                continue;
            }
            if (methodType == MethodType.ON_CLOSE && clazz.equals(CloseReason.class)) {
                pojoPathParamArray[i] = new PojoPathParam(clazz, null);
                continue;
            }
            for (Annotation annotation : annotationArray2 = annotationArray[i]) {
                if (!annotation.annotationType().equals(PathParam.class)) continue;
                pojoPathParamArray[i] = new PojoPathParam(clazz, ((PathParam)annotation).value());
                break;
            }
            if (pojoPathParamArray[i] != null) continue;
            throw new DeploymentException(sm.getString("pojoMethodMapping.paramWithoutAnnotation", new Object[]{clazz, method.getName(), method.getClass().getName()}));
        }
        if (methodType == MethodType.ON_ERROR && !bl) {
            throw new DeploymentException(sm.getString("pojoMethodMapping.onErrorNoThrowable", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
        }
        return pojoPathParamArray;
    }

    private static Object[] buildArgs(PojoPathParam[] pojoPathParamArray, Map<String, String> map, Session session, EndpointConfig endpointConfig, Throwable throwable, CloseReason closeReason) throws DecodeException {
        Object[] objectArray = new Object[pojoPathParamArray.length];
        for (int i = 0; i < pojoPathParamArray.length; ++i) {
            Class<?> clazz = pojoPathParamArray[i].getType();
            if (clazz.equals(Session.class)) {
                objectArray[i] = session;
                continue;
            }
            if (clazz.equals(EndpointConfig.class)) {
                objectArray[i] = endpointConfig;
                continue;
            }
            if (clazz.equals(Throwable.class)) {
                objectArray[i] = throwable;
                continue;
            }
            if (clazz.equals(CloseReason.class)) {
                objectArray[i] = closeReason;
                continue;
            }
            String string = pojoPathParamArray[i].getName();
            String string2 = map.get(string);
            try {
                objectArray[i] = Util.coerceToType(clazz, string2);
                continue;
            }
            catch (Exception exception) {
                throw new DecodeException(string2, sm.getString("pojoMethodMapping.decodePathParamFail", new Object[]{string2, clazz}), (Throwable)exception);
            }
        }
        return objectArray;
    }

    private static class MessageHandlerInfo {
        private final Method m;
        private int indexString = -1;
        private int indexByteArray = -1;
        private int indexByteBuffer = -1;
        private int indexPong = -1;
        private int indexBoolean = -1;
        private int indexSession = -1;
        private int indexInputStream = -1;
        private int indexReader = -1;
        private int indexPrimitive = -1;
        private final Map<Integer, PojoPathParam> indexPathParams = new HashMap<Integer, PojoPathParam>();
        private int indexPayload = -1;
        private Util.DecoderMatch decoderMatch = null;
        private final long maxMessageSize;

        MessageHandlerInfo(Method method, List<DecoderEntry> list) throws DeploymentException {
            this.m = method;
            Class<?>[] classArray = method.getParameterTypes();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            for (int i = 0; i < classArray.length; ++i) {
                Annotation[] annotationArray2;
                boolean bl = false;
                for (Annotation annotation : annotationArray2 = annotationArray[i]) {
                    if (!annotation.annotationType().equals(PathParam.class)) continue;
                    this.indexPathParams.put(i, new PojoPathParam(classArray[i], ((PathParam)annotation).value()));
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (String.class.isAssignableFrom(classArray[i])) {
                    if (this.indexString == -1) {
                        this.indexString = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (Reader.class.isAssignableFrom(classArray[i])) {
                    if (this.indexReader == -1) {
                        this.indexReader = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (Boolean.TYPE == classArray[i]) {
                    if (this.indexBoolean == -1) {
                        this.indexBoolean = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateLastParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (ByteBuffer.class.isAssignableFrom(classArray[i])) {
                    if (this.indexByteBuffer == -1) {
                        this.indexByteBuffer = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (byte[].class == classArray[i]) {
                    if (this.indexByteArray == -1) {
                        this.indexByteArray = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (InputStream.class.isAssignableFrom(classArray[i])) {
                    if (this.indexInputStream == -1) {
                        this.indexInputStream = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (Util.isPrimitive(classArray[i])) {
                    if (this.indexPrimitive == -1) {
                        this.indexPrimitive = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (Session.class.isAssignableFrom(classArray[i])) {
                    if (this.indexSession == -1) {
                        this.indexSession = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateSessionParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (PongMessage.class.isAssignableFrom(classArray[i])) {
                    if (this.indexPong == -1) {
                        this.indexPong = i;
                        continue;
                    }
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicatePongMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                if (this.decoderMatch != null && this.decoderMatch.hasMatches()) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.decoderMatch = new Util.DecoderMatch(classArray[i], list);
                if (this.decoderMatch.hasMatches()) {
                    this.indexPayload = i;
                    continue;
                }
                throw new DeploymentException(sm.getString("pojoMethodMapping.noDecoder", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
            }
            if (this.indexString != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexString;
            }
            if (this.indexReader != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexReader;
            }
            if (this.indexByteArray != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexByteArray;
            }
            if (this.indexByteBuffer != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexByteBuffer;
            }
            if (this.indexInputStream != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexInputStream;
            }
            if (this.indexPrimitive != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.duplicateMessageParam", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexPrimitive;
            }
            if (this.indexPong != -1) {
                if (this.indexPayload != -1) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.pongWithPayload", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
                }
                this.indexPayload = this.indexPong;
            }
            if (this.indexPayload == -1 && this.indexPrimitive == -1 && this.indexBoolean != -1) {
                this.indexPayload = this.indexBoolean;
                this.indexPrimitive = this.indexBoolean;
                this.indexBoolean = -1;
            }
            if (this.indexPayload == -1) {
                throw new DeploymentException(sm.getString("pojoMethodMapping.noPayload", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
            }
            if (this.indexPong != -1 && this.indexBoolean != -1) {
                throw new DeploymentException(sm.getString("pojoMethodMapping.partialPong", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
            }
            if (this.indexReader != -1 && this.indexBoolean != -1) {
                throw new DeploymentException(sm.getString("pojoMethodMapping.partialReader", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
            }
            if (this.indexInputStream != -1 && this.indexBoolean != -1) {
                throw new DeploymentException(sm.getString("pojoMethodMapping.partialInputStream", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
            }
            if (this.decoderMatch != null && this.decoderMatch.hasMatches() && this.indexBoolean != -1) {
                throw new DeploymentException(sm.getString("pojoMethodMapping.partialObject", new Object[]{method.getName(), method.getDeclaringClass().getName()}));
            }
            this.maxMessageSize = method.getAnnotation(OnMessage.class).maxMessageSize();
        }

        public boolean targetsSameWebSocketMessageType(MessageHandlerInfo messageHandlerInfo) {
            if (messageHandlerInfo == null) {
                return false;
            }
            return this.isPong() && messageHandlerInfo.isPong() || this.isBinary() && messageHandlerInfo.isBinary() || this.isText() && messageHandlerInfo.isText();
        }

        private boolean isPong() {
            return this.indexPong >= 0;
        }

        private boolean isText() {
            return this.indexString >= 0 || this.indexPrimitive >= 0 || this.indexReader >= 0 || this.decoderMatch != null && !this.decoderMatch.getTextDecoders().isEmpty();
        }

        private boolean isBinary() {
            return this.indexByteArray >= 0 || this.indexByteBuffer >= 0 || this.indexInputStream >= 0 || this.decoderMatch != null && !this.decoderMatch.getBinaryDecoders().isEmpty();
        }

        public Set<MessageHandler> getMessageHandlers(Object object, Map<String, String> map, Session session, EndpointConfig endpointConfig) {
            Object[] objectArray = new Object[this.m.getParameterTypes().length];
            for (Map.Entry<Integer, PojoPathParam> object22 : this.indexPathParams.entrySet()) {
                Object object2;
                PojoPathParam pojoPathParam = object22.getValue();
                String string = map.get(pojoPathParam.getName());
                try {
                    object2 = Util.coerceToType(pojoPathParam.getType(), string);
                }
                catch (Exception exception) {
                    DecodeException decodeException = new DecodeException(string, sm.getString("pojoMethodMapping.decodePathParamFail", new Object[]{string, pojoPathParam.getType()}), (Throwable)exception);
                    objectArray = new Object[]{decodeException};
                    break;
                }
                objectArray[object22.getKey().intValue()] = object2;
            }
            HashSet hashSet = new HashSet(2);
            if (this.indexBoolean == -1) {
                if (this.indexString != -1 || this.indexPrimitive != -1) {
                    PojoMessageHandlerWholeText pojoMessageHandlerWholeText = new PojoMessageHandlerWholeText(object, this.m, session, endpointConfig, null, objectArray, this.indexPayload, false, this.indexSession, this.maxMessageSize);
                    hashSet.add(pojoMessageHandlerWholeText);
                } else if (this.indexReader != -1) {
                    PojoMessageHandlerWholeText pojoMessageHandlerWholeText = new PojoMessageHandlerWholeText(object, this.m, session, endpointConfig, null, objectArray, this.indexReader, true, this.indexSession, this.maxMessageSize);
                    hashSet.add(pojoMessageHandlerWholeText);
                } else if (this.indexByteArray != -1) {
                    PojoMessageHandlerWholeBinary pojoMessageHandlerWholeBinary = new PojoMessageHandlerWholeBinary(object, this.m, session, endpointConfig, null, objectArray, this.indexByteArray, true, this.indexSession, false, this.maxMessageSize);
                    hashSet.add(pojoMessageHandlerWholeBinary);
                } else if (this.indexByteBuffer != -1) {
                    PojoMessageHandlerWholeBinary pojoMessageHandlerWholeBinary = new PojoMessageHandlerWholeBinary(object, this.m, session, endpointConfig, null, objectArray, this.indexByteBuffer, false, this.indexSession, false, this.maxMessageSize);
                    hashSet.add(pojoMessageHandlerWholeBinary);
                } else if (this.indexInputStream != -1) {
                    PojoMessageHandlerWholeBinary pojoMessageHandlerWholeBinary = new PojoMessageHandlerWholeBinary(object, this.m, session, endpointConfig, null, objectArray, this.indexInputStream, true, this.indexSession, true, this.maxMessageSize);
                    hashSet.add(pojoMessageHandlerWholeBinary);
                } else if (this.decoderMatch != null && this.decoderMatch.hasMatches()) {
                    if (!this.decoderMatch.getBinaryDecoders().isEmpty()) {
                        PojoMessageHandlerWholeBinary pojoMessageHandlerWholeBinary = new PojoMessageHandlerWholeBinary(object, this.m, session, endpointConfig, this.decoderMatch.getBinaryDecoders(), objectArray, this.indexPayload, true, this.indexSession, true, this.maxMessageSize);
                        hashSet.add(pojoMessageHandlerWholeBinary);
                    }
                    if (!this.decoderMatch.getTextDecoders().isEmpty()) {
                        PojoMessageHandlerWholeText pojoMessageHandlerWholeText = new PojoMessageHandlerWholeText(object, this.m, session, endpointConfig, this.decoderMatch.getTextDecoders(), objectArray, this.indexPayload, true, this.indexSession, this.maxMessageSize);
                        hashSet.add(pojoMessageHandlerWholeText);
                    }
                } else {
                    PojoMessageHandlerWholePong pojoMessageHandlerWholePong = new PojoMessageHandlerWholePong(object, this.m, session, objectArray, this.indexPong, false, this.indexSession);
                    hashSet.add(pojoMessageHandlerWholePong);
                }
            } else if (this.indexString != -1) {
                PojoMessageHandlerPartialText pojoMessageHandlerPartialText = new PojoMessageHandlerPartialText(object, this.m, session, objectArray, this.indexString, false, this.indexBoolean, this.indexSession, this.maxMessageSize);
                hashSet.add(pojoMessageHandlerPartialText);
            } else if (this.indexByteArray != -1) {
                PojoMessageHandlerPartialBinary pojoMessageHandlerPartialBinary = new PojoMessageHandlerPartialBinary(object, this.m, session, objectArray, this.indexByteArray, true, this.indexBoolean, this.indexSession, this.maxMessageSize);
                hashSet.add(pojoMessageHandlerPartialBinary);
            } else {
                PojoMessageHandlerPartialBinary pojoMessageHandlerPartialBinary = new PojoMessageHandlerPartialBinary(object, this.m, session, objectArray, this.indexByteBuffer, false, this.indexBoolean, this.indexSession, this.maxMessageSize);
                hashSet.add(pojoMessageHandlerPartialBinary);
            }
            return hashSet;
        }
    }

    private static enum MethodType {
        ON_OPEN,
        ON_CLOSE,
        ON_ERROR;

    }
}

