/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.jmx;

import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.JmxChannel;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JmxRegistry {
    private static final Log log = LogFactory.getLog(JmxRegistry.class);
    protected static final StringManager sm = StringManager.getManager(JmxRegistry.class);
    private static final ConcurrentHashMap<String, JmxRegistry> registryCache = new ConcurrentHashMap();
    private final MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
    private ObjectName baseOname = null;

    private JmxRegistry() {
    }

    public static JmxRegistry getRegistry(Channel channel) {
        if (channel == null || channel.getName() == null) {
            return null;
        }
        JmxRegistry jmxRegistry = registryCache.get(channel.getName());
        if (jmxRegistry != null) {
            return jmxRegistry;
        }
        if (!(channel instanceof JmxChannel)) {
            return null;
        }
        JmxChannel jmxChannel = (JmxChannel)((Object)channel);
        if (!jmxChannel.isJmxEnabled()) {
            return null;
        }
        ObjectName objectName = JmxRegistry.createBaseObjectName(jmxChannel.getJmxDomain(), jmxChannel.getJmxPrefix(), channel.getName());
        if (objectName == null) {
            return null;
        }
        jmxRegistry = new JmxRegistry();
        jmxRegistry.baseOname = objectName;
        registryCache.put(channel.getName(), jmxRegistry);
        return jmxRegistry;
    }

    public static void removeRegistry(Channel channel, boolean bl) {
        JmxRegistry jmxRegistry = registryCache.get(channel.getName());
        if (jmxRegistry == null) {
            return;
        }
        if (bl) {
            jmxRegistry.clearMBeans();
        }
        registryCache.remove(channel.getName());
    }

    private static ObjectName createBaseObjectName(String string, String string2, String string3) {
        if (string == null) {
            log.warn((Object)sm.getString("jmxRegistry.no.domain"));
            return null;
        }
        ObjectName objectName = null;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(':');
        stringBuilder.append(string2);
        stringBuilder.append("type=Channel,channel=");
        stringBuilder.append(string3);
        try {
            objectName = new ObjectName(stringBuilder.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.error((Object)sm.getString("jmxRegistry.objectName.failed", stringBuilder.toString()), (Throwable)malformedObjectNameException);
        }
        return objectName;
    }

    public ObjectName registerJmx(String string, Object object) {
        ObjectName objectName;
        if (this.mbserver == null) {
            return null;
        }
        String string2 = this.baseOname.toString() + string;
        try {
            objectName = new ObjectName(string2);
            if (this.mbserver.isRegistered(objectName)) {
                this.mbserver.unregisterMBean(objectName);
            }
            this.mbserver.registerMBean(object, objectName);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            log.warn((Object)sm.getString("jmxRegistry.registerJmx.notCompliant", object), (Throwable)notCompliantMBeanException);
            return null;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.error((Object)sm.getString("jmxRegistry.objectName.failed", string2), (Throwable)malformedObjectNameException);
            return null;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("jmxRegistry.registerJmx.failed", object, string2), (Throwable)exception);
            return null;
        }
        return objectName;
    }

    public void unregisterJmx(ObjectName objectName) {
        if (objectName == null) {
            return;
        }
        try {
            this.mbserver.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            log.warn((Object)sm.getString("jmxRegistry.unregisterJmx.notFound", objectName), (Throwable)instanceNotFoundException);
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("jmxRegistry.unregisterJmx.failed", objectName), (Throwable)exception);
        }
    }

    private void clearMBeans() {
        String string = this.baseOname.toString() + ",*";
        try {
            ObjectName objectName = new ObjectName(string);
            Set<ObjectName> set = this.mbserver.queryNames(objectName, null);
            for (ObjectName objectName2 : set) {
                this.unregisterJmx(objectName2);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.error((Object)sm.getString("jmxRegistry.objectName.failed", string), (Throwable)malformedObjectNameException);
        }
    }
}

