/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.awt.Color;
import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotationText;
import org.apache.pdfbox.util.BitFlagHelper;
import org.apache.pdfbox.util.DateConverter;
import org.w3c.dom.Element;

public abstract class FDFAnnotation
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(FDFAnnotation.class);
    protected COSDictionary annot;

    public FDFAnnotation() {
        this.annot = new COSDictionary();
        this.annot.setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
    }

    public FDFAnnotation(COSDictionary a) {
        this.annot = a;
    }

    public FDFAnnotation(Element element) throws IOException {
        this();
        String color;
        String page = element.getAttribute("page");
        if (page != null) {
            this.setPage(Integer.parseInt(page));
        }
        if ((color = element.getAttribute("color")) != null && color.length() == 7 && color.charAt(0) == '#') {
            int colorValue = Integer.parseInt(color.substring(1, 7), 16);
            this.setColor(new Color(colorValue));
        }
        this.setDate(element.getAttribute("date"));
        String flags = element.getAttribute("flags");
        if (flags != null) {
            String[] flagTokens = flags.split(",");
            for (int i = 0; i < flagTokens.length; ++i) {
                if (flagTokens[i].equals("invisible")) {
                    this.setInvisible(true);
                    continue;
                }
                if (flagTokens[i].equals("hidden")) {
                    this.setHidden(true);
                    continue;
                }
                if (flagTokens[i].equals("print")) {
                    this.setPrinted(true);
                    continue;
                }
                if (flagTokens[i].equals("nozoom")) {
                    this.setNoZoom(true);
                    continue;
                }
                if (flagTokens[i].equals("norotate")) {
                    this.setNoRotate(true);
                    continue;
                }
                if (flagTokens[i].equals("noview")) {
                    this.setNoView(true);
                    continue;
                }
                if (flagTokens[i].equals("readonly")) {
                    this.setReadOnly(true);
                    continue;
                }
                if (flagTokens[i].equals("locked")) {
                    this.setLocked(true);
                    continue;
                }
                if (!flagTokens[i].equals("togglenoview")) continue;
                this.setToggleNoView(true);
            }
        }
        this.setName(element.getAttribute("name"));
        String rect = element.getAttribute("rect");
        if (rect != null) {
            String[] rectValues = rect.split(",");
            float[] values = new float[rectValues.length];
            for (int i = 0; i < rectValues.length; ++i) {
                values[i] = Float.parseFloat(rectValues[i]);
            }
            COSArray array = new COSArray();
            array.setFloatArray(values);
            this.setRectangle(new PDRectangle(array));
        }
        this.setName(element.getAttribute("title"));
        this.setCreationDate(DateConverter.toCalendar(element.getAttribute("creationdate")));
        String opac = element.getAttribute("opacity");
        if (opac != null) {
            this.setOpacity(Float.parseFloat(opac));
        }
        this.setSubject(element.getAttribute("subject"));
    }

    public static FDFAnnotation create(COSDictionary fdfDic) throws IOException {
        FDFAnnotationText retval = null;
        if (fdfDic != null) {
            if ("Text".equals(fdfDic.getNameAsString(COSName.SUBTYPE))) {
                retval = new FDFAnnotationText(fdfDic);
            } else {
                LOG.warn("Unknown annotation type '" + fdfDic.getNameAsString(COSName.SUBTYPE) + "'");
            }
        }
        return retval;
    }

    @Override
    public COSBase getCOSObject() {
        return this.annot;
    }

    public COSDictionary getCOSDictionary() {
        return this.annot;
    }

    public Integer getPage() {
        Integer retval = null;
        COSNumber page = (COSNumber)this.annot.getDictionaryObject(COSName.PAGE);
        if (page != null) {
            retval = new Integer(page.intValue());
        }
        return retval;
    }

    public void setPage(int page) {
        this.annot.setInt("Page", page);
    }

    public Color getColor() {
        float[] rgb;
        Color retval = null;
        COSArray array = (COSArray)this.annot.getDictionaryObject("color");
        if (array != null && (rgb = array.toFloatArray()).length >= 3) {
            retval = new Color(rgb[0], rgb[1], rgb[2]);
        }
        return retval;
    }

    public void setColor(Color c) {
        COSArray color = null;
        if (c != null) {
            float[] colors = c.getRGBColorComponents(null);
            color = new COSArray();
            color.setFloatArray(colors);
        }
        this.annot.setItem("color", color);
    }

    public String getDate() {
        return this.annot.getString(COSName.DATE);
    }

    public void setDate(String date) {
        this.annot.setString(COSName.DATE, date);
    }

    public boolean isInvisible() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 1);
    }

    public void setInvisible(boolean invisible) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 1, invisible);
    }

    public boolean isHidden() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 2);
    }

    public void setHidden(boolean hidden) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 2, hidden);
    }

    public boolean isPrinted() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 4);
    }

    public void setPrinted(boolean printed) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 4, printed);
    }

    public boolean isNoZoom() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 8);
    }

    public void setNoZoom(boolean noZoom) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 8, noZoom);
    }

    public boolean isNoRotate() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 16);
    }

    public void setNoRotate(boolean noRotate) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 16, noRotate);
    }

    public boolean isNoView() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 32);
    }

    public void setNoView(boolean noView) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 32, noView);
    }

    public boolean isReadOnly() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 64);
    }

    public void setReadOnly(boolean readOnly) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 64, readOnly);
    }

    public boolean isLocked() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 128);
    }

    public void setLocked(boolean locked) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 128, locked);
    }

    public boolean isToggleNoView() {
        return BitFlagHelper.getFlag(this.annot, COSName.F, 256);
    }

    public void setToggleNoView(boolean toggleNoView) {
        BitFlagHelper.setFlag(this.annot, COSName.F, 256, toggleNoView);
    }

    public void setName(String name) {
        this.annot.setString(COSName.NM, name);
    }

    public String getName() {
        return this.annot.getString(COSName.NM);
    }

    public void setRectangle(PDRectangle rectangle) {
        this.annot.setItem(COSName.RECT, (COSObjectable)rectangle);
    }

    public PDRectangle getRectangle() {
        PDRectangle retval = null;
        COSArray rectArray = (COSArray)this.annot.getDictionaryObject(COSName.RECT);
        if (rectArray != null) {
            retval = new PDRectangle(rectArray);
        }
        return retval;
    }

    public void setTitle(String title) {
        this.annot.setString(COSName.T, title);
    }

    public String getTitle() {
        return this.annot.getString(COSName.T);
    }

    public Calendar getCreationDate() throws IOException {
        return this.annot.getDate(COSName.CREATION_DATE);
    }

    public void setCreationDate(Calendar date) {
        this.annot.setDate(COSName.CREATION_DATE, date);
    }

    public void setOpacity(float opacity) {
        this.annot.setFloat(COSName.CA, opacity);
    }

    public float getOpacity() {
        return this.annot.getFloat(COSName.CA, 1.0f);
    }

    public void setSubject(String subject) {
        this.annot.setString(COSName.SUBJ, subject);
    }

    public String getSubject() {
        return this.annot.getString(COSName.SUBJ);
    }
}

