"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindFileReferencesProviderImpl = void 0;
const vscode_languageserver_1 = require("vscode-languageserver");
const vscode_uri_1 = require("vscode-uri");
const utils_1 = require("../utils");
const utils_2 = require("./utils");
const utils_3 = require("../../../utils");
class FindFileReferencesProviderImpl {
    constructor(lsAndTsDocResolver) {
        this.lsAndTsDocResolver = lsAndTsDocResolver;
    }
    async fileReferences(uri) {
        const u = vscode_uri_1.URI.parse(uri);
        const fileName = u.fsPath;
        const lsContainer = await this.lsAndTsDocResolver.getTSService(fileName);
        const lang = lsContainer.getService();
        const tsDoc = await this.getSnapshotForPath(fileName);
        const references = lang.getFileReferences(fileName);
        if (!references) {
            return null;
        }
        const snapshots = new utils_2.SnapshotMap(this.lsAndTsDocResolver, lsContainer);
        snapshots.set(tsDoc.filePath, tsDoc);
        const locations = await Promise.all(references.map(async (ref) => {
            const snapshot = await snapshots.retrieve(ref.fileName);
            return vscode_languageserver_1.Location.create((0, utils_3.pathToUrl)(ref.fileName), (0, utils_1.convertToLocationRange)(snapshot, ref.textSpan));
        }));
        // Some references are in generated code but not wrapped with explicit ignore comments.
        // These show up as zero-length ranges, so filter them out.
        return locations.filter(utils_1.hasNonZeroRange);
    }
    async getSnapshotForPath(path) {
        return this.lsAndTsDocResolver.getOrCreateSnapshot(path);
    }
}
exports.FindFileReferencesProviderImpl = FindFileReferencesProviderImpl;
//# sourceMappingURL=FindFileReferencesProvider.js.map