/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryGrindPeakImageFilter_h
#define sitkBinaryGrindPeakImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class BinaryGrindPeakImageFilter
\brief Remove the objects not connected to the boundary of the image.

BinaryGrindPeakImageFilter grinds peaks in a grayscale image.

Geodesic morphology and the grind peak algorithm is described in Chapter 6 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4 

\see GrayscaleGrindPeakImageFilter
\sa itk::simple::BinaryGrindPeak for the procedural interface
\sa itk::BinaryGrindPeakImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryGrindPeakImageFilter : public ImageFilter {
    public:
      using Self = BinaryGrindPeakImageFilter;

      /** Destructor */
      virtual ~BinaryGrindPeakImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryGrindPeakImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = IntegerPixelIDTypeList;
\

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      bool GetFullyConnected() const { return this->m_FullyConnected; }\

      /**
       * Set the value in the image to consider as "foreground". Defaults to maximum value of InputPixelType.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       * Get the value in the image considered as "foreground". Defaults to maximum value of InputPixelType.
       */
      double GetForegroundValue() const { return this->m_ForegroundValue; }\

      /**
       * Set the value in eroded part of the image. Defaults to zero
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Set the value in eroded part of the image. Defaults to zero
       */
      double GetBackgroundValue() const { return this->m_BackgroundValue; }

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryGrindPeakImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_FullyConnected{false};

      double  m_ForegroundValue{1.0};

      double  m_BackgroundValue{0};


    };

    /**\
     * \brief Remove the objects not connected to the boundary of the image.
     *
     * This function directly calls the execute method of BinaryGrindPeakImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BinaryGrindPeakImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image BinaryGrindPeak ( const Image& image1, bool fullyConnected = false, double foregroundValue = 1.0, double backgroundValue = 0 );

     /** @} */
}
#endif
