# This file is auto-generated by autogen/generator.py

cdef class Gen_base:
    """
    Wrapper for a PARI ``GEN`` containing auto-generated methods.

    This class does not manage the ``GEN`` inside in any way. It is just
    a dumb wrapper. In particular, it might be invalid if the ``GEN`` is
    on the PARI stack and the PARI stack has been garbage collected.

    You almost certainly want to use one of the derived class
    :class:`Gen`  instead. That being said, :class:`Gen_base` can be
    used by itself to pass around a temporary ``GEN`` within Python
    where we cannot use C calls.
    """
    def Col(x, long n=0):
        r'''
        Transforms the object :math:`x` into a column vector. The dimension of the
        resulting vector can be optionally specified via the extra parameter :math:`n`.

        If :math:`n` is omitted or :math:`0`, the dimension depends on the type of :math:`x`; the
        vector has a single component, except when :math:`x` is

        - a vector or a quadratic form (in which case the resulting vector
        is simply the initial object considered as a row vector),

        - a polynomial or a power series. In the case of a polynomial, the
        coefficients of the vector start with the leading coefficient of the
        polynomial, while for power series only the significant coefficients are
        taken into account, but this time by increasing order of degree.
        In this last case, :literal:`Vec` is the reciprocal function of :literal:`Pol` and
        :literal:`Ser` respectively,

        - a matrix (the column of row vector comprising the matrix is returned),

        - a character string (a vector of individual characters is returned).

        In the last two cases (matrix and character string), :math:`n` is meaningless and
        must be omitted or an error is raised. Otherwise, if :math:`n` is given, :math:`0`
        entries are appended at the end of the vector if :math:`n > 0`, and prepended at
        the beginning if :math:`n < 0`. The dimension of the resulting vector is :math:`\|n\|`.

        See ??Vec for examples and further details.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtocol0(_x, n)
        return new_gen(_ret)

    def Colrev(x, long n=0):
        r'''
        As :math:`Col (x, -n)`, then reverse the result. In particular,
        :literal:`Colrev` is the reciprocal function of :literal:`Polrev`: the
        coefficients of the vector start with the constant coefficient of the
        polynomial and the others follow by increasing degree.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtocolrev0(_x, n)
        return new_gen(_ret)

    def List(x):
        r'''
        Transforms a (row or column) vector :math:`x` into a list, whose components are
        the entries of :math:`x`. Similarly for a list, but rather useless in this case.
        For other types, creates a list with the single element :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtolist(_x)
        return new_gen(_ret)

    def Map(x):
        r'''
        A "Map" is an associative array, or dictionary: a data
        type composed of a collection of (:emphasis:`key`, :emphasis:`value`) pairs, such that
        each key appears just once in the collection. This function
        converts the matrix :math:`[a_{1},b_{1};a_{2},b_{2};...;a_{n},b_{n}]`
        to the map :math:`a_{i}:---> b_{i}`.

        ::

        ? M = Map(factor(13!));
        ? mapget(M, 3)
        %2 = 5
        ? P = Map(matreduce(primes([1,20])))
        %3 = Map([2,1;3,1;5,1;7,1;11,1;13,1;17,1;19,1])
        ? select(i->mapisdefined(P,i), [1..20])
        %4 = [2, 3, 5, 7, 11, 13, 17, 19]

        If the argument :math:`x` is omitted, creates an empty map, which
        may be filled later via :literal:`mapput`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtomap(_x)
        return new_gen(_ret)

    def Mat(x):
        r'''
        Transforms the object :math:`x` into a matrix.
        If :math:`x` is already a matrix, a copy of :math:`x` is created.
        If :math:`x` is a row (resp. column) vector, this creates a 1-row (resp.
        1-column) matrix, :emphasis:`unless` all elements are column (resp. row) vectors
        of the same length, in which case the vectors are concatenated sideways
        and the attached big matrix is returned.
        If :math:`x` is a binary quadratic form, creates the attached :math:`2 x 2`
        matrix. Otherwise, this creates a :math:`1 x 1` matrix containing :math:`x`.

        ::

        ? Mat(x + 1)
        %1 =
        [x + 1]
        ? Vec( matid(3) )
        %2 = [[1, 0, 0]~, [0, 1, 0]~, [0, 0, 1]~]
        ? Mat(%)
        %3 =
        [1 0 0]
        
        [0 1 0]
        
        [0 0 1]
        ? Col( [1,2; 3,4] )
        %4 = [[1, 2], [3, 4]]~
        ? Mat(%)
        %5 =
        [1 2]
        
        [3 4]
        ? Mat(Qfb(1,2,3))
        %6 =
        [1 1]
        
        [1 3]
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtomat(_x)
        return new_gen(_ret)

    def Mod(a, b):
        r'''
        In its basic form, create an intmod or a polmod :math:`(a mod b)`; :math:`b` must
        be an integer or a polynomial. We then obtain a :literal:`t_INTMOD` and a
        :literal:`t_POLMOD` respectively:

        ::

        ? t = Mod(2,17); t^8
        %1 = Mod(1, 17)
        ? t = Mod(x,x^2+1); t^2
        %2 = Mod(-1, x^2+1)

        If :math:`a \% b` makes sense and yields a result of the
        appropriate type (:literal:`t_INT` or scalar/:literal:`t_POL`), the operation succeeds as
        well:

        ::

        ? Mod(1/2, 5)
        %3 = Mod(3, 5)
        ? Mod(7 + O(3^6), 3)
        %4 = Mod(1, 3)
        ? Mod(Mod(1,12), 9)
        %5 = Mod(1, 3)
        ? Mod(1/x, x^2+1)
        %6 = Mod(-x, x^2+1)
        ? Mod(exp(x), x^4)
        %7 = Mod(1/6*x^3 + 1/2*x^2 + x + 1, x^4)

        If :math:`a` is a complex object, "base change" it to :math:`\mathbb{Z}/b\mathbb{Z}` or :math:`K[x]/(b)`,
        which is equivalent to, but faster than, multiplying it by :literal:`Mod(1,b)`:

        ::

        ? Mod([1,2;3,4], 2)
        %8 =
        [Mod(1, 2) Mod(0, 2)]
        
        [Mod(1, 2) Mod(0, 2)]
        ? Mod(3*x+5, 2)
        %9 = Mod(1, 2)*x + Mod(1, 2)
        ? Mod(x^2 + y*x + y^3, y^2+1)
        %10 = Mod(1, y^2 + 1)*x^2 + Mod(y, y^2 + 1)*x + Mod(-y, y^2 + 1)

        This function is not the same as :math:`x` :literal:`\%` :math:`y`, the result of which
        has no knowledge of the intended modulus :math:`y`. Compare

        ::

        ? x = 4 % 5; x + 1
        %11 = 5
        ? x = Mod(4,5); x + 1
        %12 = Mod(0,5)

        Note that such "modular" objects can be lifted via :literal:`lift` or
        :literal:`centerlift`. The modulus of a :literal:`t_INTMOD` or :literal:`t_POLMOD` :math:`z` can
        be recovered via :literal:`:math:`z`.mod`.
        '''
        b = objtogen(b)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = gmodulo(_a, _b)
        return new_gen(_ret)

    def Pol(t, v=None):
        r'''
        Transforms the object :math:`t` into a polynomial with main variable :math:`v`. If :math:`t`
        is a scalar, this gives a constant polynomial. If :math:`t` is a power series with
        nonnegative valuation or a rational function, the effect is similar to
        :literal:`truncate`, i.e. we chop off the :math:`O(X^{k})` or compute the Euclidean
        quotient of the numerator by the denominator, then change the main variable
        of the result to :math:`v`.

        The main use of this function is when :math:`t` is a vector: it creates the
        polynomial whose coefficients are given by :math:`t`, with :math:`t[1]` being the leading
        coefficient (which can be zero). It is much faster to evaluate
        :literal:`Pol` on a vector of coefficients in this way, than the corresponding
        formal expression :math:`a_{n} X^{n} +...+ a_{0}`, which is evaluated naively
        exactly as written (linear versus quadratic time in :math:`n`). :literal:`Polrev` can be
        used if one wants :math:`x[1]` to be the constant coefficient:

        ::

        ? Pol([1,2,3])
        %1 = x^2 + 2*x + 3
        ? Polrev([1,2,3])
        %2 = 3*x^2 + 2*x + 1

        The reciprocal function of :literal:`Pol` (resp. :literal:`Polrev`) is :literal:`Vec` (resp.
        :literal:`Vecrev`).

        ::

        ? Vec(Pol([1,2,3]))
        %1 = [1, 2, 3]
        ? Vecrev( Polrev([1,2,3]) )
        %2 = [1, 2, 3]

        :strong:`Warning.` This is :emphasis:`not` a substitution function. It will not
        transform an object containing variables of higher priority than :math:`v`.

        ::

        ? Pol(x + y, y)
        *** at top-level: Pol(x+y,y)
        *** ^----------
        *** Pol: variable must have higher priority in gtopoly.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = gtopoly(_t, _v)
        return new_gen(_ret)

    def Polrev(t, v=None):
        r'''
        Transform the object :math:`t` into a polynomial
        with main variable :math:`v`. If :math:`t` is a scalar, this gives a constant polynomial.
        If :math:`t` is a power series, the effect is identical to :literal:`truncate`, i.e. it
        chops off the :math:`O(X^{k})`.

        The main use of this function is when :math:`t` is a vector: it creates the
        polynomial whose coefficients are given by :math:`t`, with :math:`t[1]` being the
        constant term. :literal:`Pol` can be used if one wants :math:`t[1]` to be the leading
        coefficient:

        ::

        ? Polrev([1,2,3])
        %1 = 3*x^2 + 2*x + 1
        ? Pol([1,2,3])
        %2 = x^2 + 2*x + 3

        The reciprocal function of :literal:`Pol` (resp. :literal:`Polrev`) is :literal:`Vec` (resp.
        :literal:`Vecrev`).
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = gtopolyrev(_t, _v)
        return new_gen(_ret)

    def Qfb(a, b=None, c=None):
        r'''
        Creates the binary quadratic form
        :math:`ax^{2}+bxy+cy^{2}`. Negative definite forms are not implemented,
        use their positive definite counterpart instead.
        The syntax :literal:`Qfb(V)` is also allowed with :math:`V` being either
        a :literal:`t_VEC` :math:`[a,b,c]`, a :literal:`t_POL` :math:`ax^{2}+bx+c` or a :literal:`t_MAT`
        :math:`[a,b_{0};b_{1},c]` with :math:`b_{0}+b_{1} = b`.
        '''
        cdef bint _have_b = (b is not None)
        if _have_b:
            b = objtogen(b)
        cdef bint _have_c = (c is not None)
        if _have_c:
            c = objtogen(c)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = NULL
        if _have_b:
            _b = (<Gen>b).g
        cdef GEN _c = NULL
        if _have_c:
            _c = (<Gen>c).g
        cdef GEN _ret = Qfb0(_a, _b, _c)
        return new_gen(_ret)

    def Ser(s, v=None, d=None, long serprec=-1):
        r'''
        Transforms the object :math:`s` into a power series with main variable :math:`v`
        (:math:`x` by default) and precision (number of significant terms) equal to
        :math:`d >= 0` (:math:`d = seriesprecision` by default). If :math:`s` is a
        scalar, this gives a constant power series in :math:`v` with precision :literal:`d`.
        If :math:`s` is a polynomial, the polynomial is truncated to :math:`d` terms if needed

        ::

        ? \ps
        seriesprecision = 16 significant terms
        ? Ser(1) \\ 16 terms by default
        %1 = 1 + O(x^16)
        ? Ser(1, 'y, 5)
        %2 = 1 + O(y^5)
        ? Ser(x^2,, 5)
        %3 = x^2 + O(x^7)
        ? T = polcyclo(100)
        %4 = x^40 - x^30 + x^20 - x^10 + 1
        ? Ser(T, 'x, 11)
        %5 = 1 - x^10 + O(x^11)

        The function is more or less equivalent with multiplication by
        :math:`1 + O(v^{d})` in theses cases, only faster.

        For the remaining types, vectors and power series, we first explain what
        occurs if :math:`d` is omitted. In this case, the function uses exactly the amount
        of information given in the input:

        - If :math:`s` is already a power series in :math:`v`, we return it verbatim;

        - If :math:`s` is a vector, the coefficients of the vector are
        understood to be the coefficients of the power series starting from the
        constant term (as in :literal:`Polrev`:math:`(x)`); in other words we convert
        :literal:`t_VEC` / :literal:`t_COL` to the power series whose significant terms are exactly
        given by the vector entries.

        On the other hand, if :math:`d` is explicitly given, we abide by its value
        and return a series, truncated or extended with zeros as needed, with
        :math:`d` significant terms.

        ::

        ? v = [1,2,3];
        ? Ser(v, t) \\ 3 terms: seriesprecision is ignored!
        %7 = 1 + 2*t + 3*t^2 + O(t^3)
        ? Ser(v, t, 7) \\ 7 terms as explicitly requested
        %8 = 1 + 2*t + 3*t^2 + O(t^7)
        ? s = 1+x+O(x^2);
        ? Ser(s)
        %10 = 1 + x + O(x^2) \\ 2 terms: seriesprecision is ignored
        ? Ser(s, x, 7) \\ extend to 7 terms
        %11 = 1 + x + O(x^7)
        ? Ser(s, x, 1) \\ truncate to 1 term
        %12 = 1 + O(x)

        The warning given for :literal:`Pol` also applies here: this is not a substitution
        function.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        cdef bint _have_d = (d is not None)
        if _have_d:
            d = objtogen(d)
        sig_on()
        cdef GEN _s = (<Gen>s).g
        cdef GEN _d = NULL
        if _have_d:
            _d = (<Gen>d).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = Ser0(_s, _v, _d, serprec)
        return new_gen(_ret)

    def Set(x):
        r'''
        Converts :math:`x` into a set, i.e. into a row vector, with strictly increasing
        entries with respect to the (somewhat arbitrary) universal comparison function
        :literal:`cmp`. Standard container types :literal:`t_VEC`, :literal:`t_COL`, :literal:`t_LIST` and
        :literal:`t_VECSMALL` are converted to the set with corresponding elements. All
        others are converted to a set with one element.

        ::

        ? Set([1,2,4,2,1,3])
        %1 = [1, 2, 3, 4]
        ? Set(x)
        %2 = [x]
        ? Set(Vecsmall([1,3,2,1,3]))
        %3 = [1, 2, 3]
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtoset(_x)
        return new_gen(_ret)

    def Strchr(x):
        r'''
        Deprecated alias for strchr.
        '''
        from warnings import warn
        warn('the PARI/GP function Strchr is obsolete (2018-10-01)', DeprecationWarning)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = pari_strchr(_x)
        return new_gen(_ret)

    def Vec(x, long n=0):
        r'''
        Transforms the object :math:`x` into a row vector. The dimension of the
        resulting vector can be optionally specified via the extra parameter :math:`n`.
        If :math:`n` is omitted or :math:`0`, the dimension depends on the type of :math:`x`; the
        vector has a single component, except when :math:`x` is

        - a vector or a quadratic form: returns the initial object considered as a
        row vector,

        - a polynomial or a power series: returns a vector consisting of the
        coefficients. In the case of a polynomial, the coefficients of the vector
        start with the leading coefficient of the polynomial, while for power series
        only the significant coefficients are taken into account, but this time by
        increasing order of degree. In particular the valuation is ignored
        (which makes the function useful for series of negative valuation):

        ::

        ? Vec(3*x^2 + x)
        %1 = [3, 1, 0]
        ? Vec(x^2 + 3*x^3 + O(x^5))
        %2 = [1, 3, 0]
        ? Vec(x^-2 + 3*x^-1 + O(x))
        %3 = [1, 3, 0]

        :literal:`Vec` is the reciprocal function of :literal:`Pol` for a
        polynomial and of :literal:`Ser` for power series of valuation :math:`0`.

        - a matrix: returns the vector of columns comprising the matrix,

        ::

        ? m = [1,2,3;4,5,6]
        %4 =
        [1 2 3]
        
        [4 5 6]
        ? Vec(m)
        %5 = [[1, 4]~, [2, 5]~, [3, 6]~]

        - a character string: returns the vector of individual characters
        (as strings of length :math:`1`),

        ::

        ? Vec("PARI")
        %6 = ["P", "A", "R", "I"]

        - a map: returns the vector of the domain of the map,

        - an error context (:literal:`t_ERROR`): returns the error components, see
        :literal:`iferr`.

        In the last four cases (matrix, character string, map, error), :math:`n` is
        meaningless and must be omitted or an error is raised. Otherwise, if :math:`n` is
        given, :math:`0` entries are appended at the end of the vector if :math:`n > 0`, and
        prepended at the beginning if :math:`n < 0`. The dimension of the resulting vector
        is :math:`\|n\|`. If the original object had fewer than :math:`\|n\|` components, it is
        truncated from the right if :math:`n > 0` and from the left if :math:`n < 0`:

        ::

        ? v = [1,2,3,4];
        ? forstep(i=5, 2, -1, print(Vec(v, i)));
        [1, 2, 3, 4, 0]
        [1, 2, 3, 4]
        [1, 2, 3] \\ truncated from the right
        [1, 2]
        
        ? forstep(i=5, 2, -1, print(Vec(v, -i)));
        [0, 1, 2, 3, 4]
        [1, 2, 3, 4]
        [2, 3, 4] \\ truncated from the left
        [3, 4]

        These rules allow to write a conversion function for series that takes
        positive valuations into account:

        ::

        ? serVec(s) = Vec(s, -serprec(s,variable(s)));
        ? serVec(x^2 + 3*x^3 + O(x^5))
        %2 = [0, 0, 1, 3, 0]

        (That function is not intended for series of negative
        valuation.)
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtovec0(_x, n)
        return new_gen(_ret)

    def Vecrev(x, long n=0):
        r'''
        As :math:`Vec (x, -n)`, then reverse the result. In particular,
        :literal:`Vecrev` is the reciprocal function of :literal:`Polrev`: the
        coefficients of the vector start with the constant coefficient of the
        polynomial and the others follow by increasing degree.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtovecrev0(_x, n)
        return new_gen(_ret)

    def Vecsmall(x, long n=0):
        r'''
        Transforms the object :math:`x` into a row vector of type :literal:`t_VECSMALL`. The
        dimension of the resulting vector can be optionally specified via the extra
        parameter :math:`n`.

        This acts as :literal:`Vec`:math:`(x,n)`, but only on a limited set of objects:
        the result must be representable as a vector of small integers.
        If :math:`x` is a character string, a vector of individual characters in ASCII
        encoding is returned (:literal:`strchr` yields back the character string).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtovecsmall0(_x, n)
        return new_gen(_ret)

    def abs(x, long precision=DEFAULT_BITPREC):
        r'''
        Absolute value of :math:`x` (modulus if :math:`x` is complex).
        Rational functions are not allowed. Contrary to most transcendental
        functions, an exact argument is :emphasis:`not` converted to a real number before
        applying :literal:`abs` and an exact result is returned if possible.

        ::

        ? abs(-1)
        %1 = 1
        ? abs(3/7 + 4/7*I)
        %2 = 5/7
        ? abs(1 + I)
        %3 = 1.414213562373095048801688724

        If :math:`x` is a polynomial, returns :math:`-x` if the leading coefficient is
        real and negative else returns :math:`x`. For a power series, the constant
        coefficient is considered instead.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gabs(_x, precision)
        return new_gen(_ret)

    def acos(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of :math:`\cos^{-1}(x) = -i \log (x + i\sqrt{1-x^{2}})`.
        In particular, :math:`\Re (acos(x))\in [0,\pi]` and if :math:`x\in \mathbb{R}` and :math:`\|x\| > 1`,
        then :math:`acos(x)` is complex. The branch cut is in two pieces:
        :math:`]- oo ,-1]` , continuous with quadrant II, and :math:`[1,+ oo [`, continuous
        with quadrant IV. We have :math:`acos(x) = \pi/2 - asin(x)` for all
        :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gacos(_x, precision)
        return new_gen(_ret)

    def acosh(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of :math:`\cosh^{-1}(x) = 2
        \log (\sqrt{(x+1)/2} + \sqrt{(x-1)/2})`. In particular,
        :math:`\Re (acosh(x)) >= 0` and
        :math:`\Im (acosh(x))\in ]-\pi,\pi]`; if :math:`x\in \mathbb{R}` and :math:`x < 1`, then
        :math:`acosh(x)` is complex.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gacosh(_x, precision)
        return new_gen(_ret)

    def addprimes(x):
        r'''
        Adds the integers contained in the
        vector :math:`x` (or the single integer :math:`x`) to a special table of
        "user-defined primes", and returns that table. Whenever :literal:`factor` is
        subsequently called, it will trial divide by the elements in this table.
        If :math:`x` is empty or omitted, just returns the current list of extra
        primes.

        ::

        ? addprimes(37975227936943673922808872755445627854565536638199)
        ? factor(15226050279225333605356183781326374297180681149613806\
        88657908494580122963258952897654000350692006139)
        %2 =
        [37975227936943673922808872755445627854565536638199 1]
        
        [40094690950920881030683735292761468389214899724061 1]
        ? ##
        *** last result computed in 0 ms.

        The entries in :math:`x` must be primes: there is no internal check, even if
        the :literal:`factor_proven` default is set. To remove primes from the list use
        :literal:`removeprimes`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = addprimes(_x)
        return new_gen(_ret)

    def agm(x, y, long precision=DEFAULT_BITPREC):
        r'''
        Arithmetic-geometric mean of :math:`x` and :math:`y`. In the
        case of complex or negative numbers, the optimal AGM is returned
        (the largest in absolute value over all choices of the signs of the square
        roots). :math:`p`-adic or power series arguments are also allowed. Note that
        a :math:`p`-adic agm exists only if :math:`x/y` is congruent to 1 modulo :math:`p` (modulo
        16 for :math:`p = 2`). :math:`x` and :math:`y` cannot both be vectors or matrices.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        precision = nbits2prec(precision)
        cdef GEN _ret = agm(_x, _y, precision)
        return new_gen(_ret)

    def airy(z, long precision=DEFAULT_BITPREC):
        r'''
        Airy :math:`[Ai,Bi]` functions of argument :math:`z`.

        ::

        ? [A,B] = airy(1);
        ? A
        %2 = 0.13529241631288141552414742351546630617
        ? B
        %3 = 1.2074235949528712594363788170282869954
        '''
        sig_on()
        cdef GEN _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = airy(_z, precision)
        return new_gen(_ret)

    def algadd(al, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`al` (Hamilton quaternions if
        omitted), computes their sum :math:`x+y` in the algebra :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y),[-1,1]);
        ? algadd(A,[1,x]~,[1,2,3,4]~)
        % = [2, 1, 1, 6]~
        ? algadd(,sqrt(2+I),[-1,0,1,2]~)
        % = [0.4553466902, 0.3435607497, 1, 2]~

        Also accepts matrices with coefficients in :emphasis:`al`.

        If :math:`x` and :math:`y` are given in the same format, then one should simply use :literal:`+`
        instead of :literal:`algadd`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = algadd(_al, _x, _y)
        return new_gen(_ret)

    def algalgtobasis(al, x):
        r'''
        Given an element :emphasis:`x` in the central simple algebra :emphasis:`al` output
        by :literal:`alginit`, transforms it to a column vector on the integral basis of
        :emphasis:`al`. This is the inverse function of :literal:`algbasistoalg`.

        ::

        ? A = alginit(nfinit(y^2-5),[2,y]);
        ? algalgtobasis(A,[y,1]~)
        %2 = [0, 2, 0, -1, 2, 0, 0, 0]~
        ? algbasistoalg(A,algalgtobasis(A,[y,1]~))
        %3 = [Mod(Mod(y, y^2 - 5), x^2 - 2), 1]~
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algalgtobasis(_al, _x)
        return new_gen(_ret)

    def algaut(al):
        r'''
        Given a cyclic algebra :math:`al = (L/K,\sigma,b)` output by
        :literal:`alginit`, returns the automorphism :math:`\sigma`.

        ::

        ? nf = nfinit(y);
        ? p = idealprimedec(nf,7)[1];
        ? p2 = idealprimedec(nf,11)[1];
        ? A = alginit(nf,[3,[[p,p2],[1/3,2/3]],[0]]);
        ? algaut(A)
        %5 = -1/3*x^2 + 1/3*x + 26/3
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algaut(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algb(al):
        r'''
        Given a cyclic algebra :math:`al = (L/K,\sigma,b)` output by
        :literal:`alginit`, returns the element :math:`b\in K`.

        ::

        nf = nfinit(y);
        ? p = idealprimedec(nf,7)[1];
        ? p2 = idealprimedec(nf,11)[1];
        ? A = alginit(nf,[3,[[p,p2],[1/3,2/3]],[0]]);
        ? algb(A)
        %5 = Mod(-77, y)
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algb(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algbasis(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, returns
        a :math:`\mathbb{Z}`-basis of the order :math:`O_{0}` stored in :emphasis:`al` with respect to the
        natural order in :emphasis:`al`. It is a maximal order if one has been computed.

        ::

        A = alginit(nfinit(y), [-1,-1]);
        ? algbasis(A)
        %2 =
        [1 0 0 1/2]
        
        [0 1 0 1/2]
        
        [0 0 1 1/2]
        
        [0 0 0 1/2]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algbasis(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algbasistoalg(al, x):
        r'''
        Given an element :emphasis:`x` in the central simple algebra :emphasis:`al` output
        by :literal:`alginit`, transforms it to its algebraic representation in :emphasis:`al`.
        This is the inverse function of :literal:`algalgtobasis`.

        ::

        ? A = alginit(nfinit(y^2-5),[2,y]);
        ? z = algbasistoalg(A,[0,1,0,0,2,-3,0,0]~);
        ? liftall(z)
        %3 = [(-1/2*y - 2)*x + (-1/4*y + 5/4), -3/4*y + 7/4]~
        ? algalgtobasis(A,z)
        %4 = [0, 1, 0, 0, 2, -3, 0, 0]~
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algbasistoalg(_al, _x)
        return new_gen(_ret)

    def algcenter(al):
        r'''
        If :emphasis:`al` is a table algebra output by :literal:`algtableinit`, returns a
        basis of the center of the algebra :emphasis:`al` over its prime field (:math:`\mathbb{Q}` or
        :math:`\mathbb{F}_{p}`). If :emphasis:`al` is a central simple algebra output by :literal:`alginit`,
        returns the center of :emphasis:`al`, which is stored in :emphasis:`al`.

        A simple example: the :math:`2 x 2` upper triangular matrices over :math:`\mathbb{Q}`,
        generated by :math:`I_{2}`, :math:`a = [0,1;0,0]` and :math:`b = [0,0;0,1]`,
        such that :math:`a^{2} = 0`, :math:`ab = a`, :math:`ba = 0`, :math:`b^{2} = b`: the diagonal matrices
        form the center.

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? A = algtableinit(mt);
        ? algcenter(A) \\ = (I_2)
        %3 =
        [1]
        
        [0]
        
        [0]

        An example in the central simple case:

        ::

        ? nf = nfinit(y^3-y+1);
        ? A = alginit(nf, [-1,-1]);
        ? algcenter(A).pol
        %3 = y^3 - y + 1
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algcenter(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algcentralproj(al, z, long maps=0):
        r'''
        Given a table algebra :emphasis:`al` output by :literal:`algtableinit` and a
        :literal:`t_VEC` :math:`z = [z_{1},...,z_{n}]` of orthogonal central idempotents,
        returns a :literal:`t_VEC` :math:`[al_{1},...,al_{n}]` of algebras such that
        :math:`al_{i} = z_{i} al`. If :math:`maps = 1`, each :math:`al_{i}` is a :literal:`t_VEC`
        :math:`[quo,proj,lift]` where :emphasis:`quo` is the quotient algebra, :emphasis:`proj` is a
        :literal:`t_MAT` representing the projection onto this quotient and :emphasis:`lift` is a
        :literal:`t_MAT` representing a lift.

        A simple example: :math:`\mathbb{F}_{2} x \mathbb{F}_{4}`, generated by :math:`1 = (1,1)`, :math:`e = (1,0)`
        and :math:`x` such that :math:`x^{2}+x+1 = 0`. We have :math:`e^{2} = e`, :math:`x^{2} = x+1` and :math:`ex = 0`.

        ::

        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2);
        ? e = [0,1,0]~;
        ? e2 = algsub(A,[1,0,0]~,e);
        ? [a,a2] = algcentralproj(A,[e,e2]);
        ? algdim(a)
        %6 = 1
        ? algdim(a2)
        %7 = 2
        '''
        z = objtogen(z)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _z = (<Gen>z).g
        cdef GEN _ret = alg_centralproj(_al, _z, maps)
        return new_gen(_ret)

    def algchar(al):
        r'''
        Given an algebra :emphasis:`al` output by :literal:`alginit` or :literal:`algtableinit`,
        returns the characteristic of :emphasis:`al`.

        ::

        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,13);
        ? algchar(A)
        %3 = 13
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algchar(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algcharpoly(al, b, v=None, long abs=0):
        r'''
        Given an element :math:`b` in :emphasis:`al` (Hamilton quaternions if omitted), returns
        its characteristic polynomial as a polynomial in the variable :math:`v`. If :emphasis:`al`
        is a table algebra output by :literal:`algtableinit` or if :math:`abs = 1`, returns the
        absolute characteristic polynomial of :emphasis:`b`, which is an element of
        :math:`\mathbb{F}_{p}[v]`, :math:`\mathbb{Q}[v]` or :math:`\mathbb{R}[v]`; if :emphasis:`al` is omitted or a central simple
        algebra output by :literal:`alginit` and :math:`abs = 0`, returns the reduced characteristic
        polynomial of :emphasis:`b`, which is an element of :math:`K[v]` where :math:`K` is the center of
        :emphasis:`al`.

        ::

        ? al = alginit(nfinit(y), [-1,-1]); \\ (-1,-1)_Q
        ? algcharpoly(al, [0,1]~)
        %2 = x^2 + 1
        ? algcharpoly(al, [0,1]~,,1)
        %3 = x^4 + 2*x^2 + 1
        ? nf = nfinit(y^2-5);
        ? al = alginit(nf,[-1,y]);
        ? a = [y,1+x]~*Mod(1,y^2-5)*Mod(1,x^2+1);
        ? P = lift(algcharpoly(al,a))
        %7 = x^2 - 2*y*x + (-2*y + 5)
        ? algcharpoly(al,a,,1)
        %8 = x^8 - 20*x^6 - 80*x^5 + 110*x^4 + 800*x^3 + 1500*x^2 - 400*x + 25
        ? lift(P*subst(P,y,-y)*Mod(1,y^2-5))^2
        %9 = x^8 - 20*x^6 - 80*x^5 + 110*x^4 + 800*x^3 + 1500*x^2 - 400*x + 25
        ? algcharpoly(,[sqrt(2),-1,0,Pi]~) \\ Hamilton quaternions
        %10 = x^2 - 2.8284271247*x + 12.8696044010

        Also accepts a square matrix with coefficients in :emphasis:`al`.
        '''
        b = objtogen(b)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = algcharpoly(_al, _b, _v, abs)
        return new_gen(_ret)

    def algdegree(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, returns
        the degree of :emphasis:`al`.

        ::

        ? nf = nfinit(y^3-y+1);
        ? A = alginit(nf, [-1,-1]);
        ? algdegree(A)
        %3 = 2
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef long _ret = algdegree(_al)
        clear_stack()
        return _ret

    def algdep(z, long k, long flag=0):
        r'''
        :math:`z` being real/complex, or :math:`p`-adic, finds a polynomial (in the variable
        :literal:`'x`) of degree at most
        :math:`k`, with integer coefficients, having :math:`z` as approximate root. Note that the
        polynomial which is obtained is not necessarily the "correct" one. In fact
        it is not even guaranteed to be irreducible. One can check the closeness
        either by a polynomial evaluation (use :literal:`subst`), or by computing the
        roots of the polynomial given by :literal:`algdep` (use :literal:`polroots` or
        :literal:`polrootspadic`).

        Internally, :literal:`lindep`:math:`([1,z,...,z^{k}], flag)` is used. A nonzero value of
        :math:`flag` may improve on the default behavior if the input number is known to a
        :emphasis:`huge` accuracy, and you suspect the last bits are incorrect: if :math:`flag > 0`
        the computation is done with an accuracy of :math:`flag` decimal digits; to get
        meaningful results, the parameter :math:`flag` should be smaller than the number of
        correct decimal digits in the input. But default values are usually
        sufficient, so try without :math:`flag` first:

        ::

        ? \p200
        ? z = 2^(1/6)+3^(1/5);
        ? algdep(z, 30); \\ right in 63ms
        ? algdep(z, 30, 100); \\ wrong in 39ms
        ? algdep(z, 30, 170); \\ right in 61ms
        ? algdep(z, 30, 200); \\ wrong in 146ms
        ? \p250
        ? z = 2^(1/6)+3^(1/5); \\ recompute to new, higher, accuracy !
        ? algdep(z, 30); \\ right in 68ms
        ? algdep(z, 30, 200); \\ right in 68ms
        ? \p500
        ? algdep(2^(1/6)+3^(1/5), 30); \\ right in 138ms
        ? \p1000
        ? algdep(2^(1/6)+3^(1/5), 30); \\ right in 276s

        The changes in :literal:`realprecision` only affect the quality of the
        initial approximation to :math:`2^{1/6} + 3^{1/5}`, :literal:`algdep` itself uses
        exact operations. The size of its operands depend on the accuracy of the
        input of course: a more accurate input means slower operations.

        Proceeding by increments of 5 digits of accuracy, :literal:`algdep` with default
        flag produces its first correct result at 195 digits, and from then on a
        steady stream of correct results:

        ::

        \\ assume T contains the correct result, for comparison
        forstep(d=100, 250, 5, \
        localprec(d); \
        print(d, " ", algdep(2^(1/6)+3^(1/5),30) == T))

        This example is the test case studied in a 2000 paper by Borwein and
        Lisonek: Applications of integer relation algorithms, :emphasis:`Discrete Math.`,
        :strong:`217`, p. 65--82. The version of PARI tested there was 1.39, which
        succeeded reliably from precision 265 on, in about 1000 as much time as the
        current version (on slower hardware of course).

        Note that this function does not work if :math:`z` is a power series. The function
        :literal:`seralgdep` can be used in this case to find linear relations wich
        polynomial coefficients between powers of :math:`z`.
        '''
        sig_on()
        cdef GEN _z = (<Gen>z).g
        cdef GEN _ret = algdep0(_z, k, flag)
        return new_gen(_ret)

    def algdim(al, long abs=0):
        r'''
        If :emphasis:`al` is a table algebra output by :literal:`algtableinit` or if :math:`abs = 1`,
        returns the dimension of :emphasis:`al` over its prime subfield (:math:`\mathbb{Q}` or :math:`\mathbb{F}_{p}`) or
        over :math:`\mathbb{R}` for real algebras.
        If :emphasis:`al` is a central simple algebra output by :literal:`alginit` and :math:`abs = 0`,
        returns the dimension of :emphasis:`al` over its center.

        ::

        ? nf = nfinit(y^3-y+1);
        ? A = alginit(nf, [-1,-1]);
        ? algdim(A)
        %3 = 4
        ? algdim(A,1)
        %4 = 12
        ? C = alginit(I,0); \\ complex numbers as a real algebra
        ? algdim(C,1)
        %6 = 2
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef long _ret = algdim(_al, abs)
        clear_stack()
        return _ret

    def algdisc(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, computes
        the discriminant of the order :math:`O_{0}` stored in :emphasis:`al`, that is the
        determinant of the trace form :math:`\rm{Tr} : O_{0} x O_{0}
        \to \mathbb{Z}`.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-3,1-y]);
        ? [PR,h] = alghassef(A)
        %3 = [[[2, [2, 0]~, 1, 2, 1], [3, [3, 0]~, 1, 2, 1]], Vecsmall([0, 1])]
        ? n = algdegree(A);
        ? D = algdim(A,1);
        ? h = vector(#h, i, n - gcd(n,h[i]));
        ? n^D * nf.disc^(n^2) * idealnorm(nf, idealfactorback(nf,PR,h))^n
        %4 = 12960000
        ? algdisc(A)
        %5 = 12960000
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algdisc(_al)
        return new_gen(_ret)

    def algdivl(al, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`al` (Hamilton quaternions if
        omitted), computes their left quotient :math:`x\backslash y` in the algebra :emphasis:`al`:
        an element :math:`z` such that :math:`xz = y` (such an element is not unique when :math:`x` is a
        zerodivisor). If :math:`x` is invertible, this is the same as :math:`x^{-1}y`. Assumes that
        :math:`y` is left divisible by :math:`x` (i.e. that :math:`z` exists). Also accepts square
        matrices with coefficients in :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y),[-1,1]);
        ? x = [1,1]~; algisinv(A,x)
        % = 0
        ? z = algmul(A,x,algrandom(A,2))
        % = [0, 0, 0, 8]~
        ? algdivl(A,x,z)
        % = [4, 4, 0, 0]~
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = algdivl(_al, _x, _y)
        return new_gen(_ret)

    def algdivr(al, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`al` (Hamilton quaternions if
        omitted), returns :math:`xy^{-1}`. Also accepts square matrices with coefficients in
        :emphasis:`al`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = algdivr(_al, _x, _y)
        return new_gen(_ret)

    def alggroup(gal, p=None):
        r'''
        Initializes the group algebra :math:`K[G]` over :math:`K = \mathbb{Q}` (:math:`p` omitted) or :math:`\mathbb{F}_{p}`
        where :math:`G` is the underlying group of the :literal:`galoisinit` structure :emphasis:`gal`.
        The input :emphasis:`gal` is also allowed to be a :literal:`t_VEC` of permutations that is
        closed under products.

        Example:

        ::

        ? K = nfsplitting(x^3-x+1);
        ? gal = galoisinit(K);
        ? al = alggroup(gal);
        ? algissemisimple(al)
        %4 = 1
        ? G = [Vecsmall([1,2,3]), Vecsmall([1,3,2])];
        ? al2 = alggroup(G, 2);
        ? algissemisimple(al2)
        %8 = 0
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = alggroup(_gal, _p)
        return new_gen(_ret)

    def alggroupcenter(gal, p=None, cc=None):
        r'''
        Initializes the center :math:`Z(K[G])` of the group algebra :math:`K[G]` over :math:`K = \mathbb{Q}`
        (:math:`p = 0` or omitted) or :math:`\mathbb{F}_{p}` where :math:`G` is the underlying group of the
        :literal:`galoisinit` structure :emphasis:`gal`. The input :emphasis:`gal` is also allowed to
        be a :literal:`t_VEC` of permutations that is closed under products.
        Sets :emphasis:`cc` to a :literal:`t_VEC` :math:`[elts,conjclass,rep,flag]`
        where :emphasis:`elts` is a sorted :literal:`t_VEC` containing the list of elements
        of :math:`G`, :emphasis:`conjclass` is a :literal:`t_VECSMALL` of the same length as :emphasis:`elts`
        containing the index of the conjugacy class of the corresponding element (an
        integer between :math:`1` and the number of conjugacy classes), and :emphasis:`rep` is a
        :literal:`t_VECSMALL` of length the number of conjugacy classes giving for each
        conjugacy class the index in :emphasis:`elts` of a representative of this conjugacy
        class. Finally :emphasis:`flag` is :math:`1` if and only if the permutation
        representation of :math:`G` is transitive, in which case the :math:`i`-th element
        of :emphasis:`elts` is characterized by :math:`g[1] = i`; this is always the case
        when :emphasis:`gal` is a :literal:`galoisinit` structure. The basis of :math:`Z(K[G])` as
        output consists of the indicator functions of the conjugacy classes in the
        ordering given by :emphasis:`cc`. Example:

        ::

        ? K = nfsplitting(x^4+x+1);
        ? gal = galoisinit(K); \\ S4
        ? al = alggroupcenter(gal,,&cc);
        ? algiscommutative(al)
        %4 = 1
        ? #cc[3] \\ number of conjugacy classes of S4
        %5 = 5
        ? gal = [Vecsmall([1,2,3]),Vecsmall([1,3,2])]; \\ C2
        ? al = alggroupcenter(gal,,&cc);
        ? cc[3]
        %8 = Vecsmall([1, 2])
        ? cc[4]
        %9 = 0
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        cdef bint _have_cc = (cc is not None)
        if _have_cc:
            raise NotImplementedError("optional argument cc not available")
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN * _cc = NULL
        cdef GEN _ret = alggroupcenter(_gal, _p, _cc)
        return new_gen(_ret)

    def alghasse(al, pl=None):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit` and a prime
        ideal or an integer between :math:`1` and :math:`r_{1}+r_{2}`, returns a :literal:`t_FRAC` :math:`h` : the
        local Hasse invariant of :emphasis:`al` at the place specified by :emphasis:`pl`.
        If :emphasis:`al` is an algebra over :math:`\mathbb{R}`, returns the Hasse invariant of :emphasis:`al`

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? alghasse(A, 1)
        %3 = 1/2
        ? alghasse(A, 2)
        %4 = 0
        ? alghasse(A, idealprimedec(nf,2)[1])
        %5 = 1/2
        ? alghasse(A, idealprimedec(nf,5)[1])
        %6 = 0
        ? H = alginit(1.,1/2); \\ Hamilton quaternion algebra
        ? alghasse(H)
        %8 = 1/2
        '''
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        cdef GEN _ret = alghasse(_al, _pl)
        return new_gen(_ret)

    def alghassef(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, returns
        a :literal:`t_VEC` :math:`[PR, h_{f}]` describing the local Hasse invariants at the
        finite places of the center: :literal:`PR` is a :literal:`t_VEC` of primes and :math:`h_{f}` is a
        :literal:`t_VECSMALL` of integers modulo the degree :math:`d` of :emphasis:`al`. The Hasse
        invariant of :emphasis:`al` at the primes outside :literal:`PR` is :math:`0`, but :literal:`PR` can
        include primes at which the Hasse invariant is :math:`0`.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,2*y-1]);
        ? [PR,hf] = alghassef(A);
        ? PR
        %4 = [[19, [10, 2]~, 1, 1, [-8, 2; 2, -10]], [2, [2, 0]~, 1, 2, 1]]
        ? hf
        %5 = Vecsmall([1, 0])
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = alghassef(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def alghassei(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, returns
        a :literal:`t_VECSMALL` :math:`h_{i}` of :math:`r_{1}` integers modulo the degree :math:`d` of :emphasis:`al`,
        where :math:`r_{1}` is the number of real places of the center: the local Hasse
        invariants of :emphasis:`al` at infinite places.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? alghassei(A)
        %3 = Vecsmall([1, 0])
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = alghassei(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algindex(al, pl=None):
        r'''
        Returns the index of the central simple algebra :math:`A` over :math:`K` (as output by
        alginit), that is the degree :math:`e` of the unique central division algebra :math:`D`
        over :math:`K` such that :math:`A` is isomorphic to some matrix algebra :math:`M_{k}(D)`. If
        :emphasis:`pl` is set, it should be a prime ideal of :math:`K` or an integer between :math:`1`
        and :math:`r_{1}+r_{2}`, and in that case return the local index at the place
        :emphasis:`pl` instead.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? algindex(A, 1)
        %3 = 2
        ? algindex(A, 2)
        %4 = 1
        ? algindex(A, idealprimedec(nf,2)[1])
        %5 = 2
        ? algindex(A, idealprimedec(nf,5)[1])
        %6 = 1
        ? algindex(A)
        %7 = 2
        '''
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        cdef long _ret = algindex(_al, _pl)
        clear_stack()
        return _ret

    def alginit(B, C, v=None, long flag=3):
        r'''
        Initializes the central simple algebra defined by data :math:`B`, :math:`C` and
        variable :math:`v`, as follows.

        - (multiplication table) :math:`B` is the base number field :math:`K` in :literal:`nfinit`
        form, :math:`C` is a "multiplication table" over :math:`K`.
        As a :math:`K`-vector space, the algebra is generated by a basis
        :math:`(e_{1} = 1,..., e_{n})`; the table is given as a :literal:`t_VEC` of :math:`n` matrices
        in :math:`M_{n}(K)`, giving the left multiplication by the basis elements :math:`e_{i}`,
        in the given basis.
        Assumes that :math:`e_{1} = 1`, that the multiplication table is integral, and that
        :math:`(\bigoplus_{i = 1}^{n}K e_{i},C)` describes a central simple algebra over :math:`K`.

        ::

        { mi = [0,-1,0, 0;
        1, 0,0, 0;
        0, 0,0,-1;
        0, 0,1, 0];
        mj = [0, 0,-1,0;
        0, 0, 0,1;
        1, 0, 0,0;
        0,-1, 0,0];
        mk = [0, 0, 0, -1;
        0, 0,-1, 0;
        0, 1, 0, 0;
        1, 0, 0, 0];
        A = alginit(nfinit(y), [matid(4), mi,mj,mk], , 0); }

        represents (in a complicated way) the quaternion algebra :math:`(-1,-1)_{\mathbb{Q}}`.
        See below for a simpler solution.

        - (cyclic algebra) :math:`B` is an :literal:`rnf` structure attached to a cyclic
        number field extension :math:`L/K` of degree :math:`d`, :math:`C` is a :literal:`t_VEC`
        :literal:`[sigma,b]` with 2 components: :literal:`sigma` is a :literal:`t_POLMOD` representing
        an automorphism generating :math:`Gal(L/K)`, :math:`b` is an element in :math:`K^{*}`.
        This represents the cyclic algebra :math:`(L/K,\sigma,b)`. Currently the element
        :math:`b` has to be integral.

        ::

        ? Q = nfinit(y); T = polcyclo(5, 'x); F = rnfinit(Q, T);
        ? A = alginit(F, [Mod(x^2,T), 3]);

        defines the cyclic algebra :math:`(L/\mathbb{Q}, \sigma, 3)`, where
        :math:`L = \mathbb{Q} (\zeta_{5})` and :math:`\sigma:\zeta:--->\zeta^{2}` generates
        :math:`Gal(L/\mathbb{Q})`.

        - (quaternion algebra, special case of the above) :math:`B` is an :literal:`nf`
        structure attached to a number field :math:`K`, :math:`C = [a,b]` is a vector
        containing two elements of :math:`K^{*}` with :math:`a` not a square in :math:`K`, returns the
        quaternion algebra :math:`(a,b)_{K}`.
        The variable :math:`v` (:literal:`'x` by default) must have higher priority than the
        variable of :math:`K`:literal:`.pol` and is used to represent elements in the splitting
        field :math:`L = K[x]/(x^{2}-a)`.

        ::

        ? Q = nfinit(y); A = alginit(Q, [-1,-1]); \\ (-1,-1)_{Q}

        - (algebra/:math:`K` defined by local Hasse invariants)
        :math:`B` is an :literal:`nf` structure attached to a number field :math:`K`,
        :math:`C = [d, [PR,h_{f}], h_{i}]` is a triple
        containing an integer :math:`d > 1`, a pair :math:`[PR, h_{f}]` describing the
        Hasse invariants at finite places, and :math:`h_{i}` the Hasse invariants
        at archimedean (real) places. A local Hasse invariant belongs to :math:`(1/d)\mathbb{Z}/\mathbb{Z}
        \subset \mathbb{Q}/\mathbb{Z}`, and is given either as a :literal:`t_FRAC` (lift to :math:`(1/d)\mathbb{Z}`),
        a :literal:`t_INT` or :literal:`t_INTMOD` modulo :math:`d` (lift to :math:`\mathbb{Z}/d\mathbb{Z}`); a whole vector
        of local invariants can also be given as a :literal:`t_VECSMALL`, whose
        entries are handled as :literal:`t_INT` s. :literal:`PR` is a list of prime ideals
        (:literal:`prid` structures), and :math:`h_{f}` is a vector of the same length giving the
        local invariants at those maximal ideals. The invariants at infinite real
        places are indexed by the real roots :math:`K`:literal:`.roots`: if the Archimedean
        place :math:`v` is attached to the :math:`j`-th root, the value of
        :math:`h_{v}` is given by :math:`h_{i}[j]`, must be :math:`0` or :math:`1/2` (or :math:`d/2` modulo :math:`d`), and
        can be nonzero only if :math:`d` is even.

        By class field theory, provided the local invariants :math:`h_{v}` sum to :math:`0`, up
        to Brauer equivalence, there is a unique central simple algebra over :math:`K`
        with given local invariants and trivial invariant elsewhere. In particular,
        up to isomorphism, there is a unique such algebra :math:`A` of degree :math:`d`.

        We realize :math:`A` as a cyclic algebra through class field theory. The variable :math:`v`
        (:literal:`'x` by default) must have higher priority than the variable of
        :math:`K`:literal:`.pol` and is used to represent elements in the (cyclic) splitting
        field extension :math:`L/K` for :math:`A`.

        ::

        ? nf = nfinit(y^2+1);
        ? PR = idealprimedec(nf,5); #PR
        %2 = 2
        ? hi = [];
        ? hf = [PR, [1/3,-1/3]];
        ? A = alginit(nf, [3,hf,hi]);
        ? algsplittingfield(A).pol
        %6 = x^3 - 21*x + 7

        - (matrix algebra, toy example) :math:`B` is an :literal:`nf` structure attached
        to a number field :math:`K`, :math:`C = d` is a positive integer. Returns a cyclic
        algebra isomorphic to the matrix algebra :math:`M_{d}(K)`.

        - (algebras over :math:`\mathbb{R}`) If :math:`B` is a :literal:`t_REAL` and :math:`C = 1/2`, returns
        a structure representing the Hamilton quaternion algebra :math:`H =
        (-1,-1)_{\mathbb{R}}`. If :math:`B` is a :literal:`t_REAL` and :math:`C = 0`, returns an algebra structure
        representing :math:`\mathbb{R}`. If :math:`B` is a :literal:`t_COMPLEX` and :math:`C = 0`, returns an algebra
        structure representing :math:`\mathbb{C}`.

        In all cases over a number field, this function factors various discriminants
        and computes a maximal order for the algebra by default, which may require a
        lot of time. This can be controlled by :math:`flag`, whose binary digits mean:

        - :math:`1`: compute a maximal order.

        - :math:`2`: fully factor the discriminants instead of using a lazy
        factorisation. If this digit of :math:`flag` is set to :math:`0`, the local Hasse invariants
        are not computed.

        If only a partial factorisation is known, the computed order is only guaranteed
        to be maximal at the known prime factors.

        The pari object representing such an algebra :math:`A` is a :literal:`t_VEC` with the
        following data:

        - A splitting field :math:`L` of :math:`A` of the same degree over :math:`K` as :math:`A`, in
        :literal:`rnfinit` format, accessed with :literal:`algsplittingfield`.

        - The Hasse invariants at the real places of :math:`K`, accessed with
        :literal:`alghassei`.

        - The Hasse invariants of :math:`A` at the finite primes of :math:`K` that ramify in
        the natural order of :math:`A`, accessed with :literal:`alghassef`.

        - A basis of an order :math:`O_{0}` expressed on the basis of the natural
        order, accessed with :literal:`algbasis`.

        - A basis of the natural order expressed on the basis of :math:`O_{0}`,
        accessed with :literal:`alginvbasis`.

        - The left multiplication table of :math:`O_{0}` on the previous basis,
        accessed with :literal:`algmultable`.

        - The characteristic of :math:`A` (always :math:`0`), accessed with :literal:`algchar`.

        - The absolute traces of the elements of the basis of :math:`O_{0}`.

        - If :math:`A` was constructed as a cyclic algebra :math:`(L/K,\sigma,b)` of degree
        :math:`d`, a :literal:`t_VEC` :math:`[\sigma,\sigma^{2},...,\sigma^{d-1}]`. The function
        :literal:`algaut` returns :math:`\sigma`.

        - If :math:`A` was constructed as a cyclic algebra :math:`(L/K,\sigma,b)`, the
        element :math:`b`, accessed with :literal:`algb`.

        - If :math:`A` was constructed with its multiplication table :math:`mt` over :math:`K`,
        the :literal:`t_VEC` of :literal:`t_MAT` :math:`mt`, accessed with :literal:`algrelmultable`.

        - If :math:`A` was constructed with its multiplication table :math:`mt` over :math:`K`,
        a :literal:`t_VEC` with three components: a :literal:`t_COL` representing an element of :math:`A`
        generating the splitting field :math:`L` as a maximal subfield of :math:`A`, a :literal:`t_MAT`
        representing an :math:`L`-basis :math:`B` of :math:`A` expressed on the :math:`\mathbb{Z}`-basis of
        :math:`O_{0}`, and a :literal:`t_MAT` representing the :math:`\mathbb{Z}`-basis of :math:`O_{0}`
        expressed on :math:`B`. This data is accessed with :literal:`algsplittingdata`.
        '''
        C = objtogen(C)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _B = (<Gen>B).g
        cdef GEN _C = (<Gen>C).g
        cdef GEN _ret = alginit(_B, _C, _v, flag)
        return new_gen(_ret)

    def alginv(al, x):
        r'''
        Given an element :math:`x` in :emphasis:`al` (Hamilton quaternions if omitted),
        computes its inverse :math:`x^{-1}` in the algebra :emphasis:`al`. Assumes that :math:`x` is
        invertible.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? alginv(A,[1,1,0,0]~)
        %2 = [1/2, 1/2, 0, 0]~
        ? alginv(,[1,0,Pi,sqrt(2)]~) \\ Hamilton quaternions
        %3 = [0.0777024661, 0, -0.2441094967, -0.1098878814]~

        Also accepts square matrices with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = alginv(_al, _x)
        return new_gen(_ret)

    def alginvbasis(al):
        r'''
        Given an central simple algebra :emphasis:`al` output by :literal:`alginit`, returns
        a :math:`\mathbb{Z}`-basis of the natural order in :emphasis:`al` with respect to the
        order :math:`O_{0}` stored in :emphasis:`al`.

        ::

        A = alginit(nfinit(y), [-1,-1]);
        ? alginvbasis(A)
        %2 =
        [1 0 0 -1]
        
        [0 1 0 -1]
        
        [0 0 1 -1]
        
        [0 0 0 2]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = alginvbasis(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algisassociative(mt, p=None):
        r'''
        Returns 1 if the multiplication table :literal:`mt` is suitable for
        :literal:`algtableinit(mt,p)`, 0 otherwise. More precisely, :literal:`mt` should be
        a :literal:`t_VEC` of :math:`n` matrices in :math:`M_{n}(K)`, giving the left multiplications
        by the basis elements :math:`e_{1},..., e_{n}` (structure constants).
        We check whether the first basis element :math:`e_{1}` is :math:`1` and
        :math:`e_{i}(e_{j}e_{k}) = (e_{i}e_{j})e_{k}` for all :math:`i,j,k`.

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? algisassociative(mt)
        %2 = 1

        May be used to check a posteriori an algebra: we also allow :literal:`mt` as
        output by :literal:`algtableinit` (:math:`p` is ignored in this case).
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _mt = (<Gen>mt).g
        cdef GEN _p = gen_0
        if _have_p:
            _p = (<Gen>p).g
        cdef int _ret = algisassociative(_mt, _p)
        clear_stack()
        return _ret

    def algiscommutative(al):
        r'''
        :emphasis:`al` being a table algebra output by :literal:`algtableinit` or a central
        simple algebra output by :literal:`alginit`, tests whether the algebra :emphasis:`al` is
        commutative.

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? A = algtableinit(mt);
        ? algiscommutative(A)
        %3 = 0
        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2);
        ? algiscommutative(A)
        %6 = 1
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef int _ret = algiscommutative(_al)
        clear_stack()
        return _ret

    def algisdivision(al, pl=None):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, tests
        whether :emphasis:`al` is a division algebra. If :emphasis:`pl` is set, it should be a
        prime ideal of :math:`K` or an integer between :math:`1` and :math:`r_{1}+r_{2}`, and in that
        case tests whether :emphasis:`al` is locally a division algebra at the place
        :emphasis:`pl` instead.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? algisdivision(A, 1)
        %3 = 1
        ? algisdivision(A, 2)
        %4 = 0
        ? algisdivision(A, idealprimedec(nf,2)[1])
        %5 = 1
        ? algisdivision(A, idealprimedec(nf,5)[1])
        %6 = 0
        ? algisdivision(A)
        %7 = 1
        '''
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        cdef int _ret = algisdivision(_al, _pl)
        clear_stack()
        return _ret

    def algisdivl(al, x, y, z=None):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`al` (Hamilton quaternions if
        omitted), tests whether :math:`y` is left divisible by :math:`x`, that is whether there
        exists :math:`z` in :emphasis:`al` such that :math:`xz = y`, and sets :math:`z` to this element if it
        exists.

        ::

        ? A = alginit(nfinit(y), [-1,1]);
        ? algisdivl(A,[x+2,-x-2]~,[x,1]~)
        %2 = 0
        ? algisdivl(A,[x+2,-x-2]~,[-x,x]~,&z)
        %3 = 1
        ? z
        %4 = [Mod(-2/5*x - 1/5, x^2 + 1), 0]~

        Also accepts square matrices with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        cdef bint _have_z = (z is not None)
        if _have_z:
            raise NotImplementedError("optional argument z not available")
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN * _z = NULL
        cdef int _ret = algisdivl(_al, _x, _y, _z)
        clear_stack()
        return _ret

    def algisinv(al, x, ix=None):
        r'''
        Given an element :math:`x` in :emphasis:`al` (Hamilton quaternions if omitted), tests
        whether :math:`x` is invertible, and sets :math:`ix` to the inverse of :math:`x`.

        ::

        ? A = alginit(nfinit(y), [-1,1]);
        ? algisinv(A,[-1,1]~)
        %2 = 0
        ? algisinv(A,[1,2]~,&ix)
        %3 = 1
        ? ix
        %4 = [Mod(Mod(-1/3, y), x^2 + 1), Mod(Mod(2/3, y), x^2 + 1)]~

        Also accepts square matrices with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        cdef bint _have_ix = (ix is not None)
        if _have_ix:
            raise NotImplementedError("optional argument ix not available")
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _ix = NULL
        cdef int _ret = algisinv(_al, _x, _ix)
        clear_stack()
        return _ret

    def algisramified(al, pl=None):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, tests
        whether :emphasis:`al` is ramified, i.e. not isomorphic to a matrix algebra over its
        center. If :emphasis:`pl` is set, it should be a prime ideal of :math:`K` or an integer
        between :math:`1` and :math:`r_{1}+r_{2}`, and in that case tests whether :emphasis:`al` is
        locally ramified at the place :emphasis:`pl` instead.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? algisramified(A, 1)
        %3 = 1
        ? algisramified(A, 2)
        %4 = 0
        ? algisramified(A, idealprimedec(nf,2)[1])
        %5 = 1
        ? algisramified(A, idealprimedec(nf,5)[1])
        %6 = 0
        ? algisramified(A)
        %7 = 1
        '''
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        cdef int _ret = algisramified(_al, _pl)
        clear_stack()
        return _ret

    def algissemisimple(al):
        r'''
        :emphasis:`al` being a table algebra output by :literal:`algtableinit` or a central
        simple algebra output by :literal:`alginit`, tests whether the algebra :emphasis:`al` is
        semisimple.

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? A = algtableinit(mt);
        ? algissemisimple(A)
        %3 = 0
        ? m_i=[0,-1,0,0;1,0,0,0;0,0,0,-1;0,0,1,0]; \\ quaternion algebra (-1,-1)
        ? m_j=[0,0,-1,0;0,0,0,1;1,0,0,0;0,-1,0,0];
        ? m_k=[0,0,0,-1;0,0,-1,0;0,1,0,0;1,0,0,0];
        ? mt = [matid(4), m_i, m_j, m_k];
        ? A = algtableinit(mt);
        ? algissemisimple(A)
        %9 = 1
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef int _ret = algissemisimple(_al)
        clear_stack()
        return _ret

    def algissimple(al, long ss=0):
        r'''
        :emphasis:`al` being a table algebra output by :literal:`algtableinit` or a central
        simple algebra output by :literal:`alginit`, tests whether the algebra :emphasis:`al` is
        simple. If :math:`ss = 1`, assumes that the algebra :emphasis:`al` is semisimple
        without testing it.

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? A = algtableinit(mt); \\ matrices [*,*; 0,*]
        ? algissimple(A)
        %3 = 0
        ? algissimple(A,1) \\ incorrectly assume that A is semisimple
        %4 = 1
        ? m_i=[0,-1,0,0;1,0,0,0;0,0,0,-1;0,0,1,0];
        ? m_j=[0,0,-1,0;0,0,0,1;1,0,0,0;0,-1,0,0];
        ? m_k=[0,0,0,-1;0,0,b,0;0,1,0,0;1,0,0,0];
        ? mt = [matid(4), m_i, m_j, m_k];
        ? A = algtableinit(mt); \\ quaternion algebra (-1,-1)
        ? algissimple(A)
        %10 = 1
        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2); \\ direct product F_4 x F_2
        ? algissimple(A)
        %13 = 0
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef int _ret = algissimple(_al, ss)
        clear_stack()
        return _ret

    def algissplit(al, pl=None):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, tests
        whether :emphasis:`al` is split, i.e. isomorphic to a matrix algebra over its center.
        If :emphasis:`pl` is set, it should be a prime ideal of :math:`K` or an integer between :math:`1`
        and :math:`r_{1}+r_{2}`, and in that case tests whether :emphasis:`al` is locally split
        at the place :emphasis:`pl` instead.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? algissplit(A, 1)
        %3 = 0
        ? algissplit(A, 2)
        %4 = 1
        ? algissplit(A, idealprimedec(nf,2)[1])
        %5 = 0
        ? algissplit(A, idealprimedec(nf,5)[1])
        %6 = 1
        ? algissplit(A)
        %7 = 0
        '''
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        cdef int _ret = algissplit(_al, _pl)
        clear_stack()
        return _ret

    def alglatadd(al, lat1, lat2, ptinter=None):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, computes the sum :math:`lat1 + lat2`. If :emphasis:`ptinter` is
        present, set it to the intersection :math:`lat1 \cap lat2`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? lat1 = alglathnf(al,[1,1,0,0,0,0,0,0]~);
        ? lat2 = alglathnf(al,[1,0,1,0,0,0,0,0]~);
        ? latsum = alglatadd(al,lat1,lat2,&latinter);
        ? matdet(latsum[1])
        %5 = 4
        ? matdet(latinter[1])
        %6 = 64
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        cdef bint _have_ptinter = (ptinter is not None)
        if _have_ptinter:
            raise NotImplementedError("optional argument ptinter not available")
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN * _ptinter = NULL
        cdef GEN _ret = alglatadd(_al, _lat1, _lat2, _ptinter)
        return new_gen(_ret)

    def alglatcontains(al, lat, x, ptc=None):
        r'''
        Given an algebra :emphasis:`al`, a lattice :emphasis:`lat` and :emphasis:`x` in :emphasis:`al`,
        tests whether :math:`x\in lat`. If :emphasis:`ptc` is present, sets it to the :literal:`t_COL` of
        coordinates of :math:`x` in the basis of :emphasis:`lat`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? a1 = [1,-1,0,1,2,0,1,2]~;
        ? lat1 = alglathnf(al,a1);
        ? alglatcontains(al,lat1,a1,&c)
        %4 = 1
        ? c
        %5 = [-1, -2, -1, 1, 2, 0, 1, 1]~
        '''
        lat = objtogen(lat)
        x = objtogen(x)
        cdef bint _have_ptc = (ptc is not None)
        if _have_ptc:
            raise NotImplementedError("optional argument ptc not available")
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat = (<Gen>lat).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _ptc = NULL
        cdef int _ret = alglatcontains(_al, _lat, _x, _ptc)
        clear_stack()
        return _ret

    def alglatelement(al, lat, c):
        r'''
        Given an algebra :emphasis:`al`, a lattice :emphasis:`lat` and a :literal:`t_COL` :emphasis:`c`,
        returns the element of :emphasis:`al` whose coordinates on the \mathbb{Z}-basis of :emphasis:`lat`
        are given by :emphasis:`c`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? a1 = [1,-1,0,1,2,0,1,2]~;
        ? lat1 = alglathnf(al,a1);
        ? c = [1..8]~;
        ? elt = alglatelement(al,lat1,c);
        ? alglatcontains(al,lat1,elt,&c2)
        %6 = 1
        ? c==c2
        %7 = 1
        '''
        lat = objtogen(lat)
        c = objtogen(c)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat = (<Gen>lat).g
        cdef GEN _c = (<Gen>c).g
        cdef GEN _ret = alglatelement(_al, _lat, _c)
        return new_gen(_ret)

    def alglathnf(al, m, d=None):
        r'''
        Given an algebra :emphasis:`al` and a matrix :emphasis:`m` with columns representing
        elements of :emphasis:`al`, returns the lattice :math:`L` generated by the columns of
        :emphasis:`m`. If provided, :emphasis:`d` must be a rational number such that :math:`L` contains
        :emphasis:`d` times the natural basis of :emphasis:`al`. The argument :emphasis:`m` is also
        allowed to be a :literal:`t_VEC` of :literal:`t_MAT`, in which case :emphasis:`m` is replaced by
        the concatenation of the matrices, or a :literal:`t_COL`, in which case :emphasis:`m` is
        replaced by its left multiplication table as an element of :emphasis:`al`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? a = [1,1,-1/2,1,1/3,-1,1,1]~;
        ? mt = algtomatrix(al,a,1);
        ? lat = alglathnf(al,mt);
        ? lat[2]
        %5 = 1/6
        '''
        m = objtogen(m)
        cdef bint _have_d = (d is not None)
        if _have_d:
            d = objtogen(d)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _m = (<Gen>m).g
        cdef GEN _d = gen_0
        if _have_d:
            _d = (<Gen>d).g
        cdef GEN _ret = alglathnf(_al, _m, _d)
        return new_gen(_ret)

    def alglatindex(al, lat1, lat2):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, computes the generalized index of :emphasis:`lat1` relative
        to :emphasis:`lat2`, i.e. :math:`\|lat2/lat1\cap lat2\|/\|lat1/lat1\cap lat2\|`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? lat1 = alglathnf(al,[1,1,0,0,0,0,0,0]~);
        ? lat2 = alglathnf(al,[1,0,1,0,0,0,0,0]~);
        ? alglatindex(al,lat1,lat2)
        %4 = 1
        ? lat1==lat2
        %5 = 0
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN _ret = alglatindex(_al, _lat1, _lat2)
        return new_gen(_ret)

    def alglatinter(al, lat1, lat2, ptsum=None):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, computes the intersection :math:`lat1\cap lat2`. If :emphasis:`ptsum` is
        present, sets it to the sum :math:`lat1 + lat2`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? lat1 = alglathnf(al,[1,1,0,0,0,0,0,0]~);
        ? lat2 = alglathnf(al,[1,0,1,0,0,0,0,0]~);
        ? latinter = alglatinter(al,lat1,lat2,&latsum);
        ? matdet(latsum[1])
        %5 = 4
        ? matdet(latinter[1])
        %6 = 64
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        cdef bint _have_ptsum = (ptsum is not None)
        if _have_ptsum:
            raise NotImplementedError("optional argument ptsum not available")
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN * _ptsum = NULL
        cdef GEN _ret = alglatinter(_al, _lat1, _lat2, _ptsum)
        return new_gen(_ret)

    def alglatlefttransporter(al, lat1, lat2):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, computes the left transporter from :emphasis:`lat1` to :emphasis:`lat2`, i.e.
        the set of :math:`x\in al` such that :math:`x.lat1 \subset lat2`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? lat1 = alglathnf(al,[1,-1,0,1,2,0,5,2]~);
        ? lat2 = alglathnf(al,[0,1,-2,-1,0,0,3,1]~);
        ? tr = alglatlefttransporter(al,lat1,lat2);
        ? a = alglatelement(al,tr,[0,0,0,0,0,0,1,0]~);
        ? alglatsubset(al,alglatmul(al,a,lat1),lat2)
        %6 = 1
        ? alglatsubset(al,alglatmul(al,lat1,a),lat2)
        %7 = 0
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN _ret = alglatlefttransporter(_al, _lat1, _lat2)
        return new_gen(_ret)

    def alglatmul(al, lat1, lat2):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, computes the lattice generated by the products of elements
        of :emphasis:`lat1` and :emphasis:`lat2`.
        One of :emphasis:`lat1` and :emphasis:`lat2` is also allowed to be an element of :emphasis:`al`;
        in this case, computes the product of the element and the lattice.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? a1 = [1,-1,0,1,2,0,1,2]~;
        ? a2 = [0,1,2,-1,0,0,3,1]~;
        ? lat1 = alglathnf(al,a1);
        ? lat2 = alglathnf(al,a2);
        ? lat3 = alglatmul(al,lat1,lat2);
        ? matdet(lat3[1])
        %7 = 29584
        ? lat3 == alglathnf(al, algmul(al,a1,a2))
        %8 = 0
        ? lat3 == alglatmul(al, lat1, a2)
        %9 = 0
        ? lat3 == alglatmul(al, a1, lat2)
        %10 = 0
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN _ret = alglatmul(_al, _lat1, _lat2)
        return new_gen(_ret)

    def alglatrighttransporter(al, lat1, lat2):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, computes the right transporter from :emphasis:`lat1` to :emphasis:`lat2`, i.e.
        the set of :math:`x\in al` such that :math:`lat1.x \subset lat2`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? lat1 = alglathnf(al,matdiagonal([1,3,7,1,2,8,5,2]));
        ? lat2 = alglathnf(al,matdiagonal([5,3,8,1,9,8,7,1]));
        ? tr = alglatrighttransporter(al,lat1,lat2);
        ? a = alglatelement(al,tr,[0,0,0,0,0,0,0,1]~);
        ? alglatsubset(al,alglatmul(al,lat1,a),lat2)
        %6 = 1
        ? alglatsubset(al,alglatmul(al,a,lat1),lat2)
        %7 = 0
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN _ret = alglatrighttransporter(_al, _lat1, _lat2)
        return new_gen(_ret)

    def alglatsubset(al, lat1, lat2, ptindex=None):
        r'''
        Given an algebra :emphasis:`al` and two lattices :emphasis:`lat1` and :emphasis:`lat2`
        in :emphasis:`al`, tests whether :math:`lat1\subset lat2`. If it is true and :emphasis:`ptindex`
        is present, sets it to the index of :emphasis:`lat1` in :emphasis:`lat2`.

        ::

        ? al = alginit(nfinit(y^2+7), [-1,-1]);
        ? lat1 = alglathnf(al,[1,1,0,0,0,0,0,0]~);
        ? lat2 = alglathnf(al,[1,0,1,0,0,0,0,0]~);
        ? alglatsubset(al,lat1,lat2)
        %4 = 0
        ? latsum = alglatadd(al,lat1,lat2);
        ? alglatsubset(al,lat1,latsum,&index)
        %6 = 1
        ? index
        %7 = 4
        '''
        lat1 = objtogen(lat1)
        lat2 = objtogen(lat2)
        cdef bint _have_ptindex = (ptindex is not None)
        if _have_ptindex:
            raise NotImplementedError("optional argument ptindex not available")
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _lat1 = (<Gen>lat1).g
        cdef GEN _lat2 = (<Gen>lat2).g
        cdef GEN * _ptindex = NULL
        cdef int _ret = alglatsubset(_al, _lat1, _lat2, _ptindex)
        clear_stack()
        return _ret

    def algmakeintegral(mt, long maps=0):
        r'''
        :emphasis:`mt` being a multiplication table over :math:`\mathbb{Q}` in the same format as the
        input of :literal:`algtableinit`, computes an integral multiplication table
        :emphasis:`mt2` for an isomorphic algebra. When :math:`maps = 1`, returns a :literal:`t_VEC`
        :math:`[mt2,S,T]` where :emphasis:`S` and :emphasis:`T` are matrices
        respectively representing the map from the algebra defined by :emphasis:`mt` to the
        one defined by :emphasis:`mt2` and its inverse.

        ::

        ? mt = [matid(2),[0,-1/4;1,0]];
        ? algtableinit(mt);
        *** at top-level: algtableinit(mt)
        *** ^----------------
        *** algtableinit: domain error in algtableinit: denominator(mt) != 1
        ? mt2 = algmakeintegral(mt);
        ? al = algtableinit(mt2);
        ? algisassociative(al)
        %4 = 1
        ? [mt2, S, T] = algmakeintegral(mt,1);
        ? S
        %6 =
        [1 0]
        
        [0 1/4]
        ? T
        %7 =
        [1 0]
        
        [0 4]
        ? vector(#mt, i, S * (mt * T[,i]) * T) == mt2
        %8 = 1
        '''
        sig_on()
        cdef GEN _mt = (<Gen>mt).g
        cdef GEN _ret = algmakeintegral(_mt, maps)
        return new_gen(_ret)

    def algmul(al, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`al` (Hamilton quaternions if
        omitted), computes their product :math:`xy` in the algebra :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algmul(A,[1,1,0,0]~,[0,0,2,1]~)
        % = [2, 3, 5, -4]~
        ? algmul(,[1,2,3,4]~,sqrt(I)) \\ Hamilton quaternions
        % = [-0.7071067811, 2.1213203435, 4.9497474683, 0.7071067811]~

        Also accepts matrices with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = algmul(_al, _x, _y)
        return new_gen(_ret)

    def algmultable(al):
        r'''
        Returns a multiplication table of :emphasis:`al` over its
        prime subfield (:math:`\mathbb{Q}` or :math:`\mathbb{F}_{p}`) or over :math:`\mathbb{R}` for real algebras, as a
        :literal:`t_VEC` of :literal:`t_MAT`: the left multiplication tables of basis elements.
        If :emphasis:`al` was output by :literal:`algtableinit`, returns the multiplication
        table used to define :emphasis:`al`.
        If :emphasis:`al` was output by :literal:`alginit`, returns the multiplication table of
        the order :math:`O_{0}` stored in :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? M = algmultable(A);
        ? #M
        %3 = 4
        ? M[1] \\ multiplication by e_1 = 1
        %4 =
        [1 0 0 0]
        
        [0 1 0 0]
        
        [0 0 1 0]
        
        [0 0 0 1]
        
        ? M[2]
        %5 =
        [0 -1 1 0]
        
        [1 0 1 1]
        
        [0 0 1 1]
        
        [0 0 -2 -1]
        ? H = alginit(1.,1/2); \\ Hamilton quaternions
        ? algmultable(H)[3] \\ multiplication by j
        %7 =
        [0 0 -1 0]
        
        [0 0 0 1]
        
        [1 0 0 0]
        
        [0 -1 0 0]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algmultable(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algneg(al, x):
        r'''
        Given an element :math:`x` in :emphasis:`al`, computes its opposite :math:`-x` in the
        algebra :emphasis:`al` (Hamilton quaternions if omitted).

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algneg(A,[1,1,0,0]~)
        %2 = [-1, -1, 0, 0]~

        Also accepts matrices with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algneg(_al, _x)
        return new_gen(_ret)

    def algnorm(al, x, long abs=0):
        r'''
        Given an element :emphasis:`x` in :emphasis:`al` (Hamilton quaternions if omitted),
        computes its norm. If :emphasis:`al` is a table algebra output by :literal:`algtableinit`
        or if :math:`abs = 1`, returns the absolute norm of :emphasis:`x`, which is an element of
        :math:`\mathbb{F}_{p}`, :math:`\mathbb{Q}` or :math:`\mathbb{R}`; if :emphasis:`al` is omitted or a central simple algebra
        output by :literal:`alginit` and :math:`abs = 0` (default), returns the reduced norm of
        :emphasis:`x`, which is an element of the center of :emphasis:`al`.

        ::

        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,19);
        ? algnorm(A,[0,-2,3]~)
        %3 = 18
        ? nf = nfinit(y^2-5);
        ? B = alginit(nf,[-1,y]);
        ? b = [x,1]~;
        ? n = algnorm(B,b)
        %7 = Mod(-y + 1, y^2 - 5)
        ? algnorm(B,b,1)
        %8 = 16
        ? nfeltnorm(nf,n)^algdegree(B)
        %9 = 16
        ? algnorm(,[0,sqrt(3),0,sqrt(2)]~) \\ Hamilton quaternions
        %10 = 5.0000000000

        Also accepts a square matrix with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algnorm(_al, _x, abs)
        return new_gen(_ret)

    def algpoleval(al, T, b):
        r'''
        Given an element :math:`b` in :emphasis:`al` (Hamilton quaternions if omitted) and a
        polynomial :math:`T` in :math:`K[X]`, computes :math:`T(b)` in :emphasis:`al`. Here :math:`K = \mathbb{Q}` or :math:`\mathbb{F}_p`
        for a table algebra (output by :literal:`algtableinit`) and :math:`K` is the center of
        :emphasis:`al` for a central simple algebra (output by :literal:`alginit`).
        Also accepts as input a :literal:`t_VEC` :math:`[b,mb]` where :math:`mb` is the left
        multiplication table of :math:`b`.

        ::

        ? nf = nfinit(y^2-5);
        ? al = alginit(nf,[y,-1]);
        ? b = [1..8]~;
        ? pol = algcharpoly(al,b,,1); \\absolute characteristic polynomial
        ? algpoleval(al,pol,b)==0
        %5 = 1
        ? mb = algtomatrix(al,b,1);
        ? algpoleval(al,pol,[b,mb])==0
        %7 = 1
        ? pol = algcharpoly(al,b); \\reduced characteristic polynomial
        ? algpoleval(al,pol,b) == 0
        %9 = 1
        ? algpoleval(,polcyclo(8),[1,0,0,1]~/sqrt(2)) \\ Hamilton quaternions
        %10 = [0.E-38, 0, 0, 0.E-38]~
        '''
        T = objtogen(T)
        b = objtogen(b)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _T = (<Gen>T).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = algpoleval(_al, _T, _b)
        return new_gen(_ret)

    def algpow(al, x, n):
        r'''
        Given an element :math:`x` in :emphasis:`al` (Hamilton quaternions if omitted) and an
        integer :math:`n`, computes the power :math:`x^{n}` in the algebra :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algpow(A,[1,1,0,0]~,7)
        %2 = [8, -8, 0, 0]~
        ? algpow(,[1,2,3,sqrt(3)]~,-3) \\ Hamilton quaternions
        % = [-0.0095664563, 0.0052920822, 0.0079381233, 0.0045830776]~

        Also accepts a square matrix with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        n = objtogen(n)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = algpow(_al, _x, _n)
        return new_gen(_ret)

    def algprimesubalg(al):
        r'''
        :emphasis:`al` being the output of :literal:`algtableinit` representing a semisimple
        algebra of positive characteristic, returns a basis of the prime subalgebra
        of :emphasis:`al`. The prime subalgebra of :emphasis:`al` is the subalgebra fixed by the
        Frobenius automorphism of the center of :emphasis:`al`. It is abstractly isomorphic
        to a product of copies of :math:`\mathbb{F}_{p}`.

        ::

        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2);
        ? algprimesubalg(A)
        %3 =
        [1 0]
        
        [0 1]
        
        [0 0]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algprimesubalg(_al)
        return new_gen(_ret)

    def algquotient(al, I, long maps=0):
        r'''
        :emphasis:`al` being a table algebra output by :literal:`algtableinit` and :emphasis:`I`
        being a basis of a two-sided ideal of :emphasis:`al` represented by a matrix,
        returns the quotient :math:`al/I`. When :math:`maps = 1`, returns a
        :literal:`t_VEC` :math:`[al/I,proj,lift]` where :emphasis:`proj` and
        :emphasis:`lift` are matrices respectively representing the projection map and a
        section of it.

        ::

        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2);
        ? AQ = algquotient(A,[0;1;0]);
        ? algdim(AQ)
        %4 = 2
        '''
        I = objtogen(I)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _I = (<Gen>I).g
        cdef GEN _ret = alg_quotient(_al, _I, maps)
        return new_gen(_ret)

    def algradical(al):
        r'''
        :emphasis:`al` being a table algebra output by :literal:`algtableinit`, returns a
        basis of the Jacobson radical of the algebra :emphasis:`al` over its prime field
        (:math:`\mathbb{Q}` or :math:`\mathbb{F}_{p}`).

        Here is an example with :math:`A = \mathbb{Q}[x]/(x^{2})`, with the basis :math:`(1,x)`:

        ::

        ? mt = [matid(2),[0,0;1,0]];
        ? A = algtableinit(mt);
        ? algradical(A) \\ = (x)
        %3 =
        [0]
        
        [1]

        Another one with :math:`2 x 2` upper triangular matrices over :math:`\mathbb{Q}`, with basis
        :math:`I_{2}`, :math:`a = [0,1;0,0]` and :math:`b = [0,0;0,1]`, such that :math:`a^{2} =
        0`, :math:`ab = a`, :math:`ba = 0`, :math:`b^{2} = b`:

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? A = algtableinit(mt);
        ? algradical(A) \\ = (a)
        %6 =
        [0]
        
        [1]
        
        [0]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algradical(_al)
        return new_gen(_ret)

    def algramifiedplaces(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, returns a
        :literal:`t_VEC` containing the list of places of the center of :emphasis:`al` that are
        ramified in :emphasis:`al`. Each place is described as an integer between :math:`1`
        and :math:`r_{1}` or as a prime ideal.

        ::

        ? nf = nfinit(y^2-5);
        ? A = alginit(nf, [-1,y]);
        ? algramifiedplaces(A)
        %3 = [1, [2, [2, 0]~, 1, 2, 1]]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algramifiedplaces(_al)
        return new_gen(_ret)

    def algrandom(al, b):
        r'''
        Given an algebra :emphasis:`al` and a nonnegative integer :emphasis:`b`, returns a
        random element in :emphasis:`al` with coefficients in :math:`[-b,b]`.

        ::

        ? al = alginit(nfinit(y),[-1,-1]);
        ? algrandom(al,3)
        % = [2, 0, 3, -1]~

        If :emphasis:`al` is an algebra over :math:`\mathbb{R}` (Hamilton quaternions if omitted) and
        :emphasis:`b` is a positive :literal:`t_REAL`, returns a random element of :emphasis:`al` with
        coefficients in :math:`[-b,b]`.

        ::

        ? algrandom(,1.)
        % = [-0.1806334680, -0.2810504190, 0.5011479961, 0.9498643737]~
        '''
        b = objtogen(b)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = algrandom(_al, _b)
        return new_gen(_ret)

    def algrelmultable(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit` defined by a multiplication table over its center (a number field), returns this multiplication table.

        ::

        ? nf = nfinit(y^3-5); a = y; b = y^2;
        ? {m_i = [0,a,0,0;
        1,0,0,0;
        0,0,0,a;
        0,0,1,0];}
        ? {m_j = [0, 0,b, 0;
        0, 0,0,-b;
        1, 0,0, 0;
        0,-1,0, 0];}
        ? {m_k = [0, 0,0,-a*b;
        0, 0,b, 0;
        0,-a,0, 0;
        1, 0,0, 0];}
        ? mt = [matid(4), m_i, m_j, m_k];
        ? A = alginit(nf,mt,'x);
        ? M = algrelmultable(A);
        ? M[2] == m_i
        %8 = 1
        ? M[3] == m_j
        %9 = 1
        ? M[4] == m_k
        %10 = 1
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algrelmultable(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algsimpledec(al, long maps=0):
        r'''
        :emphasis:`al` being the output of :literal:`algtableinit`, returns a :literal:`t_VEC`
        :math:`[J,[al_{1},...,al_{n}]]` where :math:`J` is a basis of the
        Jacobson radical of :emphasis:`al` and :math:`al/J` is isomorphic to the direct
        product of the simple algebras :math:`al_{i}`. When :math:`maps = 1`,
        each :math:`al_{i}` is replaced with a :literal:`t_VEC`
        :math:`[al_{i},proj_{i},lift_{i}]` where :math:`proj_{i}`
        and :math:`lift_{i}`
        are matrices respectively representing the projection map :math:`al \to
        al_{i}` and a section of it. Modulo :math:`J`, the images of the
        :math:`lift_{i}`
        form a direct sum in :math:`al/J`, so that the images of :math:`1\inal_{i}`
        under :math:`lift_{i}` are central primitive idempotents of :math:`al/J`. The
        factors are sorted by increasing dimension, then increasing dimension of the
        center. This ensures that the ordering of the isomorphism classes of the
        factors is deterministic over finite fields, but not necessarily over :math:`\mathbb{Q}`.
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algsimpledec(_al, maps)
        return new_gen(_ret)

    def algsplit(al, v=None):
        r'''
        If :emphasis:`al` is a table algebra over :math:`\mathbb{F}_{p}` output by :literal:`algtableinit`
        that represents a simple algebra, computes an isomorphism between :emphasis:`al` and
        a matrix algebra :math:`M_{d}(\mathbb{F}_{p^{n}})` where :math:`N = nd^{2}` is the dimension
        of :emphasis:`al`. Returns a :literal:`t_VEC` :math:`[map,mapi]`, where:

        - :emphasis:`map` is a :literal:`t_VEC` of :math:`N` matrices of size :math:`d x d` with
        :literal:`t_FFELT` coefficients using the variable :emphasis:`v`, representing the image of
        the basis of :emphasis:`al` under the isomorphism.

        - :emphasis:`mapi` is an :math:`N x N` matrix with :literal:`t_INT` coefficients,
        representing the image in :emphasis:`al` by the inverse isomorphism of the
        basis :math:`(b_{i})` of :math:`M_{d}(\mathbb{F}_{p}[\alpha])` (where :math:`\alpha` has degree :math:`n`
        over :math:`\mathbb{F}_{p}`) defined as follows:
        let :math:`E_{i,j}` be the matrix having all coefficients :math:`0` except the :math:`(i,j)`-th
        coefficient equal to :math:`1`, and define
        

        .. MATH::

        b_{i_{3}+n(i_{2}+di_{1})+1} = E_{i_{1}+1,i_{2}+1} \alpha^{i_{3}},

        where :math:`0 <= i_{1},i_{2} < d` and :math:`0 <= i_{3} < n`.

        Example:

        ::

        ? al0 = alginit(nfinit(y^2+7), [-1,-1]);
        ? al = algtableinit(algmultable(al0), 3); \\ isomorphic to M_2(F_9)
        ? [map,mapi] = algsplit(al, 'a);
        ? x = [1,2,1,0,0,0,0,0]~; fx = map*x
        %4 =
        [2*a 0]
        
        [ 0 2]
        ? y = [0,0,0,0,1,0,0,1]~; fy = map*y
        %5 =
        [1 2*a]
        
        [2 a + 2]
        ? map*algmul(al,x,y) == fx*fy
        %6 = 1
        ? map*mapi[,6]
        %7 =
        [0 0]
        
        [a 0]

        :strong:`Warning.` If :emphasis:`al` is not simple, :literal:`algsplit(al)` can trigger
        an error, but can also run into an infinite loop. Example:

        ::

        ? al = alginit(nfinit(y),[-1,-1]); \\ ramified at 2
        ? al2 = algtableinit(algmultable(al),2); \\ maximal order modulo 2
        ? algsplit(al2); \\ not semisimple, infinite loop
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algsplit(_al, _v)
        return new_gen(_ret)

    def algsplittingdata(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit` defined
        by a multiplication table over its center :math:`K` (a number field), returns data
        stored to compute a splitting of :emphasis:`al` over an extension. This data is a
        :literal:`t_VEC` :literal:`[t,Lbas,Lbasinv]` with :math:`3` components:

        - an element :math:`t` of :emphasis:`al` such that :math:`L = K(t)` is a maximal subfield
        of :emphasis:`al`;

        - a matrix :literal:`Lbas` expressing a :math:`L`-basis of :emphasis:`al` (given an
        :math:`L`-vector space structure by multiplication on the right) on the integral
        basis of :emphasis:`al`;

        - a matrix :literal:`Lbasinv` expressing the integral basis of :emphasis:`al` on
        the previous :math:`L`-basis.

        ::

        ? nf = nfinit(y^3-5); a = y; b = y^2;
        ? {m_i = [0,a,0,0;
        1,0,0,0;
        0,0,0,a;
        0,0,1,0];}
        ? {m_j = [0, 0,b, 0;
        0, 0,0,-b;
        1, 0,0, 0;
        0,-1,0, 0];}
        ? {m_k = [0, 0,0,-a*b;
        0, 0,b, 0;
        0,-a,0, 0;
        1, 0,0, 0];}
        ? mt = [matid(4), m_i, m_j, m_k];
        ? A = alginit(nf,mt,'x);
        ? [t,Lb,Lbi] = algsplittingdata(A);
        ? t
        %8 = [0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0]~;
        ? matsize(Lb)
        %9 = [12, 2]
        ? matsize(Lbi)
        %10 = [2, 12]
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algsplittingdata(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algsplittingfield(al):
        r'''
        Given a central simple algebra :emphasis:`al` output by :literal:`alginit`, returns
        an :literal:`rnf` structure: the splitting field of :emphasis:`al` that is stored in
        :emphasis:`al`, as a relative extension of the center.

        ::

        nf = nfinit(y^3-5);
        a = y; b = y^2;
        {m_i = [0,a,0,0;
        1,0,0,0;
        0,0,0,a;
        0,0,1,0];}
        {m_j = [0, 0,b, 0;
        0, 0,0,-b;
        1, 0,0, 0;
        0,-1,0, 0];}
        {m_k = [0, 0,0,-a*b;
        0, 0,b, 0;
        0,-a,0, 0;
        1, 0,0, 0];}
        mt = [matid(4), m_i, m_j, m_k];
        A = alginit(nf,mt,'x);
        algsplittingfield(A).pol
        %8 = x^2 - y
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _ret = algsplittingfield(_al)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def algsqr(al, x):
        r'''
        Given an element :math:`x` in :emphasis:`al` (Hamilton quaternions if omitted),
        computes its square :math:`x^{2}` in the algebra :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algsqr(A,[1,0,2,0]~)
        %2 = [-3, 0, 4, 0]~
        ? algsqr(,[0,0,0,Pi]~) \\ Hamilton quaternions
        %3 = [-9.8696044010, 0, 0, 0]~

        Also accepts a square matrix with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algsqr(_al, _x)
        return new_gen(_ret)

    def algsub(al, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`al` (Hamilton quaternions if
        omitted), computes their difference :math:`x-y` in the algebra :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algsub(A,[1,1,0,0]~,[1,0,1,0]~)
        %2 = [0, 1, -1, 0]~

        Also accepts matrices with coefficients in :emphasis:`al`.

        If :math:`x` and :math:`y` are given in the same format, then one should simply use :literal:`-`
        instead of :literal:`algsub`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = algsub(_al, _x, _y)
        return new_gen(_ret)

    def algsubalg(al, B):
        r'''
        :emphasis:`al` being a table algebra output by :literal:`algtableinit` and :emphasis:`B`
        being a basis of a subalgebra of :emphasis:`al` represented by a matrix, computes an
        algebra :emphasis:`al2` isomorphic to :emphasis:`B`.

        Returns :math:`[al2,B2]` where :emphasis:`B2` is a possibly different basis of
        the subalgebra :emphasis:`al2`, with respect to which the multiplication table of
        :emphasis:`al2` is defined.

        ::

        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2);
        ? B = algsubalg(A,[1,0; 0,0; 0,1]);
        ? algdim(A)
        %4 = 3
        ? algdim(B[1])
        %5 = 2
        ? m = matcompanion(x^4+1);
        ? mt = [m^i | i <- [0..3]];
        ? al = algtableinit(mt);
        ? B = [1,0;0,0;0,1/2;0,0];
        ? al2 = algsubalg(al,B);
        ? algdim(al2[1])
        ? al2[2]
        %13 =
        [1 0]
        
        [0 0]
        
        [0 1]
        
        [0 0]
        '''
        B = objtogen(B)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = algsubalg(_al, _B)
        return new_gen(_ret)

    def algtableinit(mt, p=None):
        r'''
        Initializes the associative algebra over :math:`K = \mathbb{Q}` (:math:`p` omitted) or :math:`\mathbb{F}_{p}`
        defined by the multiplication table :emphasis:`mt`.
        As a :math:`K`-vector space, the algebra is generated by a basis
        :math:`(e_{1} = 1, e_{2},..., e_{n})`; the table is given as a :literal:`t_VEC` of :math:`n` matrices in
        :math:`M_{n}(K)`, giving the left multiplication by the basis elements :math:`e_{i}`, in the
        given basis.
        Assumes that :math:`e_{1} = 1`, that :math:`K e_{1}\oplus...\oplus K e_{n}]` describes an
        associative algebra over :math:`K`, and in the case :math:`K = \mathbb{Q}` that the multiplication
        table is integral. If the algebra is already known to be central
        and simple, then the case :math:`K = \mathbb{F}_{p}` is useless, and one should use
        :literal:`alginit` directly.

        The point of this function is to input a finite dimensional :math:`K`-algebra, so
        as to later compute its radical, then to split the quotient algebra as a
        product of simple algebras over :math:`K`.

        The pari object representing such an algebra :math:`A` is a :literal:`t_VEC` with the
        following data:

        - The characteristic of :math:`A`, accessed with :literal:`algchar`.

        - The multiplication table of :math:`A`, accessed with :literal:`algmultable`.

        - The traces of the elements of the basis.

        A simple example: the :math:`2 x 2` upper triangular matrices over :math:`\mathbb{Q}`,
        generated by :math:`I_{2}`, :math:`a = [0,1;0,0]` and :math:`b = [0,0;0,1]`,
        such that :math:`a^{2} = 0`, :math:`ab = a`, :math:`ba = 0`, :math:`b^{2} = b`:

        ::

        ? mt = [matid(3),[0,0,0;1,0,1;0,0,0],[0,0,0;0,0,0;1,0,1]];
        ? A = algtableinit(mt);
        ? algradical(A) \\ = (a)
        %6 =
        [0]
        
        [1]
        
        [0]
        ? algcenter(A) \\ = (I_2)
        %7 =
        [1]
        
        [0]
        
        [0]
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _mt = (<Gen>mt).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = algtableinit(_mt, _p)
        return new_gen(_ret)

    def algtensor(al1, al2, long flag=3):
        r'''
        Given two algebras :emphasis:`al1` and :emphasis:`al2`, computes their tensor
        product. :math:`flag` has the same meaning as in :literal:`alginit`.

        Currently only implemented for cyclic algebras of coprime degree over the same
        center :math:`K`, and the tensor product is over :math:`K`.
        '''
        al2 = objtogen(al2)
        sig_on()
        cdef GEN _al1 = (<Gen>al1).g
        cdef GEN _al2 = (<Gen>al2).g
        cdef GEN _ret = algtensor(_al1, _al2, flag)
        return new_gen(_ret)

    def algtomatrix(al, x, long abs=0):
        r'''
        Given an element :emphasis:`x` in :emphasis:`al` (Hamilton quaternions if omitted),
        returns the image of :emphasis:`x` under a homomorphism to a matrix algebra. If
        :emphasis:`al` is a table algebra output by :literal:`algtableinit` or if :math:`abs = 1`, returns
        the left multiplication table on the integral basis; if :emphasis:`al` is a central
        simple algebra and :math:`abs = 0`, returns :math:`\phi (x)` where :math:`\phi : A\otimes_{K} L \to
        M_{d}(L)` (where :math:`d` is the degree of the algebra and :math:`L` is an extension of :math:`L`
        with :math:`[L:K] = d`) is an isomorphism stored in :emphasis:`al`. Also accepts a square
        matrix with coefficients in :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algtomatrix(A,[0,0,0,2]~)
        %2 =
        [Mod(x + 1, x^2 + 1) Mod(Mod(1, y)*x + Mod(-1, y), x^2 + 1)]
        
        [Mod(x + 1, x^2 + 1) Mod(-x + 1, x^2 + 1)]
        ? algtomatrix(A,[0,1,0,0]~,1)
        %2 =
        [0 -1 1 0]
        
        [1 0 1 1]
        
        [0 0 1 1]
        
        [0 0 -2 -1]
        ? algtomatrix(A,[0,x]~,1)
        %3 =
        [-1 0 0 -1]
        
        [-1 0 1 0]
        
        [-1 -1 0 -1]
        
        [ 2 0 0 1]
        ? algtomatrix(,[1,2,3,4]~) \\ Hamilton quaternions
        %4 =
        [1 + 2*I -3 - 4*I]
        
        [3 - 4*I 1 - 2*I]
        ? algtomatrix(,I,1)
        %5 =
        [0 -1 0 0]
        
        [1 0 0 0]
        
        [0 0 0 -1]
        
        [0 0 1 0]

        Also accepts matrices with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algtomatrix(_al, _x, abs)
        return new_gen(_ret)

    def algtrace(al, x, long abs=0):
        r'''
        Given an element :emphasis:`x` in :emphasis:`al` (Hamilton quaternions if omitted),
        computes its trace. If :emphasis:`al` is a table algebra output by :literal:`algtableinit`
        or if :math:`abs = 1`, returns the absolute trace of :emphasis:`x`, which is an element of
        :math:`\mathbb{F}_{p}`, :math:`\mathbb{Q}` or :math:`\mathbb{R}`; if :emphasis:`al` is omitted or the output of :literal:`alginit` and
        :math:`abs = 0` (default), returns the reduced trace of :emphasis:`x`, which is an element of
        the center of :emphasis:`al`.

        ::

        ? A = alginit(nfinit(y), [-1,-1]);
        ? algtrace(A,[5,0,0,1]~)
        %2 = 11
        ? algtrace(A,[5,0,0,1]~,1)
        %3 = 22
        ? nf = nfinit(y^2-5);
        ? A = alginit(nf,[-1,y]);
        ? a = [1+x+y,2*y]~*Mod(1,y^2-5)*Mod(1,x^2+1);
        ? t = algtrace(A,a)
        %7 = Mod(2*y + 2, y^2 - 5)
        ? algtrace(A,a,1)
        %8 = 8
        ? algdegree(A)*nfelttrace(nf,t)
        %9 = 8
        ? algtrace(,[1.,2,3,4]~) \\ Hamilton quaternions
        %10 = 2.0000000000
        ? algtrace(,[1.,2,3,4]~,0)
        %11 = 4.0000000000

        Also accepts a square matrix with coefficients in :emphasis:`al`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algtrace(_al, _x, abs)
        return new_gen(_ret)

    def algtype(al):
        r'''
        Given an algebra :emphasis:`al` output by :literal:`alginit` or by :literal:`algtableinit`, returns an integer indicating the type of algebra:

        - :math:`0`: not a valid algebra.

        - :math:`1`: table algebra output by :literal:`algtableinit`.

        - :math:`2`: central simple algebra output by :literal:`alginit` and represented by
        a multiplication table over its center.

        - :math:`3`: central simple algebra output by :literal:`alginit` and represented by
        a cyclic algebra.

        - :math:`4`: division algebra over :math:`\mathbb{R}` (:math:`\mathbb{R}`, :math:`\mathbb{C}` or Hamilton quaternion algebra :math:`H`).

        ::

        ? algtype([])
        %1 = 0
        ? mt = [matid(3), [0,0,0; 1,1,0; 0,0,0], [0,0,1; 0,0,0; 1,0,1]];
        ? A = algtableinit(mt,2);
        ? algtype(A)
        %4 = 1
        ? nf = nfinit(y^3-5);
        ? a = y; b = y^2;
        ? {m_i = [0,a,0,0;
        1,0,0,0;
        0,0,0,a;
        0,0,1,0];}
        ? {m_j = [0, 0,b, 0;
        0, 0,0,-b;
        1, 0,0, 0;
        0,-1,0, 0];}
        ? {m_k = [0, 0,0,-a*b;
        0, 0,b, 0;
        0,-a,0, 0;
        1, 0,0, 0];}
        ? mt = [matid(4), m_i, m_j, m_k];
        ? A = alginit(nf,mt,'x);
        ? algtype(A)
        %12 = 2
        ? A = alginit(nfinit(y), [-1,-1]);
        ? algtype(A)
        %14 = 3
        ? H = alginit(1.,1/2);
        ? algtype(H)
        %16 = 4
        '''
        sig_on()
        cdef GEN _al = (<Gen>al).g
        cdef long _ret = algtype(_al)
        clear_stack()
        return _ret

    def apply(f, A):
        r'''
        Apply the :literal:`t_CLOSURE` :literal:`f` to the entries of :literal:`A`.

        - If :literal:`A` is a scalar, return :literal:`f(A)`.

        - If :literal:`A` is a polynomial or power series :math:`\sum a_{i} x^{i}` (:math:`+
        O(x^{N})`), apply :literal:`f` on all coefficients and return :math:`\sum f(a_{i})
        x^{i}` (:math:`+ O(x^{N})`).

        - If :literal:`A` is a vector or list :math:`[a_{1},...,a_{n}]`, return the vector
        or list :math:`[f(a_{1}),..., f(a_{n})]`. If :literal:`A` is a matrix, return the matrix
        whose entries are the :math:`f(A[i,j])`.

        ::

        ? apply(x->x^2, [1,2,3,4])
        %1 = [1, 4, 9, 16]
        ? apply(x->x^2, [1,2;3,4])
        %2 =
        [1 4]
        
        [9 16]
        ? apply(x->x^2, 4*x^2 + 3*x+ 2)
        %3 = 16*x^2 + 9*x + 4
        ? apply(sign, 2 - 3* x + 4*x^2 + O(x^3))
        %4 = 1 - x + x^2 + O(x^3)

        Note that many functions already act componentwise on
        vectors or matrices, but they almost never act on lists; in this case,
        :literal:`apply` is a good solution:

        ::

        ? L = List([Mod(1,3), Mod(2,4)]);
        ? lift(L)
        *** at top-level: lift(L)
        *** ^-------
        *** lift: incorrect type in lift.
        ? apply(lift, L);
        %2 = List([1, 2])

        :strong:`Remark.` For :math:`v` a :literal:`t_VEC`, :literal:`t_COL`, :literal:`t_VECSMALL`,
        :literal:`t_LIST` or :literal:`t_MAT`, the alternative set-notations

        ::

        [g(x) | x <- v, f(x)]
        [x | x <- v, f(x)]
        [g(x) | x <- v]

        are available as shortcuts for

        ::

        apply(g, select(f, Vec(v)))
        select(f, Vec(v))
        apply(g, Vec(v))

        respectively:

        ::

        ? L = List([Mod(1,3), Mod(2,4)]);
        ? [ lift(x) | x<-L ]
        %2 = [1, 2]
        '''
        A = objtogen(A)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _A = (<Gen>A).g
        cdef GEN _ret = apply0(_f, _A)
        return new_gen(_ret)

    def arg(x, long precision=DEFAULT_BITPREC):
        r'''
        Argument of the complex number :math:`x`, such that :math:`-\pi < \arg (x) <= \pi`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = garg(_x, precision)
        return new_gen(_ret)

    def arity(C):
        r'''
        Return the arity of the closure :math:`C`, i.e., the number of its arguments.

        ::

        ? f1(x,y=0)=x+y;
        ? arity(f1)
        %1 = 2
        ? f2(t,s[..])=print(t,":",s);
        ? arity(f2)
        %2 = 2

        Note that a variadic argument, such as :math:`s` in :literal:`f2` above,
        is counted as a single argument.
        '''
        sig_on()
        cdef GEN _C = (<Gen>C).g
        cdef GEN _ret = arity0(_C)
        return new_gen(_ret)

    def asin(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of :math:`\sin^{-1}(x) = -i \log (ix + \sqrt{1 - x^{2}})`.
        In particular, :math:`\Re (asin(x))\in [-\pi/2,\pi/2]` and if :math:`x\in \mathbb{R}` and
        :math:`\|x\| > 1` then :math:`asin(x)` is complex. The branch cut is in two pieces:
        :math:`]- oo ,-1]`, continuous with quadrant II, and :math:`[1,+ oo [` continuous
        with quadrant IV. The function satisfies :math:`i asin(x) =
        asinh(ix)`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gasin(_x, precision)
        return new_gen(_ret)

    def asinh(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of :math:`\sinh^{-1}(x) = \log (x + \sqrt{1+x^{2}})`. In
        particular :math:`\Im (asinh(x))\in [-\pi/2,\pi/2]`.
        The branch cut is in two pieces: :math:`]-i oo ,-i]`, continuous with quadrant
        III and :math:`[+i,+i oo [`, continuous with quadrant I.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gasinh(_x, precision)
        return new_gen(_ret)

    def asympnum(expr, alpha=None, long precision=DEFAULT_BITPREC):
        r'''
        Asymptotic expansion of :emphasis:`expr`, corresponding to a sequence :math:`u(n)`,
        assuming it has the shape

        .. MATH::

        u(n) ~ \sum_{i >= 0} a_{i} n^{-i\alpha}

        with rational coefficients :math:`a_{i}` with reasonable height; the algorithm
        is heuristic and performs repeated calls to limitnum, with
        :literal:`alpha` as in :literal:`limitnum`. As in :literal:`limitnum`, :math:`u(n)` may be
        given either by a closure :math:`n:---> u(n)` or as a closure :math:`N:--->
        [u(1),...,u(N)]`, the latter being often more efficient.

        ::

        ? f(n) = n! / (n^n*exp(-n)*sqrt(n));
        ? asympnum(f)
        %2 = [] \\ failure !
        ? localprec(57); l = limitnum(f)
        %3 = 2.5066282746310005024157652848110452530
        ? asympnum(n->f(n)/l) \\ normalize
        %4 = [1, 1/12, 1/288, -139/51840, -571/2488320, 163879/209018880,
        5246819/75246796800]

        and we indeed get a few terms of Stirling's expansion. Note
        that it definitely helps to normalize with a limit computed to higher
        accuracy (as a rule of thumb, multiply the bit accuracy by :math:`1.612`):

        ::

        ? l = limitnum(f)
        ? asympnum(n->f(n) / l) \\ failure again !!!
        %6 = []

        We treat again the example of the Motzkin numbers :math:`M_{n}` given
        in :literal:`limitnum`:

        ::

        \\ [M_k, M_{k*2}, ..., M_{k*N}] / (3^n / n^(3/2))
        ? vM(N, k = 1) =
        { my(q = k*N, V);
        if (q == 1, return ([1/3]));
        V = vector(q); V[1] = V[2] = 1;
        for(n = 2, q - 1,
        V[n+1] = ((2*n + 1)*V[n] + 3*(n - 1)*V[n-1]) / (n + 2));
        f = (n -> 3^n / n^(3/2));
        return (vector(N, n, V[n*k] / f(n*k)));
        }
        ? localprec(100); l = limitnum(n->vM(n,10)); \\ 3/sqrt(12*Pi)
        ? \p38
        ? asympnum(n->vM(n,10)/l)
        %2 = [1, -3/32, 101/10240, -1617/1638400, 505659/5242880000, ...]

        If :literal:`alpha` is not a rational number, loss of accuracy is
        expected, so it should be precomputed to double accuracy, say:

        ::

        ? \p38
        ? asympnum(n->log(1+1/n^Pi),Pi)
        %1 = [0, 1, -1/2, 1/3, -1/4, 1/5]
        ? localprec(76); a = Pi;
        ? asympnum(n->log(1+1/n^Pi), a) \\ more terms
        %3 = [0, 1, -1/2, 1/3, -1/4, 1/5, -1/6, 1/7, -1/8, 1/9, -1/10, 1/11, -1/12]
        ? asympnum(n->log(1+1/sqrt(n)),1/2) \\ many more terms
        %4 = 49

        The expression is evaluated for :math:`n = 1, 2,..., N`
        for an :math:`N = O(B)` if the current bit accuracy is :math:`B`. If it is not defined
        for one of these values, translate or rescale accordingly:

        ::

        ? asympnum(n->log(1-1/n)) \\ can't evaluate at n = 1 !
        *** at top-level: asympnum(n->log(1-1/n))
        *** ^-----------------------
        *** in function asympnum: log(1-1/n)
        *** ^----------
        *** log: domain error in log: argument = 0
        ? asympnum(n->-log(1-1/(2*n)))
        %5 = [0, 1/2, 1/8, 1/24, ...]
        ? asympnum(n->-log(1-1/(n+1)))
        %6 = [0, 1, -1/2, 1/3, -1/4, ...]
        '''
        cdef bint _have_alpha = (alpha is not None)
        if _have_alpha:
            alpha = objtogen(alpha)
        sig_on()
        cdef GEN _expr = (<Gen>expr).g
        cdef GEN _alpha = NULL
        if _have_alpha:
            _alpha = (<Gen>alpha).g
        precision = nbits2prec(precision)
        cdef GEN _ret = asympnum0(_expr, _alpha, precision)
        return new_gen(_ret)

    def asympnumraw(expr, long N, alpha=None, long precision=DEFAULT_BITPREC):
        r'''
        Return the :math:`N+1` first terms of asymptotic expansion of :emphasis:`expr`,
        corresponding to a sequence :math:`u(n)`, as floating point numbers. Assume
        that the expansion has the shape

        .. MATH::

        u(n) ~ \sum_{i >= 0} a_{i} n^{-i\alpha}

        and return approximation of :math:`[a_{0}, a_{1},..., a_{N}]`.
        The algorithm is heuristic and performs repeated calls to limitnum, with
        :literal:`alpha` as in :literal:`limitnum`. As in :literal:`limitnum`, :math:`u(n)` may be
        given either by a closure :math:`n:---> u(n)` or as a closure :math:`N:--->
        [u(1),...,u(N)]`, the latter being often more efficient. This function
        is related to, but more flexible than, :literal:`asympnum`, which requires
        rational asymptotic expansions.

        ::

        ? f(n) = n! / (n^n*exp(-n)*sqrt(n));
        ? asympnum(f)
        %2 = [] \\ failure !
        ? v = asympnumraw(f, 10);
        ? v[1] - sqrt(2*Pi)
        %4 = 0.E-37
        ? bestappr(v / v[1], 2^60)
        %5 = [1, 1/12, 1/288, -139/51840, -571/2488320, 163879/209018880,...]

        and we indeed get a few terms of Stirling's expansion (the
        first 9 terms are correct).
        If :math:`u(n)` has an asymptotic expansion in :math:`n^{-\alpha}` with :math:`\alpha` not an
        integer, the default :math:`alpha = 1` is inaccurate:

        ::

        ? f(n) = (1+1/n^(7/2))^(n^(7/2));
        ? v1 = asympnumraw(f,10);
        ? v1[1] - exp(1)
        %8 = 4.62... E-12
        ? v2 = asympnumraw(f,10,7/2);
        ? v2[1] - exp(1)
        %7 0.E-37

        As in :literal:`asympnum`, if :literal:`alpha` is not a rational number,
        loss of accuracy is expected, so it should be precomputed to double
        accuracy, say.
        '''
        cdef bint _have_alpha = (alpha is not None)
        if _have_alpha:
            alpha = objtogen(alpha)
        sig_on()
        cdef GEN _expr = (<Gen>expr).g
        cdef GEN _alpha = NULL
        if _have_alpha:
            _alpha = (<Gen>alpha).g
        precision = nbits2prec(precision)
        cdef GEN _ret = asympnumraw0(_expr, N, _alpha, precision)
        return new_gen(_ret)

    def atan(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of :math:`tan^{-1}(x) = \log ((1+ix)/(1-ix)) /
        2i`. In particular the real part of :math:`atan(x)` belongs to
        :math:`]-\pi/2,\pi/2[`.
        The branch cut is in two pieces:
        :math:`]-i oo ,-i[`, continuous with quadrant IV, and :math:`]i,+i oo [` continuous
        with quadrant II. The function satisfies :math:`atan(x) =
        -iatanh(ix)` for all :math:`x ! = ± i`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gatan(_x, precision)
        return new_gen(_ret)

    def atanh(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of :math:`tanh^{-1}(x) = \log ((1+x)/(1-x)) / 2`. In
        particular the imaginary part of :math:`atanh(x)` belongs to
        :math:`[-\pi/2,\pi/2]`; if :math:`x\in \mathbb{R}` and :math:`\|x\| > 1` then :math:`atanh(x)` is complex.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gatanh(_x, precision)
        return new_gen(_ret)

    def besselh1(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`H^{1}`-Bessel function of index :emphasis:`nu` and argument :math:`x`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = hbessel1(_nu, _x, precision)
        return new_gen(_ret)

    def besselh2(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`H^{2}`-Bessel function of index :emphasis:`nu` and argument :math:`x`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = hbessel2(_nu, _x, precision)
        return new_gen(_ret)

    def besseli(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`I`-Bessel function of index :emphasis:`nu` and
        argument :math:`x`. If :math:`x` converts to a power series, the initial factor
        :math:`(x/2)^{\nu}/\Gamma (\nu+1)` is omitted (since it cannot be represented in PARI
        when :math:`\nu` is not integral).
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ibessel(_nu, _x, precision)
        return new_gen(_ret)

    def besselj(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`J`-Bessel function of index :emphasis:`nu` and
        argument :math:`x`. If :math:`x` converts to a power series, the initial factor
        :math:`(x/2)^{\nu}/\Gamma (\nu+1)` is omitted (since it cannot be represented in
        PARI when :math:`\nu` is not integral).
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = jbessel(_nu, _x, precision)
        return new_gen(_ret)

    def besseljh(n, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`J`-Bessel function of half integral index.
        More precisely, :math:`besseljh (n,x)` computes :math:`J_{n+1/2}(x)` where :math:`n`
        must be of type integer, and :math:`x` is any element of :math:`\mathbb{C}`. In the
        present version :strong:`2.17.2`, this function is not very accurate when :math:`x` is small.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _n = (<Gen>n).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = jbesselh(_n, _x, precision)
        return new_gen(_ret)

    def besseljzero(nu, long k=1, long precision=DEFAULT_BITPREC):
        r'''
        :math:`k`-th zero of the :math:`J`-Bessel function of index :emphasis:`nu`, close
        to :math:`\pi (\nu/2 + k - 1/4)`, usually noted :math:`j_{\nu,k}`.

        ::

        ? besseljzero(0) \\ {first zero of J_{0}}
        %1 = 2.4048255576957727686216318793264546431
        ? besselj(0, %)
        %2 = 7.1951595399463653939930598011247182898 E-41
        ? besseljzero(0, 2) \\ {second zero}
        %3 = 5.5200781102863106495966041128130274252
        ? besseljzero(I) \\ {also works for complex orders, here J_{i}}
        %4 = 2.5377... + 1.4753...*I

        The function uses a Newton iteration due to Temme.
        If :math:`\nu` is real and nonnegative, the result is guaranteed and the function really
        returns the :math:`k`-th positive zero of :math:`J_{\nu}`. For general :math:`\nu`, the result
        is not well defined, given by the Newton iteration with :math:`\pi (\nu/2 + k - 1/4)`
        as a starting value. (N.B. Using this method for large real :math:`\nu` would give
        completely different results than the :math:`j_{\nu,k}` unless :math:`k` is large enough.)
        '''
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _ret = besseljzero(_nu, k, precision)
        return new_gen(_ret)

    def besselk(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`K`-Bessel function of index :emphasis:`nu` and argument :math:`x`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = kbessel(_nu, _x, precision)
        return new_gen(_ret)

    def besseln(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        Deprecated alias for :literal:`bessely`.
        '''
        from warnings import warn
        warn('the PARI/GP function besseln is obsolete (2018-12-10)', DeprecationWarning)
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ybessel(_nu, _x, precision)
        return new_gen(_ret)

    def bessely(nu, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`Y`-Bessel function of index :emphasis:`nu` and argument :math:`x`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ybessel(_nu, _x, precision)
        return new_gen(_ret)

    def besselyzero(nu, long k=1, long precision=DEFAULT_BITPREC):
        r'''
        :math:`k`-th zero of the :math:`Y`-Bessel function of index :emphasis:`nu`, close
        to :math:`\pi (\nu/2 + k - 3/4)`, usually noted :math:`y_{\nu,k}`.

        ::

        ? besselyzero(0) \\ {first zero of Y_{0}}
        %1 = 0.89357696627916752158488710205833824123
        ? bessely(0, %)
        %2 = 1.8708573650996561952 E-39
        ? besselyzero(0, 2) \\ {second zero}
        %3 = 3.9576784193148578683756771869174012814
        ? besselyzero(I) \\ {also works for complex orders, here Y_{i}}
        %4 = 1.03930... + 1.3266...*I

        The function uses a Newton iteration due to Temme.
        If :math:`\nu` is real and nonnegative, the result is guaranteed and the function really
        returns the :math:`k`-th positive zero of :math:`Y_{\nu}`. For general :math:`\nu`, the result
        is not well defined, given by Newton iteration with :math:`\pi (\nu/2 + k - 3/4)`
        as a starting value. (N.B. Using this method for large real :math:`\nu` would give
        completely different results than the :math:`y_{\nu,k}` unless :math:`k` is large enough.)
        '''
        sig_on()
        cdef GEN _nu = (<Gen>nu).g
        cdef GEN _ret = besselyzero(_nu, k, precision)
        return new_gen(_ret)

    def bestappr(x, B=None):
        r'''
        Using variants of the extended Euclidean algorithm, returns a rational
        approximation :math:`a/b` to :math:`x`, whose denominator is limited
        by :math:`B`, if present. If :math:`B` is omitted, returns the best approximation
        affordable given the input accuracy; if you are looking for true rational
        numbers, presumably approximated to sufficient accuracy, you should first
        try that option. Otherwise, :math:`B` must be a positive real scalar (impose
        :math:`0 < b <= B`).

        - If :math:`x` is a :literal:`t_REAL` or a :literal:`t_FRAC`, this function uses continued
        fractions.

        ::

        ? bestappr(Pi, 100)
        %1 = 22/7
        ? bestappr(0.1428571428571428571428571429)
        %2 = 1/7
        ? bestappr([Pi, sqrt(2) + 'x], 10^3)
        %3 = [355/113, x + 1393/985]

        By definition, :math:`a/b` is the best rational approximation to :math:`x` if
        :math:`\|b x - a\| < \|v x - u\|` for all integers :math:`(u,v)` with :math:`0 < v <= B`.
        (Which implies that :math:`n/d` is a convergent of the continued fraction of :math:`x`.)

        - If :math:`x` is a :literal:`t_INTMOD` modulo :math:`N` or a :literal:`t_PADIC` of precision :math:`N =
        p^{k}`, this function performs rational modular reconstruction modulo :math:`N`. The
        routine then returns the unique rational number :math:`a/b` in coprime integers
        :math:`\|a\| < N/2B` and :math:`b <= B` which is congruent to :math:`x` modulo :math:`N`. Omitting
        :math:`B` amounts to choosing it of the order of :math:`\sqrt{N/2}`. If rational
        reconstruction is not possible (no suitable :math:`a/b` exists), returns :math:`[]`.

        ::

        ? bestappr(Mod(18526731858, 11^10))
        %1 = 1/7
        ? bestappr(Mod(18526731858, 11^20))
        %2 = []
        ? bestappr(3 + 5 + 3*5^2 + 5^3 + 3*5^4 + 5^5 + 3*5^6 + O(5^7))
        %2 = -1/3

        In most concrete uses, :math:`B` is a prime power and we performed
        Hensel lifting to obtain :math:`x`.

        The function applies recursively to components of complex objects
        (polynomials, vectors,...). If rational reconstruction fails for even a
        single entry, returns :math:`[]`.
        '''
        cdef bint _have_B = (B is not None)
        if _have_B:
            B = objtogen(B)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _B = NULL
        if _have_B:
            _B = (<Gen>B).g
        cdef GEN _ret = bestappr(_x, _B)
        return new_gen(_ret)

    def bestapprPade(x, long B=-1, long Q=-1):
        r'''
        Using variants of the extended Euclidean algorithm (Padé
        approximants), returns a rational
        function approximation :math:`a/b` to :math:`x`, whose denominator is limited
        by :math:`B`, if present. If :math:`B` is omitted, return the best approximation
        affordable given the input accuracy; if you are looking for true rational
        functions, presumably approximated to sufficient accuracy, you should first
        try that option. Otherwise, :math:`B` must be a nonnegative real
        (impose :math:`0 <= degree(b) <= B`).

        - If :math:`x` is a :literal:`t_POLMOD` modulo :math:`N` this function performs rational
        modular reconstruction modulo :math:`N`. The routine then returns the unique
        rational function :math:`a/b` in coprime polynomials, with :math:`degree(b) <= B`
        and :math:`degree(a)` minimal, which is congruent to :math:`x` modulo :math:`N`.
        Omitting :math:`B` amounts to choosing it equal to the floor of
        :math:`degree(N) / 2`. If rational reconstruction is not possible (no
        suitable :math:`a/b` exists), returns :math:`[]`.

        ::

        ? T = Mod(x^3 + x^2 + x + 3, x^4 - 2);
        ? bestapprPade(T)
        %2 = (2*x - 1)/(x - 1)
        ? U = Mod(1 + x + x^2 + x^3 + x^5, x^9);
        ? bestapprPade(U) \\ internally chooses B = 4
        %3 = []
        ? bestapprPade(U, 5) \\ with B = 5, a solution exists
        %4 = (2*x^4 + x^3 - x - 1)/(-x^5 + x^3 + x^2 - 1)

        - If :math:`x` is a :literal:`t_SER`, we implicitly
        convert the input to a :literal:`t_POLMOD` modulo :math:`N = t^{k}` where :math:`k` is the
        series absolute precision.

        ::

        ? T = 1 + t + t^2 + t^3 + t^4 + t^5 + t^6 + O(t^7); \\ mod t^7
        ? bestapprPade(T)
        %1 = 1/(-t + 1)

        - If :math:`x` is a :literal:`t_SER` and both :math:`B` and :math:`Q` are nonnegative,
        returns a rational function approximation :math:`a/b`
        to :math:`x`, with :math:`a` of degree at most :math:`B` and :math:`b` of degree at most :math:`Q`, with
        :math:`x-a/b = O(t^{B+Q+1+v})` if :math:`t` is the variable, where :math:`v` is the valuation
        of :math:`x`, the empty vector if not possible.

        - If :math:`x` is a :literal:`t_RFRAC`, we implicitly convert the input to a
        :literal:`t_POLMOD` modulo :math:`N = t^{k}` where :math:`k = 2B + 1`. If :math:`B` was omitted,
        we return :math:`x`:

        ::

        ? T = (4*t^2 + 2*t + 3)/(t+1)^10;
        ? bestapprPade(T,1)
        %2 = [] \\ impossible
        ? bestapprPade(T,2)
        %3 = 27/(337*t^2 + 84*t + 9)
        ? bestapprPade(T,3)
        %4 = (4253*t - 3345)/(-39007*t^3 - 28519*t^2 - 8989*t - 1115)

        The function applies recursively to components of complex objects
        (polynomials, vectors,...). If rational reconstruction fails for even a
        single entry, return :math:`[]`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = bestapprPade0(_x, B, Q)
        return new_gen(_ret)

    def bestapprnf(V, T, rootT=None, long precision=DEFAULT_BITPREC):
        r'''
        :math:`T` being an integral polynomial and :math:`V` being a scalar, vector, or
        matrix with complex coefficients, return a reasonable approximation of :math:`V`
        with polmods modulo :math:`T`. :math:`T` can also be any number field structure, in which
        case the minimal polynomial attached to the structure (:literal:`:math:`T``.pol) is
        used. The :emphasis:`rootT` argument, if present, must be an element of
        :literal:`polroots(:math:`T`)` (or :literal:`:math:`T``.pol), i.e. a complex root of :math:`T` fixing an embedding of
        :math:`\mathbb{Q}[x]/(T)` into :math:`\mathbb{C}`.

        ::

        ? bestapprnf(sqrt(5), polcyclo(5))
        %1 = Mod(-2*x^3 - 2*x^2 - 1, x^4 + x^3 + x^2 + x + 1)
        ? bestapprnf(sqrt(5), polcyclo(5), exp(4*I*Pi/5))
        %2 = Mod(2*x^3 + 2*x^2 + 1, x^4 + x^3 + x^2 + x + 1)

        When the output has huge rational coefficients, try to
        increase the working :literal:`realbitprecision`: if the answer does not
        stabilize, consider that the reconstruction failed.
        Beware that if :math:`T` is not Galois over :math:`\mathbb{Q}`, some embeddings
        may not allow to reconstruct :math:`V`:

        ::

        ? T = x^3-2; vT = polroots(T); z = 3*2^(1/3)+1;
        ? bestapprnf(z, T, vT[1])
        %2 = Mod(3*x + 1, x^3 - 2)
        ? bestapprnf(z, T, vT[2])
        %3 = 4213714286230872/186454048314072 \\ close to 3*2^(1/3) + 1
        '''
        T = objtogen(T)
        cdef bint _have_rootT = (rootT is not None)
        if _have_rootT:
            rootT = objtogen(rootT)
        sig_on()
        cdef GEN _V = (<Gen>V).g
        cdef GEN _T = (<Gen>T).g
        cdef GEN _rootT = NULL
        if _have_rootT:
            _rootT = (<Gen>rootT).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bestapprnf(_V, _T, _rootT, precision)
        return new_gen(_ret)

    def bezout(x, y):
        r'''
        Deprecated alias for :literal:`gcdext`
        '''
        from warnings import warn
        warn('the PARI/GP function bezout is obsolete (2013-04-03)', DeprecationWarning)
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gcdext0(_x, _y)
        return new_gen(_ret)

    def bezoutres(A, B, v=None):
        r'''
        Deprecated alias for :literal:`polresultantext`
        '''
        from warnings import warn
        warn('the PARI/GP function bezoutres is obsolete (2015-01-13)', DeprecationWarning)
        B = objtogen(B)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = polresultantext0(_A, _B, _v)
        return new_gen(_ret)

    def bigomega(x):
        r'''
        Number of prime divisors of the integer :math:`\|x\|` counted with
        multiplicity:

        ::

        ? factor(392)
        %1 =
        [2 3]
        
        [7 2]
        
        ? bigomega(392)
        %2 = 5; \\ = 3+2
        ? omega(392)
        %3 = 2; \\ without multiplicity
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = bigomega(_x)
        clear_stack()
        return _ret

    def binary(x):
        r'''
        Outputs the vector of the binary digits of :math:`\|x\|`. Here :math:`x` can be an
        integer, a real number (in which case the result has two components, one for
        the integer part, one for the fractional part) or a vector/matrix.

        ::

        ? binary(10)
        %1 = [1, 0, 1, 0]
        
        ? binary(3.14)
        %2 = [[1, 1], [0, 0, 1, 0, 0, 0, [...]]
        
        ? binary([1,2])
        %3 = [[1], [1, 0]]

        For integer :math:`x >= 1`, the number of bits is
        :math:`logint (x,2) + 1`. By convention, :math:`0` has no digits:

        ::

        ? binary(0)
        %4 = []
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = binaire(_x)
        return new_gen(_ret)

    def binomial(n, k=None):
        r'''
        binomial coefficient :math:`binom{n}{k}`.
        Here :math:`k` must be an integer, but :math:`n` can be any PARI object. For nonnegative
        :math:`k`, :math:`binom{n}{k} = (n)_{k} / k!` is polynomial in :math:`n`, where :math:`(n)_{k} =
        n(n-1)...(n-k+1)` is the Pochhammer symbol used by combinatorists (which is
        different from the one used by analysts).

        ::

        ? binomial(4,2)
        %1 = 6
        ? n = 4; vector(n+1, k, binomial(n,k-1))
        %2 = [1, 4, 6, 4, 1]
        ? binomial('x, 2)
        %3 = 1/2*x^2 - 1/2*x

        When :math:`n` is a negative integer and :math:`k` is negative,
        we use Daniel Loeb's extension,

        .. MATH::

        \lim_{t\to 1} \Gamma (n+t) / \Gamma (k+t) / \Gamma (n-k+t).

        (Sets with a negative number of elements, :emphasis:`Adv. Math.` :strong:`91` (1992),
        no. 1, 64--74. See also :literal:`https://arxiv.org/abs/1105.3689`.)
        This way the symmetry relation :math:`binom{n}{k} = binom{n}{n - k}`
        becomes valid for all integers :math:`n` and :math:`k`, and
        the binomial theorem
        holds for all complex numbers :math:`a`, :math:`b`, :math:`n` with :math:`\|b\| < \|a\|`:

        .. MATH::

        (a + b)^{n} = \sum_{k >= 0} binom{n}{k} a^{n-k} b^{k}.

        Beware that this extension is incompatible with another traditional
        extension (:math:`binom{n}{k} := 0` if :math:`k < 0`); to enforce the latter, use

        ::

        BINOMIAL(n, k) = if (k >= 0, binomial(n, k));

        The argument :math:`k` may be omitted if :math:`n` is a
        nonnegative integer; in this case, return the vector with :math:`n+1`
        components whose :math:`k+1`-th entry is :literal:`binomial`:math:`(n,k)`

        ::

        ? binomial(4)
        %4 = [1, 4, 6, 4, 1]
        '''
        cdef bint _have_k = (k is not None)
        if _have_k:
            k = objtogen(k)
        sig_on()
        cdef GEN _n = (<Gen>n).g
        cdef GEN _k = NULL
        if _have_k:
            _k = (<Gen>k).g
        cdef GEN _ret = binomial0(_n, _k)
        return new_gen(_ret)

    def bitand(x, y):
        r'''
        Bitwise :literal:`and`
        of two integers :math:`x` and :math:`y`, that is the integer

        .. MATH::

        \sum_{i} (x_{i} and y_{i}) 2^{i}

        Negative numbers behave :math:`2`-adically, i.e. the result is the :math:`2`-adic limit
        of :literal:`bitand`:math:`(x_{n},y_{n})`, where :math:`x_{n}` and :math:`y_{n}` are nonnegative
        integers tending to :math:`x` and :math:`y` respectively. (The result is an ordinary
        integer, possibly negative.)

        ::

        ? bitand(5, 3)
        %1 = 1
        ? bitand(-5, 3)
        %2 = 3
        ? bitand(-5, -3)
        %3 = -7
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gbitand(_x, _y)
        return new_gen(_ret)

    def bitneg(x, long n=-1):
        r'''
        bitwise negation of an integer :math:`x`,
        truncated to :math:`n` bits, :math:`n >= 0`, that is the integer

        .. MATH::

        \sum_{i = 0}^{n-1} not (x_{i}) 2^{i}.

        The special case :math:`n = -1` means no truncation: an infinite sequence of
        leading :math:`1` is then represented as a negative number.

        See ``bitand`` (in the PARI manual) for the behavior for negative arguments.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gbitneg(_x, n)
        return new_gen(_ret)

    def bitnegimply(x, y):
        r'''
        Bitwise negated imply of two integers :math:`x` and
        :math:`y` (or :literal:`not` :math:`(x ==> y)`), that is the integer

        .. MATH::

        \sum
        (x_{i} and not (y_{i})) 2^{i}

        See ``bitand`` (in the PARI manual) for the behavior for negative arguments.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gbitnegimply(_x, _y)
        return new_gen(_ret)

    def bitor(x, y):
        r'''
        bitwise (inclusive)
        :literal:`or` of two integers :math:`x` and :math:`y`, that is the integer

        .. MATH::

        \sum
        (x_{i} or y_{i}) 2^{i}

        See ``bitand`` (in the PARI manual) for the behavior for negative arguments.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gbitor(_x, _y)
        return new_gen(_ret)

    def bitprecision(x, n=None):
        r'''
        The function behaves differently according to whether :math:`n` is
        present or not. If :math:`n` is missing, the function returns
        the (floating point) precision in bits of the PARI object :math:`x`.

        If :math:`x` is an exact object, the function returns :literal:`+oo`.

        ::

        ? bitprecision(exp(1e-100))
        %1 = 512 \\ 512 bits
        ? bitprecision( [ exp(1e-100), 0.5 ] )
        %2 = 128 \\ minimal accuracy among components
        ? bitprecision(2 + x)
        %3 = +oo \\ exact object

        Use :literal:`getlocalbitprec()` to retrieve the
        working bit precision (as modified by possible :literal:`localbitprec`
        statements).

        If :math:`n` is present and positive, the function creates a new object equal to :math:`x`
        with the new bit-precision roughly :math:`n`. In fact, the smallest multiple of 64
        (resp. 32 on a 32-bit machine) larger than or equal to :math:`n`.

        For :math:`x` a vector or a matrix, the operation is
        done componentwise; for series and polynomials, the operation is done
        coefficientwise. For real :math:`x`, :math:`n` is the number of desired significant
        :emphasis:`bits`. If :math:`n` is smaller than the precision of :math:`x`, :math:`x` is truncated,
        otherwise :math:`x` is extended with zeros. For exact or non-floating-point types,
        no change.

        ::

        ? bitprecision(Pi, 10) \\ actually 64 bits ~ 19 decimal digits
        %1 = 3.141592653589793239
        ? bitprecision(1, 10)
        %2 = 1
        ? bitprecision(1 + O(x), 10)
        %3 = 1 + O(x)
        ? bitprecision(2 + O(3^5), 10)
        %4 = 2 + O(3^5)
        '''
        cdef bint _have_n = (n is not None)
        if _have_n:
            n = objtogen(n)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _n = NULL
        if _have_n:
            _n = (<Gen>n).g
        cdef GEN _ret = bitprecision00(_x, _n)
        return new_gen(_ret)

    def bittest(x, long n):
        r'''
        Outputs the :math:`n-th` bit of :math:`x` starting
        from the right (i.e. the coefficient of :math:`2^{n}` in the binary expansion of :math:`x`).
        The result is 0 or 1. For :math:`x >= 1`, the highest 1-bit is at :math:`n =
        logint (x)` (and bigger :math:`n` gives :math:`0`).

        ::

        ? bittest(7, 0)
        %1 = 1 \\ the bit 0 is 1
        ? bittest(7, 2)
        %2 = 1 \\ the bit 2 is 1
        ? bittest(7, 3)
        %3 = 0 \\ the bit 3 is 0

        See ``bitand`` (in the PARI manual) for the behavior at negative arguments.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gbittest(_x, n)
        return new_gen(_ret)

    def bitxor(x, y):
        r'''
        Bitwise (exclusive) :literal:`or`
        of two integers :math:`x` and :math:`y`, that is the integer

        .. MATH::

        \sum (x_{i} xor y_{i}) 2^{i}

        See ``bitand`` (in the PARI manual) for the behavior for negative arguments.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gbitxor(_x, _y)
        return new_gen(_ret)

    def bnfcertify(bnf, long flag=0):
        r'''
        :math:`bnf` being as output by
        :literal:`bnfinit`, checks whether the result is correct, i.e. whether it is
        possible to remove the assumption of the Generalized Riemann
        Hypothesis. It is correct if and only if the answer is 1. If it is
        incorrect, the program may output some error message, or loop indefinitely.
        You can check its progress by increasing the debug level. The :emphasis:`bnf`
        structure must contain the fundamental units:

        ::

        ? K = bnfinit(x^3+2^2^3+1); bnfcertify(K)
        *** at top-level: K=bnfinit(x^3+2^2^3+1);bnfcertify(K)
        *** ^-------------
        *** bnfcertify: precision too low in makeunits [use bnfinit(,1)].
        ? K = bnfinit(x^3+2^2^3+1, 1); \\ include units
        ? bnfcertify(K)
        %3 = 1

        If :math:`flag` is present, only certify that the class group is a quotient of the
        one computed in bnf (much simpler in general); likewise, the computed units
        may form a subgroup of the full unit group. In this variant, the units are
        no longer needed:

        ::

        ? K = bnfinit(x^3+2^2^3+1); bnfcertify(K, 1)
        %4 = 1
        '''
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef long _ret = bnfcertify0(_bnf, flag)
        clear_stack()
        return _ret

    def bnfdecodemodule(nf, m):
        r'''
        If :math:`m` is a module as output in the
        first component of an extension given by :literal:`bnrdisclist`, outputs the
        true module.

        ::

        ? K = bnfinit(x^2+23); L = bnrdisclist(K, 10); s = L[2]
        %1 = [[[Vecsmall([8]), Vecsmall([1])], [[0, 0, 0]]],
        [[Vecsmall([9]), Vecsmall([1])], [[0, 0, 0]]]]
        ? bnfdecodemodule(K, s[1][1])
        %2 =
        [2 0]
        
        [0 1]
        ? bnfdecodemodule(K,s[2][1])
        %3 =
        [2 1]
        
        [0 1]
        '''
        m = objtogen(m)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = decodemodule(_nf, _m)
        return new_gen(_ret)

    def bnfinit(P, long flag=0, tech=None, long precision=DEFAULT_BITPREC):
        r'''
        Initializes a
        :literal:`bnf` structure. Used in programs such as :literal:`bnfisprincipal`,
        :literal:`bnfisunit` or :literal:`bnfnarrow`. By default, the results are conditional
        on the GRH, see ``GRHbnf`` (in the PARI manual). The result is a
        10-component vector :emphasis:`bnf`.

        This implements Buchmann's sub-exponential algorithm for computing the
        class group, the regulator and a system of fundamental units of the
        general algebraic number field :math:`K` defined by the irreducible polynomial :math:`P`
        with integer coefficients. The meaning of :math:`flag` is as follows:

        - :math:`flag = 0` (default). This is the historical behavior, kept for
        compatibility reasons and speed. It has severe drawbacks but is likely to be
        a little faster than the alternative, twice faster say, so only use it if
        speed is paramount, you obtain a useful speed gain for the fields
        under consideration, and you are only interested in the field invariants
        such as the classgroup structure or its regulator. The computations involve
        exact algebraic numbers which are replaced by floating point embeddings for
        the sake of speed. If the precision is insufficient, :literal:`gp` may not be able
        to compute fundamental units, nor to solve some discrete logarithm problems.
        It :emphasis:`may` be possible to increase the precision of the :literal:`bnf`
        structure using :literal:`nfnewprec` but this may fail, in particular when
        fundamental units are large. In short, the resulting :literal:`bnf`
        structure is correct and contains useful information but later
        function calls to :literal:`bnfisprincpal` or :literal:`bnrclassfield` may fail.

        When :math:`flag = 1`, we keep an exact algebraic version of all floating point data
        and this allows to guarantee that functions using the structure will always
        succeed, as well as to compute the fundamental units exactly. The units are
        computed in compact form, as a product of small :math:`S`-units, possibly with
        huge exponents. This flag also allows :literal:`bnfisprincipal` to compute
        generators of principal ideals in factored form as well. Be warned that
        expanding such products explicitly can take a very long time, but they can
        easily be mapped to floating point or :math:`\ell`-adic embeddings of bounded
        accuracy, or to :math:`K^{*}/(K^{*})^{\ell}`, and this is enough for applications. In
        short, this flag should be used by default, unless you have a very good
        reason for it, for instance building massive tables of class numbers, and
        you do not care about units or the effect large units would have on your
        computation.

        :math:`tech` is a technical vector (empty by default, see ``GRHbnf`` (in the PARI manual)).
        Careful use of this parameter may speed up your computations,
        but it is mostly obsolete and you should leave it alone.

        The components of a :emphasis:`bnf` are technical.
        In fact: :emphasis:`never access a component directly, always use
        a proper member function.` However, for the sake of completeness and internal
        documentation, their description is as follows. We use the notations
        explained in the book by H. Cohen, :emphasis:`A Course in Computational Algebraic
        Number Theory`, Graduate Texts in Maths :strong:`138`, Springer-Verlag, 1993,
        Section 6.5, and subsection 6.5.5 in particular.

        :math:`bnf[1]` contains the matrix :math:`W`, i.e. the matrix in Hermite normal
        form giving relations for the class group on prime ideal generators
        :math:`(p_{i})_{1 <= i <= r}`.

        :math:`bnf[2]` contains the matrix :math:`B`, i.e. the matrix containing the
        expressions of the prime ideal factorbase in terms of the :math:`p_{i}`.
        It is an :math:`r x c` matrix.

        :math:`bnf[3]` contains the complex logarithmic embeddings of the system of
        fundamental units which has been found. It is an
        :math:`(r_{1}+r_{2}) x (r_{1}+r_{2}-1)` matrix.

        :math:`bnf[4]` contains the matrix :math:`M"_{C}` of Archimedean components of the
        relations of the matrix :math:`(W\|B)`.

        :math:`bnf[5]` contains the prime factor base, i.e. the list of prime
        ideals used in finding the relations.

        :math:`bnf[6]` contains a dummy :math:`0`.

        :math:`bnf[7]` or :literal:`:emphasis:`bnf`.nf` is equal to the number field data
        :math:`nf` as would be given by :literal:`nfinit`.

        :math:`bnf[8]` is a vector containing the classgroup :literal:`:emphasis:`bnf`.clgp`
        as a finite abelian group, the regulator :literal:`:emphasis:`bnf`.reg`,
        the number of roots of unity and a generator :literal:`:emphasis:`bnf`.tu`, the
        fundamental units :emphasis:`in expanded form` :literal:`:emphasis:`bnf`.fu`. If the
        fundamental units were omitted in the :emphasis:`bnf`, :literal:`:emphasis:`bnf`.fu` returns
        the sentinel value :math:`0`. If :math:`flag = 1`, this vector contain also algebraic
        data corresponding to the fundamental units and to the discrete logarithm
        problem (see :literal:`bnfisprincipal`). In particular, if :math:`flag = 1` we may
        :emphasis:`only` know the units in factored form: the first call to
        :literal:`:emphasis:`bnf`.fu` expands them, which may be very costly, then caches the
        result.

        :math:`bnf[9]` is a vector used in :literal:`bnfisprincipal` only
        and obtained as follows. Let :math:`D = U W V` obtained by applying the
        Smith normal form algorithm to the matrix :math:`W` ( = :math:`bnf[1]`) and
        let :math:`U_{r}` be the reduction of :math:`U` modulo :math:`D`. The first elements of the
        factorbase are given (in terms of :literal:`bnf.gen`) by the columns of :math:`U_{r}`,
        with Archimedean component :math:`g_{a}`; let also :math:`GD_{a}` be the Archimedean
        components of the generators of the (principal) ideals defined by the
        :literal:`bnf.gen[i]^bnf.cyc[i]`. Then :math:`bnf[9] = [U_{r}, g_{a}, GD_{a}]`,
        followed by technical exact components which allow to recompute :math:`g_{a}` and
        :math:`GD_{a}` to higher accuracy.

        :math:`bnf[10]` is by default unused and set equal to 0. This field is used
        to store further information about the field as it becomes available, which
        is rarely needed, hence would be too expensive to compute during the initial
        :literal:`bnfinit` call. For instance, the generators of the principal ideals
        :literal:`bnf.gen[i]^bnf.cyc[i]` (during a call to :literal:`bnrisprincipal`), or
        those corresponding to the relations in :math:`W` and :math:`B` (when the :literal:`bnf`
        internal precision needs to be increased).
        '''
        cdef bint _have_tech = (tech is not None)
        if _have_tech:
            tech = objtogen(tech)
        sig_on()
        cdef GEN _P = (<Gen>P).g
        cdef GEN _tech = NULL
        if _have_tech:
            _tech = (<Gen>tech).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bnfinit0(_P, flag, _tech, precision)
        return new_gen(_ret)

    def bnfisintnorm(bnf, x, long flag=0):
        r'''
        Computes a complete system of
        solutions (modulo units of positive norm) of the absolute norm equation
        :math:`\mathrm{Norm} (a) = x`,
        where :math:`a` is an integer in :math:`bnf`. If :math:`bnf` has not been certified,
        the correctness of the result depends on the validity of GRH.
        If (optional) flag is set, allow returning solutions in factored form, which
        helps a lot when the fundamental units are large (equivalently, when :literal:`bnf.reg`
        is large); having an exact algebraic :math:`bnf` from :literal:`bnfinit(,1)` is
        necessary in this case, else setting the flag will mostly be a no-op.

        ::

        ? bnf = bnfinit(x^4-2, 1);
        ? bnfisintnorm(bnf,7)
        %2 = [-x^2 + x - 1, x^2 + x + 1]
        ? bnfisintnorm(bnf,-7)
        %3 = [-x^3 - 1, x^3 + 2*x^2 + 2*x + 1]
        
        ? bnf = bnfinit(x^2-2305843005992468481, 1);
        ? bnfisintnorm(bnf, 2305843008139952128)
        \\ stack overflow with 100GB parisize
        ? bnf.reg \\ fundamental unit is huge
        %6 = 14054016.227457155120413774802385952043
        
        ? v = bnfisintnorm(bnf, 2305843008139952128, 1); #v
        %7 = 31 \\ succeeds instantly
        ? s = v[1]; [type(s), matsize(s)]
        %8 = ["t_MAT", [165, 2]] \\ solution 1 is a product of 165 factors
        ? exponent(s[,2])
        %9 = 105

        The :emphasis:`exponents` have :math:`105` bits, so there is indeed little
        hope of writing down the solutions in expanded form.

        See also :literal:`bnfisnorm`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = bnfisintnorm0(_bnf, _x, flag)
        return new_gen(_ret)

    def bnfisnorm(bnf, x, long flag=1):
        r'''
        Tries to tell whether the
        rational number :math:`x` is the norm of some element y in :math:`bnf`. Returns a
        vector :math:`[a,b]` where :math:`x = Norm(a)*b`. Looks for a solution which is an :math:`S`-unit,
        with :math:`S` a certain set of prime ideals containing (among others) all primes
        dividing :math:`x`. If :math:`bnf` is known to be Galois, you may set :math:`flag = 0`
        (in this case, :math:`x` is a norm iff :math:`b = 1`). If :math:`flag` is nonzero the program adds
        to :math:`S` the following prime ideals, depending on the sign of :math:`flag`. If :math:`flag > 0`,
        the ideals of norm less than :math:`flag`. And if :math:`flag < 0` the ideals dividing :math:`flag`.

        Assuming GRH, the answer is guaranteed (i.e. :math:`x` is a norm iff :math:`b = 1`),
        if :math:`S` contains all primes less than :math:`4\log (\mathrm{disc} (Bnf))^{2}`, where
        :math:`Bnf` is the Galois closure of :math:`bnf`.

        See also :literal:`bnfisintnorm`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = bnfisnorm(_bnf, _x, flag)
        return new_gen(_ret)

    def bnfisprincipal(bnf, x, long flag=1):
        r'''
        :math:`bnf` being the
        number field data output by :literal:`bnfinit`, and :math:`x` being an ideal, this
        function tests whether the ideal is principal or not. The result is more
        complete than a simple true/false answer and solves a general discrete
        logarithm problem. Assume the class group is :math:`\oplus (\mathbb{Z}/d_{i}\mathbb{Z})g_{i}`
        (where the generators :math:`g_{i}` and their orders :math:`d_{i}` are respectively
        given by :literal:`bnf.gen` and :literal:`bnf.cyc`). The routine returns a row vector
        :math:`[e,t]`, where :math:`e` is a vector of exponents :math:`0 <= e_{i} < d_{i}`, and :math:`t`
        is a number field element such that

        .. MATH::

        x = (t) \prod_{i} g_{i}^{e_{i}}.

        For :emphasis:`given` :math:`g_{i}` (i.e. for a given :literal:`bnf`), the :math:`e_{i}` are unique,
        and :math:`t` is unique modulo units.

        In particular, :math:`x` is principal if and only if :math:`e` is the zero vector. Note
        that the empty vector, which is returned when the class number is :math:`1`, is
        considered to be a zero vector (of dimension :math:`0`).

        ::

        ? K = bnfinit(y^2+23);
        ? K.cyc
        %2 = [3]
        ? K.gen
        %3 = [[2, 0; 0, 1]] \\ a prime ideal above 2
        ? P = idealprimedec(K,3)[1]; \\ a prime ideal above 3
        ? v = bnfisprincipal(K, P)
        %5 = [[2]~, [3/4, 1/4]~]
        ? idealmul(K, v[2], idealfactorback(K, K.gen, v[1]))
        %6 =
        [3 0]
        
        [0 1]
        ? % == idealhnf(K, P)
        %7 = 1

        The binary digits of :math:`flag` mean:

        - :math:`1`: If set, outputs :math:`[e,t]` as explained above, otherwise returns
        only :math:`e`, which is easier to compute. The following idiom only tests
        whether an ideal is principal:

        ::

        is_principal(bnf, x) = !bnfisprincipal(bnf,x,0);

        - :math:`2`: It may not be possible to recover :math:`t`, given the initial accuracy
        to which the :literal:`bnf` structure was computed. In that case, a warning is
        printed and :math:`t` is set equal to the empty vector :literal:`[]~`. If this bit is
        set, increase the precision and recompute needed quantities until :math:`t` can be
        computed. Warning: setting this may induce :emphasis:`lengthy` computations, and
        the result may be too large to be physically representable in any case.
        You should consider using :math:`flag = 4` instead.

        - :math:`4`: Return :math:`t` in factored form (compact representation),
        as a small product of :math:`S`-units for a small set of finite places :math:`S`,
        possibly with huge exponents. This kind of result can be cheaply mapped to
        :math:`K^{*}/(K^{*})^{\ell}` or to :math:`\mathbb{C}` or :math:`\mathbb{Q}_{p}` to bounded accuracy and this
        is usually enough for applications. Explicitly expanding such a compact
        representation is possible using :literal:`nffactorback` but may be :emphasis:`very`
        costly. The algorithm is guaranteed to succeed if the :literal:`bnf` was computed
        using :literal:`bnfinit(,1)`. If not, the algorithm may fail to compute a huge
        generator in this case (and replace it by :literal:`[]~`). This is orders of
        magnitude faster than :math:`flag = 2` when the generators are indeed large.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = bnfisprincipal0(_bnf, _x, flag)
        return new_gen(_ret)

    def bnfissunit(bnf, sfu, x):
        r'''
        This function is obsolete, use :literal:`bnfisunit`.
        '''
        from warnings import warn
        warn('the PARI/GP function bnfissunit is obsolete (2020-01-15)', DeprecationWarning)
        sfu = objtogen(sfu)
        x = objtogen(x)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _sfu = (<Gen>sfu).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = bnfissunit(_bnf, _sfu, _x)
        return new_gen(_ret)

    def bnfisunit(bnf, x, U=None):
        r'''
        :emphasis:`bnf` being the number field data
        output by :literal:`bnfinit` and :math:`x` being an algebraic number (type integer,
        rational or polmod), this outputs the decomposition of :math:`x` on the fundamental
        units and the roots of unity if :math:`x` is a unit, the empty vector otherwise.
        More precisely, if :math:`u_{1}`,...,:math:`u_{r}` are the fundamental units, and :math:`\zeta`
        is the generator of the group of roots of unity (:literal:`bnf.tu`), the output is
        a vector :math:`[x_{1},...,x_{r},x_{r+1}]` such that :math:`x = u_{1}^{x_{1}}...
        u_{r}^{x_{r}}.\zeta^{x_{r+1}}`. The :math:`x_{i}` are integers but the last one
        (:math:`i = r+1`) is only defined modulo the order :math:`w` of :math:`\zeta` and is guaranteed
        to be in :math:`[0,w[`.

        Note that :emphasis:`bnf` need not contain the fundamental units explicitly: it may
        contain the placeholder :math:`0` instead:

        ::

        ? setrand(1); bnf = bnfinit(x^2-x-100000);
        ? bnf.fu
        %2 = 0
        ? u = [119836165644250789990462835950022871665178127611316131167, \
        379554884019013781006303254896369154068336082609238336]~;
        ? bnfisunit(bnf, u)
        %3 = [-1, 0]~

        The given :math:`u` is :math:`1/u_{1}`, where :math:`u_{1}` is the fundamental
        unit implicitly stored in :emphasis:`bnf`. In this case, :math:`u_{1}` was not computed
        and stored in algebraic form since the default accuracy was too low. Re-run
        the :literal:`bnfinit` command at :literal:`\\g1` or higher to see such diagnostics.

        This function allows :math:`x` to be given in factored form, but it then assumes
        that :math:`x` is an actual unit. (Because it is general too costly to check
        whether this is the case.)

        ::

        ? { v = [2, 85; 5, -71; 13, -162; 17, -76; 23, -37; 29, -104; [224, 1]~, -66;
        [-86, 1]~, 86; [-241, 1]~, -20; [44, 1]~, 30; [124, 1]~, 11; [125, -1]~, -11;
        [-214, 1]~, 33; [-213, -1]~, -33; [189, 1]~, 74; [190, -1]~, 104;
        [-168, 1]~, 2; [-167, -1]~, -8]; }
        ? bnfisunit(bnf,v)
        %5 = [1, 0]~

        Note that :math:`v` is the fundamental unit of :literal:`bnf` given in
        compact (factored) form.

        If the argument :literal:`U` is present, as output by :literal:`bnfunits(bnf, S)`,
        then the function decomposes :math:`x` on the :math:`S`-units generators given in
        :literal:`U[1]`.

        ::

        ? bnf = bnfinit(x^4 - x^3 + 4*x^2 + 3*x + 9, 1);
        ? bnf.sign
        %2 = [0, 2]
        ? S = idealprimedec(bnf,5); #S
        %3 = 2
        ? US = bnfunits(bnf,S);
        ? g = US[1]; #g \\ #S = #g, four S-units generators, in factored form
        %5 = 4
        ? g[1]
        %6 = [[6, -3, -2, -2]~ 1]
        ? g[2]
        %7 =
        [[-1, 1/2, -1/2, -1/2]~ 1]
        
        [ [4, -2, -1, -1]~ 1]
        ? [nffactorback(bnf, x) | x <- g]
        %8 = [[6, -3, -2, -2]~, [-5, 5, 0, 0]~, [-1, 1, -1, 0]~,
        [1, -1, 0, 0]~]
        
        ? u = [10,-40,24,11]~;
        ? a = bnfisunit(bnf, u, US)
        %9 = [2, 0, 1, 4]~
        ? nffactorback(bnf, g, a) \\ prod_i g[i]^a[i] still in factored form
        %10 =
        [[6, -3, -2, -2]~ 2]
        
        [ [0, 0, -1, -1]~ 1]
        
        [ [2, -1, -1, 0]~ -2]
        
        [ [1, 1, 0, 0]~ 2]
        
        [ [-1, 1, 1, 1]~ -1]
        
        [ [1, -1, 0, 0]~ 4]
        
        ? nffactorback(bnf,%) \\ u = prod_i g[i]^a[i]
        %11 = [10, -40, 24, 11]~
        '''
        x = objtogen(x)
        cdef bint _have_U = (U is not None)
        if _have_U:
            U = objtogen(U)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _U = NULL
        if _have_U:
            _U = (<Gen>U).g
        cdef GEN _ret = bnfisunit0(_bnf, _x, _U)
        return new_gen(_ret)

    def bnflog(bnf, l):
        r'''
        Let :emphasis:`bnf` be a :emphasis:`bnf` structure attached to the number field :math:`F` and let :math:`l` be
        a prime number (hereafter denoted :math:`\ell` for typographical reasons). Return
        the logarithmic :math:`\ell`-class group :math:`~{Cl}_{F}`
        of :math:`F`. This is an abelian group, conjecturally finite (known to be finite
        if :math:`F/\mathbb{Q}` is abelian). The function returns if and only if
        the group is indeed finite (otherwise it would run into an infinite loop).
        Let :math:`S = { p_{1},..., p_{k}}` be the set of :math:`\ell`-adic places
        (maximal ideals containing :math:`\ell`).
        The function returns :math:`[D, G(\ell), G']`, where

        - :math:`D` is the vector of elementary divisors for :math:`~{Cl}_{F}`.

        - :math:`G(\ell)` is the vector of elementary divisors for
        the (conjecturally finite) abelian group
        

        .. MATH::

        ~{\mathrm{Cl}}(\ell) =
        \{ a = \sum_{i <= k} a_{i} p_{i} : \deg_{F} a = 0},

        where the :math:`p_{i}` are the :math:`\ell`-adic places of :math:`F`; this is a
        subgroup of :math:`~{\mathrm{Cl}}`.

        - :math:`G'` is the vector of elementary divisors for the :math:`\ell`-Sylow :math:`Cl'`
        of the :math:`S`-class group of :math:`F`; the group :math:`~{\mathrm{Cl}}` maps to :math:`Cl'`
        with a simple co-kernel.
        '''
        l = objtogen(l)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _l = (<Gen>l).g
        cdef GEN _ret = bnflog(_bnf, _l)
        return new_gen(_ret)

    def bnflogdegree(nf, A, l):
        r'''
        Let :emphasis:`nf` be a :emphasis:`nf` structure attached to a number field :math:`F`,
        and let :math:`l` be a prime number (hereafter
        denoted :math:`\ell`). The
        :math:`\ell`-adified group of id\\`{e}les of :math:`F` quotiented by
        the group of logarithmic units is identified to the :math:`\ell`-group
        of logarithmic divisors :math:`\oplus \mathbb{Z}_{\ell} [p]`, generated by the
        maximal ideals of :math:`F`.

        The :emphasis:`degree` map :math:`\deg_{F}` is additive with values in :math:`\mathbb{Z}_{\ell}`,
        defined by :math:`\deg_{F} p = ~{f}_{p} \deg_{\ell} p`,
        where the integer :math:`~{f}_{p}` is as in :literal:`bnflogef` and
        :math:`\deg_{\ell} p`
        is :math:`\log_{\ell} p` for :math:`p ! = \ell`, :math:`\log_{\ell} (1 + \ell)` for
        :math:`p = \ell ! = 2` and :math:`\log_{\ell} (1 + 2^{2})` for :math:`p = \ell = 2`.

        Let :math:`A = \prod p^{n_{p}}` be an ideal and let :math:`~{A} =
        \sum n_{p} [p]` be the attached logarithmic divisor. Return the
        exponential of the :math:`\ell`-adic logarithmic degree :math:`\deg_{F} A`, which is a
        natural number.
        '''
        A = objtogen(A)
        l = objtogen(l)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _A = (<Gen>A).g
        cdef GEN _l = (<Gen>l).g
        cdef GEN _ret = bnflogdegree(_nf, _A, _l)
        return new_gen(_ret)

    def bnflogef(nf, pr):
        r'''
        Let :emphasis:`nf` be a :emphasis:`nf` structure attached to a number field :math:`F`
        and let :emphasis:`pr` be a :emphasis:`prid` structure attached to a
        maximal ideal :math:`p / p`. Return
        :math:`[~{e}(F_{p} / \mathbb{Q}_{p}), ~{f}(F_{p} / \mathbb{Q}_{p})]`
        the logarithmic ramification and residue degrees. Let :math:`\mathbb{Q}_{p}^{c}/\mathbb{Q}_{p}`
        be the cyclotomic :math:`\mathbb{Z}_{p}`-extension, then
        :math:`~{e} = [F_{p} : F_{p} \cap \mathbb{Q}_{p}^{c}]` and
        :math:`~{f} = [F_{p} \cap \mathbb{Q}_{p}^{c} : \mathbb{Q}_{p}]`. Note that
        :math:`~{e}~{f} = e(p/p) f(p/p)`, where :math:`e(p/p)` and :math:`f(p/p)` denote the
        usual ramification and residue degrees.

        ::

        ? F = nfinit(y^6 - 3*y^5 + 5*y^3 - 3*y + 1);
        ? bnflogef(F, idealprimedec(F,2)[1])
        %2 = [6, 1]
        ? bnflogef(F, idealprimedec(F,5)[1])
        %3 = [1, 2]
        '''
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = bnflogef(_nf, _pr)
        return new_gen(_ret)

    def bnfnarrow(bnf):
        r'''
        :emphasis:`bnf` being as output by
        :literal:`bnfinit`, computes the narrow class group of :emphasis:`bnf`. The output is
        a 3-component row vector :math:`v` analogous to the corresponding class group
        component :literal:`:emphasis:`bnf`.clgp`: the first component
        is the narrow class number :literal:`:math:`v`.no`, the second component is a vector
        containing the SNF cyclic components :literal:`:math:`v`.cyc` of
        the narrow class group, and the third is a vector giving the generators of
        the corresponding :literal:`:math:`v`.gen` cyclic groups. Note that this function is a
        special case of :literal:`bnrinit`; the :emphasis:`bnf` need not contain fundamental
        units.
        '''
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _ret = bnfnarrow(_bnf)
        return new_gen(_ret)

    def bnfsignunit(bnf):
        r'''
        :math:`bnf` being as output by
        :literal:`bnfinit`, this computes an :math:`r_{1} x (r_{1}+r_{2}-1)` matrix having
        :math:`±1`
        components, giving the signs of the real embeddings of the fundamental units.
        The following functions compute generators for the totally positive units:

        ::

        /* exponents of totally positive units generators on K.tu, K.fu */
        tpuexpo(K)=
        { my(M, S = bnfsignunit(K), [m,n] = matsize(S));
        \\ m = K.r1, n = r1+r2-1
        S = matrix(m,n, i,j, if (S[i,j] < 0, 1,0));
        S = concat(vectorv(m,i,1), S); \\ add sign(-1)
        M = matkermod(S, 2);
        if (M, mathnfmodid(M, 2), 2*matid(n+1))
        }
        
        /* totally positive fundamental units of bnf K */
        tpu(K)=
        { my(ex = tpuexpo(K)[,^1]); \\ remove ex[,1], corresponds to 1 or -1
        my(v = concat(K.tu[2], K.fu));
        [ nffactorback(K, v, c) | c <- ex];
        }
        '''
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _ret = signunits(_bnf)
        return new_gen(_ret)

    def bnfsunit(bnf, S, long precision=DEFAULT_BITPREC):
        r'''
        Computes the fundamental :math:`S`-units of the
        number field :math:`bnf` (output by :literal:`bnfinit`), where :math:`S` is a list of
        prime ideals (output by :literal:`idealprimedec`). The output is a vector :math:`v` with
        6 components.

        :math:`v[1]` gives a minimal system of (integral) generators of the :math:`S`-unit group
        modulo the unit group.

        :math:`v[2]` contains technical data needed by :literal:`bnfissunit`.

        :math:`v[3]` is an obsoleted component, now the empty vector.

        :math:`v[4]` is the :math:`S`-regulator (this is the product of the regulator, the
        :math:`S`-class number and the natural logarithms of the norms of the ideals
        in :math:`S`).

        :math:`v[5]` gives the :math:`S`-class group structure, in the usual abelian group
        format: a vector whose three components give in order the :math:`S`-class number,
        the cyclic components and the generators.

        :math:`v[6]` is a copy of :math:`S`.
        '''
        S = objtogen(S)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _S = (<Gen>S).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bnfsunit(_bnf, _S, precision)
        return new_gen(_ret)

    def bnfunits(bnf, S=None):
        r'''
        Return the fundamental units of the number field
        bnf output by bnfinit; if :math:`S` is present and is a list of prime ideals,
        compute fundamental :math:`S`-units instead. The first component of the result
        contains independent integral :math:`S`-units generators: first nonunits, then
        :math:`r_{1}+r_{2}-1` fundamental units, then the torsion unit. The result may be
        used
        as an optional argument to bnfisunit. The units are given in compact form:
        no expensive computation is attempted if the :emphasis:`bnf` does not already
        contain units.

        ::

        ? bnf = bnfinit(x^4 - x^3 + 4*x^2 + 3*x + 9, 1);
        ? bnf.sign \\ r1 + r2 - 1 = 1
        %2 = [0, 2]
        ? U = bnfunits(bnf); u = U[1];
        ? #u \\ r1 + r2 = 2 units
        %5 = 2;
        ? u[1] \\ fundamental unit as factorization matrix
        %6 =
        [[0, 0, -1, -1]~ 1]
        
        [[2, -1, -1, 0]~ -2]
        
        [ [1, 1, 0, 0]~ 2]
        
        [ [-1, 1, 1, 1]~ -1]
        ? u[2] \\ torsion unit as factorization matrix
        %7 =
        [[1, -1, 0, 0]~ 1]
        ? [nffactorback(bnf, z) | z <- u] \\ same units in expanded form
        %8 = [[-1, 1, -1, 0]~, [1, -1, 0, 0]~]

        Now an example involving :math:`S`-units for a nontrivial :math:`S`:

        ::

        ? S = idealprimedec(bnf,5); #S
        %9 = 2
        ? US = bnfunits(bnf, S); uS = US[1];
        ? g = [nffactorback(bnf, z) | z <- uS] \\ now 4 units
        %11 = [[6, -3, -2, -2]~, [-5, 5, 0, 0]~, [-1, 1, -1, 0]~, [1, -1, 0, 0]~]
        ? bnfisunit(bnf,[10,-40,24,11]~)
        %12 = []~ \\ not a unit
        ? e = bnfisunit(bnf, [10,-40,24,11]~, US)
        %13 = [2, 0, 1, 4]~ \\ ...but an S-unit
        ? nffactorback(bnf, g, e)
        %14 = [10, -40, 24, 11]~
        ? nffactorback(bnf, uS, e) \\ in factored form
        %15 =
        [[6, -3, -2, -2]~ 2]
        
        [ [0, 0, -1, -1]~ 1]
        
        [ [2, -1, -1, 0]~ -2]
        
        [ [1, 1, 0, 0]~ 2]
        
        [ [-1, 1, 1, 1]~ -1]
        
        [ [1, -1, 0, 0]~ 4]

        Note that in more complicated cases, any :literal:`nffactorback`
        fully expanding an element in factored form could be :emphasis:`very` expensive.
        On the other hand, the final example expands a factorization whose components
        are themselves in factored form, hence the result is a factored form:
        this is a cheap operation.
        '''
        cdef bint _have_S = (S is not None)
        if _have_S:
            S = objtogen(S)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _S = NULL
        if _have_S:
            _S = (<Gen>S).g
        cdef GEN _ret = bnfunits(_bnf, _S)
        return new_gen(_ret)

    def bnrL1(bnr, H=None, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Let :emphasis:`bnr` be the number field data output by :literal:`bnrinit` and
        :emphasis:`H` be a square matrix defining a congruence subgroup of the
        ray class group corresponding to :emphasis:`bnr` (the trivial congruence subgroup
        if omitted). This function returns, for each character :math:`\chi` of the ray
        class group which is trivial on :math:`H`, the value at :math:`s = 1` (or :math:`s = 0`) of the
        abelian :math:`L`-function attached to :math:`\chi`. For the value at :math:`s = 0`, the
        function returns in fact for each :math:`\chi` a vector :math:`[r_{\chi}, c_{\chi}]` where

        .. MATH::

        L(s, \chi) = c.s^{r} + O(s^{r + 1})

        near :math:`0`.

        The argument :emphasis:`flag` is optional, its binary digits
        mean 1: compute at :math:`s = 0` if unset or :math:`s = 1` if set, 2: compute the
        primitive :math:`L`-function attached to :math:`\chi` if unset or the :math:`L`-function
        with Euler factors at prime ideals dividing the modulus of :emphasis:`bnr` removed
        if set (that is :math:`L_{S}(s, \chi)`, where :math:`S` is the
        set of infinite places of the number field together with the finite prime
        ideals dividing the modulus of :emphasis:`bnr`), 3: return also the character if
        set.

        ::

        K = bnfinit(x^2-229);
        bnr = bnrinit(K,1);
        bnrL1(bnr)

        returns the order and the first nonzero term of :math:`L(s, \chi)` at :math:`s = 0`
        where :math:`\chi` runs through the characters of the class group of
        :math:`K = \mathbb{Q} (\sqrt{229})`. Then

        ::

        bnr2 = bnrinit(K,2);
        bnrL1(bnr2,,2)

        returns the order and the first nonzero terms of :math:`L_{S}(s, \chi)` at :math:`s = 0`
        where :math:`\chi` runs through the characters of the class group of :math:`K` and :math:`S` is
        the set of infinite places of :math:`K` together with the finite prime :math:`2`. Note
        that the ray class group modulo :math:`2` is in fact the class group, so
        :literal:`bnrL1(bnr2,0)` returns the same answer as :literal:`bnrL1(bnr,0)`.

        This function will fail with the message

        ::

        *** bnrL1: overflow in zeta_get_N0 [need too many primes].

        if the approximate functional equation requires us to sum
        too many terms (if the discriminant of :math:`K` is too large).
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bnrL1(_bnr, _H, flag, precision)
        return new_gen(_ret)

    def bnrchar(G, g, v=None):
        r'''
        Returns all characters :math:`\chi` on :math:`G` such that
        :math:`\chi (g_{i}) = e(v_{i})`, where :math:`e(x) = \exp (2i\pi x)`. :math:`G` is allowed to be a
        :emphasis:`bnr` struct (representing a ray class group) or a :emphasis:`znstar`
        (representing :math:`(\mathbb{Z}/N\mathbb{Z})^{*}`). If :math:`v` is omitted,
        returns all characters that are trivial on the :math:`g_{i}`. Else the vectors :math:`g`
        and :math:`v` must have the same length, the :math:`g_{i}` must be elements of :math:`G`, and
        each :math:`v_{i}` is a rational number whose denominator must divide the order of
        :math:`g_{i}` in :math:`G`.

        For convenience, the vector of the :math:`g_{i}`
        can be replaced by a matrix whose columns give their discrete logarithm
        in :math:`G`, for instance as given by :literal:`bnrisprincipal` if :math:`G` is a :emphasis:`bnr`;
        in this particular case, :math:`G` can be any finite abelian group
        given by a vector of elementary divisors.

        ::

        ? G = bnrinit(bnfinit(x), [160,[1]], 1); /* (Z/160Z)^* */
        ? G.cyc
        %2 = [8, 4, 2]
        ? g = G.gen;
        ? bnrchar(G, g, [1/2,0,0])
        %4 = [[4, 0, 0]] \\ a unique character
        ? bnrchar(G, [g[1],g[3]]) \\ all characters trivial on g[1] and g[3]
        %5 = [[0, 1, 0], [0, 2, 0], [0, 3, 0], [0, 0, 0]]
        ? bnrchar(G, [1,0,0;0,1,0;0,0,2])
        %6 = [[0, 0, 1], [0, 0, 0]] \\ characters trivial on given subgroup
        
        ? G = znstar(75, 1);
        ? bnrchar(G, [2, 7], [11/20, 1/4])
        %8 = [[1, 1]] \\ Dirichlet char: chi(2) = e(11/20), chi(7) = e(1/4)
        '''
        g = objtogen(g)
        cdef bint _have_v = (v is not None)
        if _have_v:
            v = objtogen(v)
        sig_on()
        cdef GEN _G = (<Gen>G).g
        cdef GEN _g = (<Gen>g).g
        cdef GEN _v = NULL
        if _have_v:
            _v = (<Gen>v).g
        cdef GEN _ret = bnrchar(_G, _g, _v)
        return new_gen(_ret)

    def bnrclassfield(bnr, subgp=None, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        :emphasis:`bnr` being as output by :literal:`bnrinit`, returns a relative equation
        for the class field corresponding to the congruence group defined by
        :math:`(bnr,subgp)` (the full ray class field if :emphasis:`subgp` is
        omitted). The subgroup can also be a :literal:`t_INT` :math:`n`,
        meaning :math:`n.Cl_{f}`. The function also handles a vector of
        subgroup, e.g, from :literal:`subgrouplist` and returns the vector of individual
        results in this case.

        If :math:`flag = 0`, returns a vector of polynomials such that the compositum of the
        corresponding fields is the class field; if :math:`flag = 1` returns a single
        polynomial; if :math:`flag = 2` returns a single absolute polynomial.

        ::

        ? bnf = bnfinit(y^3+14*y-1); bnf.cyc
        %1 = [4, 2]
        ? pol = bnrclassfield(bnf,,1) \\ Hilbert class field
        %2 = x^8 - 2*x^7 + ... + Mod(11*y^2 - 82*y + 116, y^3 + 14*y - 1)
        ? rnfdisc(bnf,pol)[1]
        %3 = 1
        ? bnr = bnrinit(bnf,3*5*7); bnr.cyc
        %4 = [24, 12, 12, 2]
        ? bnrclassfield(bnr,2) \\ maximal 2-elementary subextension
        %5 = [x^2 + (-21*y - 105), x^2 + (-5*y - 25), x^2 + (-y - 5), x^2 + (-y - 1)]
        \\ quadratic extensions of maximal conductor
        ? bnrclassfield(bnr, subgrouplist(bnr,[2]))
        %6 = [[x^2 - 105], [x^2 + (-105*y^2 - 1260)], [x^2 + (-105*y - 525)],
        [x^2 + (-105*y - 105)]]
        ? #bnrclassfield(bnr,subgrouplist(bnr,[2],1)) \\ all quadratic extensions
        %7 = 15

        When the subgroup contains :math:`n Cl_{f}`, where :math:`n` is
        fixed, it is advised to directly compute the :literal:`bnr` modulo :math:`n` to avoid
        expensive discrete logarithms:

        ::

        ? bnf = bnfinit(y^2-5); p = 1594287814679644276013;
        ? bnr = bnrinit(bnf,p); \\ very slow
        time = 24,146 ms.
        ? bnrclassfield(bnr, 2) \\ ... even though the result is trivial
        %3 = [x^2 - 1594287814679644276013]
        ? bnr2 = bnrinit(bnf,p,,2); \\ now fast
        time = 1 ms.
        ? bnrclassfield(bnr2, 2)
        %5 = [x^2 - 1594287814679644276013]

        This will save a lot of time when the modulus contains a
        maximal ideal whose residue field is large.
        '''
        cdef bint _have_subgp = (subgp is not None)
        if _have_subgp:
            subgp = objtogen(subgp)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _subgp = NULL
        if _have_subgp:
            _subgp = (<Gen>subgp).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bnrclassfield(_bnr, _subgp, flag, precision)
        return new_gen(_ret)

    def bnrclassno(A, B=None, C=None):
        r'''
        Let :math:`A`, :math:`B`, :math:`C` define a class field :math:`L` over a ground field :math:`K`
        (of type :literal:`[:emphasis:`bnr`]`,
        :literal:`[:emphasis:`bnr`, :emphasis:`subgroup`]`,
        or :literal:`[:emphasis:`bnf`, :emphasis:`modulus`]`,
        or :literal:`[:emphasis:`bnf`, :emphasis:`modulus`,:emphasis:`subgroup`]`,
        ``CFT`` (in the PARI manual)); this function returns the relative degree :math:`[L:K]`.

        In particular if :math:`A` is a :emphasis:`bnf` (with units), and :math:`B` a modulus,
        this function returns the corresponding ray class number modulo :math:`B`.
        One can input the attached :emphasis:`bid` (with generators if the subgroup
        :math:`C` is non trivial) for :math:`B` instead of the module itself, saving some time.

        This function is faster than :literal:`bnrinit` and should be used if only the
        ray class number is desired. See :literal:`bnrclassnolist` if you need ray class
        numbers for all moduli less than some bound.
        '''
        cdef bint _have_B = (B is not None)
        if _have_B:
            B = objtogen(B)
        cdef bint _have_C = (C is not None)
        if _have_C:
            C = objtogen(C)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = NULL
        if _have_B:
            _B = (<Gen>B).g
        cdef GEN _C = NULL
        if _have_C:
            _C = (<Gen>C).g
        cdef GEN _ret = bnrclassno0(_A, _B, _C)
        return new_gen(_ret)

    def bnrclassnolist(bnf, list):
        r'''
        :math:`bnf` being as
        output by :literal:`bnfinit`, and :emphasis:`list` being a list of moduli (with units) as
        output by :literal:`ideallist` or :literal:`ideallistarch`, outputs the list of the
        class numbers of the corresponding ray class groups. To compute a single
        class number, :literal:`bnrclassno` is more efficient.

        ::

        ? bnf = bnfinit(x^2 - 2);
        ? L = ideallist(bnf, 100, 2);
        ? H = bnrclassnolist(bnf, L);
        ? H[98]
        %4 = [1, 3, 1]
        ? l = L[1][98]; ids = vector(#l, i, l[i].mod[1])
        %5 = [[98, 88; 0, 1], [14, 0; 0, 7], [98, 10; 0, 1]]

        The weird :literal:`l[i].mod[1]`, is the first component of :literal:`l[i].mod`, i.e.
        the finite part of the conductor. (This is cosmetic: since by construction
        the Archimedean part is trivial, I do not want to see it). This tells us that
        the ray class groups modulo the ideals of norm 98 (printed as :literal:`\%5`) have
        respectively order :math:`1`, :math:`3` and :math:`1`. Indeed, we may check directly:

        ::

        ? bnrclassno(bnf, ids[2])
        %6 = 3
        '''
        list = objtogen(list)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _list = (<Gen>list).g
        cdef GEN _ret = bnrclassnolist(_bnf, _list)
        return new_gen(_ret)

    def bnrcompositum(A, B):
        r'''
        Given two abelian extensions :math:`A = [bnr1, H1]` and
        :math:`B = [bnr2, H2]`, where :literal:`bnr1` and :literal:`bnr2` are two :literal:`bnr`
        structures attached to the same base field, return their compositum
        as :literal:`[bnr, H]`. The modulus attached to :literal:`bnr` need not be the
        conductor of the compositum.

        ::

        ? Q = bnfinit(y);
        ? bnr1 = bnrinit(Q, [7, [1]]); bnr1.cyc
        %2 = [6]
        ? bnr2 = bnrinit(Q, [13, [1]]); bnr2.cyc
        %3 = [12]
        ? H1 = Mat(2); bnrclassfield(bnr1, H1)
        %4 = [x^2 + 7]
        ? H2 = Mat(2); bnrclassfield(bnr2, H2)
        %5 = [x^2 - 13]
        ? [bnr,H] = bnrcompositum([bnr1, H1], [bnr2,H2]);
        ? bnrclassfield(bnr,H)
        %7 = [x^2 - 13, x^2 + 7]
        '''
        B = objtogen(B)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = bnrcompositum(_A, _B)
        return new_gen(_ret)

    def bnrconductor(A, B=None, C=None, long flag=0):
        r'''
        Conductor :math:`f` of the subfield of a ray class field as defined by :math:`[A,B,C]`
        (of type :literal:`[:emphasis:`bnr`]`,
        :literal:`[:emphasis:`bnr`, :emphasis:`subgroup`]`,
        :literal:`[:emphasis:`bnf`, :emphasis:`modulus`]` or
        :literal:`[:emphasis:`bnf`, :emphasis:`modulus`, :emphasis:`subgroup`]`,
        ``CFT`` (in the PARI manual))

        If :math:`flag = 0`, returns :math:`f`.

        If :math:`flag = 1`, returns :math:`[f, Cl_{f}, H]`, where :math:`Cl_{f}` is the ray class group
        modulo :math:`f`, as a finite abelian group; finally :math:`H` is the subgroup of
        :math:`Cl_{f}` defining the extension.

        If :math:`flag = 2`, returns :math:`[f, bnr (f), H]`, as above except :math:`Cl_{f}` is
        replaced by a :literal:`bnr` structure, as output by :math:`bnrinit (,f)`, without
        generators unless the input contained a :emphasis:`bnr` with generators.

        In place of a subgroup :math:`H`, this function also accepts a character
        :literal:`chi` :math:`= (a_{j})`, expressed as usual in terms of the generators
        :literal:`bnr.gen`: :math:`\chi (g_{j}) = \exp (2i\pi a_{j} / d_{j})`, where :math:`g_{j}` has
        order :math:`d_{j} = bnr.cyc[j]`. In which case, the function returns
        respectively

        If :math:`flag = 0`, the conductor :math:`f` of :math:`Ker \chi`.

        If :math:`flag = 1`, :math:`[f, Cl_{f}, \chi_{f}]`, where :math:`\chi_{f}` is :math:`\chi` expressed
        on the minimal ray class group, whose modulus is the conductor.

        If :math:`flag = 2`, :math:`[f, bnr (f), \chi_{f}]`.

        :strong:`Note.` Using this function with :math:`flag ! = 0` is usually a
        bad idea and kept for compatibility and convenience only: :math:`flag = 1` has
        always been useless, since it is no faster than :math:`flag = 2` and returns less
        information; :math:`flag = 2` is mostly OK with two subtle drawbacks:

        - it returns the full :emphasis:`bnr` attached to the full ray class
        group, whereas in applications we only need :math:`Cl_{f}` modulo :math:`N`-th powers,
        where :math:`N` is any multiple of the exponent of :math:`Cl_{f}/H`. Computing directly the
        conductor, then calling :literal:`bnrinit` with optional argument :math:`N` avoids this
        problem.

        - computing the :emphasis:`bnr` needs only be done once for each
        conductor, which is not possible using this function.

        For maximal efficiency, the recommended procedure is as follows. Starting
        from data (character or congruence subgroups) attached to a modulus :math:`m`,
        we can first compute the conductors using this function with default :math:`flag =
        0`. Then for all data with a common conductor :math:`f \| m`, compute (once!) the
        :emphasis:`bnr` attached to :math:`f` using :literal:`bnrinit` (modulo :math:`N`-th powers for
        a suitable :math:`N`!) and finally map original data to the new :emphasis:`bnr` using
        :literal:`bnrmap`.
        '''
        cdef bint _have_B = (B is not None)
        if _have_B:
            B = objtogen(B)
        cdef bint _have_C = (C is not None)
        if _have_C:
            C = objtogen(C)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = NULL
        if _have_B:
            _B = (<Gen>B).g
        cdef GEN _C = NULL
        if _have_C:
            _C = (<Gen>C).g
        cdef GEN _ret = bnrconductor0(_A, _B, _C, flag)
        return new_gen(_ret)

    def bnrconductorofchar(bnr, chi):
        r'''
        This function is obsolete, use :emphasis:`bnrconductor`.
        '''
        from warnings import warn
        warn('the PARI/GP function bnrconductorofchar is obsolete (2015-11-11)', DeprecationWarning)
        chi = objtogen(chi)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = bnrconductorofchar(_bnr, _chi)
        return new_gen(_ret)

    def bnrdisc(A, B=None, C=None, long flag=0):
        r'''
        :math:`A`, :math:`B`, :math:`C` defining a class field :math:`L` over a ground field :math:`K`
        (of type :literal:`[:emphasis:`bnr`]`,
        :literal:`[:emphasis:`bnr`, :emphasis:`subgroup`]`,
        :literal:`[:emphasis:`bnr`, :emphasis:`character`]`,
        :literal:`[:emphasis:`bnf`, :emphasis:`modulus`]` or
        :literal:`[:emphasis:`bnf`, :emphasis:`modulus`, :emphasis:`subgroup`]`,
        ``CFT`` (in the PARI manual)), outputs data :math:`[N,r_{1},D]` giving the discriminant and
        signature of :math:`L`, depending on the binary digits of :emphasis:`flag`:

        - 1: if this bit is unset, output absolute data related to :math:`L/\mathbb{Q}`:
        :math:`N` is the absolute degree :math:`[L:\mathbb{Q}]`, :math:`r_{1}` the number of real places of :math:`L`,
        and :math:`D` the discriminant of :math:`L/\mathbb{Q}`. Otherwise, output relative data for :math:`L/K`:
        :math:`N` is the relative degree :math:`[L:K]`, :math:`r_{1}` is the number of real places of :math:`K`
        unramified in :math:`L` (so that the number of real places of :math:`L` is equal to :math:`r_{1}`
        times :math:`N`), and :math:`D` is the relative discriminant ideal of :math:`L/K`.

        - 2: if this bit is set and if the modulus is not the conductor of :math:`L`,
        only return 0.
        '''
        cdef bint _have_B = (B is not None)
        if _have_B:
            B = objtogen(B)
        cdef bint _have_C = (C is not None)
        if _have_C:
            C = objtogen(C)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = NULL
        if _have_B:
            _B = (<Gen>B).g
        cdef GEN _C = NULL
        if _have_C:
            _C = (<Gen>C).g
        cdef GEN _ret = bnrdisc0(_A, _B, _C, flag)
        return new_gen(_ret)

    def bnrdisclist(bnf, bound, arch=None):
        r'''
        :math:`bnf` being as output by :literal:`bnfinit` (with units), computes a
        list of discriminants of Abelian extensions of the number field by increasing
        modulus norm up to bound :emphasis:`bound`. The ramified Archimedean places are
        given by :emphasis:`arch`; all possible values are taken if :emphasis:`arch` is omitted.

        The alternative syntax :math:`bnrdisclist (bnf,list)` is
        supported, where :emphasis:`list` is as output by :literal:`ideallist` or
        :literal:`ideallistarch` (with units), in which case :emphasis:`arch` is disregarded.

        The output :math:`v` is a vector, where :math:`v[k]` is itself a vector :math:`w`, whose length
        is the number of ideals of norm :math:`k`.

        - We consider first the case where :emphasis:`arch` was specified. Each
        component of :math:`w` corresponds to an ideal :math:`m` of norm :math:`k`, and
        gives invariants attached to the ray class field :math:`L` of :math:`bnf` of
        conductor :math:`[m, arch]`. Namely, each contains a vector :math:`[m,d,r,D]` with
        the following meaning: :math:`m` is the prime ideal factorization of the modulus,
        :math:`d = [L:\mathbb{Q}]` is the absolute degree of :math:`L`, :math:`r` is the number of real places
        of :math:`L`, and :math:`D` is the factorization of its absolute discriminant. We set :math:`d
        = r = D = 0` if :math:`m` is not the finite part of a conductor.

        - If :emphasis:`arch` was omitted, all :math:`t = 2^{r_{1}}` possible values are taken
        and a component of :math:`w` has the form
        :math:`[m, [[d_{1},r_{1},D_{1}],..., [d_{t},r_{t},D_{t}]]]`,
        where :math:`m` is the finite part of the conductor as above, and
        :math:`[d_{i},r_{i},D_{i}]` are the invariants of the ray class field of conductor
        :math:`[m,v_{i}]`, where :math:`v_{i}` is the :math:`i`-th Archimedean component, ordered by
        inverse lexicographic order; so :math:`v_{1} = [0,...,0]`, :math:`v_{2} = [1,0...,0]`,
        etc. Again, we set :math:`d_{i} = r_{i} = D_{i} = 0` if :math:`[m,v_{i}]`
        is not a conductor.

        Finally, each prime ideal :math:`pr = [p,\alpha,e,f,\beta]` in the prime
        factorization :math:`m` is coded as the integer :math:`p.n^{2}+(f-1).n+(j-1)`,
        where :math:`n` is the degree of the base field and :math:`j` is such that

        :literal:`pr = idealprimedec(:emphasis:`nf`,p)[j]`.

        :math:`m` can be decoded using :literal:`bnfdecodemodule`.

        Note that to compute such data for a single field, either :literal:`bnrclassno`
        or :literal:`bnrdisc` are (much) more efficient.
        '''
        bound = objtogen(bound)
        cdef bint _have_arch = (arch is not None)
        if _have_arch:
            arch = objtogen(arch)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _bound = (<Gen>bound).g
        cdef GEN _arch = NULL
        if _have_arch:
            _arch = (<Gen>arch).g
        cdef GEN _ret = bnrdisclist0(_bnf, _bound, _arch)
        return new_gen(_ret)

    def bnrgaloisapply(bnr, mat, H):
        r'''
        Apply the automorphism given by its matrix :emphasis:`mat` to the congruence
        subgroup :math:`H` given as a HNF matrix.
        The matrix :emphasis:`mat` can be computed with :literal:`bnrgaloismatrix`.
        '''
        mat = objtogen(mat)
        H = objtogen(H)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _mat = (<Gen>mat).g
        cdef GEN _H = (<Gen>H).g
        cdef GEN _ret = bnrgaloisapply(_bnr, _mat, _H)
        return new_gen(_ret)

    def bnrgaloismatrix(bnr, aut):
        r'''
        Return the matrix of the action of the automorphism :emphasis:`aut` of the base
        field :literal:`bnf.nf` on the generators of the ray class field :literal:`bnr.gen`.
        The automorphism
        :emphasis:`aut` can be given as a polynomial, an algebraic number, or a vector of
        automorphisms and must stabilize the modulus :literal:`bnr.mod`. We also
        allow a Galois group as output by :literal:`galoisinit`, in which case a
        vector of matrices is returned corresponding to the generators
        :literal:`aut.gen`.
        Note: This function only makes sense when the ray class field attached to
        :emphasis:`bnr` is Galois, which is not checked.

        The generators :literal:`bnr.gen` need not be explicitly computed in the input
        :emphasis:`bnr`, which saves time: the result is well defined in this case also.

        ::

        ? K = bnfinit(a^4-3*a^2+253009); B = bnrinit(K,9); B.cyc
        %1 = [8400, 12, 6, 3]
        ? G = nfgaloisconj(K)
        %2 = [-a, a, -1/503*a^3 + 3/503*a, 1/503*a^3 - 3/503*a]~
        ? bnrgaloismatrix(B, G[2]) \\ G[2] = Id ...
        %3 =
        [1 0 0 0]
        
        [0 1 0 0]
        
        [0 0 1 0]
        
        [0 0 0 1]
        ? bnrgaloismatrix(B, G[3]) \\ automorphism of order 2
        %4 =
        [799 0 0 2800]
        
        [ 0 7 0 4]
        
        [ 4 0 5 2]
        
        [ 0 0 0 2]
        ? M = %^2; for (i=1, #B.cyc, M[i,] %= B.cyc[i]); M
        %5 = \\ acts on ray class group as automorphism of order 2
        [1 0 0 0]
        
        [0 1 0 0]
        
        [0 0 1 0]
        
        [0 0 0 1]

        See :literal:`bnrisgalois` for further examples.
        '''
        aut = objtogen(aut)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _aut = (<Gen>aut).g
        cdef GEN _ret = bnrgaloismatrix(_bnr, _aut)
        return new_gen(_ret)

    def bnrinit(bnf, f, long flag=0, cycmod=None):
        r'''
        :math:`bnf` is as
        output by :literal:`bnfinit` (including fundamental units), :math:`f` is a modulus,
        initializes data linked to the ray class group structure corresponding to
        this module, a so-called :literal:`bnr` structure. One can input the attached
        :emphasis:`bid` with generators for :math:`f` instead of the module itself, saving some
        time. (As in :literal:`idealstar`, the finite part of the conductor may be given
        by a factorization into prime ideals, as produced by :literal:`idealfactor`.)

        If the positive integer :literal:`cycmod` is present, only compute the ray class
        group modulo :literal:`cycmod`, which may save a lot of time when some maximal
        ideals in :math:`f` have a huge residue field. In applications, we are given
        a congruence subgroup :math:`H` and study the class field attached to
        :math:`Cl_{f}/H`. If that finite Abelian group has an exponent which divides
        :literal:`cycmod`, then we have changed nothing theoretically, while trivializing
        expensive discrete logs in residue fields (since computations can be
        made modulo :literal:`cycmod`-th powers). This is useful in :literal:`bnrclassfield`,
        for instance when computing :math:`p`-elementary extensions.

        The following member functions are available
        on the result: :literal:`.bnf` is the underlying :emphasis:`bnf`,
        :literal:`.mod` the modulus, :literal:`.bid` the :literal:`bid` structure attached to the
        modulus; finally, :literal:`.clgp`, :literal:`.no`, :literal:`.cyc`, :literal:`.gen` refer to the
        ray class group (as a finite abelian group), its cardinality, its elementary
        divisors, its generators (only computed if :math:`flag = 1`).

        The last group of functions are different from the members of the underlying
        :emphasis:`bnf`, which refer to the class group; use :literal:`:emphasis:`bnr`.bnf.:emphasis:`xxx``
        to access these, e.g. :literal:`:emphasis:`bnr`.bnf.cyc` to get the cyclic decomposition
        of the class group.

        They are also different from the members of the underlying :emphasis:`bid`, which
        refer to :math:`(\mathbb{Z}_{K}/f)^{*}`; use :literal:`:emphasis:`bnr`.bid.:emphasis:`xxx`` to access these,
        e.g. :literal:`:emphasis:`bnr`.bid.no` to get :math:`\phi (f)`.

        If :math:`flag = 0` (default), the generators of the ray class group are not
        explicitly computed, which saves time. Hence :literal:`:emphasis:`bnr`.gen` would
        produce an error. Note that implicit generators are still fixed and stored
        in the :emphasis:`bnr` (and guaranteed to be the same for fixed :emphasis:`bnf` and
        :emphasis:`bid` inputs), in terms of :literal:`bnr.bnf.gen` and :literal:`bnr.bid.gen`.
        The computation which is not performed is the expansion of such products
        in the ray class group so as to fix eplicit ideal representatives.

        If :math:`flag = 1`, as the default, except that generators are computed.
        '''
        f = objtogen(f)
        cdef bint _have_cycmod = (cycmod is not None)
        if _have_cycmod:
            cycmod = objtogen(cycmod)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _f = (<Gen>f).g
        cdef GEN _cycmod = NULL
        if _have_cycmod:
            _cycmod = (<Gen>cycmod).g
        cdef GEN _ret = bnrinitmod(_bnf, _f, flag, _cycmod)
        return new_gen(_ret)

    def bnrisconductor(A, B=None, C=None):
        r'''
        Fast variant of :literal:`bnrconductor`:math:`(A,B,C)`; :math:`A`, :math:`B`, :math:`C` represent
        an extension of the base field, given by class field theory
        (see ``CFT`` (in the PARI manual)). Outputs 1 if this modulus is the conductor, and 0
        otherwise. This is slightly faster than :literal:`bnrconductor` when the
        character or subgroup is not primitive.
        '''
        cdef bint _have_B = (B is not None)
        if _have_B:
            B = objtogen(B)
        cdef bint _have_C = (C is not None)
        if _have_C:
            C = objtogen(C)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = NULL
        if _have_B:
            _B = (<Gen>B).g
        cdef GEN _C = NULL
        if _have_C:
            _C = (<Gen>C).g
        cdef long _ret = bnrisconductor0(_A, _B, _C)
        clear_stack()
        return _ret

    def bnrisgalois(bnr, gal, H):
        r'''
        Check whether the class field attached to the subgroup :math:`H` is Galois
        over the subfield of :literal:`bnr.nf` fixed by the group :emphasis:`gal`, which can be
        given as output by :literal:`galoisinit`, or as a matrix or a vector of matrices as
        output by :literal:`bnrgaloismatrix`, the second option being preferable, since it
        saves the recomputation of the matrices. Note: The function assumes that the
        ray class field attached to :emphasis:`bnr` is Galois, which is not checked.

        In the following example, we lists the congruence subgroups of subextension of
        degree at most :math:`3` of the ray class field of conductor :math:`9` which are Galois
        over the rationals.

        ::

        ? K = bnfinit(a^4-3*a^2+253009); B = bnrinit(K,9); G = galoisinit(K);
        ? [H | H<-subgrouplist(B,3), bnrisgalois(B,G,H)];
        time = 160 ms.
        ? M = bnrgaloismatrix(B,G);
        ? [H | H<-subgrouplist(B,3), bnrisgalois(B,M,H)]
        time = 1 ms.

        The second computation is much faster since :literal:`bnrgaloismatrix(B,G)` is
        computed only once.
        '''
        gal = objtogen(gal)
        H = objtogen(H)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _H = (<Gen>H).g
        cdef long _ret = bnrisgalois(_bnr, _gal, _H)
        clear_stack()
        return _ret

    def bnrisprincipal(bnr, x, long flag=1):
        r'''
        Let :emphasis:`bnr` be the ray class group data output by
        :literal:`bnrinit`:math:`(,,1)` and let :math:`x` be an ideal in any form, coprime
        to the modulus :math:`f = bnr.mod`. Solves the discrete logarithm problem
        in the ray class group, with respect to the generators :literal:`bnr.gen`,
        in a way similar to :literal:`bnfisprincipal`. If :math:`x` is not coprime to the
        modulus of :emphasis:`bnr` the result is undefined. Note that :emphasis:`bnr` need not
        contain the ray class group generators, i.e. it may be created with
        :literal:`bnrinit`:math:`(,,0)`; in that case, although :literal:`bnr.gen` is undefined, we
        can still fix natural generators for the ray class group (in terms of the
        generators in :literal:`bnr.bnf.gen` and :literal:`bnr.bid.gen`) and compute with
        respect to them.

        The binary digits of :math:`flag` (default :math:`flag = 1`) mean:

        - :math:`1`: If set returns a 2-component vector :math:`[e,\alpha]` where :math:`e`
        is the vector of components of :math:`x` on the ray class group generators,
        :math:`\alpha` is an element congruent to :math:`1 mod^{*} f` such that
        :math:`x = \alpha \prod_{i} g_{i}^{e_{i}}`. If unset, returns only :math:`e`.

        - :math:`4`: If set, returns :math:`[e,\alpha]` where :math:`\alpha` is given in factored
        form (compact representation). This is orders of magnitude faster.

        ::

        ? K = bnfinit(x^2 - 30); bnr = bnrinit(K, [4, [1,1]]);
        ? bnr.clgp \\ ray class group is isomorphic to Z/4 x Z/2 x Z/2
        %2 = [16, [4, 2, 2]]
        ? P = idealprimedec(K, 3)[1]; \\ the ramified prime ideal above 3
        ? bnrisprincipal(bnr,P) \\ bnr.gen undefined !
        %5 = [[3, 0, 0]~, 9]
        ? bnrisprincipal(bnr,P, 0) \\ omit principal part
        %5 = [3, 0, 0]~
        ? bnr = bnrinit(bnr, bnr.bid, 1); \\ include explicit generators
        ? bnrisprincipal(bnr,P) \\ ... alpha is different !
        %7 = [[3, 0, 0]~, 1/128625]

        It may be surprising that the generator :math:`\alpha` is different
        although the underlying :emphasis:`bnf` and :emphasis:`bid` are the same. This defines
        unique generators for the ray class group as ideal :emphasis:`classes`, whether
        we use :literal:`bnrinit(,0)` or :literal:`bnrinit(,1)`. But the actual ideal
        representatives (implicit if :math:`flag = 0`, computed and stored in the
        :emphasis:`bnr` if :math:`flag = 1`) are in general different and this is what
        happens here. Indeed, the implicit generators are naturally expressed
        in terms of :literal:`bnr.bnf.gen` and :literal:`bnr.bid.gen` and :emphasis:`then`
        expanded and simplified (in the same ideal class) so that we obtain ideal
        representatives for :literal:`bnr.gen` which are as simple as possible.
        And indeed the quotient of the two :math:`\alpha` found is :math:`1` modulo the
        conductor (and positive at the infinite places it contains), and this is the
        only guaranteed property.

        Beware that, when :literal:`bnr` is generated using :literal:`bnrinit(, cycmod)`, the
        results are given in :math:`Cl_{f}` modulo :literal:`cycmod`-th powers:

        ::

        ? bnr2 = bnrinit(K, bnr.mod,, 2); \\ modulo squares
        ? bnr2.clgp
        %9 = [8, [2, 2, 2]] \\ bnr.clgp tensored by Z/2Z
        ? bnrisprincipal(bnr2,P, 0)
        %10 = [1, 0, 0]~
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = bnrisprincipal(_bnr, _x, flag)
        return new_gen(_ret)

    def bnrmap(A, B):
        r'''
        This function has two different uses:

        - if :math:`A` and :math:`B` are :emphasis:`bnr` structures for the same :emphasis:`bnf` attached
        to moduli :math:`m_{A}` and :math:`m_{B}` with :math:`m_{B} \| m_{A}`, return the canonical surjection
        from :math:`A` to :math:`B`, i.e. from the ray class group moodulo :math:`m_{A}` to the ray
        class group modulo :math:`m_{B}`. The map is coded by a triple
        :math:`[M,cyc_{A},cyc_{B}]`:
        :math:`M` gives the image of the fixed ray class group generators of :math:`A` in
        terms of the ones in :math:`B`, :math:`cyc_{A}` and :math:`cyc_{B}` are the cyclic
        structures :literal:`A.cyc` and :literal:`B.cyc` respectively. Note that this function
        does :emphasis:`not` need :math:`A` or :math:`B` to contain explicit generators for the ray
        class groups: they may be created using :literal:`bnrinit(,0)`.

        If :math:`B` is only known modulo :math:`N`-th powers (from :literal:`bnrinit(,N)`), the result
        is correct provided :math:`N` is a multiple of the exponent of :math:`A`.

        - if :math:`A` is a projection map as above and :math:`B` is either a congruence
        subgroup :math:`H`, or a ray class character :math:`\chi`, or a discrete logarithm
        (from :literal:`bnrisprincipal`) modulo :math:`m_{A}` whose conductor
        divides :math:`m_{B}`, return the image of the subgroup (resp. the character, the
        discrete logarighm) as defined modulo :math:`m_{B}`. The main use of this variant is
        to compute the primitive subgroup or character attached to a :emphasis:`bnr` modulo
        their conductor. This is more efficient than :literal:`bnrconductor` in two
        respects: the :emphasis:`bnr` attached to the conductor need only be computed once
        and, most importantly, the ray class group can be computed modulo :math:`N`-th
        powers, where :math:`N` is a multiple of the exponent of :math:`Cl_{m_{A}} / H`
        (resp.
        of the order of :math:`\chi`). Whereas :literal:`bnrconductor` is specified to return a
        :emphasis:`bnr` attached to the full ray class group, which may lead to untractable
        discrete logarithms in the full ray class group instead of a tiny quotient.
        '''
        B = objtogen(B)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = bnrmap(_A, _B)
        return new_gen(_ret)

    def bnrrootnumber(bnr, chi, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        If :math:`\chi = chi` is a
        character over :emphasis:`bnr`, not necessarily primitive, let
        :math:`L(s,\chi) = \sum_{id} \chi (id) N(id)^{-s}` be the attached
        Artin L-function. Returns the so-called Artin root number, i.e. the
        complex number :math:`W(\chi)` of modulus 1 such that

        .. MATH::

        \Lambda (1-s,\chi) = W(\chi) \Lambda (s,\overline{\chi})

        where :math:`\Lambda (s,\chi) = A(\chi)^{s/2}\gamma_{\chi}(s) L(s,\chi)` is
        the enlarged L-function attached to :math:`L`.

        You can set :math:`flag = 1` if the character is known to be primitive. Example:

        ::

        bnf = bnfinit(x^2 - x - 57);
        bnr = bnrinit(bnf, [7,[1,1]]);
        bnrrootnumber(bnr, [2,1])

        returns the root number of the character :math:`\chi` of
        :math:`\mathrm{Cl}_{7 oo _{1} oo _{2}}(\mathbb{Q} (\sqrt{229}))` defined by
        :math:`\chi (g_{1}^{a}g_{2}^{b})
        = \zeta_{1}^{2a}\zeta_{2}^{b}`. Here :math:`g_{1}, g_{2}` are the generators of the
        ray-class group given by :literal:`bnr.gen` and :math:`\zeta_{1} = e^{2i\pi/N_{1}},
        \zeta_{2} = e^{2i\pi/N_{2}}` where :math:`N_{1}, N_{2}` are the orders of :math:`g_{1}`
        and :math:`g_{2}` respectively (:math:`N_{1} = 6` and :math:`N_{2} = 3` as :literal:`bnr.cyc` readily
        tells us).
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _chi = (<Gen>chi).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bnrrootnumber(_bnr, _chi, flag, precision)
        return new_gen(_ret)

    def bnrstark(bnr, subgroup=None, long precision=DEFAULT_BITPREC):
        r'''
        :emphasis:`bnr` being as output by :literal:`bnrinit`, finds a relative equation
        for the class field corresponding to the modulus in :emphasis:`bnr` and the given
        congruence subgroup (as usual, omit :math:`subgroup` if you want the whole ray
        class group).

        The main variable of :emphasis:`bnr` must not be :math:`x`, and the ground field and the
        class field must be totally real. When the base field is :math:`\mathbb{Q}`, the vastly
        simpler :literal:`galoissubcyclo` is used instead. Here is an example:

        ::

        bnf = bnfinit(y^2 - 3);
        bnr = bnrinit(bnf, 5);
        bnrstark(bnr)

        returns the ray class field of :math:`\mathbb{Q} (\sqrt{3})` modulo :math:`5`. Usually, one wants
        to apply to the result one of

        ::

        rnfpolredbest(bnf, pol) \\ compute a reduced relative polynomial
        rnfpolredbest(bnf, pol, 2) \\ compute a reduced absolute polynomial

        The routine uses Stark units and needs to find a suitable auxiliary
        conductor, which may not exist when the class field is not cyclic over the
        base. In this case :literal:`bnrstark` is allowed to return a vector of
        polynomials defining :emphasis:`independent` relative extensions, whose compositum
        is the requested class field. We decided that it was useful to keep the
        extra information thus made available, hence the user has to take the
        compositum herself, see :literal:`nfcompositum`.

        Even if it exists, the auxiliary conductor may be so large that later
        computations become unfeasible. (And of course, Stark's conjecture may simply
        be wrong.) In case of difficulties, try :literal:`bnrclassfield`:

        ::

        ? bnr = bnrinit(bnfinit(y^8-12*y^6+36*y^4-36*y^2+9,1), 2);
        ? bnrstark(bnr)
        *** at top-level: bnrstark(bnr)
        *** ^-------------
        *** bnrstark: need 3919350809720744 coefficients in initzeta.
        *** Computation impossible.
        ? bnrclassfield(bnr)
        time = 20 ms.
        %2 = [x^2 + (-2/3*y^6 + 7*y^4 - 14*y^2 + 3)]
        '''
        cdef bint _have_subgroup = (subgroup is not None)
        if _have_subgroup:
            subgroup = objtogen(subgroup)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _subgroup = NULL
        if _have_subgroup:
            _subgroup = (<Gen>subgroup).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bnrstark(_bnr, _subgroup, precision)
        return new_gen(_ret)

    def bnrstarkunit(bnr, subgroup=None):
        r'''
        :emphasis:`bnr` being as output by :literal:`bnrinit`, returns the characteristic
        polynomial of the (conjectural) Stark unit corresponding to the modulus in
        :emphasis:`bnr` and the given congruence subgroup (as usual, omit :math:`subgroup`
        if you want the whole ray class group).

        The ground field attached to :emphasis:`bnr` must be totally real and
        all but one infinite place must become complex in the class field, which
        must be a quadratic extension of its totally real subfield. Finally,
        the output is given as a polynomial in :math:`x`, so the main
        variable of :emphasis:`bnr` must not be :math:`x`. Here is an example:

        ::

        ? bnf = bnfinit(y^2 - 2);
        ? bnr = bnrinit(bnf, [15, [1,0]]);
        ? lift(bnrstarkunit(bnr))
        %3 = x^8 + (-9000*y - 12728)*x^7 + (57877380*y + 81850978)*x^6 + ... + 1
        '''
        cdef bint _have_subgroup = (subgroup is not None)
        if _have_subgroup:
            subgroup = objtogen(subgroup)
        sig_on()
        cdef GEN _bnr = (<Gen>bnr).g
        cdef GEN _subgroup = NULL
        if _have_subgroup:
            _subgroup = (<Gen>subgroup).g
        cdef GEN _ret = bnrstarkunit(_bnr, _subgroup)
        return new_gen(_ret)

    def call(f, A):
        r'''
        :math:`A = [a_{1},..., a_{n}]` being a vector and :math:`f` being a function,
        returns the evaluation of :math:`f(a_{1},...,a_{n})`.
        :math:`f` can also be the name of a built-in GP function.
        If :math:`\# A = 1`, :literal:`call` (:math:`f,A`) = :literal:`apply` (:math:`f,A`)[1].
        If :math:`f` is variadic (has a variable number of arguments), then
        the variadic arguments are grouped in a vector in the last component of :math:`A`.

        This function is useful

        - when writing a variadic function, to call another one:

        ::

        fprintf(file,format,args[..]) = write(file, call(strprintf,[format,args]))

        - when dealing with function arguments with unspecified arity.

        The function below implements a global memoization interface:

        ::

        memo=Map();
        memoize(f,A[..])=
        {
        my(res);
        if(!mapisdefined(memo, [f,A], &res),
        res = call(f,A);
        mapput(memo,[f,A],res));
        res;
        }

        for example:

        ::

        ? memoize(factor,2^128+1)
        %3 = [59649589127497217,1;5704689200685129054721,1]
        ? ##
        *** last result computed in 76 ms.
        ? memoize(factor,2^128+1)
        %4 = [59649589127497217,1;5704689200685129054721,1]
        ? ##
        *** last result computed in 0 ms.
        ? memoize(ffinit,3,3)
        %5 = Mod(1,3)*x^3+Mod(1,3)*x^2+Mod(1,3)*x+Mod(2,3)
        ? fibo(n)=if(n==0,0,n==1,1,memoize(fibo,n-2)+memoize(fibo,n-1));
        ? fibo(100)
        %7 = 354224848179261915075

        - to call operators through their internal names without using
        :literal:`alias`

        ::

        matnbelts(M) = call("_*_",matsize(M))
        '''
        A = objtogen(A)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _A = (<Gen>A).g
        cdef GEN _ret = call0(_f, _A)
        return new_gen(_ret)

    def ceil(x):
        r'''
        Ceiling of :math:`x`. When :math:`x` is in :math:`\mathbb{R}`, the result is the
        smallest integer greater than or equal to :math:`x`. Applied to a rational
        function, :math:`ceil (x)` returns the Euclidean quotient of the numerator by
        the denominator.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gceil(_x)
        return new_gen(_ret)

    def centerlift(x, v=None):
        r'''
        Same as :literal:`lift`, except that :literal:`t_INTMOD` and :literal:`t_PADIC` components
        are lifted using centered residues:

        - for a :literal:`t_INTMOD` :math:`x\in \mathbb{Z}/n\mathbb{Z}`, the lift :math:`y` is such that
        :math:`-n/2 < y <= n/2`.

        - a :literal:`t_PADIC` :math:`x` is lifted in the same way as above (modulo
        :math:`p^{padicprec(x)}`) if its valuation :math:`v` is nonnegative; if not, returns
        the fraction :math:`p^{v}` :literal:`centerlift`:math:`(x p^{-v})`; in particular, rational
        reconstruction is not attempted. Use :literal:`bestappr` for this.

        For backward compatibility, :literal:`centerlift(x,'v)` is allowed as an alias
        for :literal:`lift(x,'v)`.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = centerlift0(_x, _v)
        return new_gen(_ret)

    def characteristic(x):
        r'''
        Returns the characteristic of the base ring over which :math:`x` is defined (as
        defined by :literal:`t_INTMOD` and :literal:`t_FFELT` components). The function raises an
        exception if incompatible primes arise from :literal:`t_FFELT` and :literal:`t_PADIC`
        components.

        ::

        ? characteristic(Mod(1,24)*x + Mod(1,18)*y)
        %1 = 6
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = characteristic(_x)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def charconj(cyc, chi):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary
        divisors, i.e. :math:`(d_{j})` represents :math:`\sum_{j <= k} \mathbb{Z}/d_{j}\mathbb{Z}` with :math:`d_{k}
        | ... \| d_{1}`; any object which has a :literal:`.cyc` method is also
        allowed, e.g. the output of :literal:`znstar` or :literal:`bnrinit`. A character
        on this group is given by a row vector :math:`\chi = [a_{1},...,a_{n}]` such that
        :math:`\chi (\prod g_{j}^{n_{j}}) = \exp (2\pi i\sum_{j} a_{j} n_{j} / d_{j})`, where
        :math:`g_{j}` denotes the generator (of order :math:`d_{j}`) of the :math:`j`-th cyclic
        component. This function returns the conjugate character.

        ::

        ? cyc = [15,5]; chi = [1,1];
        ? charconj(cyc, chi)
        %2 = [14, 4]
        ? bnf = bnfinit(x^2+23);
        ? bnf.cyc
        %4 = [3]
        ? charconj(bnf, [1])
        %5 = [2]

        For Dirichlet characters (when :literal:`cyc` is
        :literal:`znstar(q,1)`), characters in Conrey representation are available,
        see ``dirichletchar`` (in the PARI manual) or :literal:`??character`:

        ::

        ? G = znstar(16, 1); \\ (Z/16Z)^*
        ? charconj(G, 3) \\ Conrey label
        %2 = [1, 1]~
        ? znconreyexp(G, %)
        %3 = 11 \\ attached Conrey label; indeed 11 = 3^(-1) mod 16
        ? chi = znconreylog(G, 3);
        ? charconj(G, chi) \\ Conrey logarithm
        %5 = [1, 1]~
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = charconj0(_cyc, _chi)
        return new_gen(_ret)

    def chardiv(cyc, a, b):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary
        divisors, i.e. :math:`(d_{j})` represents :math:`\sum_{j <= k} \mathbb{Z}/d_{j}\mathbb{Z}` with :math:`d_{k}.
        | ... \| d_{1}`; any object which has a :literal:`.cyc` method is also
        allowed, e.g. the output of :literal:`znstar` or :literal:`bnrinit`. A character
        on this group is given by a row vector :math:`a = [a_{1},...,a_{n}]` such that
        :math:`\chi (\prod g_{j}^{n_{j}}) = \exp (2\pi i\sum_{j} a_{j} n_{j} / d_{j})`,
        where :math:`g_{j}` denotes the generator (of order :math:`d_{j}`) of the :math:`j`-th cyclic
        component.

        Given two characters :math:`a` and :math:`b`, return the character
        :math:`a / b = a \overline{b}`.

        ::

        ? cyc = [15,5]; a = [1,1]; b = [2,4];
        ? chardiv(cyc, a,b)
        %2 = [14, 2]
        ? bnf = bnfinit(x^2+23);
        ? bnf.cyc
        %4 = [3]
        ? chardiv(bnf, [1], [2])
        %5 = [2]

        For Dirichlet characters on :math:`(\mathbb{Z}/N\mathbb{Z})^{*}`, additional
        representations are available (Conrey labels, Conrey logarithm),
        see ``dirichletchar`` (in the PARI manual) or :literal:`??character`.
        If the two characters are in the same format, the
        result is given in the same format, otherwise a Conrey logarithm is used.

        ::

        ? G = znstar(100, 1);
        ? G.cyc
        %2 = [20, 2]
        ? a = [10, 1]; \\ usual representation for characters
        ? b = 7; \\ Conrey label;
        ? c = znconreylog(G, 11); \\ Conrey log
        ? chardiv(G, b,b)
        %6 = 1 \\ Conrey label
        ? chardiv(G, a,b)
        %7 = [0, 5]~ \\ Conrey log
        ? chardiv(G, a,c)
        %7 = [0, 14]~ \\ Conrey log
        '''
        a = objtogen(a)
        b = objtogen(b)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = chardiv0(_cyc, _a, _b)
        return new_gen(_ret)

    def chareval(G, chi, x, z=None):
        r'''
        Let :math:`G` be an abelian group structure affording a discrete logarithm
        method, e.g :math:`G = znstar (N, 1)` for :math:`(\mathbb{Z}/N\mathbb{Z})^{*}` or a :literal:`bnr`
        structure, let :math:`x` be an element of :math:`G` and let :emphasis:`chi` be a character of
        :math:`G` (see the note below for details). This function returns the value of
        :emphasis:`chi` at :math:`x`.

        :strong:`Note on characters.`
        Let :math:`K` be some field. If :math:`G` is an abelian group,
        let :math:`\chi: G \to K^{*}` be a character of finite order and let :math:`o` be a
        multiple of the character order such that :math:`\chi (n) = \zeta^{c(n)}` for some
        fixed :math:`\zeta\in K^{*}` of multiplicative order :math:`o` and a unique morphism :math:`c: G
        \to (\mathbb{Z}/o\mathbb{Z},+)`. Our usual convention is to write

        .. MATH::

        G = (\mathbb{Z}/o_{1}\mathbb{Z}) g_{1} \oplus...\oplus (\mathbb{Z}/o_{d}\mathbb{Z}) g_{d}

        for some generators :math:`(g_{i})` of respective order :math:`d_{i}`, where the group
        has exponent :math:`o := lcm_{i} o_{i}`. Since :math:`\zeta^{o} = 1`, the vector
        :math:`(c_{i})` in
        :math:`\prod_{i} (\mathbb{Z}/o_{i}\mathbb{Z})` defines a character :math:`\chi` on :math:`G` via :math:`\chi (g_{i}) =
        \zeta^{c_{i} (o/o_{i})}` for all :math:`i`. Classical Dirichlet characters have values
        in :math:`K = \mathbb{C}` and we can take :math:`\zeta = \exp (2i\pi/o)`.

        :strong:`Note on Dirichlet characters.`
        In the special case where :emphasis:`bid` is attached to :math:`G = (\mathbb{Z}/q\mathbb{Z})^{*}`
        (as per :literal:`G = znstar(q,1)`), the Dirichlet
        character :emphasis:`chi` can be written in one of the usual 3 formats: a :literal:`t_VEC`
        in terms of :literal:`bid.gen` as above, a :literal:`t_COL` in terms of the Conrey
        generators, or a :literal:`t_INT` (Conrey label);
        see ``dirichletchar`` (in the PARI manual) or :literal:`??character`.

        The character value is encoded as follows, depending on the optional
        argument :math:`z`:

        - If :math:`z` is omitted: return the rational number :math:`c(x)/o` for :math:`x` coprime
        to :math:`q`, where we normalize :math:`0 <= c(x) < o`. If :math:`x` can not be mapped to the
        group (e.g. :math:`x` is not coprime to the conductor of a Dirichlet or Hecke
        character) we return the sentinel value :math:`-1`.

        - If :math:`z` is an integer :math:`o`, then we assume that :math:`o` is a multiple of the
        character order and we return the integer :math:`c(x)` when :math:`x` belongs
        to the group, and the sentinel value :math:`-1` otherwise.

        - :math:`z` can be of the form :math:`[zeta, o]`, where :emphasis:`zeta`
        is an :math:`o`-th root of :math:`1` and :math:`o` is a multiple of the character order.
        We return :math:`\zeta^{c(x)}` if :math:`x` belongs to the group, and the sentinel
        value :math:`0` otherwise. (Note that this coincides with the usual extension
        of Dirichlet characters to :math:`\mathbb{Z}`, or of Hecke characters to general ideals.)

        - Finally, :math:`z` can be of the form :math:`[vzeta, o]`, where
        :emphasis:`vzeta` is a vector of powers :math:`\zeta^{0},..., \zeta^{o-1}`
        of some :math:`o`-th root of :math:`1` and :math:`o` is a multiple of the character order.
        As above, we return :math:`\zeta^{c(x)}` after a table lookup. Or the sentinel
        value :math:`0`.
        '''
        chi = objtogen(chi)
        x = objtogen(x)
        cdef bint _have_z = (z is not None)
        if _have_z:
            z = objtogen(z)
        sig_on()
        cdef GEN _G = (<Gen>G).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _z = NULL
        if _have_z:
            _z = (<Gen>z).g
        cdef GEN _ret = chareval(_G, _chi, _x, _z)
        return new_gen(_ret)

    def chargalois(cyc, ORD=None):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary divisors
        (any object which has a :literal:`.cyc` method is also allowed, i.e. the output of
        :literal:`znstar` or :literal:`bnrinit`). Return a list of representatives for the
        Galois orbits of complex characters of :math:`G`.
        If :literal:`ORD` is present, select characters depending on their orders:

        - if :literal:`ORD` is a :literal:`t_INT`, restrict to orders less than this
        bound;

        - if :literal:`ORD` is a :literal:`t_VEC` or :literal:`t_VECSMALL`, restrict to orders in
        the list.

        ::

        ? G = znstar(96);
        ? #chargalois(G) \\ 16 orbits of characters mod 96
        %2 = 16
        ? #chargalois(G,4) \\ order less than 4
        %3 = 12
        ? chargalois(G,[1,4]) \\ order 1 or 4; 5 orbits
        %4 = [[0, 0, 0], [2, 0, 0], [2, 1, 0], [2, 0, 1], [2, 1, 1]]

        Given a character :math:`\chi`, of order :math:`n` (:literal:`charorder(G,chi)`), the
        elements in its orbit are the :math:`\phi (n)` characters :math:`\chi^{i}`, :math:`(i,n) = 1`.
        '''
        cdef bint _have_ORD = (ORD is not None)
        if _have_ORD:
            ORD = objtogen(ORD)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _ORD = NULL
        if _have_ORD:
            _ORD = (<Gen>ORD).g
        cdef GEN _ret = chargalois(_cyc, _ORD)
        return new_gen(_ret)

    def charker(cyc, chi):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary
        divisors, i.e. :math:`(d_{j})` represents :math:`\sum_{j <= k} \mathbb{Z}/d_{j}\mathbb{Z}` with :math:`d_{k}
        | ... \| d_{1}`; any object which has a :literal:`.cyc` method is also
        allowed, e.g. the output of :literal:`znstar` or :literal:`bnrinit`. A character
        on this group is given by a row vector :math:`\chi = [a_{1},...,a_{n}]` such that
        :math:`\chi (\prod g_{j}^{n_{j}}) = \exp (2\pi i\sum_{j} a_{j} n_{j} / d_{j})`,
        where :math:`g_{j}` denotes
        the generator (of order :math:`d_{j}`) of the :math:`j`-th cyclic component.

        This function returns the kernel of :math:`\chi`, as a matrix :math:`K` in HNF which is a
        left-divisor of :literal:`matdiagonal(d)`. Its columns express in terms of
        the :math:`g_{j}` the generators of the subgroup. The determinant of :math:`K` is the
        kernel index.

        ::

        ? cyc = [15,5]; chi = [1,1];
        ? charker(cyc, chi)
        %2 =
        [15 12]
        
        [ 0 1]
        
        ? bnf = bnfinit(x^2+23);
        ? bnf.cyc
        %4 = [3]
        ? charker(bnf, [1])
        %5 =
        [3]

        Note that for Dirichlet characters (when :literal:`cyc` is
        :literal:`znstar(q, 1)`), characters in Conrey representation are available,
        see ``dirichletchar`` (in the PARI manual) or :literal:`??character`.

        ::

        ? G = znstar(8, 1); \\ (Z/8Z)^*
        ? charker(G, 1) \\ Conrey label for trivial character
        %2 =
        [1 0]
        
        [0 1]
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = charker0(_cyc, _chi)
        return new_gen(_ret)

    def charmul(cyc, a, b):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary
        divisors, i.e. :math:`(d_{j})` represents :math:`\sum_{j <= k} \mathbb{Z}/d_{j}\mathbb{Z}` with :math:`d_{k}
        | ... \| d_{1}`; any object which has a :literal:`.cyc` method is also
        allowed, e.g. the output of :literal:`znstar` or :literal:`bnrinit`. A character
        on this group is given by a row vector :math:`\chi = [a_{1},...,a_{n}]` such that
        :math:`\chi (\prod g_{j}^{n_{j}}) = \exp (2\pi i\sum_{j} a_{j} n_{j} / d_{j})`,
        where :math:`g_{j}` denotes
        the generator (of order :math:`d_{j}`) of the :math:`j`-th cyclic component.

        Given two characters :math:`a` and :math:`b`, return the product character :math:`ab`.

        ::

        ? cyc = [15,5]; a = [1,1]; b = [2,4];
        ? charmul(cyc, a,b)
        %2 = [3, 0]
        ? bnf = bnfinit(x^2+23);
        ? bnf.cyc
        %4 = [3]
        ? charmul(bnf, [1], [2])
        %5 = [0]

        For Dirichlet characters on :math:`(\mathbb{Z}/N\mathbb{Z})^{*}`, additional
        representations are available (Conrey labels, Conrey logarithm), see
        ``dirichletchar`` (in the PARI manual) or :literal:`??character`. If the two characters are in
        the same format, their
        product is given in the same format, otherwise a Conrey logarithm is used.

        ::

        ? G = znstar(100, 1);
        ? G.cyc
        %2 = [20, 2]
        ? a = [10, 1]; \\ usual representation for characters
        ? b = 7; \\ Conrey label;
        ? c = znconreylog(G, 11); \\ Conrey log
        ? charmul(G, b,b)
        %6 = 49 \\ Conrey label
        ? charmul(G, a,b)
        %7 = [0, 15]~ \\ Conrey log
        ? charmul(G, a,c)
        %7 = [0, 6]~ \\ Conrey log
        '''
        a = objtogen(a)
        b = objtogen(b)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = charmul0(_cyc, _a, _b)
        return new_gen(_ret)

    def charorder(cyc, chi):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary
        divisors, i.e. :math:`(d_{j})` represents :math:`\sum_{j <= k} \mathbb{Z}/d_{j}\mathbb{Z}` with :math:`d_{k}
        | ... \| d_{1}`; any object which has a :literal:`.cyc` method is also
        allowed, e.g. the output of :literal:`znstar` or :literal:`bnrinit`. A character
        on this group is given by a row vector :math:`\chi = [a_{1},...,a_{n}]` such that
        :math:`\chi (\prod g_{j}^{n_{j}}) = \exp (2\pi i\sum_{j} a_{j} n_{j} / d_{j})`,
        where :math:`g_{j}` denotes
        the generator (of order :math:`d_{j}`) of the :math:`j`-th cyclic component.

        This function returns the order of the character :literal:`chi`.

        ::

        ? cyc = [15,5]; chi = [1,1];
        ? charorder(cyc, chi)
        %2 = 15
        ? bnf = bnfinit(x^2+23);
        ? bnf.cyc
        %4 = [3]
        ? charorder(bnf, [1])
        %5 = 3

        For Dirichlet characters (when :literal:`cyc` is
        :literal:`znstar(q, 1)`), characters in Conrey representation are available,
        see ``dirichletchar`` (in the PARI manual) or :literal:`??character`:

        ::

        ? G = znstar(100, 1); \\ (Z/100Z)^*
        ? charorder(G, 7) \\ Conrey label
        %2 = 4
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = charorder0(_cyc, _chi)
        return new_gen(_ret)

    def charpoly(A, v=None, long flag=5):
        r'''
        characteristic polynomial
        of :math:`A` with respect to the variable :math:`v`, i.e. determinant of :math:`v*I-A` if :math:`A`
        is a square matrix.

        ::

        ? charpoly([1,2;3,4]);
        %1 = x^2 - 5*x - 2
        ? charpoly([1,2;3,4],, 't)
        %2 = t^2 - 5*t - 2

        If :math:`A` is not a square matrix, the function returns the characteristic
        polynomial of the map "multiplication by :math:`A`" if :math:`A` is a scalar:

        ::

        ? charpoly(Mod(x+2, x^3-2))
        %1 = x^3 - 6*x^2 + 12*x - 10
        ? charpoly(I)
        %2 = x^2 + 1
        ? charpoly(quadgen(5))
        %3 = x^2 - x - 1
        ? charpoly(ffgen(ffinit(2,4)))
        %4 = Mod(1, 2)*x^4 + Mod(1, 2)*x^3 + Mod(1, 2)*x^2 + Mod(1, 2)*x + Mod(1, 2)

        The value of :math:`flag` is only significant for matrices, and we advise to stick
        to the default value. Let :math:`n` be the dimension of :math:`A`.

        If :math:`flag = 0`, same method (Le Verrier's) as for computing the adjoint matrix,
        i.e. using the traces of the powers of :math:`A`. Assumes that :math:`n!` is
        invertible; uses :math:`O(n^{4})` scalar operations.

        If :math:`flag = 1`, uses Lagrange interpolation which is usually the slowest method.
        Assumes that :math:`n!` is invertible; uses :math:`O(n^{4})` scalar operations.

        If :math:`flag = 2`, uses the Hessenberg form. Assumes that the base ring is a field.
        Uses :math:`O(n^{3})` scalar operations, but suffers from coefficient explosion
        unless the base field is finite or :math:`\mathbb{R}`.

        If :math:`flag = 3`, uses Berkowitz's division free algorithm, valid over any
        ring (commutative, with unit). Uses :math:`O(n^{4})` scalar operations.

        If :math:`flag = 4`, :math:`x` must be integral. Uses a modular algorithm: Hessenberg form
        for various small primes, then Chinese remainders.

        If :math:`flag = 5` (default), uses the "best" method given :math:`x`.
        This means we use Berkowitz unless the base ring is :math:`\mathbb{Z}` (use :math:`flag = 4`)
        or a field where coefficient explosion does not occur,
        e.g. a finite field or the reals (use :math:`flag = 2`).
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _ret = charpoly0(_A, _v, flag)
        return new_gen(_ret)

    def charpow(cyc, a, n):
        r'''
        Let :emphasis:`cyc` represent a finite abelian group by its elementary
        divisors, i.e. :math:`(d_{j})` represents :math:`\sum_{j <= k} \mathbb{Z}/d_{j}\mathbb{Z}` with :math:`d_{k}
        | ... \| d_{1}`; any object which has a :literal:`.cyc` method is also
        allowed, e.g. the output of :literal:`znstar` or :literal:`bnrinit`. A character
        on this group is given by a row vector :math:`\chi = [a_{1},...,a_{n}]` such that
        :math:`\chi (\prod g_{j}^{n_{j}}) = \exp (2\pi i\sum_{j} a_{j} n_{j} / d_{j})`,
        where :math:`g_{j}` denotes
        the generator (of order :math:`d_{j}`) of the :math:`j`-th cyclic component.

        Given :math:`n\in \mathbb{Z}` and a character :math:`a`, return the character :math:`a^{n}`.

        ::

        ? cyc = [15,5]; a = [1,1];
        ? charpow(cyc, a, 3)
        %2 = [3, 3]
        ? charpow(cyc, a, 5)
        %2 = [5, 0]
        ? bnf = bnfinit(x^2+23);
        ? bnf.cyc
        %4 = [3]
        ? charpow(bnf, [1], 3)
        %5 = [0]

        For Dirichlet characters on :math:`(\mathbb{Z}/N\mathbb{Z})^{*}`, additional
        representations are available (Conrey labels, Conrey logarithm), see
        ``dirichletchar`` (in the PARI manual) or :literal:`??character` and the output uses the
        same format as the input.

        ::

        ? G = znstar(100, 1);
        ? G.cyc
        %2 = [20, 2]
        ? a = [10, 1]; \\ standard representation for characters
        ? b = 7; \\ Conrey label;
        ? c = znconreylog(G, 11); \\ Conrey log
        ? charpow(G, a,3)
        %6 = [10, 1] \\ standard representation
        ? charpow(G, b,3)
        %7 = 43 \\ Conrey label
        ? charpow(G, c,3)
        %8 = [1, 8]~ \\ Conrey log
        '''
        a = objtogen(a)
        n = objtogen(n)
        sig_on()
        cdef GEN _cyc = (<Gen>cyc).g
        cdef GEN _a = (<Gen>a).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = charpow0(_cyc, _a, _n)
        return new_gen(_ret)

    def chinese(x, y=None):
        r'''
        If :math:`x` and :math:`y` are both intmods or both polmods, creates (with the same
        type) a :math:`z` in the same residue class as :math:`x` and in the same residue class as
        :math:`y`, if it is possible.

        ::

        ? chinese(Mod(1,2), Mod(2,3))
        %1 = Mod(5, 6)
        ? chinese(Mod(x,x^2-1), Mod(x+1,x^2+1))
        %2 = Mod(-1/2*x^2 + x + 1/2, x^4 - 1)

        This function also allows vector and matrix arguments, in which case the
        operation is recursively applied to each component of the vector or matrix.

        ::

        ? chinese([Mod(1,2),Mod(1,3)], [Mod(1,5),Mod(2,7)])
        %3 = [Mod(1, 10), Mod(16, 21)]

        For polynomial arguments in the same variable, the function is applied to each
        coefficient; if the polynomials have different degrees, the high degree terms
        are copied verbatim in the result, as if the missing high degree terms in the
        polynomial of lowest degree had been :literal:`Mod(0,1)`. Since the latter
        behavior is usually :emphasis:`not` the desired one, we propose to convert the
        polynomials to vectors of the same length first:

        ::

        ? P = x+1; Q = x^2+2*x+1;
        ? chinese(P*Mod(1,2), Q*Mod(1,3))
        %4 = Mod(1, 3)*x^2 + Mod(5, 6)*x + Mod(3, 6)
        ? chinese(Vec(P,3)*Mod(1,2), Vec(Q,3)*Mod(1,3))
        %5 = [Mod(1, 6), Mod(5, 6), Mod(4, 6)]
        ? Pol(%)
        %6 = Mod(1, 6)*x^2 + Mod(5, 6)*x + Mod(4, 6)

        If :math:`y` is omitted, and :math:`x` is a vector, :literal:`chinese` is applied recursively
        to the components of :math:`x`, yielding a residue belonging to the same class as all
        components of :math:`x`.

        Finally :math:`chinese (x,x) = x` regardless of the type of :math:`x`; this allows
        vector arguments to contain other data, so long as they are identical in both
        vectors.
        '''
        cdef bint _have_y = (y is not None)
        if _have_y:
            y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = NULL
        if _have_y:
            _y = (<Gen>y).g
        cdef GEN _ret = chinese(_x, _y)
        return new_gen(_ret)

    def cmp(x, y):
        r'''
        Gives the result of a comparison between arbitrary objects :math:`x` and :math:`y`
        (as :math:`-1`, :math:`0` or :math:`1`). The underlying order relation is transitive,
        the function returns :math:`0` if and only if :math:`x  ===  y`. It has no
        mathematical meaning but satisfies the following properties when comparing
        entries of the same type:

        - two :literal:`t_INT` s compare as usual (i.e. :literal:`cmp`:math:`(x,y) < 0` if and only
        if :math:`x < y`);

        - two :literal:`t_VECSMALL` s of the same length compare lexicographically;

        - two :literal:`t_STR` s compare lexicographically.

        In case all components are equal up to the smallest length of the operands,
        the more complex is considered to be larger. More precisely, the longest is
        the largest; when lengths are equal, we have matrix :math:`>` vector :math:`>` scalar.
        For example:

        ::

        ? cmp(1, 2)
        %1 = -1
        ? cmp(2, 1)
        %2 = 1
        ? cmp(1, 1.0) \\ note that 1 == 1.0, but (1===1.0) is false.
        %3 = -1
        ? cmp(x + Pi, [])
        %4 = -1

        This function is mostly useful to handle sorted lists or
        vectors of arbitrary objects. For instance, if :math:`v` is a vector, the
        construction :literal:`vecsort(v, cmp)` is equivalent to :literal:`Set(v)`.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef int _ret = cmp_universal(_x, _y)
        clear_stack()
        return _ret

    def component(x, long n):
        r'''
        Extracts the :math:`n-th`-component of :math:`x`. This is to be understood
        as follows: every PARI type has one or two initial code words. The
        components are counted, starting at 1, after these code words. In particular
        if :math:`x` is a vector, this is indeed the :math:`n-th`-component of :math:`x`, if
        :math:`x` is a matrix, the :math:`n-th` column, if :math:`x` is a polynomial, the
        :math:`n-th` coefficient (i.e. of degree :math:`n-1`), and for power series,
        the :math:`n-th` significant coefficient.

        For polynomials and power series, one should rather use :literal:`polcoef`, and
        for vectors and matrices, the :literal:`[]` operator. Namely, if :math:`x` is a
        vector, then :literal:`x[n]` represents the :math:`n-th` component of :math:`x`. If
        :math:`x` is a matrix, :literal:`x[m,n]` represents the coefficient of row :literal:`m` and
        column :literal:`n` of the matrix, :literal:`x[m,]` represents the :math:`m-th`
        :emphasis:`row` of :math:`x`, and :literal:`x[,n]` represents the :math:`n-th`
        :emphasis:`column` of :math:`x`.

        Using of this function requires detailed knowledge of the structure of the
        different PARI types, and thus it should almost never be used directly.
        Some useful exceptions:

        ::

        ? x = 3 + O(3^5);
        ? component(x, 2)
        %2 = 81 \\ p^(p-adic accuracy)
        ? component(x, 1)
        %3 = 3 \\ p
        ? q = Qfb(1,2,3);
        ? component(q, 1)
        %5 = 1
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = compo(_x, n)
        return new_gen(_ret)

    def concat(x, y=None):
        r'''
        Concatenation of :math:`x` and :math:`y`. If :math:`x` or :math:`y` is
        not a vector or matrix, it is considered as a one-dimensional vector. All
        types are allowed for :math:`x` and :math:`y`, but the sizes must be compatible. Note
        that matrices are concatenated horizontally, i.e. the number of rows stays
        the same. Using transpositions, one can concatenate them vertically,
        but it is often simpler to use :literal:`matconcat`.

        ::

        ? x = matid(2); y = 2*matid(2);
        ? concat(x,y)
        %2 =
        [1 0 2 0]
        
        [0 1 0 2]
        ? concat(x~,y~)~
        %3 =
        [1 0]
        
        [0 1]
        
        [2 0]
        
        [0 2]
        ? matconcat([x;y])
        %4 =
        [1 0]
        
        [0 1]
        
        [2 0]
        
        [0 2]

        To concatenate vectors sideways (i.e. to obtain a two-row or two-column
        matrix), use :literal:`Mat` instead, or :literal:`matconcat`:

        ::

        ? x = [1,2];
        ? y = [3,4];
        ? concat(x,y)
        %3 = [1, 2, 3, 4]
        
        ? Mat([x,y]~)
        %4 =
        [1 2]
        
        [3 4]
        ? matconcat([x;y])
        %5 =
        [1 2]
        
        [3 4]

        Concatenating a row vector to a matrix having the same number of columns will
        add the row to the matrix (top row if the vector is :math:`x`, i.e. comes first, and
        bottom row otherwise).

        The empty matrix :literal:`[;]` is considered to have a number of rows compatible
        with any operation, in particular concatenation. (Note that this is
        :emphasis:`not` the case for empty vectors :literal:`[ ]` or :literal:`[ ]~`.)

        If :math:`y` is omitted, :math:`x` has to be a row vector or a list, in which case its
        elements are concatenated, from left to right, using the above rules.

        ::

        ? concat([1,2], [3,4])
        %1 = [1, 2, 3, 4]
        ? a = [[1,2]~, [3,4]~]; concat(a)
        %2 =
        [1 3]
        
        [2 4]
        
        ? concat([1,2; 3,4], [5,6]~)
        %3 =
        [1 2 5]
        
        [3 4 6]
        ? concat([%, [7,8]~, [1,2,3,4]])
        %5 =
        [1 2 5 7]
        
        [3 4 6 8]
        
        [1 2 3 4]
        '''
        cdef bint _have_y = (y is not None)
        if _have_y:
            y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = NULL
        if _have_y:
            _y = (<Gen>y).g
        cdef GEN _ret = gconcat(_x, _y)
        return new_gen(_ret)

    def conj(x):
        r'''
        Conjugate of :math:`x`. The meaning of this
        is clear, except that for real quadratic numbers, it means conjugation in the
        real quadratic field. This function has no effect on integers, reals,
        intmods, fractions or :math:`p`-adics. The only forbidden type is polmod
        (see :literal:`conjvec` for this).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gconj(_x)
        return new_gen(_ret)

    def conjvec(z, long precision=DEFAULT_BITPREC):
        r'''
        Conjugate vector representation of :math:`z`. If :math:`z` is a
        polmod, equal to :literal:`Mod`:math:`(a,T)`, this gives a vector of length
        :math:`degree(T)` containing:

        - the complex embeddings of :math:`z` if :math:`T` has rational coefficients,
        i.e. the :math:`a(r[i])` where :math:`r = polroots (T)`;

        - the conjugates of :math:`z` if :math:`T` has some intmod coefficients;

        if :math:`z` is a finite field element, the result is the vector of
        conjugates :math:`[z,z^{p},z^{p^{2}},...,z^{p^{n-1}}]` where :math:`n = degree(T)`.

        If :math:`z` is an integer or a rational number, the result is :math:`z`. If
        :math:`z` is a (row or column) vector, the result is a matrix whose columns are
        the conjugate vectors of the individual elements of :math:`z`.
        '''
        sig_on()
        cdef GEN _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = conjvec(_z, precision)
        return new_gen(_ret)

    def content(x, D=None):
        r'''
        Computes the gcd of all the coefficients of :math:`x`,
        when this gcd makes sense. This is the natural definition
        if :math:`x` is a polynomial (and by extension a power series) or a
        vector/matrix. This is in general a weaker notion than the :emphasis:`ideal`
        generated by the coefficients:

        ::

        ? content(2*x+y)
        %1 = 1 \\ = gcd(2,y) over Q[y]

        If :math:`x` is a scalar, this simply returns the absolute value of :math:`x` if :math:`x` is
        rational (:literal:`t_INT` or :literal:`t_FRAC`), and either :math:`1` (inexact input) or :math:`x`
        (exact input) otherwise; the result should be identical to :literal:`gcd(x, 0)`.

        The content of a rational function is the ratio of the contents of the
        numerator and the denominator. In recursive structures, if a
        matrix or vector :emphasis:`coefficient` :math:`x` appears, the gcd is taken
        not with :math:`x`, but with its content:

        ::

        ? content([ [2], 4*matid(3) ])
        %1 = 2

        The content of a :literal:`t_VECSMALL` is computed assuming the
        entries are signed integers.

        The optional argument :math:`D` allows to control over which ring we compute
        and get a more predictable behaviour:

        - :math:`1`: we only consider the underlying :math:`\mathbb{Q}`-structure and the
        denominator is a (positive) rational number

        - a simple variable, say :literal:`'x`: all entries are considered as
        rational functions in :math:`K(x)` for some field :math:`K` and the content is an
        element of :math:`K`.

        ::

        ? f = x + 1/y + 1/2;
        ? content(f) \\ as a t_POL in x
        %2 = 1/(2*y)
        ? content(f, 1) \\ Q-content
        %3 = 1/2
        ? content(f, y) \\ as a rational function in y
        %4 = 1/2
        ? g = x^2*y + y^2*x;
        ? content(g, x)
        %6 = y
        ? content(g, y)
        %7 = x
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = content0(_x, _D)
        return new_gen(_ret)

    def contfrac(x, b=None, long nmax=0):
        r'''
        Returns the row vector whose components are the partial quotients of the
        continued fraction expansion of :math:`x`. In other words, a result
        :math:`[a_{0},...,a_{n}]` means that :math:`x ~ a_{0}+1/(a_{1}+...+1/a_{n})`. The
        output is normalized so that :math:`a_{n} ! = 1` (unless we also have :math:`n = 0`).

        The number of partial quotients :math:`n+1` is limited by :literal:`nmax`. If
        :literal:`nmax` is omitted, the expansion stops at the last significant partial
        quotient.

        ::

        ? \p19
        realprecision = 19 significant digits
        ? contfrac(Pi)
        %1 = [3, 7, 15, 1, 292, 1, 1, 1, 2, 1, 3, 1, 14, 2, 1, 1, 2, 2]
        ? contfrac(Pi,, 3) \\ n = 2
        %2 = [3, 7, 15]

        :math:`x` can also be a rational function or a power series.

        If a vector :math:`b` is supplied, the numerators are equal to the coefficients
        of :math:`b`, instead of all equal to :math:`1` as above; more precisely, :math:`x ~
        (1/b_{0})(a_{0}+b_{1}/(a_{1}+...+b_{n}/a_{n}))`; for a numerical continued
        fraction (:math:`x` real), the :math:`a_{i}` are integers, as large as possible;
        if :math:`x` is a
        rational function, they are polynomials with :math:`\deg a_{i} = \deg b_{i} + 1`.
        The length of the result is then equal to the length of :math:`b`, unless the next
        partial quotient cannot be reliably computed, in which case the expansion
        stops. This happens when a partial remainder is equal to zero (or too small
        compared to the available significant digits for :math:`x` a :literal:`t_REAL`).

        A direct implementation of the numerical continued fraction
        :literal:`contfrac(x,b)` described above would be

        ::

        \\ "greedy" generalized continued fraction
        cf(x, b) =
        { my( a= vector(#b), t );
        
        x *= b[1];
        for (i = 1, #b,
        a[i] = floor(x);
        t = x - a[i]; if (!t || i == #b, break);
        x = b[i+1] / t;
        ); a;
        }

        There is some degree of freedom when choosing the :math:`a_{i}`; the
        program above can easily be modified to derive variants of the standard
        algorithm. In the same vein, although no builtin
        function implements the related Engel expansion (a special kind of
        Egyptian fraction decomposition: :math:`x = 1/a_{1} + 1/(a_{1}a_{2}) +...`),
        it can be obtained as follows:

        ::

        \\ n terms of the Engel expansion of x
        engel(x, n = 10) =
        { my( u = x, a = vector(n) );
        for (k = 1, n,
        a[k] = ceil(1/u);
        u = u*a[k] - 1;
        if (!u, break);
        ); a
        }

        :strong:`Obsolete hack.` (don't use this): if :math:`b` is an integer, :emphasis:`nmax`
        is ignored and the command is understood as :literal:`contfrac(:math:`x,, b`)`.
        '''
        cdef bint _have_b = (b is not None)
        if _have_b:
            b = objtogen(b)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _b = NULL
        if _have_b:
            _b = (<Gen>b).g
        cdef GEN _ret = contfrac0(_x, _b, nmax)
        return new_gen(_ret)

    def contfraceval(CF, t, long lim=-1):
        r'''
        Given a continued fraction :literal:`CF` output by :literal:`contfracinit`, evaluate
        the first :literal:`lim` terms of the continued fraction at :literal:`t` (all
        terms if :literal:`lim` is negative or omitted; if positive, :literal:`lim` must be
        less than or equal to the length of :literal:`CF`.
        '''
        t = objtogen(t)
        sig_on()
        cdef GEN _CF = (<Gen>CF).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = contfraceval(_CF, _t, lim)
        return new_gen(_ret)

    def contfracinit(M, long lim=-1):
        r'''
        Given :math:`M` representing the power series :math:`S = \sum_{n >= 0} M[n+1]z^{n}`,
        transform it into a continued fraction in Euler form, using the
        quotient-difference algorithm; restrict to
        :math:`n <= lim` if latter is nonnegative. :math:`M` can be a vector, a power
        series, a polynomial; if the limiting parameter :literal:`lim` is present, a
        rational function is also allowed (and converted to a power series of that
        accuracy).

        The result is a 2-component vector :math:`[A,B]` such that
        :math:`S = M[1] / (1+A[1]z+B[1]z^{2}/(1+A[2]z+B[2]z^{2}/(1+...1/(1+A[lim/2]z))))`.
        Does not work if any coefficient of :math:`M` vanishes, nor for series for
        which certain partial denominators vanish.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = contfracinit(_M, lim)
        return new_gen(_ret)

    def contfracpnqn(x, long n=-1):
        r'''
        When :math:`x` is a vector or a one-row matrix, :math:`x`
        is considered as the list of partial quotients :math:`[a_{0},a_{1},...,a_{n}]` of a
        rational number, and the result is the 2 by 2 matrix
        :math:`[p_{n},p_{n-1};q_{n},q_{n-1}]` in the standard notation of continued fractions,
        so :math:`p_{n}/q_{n} = a_{0}+1/(a_{1}+...+1/a_{n})`. If :math:`x` is a matrix with two rows
        :math:`[b_{0},b_{1},...,b_{n}]` and :math:`[a_{0},a_{1},...,a_{n}]`, this is then considered as a
        generalized continued fraction and we have similarly
        :math:`p_{n}/q_{n} = (1/b_{0})(a_{0}+b_{1}/(a_{1}+...+b_{n}/a_{n}))`. Note that in this case one
        usually has :math:`b_{0} = 1`.

        If :math:`n >= 0` is present, returns all convergents from :math:`p_{0}/q_{0}` up to
        :math:`p_{n}/q_{n}`. (All convergents if :math:`x` is too small to compute the :math:`n+1`
        requested convergents.)

        ::

        ? a = contfrac(Pi,10)
        %1 = [3, 7, 15, 1, 292, 1, 1, 1, 3]
        ? allpnqn(x) = contfracpnqn(x,#x) \\ all convergents
        ? allpnqn(a)
        %3 =
        [3 22 333 355 103993 104348 208341 312689 1146408]
        
        [1 7 106 113 33102 33215 66317 99532 364913]
        ? contfracpnqn(a) \\ last two convergents
        %4 =
        [1146408 312689]
        
        [ 364913 99532]
        
        ? contfracpnqn(a,3) \\ first three convergents
        %5 =
        [3 22 333 355]
        
        [1 7 106 113]
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = contfracpnqn(_x, n)
        return new_gen(_ret)

    def core(n, long flag=0):
        r'''
        If :math:`n` is an integer written as
        :math:`n = df^{2}` with :math:`d` squarefree, returns :math:`d`. If :math:`flag` is nonzero,
        returns the two-element row vector :math:`[d,f]`. By convention, we write :math:`0 = 0
        x 1^{2}`, so :literal:`core(0, 1)` returns :math:`[0,1]`.
        '''
        sig_on()
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = core0(_n, flag)
        return new_gen(_ret)

    def coredisc(n, long flag=0):
        r'''
        A :emphasis:`fundamental discriminant` is an integer of the form :math:`t = 1
        mod 4` or :math:`4t = 8,12 mod 16`, with :math:`t` squarefree (i.e. :math:`1` or the
        discriminant of a quadratic number field). Given a nonzero integer
        :math:`n`, this routine returns the (unique) fundamental discriminant :math:`d`
        such that :math:`n = df^{2}`, :math:`f` a positive rational number. If :math:`flag` is nonzero,
        returns the two-element row vector :math:`[d,f]`. If :math:`n` is congruent to
        0 or 1 modulo 4, :math:`f` is an integer, and a half-integer otherwise.

        By convention, :literal:`coredisc(0, 1))` returns :math:`[0,1]`.

        Note that :literal:`quaddisc`:math:`(n)` returns the same value as :literal:`coredisc`:math:`(n)`,
        and also works with rational inputs :math:`n\in\mathbb{Q}^{*}`.
        '''
        sig_on()
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = coredisc0(_n, flag)
        return new_gen(_ret)

    def cos(x, long precision=DEFAULT_BITPREC):
        r'''
        Cosine of :math:`x`.
        Note that, for real :math:`x`, cosine and sine can be obtained simultaneously as

        ::

        cs(x) = my(z = exp(I*x)); [real(z), imag(z)];

        and for general complex :math:`x` as

        ::

        cs2(x) = my(z = exp(I*x), u = 1/z); [(z+u)/2, (z-u)/2];

        Note that the latter function suffers from catastrophic cancellation
        when :math:`z^{2} ~ ±1`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcos(_x, precision)
        return new_gen(_ret)

    def cosh(x, long precision=DEFAULT_BITPREC):
        r'''
        Hyperbolic cosine of :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcosh(_x, precision)
        return new_gen(_ret)

    def cotan(x, long precision=DEFAULT_BITPREC):
        r'''
        Cotangent of :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcotan(_x, precision)
        return new_gen(_ret)

    def cotanh(x, long precision=DEFAULT_BITPREC):
        r'''
        Hyperbolic cotangent of :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcotanh(_x, precision)
        return new_gen(_ret)

    def denominator(f, D=None):
        r'''
        Denominator of :math:`f`. The meaning of this is clear when :math:`f` is a rational number
        or function. If :math:`f` is an integer or a polynomial, it is treated as a rational
        number or function, respectively, and the result is equal to :math:`1`. For
        polynomials, you probably want to use

        ::

        denominator( content(f) )

        instead. As for modular objects, :literal:`t_INTMOD` and :literal:`t_PADIC`
        have denominator :math:`1`, and the denominator of a :literal:`t_POLMOD` is the
        denominator of its lift.

        If :math:`f` is a recursive structure, for instance a vector or matrix, the lcm
        of the denominators of its components (a common denominator) is computed.
        This also applies for :literal:`t_COMPLEX` s and :literal:`t_QUAD` s.

        :strong:`Warning.` Multivariate objects are created according to variable
        priorities, with possibly surprising side effects (:math:`x/y` is a polynomial, but
        :math:`y/x` is a rational function). See ``priority`` (in the PARI manual).

        The optional argument :math:`D` allows to control over which ring we compute the
        denominator and get a more predictable behaviour:

        - :math:`1`: we only consider the underlying :math:`\mathbb{Q}`-structure and the
        denominator is a (positive) rational integer

        - a simple variable, say :literal:`'x`: all entries as rational functions
        in :math:`K(x)` and the denominator is a polynomial in :math:`x`.

        ::

        ? f = x + 1/y + 1/2;
        ? denominator(f) \\ a t_POL in x
        %2 = 1
        ? denominator(f, 1) \\ Q-denominator
        %3 = 2
        ? denominator(f, x) \\ as a t_POL in x, seen above
        %4 = 1
        ? denominator(f, y) \\ as a rational function in y
        %5 = 2*y
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = denominator(_f, _D)
        return new_gen(_ret)

    def deriv(x, v=None):
        r'''
        Derivative of :math:`x` with respect to the main
        variable if :math:`v` is omitted, and with respect to :math:`v` otherwise. The derivative
        of a scalar type is zero, and the derivative of a vector or matrix is done
        componentwise. One can use :math:`x'` as a shortcut if the derivative is with
        respect to the main variable of :math:`x`; and also use :math:`x"`, etc., for multiple
        derivatives altough :literal:`derivn` is often preferrable.

        By definition, the main variable of a :literal:`t_POLMOD` is the main variable among
        the coefficients from its two polynomial components (representative and
        modulus); in other words, assuming a polmod represents an element of
        :math:`R[X]/(T(X))`, the variable :math:`X` is a mute variable and the derivative is
        taken with respect to the main variable used in the base ring :math:`R`.

        ::

        ? f = (x/y)^5;
        ? deriv(f)
        %2 = 5/y^5*x^4
        ? f'
        %3 = 5/y^5*x^4
        ? deriv(f, 'x) \\ same since 'x is the main variable
        %4 = 5/y^5*x^4
        ? deriv(f, 'y)
        %5 = -5/y^6*x^5

        This function also operates on closures, in which case the variable
        must be omitted. It returns a closure performing a numerical
        differentiation as per :literal:`derivnum`:

        ::

        ? f(x) = x^2;
        ? g = deriv(f)
        ? g(1)
        %3 = 2.0000000000000000000000000000000000000
        ? f(x) = sin(exp(x));
        ? deriv(f)(0)
        %5 = 0.54030230586813971740093660744297660373
        ? cos(1)
        %6 = 0.54030230586813971740093660744297660373
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = deriv(_x, _v)
        return new_gen(_ret)

    def derivn(x, long n, v=None):
        r'''
        :math:`n`-th derivative of :math:`x` with respect to the main
        variable if :math:`v` is omitted, and with respect to :math:`v` otherwise; the integer
        :math:`n` must be nonnegative. The derivative
        of a scalar type is zero, and the derivative of a vector or matrix is done
        componentwise. One can use :math:`x'`, :math:`x"`, etc., as a shortcut if the
        derivative is with respect to the main variable of :math:`x`.

        By definition, the main variable of a :literal:`t_POLMOD` is the main variable among
        the coefficients from its two polynomial components (representative and
        modulus); in other words, assuming a polmod represents an element of
        :math:`R[X]/(T(X))`, the variable :math:`X` is a mute variable and the derivative is
        taken with respect to the main variable used in the base ring :math:`R`.

        ::

        ? f = (x/y)^5;
        ? derivn(f, 2)
        %2 = 20/y^5*x^3
        ? f''
        %3 = 20/y^5*x^3
        ? derivn(f, 2, 'x) \\ same since 'x is the main variable
        %4 = 20/y^5*x^3
        ? derivn(f, 2, 'y)
        %5 = 30/y^7*x^5

        This function also operates on closures, in which case the variable
        must be omitted. It returns a closure performing a numerical
        differentiation as per :literal:`derivnum`:

        ::

        ? f(x) = x^10;
        ? g = derivn(f, 5)
        ? g(1)
        %3 = 30240.000000000000000000000000000000000
        
        ? derivn(zeta, 2)(0)
        %4 = -2.0063564559085848512101000267299604382
        ? zeta''(0)
        %5 = -2.0063564559085848512101000267299604382
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = derivn(_x, n, _v)
        return new_gen(_ret)

    def diffop(x, v, d, long n=1):
        r'''
        Let :math:`v` be a vector of variables, and :math:`d` a vector of the same length,
        return the image of :math:`x` by the :math:`n`-power (:math:`1` if n is not given) of the
        differential operator :math:`D` that assumes the value :literal:`d[i]` on the variable
        :literal:`v[i]`. The value of :math:`D` on a scalar type is zero, and :math:`D` applies
        componentwise to a vector or matrix. When applied to a :literal:`t_POLMOD`, if no
        value is provided for the variable of the modulus, such value is derived
        using the implicit function theorem.

        :strong:`Examples.`
        This function can be used to differentiate formal expressions:
        if :math:`E = \exp (X^{2})` then we have :math:`E' = 2*X*E`. We derivate :math:`X*exp(X^{2})`
        as follows:

        ::

        ? diffop(E*X,[X,E],[1,2*X*E])
        %1 = (2*X^2 + 1)*E

        Let :literal:`Sin` and :literal:`Cos` be two function such that
        :math:`Sin^{2}+Cos^{2} = 1` and :math:`Cos' = -Sin`.
        We can differentiate :math:`Sin/Cos` as follows,
        PARI inferring the value of :math:`Sin'` from the equation:

        ::

        ? diffop(Mod('Sin/'Cos,'Sin^2+'Cos^2-1),['Cos],[-'Sin])
        %1 = Mod(1/Cos^2, Sin^2 + (Cos^2 - 1))

        Compute the Bell polynomials (both complete and partial) via the Faa di Bruno
        formula:

        ::

        Bell(k,n=-1)=
        { my(x, v, dv, var = i->eval(Str("X",i)));
        
        v = vector(k, i, if (i==1, 'E, var(i-1)));
        dv = vector(k, i, if (i==1, 'X*var(1)*'E, var(i)));
        x = diffop('E,v,dv,k) / 'E;
        if (n < 0, subst(x,'X,1), polcoef(x,n,'X));
        }
        '''
        v = objtogen(v)
        d = objtogen(d)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = diffop0(_x, _v, _d, n)
        return new_gen(_ret)

    def digits(x, b=None):
        r'''
        Outputs the vector of the digits of :math:`x` in base :math:`b`, where :math:`x` and :math:`b` are
        integers (:math:`b = 10` by default), from most significant down to least
        significant, the digits being the the integers :math:`0`, :math:`1`,...:math:`\|b\|-1`.
        If :math:`b > 0` and :math:`x < 0`, return the digits of :math:`\|x\|`.

        For :math:`x >= 1` and :math:`b > 0`, the number of digits is
        :math:`logint (x,b) + 1`. See :literal:`fromdigits` for the reverse operation.

        We also allow :math:`x` an integral :math:`p`-adic in which case :math:`b` should be omitted
        or equal to :math:`p`. Digits are still ordered from most significant to least
        significant in the :math:`p`-adic sense (meaning we start from :math:`x` mod :math:`p`);
        trailing zeros are truncated.

        ::

        ? digits(1230)
        %1 = [1, 2, 3, 0]
        
        ? digits(10, 2) \\ base 2
        %2 = [1, 0, 1, 0]

        By convention, :math:`0` has no digits:

        ::

        ? digits(0)
        %3 = []
        ? digits(10,-2) \\ base -2
        %4 = [1, 1, 1, 1, 0] \\ 10 = -2 + 4 - 8 + 16
        ? 1105 + O(5^5)
        %5 = 5 + 4*5^2 + 3*5^3 + O(5^5)
        ? digits(%)
        %6 = [0, 1, 4, 3]
        '''
        cdef bint _have_b = (b is not None)
        if _have_b:
            b = objtogen(b)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _b = NULL
        if _have_b:
            _b = (<Gen>b).g
        cdef GEN _ret = digits(_x, _b)
        return new_gen(_ret)

    def dilog(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of the dilogarithm of :math:`x`,
        i.e. analytic continuation of the power series
        :math:`Li_{2}(x) = \sum_{n >= 1}x^{n}/n^{2}`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = dilog(_x, precision)
        return new_gen(_ret)

    def dirdiv(x, y):
        r'''
        :math:`x` and :math:`y` being vectors of perhaps different
        lengths but with :math:`y[1] ! = 0` considered as Dirichlet series, computes
        the quotient of :math:`x` by :math:`y`, again as a vector.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = dirdiv(_x, _y)
        return new_gen(_ret)

    def dirmul(x, y):
        r'''
        :math:`x` and :math:`y` being vectors of perhaps different lengths representing
        the Dirichlet series :math:`\sum_{n} x_{n} n^{-s}` and :math:`\sum_{n} y_{n} n^{-s}`,
        computes the product of :math:`x` by :math:`y`, again as a vector.

        ::

        ? dirmul(vector(10,n,1), vector(10,n,moebius(n)))
        %1 = [1, 0, 0, 0, 0, 0, 0, 0, 0, 0]

        The product
        length is the minimum of :math:`\# x* v(y)` and :math:`\# y* v(x)`,
        where :math:`v(x)` is the index of the first nonzero coefficient.

        ::

        ? dirmul([0,1], [0,1]);
        %2 = [0, 0, 0, 1]
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = dirmul(_x, _y)
        return new_gen(_ret)

    def dirpowerssum(N, x, f=None, long both=0, long precision=DEFAULT_BITPREC):
        r'''
        For positive integer :math:`N` and complex number :math:`x`, return the sum
        :math:`f(1)1^{x} + f(2)2^{x} +...+ f(N)N^{x}`, where :math:`f` is a completely
        multiplicative function. If :math:`f` is omitted, return
        :math:`1^{x} +...+ N^{x}`. When :math:`N <= 0`, the function returns :math:`0`.
        If :literal:`both` is set, return the pair for arguments :math:`(x,f)` and
        :math:`(-1-x,\overline{f})`. If :literal:`both = 2`, assume in addition that :math:`f` is
        real-valued (which is true when :math:`f` is omitted, i.e. represents the constant
        function :math:`f(n) = 1`).

        :strong:`Caveat.` when ``both`` is set, the present implementation
        assumes that :math:`\|f(n)\|` is either :math:`0` or :math:`1`, which is the case for
        Dirichlet characters.

        A vector-valued multiplicative function :math:`f` is allowed, in which case the
        above conditions must be met componentwise and the vector length must
        be constant.

        Unlike variants using :literal:`dirpowers(N,x)`, this function uses :math:`O(\sqrt{N})`
        memory instead of :math:`O(N)`. And it is faster for large :math:`N`. The return value
        is usually a floating point number, but it will be exact if the result
        is an integer. On the other hand, rational numbers are converted to
        floating point approximations, since they are likely to blow up for large :math:`N`.

        ::

        ? dirpowers(5, 2)
        %1 = [1, 4, 9, 16, 25]
        ? vecsum(%)
        %2 = 55
        ? dirpowerssum(5, 2)
        %3 = 55
        ? dirpowerssum(5, -2)
        %4 = 1.4636111111111111111111111111111111111
        ? \p200
        ? s = 1/2 + I * sqrt(3); N = 10^7;
        ? dirpowerssum(N, s);
        time = 11,425 ms.
        ? vecsum(dirpowers(N, s))
        time = 19,365 ms.
        ? dirpowerssum(N, s, n->kronecker(-23,n))
        time = 10,981 ms.

        The :literal:`dirpowerssum` commands work with default stack size,
        the :literal:`dirpowers` one requires a stacksize of at least 5GB.
        '''
        x = objtogen(x)
        cdef bint _have_f = (f is not None)
        if _have_f:
            f = objtogen(f)
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _f = NULL
        if _have_f:
            _f = (<Gen>f).g
        precision = nbits2prec(precision)
        cdef GEN _ret = dirpowerssum0(_N, _x, _f, both, precision)
        return new_gen(_ret)

    def dirzetak(nf, b):
        r'''
        Gives as a vector the first :math:`b`
        coefficients of the Dedekind zeta function of the number field :math:`nf`
        considered as a Dirichlet series.
        '''
        b = objtogen(b)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = dirzetak(_nf, _b)
        return new_gen(_ret)

    def divisors(x, long flag=0):
        r'''
        Creates a row vector whose components are the
        divisors of :math:`x`. The factorization of :math:`x` (as output by :literal:`factor`) can
        be used instead. If :math:`flag = 1`, return pairs :math:`[d, factor (d)]`.

        By definition, these divisors are the products of the irreducible
        factors of :math:`n`, as produced by :literal:`factor(n)`, raised to appropriate
        powers (no negative exponent may occur in the factorization). If :math:`n` is
        an integer, they are the positive divisors, in increasing order.

        ::

        ? divisors(12)
        %1 = [1, 2, 3, 4, 6, 12]
        ? divisors(12, 1) \\ include their factorization
        %2 = [[1, matrix(0,2)], [2, Mat([2, 1])], [3, Mat([3, 1])],
        [4, Mat([2, 2])], [6, [2, 1; 3, 1]], [12, [2, 2; 3, 1]]]
        
        ? divisors(x^4 + 2*x^3 + x^2) \\ also works for polynomials
        %3 = [1, x, x^2, x + 1, x^2 + x, x^3 + x^2, x^2 + 2*x + 1,
        x^3 + 2*x^2 + x, x^4 + 2*x^3 + x^2]

        This function requires a lot of memory if :math:`x` has many divisors. The
        following idiom runs through all divisors using very little memory, in no
        particular order this time:

        ::

        F = factor(x); P = F[,1]; E = F[,2];
        forvec(e = vectorv(#E,i,[0,E[i]]), d = factorback(P,e); ...)

        If the factorization of :math:`d` is also desired, then :math:`[P,e]` almost
        provides it but not quite: :math:`e` may contain :math:`0` exponents, which are not
        allowed in factorizations. These must be sieved out as in:

        ::

        ? tofact(P,E) = matreduce(Mat([P,E]));
        ? tofact([2,3,5,7]~, [4,0,2,0]~)
        %4 =
        [2 4]
        
        [5 2]

        We can then run the above loop with :literal:`tofact(P,e)` instead of,
        or together with, :literal:`factorback`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = divisors0(_x, flag)
        return new_gen(_ret)

    def divisorslenstra(N, r, s):
        r'''
        Given three integers :math:`N > s > r >= 0` such that :math:`(r,s) = 1`
        and :math:`s^{3} > N`, find all divisors :math:`d` of :math:`N` such that :math:`d = r (mod s)`.
        There are at most :math:`11` such divisors (Lenstra).

        ::

        ? N = 245784; r = 19; s = 65 ;
        ? divisorslenstra(N, r, s)
        %2 = [19, 84, 539, 1254, 3724, 245784]
        ? [ d | d <- divisors(N), d % s == r]
        %3 = [19, 84, 539, 1254, 3724, 245784]

        When the preconditions are not met, the result is undefined:

        ::

        ? N = 4484075232; r = 7; s = 1303; s^3 > N
        %4 = 0
        ? divisorslenstra(N, r, s)
        ? [ d | d <- divisors(N), d % s == r ]
        %6 = [7, 2613, 9128, 19552, 264516, 3407352, 344928864]

        (Divisors were missing but :math:`s^{3} < N`.)
        '''
        r = objtogen(r)
        s = objtogen(s)
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _r = (<Gen>r).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _ret = divisorslenstra(_N, _r, _s)
        return new_gen(_ret)

    def divrem(x, y, v=None):
        r'''
        Creates a column vector with two components, the first being the Euclidean
        quotient (:literal:`:math:`x` \\:math:`y``), the second the Euclidean remainder
        (:literal:`:math:`x` - (:math:`x`\\:math:`y`)*:math:`y``), of the division of :math:`x` by :math:`y`. This avoids the
        need to do two divisions if one needs both the quotient and the remainder.
        If :math:`v` is present, and :math:`x`, :math:`y` are multivariate
        polynomials, divide with respect to the variable :math:`v`.

        Beware that :literal:`divrem(:math:`x`,:math:`y`)[2]` is in general not the same as
        :literal:`:math:`x` \% :math:`y``; no GP operator corresponds to it:

        ::

        ? divrem(1/2, 3)[2]
        %1 = 1/2
        ? (1/2) % 3
        %2 = 2
        ? divrem(Mod(2,9), 3)[2]
        *** at top-level: divrem(Mod(2,9),3)[2
        *** ^--------------------
        *** forbidden division t_INTMOD \ t_INT.
        ? Mod(2,9) % 6
        %3 = Mod(2,3)
        '''
        y = objtogen(y)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = divrem(_x, _y, _v)
        return new_gen(_ret)

    def eint1(x, n=None, long precision=DEFAULT_BITPREC):
        r'''
        Exponential integral :math:`\int_{x}^{ oo } (e^{-t})/(t)dt =
        incgam (0, x)`, where the latter expression extends the function
        definition from real :math:`x > 0` to all complex :math:`x ! = 0`.

        If :math:`n` is present, we must have :math:`x > 0`; the function returns the
        :math:`n`-dimensional vector :math:`[eint1 (x),...,eint1 (nx)]`. Contrary to
        other transcendental functions, and to the default case (:math:`n` omitted), the
        values are correct up to a bounded :emphasis:`absolute`, rather than relative,
        error :math:`10^{-n}`, where :math:`n` is :literal:`precision`:math:`(x)` if :math:`x` is a :literal:`t_REAL`
        and defaults to :literal:`realprecision` otherwise. (In the most important
        application, to the computation of :math:`L`-functions via approximate functional
        equations, those values appear as weights in long sums and small individual
        relative errors are less useful than controlling the absolute error.) This is
        faster than repeatedly calling :literal:`eint1(:math:`i` * x)`, but less precise.
        '''
        cdef bint _have_n = (n is not None)
        if _have_n:
            n = objtogen(n)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _n = NULL
        if _have_n:
            _n = (<Gen>n).g
        precision = nbits2prec(precision)
        cdef GEN _ret = veceint1(_x, _n, precision)
        return new_gen(_ret)

    def ell2cover(E, long precision=DEFAULT_BITPREC):
        r'''
        If :math:`E` is an elliptic curve over :math:`\mathbb{Q}`, returns a basis of the set of
        everywhere locally soluble :math:`2`-covers of the curve :math:`E`.
        For each cover a pair :math:`[R,P]` is returned where :math:`y^{2}-R(x)` is a quartic curve
        and :math:`P` is a point on :math:`E(k)`, where :math:`k = \mathbb{Q} (x)[y] / (y^{2}-R(x))`.
        :math:`E` can also be given as the output of :literal:`ellrankinit(E)`,
        or as a pair :math:`[e, f]`, where :math:`e` is an elliptic curve given by
        :literal:`ellrankinit` and :math:`f` is a quadratic twist of :math:`e`. We then look for
        points on :math:`f`.

        ::

        ? E = ellinit([-25,4]);
        ? C = ell2cover(E); #C
        %2 = 2
        ? [R,P] = C[1]; R
        %3 = 64*x^4+480*x^2-128*x+100
        ? P[1]
        %4 = -320/y^2*x^4 + 256/y^2*x^3 + 800/y^2*x^2 - 320/y^2*x - 436/y^2
        ? ellisoncurve(E, Mod(P, y^2-R))
        %5 = 1
        ? H = hyperellratpoints(R,10)
        %6 = [[0,10], [0,-10], [1/5,242/25], [1/5,-242/25], [2/5,282/25],
        [2/5,-282/25]]
        ? A = substvec(P,[x,y],H[1])
        %7 = [-109/25, 686/125]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ell2cover(_E, precision)
        return new_gen(_ret)

    def ellE(k, long precision=DEFAULT_BITPREC):
        r'''
        Complete elliptic integral of the second kind

        .. MATH::

        E(k) = \int_{0}^{\pi/2}(1-k^{2}\sin (t)^{2})^{1/2}dt

        for the
        complex parameter :math:`k` using the agm.

        In particular, the perimeter of an ellipse of semi-major and semi-minor axes
        :math:`a` and :math:`b` is given by

        ::

        e = sqrt(1 - (b/a)^2); \\ eccentricity
        4 * a * ellE(e) \\ perimeter
        '''
        sig_on()
        cdef GEN _k = (<Gen>k).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellE(_k, precision)
        return new_gen(_ret)

    def ellK(k, long precision=DEFAULT_BITPREC):
        r'''
        Complete elliptic integral of the first kind

        .. MATH::

        K(k) = \int_{0}^{\pi/2}(1-k^{2}\sin (t)^{2})^{-1/2}dt

        for the
        complex parameter :math:`k` using the agm.
        '''
        sig_on()
        cdef GEN _k = (<Gen>k).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellK(_k, precision)
        return new_gen(_ret)

    def ellL1(E, long r=0, long precision=DEFAULT_BITPREC):
        r'''
        Returns the value at :math:`s = 1` of the derivative of order :math:`r` of the
        :math:`L`-function of the elliptic curve :math:`E/\mathbb{Q}`.

        ::

        ? E = ellinit("11a1"); \\ order of vanishing is 0
        ? ellL1(E)
        %2 = 0.2538418608559106843377589233
        ? E = ellinit("389a1"); \\ order of vanishing is 2
        ? ellL1(E)
        %4 = -5.384067311837218089235032414 E-29
        ? ellL1(E, 1)
        %5 = 0
        ? ellL1(E, 2)
        %6 = 1.518633000576853540460385214

        The main use of this function, after computing at :emphasis:`low` accuracy the
        order of vanishing using :literal:`ellanalyticrank`, is to compute the
        leading term at :emphasis:`high` accuracy to check (or use) the Birch and
        Swinnerton-Dyer conjecture:

        ::

        ? \p18
        realprecision = 18 significant digits
        ? E = ellinit("5077a1"); ellanalyticrank(E)
        time = 8 ms.
        %1 = [3, 10.3910994007158041]
        ? \p200
        realprecision = 202 significant digits (200 digits displayed)
        ? ellL1(E, 3)
        time = 104 ms.
        %3 = 10.3910994007158041387518505103609170697263563756570092797[...]

        Analogous and more general functionalities for :math:`E`
        defined over general number fields are available through :literal:`lfun`.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellL1(_E, r, precision)
        return new_gen(_ret)

    def elladd(E, z1, z2):
        r'''
        Sum of the points :math:`z1` and :math:`z2` on the
        elliptic curve corresponding to :math:`E`.
        '''
        z1 = objtogen(z1)
        z2 = objtogen(z2)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z1 = (<Gen>z1).g
        cdef GEN _z2 = (<Gen>z2).g
        cdef GEN _ret = elladd(_E, _z1, _z2)
        return new_gen(_ret)

    def ellak(E, n):
        r'''
        Computes the coefficient :math:`a_{n}` of the :math:`L`-function of the elliptic curve
        :math:`E/\mathbb{Q}`, i.e. coefficients of a newform of weight 2 by the modularity theorem
        (Taniyama-Shimura-Weil conjecture). :math:`E` must be an :literal:`ell` structure
        over :math:`\mathbb{Q}` as output by :literal:`ellinit`. :math:`E` must be given by an integral model,
        not necessarily minimal, although a minimal model will make the function
        faster.

        ::

        ? E = ellinit([1,-1,0,4,3]);
        ? ellak(E, 10)
        %2 = -3
        ? e = ellchangecurve(E, [1/5,0,0,0]); \\ made not minimal at 5
        ? ellak(e, 10) \\ wasteful but works
        %3 = -3
        ? E = ellminimalmodel(e); \\ now minimal
        ? ellak(E, 5)
        %5 = -3

        If the model is not minimal at a number of bad primes, then
        the function will be slower on those :math:`n` divisible by the bad primes.
        The speed should be comparable for other :math:`n`:

        ::

        ? for(i=1,10^6, ellak(E,5))
        time = 699 ms.
        ? for(i=1,10^6, ellak(e,5)) \\ 5 is bad, markedly slower
        time = 1,079 ms.
        
        ? for(i=1,10^5,ellak(E,5*i))
        time = 1,477 ms.
        ? for(i=1,10^5,ellak(e,5*i)) \\ still slower but not so much on average
        time = 1,569 ms.
        '''
        n = objtogen(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = akell(_E, _n)
        return new_gen(_ret)

    def ellan(E, long n):
        r'''
        Computes the vector of the first :math:`n` Fourier coefficients :math:`a_{k}`
        corresponding to the elliptic curve :math:`E` defined over a number field.
        If :math:`E` is defined over :math:`\mathbb{Q}`, the curve may be given by an
        arbitrary model, not necessarily minimal,
        although a minimal model will make the function faster. Over a more general
        number field, the model must be locally minimal at all primes above :math:`2`
        and :math:`3`.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellan(_E, n)
        return new_gen(_ret)

    def ellanalyticrank(E, eps=None, long precision=DEFAULT_BITPREC):
        r'''
        Returns the order of vanishing at :math:`s = 1` of the :math:`L`-function of the
        elliptic curve :math:`E/\mathbb{Q}` and the value of the first nonzero derivative. To
        determine this order, it is assumed that any value less than :literal:`eps` is
        zero. If :literal:`eps` is omitted, :math:`2^{-b/2}` is used, where :math:`b`
        is the current bit precision.

        ::

        ? E = ellinit("11a1"); \\ rank 0
        ? ellanalyticrank(E)
        %2 = [0, 0.2538418608559106843377589233]
        ? E = ellinit("37a1"); \\ rank 1
        ? ellanalyticrank(E)
        %4 = [1, 0.3059997738340523018204836835]
        ? E = ellinit("389a1"); \\ rank 2
        ? ellanalyticrank(E)
        %6 = [2, 1.518633000576853540460385214]
        ? E = ellinit("5077a1"); \\ rank 3
        ? ellanalyticrank(E)
        %8 = [3, 10.39109940071580413875185035]

        Analogous and more general functionalities for :math:`E`
        defined over general number fields are available through :literal:`lfun`
        and :literal:`lfunorderzero`.
        '''
        cdef bint _have_eps = (eps is not None)
        if _have_eps:
            eps = objtogen(eps)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _eps = NULL
        if _have_eps:
            _eps = (<Gen>eps).g
        cdef GEN _ret = ellanalyticrank(_E, _eps, precision)
        return new_gen(_ret)

    def ellap(E, p=None):
        r'''
        Let :literal:`E` be an :literal:`ell` structure as output by :literal:`ellinit`, attached
        to an elliptic curve :math:`E/K`. If the field :math:`K = \mathbb{F}_{q}` is finite, return the
        trace of Frobenius :math:`t`, defined by the equation :math:`\#E(\mathbb{F}_{q}) = q+1 - t`.

        For other fields of definition and :math:`p` defining a finite residue field
        :math:`\mathbb{F}_{q}`, return the trace of Frobenius for the reduction of :math:`E`: the argument
        :math:`p` is best left omitted if :math:`K = \mathbb{Q}_{\ell}` (else we must have :math:`p = \ell`) and
        must be a prime number (:math:`K = \mathbb{Q}`) or prime ideal (:math:`K` a general number field)
        with residue field :math:`\mathbb{F}_{q}` otherwise. The equation need not be minimal
        or even integral at :math:`p`; of course, a minimal model will be more efficient.

        For a number field :math:`K`, the trace of Frobenius is the :math:`a_{p}`
        coefficient in the Euler product defining the curve :math:`L`-series, whence
        the function name:

        .. MATH::

        L(E/K,s) = \prod_{bad p} (1-a_{p} (Np)^{-s})^{-1}
        \prod_{good p} (1-a_{p} (Np)^{-s} + (Np)^{1-2s})^{-1}.

        When the characteristic of the finite field is large, the availability of
        the :literal:`seadata` package will speed up the computation.

        ::

        ? E = ellinit([0,1]); \\ y^2 = x^3 + 0.x + 1, defined over Q
        ? ellap(E, 7) \\ 7 necessary here
        %2 = -4 \\ #E(F_7) = 7+1-(-4) = 12
        ? ellcard(E, 7)
        %3 = 12 \\ OK
        
        ? E = ellinit([0,1], 11); \\ defined over F_11
        ? ellap(E) \\ no need to repeat 11
        %4 = 0
        ? ellap(E, 11) \\ ... but it also works
        %5 = 0
        ? ellgroup(E, 13) \\ ouch, inconsistent input!
        *** at top-level: ellap(E,13)
        *** ^-----------
        *** ellap: inconsistent moduli in Rg_to_Fp:
        11
        13
        ? a = ffgen(ffinit(11,3), 'a); \\ defines F_q := F_{11^3}
        ? E = ellinit([a+1,a]); \\ y^2 = x^3 + (a+1)x + a, defined over F_q
        ? ellap(E)
        %8 = -3

        If the curve is defined over a more general number field than :math:`\mathbb{Q}`,
        the maximal ideal :math:`p` must be explicitly given in :literal:`idealprimedec`
        format. There is no assumption of local minimality at :math:`p`.

        ::

        ? K = nfinit(a^2+1); E = ellinit([1+a,0,1,0,0], K);
        ? fa = idealfactor(K, E.disc)
        %2 =
        [ [5, [-2, 1]~, 1, 1, [2, -1; 1, 2]] 1]
        
        [[13, [5, 1]~, 1, 1, [-5, -1; 1, -5]] 2]
        ? ellap(E, fa[1,1])
        %3 = -1 \\ nonsplit multiplicative reduction
        ? ellap(E, fa[2,1])
        %4 = 1 \\ split multiplicative reduction
        ? P17 = idealprimedec(K,17)[1];
        ? ellap(E, P17)
        %6 = 6 \\ good reduction
        ? E2 = ellchangecurve(E, [17,0,0,0]);
        ? ellap(E2, P17)
        %8 = 6 \\ same, starting from a nonminimal model
        
        ? P3 = idealprimedec(K,3)[1];
        ? ellap(E, P3) \\ OK: E is minimal at P3
        %10 = -2
        ? E3 = ellchangecurve(E, [3,0,0,0]);
        ? ellap(E3, P3) \\ not integral at P3
        *** at top-level: ellap(E3,P3)
        *** ^------------
        *** ellap: impossible inverse in Rg_to_ff: Mod(0, 3).

        :strong:`Algorithms used.` If :math:`E/\mathbb{F}_{q}` has CM by a principal imaginary
        quadratic order we use a fast explicit formula (involving essentially
        Kronecker symbols and Cornacchia's algorithm), in :math:`O(\log q)^{2}` bit
        operations.
        Otherwise, we use Shanks-Mestre's baby-step/giant-step method, which runs in
        time :math:`~{O}(q^{1/4})` using :math:`~{O}(q^{1/4})` storage, hence becomes
        unreasonable when :math:`q` has about 30 digits. Above this range, the :literal:`SEA`
        algorithm becomes available, heuristically in :math:`~{O}(\log q)^{4}`, and
        primes of the order of 200 digits become feasible. In small
        characteristic we use Mestre's (p = 2), Kohel's (p = 3,5,7,13), Satoh-Harley
        (all in :math:`~{O}(p^{2} n^{2})`) or Kedlaya's (in :math:`~{O}(p n^{3})`)
        algorithms.
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = ellap(_E, _p)
        return new_gen(_ret)

    def ellbil(E, z1, z2, long precision=DEFAULT_BITPREC):
        r'''
        Deprecated alias for :literal:`ellheight(E,P,Q)`.
        '''
        from warnings import warn
        warn('the PARI/GP function ellbil is obsolete (2014-05-21)', DeprecationWarning)
        z1 = objtogen(z1)
        z2 = objtogen(z2)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z1 = (<Gen>z1).g
        cdef GEN _z2 = (<Gen>z2).g
        precision = nbits2prec(precision)
        cdef GEN _ret = bilhell(_E, _z1, _z2, precision)
        return new_gen(_ret)

    def ellbsd(E, long precision=DEFAULT_BITPREC):
        r'''
        :math:`E` being an elliptic curve over a number field, returns a real
        number :math:`c` such that the Birch and Swinnerton-Dyer conjecture predicts that
        :math:`L_{E}^{(r)}(1)/r! = c R S`, where :math:`r` is the rank, :math:`R` the regulator and
        :math:`S` the cardinal of the Tate-Shafarevich group.

        ::

        ? e = ellinit([0,-1,1,-10,-20]); \\ rank 0
        ? ellbsd(e)
        %2 = 0.25384186085591068433775892335090946105
        ? lfun(e,1)
        %3 = 0.25384186085591068433775892335090946104
        ? e = ellinit([0,0,1,-1,0]); \\ rank 1
        ? P = ellheegner(e);
        ? ellbsd(e)*ellheight(e,P)
        %6 = 0.30599977383405230182048368332167647445
        ? lfun(e,1,1)
        %7 = 0.30599977383405230182048368332167647445
        ? e = ellinit([1+a,0,1,0,0],nfinit(a^2+1)); \\ rank 0
        ? ellbsd(e)
        %9 = 0.42521832235345764503001271536611593310
        ? lfun(e,1)
        %10 = 0.42521832235345764503001271536611593309
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellbsd(_E, precision)
        return new_gen(_ret)

    def ellcard(E, p=None):
        r'''
        Let :literal:`E` be an :literal:`ell` structure as output by :literal:`ellinit`, attached
        to an elliptic curve :math:`E/K`. If :math:`K = \mathbb{F}_{q}` is finite, return the order of the
        group :math:`E(\mathbb{F}_{q})`.

        ::

        ? E = ellinit([-3,1], 5); ellcard(E)
        %1 = 7
        ? t = ffgen(3^5,'t); E = ellinit([t,t^2+1]); ellcard(E)
        %2 = 217

        For other fields of definition and :math:`p` defining a finite residue field
        :math:`\mathbb{F}_{q}`, return the order of the reduction of :math:`E`: the argument :math:`p` is best
        left omitted if :math:`K = \mathbb{Q}_{\ell}` (else we must have :math:`p = \ell`) and must be a
        prime number (:math:`K = \mathbb{Q}`) or prime ideal (:math:`K` a general number field) with
        residue field :math:`\mathbb{F}_{q}` otherwise. The equation need not be minimal
        or even integral at :math:`p`; of course, a minimal model will be more efficient.
        The function considers the group of nonsingular points of the reduction
        of a minimal model of the curve at :math:`p`, so also makes sense when the curve
        has bad reduction.

        ::

        ? E = ellinit([-3,1]);
        ? factor(E.disc)
        %2 =
        [2 4]
        
        [3 4]
        ? ellcard(E, 5) \\ as above !
        %3 = 7
        ? ellcard(E, 2) \\ additive reduction
        %4 = 2

        When the characteristic of the finite field is large, the availability of
        the :literal:`seadata` package will speed the computation. See also :literal:`ellap`
        for the list of implemented algorithms.
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = ellcard(_E, _p)
        return new_gen(_ret)

    def ellchangecurve(E, v):
        r'''
        Changes the data for the elliptic curve :math:`E`
        by changing the coordinates using the vector :literal:`v = [u,r,s,t]`, i.e. if :math:`x'`
        and :math:`y'` are the new coordinates, then :math:`x = u^{2}x'+r`, :math:`y = u^{3}y'+su^{2}x'+t`.
        :math:`E` must be an :literal:`ell` structure as output by :literal:`ellinit`. The special
        case :math:`v = 1` is also used instead of :math:`[1,0,0,0]` to denote the
        trivial coordinate change.
        '''
        v = objtogen(v)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = ellchangecurve(_E, _v)
        return new_gen(_ret)

    def ellchangepoint(x, v):
        r'''
        Changes the coordinates of the point or
        vector of points :math:`x` using the vector :literal:`v = [u,r,s,t]`, i.e. if :math:`x'` and
        :math:`y'` are the new coordinates, then :math:`x = u^{2}x'+r`, :math:`y = u^{3}y'+su^{2}x'+t`
        (see also :literal:`ellchangecurve`).

        ::

        ? E0 = ellinit([1,1]); P0 = [0,1]; v = [1,2,3,4];
        ? E = ellchangecurve(E0, v);
        ? P = ellchangepoint(P0,v)
        %3 = [-2, 3]
        ? ellisoncurve(E, P)
        %4 = 1
        ? ellchangepointinv(P,v)
        %5 = [0, 1]
        '''
        v = objtogen(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = ellchangepoint(_x, _v)
        return new_gen(_ret)

    def ellchangepointinv(x, v):
        r'''
        Changes the coordinates of the point or vector of points :math:`x` using
        the inverse of the isomorphism attached to :literal:`v = [u,r,s,t]`,
        i.e. if :math:`x'` and :math:`y'` are the old coordinates, then :math:`x = u^{2}x'+r`,
        :math:`y = u^{3}y'+su^{2}x'+t` (inverse of :literal:`ellchangepoint`).

        ::

        ? E0 = ellinit([1,1]); P0 = [0,1]; v = [1,2,3,4];
        ? E = ellchangecurve(E0, v);
        ? P = ellchangepoint(P0,v)
        %3 = [-2, 3]
        ? ellisoncurve(E, P)
        %4 = 1
        ? ellchangepointinv(P,v)
        %5 = [0, 1] \\ we get back P0
        '''
        v = objtogen(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = ellchangepointinv(_x, _v)
        return new_gen(_ret)

    def ellconvertname(name):
        r'''
        Converts an elliptic curve name, as found in the :literal:`elldata` database,
        from a string to a triplet :math:`[conductor, isogeny class,
        index]`. It will also convert a triplet back to a curve name.
        Examples:

        ::

        ? ellconvertname("123b1")
        %1 = [123, 1, 1]
        ? ellconvertname(%)
        %2 = "123b1"
        '''
        sig_on()
        cdef GEN _name = (<Gen>name).g
        cdef GEN _ret = ellconvertname(_name)
        return new_gen(_ret)

    def elldivpol(E, long n, v=None):
        r'''
        :math:`n`-division polynomial :math:`f_{n}` for the curve :math:`E` in the
        variable :math:`v`. In standard notation, for any affine point :math:`P = (X,Y)` on the
        curve and any integer :math:`n >= 0`, we have

        .. MATH::

        [n]P = (\phi_{n}(P)\psi_{n}(P) : \omega_{n}(P) : \psi_{n}(P)^{3})

        for some polynomials :math:`\phi_{n},\omega_{n},\psi_{n}` in
        :math:`\mathbb{Z}[a_{1},a_{2},a_{3},a_{4},a_{6}][X,Y]`. We have :math:`f_{n}(X) = \psi_{n}(X)`
        for :math:`n` odd, and
        :math:`f_{n}(X) = \psi_{n}(X,Y) (2Y + a_{1}X+a_{3})` for :math:`n` even. We have

        .. MATH::

        f_{0} = 0, f_{1} = 1,
        f_{2} = 4X^{3} + b_{2}X^{2} + 2b_{4} X + b_{6},
        f_{3} = 3 X^{4} + b_{2} X^{3} + 3b_{4} X^{2} + 3 b_{6} X + b8,

        .. MATH::

        f_{4} = f_{2}(2X^{6} + b_{2} X^{5} + 5b_{4} X^{4} + 10 b_{6} X^{3}
        + 10 b_{8} X^{2} + (b_{2}b_{8}-b_{4}b_{6})X + (b_{8}b_{4} - b_{6}^{2})),
        ...

        When :math:`n` is odd, the roots of :math:`f_{n}` are the :math:`X`-coordinates of the affine
        points in the :math:`n`-torsion subgroup :math:`E[n]`; when :math:`n` is even, the roots
        of :math:`f_{n}` are the :math:`X`-coordinates of the affine points in :math:`E[n] \
        E[2]` when :math:`n > 2`, resp. in :math:`E[2]` when :math:`n = 2`.
        For :math:`n < 0`, we define :math:`f_{n} := - f_{-n}`.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = elldivpol(_E, n, _v)
        return new_gen(_ret)

    def elleisnum(w, long k, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        :math:`k` being an even positive integer, computes the numerical value of the
        Eisenstein series of weight :math:`k` at the lattice :math:`w`, as given by
        :literal:`ellperiods`, namely

        .. MATH::

        (2i \pi/\omega_{2})^{k}
        (1 + 2/\zeta (1-k) \sum_{n >= 1} n^{k-1}q^{n} / (1-q^{n})),

        where :math:`q = \exp (2i\pi \tau)` and :math:`\tau := \omega_{1}/\omega_{2}` belongs to the
        complex upper half-plane. It is also possible to directly input :math:`w =
        [\omega_{1},\omega_{2}]`, or an elliptic curve :math:`E` as given by :literal:`ellinit`.

        ::

        ? w = ellperiods([1,I]);
        ? elleisnum(w, 4)
        %2 = 2268.8726415508062275167367584190557607
        ? elleisnum(w, 6)
        %3 = -3.977978632282564763 E-33
        ? E = ellinit([1, 0]);
        ? elleisnum(E, 4)
        %5 = -48.000000000000000000000000000000000000

        When :emphasis:`flag` is nonzero and :math:`k = 4` or 6, returns the elliptic invariants :math:`g_{2}`
        or :math:`g_{3}`, such that

        .. MATH::

        y^{2} = 4x^{3} - g_{2} x - g_{3}

        is a Weierstrass equation for :math:`E`.

        ::

        ? g2 = elleisnum(E, 4, 1)
        %6 = -4.0000000000000000000000000000000000000
        ? g3 = elleisnum(E, 6, 1) \\ ~ 0
        %7 = 0.E-114 - 3.909948178422242682 E-57*I
        '''
        sig_on()
        cdef GEN _w = (<Gen>w).g
        precision = nbits2prec(precision)
        cdef GEN _ret = elleisnum(_w, k, flag, precision)
        return new_gen(_ret)

    def elleta(w, long precision=DEFAULT_BITPREC):
        r'''
        Returns the quasi-periods :math:`[\eta_{1},\eta_{2}]`
        attached to the lattice basis :math:`w = [\omega_{1}, \omega_{2}]`.
        Alternatively, :emphasis:`w` can be an elliptic curve :math:`E` as output by
        :literal:`ellinit`, in which case, the quasi periods attached to the period
        lattice basis :literal:`:math:`E`.omega` (namely, :literal:`:math:`E`.eta`) are returned.

        ::

        ? elleta([1, I])
        %1 = [3.141592653589793238462643383, 9.424777960769379715387930149*I]
        '''
        sig_on()
        cdef GEN _w = (<Gen>w).g
        precision = nbits2prec(precision)
        cdef GEN _ret = elleta(_w, precision)
        return new_gen(_ret)

    def ellformaldifferential(E, long serprec=-1, n=None):
        r'''
        Let :math:`\omega := dx / (2y+a_{1}x+a_{3})` be the invariant differential form
        attached to the model :math:`E` of some elliptic curve (:literal:`ellinit` form),
        and :math:`\eta := x(t)\omega`. Return :math:`n` terms (:literal:`seriesprecision` by default)
        of :math:`f(t),g(t)` two power series in the formal parameter :math:`t = -x/y` such that
        :math:`\omega = f(t) dt`, :math:`\eta = g(t) dt`:

        .. MATH::

        f(t) = 1+a_{1} t + (a_{1}^{2} + a_{2}) t^{2} +...,
        g(t) = t^{-2} +...

        ::

        ? E = ellinit([-1,1/4]); [f,g] = ellformaldifferential(E,7,'t);
        ? f
        %2 = 1 - 2*t^4 + 3/4*t^6 + O(t^7)
        ? g
        %3 = t^-2 - t^2 + 1/2*t^4 + O(t^5)
        '''
        cdef long _n = -1
        if n is not None:
            _n = get_var(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = ellformaldifferential(_E, serprec, _n)
        return new_gen(_ret)

    def ellformalexp(E, long serprec=-1, n=None):
        r'''
        The elliptic formal exponential :literal:`Exp` attached to :math:`E` is the
        isomorphism from the formal additive law to the formal group of :math:`E`. It is
        normalized so as to be the inverse of the elliptic logarithm (see
        :literal:`ellformallog`): :math:`Exp o L = \mathrm{Id}`. Return :math:`n` terms of this
        power series:

        ::

        ? E=ellinit([-1,1/4]); Exp = ellformalexp(E,10,'z)
        %1 = z + 2/5*z^5 - 3/28*z^7 + 2/15*z^9 + O(z^11)
        ? L = ellformallog(E,10,'t);
        ? subst(Exp,z,L)
        %3 = t + O(t^11)
        '''
        cdef long _n = -1
        if n is not None:
            _n = get_var(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = ellformalexp(_E, serprec, _n)
        return new_gen(_ret)

    def ellformallog(E, long serprec=-1, n=None):
        r'''
        The formal elliptic logarithm is a series :math:`L` in :math:`t K[[t]]`
        such that :math:`d L = \omega = dx / (2y + a_{1}x + a_{3})`, the canonical invariant
        differential attached to the model :math:`E`. It gives an isomorphism
        from the formal group of :math:`E` to the additive formal group.

        ::

        ? E = ellinit([-1,1/4]); L = ellformallog(E, 9, 't)
        %1 = t - 2/5*t^5 + 3/28*t^7 + 2/3*t^9 + O(t^10)
        ? [f,g] = ellformaldifferential(E,8,'t);
        ? L' - f
        %3 = O(t^8)
        '''
        cdef long _n = -1
        if n is not None:
            _n = get_var(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = ellformallog(_E, serprec, _n)
        return new_gen(_ret)

    def ellformalpoint(E, long serprec=-1, n=None):
        r'''
        If :math:`E` is an elliptic curve, return the coordinates :math:`x(t), y(t)` in the
        formal group of the elliptic curve :math:`E` in the formal parameter :math:`t = -x/y`
        at :math:`oo`:

        .. MATH::

        x = t^{-2} -a_{1} t^{-1} - a_{2} - a_{3} t +...

        .. MATH::

        y = - t^{-3} -a_{1} t^{-2} - a_{2}t^{-1} -a_{3} +...

        Return :math:`n` terms (:literal:`seriesprecision` by default) of these two power
        series, whose coefficients are in :math:`\mathbb{Z}[a_{1},a_{2},a_{3},a_{4},a_{6}]`.

        ::

        ? E = ellinit([0,0,1,-1,0]); [x,y] = ellformalpoint(E,8,'t);
        ? x
        %2 = t^-2 - t + t^2 - t^4 + 2*t^5 + O(t^6)
        ? y
        %3 = -t^-3 + 1 - t + t^3 - 2*t^4 + O(t^5)
        ? E = ellinit([0,1/2]); ellformalpoint(E,7)
        %4 = [x^-2 - 1/2*x^4 + O(x^5), -x^-3 + 1/2*x^3 + O(x^4)]
        '''
        cdef long _n = -1
        if n is not None:
            _n = get_var(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = ellformalpoint(_E, serprec, _n)
        return new_gen(_ret)

    def ellformalw(E, long serprec=-1, n=None):
        r'''
        Return the formal power series :math:`w` attached to the elliptic curve :math:`E`,
        in the variable :math:`t`:

        .. MATH::

        w(t) = t^{3}(1 + a_{1} t + (a_{2} + a_{1}^{2}) t^{2} +...+ O(t^{n})),

        which is the formal expansion of :math:`-1/y` in the formal parameter :math:`t := -x/y`
        at :math:`oo` (take :math:`n = seriesprecision` if :math:`n` is omitted). The
        coefficients of :math:`w` belong to :math:`\mathbb{Z}[a_{1},a_{2},a_{3},a_{4},a_{6}]`.

        ::

        ? E=ellinit([3,2,-4,-2,5]); ellformalw(E, 5, 't)
        %1 = t^3 + 3*t^4 + 11*t^5 + 35*t^6 + 101*t^7 + O(t^8)
        '''
        cdef long _n = -1
        if n is not None:
            _n = get_var(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = ellformalw(_E, serprec, _n)
        return new_gen(_ret)

    def ellfromeqn(P):
        r'''
        Given a genus :math:`1` plane curve, defined by the affine equation :math:`f(x,y) = 0`,
        return the coefficients :math:`[a_{1},a_{2},a_{3},a_{4},a_{6}]` of a Weierstrass
        equation for its Jacobian. This allows to recover a Weierstrass model for an
        elliptic curve given by a general plane cubic or by a binary quartic or
        biquadratic model. The function implements the :math:`f :---> f^{*}` formulae of
        Artin, Tate and Villegas (Advances in Math. 198 (2005), pp. 366--382).

        In the example below, the function is used to convert between twisted Edwards
        coordinates and Weierstrass coordinates.

        ::

        ? e = ellfromeqn(a*x^2+y^2 - (1+d*x^2*y^2))
        %1 = [0, -a - d, 0, -4*d*a, 4*d*a^2 + 4*d^2*a]
        ? E = ellinit(ellfromeqn(y^2-x^2 - 1 +(121665/121666*x^2*y^2)),2^255-19);
        ? isprime(ellcard(E) / 8)
        %3 = 1

        The elliptic curve attached to the sum of two cubes is given by

        ::

        ? ellfromeqn(x^3+y^3 - a)
        %1 = [0, 0, -9*a, 0, -27*a^2]

        :strong:`Congruent number problem.`
        Let :math:`n` be an integer, if :math:`a^{2}+b^{2} = c^{2}` and :math:`a b = 2 n`,
        then by substituting :math:`b` by :math:`2 n/a` in the first equation,
        we get :math:`((a^{2}+(2 n/a)^{2})-c^{2}) a^{2} = 0`.
        We set :math:`x = a`, :math:`y = a c`.

        ::

        ? En = ellfromeqn((x^2 + (2*n/x)^2 - (y/x)^2)*x^2)
        %1 = [0, 0, 0, -16*n^2, 0]

        For example :math:`23` is congruent since the curve has a point of infinite order,
        namely:

        ::

        ? ellheegner( ellinit(subst(En, n, 23)) )
        %2 = [168100/289, 68053440/4913]
        '''
        sig_on()
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = ellfromeqn(_P)
        return new_gen(_ret)

    def ellfromj(j):
        r'''
        Returns the coefficients :math:`[a_{1},a_{2},a_{3},a_{4},a_{6}]` of a fixed
        elliptic curve
        with :math:`j`-invariant :math:`j`. The given model is arbitrary; for instance, over the
        rationals, it is in general not minimal nor even integral.

        ::

        ? v = ellfromj(1/2)
        %1 = [0, 0, 0, 10365/4, 11937025/4]
        ? E = ellminimalmodel(ellinit(v)); E[1..5]
        %2 = [0, 0, 0, 41460, 190992400]
        ? F = ellminimalmodel(elltwist(E, 24)); F[1..5]
        %3 = [1, 0, 0, 72, 13822]
        ? [E.disc, F.disc]
        %4 = [-15763098924417024000, -82484842750]

        For rational :math:`j`, the following program returns the integral
        curve of minimal discriminant and given :math:`j` invariant:

        ::

        ellfromjminimal(j)=
        { my(E = ellinit(ellfromj(j)));
        my(D = ellminimaltwist(E));
        
        ellminimalmodel(elltwist(E,D));
        }
        ? e = ellfromjminimal(1/2); e.disc
        %1 = -82484842750

        Using :math:`flag = 1` in :literal:`ellminimaltwist` would instead return the
        curve of minimal conductor. For instance, if :math:`j = 1728`, this would return a
        different curve (of conductor :math:`32` instead of :math:`64`).
        '''
        sig_on()
        cdef GEN _j = (<Gen>j).g
        cdef GEN _ret = ellfromj(_j)
        return new_gen(_ret)

    def ellgenerators(E):
        r'''
        If :math:`E` is an elliptic curve over the rationals, return a :math:`\mathbb{Z}`-basis of the
        free part of the Mordell-Weil group attached to :math:`E`. This relies on
        the :literal:`elldata` database being installed and referencing the curve, and so
        is only available for curves over :math:`\mathbb{Z}` of small conductors.
        If :math:`E` is an elliptic curve over a finite field :math:`\mathbb{F}_{q}` as output by
        :literal:`ellinit`, return a minimal set of generators for the group :math:`E(\mathbb{F}_{q})`.

        :strong:`Caution.` When the group is not cyclic, of shape :math:`\mathbb{Z}/d_{1}\mathbb{Z} x
        \mathbb{Z}/d_{2}\mathbb{Z}` with :math:`d_{2} \| d_{1}`, the points :math:`[P,Q]` returned by
        ellgenerators need not have order :math:`d_{1}` and :math:`d_{2}`: it is true that
        :math:`P` has order :math:`d_{1}`, but we only know that :math:`Q` is a generator of
        :math:`E(\mathbb{F}_{q})/ <P>` and that the Weil pairing :math:`w(P,Q)` has order :math:`d_{2}`,
        see :literal:`??ellgroup`.
        If you need generators :math:`[P,R]` with :math:`R` of order :math:`d_{2}`, find
        :math:`x` such that :math:`R = Q-[x]P` has order :math:`d_{2}` by solving
        the discrete logarithm problem :math:`[d_{2}]Q = [x]([d_{2}]P)` in a cyclic group of
        order :math:`d_{1}/d_{2}`. This will be very expensive if :math:`d_{1}/d_{2}` has a large
        prime factor.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellgenerators(_E)
        return new_gen(_ret)

    def ellglobalred(E):
        r'''
        Let :math:`E` be an :literal:`ell` structure as output by :literal:`ellinit` attached
        to an elliptic curve defined over a number field. This function calculates
        the arithmetic conductor and the global Tamagawa number :math:`c`.
        The result :math:`[N,v,c,F,L]` is slightly different if :math:`E` is defined
        over :math:`\mathbb{Q}` (domain :math:`D = 1` in :literal:`ellinit`) or over a number field
        (domain :math:`D` is a number field structure, including :literal:`nfinit(x)`
        representing :math:`\mathbb{Q}` !):

        - :math:`N` is the arithmetic conductor of the curve,

        - :math:`v` is an obsolete field, left in place for backward compatibility.
        If :math:`E` is defined over :math:`\mathbb{Q}`, :math:`v` gives the coordinate change for :math:`E` to the
        standard minimal integral model (:literal:`ellminimalmodel` provides it in a
        cheaper way); if :math:`E` is defined over another number field, :math:`v` gives a
        coordinate change to an integral model (:literal:`ellintegralmodel` provides it
        in a cheaper way).

        - :math:`c` is the product of the local Tamagawa numbers :math:`c_{p}`, a quantity
        which enters in the Birch and Swinnerton-Dyer conjecture,

        - :math:`F` is the factorization of :math:`N`,

        - :math:`L` is a vector, whose :math:`i`-th entry contains the local data
        at the :math:`i`-th prime ideal divisor of :math:`N`, i.e.
        :literal:`L[i] = elllocalred(E,F[i,1])`. If :math:`E` is defined over :math:`\mathbb{Q}`, the local
        coordinate change has been deleted and replaced by a 0; if :math:`E` is defined
        over another number field the local coordinate change to a local minimal
        model is given relative to the integral model afforded by :math:`v` (so either
        start from an integral model so that :math:`v` be trivial, or apply :math:`v` first).
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellglobalred(_E)
        return new_gen(_ret)

    def ellgroup(E, p=None, long flag=0):
        r'''
        Let :literal:`E` be an :literal:`ell` structure as output by :literal:`ellinit`, attached
        to an elliptic curve :math:`E/K`. We first describe the function when the field
        :math:`K = \mathbb{F}_{q}` is finite, it computes the structure of the finite abelian group
        :math:`E(\mathbb{F}_{q})`:

        - if :math:`flag = 0`, returns the structure :math:`[]` (trivial group) or :math:`[d_{1}]`
        (nontrivial cyclic group) or :math:`[d_{1},d_{2}]` (noncyclic group) of
        :math:`E(\mathbb{F}_{q}) ~ \mathbb{Z}/d_{1}\mathbb{Z} x \mathbb{Z}/d_{2}\mathbb{Z}`, with :math:`d_{2} \| d_{1}`.

        - if :math:`flag = 1`, returns a triple :math:`[h,cyc,gen]`, where
        :math:`h` is the curve cardinality, :emphasis:`cyc` gives the group structure as a
        product of cyclic groups (as per :math:`flag = 0`). More precisely, if :math:`d_{2} > 1`,
        the output is :math:`[d_{1}d_{2}, [d_{1},d_{2}], [P,Q]]` where :math:`P` is
        of order :math:`d_{1}` and :math:`[P,Q]` generates the curve.
        :strong:`Caution.` It is not guaranteed that :math:`Q` has order :math:`d_{2}`, which in
        the worst case requires an expensive discrete log computation. Only that
        :literal:`ellweilpairing`:math:`(E, P, Q, d_{1})` has order :math:`d_{2}`.

        For other fields of definition and :math:`p` defining a finite residue field
        :math:`\mathbb{F}_{q}`, returns the structure of the reduction of :math:`E`: the argument
        :math:`p` is best left omitted if :math:`K = \mathbb{Q}_{\ell}` (else we must have :math:`p = \ell`) and
        must be a prime number (:math:`K = \mathbb{Q}`) or prime ideal (:math:`K` a general number field)
        with residue field :math:`\mathbb{F}_{q}` otherwise. The curve is allowed to have bad
        reduction at :math:`p` and in this case we consider the (cyclic) group of
        nonsingular points for the reduction of a minimal model at :math:`p`.

        If :math:`flag = 0`, the equation need not be minimal or even integral at :math:`p`; of
        course, a minimal model will be more efficient.

        If :math:`flag = 1`, the requested generators depend on the model, which must then
        be minimal at :math:`p`, otherwise an exception is thrown. Use
        :literal:`ellintegralmodel` and/or :literal:`ellocalred` first to reduce to this case.

        ::

        ? E = ellinit([0,1]); \\ y^2 = x^3 + 0.x + 1, defined over Q
        ? ellgroup(E, 7)
        %2 = [6, 2] \\ Z/6 x Z/2, noncyclic
        ? E = ellinit([0,1] * Mod(1,11)); \\ defined over F_11
        ? ellgroup(E) \\ no need to repeat 11
        %4 = [12]
        ? ellgroup(E, 11) \\ ... but it also works
        %5 = [12]
        ? ellgroup(E, 13) \\ ouch, inconsistent input!
        *** at top-level: ellgroup(E,13)
        *** ^--------------
        *** ellgroup: inconsistent moduli in Rg_to_Fp:
        11
        13
        ? ellgroup(E, 7, 1)
        %6 = [12, [6, 2], [[Mod(2, 7), Mod(4, 7)], [Mod(4, 7), Mod(4, 7)]]]

        Let us now consider curves of bad reduction, in this case we return the
        structure of the (cyclic) group of nonsingular points, satisfying
        :math:`\#E_{ns}(\mathbb{F}_{p}) = p - a_{p}`:

        ::

        ? E = ellinit([0,5]);
        ? ellgroup(E, 5, 1)
        %2 = [5, [5], [[Mod(4, 5), Mod(2, 5)]]]
        ? ellap(E, 5)
        %3 = 0 \\ additive reduction at 5
        ? E = ellinit([0,-1,0,35,0]);
        ? ellgroup(E, 5, 1)
        %5 = [4, [4], [[Mod(2, 5), Mod(2, 5)]]]
        ? ellap(E, 5)
        %6 = 1 \\ split multiplicative reduction at 5
        ? ellgroup(E, 7, 1)
        %7 = [8, [8], [[Mod(3, 7), Mod(5, 7)]]]
        ? ellap(E, 7)
        %8 = -1 \\ nonsplit multiplicative reduction at 7
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = ellgroup0(_E, _p, flag)
        return new_gen(_ret)

    def ellheegner(E):
        r'''
        Let :math:`E` be an elliptic curve over the rationals, assumed to be of
        (analytic) rank :math:`1`. This returns a nontorsion rational point on the curve,
        whose canonical height is equal to the product of the elliptic regulator by the
        analytic Sha.

        This uses the Heegner point method, described in Cohen GTM 239; the complexity
        is proportional to the product of the square root of the conductor and the
        height of the point (thus, it is preferable to apply it to strong Weil curves).

        ::

        ? E = ellinit([-157^2,0]);
        ? u = ellheegner(E); print(u[1], "\n", u[2])
        69648970982596494254458225/166136231668185267540804
        538962435089604615078004307258785218335/67716816556077455999228495435742408
        ? ellheegner(ellinit([0,1])) \\ E has rank 0 !
        *** at top-level: ellheegner(E=ellinit
        *** ^--------------------
        *** ellheegner: The curve has even analytic rank.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellheegner(_E)
        return new_gen(_ret)

    def ellheight(E, P=None, Q=None, long precision=DEFAULT_BITPREC):
        r'''
        Let :math:`E` be an elliptic curve defined over :math:`K = \mathbb{Q}` or a number field,
        as output by :literal:`ellinit`; it needs not be given by a minimal model
        although the computation will be faster if it is.

        - Without arguments :math:`P,Q`, returns the Faltings height of the curve :math:`E`
        using Deligne normalization. For a rational curve, the normalization is such
        that the function returns :literal:`-(1/2)*log(ellminimalmodel(E).area)`.

        - If the argument :math:`P \in E(K)` is present, returns the global
        Néron-Tate height :math:`h(P)` of the point, using the normalization in
        Cremona's :emphasis:`Algorithms for modular elliptic curves`.

        - If the argument :math:`Q \in E(K)` is also present, computes the value of
        the bilinear form :math:`(h(P+Q)-h(P-Q)) / 4`.
        '''
        cdef bint _have_P = (P is not None)
        if _have_P:
            P = objtogen(P)
        cdef bint _have_Q = (Q is not None)
        if _have_Q:
            Q = objtogen(Q)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = NULL
        if _have_P:
            _P = (<Gen>P).g
        cdef GEN _Q = NULL
        if _have_Q:
            _Q = (<Gen>Q).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellheight0(_E, _P, _Q, precision)
        return new_gen(_ret)

    def ellheightmatrix(E, x, long precision=DEFAULT_BITPREC):
        r'''
        :math:`x` being a vector of points, this
        function outputs the Gram matrix of :math:`x` with respect to the Néron-Tate
        height, in other words, the :math:`(i,j)` component of the matrix is equal to
        :literal:`ellheight(:math:`E`,x[:math:`i`],x[:math:`j`])`. The rank of this matrix, at least in some
        approximate sense, gives the rank of the set of points, and if :math:`x` is a
        basis of the Mordell-Weil group of :math:`E`, its determinant is equal to
        the regulator of :math:`E`. Note our height normalization follows Cremona's
        :emphasis:`Algorithms for modular elliptic curves`: this matrix should be divided
        by 2 to be in accordance with, e.g., Silverman's normalizations.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellheightmatrix(_E, _x, precision)
        return new_gen(_ret)

    def ellidentify(E):
        r'''
        Look up the elliptic curve :math:`E`, defined by an arbitrary model over :math:`\mathbb{Q}`,
        in the :literal:`elldata` database.
        Return :literal:`[[N, M, G], C]` where :math:`N` is the curve name in Cremona's
        elliptic curve database, :math:`M` is the minimal model, :math:`G` is a :math:`\mathbb{Z}`-basis of
        the free part of the Mordell-Weil group :math:`E(\mathbb{Q})` and :math:`C` is the
        change of coordinates from :math:`E` to :math:`M`, suitable for :literal:`ellchangecurve`.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellidentify(_E)
        return new_gen(_ret)

    def ellinit(x, D=None, long precision=DEFAULT_BITPREC):
        r'''
        Initialize an :literal:`ell` structure, attached to the elliptic curve :math:`E`.
        :math:`E` is either

        - a :math:`5`-component vector :math:`[a_{1},a_{2},a_{3},a_{4},a_{6}]` defining the elliptic
        curve with Weierstrass equation
        

        .. MATH::

        Y^{2} + a_{1} XY + a_{3} Y = X^{3} + a_{2} X^{2} + a_{4} X + a_{6},

        - a :math:`2`-component vector :math:`[a_{4},a_{6}]` defining the elliptic
        curve with short Weierstrass equation
        

        .. MATH::

        Y^{2} = X^{3} + a_{4} X + a_{6},

        - a single-component vector :math:`[j]` giving the :math:`j`-invariant for the curve,
        with the same coefficients as given by :literal:`ellfromj`.

        - a character string in Cremona's notation, e.g. :literal:`"11a1"`, in which
        case the curve is retrieved from the :literal:`elldata` database if available.

        The optional argument :math:`D` describes the domain over which the curve is
        defined:

        - the :literal:`t_INT` :math:`1` (default): the field of rational numbers :math:`\mathbb{Q}`.

        - a :literal:`t_INT` :math:`p`, where :math:`p` is a prime number: the prime finite field
        :math:`\mathbb{F}_{p}`.

        - an :literal:`t_INTMOD` :literal:`Mod(a, p)`, where :math:`p` is a prime number: the
        prime finite field :math:`\mathbb{F}_{p}`.

        - a :literal:`t_FFELT`, as returned by :literal:`ffgen`: the corresponding finite
        field :math:`\mathbb{F}_{q}`.

        - a :literal:`t_PADIC`, :math:`O(p^{n})`: the field :math:`\mathbb{Q}_{p}`, where :math:`p`-adic quantities
        will be computed to a relative accuracy of :math:`n` digits. We advise to input a
        model defined over :math:`\mathbb{Q}` for such curves. In any case, if you input an
        approximate model with :literal:`t_PADIC` coefficients, it will be replaced by a lift
        to :math:`\mathbb{Q}` (an exact model "close" to the one that was input) and all quantities
        will then be computed in terms of this lifted model, at the given accuracy.

        - a :literal:`t_REAL` :math:`x`: the field :math:`\mathbb{C}` of complex numbers, where floating
        point quantities are by default computed to a relative accuracy of
        :literal:`precision`:math:`(x)`. If no such argument is given, the value of
        :literal:`realprecision` at the time :literal:`ellinit` is called will be used.

        - a number field :math:`K`, given by a :literal:`nf` or :literal:`bnf` structure; a
        :literal:`bnf` is required for :literal:`ellminimalmodel`.

        - a prime ideal :math:`p`, given by a :literal:`prid` structure; valid if
        :math:`x` is a curve defined over a number field :math:`K` and the equation is integral
        and minimal at :math:`p`.

        This argument :math:`D` is indicative: the curve coefficients are checked for
        compatibility, possibly changing :math:`D`; for instance if :math:`D = 1` and
        an :literal:`t_INTMOD` is found. If inconsistencies are detected, an error is
        raised:

        ::

        ? ellinit([1 + O(5), 1], O(7));
        *** at top-level: ellinit([1+O(5),1],O
        *** ^--------------------
        *** ellinit: inconsistent moduli in ellinit: 7 != 5

        If the curve coefficients are too general to fit any of the
        above domain categories, only basic operations, such as point addition, will
        be supported later.

        If the curve (seen over the domain :math:`D`) is singular, fail and return an
        empty vector :math:`[]`.

        ::

        ? E = ellinit([0,0,0,0,1]); \\ y^2 = x^3 + 1, over Q
        ? E = ellinit([0,1]); \\ the same curve, short form
        ? E = ellinit("36a1"); \\ sill the same curve, Cremona's notations
        ? E = ellinit([0]); \\ a curve of j-invariant 0
        ? E = ellinit([0,1], 2) \\ over F2: singular curve
        %4 = []
        ? E = ellinit(['a4,'a6] * Mod(1,5)); \\ over F_5[a4,a6], basic support !

        Note that the given curve of :math:`j`-invariant :math:`0` happens
        to be :literal:`36a1` but a priori any model for an arbitrary twist could have
        been returned. See :literal:`ellfromj`.

        The result of :literal:`ellinit` is an :emphasis:`ell` structure. It contains at least
        the following information in its components:

        .. MATH::

        a_{1},a_{2},a_{3},a_{4},a_{6},b_{2},b_{4},b_{6},b_{8},c_{4},c_{6},
        \Delta,j.

        All are accessible via member functions. In particular, the discriminant is
        :literal:`:math:`E`.disc`, and the :math:`j`-invariant is :literal:`:math:`E`.j`.

        ::

        ? E = ellinit([a4, a6]);
        ? E.disc
        %2 = -64*a4^3 - 432*a6^2
        ? E.j
        %3 = -6912*a4^3/(-4*a4^3 - 27*a6^2)

        Further components contain domain-specific data, which are in general dynamic:
        only computed when needed, and then cached in the structure.

        ::

        ? E = ellinit([2,3], 10^60+7); \\ E over F_p, p large
        ? ellap(E)
        time = 4,440 ms.
        %2 = -1376268269510579884904540406082
        ? ellcard(E); \\ now instantaneous !
        time = 0 ms.
        ? ellgenerators(E);
        time = 5,965 ms.
        ? ellgenerators(E); \\ second time instantaneous
        time = 0 ms.

        See the description of member functions related to elliptic curves at the
        beginning of this section.
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellinit(_x, _D, precision)
        return new_gen(_ret)

    def ellintegralmodel(E, v=None):
        r'''
        Let :math:`E` be an :literal:`ell` structure over a number field :math:`K` or :math:`\mathbb{Q}_{p}`.
        This function returns an integral model. If :math:`v` is present, sets
        :math:`v = [u,0,0,0]` to the corresponding change of variable: the return value is
        identical to that of :literal:`ellchangecurve(E, v)`.

        ::

        ? e = ellinit([1/17,1/42]);
        ? e = ellintegralmodel(e,&v);
        ? e[1..5]
        %3 = [0, 0, 0, 15287762448, 3154568630095008]
        ? v
        %4 = [1/714, 0, 0, 0]
        '''
        cdef bint _have_v = (v is not None)
        if _have_v:
            raise NotImplementedError("optional argument v not available")
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN * _v = NULL
        cdef GEN _ret = ellintegralmodel(_E, _v)
        return new_gen(_ret)

    def elliscm(E):
        r'''
        Let :math:`E` an elliptic curve over a number field.
        Return :math:`0` if :math:`E` is not CM, otherwise return the discriminant of its
        endomorphism ring.

        ::

        ? E = ellinit([0,0,-5,-750,7900]);
        ? D = elliscm(E)
        %2 = -27
        ? w = quadgen(D, 'w);
        ? P = ellheegner(E)
        %4 = [10,40]
        ? Q = ellmul(E,P,w)
        %5 = [110/7-5/49*w,85/49-225/343*w]

        An example over a number field:

        ::

        ? nf=nfinit(a^2-5);
        ? E = ellinit([261526980*a-584793000,-3440201839360*a+7692525148000],nf);
        ? elliscm(E)
        %3 = -20
        ? ellisomat(E)[2]
        %4 = [1,2,5,10;2,1,10,5;5,10,1,2;10,5,2,1]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef long _ret = elliscm(_E)
        clear_stack()
        return _ret

    def ellisdivisible(E, P, n, Q=None):
        r'''
        Given :math:`E/K` a number field and :math:`P` in :math:`E(K)`
        return :math:`1` if :math:`P = [n]R` for some :math:`R` in :math:`E(K)` and set :math:`Q` to one such :math:`R`;
        and return :math:`0` otherwise.

        ::

        ? K = nfinit(polcyclo(11,t));
        ? E = ellinit([0,-1,1,0,0], K);
        ? P = [0,0];
        ? ellorder(E,P)
        %4 = 5
        ? ellisdivisible(E,P,5, &Q)
        %5 = 1
        ? lift(Q)
        %6 = [-t^7-t^6-t^5-t^4+1, -t^9-2*t^8-2*t^7-3*t^6-3*t^5-2*t^4-2*t^3-t^2-1]
        ? ellorder(E, Q)
        %7 = 25

        We use a fast multimodular algorithm over :math:`\mathbb{Q}` whose
        complexity is essentially independent of :math:`n` (polynomial in :math:`\log n`).
        Over number fields, we compute roots of division polynomials and the
        algebraic complexity of the underlying algorithm is in :math:`O(p^{4})`, where :math:`p` is
        the largest prime divisor of :math:`n`. The integer :math:`n >= 0` may be given as
        :literal:`ellxn(E,n)`, if many points need to be tested; this provides a modest
        speedup over number fields but is likely to slow down the algorithm over
        :math:`\mathbb{Q}`.
        '''
        P = objtogen(P)
        n = objtogen(n)
        cdef bint _have_Q = (Q is not None)
        if _have_Q:
            raise NotImplementedError("optional argument Q not available")
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN * _Q = NULL
        cdef long _ret = ellisdivisible(_E, _P, _n, _Q)
        clear_stack()
        return _ret

    def ellisisom(E, F):
        r'''
        Return :math:`0` if the elliptic curves :math:`E` and :math:`F` defined over the same number
        field are not isomorphic, otherwise return :literal:`[u,r,s,t]` suitable for
        :literal:`ellchangecurve`, mapping :math:`E` to :math:`F`.

        ::

        ? E = ellinit([1,2]);
        ? ellisisom(E, ellinit([1,3]))
        %2 = 0
        ? F = ellchangecurve(E, [-1,1,3,2]);
        ? ellisisom(E,F)
        %4 = [1, 1, -3, -2]

        ::

        ? nf = nfinit(a^3-2); E = ellinit([a^2+1,2*a-5], nf);
        ? F = ellchangecurve(E,Mod([a, a+1, a^2, a^2+a-3], nf.pol));
        ? v = ellisisom(E,F)
        %3 = [Mod(-a, a^3 - 2), Mod(a + 1, a^3 - 2), Mod(-a^2, a^3 - 2),
        Mod(-a^2 - a + 3, a^3 - 2)]
        ? ellchangecurve(E,v) == F
        %4 = 1
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = ellisisom(_E, _F)
        return new_gen(_ret)

    def ellisogeny(E, G, long only_image=0, x=None, y=None):
        r'''
        Given an elliptic curve :math:`E`, a finite subgroup :math:`G` of :math:`E` is given either
        as a generating point :math:`P` (for a cyclic :math:`G`) or as a polynomial whose roots
        vanish on the :math:`x`-coordinates of the nonzero elements of :math:`G` (general case
        and more efficient if available). This function returns the
        :math:`[a_{1},a_{2},a_{3},a_{4},a_{6}]` invariants of the quotient elliptic curve
        :math:`E/G` and (if :emphasis:`only_image` is zero (the default)) a vector of rational
        functions :math:`[f, g, h]` such that the isogeny :math:`E \to E/G` is given by :math:`(x,y)
        :---> (f(x)/h(x)^{2}, g(x,y)/h(x)^{3})`.

        ::

        ? E = ellinit([0,1]);
        ? elltors(E)
        %2 = [6, [6], [[2, 3]]]
        ? ellisogeny(E, [2,3], 1) \\ Weierstrass model for E/<P>
        %3 = [0, 0, 0, -135, -594]
        ? ellisogeny(E,[-1,0])
        %4 = [[0,0,0,-15,22], [x^3+2*x^2+4*x+3, y*x^3+3*y*x^2-2*y, x+1]]
        '''
        G = objtogen(G)
        cdef long _x = -1
        if x is not None:
            _x = get_var(x)
        cdef long _y = -1
        if y is not None:
            _y = get_var(y)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _G = (<Gen>G).g
        cdef GEN _ret = ellisogeny(_E, _G, only_image, _x, _y)
        return new_gen(_ret)

    def ellisogenyapply(f, g):
        r'''
        Given an isogeny of elliptic curves :math:`f:E'\to E` (being the result of a call
        to :literal:`ellisogeny`), apply :math:`f` to :math:`g`:

        - if :math:`g` is a point :math:`P` in the domain of :math:`f`, return the image :math:`f(P)`;

        - if :math:`g:E"\to E'` is a compatible isogeny, return the composite
        isogeny :math:`f o g: E"\to E`.

        ::

        ? one = ffgen(101, 't)^0;
        ? E = ellinit([6, 53, 85, 32, 34] * one);
        ? P = [84, 71] * one;
        ? ellorder(E, P)
        %4 = 5
        ? [F, f] = ellisogeny(E, P); \\ f: E->F = E/<P>
        ? ellisogenyapply(f, P)
        %6 = [0]
        ? F = ellinit(F);
        ? Q = [89, 44] * one;
        ? ellorder(F, Q)
        %9 = 2
        ? [G, g] = ellisogeny(F, Q); \\ g: F->G = F/<Q>
        ? gof = ellisogenyapply(g, f); \\ gof: E -> G
        '''
        g = objtogen(g)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _g = (<Gen>g).g
        cdef GEN _ret = ellisogenyapply(_f, _g)
        return new_gen(_ret)

    def ellisomat(E, long p=0, long flag=0):
        r'''
        Given an elliptic curve :math:`E` defined over a number field :math:`K`, computes
        representatives of the set of isomorphism classes of elliptic curves defined
        over :math:`K` and :math:`K`-isogenous to :math:`E`, assuming it is finite (see below).
        For any such curve :math:`E_{i}`, let :math:`f_{i}: E \to E_{i}` be a rational isogeny
        of minimal degree and let :math:`g_{i}: E_{i} \to E` be the dual isogeny; and let
        :math:`M` be the matrix such that :math:`M_{i,j}` is the minimal degree for an isogeny
        :math:`E_{i} \to E_{j}`.

        The function returns a vector :math:`[L,M]` where :math:`L` is a list of triples
        :math:`[E_{i}, f_{i}, g_{i}]` (:math:`flag = 0`), or simply the list of :math:`E_{i}` (:math:`flag = 1`,
        which saves time). The curves :math:`E_{i}` are given in :math:`[a_{4},a_{6}]` form and
        the first curve :math:`E_{1}` is isomorphic to :math:`E` by :math:`f_{1}`.

        The set of isomorphism classes is finite except when :math:`E` has CM over a
        quadratic order contained in :math:`K`. In that case the function only returns the
        discriminant of the quadratic order.

        If :math:`p` is set, it must be a prime number; in this which case only isogenies of
        degree a power of :math:`p` are considered.

        Over a number field, the possible isogeny degrees are determined by
        Billerey's algorithm.

        ::

        ? E = ellinit("14a1");
        ? [L,M] = ellisomat(E);
        ? LE = apply(x->x[1], L) \\ list of curves
        %3 = [[215/48,-5291/864],[-675/16,6831/32],[-8185/48,-742643/864],
        [-1705/48,-57707/864],[-13635/16,306207/32],[-131065/48,-47449331/864]]
        ? L[2][2] \\ isogeny f_2
        %4 = [x^3+3/4*x^2+19/2*x-311/12,
        1/2*x^4+(y+1)*x^3+(y-4)*x^2+(-9*y+23)*x+(55*y+55/2),x+1/3]
        ? L[2][3] \\ dual isogeny g_2
        %5 = [1/9*x^3-1/4*x^2-141/16*x+5613/64,
        -1/18*x^4+(1/27*y-1/3)*x^3+(-1/12*y+87/16)*x^2+(49/16*y-48)*x
        +(-3601/64*y+16947/512),x-3/4]
        ? apply(E->ellidentify(ellinit(E))[1][1], LE)
        %6 = ["14a1","14a4","14a3","14a2","14a6","14a5"]
        ? M
        %7 =
        [1 3 3 2 6 6]
        
        [3 1 9 6 2 18]
        
        [3 9 1 6 18 2]
        
        [2 6 6 1 3 3]
        
        [6 2 18 3 1 9]
        
        [6 18 2 3 9 1]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellisomat(_E, p, flag)
        return new_gen(_ret)

    def ellisoncurve(E, z):
        r'''
        Gives 1 (i.e. true) if the point :math:`z` is on the elliptic curve :math:`E`, 0
        otherwise. If :math:`E` or :math:`z` have imprecise coefficients, an attempt is made to
        take this into account, i.e. an imprecise equality is checked, not a precise
        one. It is allowed for :math:`z` to be a vector of points in which case a vector
        (of the same type) is returned.
        '''
        z = objtogen(z)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z = (<Gen>z).g
        cdef GEN _ret = ellisoncurve(_E, _z)
        return new_gen(_ret)

    def ellisotree(E):
        r'''
        Given an elliptic curve :math:`E` defined over :math:`\mathbb{Q}` or a set of
        :math:`\mathbb{Q}`-isogenous curves as given by :literal:`ellisomat`, return a pair :math:`[L,M]` where

        - :math:`L` lists the minimal models of the isomorphism classes of elliptic
        curves :math:`\mathbb{Q}`-isogenous to :math:`E` (or in the set of isogenous curves),

        - :math:`M` is the adjacency matrix of the prime degree isogenies tree:
        there is an edge from :math:`E_{i}` to :math:`E_{j}` if there is an isogeny :math:`E_{i} \to
        E_{j}` of prime degree such that the Néron differential forms are
        preserved.

        ::

        ? E = ellinit("14a1");
        ? [L,M] = ellisotree(E);
        ? M
        %3 =
        [0 0 3 2 0 0]
        
        [3 0 0 0 2 0]
        
        [0 0 0 0 0 2]
        
        [0 0 0 0 0 3]
        
        [0 0 0 3 0 0]
        
        [0 0 0 0 0 0]
        ? [L2,M2] = ellisotree(ellisomat(E,2,1));
        %4 =
        [0 2]
        
        [0 0]
        ? [L3,M3] = ellisotree(ellisomat(E,3,1));
        ? M3
        %6 =
        [0 0 3]
        
        [3 0 0]
        
        [0 0 0]

        Compare with the result of :literal:`ellisomat`.

        ::

        ? [L,M]=ellisomat(E,,1);
        ? M
        %7 =
        [1 3 3 2 6 6]
        
        [3 1 9 6 2 18]
        
        [3 9 1 6 18 2]
        
        [2 6 6 1 3 3]
        
        [6 2 18 3 1 9]
        
        [6 18 2 3 9 1]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellisotree(_E)
        return new_gen(_ret)

    def ellissupersingular(E, p=None):
        r'''
        Return 1 if the elliptic curve :math:`E` defined over a number field, :math:`\mathbb{Q}_{p}`
        or a finite field is supersingular at :math:`p`, and :math:`0` otherwise.
        If the curve is defined over :math:`\mathbb{Q}` or a number field, :math:`p` must be explicitly
        given, and must be a prime number, resp. a maximal ideal; we return :math:`1` if and
        only if :math:`E` has supersingular good reduction at :math:`p`.

        Alternatively, :math:`E` can be given by its :math:`j`-invariant in a finite field. In
        this case :math:`p` must be omitted.

        ::

        ? g = ffprimroot(ffgen(7^5))
        %1 = 4*x^4+5*x^3+6*x^2+5*x+6
        ? [g^n | n <- [1 .. 7^5 - 1], ellissupersingular(g^n)]
        %2 = [6]
        ? j = ellsupersingularj(2^31-1)
        %3 = 1618591527*w+1497042960
        ? ellissupersingular(j)
        %4 = 1
        
        ? K = nfinit(y^3-2); P = idealprimedec(K, 2)[1];
        ? E = ellinit([y,1], K);
        ? ellissupersingular(E, P)
        %7 = 1
        ? Q = idealprimedec(K,5)[1];
        ? ellissupersingular(E, Q)
        %9 = 0
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef int _ret = ellissupersingular(_E, _p)
        clear_stack()
        return _ret

    def ellj(x, long precision=DEFAULT_BITPREC):
        r'''
        Elliptic :math:`j`-invariant. :math:`x` must be a complex number
        with positive imaginary part, or convertible into a power series or a
        :math:`p`-adic number with positive valuation.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = jell(_x, precision)
        return new_gen(_ret)

    def elllocalred(E, p=None):
        r'''
        Calculates the Kodaira type of the local fiber of the elliptic curve
        :math:`E` at :math:`p`. :math:`E` must be an :literal:`ell` structure as output by
        :literal:`ellinit`, over :math:`\mathbb{Q}_{\ell}` (:math:`p` better left omitted, else equal to :math:`\ell`)
        over :math:`\mathbb{Q}` (:math:`p` a rational prime) or a number field :math:`K` (:math:`p`
        a maximal ideal given by a :literal:`prid` structure).
        The result is a 4-component vector :math:`[f,kod,v,c]`. Here :math:`f` is the exponent of
        :math:`p` in the arithmetic conductor of :math:`E`, and :math:`kod` is the Kodaira type which
        is coded as follows:

        1 means good reduction (type I:math:`_{0}`), 2, 3 and 4 mean types II, III and IV
        respectively, :math:`4+\nu` with :math:`\nu > 0` means type I:math:`_{\nu}`;
        finally the opposite values :math:`-1`, :math:`-2`, etc. refer to the starred types
        I:math:`_{0}^{*}`, II:math:`^{*}`, etc. The third component :math:`v` is itself a vector :math:`[u,r,s,t]`
        giving the coordinate changes done during the local reduction;
        :math:`u = 1` if and only if the given equation was already minimal at :math:`p`.
        Finally, the last component :math:`c` is the local Tamagawa number :math:`c_{p}`.
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = elllocalred(_E, _p)
        return new_gen(_ret)

    def elllog(E, P, G, o=None):
        r'''
        Given two points :math:`P` and :math:`G` on the elliptic curve :math:`E/\mathbb{F}_{q}`, returns the
        discrete logarithm of :math:`P` in base :math:`G`, i.e. the smallest nonnegative
        integer :math:`n` such that :math:`P = [n]G`.
        See :literal:`znlog` for the limitations of the underlying discrete log algorithms.
        If present, :math:`o` represents the order of :math:`G`, see ``DLfun`` (in the PARI manual);
        the preferred format for this parameter is :literal:`[N, factor(N)]`, where :math:`N`
        is the order of :math:`G`.

        If no :math:`o` is given, assume that :math:`G` generates the curve.
        The function also assumes that :math:`P` is a multiple of :math:`G`.

        ::

        ? a = ffgen(ffinit(2,8),'a);
        ? E = ellinit([a,1,0,0,1]); \\ over F_{2^8}
        ? x = a^3; y = ellordinate(E,x)[1];
        ? P = [x,y]; G = ellmul(E, P, 113);
        ? ord = [242, factor(242)]; \\ P generates a group of order 242. Initialize.
        ? ellorder(E, G, ord)
        %4 = 242
        ? e = elllog(E, P, G, ord)
        %5 = 15
        ? ellmul(E,G,e) == P
        %6 = 1
        '''
        P = objtogen(P)
        G = objtogen(G)
        cdef bint _have_o = (o is not None)
        if _have_o:
            o = objtogen(o)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _G = (<Gen>G).g
        cdef GEN _o = NULL
        if _have_o:
            _o = (<Gen>o).g
        cdef GEN _ret = elllog(_E, _P, _G, _o)
        return new_gen(_ret)

    def elllseries(E, s, A=None, long precision=DEFAULT_BITPREC):
        r'''
        This function is deprecated, use :literal:`lfun(E,s)` instead.

        :math:`E` being an elliptic curve, given by an arbitrary model over :math:`\mathbb{Q}` as output
        by :literal:`ellinit`, this function computes the value of the :math:`L`-series of :math:`E` at
        the (complex) point :math:`s`. This function uses an :math:`O(N^{1/2})` algorithm, where
        :math:`N` is the conductor.

        The optional parameter :math:`A` fixes a cutoff point for the integral and is best
        left omitted; the result must be independent of :math:`A`, up to
        :literal:`realprecision`, so this allows to check the function's accuracy.
        '''
        from warnings import warn
        warn('the PARI/GP function elllseries is obsolete (2016-08-08)', DeprecationWarning)
        s = objtogen(s)
        cdef bint _have_A = (A is not None)
        if _have_A:
            A = objtogen(A)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _A = NULL
        if _have_A:
            _A = (<Gen>A).g
        precision = nbits2prec(precision)
        cdef GEN _ret = elllseries(_E, _s, _A, precision)
        return new_gen(_ret)

    def ellmaninconstant(E):
        r'''
        Let :math:`E` be an elliptic curve over :math:`Q` given by
        :literal:`ellinit` or a rational isogeny class given by ellisomat. Return the
        Manin constant of the curve, see :literal:`ellweilcurve`.
        The algorithm is slow but unconditional.
        The function also accepts the output of :literal:`ellisomat` and returns the list
        of Manin constants for all the isogeny class.

        ::

        ? E = ellinit("11a3");
        ? ellmaninconstant(E)
        %2 = 5
        ? L=ellisomat(E,,1);
        ? ellmaninconstant(L)
        %4 = [5,1,1]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellmaninconstant(_E)
        return new_gen(_ret)

    def ellminimaldisc(E):
        r'''
        :math:`E` being an elliptic curve defined over a number field output by
        :literal:`ellinit`, return the minimal discriminant ideal of E.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellminimaldisc(_E)
        return new_gen(_ret)

    def ellminimalmodel(E, v=None):
        r'''
        Let :math:`E` be an :literal:`ell` structure over a number field :math:`K`. This function
        determines whether :math:`E` admits a global minimal integral model. If so, it
        returns it and sets :math:`v = [u,r,s,t]` to the corresponding change of variable:
        the return value is identical to that of :literal:`ellchangecurve(E, v)`.

        Else return the (nonprincipal) Weierstrass class of :math:`E`, i.e. the class of
        :math:`\prod p^{(v_{p}{\Delta} - \delta_{p}) / 12}` where
        :math:`\Delta = E.disc` is the model's discriminant and
        :math:`p^{\delta_{p}}` is the local minimal discriminant.
        This function requires either that :math:`E` be defined
        over the rational field :math:`\mathbb{Q}` (with domain :math:`D = 1` in :literal:`ellinit`),
        in which case a global minimal model always exists, or over a number
        field given by a :emphasis:`bnf` structure. The Weierstrass class is given in
        :literal:`bnfisprincipal` format, i.e. in terms of the :literal:`K.gen` generators.

        The resulting model has integral coefficients and is everywhere minimal, the
        coefficients :math:`a_{1}` and :math:`a_{3}` are reduced modulo :math:`2` (in terms of the fixed
        integral basis :literal:`K.zk`) and :math:`a_{2}` is reduced modulo :math:`3`. Over :math:`\mathbb{Q}`, we
        further require that :math:`a_{1}` and :math:`a_{3}` be :math:`0` or :math:`1`, that :math:`a_{2}`
        be :math:`0` or :math:`± 1` and that :math:`u > 0` in the change of variable: both the model
        and the change of variable :math:`v` are then unique.

        ::

        ? e = ellinit([6,6,12,55,233]); \\ over Q
        ? E = ellminimalmodel(e, &v);
        ? E[1..5]
        %3 = [0, 0, 0, 1, 1]
        ? v
        %4 = [2, -5, -3, 9]

        ::

        ? K = bnfinit(a^2-65); \\ over a nonprincipal number field
        ? K.cyc
        %2 = [2]
        ? u = Mod(8+a, K.pol);
        ? E = ellinit([1,40*u+1,0,25*u^2,0], K);
        ? ellminimalmodel(E) \\ no global minimal model exists over Z_K
        %6 = [1]~
        '''
        cdef bint _have_v = (v is not None)
        if _have_v:
            raise NotImplementedError("optional argument v not available")
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN * _v = NULL
        cdef GEN _ret = ellminimalmodel(_E, _v)
        return new_gen(_ret)

    def ellminimaltwist(E, long flag=0):
        r'''
        Let :math:`E` be an elliptic curve defined over :math:`\mathbb{Q}`, return
        a discriminant :math:`D` such that the twist of :math:`E` by :math:`D` is minimal among all
        possible quadratic twists, i.e. if :math:`flag = 0`, its minimal model has minimal
        discriminant, or if :math:`flag = 1`, it has minimal conductor.

        In the example below, we find a curve with :math:`j`-invariant :math:`3` and minimal
        conductor.

        ::

        ? E = ellminimalmodel(ellinit(ellfromj(3)));
        ? ellglobalred(E)[1]
        %2 = 357075
        ? D = ellminimaltwist(E,1)
        %3 = -15
        ? E2 = ellminimalmodel(elltwist(E,D));
        ? ellglobalred(E2)[1]
        %5 = 14283

        In the example below, :math:`flag = 0` and :math:`flag = 1` give different results.

        ::

        ? E = ellinit([1,0]);
        ? D0 = ellminimaltwist(E,0)
        %7 = 1
        ? D1 = ellminimaltwist(E,1)
        %8 = 8
        ? E0 = ellminimalmodel(elltwist(E,D0));
        ? [E0.disc, ellglobalred(E0)[1]]
        %10 = [-64, 64]
        ? E1 = ellminimalmodel(elltwist(E,D1));
        ? [E1.disc, ellglobalred(E1)[1]]
        %12 = [-4096, 32]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellminimaltwist0(_E, flag)
        return new_gen(_ret)

    def ellmoddegree(e):
        r'''
        :math:`e` being an elliptic curve defined over :math:`\mathbb{Q}` output by :literal:`ellinit`,
        compute the modular degree of :math:`e` divided by the square of
        the Manin constant :math:`c`. It is conjectured that :math:`c = 1` for the strong Weil
        curve in the isogeny class (optimal quotient of :math:`J_{0}(N)`) and this can be
        proven using :literal:`ellweilcurve` when the conductor :math:`N` is moderate.

        ::

        ? E = ellinit("11a1"); \\ from Cremona table: strong Weil curve and c = 1
        ? [v,smith] = ellweilcurve(E); smith \\ proof of the above
        %2 = [[1, 1], [5, 1], [1, 1/5]]
        ? ellmoddegree(E)
        %3 = 1
        ? [ellidentify(e)[1][1] | e<-v]
        %4 = ["11a1", "11a2", "11a3"]
        ? ellmoddegree(ellinit("11a2"))
        %5 = 5
        ? ellmoddegree(ellinit("11a3"))
        %6 = 1/5

        The modular degree of :literal:`11a1` is :math:`1` (because
        :literal:`ellweilcurve` or Cremona's table prove that the Manin constant
        is :math:`1` for this curve); the output of :literal:`ellweilcurve` also proves
        that the Manin constants of :literal:`11a2` and :literal:`11a3` are 1 and 5
        respectively, so the actual modular degree of both :literal:`11a2` and :literal:`11a3`
        is 5.
        '''
        sig_on()
        cdef GEN _e = (<Gen>e).g
        cdef GEN _ret = ellmoddegree(_e)
        return new_gen(_ret)

    def ellmul(E, z, n):
        r'''
        Computes :math:`[n]z`, where :math:`z` is a point on the elliptic curve :math:`E`. The
        exponent :math:`n` is in :math:`\mathbb{Z}`, or may be a complex quadratic integer if the curve :math:`E`
        has complex multiplication by :math:`n` (if not, an error message is issued).

        ::

        ? Ei = ellinit([1,0]); z = [0,0];
        ? ellmul(Ei, z, 10)
        %2 = [0] \\ unsurprising: z has order 2
        ? ellmul(Ei, z, I)
        %3 = [0, 0] \\ Ei has complex multiplication by Z[i]
        ? ellmul(Ei, z, quadgen(-4))
        %4 = [0, 0] \\ an alternative syntax for the same query
        ? Ej = ellinit([0,1]); z = [-1,0];
        ? ellmul(Ej, z, I)
        *** at top-level: ellmul(Ej,z,I)
        *** ^--------------
        *** ellmul: not a complex multiplication in ellmul.
        ? ellmul(Ej, z, 1+quadgen(-3))
        %6 = [1 - w, 0]

        The simple-minded algorithm for the CM case assumes that we are in
        characteristic :math:`0`, and that the quadratic order to which :math:`n` belongs has
        small discriminant.
        '''
        z = objtogen(z)
        n = objtogen(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z = (<Gen>z).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = ellmul(_E, _z, _n)
        return new_gen(_ret)

    def ellneg(E, z):
        r'''
        Opposite of the point :math:`z` on elliptic curve :math:`E`.
        '''
        z = objtogen(z)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z = (<Gen>z).g
        cdef GEN _ret = ellneg(_E, _z)
        return new_gen(_ret)

    def ellnonsingularmultiple(E, P):
        r'''
        Given an elliptic curve :math:`E/\mathbb{Q}` (more precisely, a model defined over :math:`\mathbb{Q}`
        of a curve) and a rational point :math:`P \in E(\mathbb{Q})`, returns the pair :math:`[R,n]`,
        where :math:`n` is the least positive integer such that :math:`R := [n]P` has good
        reduction at every prime. More precisely, its image in a minimal model is
        everywhere nonsingular.

        ::

        ? e = ellinit("57a1"); P = [2,-2];
        ? ellnonsingularmultiple(e, P)
        %2 = [[1, -1], 2]
        ? e = ellinit("396b2"); P = [35, -198];
        ? [R,n] = ellnonsingularmultiple(e, P);
        ? n
        %5 = 12
        '''
        P = objtogen(P)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = ellnonsingularmultiple(_E, _P)
        return new_gen(_ret)

    def ellorder(E, z, o=None):
        r'''
        Gives the order of the point :math:`z` on the elliptic
        curve :math:`E`, defined over a finite field or a number field.
        Return (the impossible value) zero if the point has infinite order.

        ::

        ? E = ellinit([-157^2,0]); \\ the "157-is-congruent" curve
        ? P = [2,2]; ellorder(E, P)
        %2 = 2
        ? P = ellheegner(E); ellorder(E, P) \\ infinite order
        %3 = 0
        ? K = nfinit(polcyclo(11,t)); E=ellinit("11a3", K); T = elltors(E);
        ? ellorder(E, T.gen[1])
        %5 = 25
        ? E = ellinit(ellfromj(ffgen(5^10)));
        ? ellcard(E)
        %7 = 9762580
        ? P = random(E); ellorder(E, P)
        %8 = 4881290
        ? p = 2^160+7; E = ellinit([1,2], p);
        ? N = ellcard(E)
        %9 = 1461501637330902918203686560289225285992592471152
        ? o = [N, factor(N)];
        ? for(i=1,100, ellorder(E,random(E)))
        time = 260 ms.

        The parameter :math:`o`, is now mostly useless, and kept for backward
        compatibility. If present, it represents a nonzero multiple of the order
        of :math:`z`, see ``DLfun`` (in the PARI manual); the preferred format for this parameter is
        :literal:`[ord, factor(ord)]`, where :literal:`ord` is the cardinality of the curve.
        It is no longer needed since PARI is now able to compute it over large
        finite fields (was restricted to small prime fields at the time this feature
        was introduced), :emphasis:`and` caches the result in :math:`E` so that it is computed
        and factored only once. Modifying the last example, we see that including
        this extra parameter provides no improvement:

        ::

        ? o = [N, factor(N)];
        ? for(i=1,100, ellorder(E,random(E),o))
        time = 260 ms.
        '''
        z = objtogen(z)
        cdef bint _have_o = (o is not None)
        if _have_o:
            o = objtogen(o)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z = (<Gen>z).g
        cdef GEN _o = NULL
        if _have_o:
            _o = (<Gen>o).g
        cdef GEN _ret = ellorder(_E, _z, _o)
        return new_gen(_ret)

    def ellordinate(E, x, long precision=DEFAULT_BITPREC):
        r'''
        Gives a 0, 1 or 2-component vector containing
        the :math:`y`-coordinates of the points of the curve :math:`E` having :math:`x` as
        :math:`x`-coordinate.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellordinate(_E, _x, precision)
        return new_gen(_ret)

    def ellpadicL(E, p, long n, s=None, long r=0, D=None):
        r'''
        Returns the value (or :math:`r`-th derivative) on a character :math:`\chi^{s}` of
        :math:`\mathbb{Z}_{p}^{*}` of the :math:`p`-adic :math:`L`-function of the elliptic curve :math:`E/\mathbb{Q}`, twisted by
        :math:`D`, given modulo :math:`p^{n}`.

        :strong:`Characters.` The set of continuous characters of
        :math:`Gal(\mathbb{Q} (\mu_{p^{ oo }})/ \mathbb{Q})` is identified to :math:`\mathbb{Z}_{p}^{*}` via the
        cyclotomic character :math:`\chi` with values in :math:`\overline{\mathbb{Q}_{p}}^{*}`. Denote by
        :math:`\tau:\mathbb{Z}_{p}^{*}\to\mathbb{Z}_{p}^{*}` the Teichmüller character, with values
        in the :math:`(p-1)`-th roots of :math:`1` for :math:`p ! = 2`, and :math:`{-1,1}` for :math:`p = 2`;
        finally, let
        :math:`<\chi>= \chi \tau^{-1}`, with values in :math:`1 + 2p\mathbb{Z}_{p}`.
        In GP, the continuous character of
        :math:`Gal(\mathbb{Q} (\mu_{p^{ oo }})/ \mathbb{Q})` given by :math:`<\chi>^{s_{1}}
        \tau^{s_{2}}` is represented by the pair of integers :math:`s = (s_{1},s_{2})`,
        with :math:`s_{1} \in \mathbb{Z}_{p}` and :math:`s_{2} mod p-1` for :math:`p > 2`,
        (resp. mod :math:`2` for :math:`p = 2`); :math:`s`
        may be also an integer, representing :math:`(s,s)` or :math:`\chi^{s}`.

        :strong:`The :math:`p`-adic :math:`L` function.`
        The :math:`p`-adic :math:`L` function :math:`L_{p}` is defined on the set of continuous
        characters of :math:`Gal(\mathbb{Q} (\mu_{p^{ oo }})/ \mathbb{Q})`, as :math:`\int_{\mathbb{Z}_{p}^{*}}
        \chi^{s} d \mu` for a certain :math:`p`-adic distribution :math:`\mu` on :math:`\mathbb{Z}_{p}^{*}`. The
        derivative is given by

        .. MATH::

        L_{p}^{(r)}(E, \chi^{s}) = \int_{\mathbb{Z}_{p}^{*}} \log_{p}^{r}(a) \chi^{s}(a)
        d\mu (a).

        More precisely:

        - When :math:`E` has good supersingular reduction, :math:`L_{p}` takes its
        values in :math:`D := H^{1}_{dR}(E/\mathbb{Q})\otimes_{\mathbb{Q}} \mathbb{Q}_{p}` and satisfies
        

        .. MATH::

        (1-p^{-1} F)^{-2} L_{p}(E, \chi^{0}) = (L(E,1) / \Omega).\omega

        where :math:`F` is the Frobenius, :math:`L(E,1)` is the value of the complex :math:`L`
        function at :math:`1`, :math:`\omega` is the Néron differential
        and :math:`\Omega` the attached period on :math:`E(\mathbb{R})`. Here, :math:`\chi^{0}` represents
        the trivial character.

        The function returns the components of :math:`L_{p}^{(r)}(E,\chi^{s})` in
        the basis :math:`(\omega, F \omega)`.

        - When :math:`E` has ordinary good reduction, this method only defines
        the projection of :math:`L_{p}(E,\chi^{s})` on the :math:`\alpha`-eigenspace,
        where :math:`\alpha` is the unit eigenvalue for :math:`F`. This is what the function
        returns. We have
        

        .. MATH::

        (1- \alpha^{-1})^{-2} L_{p,\alpha}(E,\chi^{0}) = L(E,1) / \Omega.

        Two supersingular examples:

        ::

        ? cxL(e) = bestappr( ellL1(e) / e.omega[1] );
        
        ? e = ellinit("17a1"); p=3; \\ supersingular, a3 = 0
        ? L = ellpadicL(e,p,4);
        ? F = [0,-p;1,ellap(e,p)]; \\ Frobenius matrix in the basis (omega,F(omega))
        ? (1-p^(-1)*F)^-2 * L / cxL(e)
        %5 = [1 + O(3^5), O(3^5)]~ \\ [1,0]~
        
        ? e = ellinit("116a1"); p=3; \\ supersingular, a3 != 0~
        ? L = ellpadicL(e,p,4);
        ? F = [0,-p; 1,ellap(e,p)];
        ? (1-p^(-1)*F)^-2*L~ / cxL(e)
        %9 = [1 + O(3^4), O(3^5)]~

        Good ordinary reduction:

        ::

        ? e = ellinit("17a1"); p=5; ap = ellap(e,p)
        %1 = -2 \\ ordinary
        ? L = ellpadicL(e,p,4)
        %2 = 4 + 3*5 + 4*5^2 + 2*5^3 + O(5^4)
        ? al = padicappr(x^2 - ap*x + p, ap + O(p^7))[1];
        ? (1-al^(-1))^(-2) * L / cxL(e)
        %4 = 1 + O(5^4)

        Twist and Teichmüller:

        ::

        ? e = ellinit("17a1"); p=5; \\ ordinary
        \\ 2nd derivative at tau^1, twist by -7
        ? ellpadicL(e, p, 4, [0,1], 2, -7)
        %2 = 2*5^2 + 5^3 + O(5^4)

        We give an example of non split multiplicative reduction (see
        :literal:`ellpadicbsd` for more examples).

        ::

        ? e=ellinit("15a1"); p=3; n=5;
        ? L = ellpadicL(e,p,n)
        %2 = 2 + 3 + 3^2 + 3^3 + 3^4 + O(3^5)
        ? (1 - ellap(e,p))^(-1) * L / cxL(e)
        %3 = 1 + O(3^5)

        This function is a special case of :literal:`mspadicL` and it also appears
        as the first term of :literal:`mspadicseries`:

        ::

        ? e = ellinit("17a1"); p=5;
        ? L = ellpadicL(e,p,4)
        %2 = 4 + 3*5 + 4*5^2 + 2*5^3 + O(5^4)
        ? [M,phi] = msfromell(e, 1);
        ? Mp = mspadicinit(M, p, 4);
        ? mu = mspadicmoments(Mp, phi);
        ? mspadicL(mu)
        %6 = 4 + 3*5 + 4*5^2 + 2*5^3 + 2*5^4 + 5^5 + O(5^6)
        ? mspadicseries(mu)
        %7 = (4 + 3*5 + 4*5^2 + 2*5^3 + 2*5^4 + 5^5 + O(5^6))
        + (3 + 3*5 + 5^2 + 5^3 + O(5^4))*x
        + (2 + 3*5 + 5^2 + O(5^3))*x^2
        + (3 + 4*5 + 4*5^2 + O(5^3))*x^3
        + (3 + 2*5 + O(5^2))*x^4 + O(x^5)

        These are more cumbersome than :literal:`ellpadicL` but allow to
        compute at different characters, or successive derivatives, or to
        twist by a quadratic character essentially for the cost of a single call to
        :literal:`ellpadicL` due to precomputations.
        '''
        p = objtogen(p)
        cdef bint _have_s = (s is not None)
        if _have_s:
            s = objtogen(s)
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _s = NULL
        if _have_s:
            _s = (<Gen>s).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = ellpadicL(_E, _p, n, _s, r, _D)
        return new_gen(_ret)

    def ellpadicbsd(E, p, long n, D=None):
        r'''
        Given an elliptic curve :math:`E` over :math:`\mathbb{Q}`, its quadratic twist :math:`E_{D}`
        and a prime number :math:`p`, this function is a :math:`p`-adic analog of the complex
        functions :literal:`ellanalyticrank` and :literal:`ellbsd`. It calls :literal:`ellpadicL`
        with initial accuracy :math:`p^{n}` and may increase it internally;
        it returns a vector :math:`[r, L_{p}]` where

        - :math:`L_{p}` is a :math:`p`-adic number (resp. a pair of :math:`p`-adic numbers if
        :math:`E` has good supersingular reduction) defined modulo :math:`p^{N}`, conjecturally
        equal to :math:`R_{p} S`, where :math:`R_{p}` is the :math:`p`-adic regulator as given by
        :literal:`ellpadicregulator` (in the basis :math:`(\omega, F \omega)`) and :math:`S` is the
        cardinal of the Tate-Shafarevich group for the quadratic twist :math:`E_{D}`.

        - :math:`r` is an upper bound for the analytic rank of the :math:`p`-adic
        :math:`L`-function attached to :math:`E_{D}`: we know for sure that the :math:`i`-th
        derivative of :math:`L_{p}(E_{D},.)` at :math:`\chi^{0}` is :math:`O(p^{N})` for all :math:`i < r`
        and that its :math:`r`-th derivative is nonzero; it is expected that the true
        analytic rank is equal to the rank of the Mordell-Weil group :math:`E_{D}(\mathbb{Q})`,
        plus :math:`1` if the reduction of :math:`E_{D}` at :math:`p` is split multiplicative;
        if :math:`r = 0`, then both the analytic rank and the Mordell-Weil rank are
        unconditionnally :math:`0`.

        Recall that the :math:`p`-adic BSD conjecture (Mazur, Tate, Teitelbaum, Bernardi,
        Perrin-Riou) predicts an explicit link between :math:`R_{p} S` and

        .. MATH::

        (1-p^{-1} F)^{-2}.L_{p}^{(r)}(E_{D}, \chi^{0}) / r!

        where :math:`r` is the analytic rank of the :math:`p`-adic :math:`L`-function attached to
        :math:`E_{D}` and :math:`F` is the Frobenius on :math:`H^{1}_{dR}`; see :literal:`ellpadicL`
        for definitions.

        ::

        ? E = ellinit("11a1"); p = 7; n = 5; \\ good ordinary
        ? ellpadicbsd(E, 7, 5) \\ rank 0,
        %2 = [0, 1 + O(7^5)]
        
        ? E = ellinit("91a1"); p = 7; n = 5; \\ non split multiplicative
        ? [r,Lp] = ellpadicbsd(E, p, n)
        %5 = [1, 2*7 + 6*7^2 + 3*7^3 + 7^4 + O(7^5)]
        ? R = ellpadicregulator(E, p, n, E.gen)
        %6 = 2*7 + 6*7^2 + 3*7^3 + 7^4 + 5*7^5 + O(7^6)
        ? sha = Lp/R
        %7 = 1 + O(7^4)
        
        ? E = ellinit("91b1"); p = 7; n = 5; \\ split multiplicative
        ? [r,Lp] = ellpadicbsd(E, p, n)
        %9 = [2, 2*7 + 7^2 + 5*7^3 + O(7^4)]
        ? ellpadicregulator(E, p, n, E.gen)
        %10 = 2*7 + 7^2 + 5*7^3 + 6*7^4 + 2*7^5 + O(7^6)
        ? [rC, LC] = ellanalyticrank(E);
        ? [r, rC]
        %12 = [2, 1] \\ r = rC+1 because of split multiplicative reduction
        
        ? E = ellinit("53a1"); p = 5; n = 5; \\ supersingular
        ? [r, Lp] = ellpadicbsd(E, p, n);
        ? r
        %15 = 1
        ? Lp
        %16 = [3*5 + 2*5^2 + 2*5^5 + O(5^6), \
        5 + 3*5^2 + 4*5^3 + 2*5^4 + 5^5 + O(5^6)]
        ? R = ellpadicregulator(E, p, n, E.gen)
        %17 = [3*5 + 2*5^2 + 2*5^5 + O(5^6), 5 + 3*5^2 + 4*5^3 + 2*5^4 + O(5^5)]
        \\ expect Lp = R*#Sha, hence (conjecturally) #Sha = 1
        
        ? E = ellinit("84a1"); p = 11; n = 6; D = -443;
        ? [r,Lp] = ellpadicbsd(E, 11, 6, D) \\ Mordell-Weil rank 0, no regulator
        %19 = [0, 3 + 2*11 + O(11^6)]
        ? lift(Lp) \\ expected cardinal for Sha is 5^2
        %20 = 25
        ? ellpadicbsd(E, 3, 12, D) \\ at 3
        %21 = [1, 1 + 2*3 + 2*3^2 + O(3^8)]
        ? ellpadicbsd(E, 7, 8, D) \\ and at 7
        %22 = [0, 4 + 3*7 + O(7^8)]
        '''
        p = objtogen(p)
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = ellpadicbsd(_E, _p, n, _D)
        return new_gen(_ret)

    def ellpadicfrobenius(E, unsigned long p, long n):
        r'''
        If :math:`p > 2` is a prime and :math:`E` is an elliptic curve on :math:`\mathbb{Q}` with good
        reduction at :math:`p`, return the matrix of the Frobenius endomorphism :math:`\varphi`
        on the crystalline module :math:`D_{p}(E) = \mathbb{Q}_{p} \otimes H^{1}_{dR}(E/\mathbb{Q})` with
        respect to the basis of the given model :math:`(\omega, \eta = x \omega)`, where
        :math:`\omega = dx/(2 y+a_{1} x+a_{3})` is the invariant differential.
        The characteristic polynomial of :math:`\varphi` is :math:`x^{2} - a_{p} x + p`.
        The matrix is computed to absolute :math:`p`-adic precision :math:`p^{n}`.

        ::

        ? E = ellinit([1,-1,1,0,0]);
        ? F = ellpadicfrobenius(E,5,3);
        ? lift(F)
        %3 =
        [120 29]
        
        [ 55 5]
        ? charpoly(F)
        %4 = x^2 + O(5^3)*x + (5 + O(5^3))
        ? ellap(E, 5)
        %5 = 0
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellpadicfrobenius(_E, p, n)
        return new_gen(_ret)

    def ellpadicheight(E, p, long n, P, Q=None):
        r'''
        Cyclotomic :math:`p`-adic height of the rational point :math:`P` on the elliptic curve
        :math:`E` (defined over :math:`\mathbb{Q}`), given to :math:`n` :math:`p`-adic digits.
        If the argument :math:`Q` is present, computes the value of the bilinear
        form :math:`(h(P+Q)-h(P-Q)) / 4`.

        Let :math:`D := H^{1}_{dR}(E) \otimes_{\mathbb{Q}} \mathbb{Q}_{p}` be the :math:`\mathbb{Q}_{p}` vector space
        spanned by :math:`\omega`
        (invariant differential :math:`dx/(2y+a_{1}x+a_{3})` related to the given model) and
        :math:`\eta = x \omega`. Then the cyclotomic :math:`p`-adic height :math:`h_{E}` associates to
        :math:`P\in E(\mathbb{Q})` an element :math:`f \omega + g \eta` in :math:`D`.
        This routine returns the vector :math:`[f, g]` to :math:`n` :math:`p`-adic digits.
        If :math:`P\in E(\mathbb{Q})` is in the kernel of reduction mod :math:`p` and if its reduction
        at all finite places is non singular, then :math:`g = -(\log_{E} P)^{2}`, where
        :math:`\log_{E}` is the logarithm for the formal group of :math:`E` at :math:`p`.

        If furthermore the model is of the form :math:`Y^{2} = X^{3} + a X + b`
        and :math:`P = (x,y)`, then

        .. MATH::

        f = \log_{p}(denominator (x)) - 2 \log_{p}(\sigma (P))

        where :math:`\sigma (P)` is given by :literal:`ellsigma`:math:`(E,P)`.

        Recall (:emphasis:`Advanced topics in the arithmetic of elliptic
        curves`, Theorem 3.2) that the local height function over the complex numbers
        is of the form

        .. MATH::

        \lambda (z) = -\log (\|E.disc\|) / 6 + \Re (z \eta (z)) - 2 \log (
        \sigma (z)).

        (N.B. our normalization for local and global heights is twice that of
        Silverman's).

        ::

        ? E = ellinit([1,-1,1,0,0]); P = [0,0];
        ? ellpadicheight(E,5,3, P)
        %2 = [3*5 + 5^2 + 2*5^3 + O(5^4), 5^2 + 4*5^4 + O(5^5)]
        ? E = ellinit("11a1"); P = [5,5]; \\ torsion point
        ? ellpadicheight(E,19,6, P)
        %4 = [0, 0]
        ? E = ellinit([0,0,1,-4,2]); P = [-2,1];
        ? ellpadicheight(E,3,3, P)
        %6 = [2*3^2 + 2*3^3 + 3^4 + O(3^5), 2*3^2 + 3^4 + O(3^5)]
        ? ellpadicheight(E,3,5, P, elladd(E,P,P))
        %7 = [3^2 + 2*3^3 + O(3^7), 3^2 + 3^3 + 2*3^4 + 3^5 + O(3^7)]

        - When :math:`E` has good ordinary reduction at :math:`p` or non split multiplicative
        reduction, the "canonical" :math:`p`-adic height is given by

        ::

        s2 = ellpadics2(E,p,n);
        ellpadicheight(E, p, n, P) * [1,-s2]~

        Since :math:`s_{2}` does not depend on :math:`P`, it is preferable to
        compute it only once:

        ::

        ? E = ellinit("5077a1"); p = 5; n = 7; \\ rank 3
        ? s2 = ellpadics2(E,p,n);
        ? M = ellpadicheightmatrix(E,p, n, E.gen) * [1,-s2]~;
        ? matdet(M) \\ p-adic regulator on the points in E.gen
        %4 = 5 + 5^2 + 4*5^3 + 2*5^4 + 2*5^5 + 2*5^6 + O(5^7)

        - When :math:`E` has split multiplicative reduction at :math:`p` (Tate curve),
        the "canonical" :math:`p`-adic height is given by

        ::

        Ep = ellinit(E[1..5], O(p^(n))); \\ E seen as a Tate curve over Qp
        [u2,u,q] = Ep.tate;
        ellpadicheight(E, p, n, P) * [1,-s2 + 1/log(q)/u2]]~

        where :math:`s_{2}` is as above. For example,

        ::

        ? E = ellinit("91b1"); P =[-1, 3]; p = 7; n = 5;
        ? Ep = ellinit(E[1..5], O(p^(n)));
        ? s2 = ellpadics2(E,p,n);
        ? [u2,u,q] = Ep.tate;
        ? H = ellpadicheight(E,p, n, P) * [1,-s2 + 1/log(q)/u2]~
        %5 = 2*7 + 7^2 + 5*7^3 + 6*7^4 + 2*7^5 + O(7^6)

        These normalizations are chosen so that :math:`p`-adic BSD conjectures
        are easy to state, see :literal:`ellpadicbsd`.
        '''
        p = objtogen(p)
        P = objtogen(P)
        cdef bint _have_Q = (Q is not None)
        if _have_Q:
            Q = objtogen(Q)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _Q = NULL
        if _have_Q:
            _Q = (<Gen>Q).g
        cdef GEN _ret = ellpadicheight0(_E, _p, n, _P, _Q)
        return new_gen(_ret)

    def ellpadicheightmatrix(E, p, long n, Q):
        r'''
        :math:`Q` being a vector of points, this function returns the "Gram matrix"
        :math:`[F,G]` of the cyclotomic :math:`p`-adic height :math:`h_{E}` with respect to
        the basis :math:`(\omega, \eta)` of :math:`D = H^{1}_{dR}(E) \otimes_{\mathbb{Q}} \mathbb{Q}_{p}`
        given to :math:`n` :math:`p`-adic digits. In other words, if
        :literal:`ellpadicheight`:math:`(E,p,n, Q[i],Q[j]) = [f,g]`, corresponding to
        :math:`f \omega + g \eta` in :math:`D`, then :math:`F[i,j] = f` and :math:`G[i,j] = g`.

        ::

        ? E = ellinit([0,0,1,-7,6]); Q = [[-2,3],[-1,3]]; p = 5; n = 5;
        ? [F,G] = ellpadicheightmatrix(E,p,n,Q);
        ? lift(F) \\ p-adic entries, integral approximation for readability
        %3 =
        [2364 3100]
        
        [3100 3119]
        
        ? G
        %4 =
        [25225 46975]
        
        [46975 61850]
        
        ? [F,G] * [1,-ellpadics2(E,p,n)]~
        %5 =
        [4 + 2*5 + 4*5^2 + 3*5^3 + O(5^5) 4*5^2 + 4*5^3 + 5^4 + O(5^5)]
        
        [ 4*5^2 + 4*5^3 + 5^4 + O(5^5) 4 + 3*5 + 4*5^2 + 4*5^3 + 5^4 + O(5^5)]
        '''
        p = objtogen(p)
        Q = objtogen(Q)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _ret = ellpadicheightmatrix(_E, _p, n, _Q)
        return new_gen(_ret)

    def ellpadiclambdamu(E, long p, long D=1, long i=0):
        r'''
        Let :math:`p` be a prime number and let :math:`E/\mathbb{Q}` be a rational elliptic curve
        with good or bad multiplicative reduction at :math:`p`.
        Return the Iwasawa invariants :math:`\lambda` and :math:`\mu` for the :math:`p`-adic :math:`L`
        function :math:`L_{p}(E)`, twisted by :math:`(D/.)` and the :math:`i`-th power of the
        Teichmüller character :math:`\tau`, see :literal:`ellpadicL` for details about
        :math:`L_{p}(E)`.

        Let :math:`\chi` be the cyclotomic character and choose :math:`\gamma`
        in :math:`Gal(\mathbb{Q}_{p}(\mu_{p^{ oo }})/\mathbb{Q}_{p})` such that :math:`\chi (\gamma) = 1+2p`.
        Let :math:`^{L}^{(i), D} \in \mathbb{Q}_{p}[[X]]\otimes D_{cris}` such that

        .. MATH::

        ( < \chi > ^{s} \tau^{i}) (^{L}^{(i), D}(\gamma-1))
        = L_{p}(E, < \chi > ^{s}\tau^{i} (D/.)).

        - When :math:`E` has good ordinary or bad multiplicative reduction at :math:`p`.
        By Weierstrass's preparation theorem the series :math:`^{L}^{(i), D}` can be
        written :math:`p^{\mu} (X^{\lambda} + p G(X))` up to a :math:`p`-adic unit, where
        :math:`G(X)\in \mathbb{Z}_{p}[X]`. The function returns :math:`[\lambda,\mu]`.

        - When :math:`E` has good supersingular reduction, we define a sequence
        of polynomials :math:`P_{n}` in :math:`\mathbb{Q}_{p}[X]` of degree :math:`< p^{n}` (and bounded
        denominators), such that
        

        .. MATH::

        ^{L}^{(i), D} = P_{n} \varphi^{n+1}\omega_{E} -
        \xi_{n} P_{n-1}\varphi^{n+2}\omega_{E} mod ((1+X)^{p^{n}}-1)
        \mathbb{Q}_{p}[X]\otimes D_{cris},

        where :math:`\xi_{n} = polcyclo (p^{n}, 1+X)`.
        Let :math:`\lambda_{n},\mu_{n}` be the invariants of :math:`P_{n}`. We find that

        - :math:`\mu_{n}` is nonnegative and decreasing for :math:`n` of given parity hence
        :math:`\mu_{2n}` tends to a limit :math:`\mu^{+}` and :math:`\mu_{2n+1}` tends to a limit
        :math:`\mu^{-}` (both conjecturally :math:`0`).

        - there exists integers :math:`\lambda^{+}`, :math:`\lambda^{-}`
        in :math:`\mathbb{Z}` (denoted with a :math:`~` in the reference below) such that
        

        .. MATH::

        \lim_{n\to oo } \lambda_{2n} + 1/(p+1) = \lambda^{+}
        and
        \lim_{n\to oo } \lambda_{2n+1} + p/(p+1) = \lambda^{-}.

        The function returns :math:`[[\lambda^{+}, \lambda^{-}], [\mu^{+},\mu^{-}]]`.

        Reference: B. Perrin-Riou, Arithmétique des courbes elliptiques
        à réduction supersinguli\\`ere en :math:`p`, :emphasis:`Experimental Mathematics`,
        :strong:`12`, 2003, pp. 155-186.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellpadiclambdamu(_E, p, D, i)
        return new_gen(_ret)

    def ellpadiclog(E, p, long n, P):
        r'''
        Given :math:`E` defined over :math:`K = \mathbb{Q}` or :math:`\mathbb{Q}_{p}` and :math:`P = [x,y]` on :math:`E(K)` in the
        kernel of reduction mod :math:`p`, let :math:`t(P) = -x/y` be the formal group
        parameter; this function returns :math:`L(t)` to relative :math:`p`-adic precision
        :math:`p^{n}`, where :math:`L` denotes the formal logarithm (mapping the formal group
        of :math:`E` to the additive formal group) attached to the canonical invariant
        differential: :math:`dL = dx/(2y + a_{1}x + a_{3})`.

        ::

        ? E = ellinit([0,0,1,-4,2]); P = [-2,1];
        ? ellpadiclog(E,2,10,P)
        %2 = 2 + 2^3 + 2^8 + 2^9 + 2^10 + O(2^11)
        ? E = ellinit([17,42]);
        ? p=3; Ep = ellinit(E,p); \\ E mod p
        ? P=[114,1218]; ellorder(Ep,P) \\ the order of P on (E mod p) is 2
        %5 = 2
        ? Q = ellmul(E,P,2) \\ we need a point of the form 2*P
        %6 = [200257/7056, 90637343/592704]
        ? ellpadiclog(E,3,10,Q)
        %7 = 3 + 2*3^2 + 3^3 + 3^4 + 3^5 + 3^6 + 2*3^8 + 3^9 + 2*3^10 + O(3^11)
        '''
        p = objtogen(p)
        P = objtogen(P)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = ellpadiclog(_E, _p, n, _P)
        return new_gen(_ret)

    def ellpadicregulator(E, p, long n, S):
        r'''
        Let :math:`E/\mathbb{Q}` be an elliptic curve. Return the determinant of the Gram
        matrix of the vector of points :math:`S = (S_{1},..., S_{r})` with respect to the
        "canonical" cyclotomic :math:`p`-adic height on :math:`E`, given to :math:`n` (:math:`p`-adic)
        digits.

        When :math:`E` has ordinary reduction at :math:`p`, this is the expected Gram
        deteterminant in :math:`\mathbb{Q}_{p}`.

        In the case of supersingular reduction of :math:`E` at :math:`p`, the definition
        requires care: the regulator :math:`R` is an element of
        :math:`D := H^{1}_{dR}(E) \otimes_{\mathbb{Q}} \mathbb{Q}_{p}`, which is a two-dimensional
        :math:`\mathbb{Q}_{p}`-vector space spanned by :math:`\omega` and :math:`\eta = x \omega`
        (which are defined over :math:`\mathbb{Q}`) or equivalently but now over :math:`\mathbb{Q}_{p}`
        by :math:`\omega` and :math:`F\omega` where :math:`F` is the Frobenius endomorphism on :math:`D`
        as defined in :literal:`ellpadicfrobenius`. On :math:`D` we
        define the cyclotomic height :math:`h_{E} = f \omega + g \eta`
        (see :literal:`ellpadicheight`) and a canonical alternating bilinear form
        :math:`[.,.]_{D}` such that :math:`[\omega, \eta]_{D} = 1`.

        For any :math:`\nu \in D`, we can define a height :math:`h_{\nu} := [ h_{E}, \nu ]_{D}`
        from :math:`E(\mathbb{Q})` to :math:`\mathbb{Q}_{p}` and :math:`<.,.>_{\nu}` the attached
        bilinear form. In particular, if :math:`h_{E} = f \omega + g\eta`, then
        :math:`h_{\eta} = [ h_{E}, \eta ]_{D}` = f and :math:`h_{\omega} = [ h_{E}, \omega ]_{D}
        = - g` hence :math:`h_{E} = h_{\eta} \omega - h_{\omega} \eta`.
        Then, :math:`R` is the unique element of :math:`D` such that

        .. MATH::

        [\omega,\nu]_{D}^{r-1} [R, \nu]_{D} = \det (< S_{i}, S_{j} >_{\nu})

        for all :math:`\nu \in D` not in :math:`\mathbb{Q}_{p} \omega`. The :literal:`ellpadicregulator`
        function returns :math:`R` in the basis :math:`(\omega, F\omega)`, which was chosen
        so that :math:`p`-adic BSD conjectures are easy to state, see :literal:`ellpadicbsd`.

        Note that by definition

        .. MATH::

        [R, \eta]_{D} = \det (< S_{i}, S_{j} >_{\eta})

        and

        .. MATH::

        [R, \omega+\eta]_{D} = \det (< S_{i}, S_{j} >_{\omega+\eta}).
        '''
        p = objtogen(p)
        S = objtogen(S)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _S = (<Gen>S).g
        cdef GEN _ret = ellpadicregulator(_E, _p, n, _S)
        return new_gen(_ret)

    def ellpadics2(E, p, long n):
        r'''
        If :math:`p > 2` is a prime and :math:`E/\mathbb{Q}` is an elliptic curve with ordinary good
        reduction at :math:`p`, returns the slope of the unit eigenvector
        of :literal:`ellpadicfrobenius(E,p,n)`, i.e., the action of Frobenius :math:`\varphi` on
        the crystalline module :math:`D_{p}(E) = \mathbb{Q}_{p} \otimes H^{1}_{dR}(E/\mathbb{Q})` in the basis of
        the given model :math:`(\omega, \eta = x \omega)`, where :math:`\omega` is the invariant
        differential :math:`dx/(2 y+a_{1} x+a_{3})`. In other words, :math:`\eta + s_{2}\omega`
        is an eigenvector for the unit eigenvalue of :math:`\varphi`.

        ::

        ? e=ellinit([17,42]);
        ? ellpadics2(e,13,4)
        %2 = 10 + 2*13 + 6*13^3 + O(13^4)

        This slope is the unique :math:`c \in 3^{-1}\mathbb{Z}_{p}` such that the odd solution
        :math:`\sigma (t) = t + O(t^{2})` of

        .. MATH::

        - d((1)/(\sigma) (d \sigma)/(\omega))
        = (x(t) + c) \omega

        is in :math:`t\mathbb{Z}_{p}[[t]]`.

        It is equal to :math:`b_{2}/12 - E_{2}/12` where :math:`E_{2}` is the value of the Katz
        :math:`p`-adic Eisenstein series of weight 2 on :math:`(E,\omega)`. This is
        used to construct a canonical :math:`p`-adic height when :math:`E` has good ordinary
        reduction at :math:`p` as follows

        ::

        s2 = ellpadics2(E,p,n);
        h(E,p,n, P, s2) = ellpadicheight(E, [p,[1,-s2]],n, P);

        Since :math:`s_{2}` does not depend on the point :math:`P`, we compute it
        only once.
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = ellpadics2(_E, _p, n)
        return new_gen(_ret)

    def ellperiods(w, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Let :math:`w` describe a complex period lattice (:math:`w = [w_{1},w_{2}]`
        or an :literal:`ellinit` structure). Returns normalized periods :math:`[W_{1},W_{2}]`
        generating the same lattice such that :math:`\tau := W_{1}/W_{2}` has positive
        imaginary part and lies in the standard fundamental domain for
        :math:`SL_{2}(\mathbb{Z})`.

        If :math:`flag = 1`, the function returns :math:`[[W_{1},W_{2}], [\eta_{1},\eta_{2}]]`,
        where :math:`\eta_{1}` and :math:`\eta_{2}` are the quasi-periods attached to
        :math:`[W_{1},W_{2}]`, satisfying :math:`\eta_{2} W_{1} - \eta_{1} W_{2} = 2 i \pi`.

        The output of this function is meant to be used as the first argument
        given to ellwp, ellzeta, ellsigma or elleisnum. Quasi-periods are
        needed by ellzeta and ellsigma only.

        ::

        ? L = ellperiods([1,I],1);
        ? [w1,w2] = L[1]; [e1,e2] = L[2];
        ? e2*w1 - e1*w2
        %3 = 6.2831853071795864769252867665590057684*I
        ? ellzeta(L, 1/2 + 2*I)
        %4 = 1.5707963... - 6.283185307...*I
        ? ellzeta([1,I], 1/2 + 2*I) \\ same but less efficient
        %4 = 1.5707963... - 6.283185307...*I
        '''
        sig_on()
        cdef GEN _w = (<Gen>w).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellperiods(_w, flag, precision)
        return new_gen(_ret)

    def ellpointtoz(E, P, long precision=DEFAULT_BITPREC):
        r'''
        If :math:`E/\mathbb{C} ~ \mathbb{C}/\Lambda` is a complex elliptic curve (:math:`\Lambda =
        E.omega`), computes a complex number :math:`z`, well-defined modulo the
        lattice :math:`\Lambda`, corresponding to the point :math:`P`; i.e. such that
        :math:`P = [\wp_{\Lambda}(z),\wp'_{\Lambda}(z)]` satisfies the equation

        .. MATH::

        y^{2} = 4x^{3} - g_{2} x - g_{3},

        where :math:`g_{2}`, :math:`g_{3}` are the elliptic invariants.

        If :math:`E` is defined over :math:`\mathbb{R}` and :math:`P\in E(\mathbb{R})`, we have more precisely, :math:`0 \leq
        \Re (t) < w1` and :math:`0 <= \Im (t) < \Im (w2)`, where :math:`(w1,w2)` are the real and
        complex periods of :math:`E`.

        ::

        ? E = ellinit([0,1]); P = [2,3];
        ? z = ellpointtoz(E, P)
        %2 = 3.5054552633136356529375476976257353387
        ? ellwp(E, z)
        %3 = 2.0000000000000000000000000000000000000
        ? ellztopoint(E, z) - P
        %4 = [2.548947057811923643 E-57, 7.646841173435770930 E-57]
        ? ellpointtoz(E, [0]) \\ the point at infinity
        %5 = 0

        If :math:`E` is defined over a general number field, the function returns the
        values corresponding to the various complex embeddings of the curve
        and of the point, in the same order as :literal:`E.nf.roots`:

        ::

        ? E=ellinit([-22032-15552*x,0], nfinit(x^2-2));
        ? P=[-72*x-108,0];
        ? ellisoncurve(E,P)
        %3 = 1
        ? ellpointtoz(E,P)
        %4 = [-0.52751724240790530394437835702346995884*I,
        -0.090507650025885335533571758708283389896*I]
        ? E.nf.roots
        %5 = [-1.4142135623730950488016887242096980786, \\ x-> -sqrt(2)
        1.4142135623730950488016887242096980786] \\ x-> sqrt(2)

        If :math:`E/\mathbb{Q}_{p}` has multiplicative reduction, then :math:`E/\bar{\mathbb{Q}_{p}}` is
        analytically
        isomorphic to :math:`\bar{\mathbb{Q}}_{p}^{*}/q^{\mathbb{Z}}` (Tate curve) for some :math:`p`-adic integer
        :math:`q`. The behavior is then as follows:

        - If the reduction is split (:math:`E.tate[2]` is a :literal:`t_PADIC`), we have
        an isomorphism :math:`\phi: E(\mathbb{Q}_{p}) ~ \mathbb{Q}_{p}^{*}/q^{\mathbb{Z}}` and the function
        returns :math:`\phi (P)\in \mathbb{Q}_{p}`.

        - If the reduction is :emphasis:`not` split (:math:`E.tate[2]` is a
        :literal:`t_POLMOD`), we only have an isomorphism :math:`\phi: E(K) ~ K^{*}/q^{\mathbb{Z}}`
        over the unramified quadratic extension :math:`K/\mathbb{Q}_{p}`. In this case, the output
        :math:`\phi (P)\in K` is a :literal:`t_POLMOD`; the function is not fully implemented in
        this case and may fail with a ":math:`u` not in :math:`\mathbb{Q}_{p}`" exception:

        ::

        ? E = ellinit([0,-1,1,0,0], O(11^5)); P = [0,0];
        ? [u2,u,q] = E.tate; type(u) \\ split multiplicative reduction
        %2 = "t_PADIC"
        ? ellmul(E, P, 5) \\ P has order 5
        %3 = [0]
        ? z = ellpointtoz(E, [0,0])
        %4 = 3 + 11^2 + 2*11^3 + 3*11^4 + 6*11^5 + 10*11^6 + 8*11^7 + O(11^8)
        ? z^5
        %5 = 1 + O(11^9)
        ? E = ellinit(ellfromj(1/4), O(2^6)); x=1/2; y=ellordinate(E,x)[1];
        ? z = ellpointtoz(E,[x,y]); \\ t_POLMOD of t_POL with t_PADIC coeffs
        ? liftint(z) \\ lift all p-adics
        %8 = Mod(8*u + 7, u^2 + 437)
        ? x=33/4; y=ellordinate(E,x)[1]; z = ellpointtoz(E,[x,y])
        *** at top-level: ...;y=ellordinate(E,x)[1];z=ellpointtoz(E,[x,y])
        *** ^--------------------
        *** ellpointtoz: sorry, ellpointtoz when u not in Qp is not yet implemented.
        '''
        P = objtogen(P)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        precision = nbits2prec(precision)
        cdef GEN _ret = zell(_E, _P, precision)
        return new_gen(_ret)

    def ellpow(E, z, n):
        r'''
        Deprecated alias for :literal:`ellmul`.
        '''
        from warnings import warn
        warn('the PARI/GP function ellpow is obsolete (2012-06-06)', DeprecationWarning)
        z = objtogen(z)
        n = objtogen(n)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z = (<Gen>z).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = ellmul(_E, _z, _n)
        return new_gen(_ret)

    def ellrank(E, long effort=0, points=None, long precision=DEFAULT_BITPREC):
        r'''
        If :math:`E` is an elliptic curve over :math:`\mathbb{Q}`, attempts to compute the
        Mordell-Weil group attached to the curve. The output is :math:`[r_{1},r_{2},s,L]`,
        where
        :math:`r_{1} <= rank(E) <= r_{2}`, :math:`s` gives informations on the
        Tate-Shafarevic group (see below), and :math:`L` is a list of independent,
        non-torsion rational points on the curve. :math:`E` can also be given as the output
        of :literal:`ellrankinit(E)`.

        If :literal:`points` is provided, it must be a vector of rational points on the
        curve, which are not computed again.

        The parameter :literal:`effort` is a measure of the time employed to find rational
        points before giving up. If :literal:`effort` is not :math:`0`, the search is
        randomized, so rerunning the function might yield different or even
        a different number of rational points. Values up to :math:`10` or so are reasonable
        but the parameter can be increased futher, with running times increasing
        roughly like the :emphasis:`cube` of the :literal:`effort` value.

        ::

        ? E = ellinit([-127^2,0]);
        ? ellrank(E)
        %2 = [1, 1, 0, []] \\ rank is 1 but no point has been found.
        ? ellrank(E,4) \\ with more effort we find a point.
        %3 = [1, 1, 0, [[38902300445163190028032/305111826865145547009,
        680061120400889506109527474197680/5329525731816164537079693913473]]]

        In addition to the previous calls, the first argument :math:`E` can be a pair
        :math:`[e,f]`, where :math:`e` is an elliptic curve given by :literal:`ellrankinit` and
        :math:`f` is a quadratic twist of :math:`e`. We then look for points on :math:`f`.
        Note that the :literal:`ellrankinit` initialization is independent of :math:`f`, so
        this can speed up computations significantly!

        :strong:`Technical explanation.`
        The algorithm, which computes the :math:`2`-descent and the :math:`2`-part of the Cassels
        pairings has an intrinsic limitation: :math:`r_{1} = r_{2}` never holds when
        the Tate-Shafarevic group :math:`G` has :math:`4`-torsion. Thus, in this case we cannot
        determine the rank precisely. The algorithm computes unconditionally three
        quantities:

        - the rank :math:`C` of the :math:`2`-Selmer group.

        - the rank :math:`T` of the :math:`2`-torsion subgroup.

        - the (even) rank :math:`s` of :math:`G[2]/2G[4]`; then :math:`r_{2}` is defined
        by :math:`r_{2} = C - T - s`.

        The following quantities are also relevant:

        - the rank :math:`R` of the free part of :math:`E(\mathbb{Q})`; it always holds that
        :math:`r_{1} <= R <= r_{2}`.

        - the rank :math:`S` of :math:`G[2]` (conjecturally even); it always holds that
        :math:`s <= S` and that :math:`C = T + R + S`. Then :math:`r_{2} = C - T - s >= R`.

        When the conductor of :math:`E` is small, the BSD conjecture can be used
        to (conditionally) find the true rank:

        ::

        ? E=ellinit([-113^2,0]);
        ? ellrootno(E) \\ rank is even (parity conjecture)
        %2 = 1
        ? ellrank(E)
        %3 = [0, 2, 0, []] \\ rank is either 0 or 2, $2$-rank of $G$ is
        ? ellrank(E, 3) \\ try harder
        %4 = [0, 2, 0, []] \\ no luck
        ? [r,L] = ellanalyticrank(E) \\ assume BSD
        %5 = [0, 3.9465...]
        ? L / ellbsd(E) \\ analytic rank is 0, compute Sha
        %6 = 16.0000000000000000000000000000000000000

        We find that the rank is :math:`0` and the cardinal of the Tate-Shafarevich group
        is :math:`16` (assuming BSD!). Moreover, since :math:`s = 0`, it is isomorphic to
        :math:`(\mathbb{Z}/4\mathbb{Z})^{2}`.

        When the rank is :math:`1` and the conductor is small, :literal:`ellheegner` can be used
        to find a non-torsion point:

        ::

        ? E = ellinit([-157^2,0]);
        ? ellrank(E)
        %2 = [1, 1, 0, []] \\ rank is 1, no point found
        ? ellrank(E, 5) \\ Try harder
        time = 1,094 ms.
        %3 = [1, 1, 0, []] \\ No luck
        ? ellheegner(E) \\ use analytic method
        time = 492 ms.
        %4 = [69648970982596494254458225/166136231668185267540804, ...]

        In this last example, an :literal:`effort` about 10 would also
        (with probability about 80\%) find a random point, not necessarily the
        Heegner point, in about 5 seconds.
        '''
        cdef bint _have_points = (points is not None)
        if _have_points:
            points = objtogen(points)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _points = NULL
        if _have_points:
            _points = (<Gen>points).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellrank(_E, effort, _points, precision)
        return new_gen(_ret)

    def ellrankinit(E, long precision=DEFAULT_BITPREC):
        r'''
        If :math:`E` is an elliptic curve over :math:`\mathbb{Q}`, initialize data to speed up further
        calls to :literal:`ellrank`.

        ::

        ? E = ellinit([0,2429469980725060,0,275130703388172136833647756388,0]);
        ? rk = ellrankinit(E);
        ? [r, R, s, P] = ellrank(rk)
        %3 = [12, 14, 0, [...]]
        ? [r, R, s, P] = ellrank(rk, 1, P) \\ more effort, using known points
        %4 = [14, 14, 0, [...]] \\ this time all points are found
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellrankinit(_E, precision)
        return new_gen(_ret)

    def ellratpoints(E, h, long flag=0):
        r'''
        :math:`E` being an integral model of elliptic curve , return a vector
        containing the affine rational points on the curve of naive height less than
        :math:`h`. If :math:`flag = 1`, stop as soon as a point is found; return either an empty
        vector or a vector containing a single point.
        See :literal:`hyperellratpoints` for how :math:`h` can be specified.

        ::

        ? E=ellinit([-25,1]);
        ? ellratpoints(E,10)
        %2 = [[-5,1],[-5,-1],[-3,7],[-3,-7],[-1,5],[-1,-5],
        [0,1],[0,-1],[5,1],[5,-1],[7,13],[7,-13]]
        ? ellratpoints(E,10,1)
        %3 = [[-5,1]]
        '''
        h = objtogen(h)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _h = (<Gen>h).g
        cdef GEN _ret = ellratpoints(_E, _h, flag)
        return new_gen(_ret)

    def ellrootno(E, p=None):
        r'''
        :math:`E` being an :literal:`ell` structure over :math:`\mathbb{Q}` as output by :literal:`ellinit`,
        this function computes the local root number of its :math:`L`-series at the place
        :math:`p` (at the infinite place if :math:`p = 0`). If :math:`p` is omitted, return the global
        root number and in this case the curve can also be defined over a number field.

        Note that the global root number is the sign of the functional
        equation and conjecturally is the parity of the rank of the
        Mordell-Weil group. The equation for :math:`E` needs not be minimal at :math:`p`,
        but if the model is already minimal the function will run faster.
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef long _ret = ellrootno(_E, _p)
        clear_stack()
        return _ret

    def ellsaturation(E, V, long B, long precision=DEFAULT_BITPREC):
        r'''
        Let :math:`E` be an elliptic curve over :math:`\mathbb{Q}` and
        and :math:`V` be a set of independent non-torsion rational points on :math:`E` of infinite
        order that generate a subgroup :math:`G` of :math:`E(\mathbb{Q})` of finite index.
        Return a new set :math:`W` of the same length that generate a subgroup :math:`H` of
        :math:`E(\mathbb{Q})` containing :math:`G` and such that :math:`[E(\mathbb{Q}):H]` is not divisible by any
        prime number less than :math:`B`. The running time is roughly quadratic in :math:`B`.

        ::

        ? E = ellinit([0,0, 1, -7, 6]);
        ? [r,R,s,V] = ellrank(E)
        %2 = [3, 3, 0, [[-1,3], [-3,0], [11,35]]]
        ? matdet(ellheightmatrix(E, V))
        %3 = 3.7542920288254557283540759015628405708
        ? W = ellsaturation(E, V, 2) \\ index is now odd
        time = 1 ms.
        %4 = [[-1, 3], [-3, 0], [11, 35]]
        ? W = ellsaturation(E, W, 10) \\ index not divisible by p <= 10
        %5 = [[1, -1], [2, -1], [0, -3]]
        time = 2 ms.
        ? W = ellsaturation(E, V, 100) \\ looks OK now
        time = 171 ms.
        %6 = [[1, -1], [2, -1], [0, -3]]
        ? matdet(ellheightmatrix(E,V))
        %7 = 0.41714355875838396981711954461809339675
        ? lfun(E,1,3)/3! / ellbsd(E) \\ conductor is small, check assuming BSD
        %8 = 0.41714355875838396981711954461809339675
        '''
        V = objtogen(V)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _V = (<Gen>V).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellsaturation(_E, _V, B, precision)
        return new_gen(_ret)

    def ellsea(E, long tors=0):
        r'''
        Let :math:`E` be an :emphasis:`ell` structure as output by :literal:`ellinit`, defined over
        a finite field :math:`\mathbb{F}_{q}`. This low-level function computes the order of the
        group :math:`E(\mathbb{F}_{q})` using the SEA algorithm; compared to the high-level
        function :literal:`ellcard`, which includes SEA among its choice of algorithms,
        the :literal:`tors` argument allows to speed up a search for curves having almost
        prime order and whose quadratic twist may also have almost prime order.
        When :literal:`tors` is set to a nonzero value, the function returns :math:`0` as soon
        as it detects that the order has a small prime factor not dividing :literal:`tors`;
        SEA considers modular polynomials of increasing prime degree :math:`\ell` and we
        return :math:`0` as soon as we hit an :math:`\ell` (coprime to :literal:`tors`) dividing
        :math:`\#E(\mathbb{F}_{q})`:

        ::

        ? ellsea(ellinit([1,1], 2^56+3477), 1)
        %1 = 72057594135613381
        ? forprime(p=2^128,oo, q = ellcard(ellinit([1,1],p)); if(isprime(q),break))
        time = 6,571 ms.
        ? forprime(p=2^128,oo, q = ellsea(ellinit([1,1],p),1);if(isprime(q),break))
        time = 522 ms.

        In particular, set :literal:`tors` to :math:`1` if you want a curve with prime order,
        to :math:`2` if you want to allow a cofactor which is a power of two (e.g. for
        Edwards's curves), etc. The early exit on bad curves yields a massive
        speedup compared to running the cardinal algorithm to completion.

        When :literal:`tors` is negative, similar checks are performed for the quadratic
        twist of the curve.

        The following function returns a curve of prime order over :math:`\mathbb{F}_{p}`.

        ::

        cryptocurve(p) =
        {
        while(1,
        my(E, N, j = Mod(random(p), p));
        E = ellinit(ellfromj(j));
        N = ellsea(E, 1); if (!N, continue);
        if (isprime(N), return(E));
        \\ try the quadratic twist for free
        if (isprime(2*p+2 - N), return(elltwist(E)));
        );
        }
        ? p = randomprime([2^255, 2^256]);
        ? E = cryptocurve(p); \\ insist on prime order
        %2 = 47,447ms

        The same example without early abort (using :literal:`ellcard(E)`
        instead of :literal:`ellsea(E, 1)`) runs for about 5 minutes before finding a
        suitable curve.

        The availability of the :literal:`seadata` package will speed up the computation,
        and is strongly recommended. The generic function :literal:`ellcard` should be
        preferred when you only want to compute the cardinal of a given curve without
        caring about it having almost prime order:

        - If the characteristic is too small (:math:`p <= 7`) or the field
        cardinality is tiny (:math:`q <= 523`) the generic algorithm
        :literal:`ellcard` is used instead and the :literal:`tors` argument is ignored.
        (The reason for this is that SEA is not implemented for :math:`p <= 7` and
        that if :math:`q <= 523` it is likely to run into an infinite loop.)

        - If the field cardinality is smaller than about :math:`2^{50}`, the
        generic algorithm will be faster.

        - Contrary to :literal:`ellcard`, :literal:`ellsea` does not store the computed
        cardinality in :math:`E`.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellsea(_E, tors)
        return new_gen(_ret)

    def ellsearch(N):
        r'''
        This function finds all curves in the :literal:`elldata` database satisfying
        the constraint defined by the argument :math:`N`:

        - if :math:`N` is a character string, it selects a given curve, e.g.
        :literal:`"11a1"`, or curves in the given isogeny class, e.g. :literal:`"11a"`, or
        curves with given conductor, e.g. :literal:`"11"`;

        - if :math:`N` is a vector of integers, it encodes the same constraints
        as the character string above, according to the :literal:`ellconvertname`
        correspondance, e.g. :literal:`[11,0,1]` for :literal:`"11a1"`, :literal:`[11,0]` for
        :literal:`"11a"` and :literal:`[11]` for :literal:`"11"`;

        - if :math:`N` is an integer, curves with conductor :math:`N` are selected.

        If :math:`N` codes a full curve name, for instance :literal:`"11a1"` or :literal:`[11,0,1]`,
        the output format is :math:`[N, [a_{1},a_{2},a_{3},a_{4},a_{6}], G]` where
        :math:`[a_{1},a_{2},a_{3},a_{4},a_{6}]` are the coefficients of the Weierstrass
        equation of the curve and :math:`G` is a :math:`\mathbb{Z}`-basis of the free part of the
        Mordell-Weil group attached to the curve.

        ::

        ? ellsearch("11a3")
        %1 = ["11a3", [0, -1, 1, 0, 0], []]
        ? ellsearch([11,0,3])
        %2 = ["11a3", [0, -1, 1, 0, 0], []]

        If :math:`N` is not a full curve name, then the output is a vector of all matching
        curves in the above format:

        ::

        ? ellsearch("11a")
        %1 = [["11a1", [0, -1, 1, -10, -20], []],
        ["11a2", [0, -1, 1, -7820, -263580], []],
        ["11a3", [0, -1, 1, 0, 0], []]]
        ? ellsearch("11b")
        %2 = []
        '''
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _ret = ellsearch(_N)
        return new_gen(_ret)

    def ellsigma(L, z=None, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Computes the value at :math:`z` of the Weierstrass :math:`\sigma` function attached to
        the lattice :math:`L` as given by :literal:`ellperiods`:math:`(,1)`: including quasi-periods
        is useful, otherwise there are recomputed from scratch for each new :math:`z`.

        .. MATH::

        \sigma (z, L) = z \prod_{\omega\in L^{*}} (1 - (z)/(\omega))
        e^{(z)/(\omega) + (z^{2})/(2\omega^{2})}.

        It is also possible to directly input :math:`L = [\omega_{1},\omega_{2}]`,
        or an elliptic curve :math:`E` as given by :literal:`ellinit` (:math:`L = E.omega`).

        ::

        ? w = ellperiods([1,I], 1);
        ? ellsigma(w, 1/2)
        %2 = 0.47494937998792065033250463632798296855
        ? E = ellinit([1,0]);
        ? ellsigma(E) \\ at 'x, implicitly at default seriesprecision
        %4 = x + 1/60*x^5 - 1/10080*x^9 - 23/259459200*x^13 + O(x^17)

        If :math:`flag = 1`, computes an arbitrary determination of :math:`\log (\sigma (z))`.
        '''
        cdef bint _have_z = (z is not None)
        if _have_z:
            z = objtogen(z)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _z = NULL
        if _have_z:
            _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellsigma(_L, _z, flag, precision)
        return new_gen(_ret)

    def ellsub(E, z1, z2):
        r'''
        Difference of the points :math:`z1` and :math:`z2` on the
        elliptic curve corresponding to :math:`E`.
        '''
        z1 = objtogen(z1)
        z2 = objtogen(z2)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z1 = (<Gen>z1).g
        cdef GEN _z2 = (<Gen>z2).g
        cdef GEN _ret = ellsub(_E, _z1, _z2)
        return new_gen(_ret)

    def ellsupersingularj(p):
        r'''
        Return a random supersingular :math:`j`-invariant defined over :math:`\mathbb{F}_{p}^{2}` as a
        :literal:`t_FFELT` in the variable :literal:`w`, if :math:`p` is a prime number, or over the
        field of definition of :math:`p` if :math:`p` is a :literal:`t_FFELT`. The field must be of even
        degree. The random distribution is close to uniform except when :math:`0` or
        :math:`1728` are supersingular :math:`j`-invariants, in which case they are less
        likely to be returned. This bias becomes negligible as :math:`p` grows.

        ::

        ? j = ellsupersingularj(1009)
        %1 = 12*w+295
        ? ellissupersingular(j)
        %2 = 1
        ? a = ffgen([1009,2],'a);
        ? j = ellsupersingularj(a)
        %4 = 867*a+721
        ? ellissupersingular(j)
        %5 = 1
        ? E = ellinit([j]);
        ? F = elltwist(E);
        ? ellissupersingular(F)
        %8 = 1
        ? ellap(E)
        %9 = 2018
        ? ellap(F)
        %10 = -2018
        '''
        sig_on()
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = ellsupersingularj(_p)
        return new_gen(_ret)

    def elltamagawa(E):
        r'''
        The object :math:`E` being an elliptic curve over a number field, returns the global
        Tamagawa number of the curve (including the factor at infinite places).

        ::

        ? e = ellinit([1, -1, 1, -3002, 63929]); \\ curve "90c6" from elldata
        ? elltamagawa(e)
        %2 = 288
        ? [elllocalred(e,p)[4] | p<-[2,3,5]]
        %3 = [6, 4, 6]
        ? vecprod(%) \\ since e.disc > 0 the factor at infinity is 2
        %4 = 144
        ? ellglobalred(e)[4] \\ product without the factor at infinity
        %5 = 144
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = elltamagawa(_E)
        return new_gen(_ret)

    def elltaniyama(E, long serprec=-1):
        r'''
        Computes the modular parametrization of the elliptic curve :math:`E/\mathbb{Q}`,
        where :math:`E` is an :literal:`ell` structure as output by :literal:`ellinit`. This returns
        a two-component vector :math:`[u,v]` of power series, given to :math:`n` significant
        terms (:literal:`seriesprecision` by default), characterized by the following two
        properties. First the point :math:`(u,v)` satisfies the equation of the elliptic
        curve. Second, let :math:`N` be the conductor of :math:`E` and :math:`\Phi: X_{0}(N)\to E`
        be a modular parametrization; the pullback by :math:`\Phi` of the
        Néron differential :math:`du/(2v+a_{1}u+a_{3})` is equal to :math:`2i\pi
        f(z)dz`, a holomorphic differential form. The variable used in the power
        series for :math:`u` and :math:`v` is :math:`x`, which is implicitly understood to be equal to
        :math:`\exp (2i\pi z)`.

        The algorithm assumes that :math:`E` is a :emphasis:`strong` Weil curve
        and that the Manin constant is equal to 1: in fact, :math:`f(x) = \sum_{n > 0}
        ellak (E, n) x^{n}`.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = elltaniyama(_E, serprec)
        return new_gen(_ret)

    def elltatepairing(E, P, Q, m):
        r'''
        Let :math:`E` be an elliptic curve defined over a finite field :math:`k`
        and :math:`m >= 1` be an integer. This function computes the (nonreduced) Tate
        pairing of the points :math:`P` and :math:`Q` on :math:`E`, where :math:`P` is an :math:`m`-torsion point.
        More precisely, let :math:`f_{m,P}` denote a Miller function with divisor :math:`m[P] -
        m[O_{E}]`; the algorithm returns :math:`f_{m,P}(Q) \in k^{*}/(k^{*})^{m}`.
        '''
        P = objtogen(P)
        Q = objtogen(Q)
        m = objtogen(m)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = elltatepairing(_E, _P, _Q, _m)
        return new_gen(_ret)

    def elltors(E):
        r'''
        If :math:`E` is an elliptic curve defined over a number field or a finite field,
        outputs the torsion subgroup of :math:`E` as a 3-component vector :literal:`[t,v1,v2]`,
        where :literal:`t` is the order of the torsion group, :literal:`v1` gives the structure
        of the torsion group as a product of cyclic groups (sorted by decreasing
        order), and :literal:`v2` gives generators for these cyclic groups. :math:`E` must be an
        :literal:`ell` structure as output by :literal:`ellinit`.

        ::

        ? E = ellinit([-1,0]);
        ? elltors(E)
        %1 = [4, [2, 2], [[0, 0], [1, 0]]]

        Here, the torsion subgroup is isomorphic to :math:`\mathbb{Z}/2\mathbb{Z} x \mathbb{Z}/2\mathbb{Z}`, with
        generators :math:`[0,0]` and :math:`[1,0]`.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = elltors(_E)
        return new_gen(_ret)

    def elltrace(E, P):
        r'''
        Let :math:`E` be an elliptic curve over a base field and a point :math:`P` defined
        over an extension field using :literal:`t_POLMOD` constructs. Returns the sum of
        the Galois conjugates of :math:`P`.
        The field over which :math:`P` is defined must be specified, even in the (silly)
        case of a trivial extension:

        ::

        ? E = ellinit([1,15]); \\ y^2 = x^3 + x + 15, over Q
        ? P = Mod([a/8-1, 1/32*a^2-11/32*a-19/4], a^3-135*a-408);
        ? ellisoncurve(E,P) \\ P defined over a cubic extension
        %3 = 1
        ? elltrace(E,P)
        %4 = [2,-5]

        ::

        ? E = ellinit([-13^2, 0]);
        ? P = Mod([13,0], a^2-2); \\ defined over Q, seen over a quadratic extension
        ? elltrace(E,P) == ellmul(E,P,2)
        %3 = 1
        ? elltrace(E,[13,0]) \\ number field of definition of the point unspecified!
        *** at top-level: elltrace(E,[13,0])
        *** ^------------------
        *** elltrace: incorrect type in elltrace (t_INT).
        ? elltrace(E,Mod([13,0],a)) \\ trivial extension
        %5 = [Mod(13, a), Mod(0, a)]
        ? P = Mod([-10*x^3+10*x-13, -16*x^3+16*x-34], x^4-x^3+2*x-1);
        ? ellisoncurve(E,P)
        %7 = 1
        ? Q = elltrace(E,P)
        %8 = [11432100241 / 375584400, 1105240264347961 / 7278825672000]
        ? ellisoncurve(E,Q)
        %9 = 1

        ::

        ? E = ellinit([2,3], 19); \\ over F_19
        ? T = a^5+a^4+15*a^3+16*a^2+3*a+1; \\ irreducible
        ? P = Mod([11*a^3+11*a^2+a+12,15*a^4+9*a^3+18*a^2+18*a+6], T);
        ? ellisoncurve(E, P)
        %4 = 1
        ? Q = elltrace(E, P)
        %5 = [Mod(1,19), Mod(14,19)]
        ? ellisoncurve(E, Q)
        %6 = 1
        '''
        P = objtogen(P)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = elltrace(_E, _P)
        return new_gen(_ret)

    def elltwist(E, P=None):
        r'''
        Returns an :literal:`ell` structure (as given by :literal:`ellinit`) for the twist
        of the elliptic curve :math:`E` by the quadratic extension of the coefficient
        ring defined by :math:`P` (when :math:`P` is a polynomial) or :literal:`quadpoly(P)` when :math:`P`
        is an integer. If :math:`E` is defined over a finite field, then :math:`P` can be
        omitted, in which case a random model of the unique nontrivial twist is
        returned. If :math:`E` is defined over a number field, the model should be
        replaced by a minimal model (if one exists).

        The elliptic curve :math:`E` can be given in some of the formats allowed by
        :literal:`ellinit`: an :literal:`ell` structure, a :math:`5`-component vector
        :math:`[a_{1},a_{2},a_{3},a_{4},a_{6}]` or a :math:`2`-component vector :math:`[a_{4},a_{6}]`.

        Twist by discriminant :math:`-3`:

        ::

        ? elltwist([0,a2,0,a4,a6], -3)[1..5]
        %1 = [0, -3*a2, 0, 9*a4, -27*a6]
        ? elltwist([a4,a6], -3)[1..5]
        %2 = [0, 0, 0, 9*a4, -27*a6]

        Twist by the Artin-Schreier extension given by :math:`x^{2}+x+T` in
        characteristic :math:`2`:

        ::

        ? lift(elltwist([a1,a2,a3,a4,a6]*Mod(1,2), x^2+x+T)[1..5])
        %1 = [a1, a2+a1^2*T, a3, a4, a6+a3^2*T]

        Twist of an elliptic curve defined over a finite field:

        ::

        ? E = elltwist([1,7]*Mod(1,19)); lift([E.a4, E.a6])
        %1 = [11, 12]
        '''
        cdef bint _have_P = (P is not None)
        if _have_P:
            P = objtogen(P)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = NULL
        if _have_P:
            _P = (<Gen>P).g
        cdef GEN _ret = elltwist(_E, _P)
        return new_gen(_ret)

    def ellweilcurve(E, ms=None):
        r'''
        If :math:`E'` is an elliptic curve over :math:`\mathbb{Q}`, let :math:`L_{E'}` be the
        sub-:math:`\mathbb{Z}`-module of :math:`\text{Hom}_{\Gamma_{0}(N)}(\Delta_{0},\mathbb{Q})` attached to :math:`E'`
        (It is given by :math:`x[3]` if :math:`[M,x] = msfromell (E')`.)

        On the other hand, if :math:`N` is the conductor of :math:`E` and :math:`f` is the modular form
        for :math:`\Gamma_{0}(N)` attached to :math:`E`, let :math:`L_{f}` be the lattice of the
        :math:`f`-component of :math:`\text{Hom}_{\Gamma_{0}(N)}(\Delta_{0},\mathbb{Q})` given by the elements
        :math:`\phi` such that :math:`\phi ({0,\gamma^{-1} 0}) \in \mathbb{Z}` for all
        :math:`\gamma \in \Gamma_{0}(N)` (see :literal:`mslattice`).

        Let :math:`E'` run through the isomorphism classes of elliptic curves
        isogenous to :math:`E` as given by :literal:`ellisomat` (and in the same order).
        This function returns a pair :literal:`[vE,vS]` where :literal:`vE` contains minimal
        models for the :math:`E'` and :literal:`vS` contains the list of Smith invariants for
        the lattices :math:`L_{E'}` in :math:`L_{f}`. The function also accepts the output of
        :literal:`ellisomat`, i.e. the isogeny class. If the optional argument :literal:`ms`
        is present, it contains the output of :literal:`msfromell(vE, 0)`, i.e. the new
        modular symbol space :math:`M` of level :math:`N` and a vector of triples
        :math:`[x^{+},x^{-}, L]` attached to each curve :math:`E'`.

        In particular, the strong Weil curve amongst the curves isogenous to :math:`E`
        is the one whose Smith invariants are :math:`[c,c]`, where :math:`c` is the Manin
        constant, conjecturally equal to :math:`1`.

        ::

        ? E = ellinit("11a3");
        ? [vE, vS] = ellweilcurve(E);
        ? [n] = [ i | i<-[1..#vS], vS[i]==[1,1] ] \\ lattice with invariant [1,1]
        %3 = [2]
        ? ellidentify(vE[n]) \\ ... corresponds to strong Weil curve
        %4 = [["11a1", [0, -1, 1, -10, -20], []], [1, 0, 0, 0]]
        
        ? [vE, vS] = ellweilcurve(E, &ms); \\ vE,vS are as above
        ? [M, vx] = ms; msdim(M) \\ ... but ms contains more information
        %6 = 3
        ? #vx
        %7 = 3
        ? vx[1]
        %8 = [[1/25, -1/10, -1/10]~, [0, 1/2, -1/2]~, [1/25,0; -3/5,1; 2/5,-1]]
        ? forell(E, 11,11, print(msfromell(ellinit(E[1]), 1)[2]))
        [1/5, -1/2, -1/2]~
        [1, -5/2, -5/2]~
        [1/25, -1/10, -1/10]~

        The last example prints the modular symbols :math:`x^{+}`
        in :math:`M^{+}` attached to the curves :literal:`11a1`, :literal:`11a2` and :literal:`11a3`.
        '''
        cdef bint _have_ms = (ms is not None)
        if _have_ms:
            raise NotImplementedError("optional argument ms not available")
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN * _ms = NULL
        cdef GEN _ret = ellweilcurve(_E, _ms)
        return new_gen(_ret)

    def ellweilpairing(E, P, Q, m):
        r'''
        Let :math:`E` be an elliptic curve defined over a finite field and :math:`m >= 1`
        be an integer. This function computes the Weil pairing of the two :math:`m`-torsion
        points :math:`P` and :math:`Q` on :math:`E`, which is an alternating bilinear map.
        More precisely, let :math:`f_{m,R}` denote a Miller function with
        divisor :math:`m[R] - m[O_{E}]`; the algorithm returns the :math:`m`-th root of unity

        .. MATH::

        \varepsilon (P,Q)^{m}.f_{m,P}(Q) / f_{m,Q}(P),

        where :math:`f(R)` is the extended evaluation of :math:`f` at the divisor :math:`[R] - [O_{E}]`
        and :math:`\varepsilon (P,Q)\in {±1}` is given by Weil reciprocity:
        :math:`\varepsilon (P,Q) = 1` if and only if :math:`P, Q, O_{E}` are not pairwise distinct.
        '''
        P = objtogen(P)
        Q = objtogen(Q)
        m = objtogen(m)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = ellweilpairing(_E, _P, _Q, _m)
        return new_gen(_ret)

    def ellwp(w, z=None, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Computes the value at :math:`z` of the Weierstrass :math:`\wp` function attached to
        the lattice :math:`w` as given by :literal:`ellperiods`. It is also possible to
        directly input :math:`w = [\omega_{1},\omega_{2}]`, or an elliptic curve :math:`E` as
        given by :literal:`ellinit` (:math:`w = E.omega`).

        ::

        ? w = ellperiods([1,I]);
        ? ellwp(w, 1/2)
        %2 = 6.8751858180203728274900957798105571978
        ? E = ellinit([1,1]);
        ? ellwp(E, 1/2)
        %4 = 3.9413112427016474646048282462709151389

        One can also compute the series expansion around :math:`z = 0`:

        ::

        ? E = ellinit([1,0]);
        ? ellwp(E) \\ 'x implicitly at default seriesprecision
        %5 = x^-2 - 1/5*x^2 + 1/75*x^6 - 2/4875*x^10 + O(x^14)
        ? ellwp(E, x + O(x^12)) \\ explicit precision
        %6 = x^-2 - 1/5*x^2 + 1/75*x^6 + O(x^9)

        Optional :emphasis:`flag` means 0 (default): compute only :math:`\wp (z)`, 1: compute
        :math:`[\wp (z),\wp'(z)]`.

        For instance, the Dickson elliptic functions :emphasis:`sm` and :emphasis:`sn` can be
        implemented as follows

        ::

        smcm(z) =
        { my(a, b, E = ellinit([0,-1/(4*27)])); \\ ell. invariants (g2,g3)=(0,1/27)
        [a,b] = ellwp(E, z, 1);
        [6*a / (1-3*b), (3*b+1)/(3*b-1)];
        }
        ? [s,c] = smcm(0.5);
        ? s
        %2 = 0.4898258757782682170733218609
        ? c
        %3 = 0.9591820206453842491187464098
        ? s^3+c^3
        %4 = 1.000000000000000000000000000
        ? smcm('x + O('x^11))
        %5 = [x - 1/6*x^4 + 2/63*x^7 - 13/2268*x^10 + O(x^11),
        1 - 1/3*x^3 + 1/18*x^6 - 23/2268*x^9 + O(x^10)]
        '''
        cdef bint _have_z = (z is not None)
        if _have_z:
            z = objtogen(z)
        sig_on()
        cdef GEN _w = (<Gen>w).g
        cdef GEN _z = NULL
        if _have_z:
            _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellwp0(_w, _z, flag, precision)
        return new_gen(_ret)

    def ellxn(E, long n, v=None):
        r'''
        For any affine point :math:`P = (t,u)` on the curve :math:`E`, we have

        .. MATH::

        [n]P = (\phi_{n}(P)\psi_{n}(P) : \omega_{n}(P) : \psi_{n}(P)^{3})

        for some :math:`\phi_{n},\omega_{n},\psi_{n}` in :math:`\mathbb{Z}[a_{1},a_{2},a_{3},a_{4},a_{6}][t,u]`
        modulo the curve equation. This function returns a pair :math:`[A,B]` of polynomials
        in :math:`\mathbb{Z}[a_{1},a_{2},a_{3},a_{4},a_{6}][v]` such that :math:`[A(t),B(t)]
        = [\phi_{n}(P),\psi_{n}(P)^{2}]` in the function field of :math:`E`,
        whose quotient give the abscissa of :math:`[n]P`. If :math:`P` is an :math:`n`-torsion point,
        then :math:`B(t) = 0`.

        ::

        ? E = ellinit([17,42]); [t,u] = [114,1218];
        ? T = ellxn(E, 2, 'X)
        %2 = [X^4 - 34*X^2 - 336*X + 289, 4*X^3 + 68*X + 168]
        ? [a,b] = subst(T,'X,t);
        %3 = [168416137, 5934096]
        ? a / b == ellmul(E, [t,u], 2)[1]
        %4 = 1
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = ellxn(_E, n, _v)
        return new_gen(_ret)

    def ellzeta(w, z=None, long precision=DEFAULT_BITPREC):
        r'''
        Computes the value at :math:`z` of the Weierstrass :math:`\zeta` function attached to
        the lattice :math:`w` as given by :literal:`ellperiods`:math:`(,1)`: including quasi-periods
        is useful, otherwise there are recomputed from scratch for each new :math:`z`.

        .. MATH::

        \zeta (z, L) = (1)/(z) + z^{2}\sum_{\omega\in L^{*}}
        (1)/(\omega^{2}(z-\omega)).

        It is also possible to directly input :math:`w = [\omega_{1},\omega_{2}]`,
        or an elliptic curve :math:`E` as given by :literal:`ellinit` (:math:`w = E.omega`).
        The quasi-periods of :math:`\zeta`, such that

        .. MATH::

        \zeta (z + a\omega_{1} + b\omega_{2}) = \zeta (z) + a\eta_{1} + b\eta_{2}

        for integers :math:`a` and :math:`b` are obtained as :math:`\eta_{i} = 2\zeta (\omega_{i}/2)`.
        Or using directly :literal:`elleta`.

        ::

        ? w = ellperiods([1,I],1);
        ? ellzeta(w, 1/2)
        %2 = 1.5707963267948966192313216916397514421
        ? E = ellinit([1,0]);
        ? ellzeta(E, E.omega[1]/2)
        %4 = 0.84721308479397908660649912348219163647

        One can also compute the series expansion around :math:`z = 0`
        (the quasi-periods are useless in this case):

        ::

        ? E = ellinit([0,1]);
        ? ellzeta(E) \\ at 'x, implicitly at default seriesprecision
        %4 = x^-1 + 1/35*x^5 - 1/7007*x^11 + O(x^15)
        ? ellzeta(E, x + O(x^20)) \\ explicit precision
        %5 = x^-1 + 1/35*x^5 - 1/7007*x^11 + 1/1440257*x^17 + O(x^18)
        '''
        cdef bint _have_z = (z is not None)
        if _have_z:
            z = objtogen(z)
        sig_on()
        cdef GEN _w = (<Gen>w).g
        cdef GEN _z = NULL
        if _have_z:
            _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ellzeta(_w, _z, precision)
        return new_gen(_ret)

    def ellztopoint(E, z, long precision=DEFAULT_BITPREC):
        r'''
        :math:`E` being an :emphasis:`ell` as output by
        :literal:`ellinit`, computes the coordinates :math:`[x,y]` on the curve :math:`E`
        corresponding to the complex or :math:`p`-adic parameter :math:`z`. Hence this is the
        inverse function of :literal:`ellpointtoz`.

        - If :math:`E` is defined over a :math:`p`-adic field and has multiplicative
        reduction, then :math:`z` is understood as an element on the
        Tate curve :math:`\bar{Q}_{p}^{*} / q^{\mathbb{Z}}`.

        ::

        ? E = ellinit([0,-1,1,0,0], O(11^5));
        ? [u2,u,q] = E.tate; type(u)
        %2 = "t_PADIC" \\ split multiplicative reduction
        ? z = ellpointtoz(E, [0,0])
        %3 = 3 + 11^2 + 2*11^3 + 3*11^4 + 6*11^5 + 10*11^6 + 8*11^7 + O(11^8)
        ? ellztopoint(E,z)
        %4 = [O(11^9), O(11^9)]
        
        ? E = ellinit(ellfromj(1/4), O(2^6)); x=1/2; y=ellordinate(E,x)[1];
        ? z = ellpointtoz(E,[x,y]); \\ nonsplit: t_POLMOD with t_PADIC coefficients
        ? P = ellztopoint(E, z);
        ? P[1] \\ y coordinate is analogous, more complicated
        %8 = Mod(O(2^4)*x + (2^-1 + O(2^5)), x^2 + (1 + 2^2 + 2^4 + 2^5 + O(2^7)))

        - If :math:`E` is defined over the complex numbers (for instance over :math:`\mathbb{Q}`),
        :math:`z` is understood as a complex number in :math:`\mathbb{C}/\Lambda_{E}`. If the
        short Weierstrass equation is :math:`y^{2} = 4x^{3} - g_{2}x - g_{3}`, then :math:`[x,y]`
        represents the Weierstrass :math:`\wp`-function
        and its derivative. For a general Weierstrass equation we have
        

        .. MATH::

        x = \wp (z) - b_{2}/12, y = \wp'(z)/2 - (a_{1} x + a_{3})/2.

        If :math:`z` is in the lattice defining :math:`E` over :math:`\mathbb{C}`, the result is the point at
        infinity :math:`[0]`.

        ::

        ? E = ellinit([0,1]); P = [2,3];
        ? z = ellpointtoz(E, P)
        %2 = 3.5054552633136356529375476976257353387
        ? ellwp(E, z)
        %3 = 2.0000000000000000000000000000000000000
        ? ellztopoint(E, z) - P
        %4 = [2.548947057811923643 E-57, 7.646841173435770930 E-57]
        ? ellztopoint(E, 0)
        %5 = [0] \\ point at infinity
        '''
        z = objtogen(z)
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = pointell(_E, _z, precision)
        return new_gen(_ret)

    def erfc(x, long precision=DEFAULT_BITPREC):
        r'''
        Complementary error function, analytic continuation of
        :math:`(2/\sqrt\pi)\int_{x}^{ oo } e^{-t^{2}}dt
        = {sign(x)}incgam (1/2,x^{2})/\sqrt\pi` for real :math:`x ! = 0`.
        The latter expression extends the function definition from real :math:`x` to
        complex :math:`x` with positive real part (or zero real part and positive
        imaginary part). This is extended to the whole complex plane by
        the functional equation :math:`erfc (-x) = 2 - erfc (x)`.

        ::

        ? erfc(0)
        %1 = 1.0000000000000000000000000000000000000
        ? erfc(1)
        %2 = 0.15729920705028513065877936491739074071
        ? erfc(1+I)
        %3 = -0.31615128169794764488027108024367036903
        - 0.19045346923783468628410886196916244244*I
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gerfc(_x, precision)
        return new_gen(_ret)

    def errname(E):
        r'''
        Returns the type of the error message :literal:`E` as a string.

        ::

        ? iferr(1 / 0, E, print(errname(E)))
        e_INV
        ? ?? e_INV
        [...]
        * "e_INV". Tried to invert a noninvertible object x in function s.
        [...]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = errname(_E)
        return new_gen(_ret)

    def eta(z, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Variants of Dedekind's :math:`\eta` function.
        If :math:`flag = 0`, return :math:`\prod_{n = 1}^{ oo }(1-q^{n})`, where :math:`q` depends on :math:`x`
        in the following way:

        - :math:`q = e^{2i\pi x}` if :math:`x` is a :emphasis:`complex number` (which must then
        have positive imaginary part); notice that the factor :math:`q^{1/24}` is
        missing!

        - :math:`q = x` if :math:`x` is a :literal:`t_PADIC`, or can be converted to a
        :emphasis:`power series` (which must then have positive valuation).

        If :math:`flag` is nonzero, :math:`x` is converted to a complex number and we return the
        true :math:`\eta` function, :math:`q^{1/24}\prod_{n = 1}^{ oo }(1-q^{n})`,
        where :math:`q = e^{2i\pi x}`.
        '''
        sig_on()
        cdef GEN _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = eta0(_z, flag, precision)
        return new_gen(_ret)

    def eulerphi(x):
        r'''
        Euler's :math:`\phi` (totient) function of the
        integer :math:`\|x\|`, in other words :math:`\|(\mathbb{Z}/x\mathbb{Z})^{*}\|`.

        ::

        ? eulerphi(40)
        %1 = 16

        According to this definition we let :math:`\phi (0) := 2`, since :math:`\mathbb{Z}^{*} = {-1,1}`;
        this is consistent with :literal:`znstar(0)`: we have
        :literal:`znstar:math:`(n)`.no = eulerphi(n)` for all :math:`n\in\mathbb{Z}`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = eulerphi(_x)
        return new_gen(_ret)

    def exp(x, long precision=DEFAULT_BITPREC):
        r'''
        Exponential of :math:`x`.
        :math:`p`-adic arguments with positive valuation are accepted.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gexp(_x, precision)
        return new_gen(_ret)

    def expm1(x, long precision=DEFAULT_BITPREC):
        r'''
        Return :math:`\exp (x)-1`, computed in a way that is also accurate
        when the real part of :math:`x` is near :math:`0`.
        A naive direct computation would suffer from catastrophic cancellation;
        PARI's direct computation of :math:`\exp (x)` alleviates this well known problem at
        the expense of computing :math:`\exp (x)` to a higher accuracy when :math:`x` is small.
        Using :literal:`expm1` is recommended instead:

        ::

        ? default(realprecision, 10000); x = 1e-100;
        ? a = expm1(x);
        time = 4 ms.
        ? b = exp(x)-1;
        time = 4 ms.
        ? default(realprecision, 10040); x = 1e-100;
        ? c = expm1(x); \\ reference point
        ? abs(a-c)/c \\ relative error in expm1(x)
        %7 = 1.4027986153764843997 E-10019
        ? abs(b-c)/c \\ relative error in exp(x)-1
        %8 = 1.7907031188259675794 E-9919

        As the example above shows, when :math:`x` is near :math:`0`,
        :literal:`expm1` is more accurate than :literal:`exp(x)-1`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gexpm1(_x, precision)
        return new_gen(_ret)

    def exponent(x):
        r'''
        When :math:`x` is a :literal:`t_REAL`, the result is the binary exponent :math:`e` of :math:`x`.
        For a nonzero :math:`x`, this is the unique integer :math:`e` such that
        :math:`2^{e} <= \|x\| < 2^{e+1}`. For a real :math:`0`, this returns the PARI exponent :math:`e`
        attached to :math:`x` (which may represent any floating-point number less than
        :math:`2^{e}` in absolute value).

        ::

        ? exponent(Pi)
        %1 = 1
        ? exponent(4.0)
        %2 = 2
        ? exponent(0.0)
        %3 = -128
        ? default(realbitprecision)
        %4 = 128

        This definition extends naturally to nonzero integers,
        and the exponent of an exact :math:`0` is :math:`-oo` by convention.

        For convenience, we :emphasis:`define` the exponent of a :literal:`t_FRAC` :math:`a/b` as
        the difference of :literal:`exponent`:math:`(a)` and :literal:`exponent`:math:`(b)`; note that,
        if :math:`e'` denotes the exponent of :literal:`:math:`a/b` * 1.0`, then the exponent :math:`e`
        we return is either :math:`e'` or :math:`e'+1`, thus :math:`2^{e+1}` is an upper bound for
        :math:`\|a/b\|`.

        ::

        ? [ exponent(9), exponent(10), exponent(9/10), exponent(9/10*1.) ]
        %5 = [3, 3, 0, -1]

        For a PARI object of type :literal:`t_COMPLEX`, :literal:`t_POL`, :literal:`t_SER`, :literal:`t_VEC`,
        :literal:`t_COL`, :literal:`t_MAT` this returns the largest exponent found among the
        components of :math:`x`. Hence :math:`2^{e+1}` is a quick upper bound for the sup norm
        of real matrices or polynomials; and :math:`2^{e+(3/2)}` for complex ones.

        ::

        ? exponent(3*x^2 + 15*x - 100)
        %5 = 6
        ? exponent(0)
        %6 = -oo
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gpexponent(_x)
        return new_gen(_ret)

    def factor(x, D=None):
        r'''
        Factor :math:`x` over domain :math:`D`; if :math:`D` is omitted, it is determined from :math:`x`.
        For instance, if :math:`x` is an integer, it is factored in :math:`\mathbb{Z}`, if it is a
        polynomial with rational coefficients, it is factored in :math:`\mathbb{Q}[x]`, etc., see
        below for details. The result is a two-column matrix: the first contains the
        irreducibles dividing :math:`x` (rational or Gaussian primes, irreducible
        polynomials), and the second the exponents. By convention, :math:`0` is factored
        as :math:`0^{1}`.

        :strong:`:math:`x \in \mathbb{Q}`.`
        See :literal:`factorint` for the algorithms used. The factorization includes the
        unit :math:`-1` when :math:`x < 0` and all other factors are positive; a denominator is
        factored with negative exponents. The factors are sorted in increasing order.

        ::

        ? factor(-7/106)
        %1 =
        [-1 1]
        
        [ 2 -1]
        
        [ 7 1]
        
        [53 -1]

        By convention, :math:`1` is factored as :literal:`matrix(0,2)`
        (the empty factorization, printed as :literal:`[;]`).

        Large rational "primes" :math:`> 2^{64}` in the factorization are in fact
        :emphasis:`pseudoprimes` (see :literal:`ispseudoprime`), a priori not rigorously proven
        primes. Use :literal:`isprime` to prove primality of these factors, as in

        ::

        ? fa = factor(2^2^7 + 1)
        %2 =
        [59649589127497217 1]
        
        [5704689200685129054721 1]
        
        ? isprime( fa[,1] )
        %3 = [1, 1]~ \\ both entries are proven primes

        Another possibility is to globally set the default :literal:`factor_proven`, which
        will perform a rigorous primality proof for each pseudoprime factor but will
        slow down PARI.

        A :literal:`t_INT` argument :math:`D` can be added, meaning that we only trial divide
        by all primes :math:`p < D` and the :literal:`addprimes` entries, then skip all
        expensive factorization methods. The limit :math:`D` must be nonnegative.
        In this case, one entry in the factorization may be a composite number: all
        factors less than :math:`D^{2}` and primes from the :literal:`addprimes` table
        are actual primes. But (at most) one entry may not verify this criterion,
        and it may be prime or composite: it is only known to be coprime to all
        other entries and not a pure power.

        ::

        ? factor(2^2^7 +1, 10^5)
        %4 =
        [340282366920938463463374607431768211457 1]

        :strong:`Deprecated feature.` Setting :math:`D = 0` is the same
        as setting it to :math:`factorlimit + 1`.

        This routine uses trial division and perfect power tests, and should not be
        used for huge values of :math:`D` (at most :math:`10^{9}`, say):
        :literal:`factorint(, 1 + 8)` will in general be faster. The latter does not
        guarantee that all small prime factors are found, but it also finds larger
        factors and in a more efficient way.

        ::

        ? F = (2^2^7 + 1) * 1009 * (10^5+3); factor(F, 10^5) \\ fast, incomplete
        time = 0 ms.
        %5 =
        [1009 1]
        
        [34029257539194609161727850866999116450334371 1]
        
        ? factor(F, 10^9) \\ slow
        time = 3,260 ms.
        %6 =
        [1009 1]
        
        [100003 1]
        
        [340282366920938463463374607431768211457 1]
        
        ? factorint(F, 1+8) \\ much faster and all small primes were found
        time = 8 ms.
        %7 =
        [1009 1]
        
        [100003 1]
        
        [340282366920938463463374607431768211457 1]
        
        ? factor(F) \\ complete factorization
        time = 60 ms.
        %8 =
        [1009 1]
        
        [100003 1]
        
        [59649589127497217 1]
        
        [5704689200685129054721 1]

        :strong:`:math:`x \in \mathbb{Q} (i)`.` The factorization is performed with Gaussian
        primes in :math:`\mathbb{Z}[i]` and includes Gaussian units in :math:`{±1, ± i}`;
        factors are sorted by increasing norm. Except for a possible leading unit,
        the Gaussian factors are normalized: rational factors are positive and
        irrational factors have positive imaginary part.

        Unless :literal:`factor_proven` is set, large factors are actually pseudoprimes,
        not proven primes; a rational factor is prime if less than :math:`2^{64}` and an
        irrational one if its norm is less than :math:`2^{64}`.

        ::

        ? factor(5*I)
        %9 =
        [ 2 + I 1]
        
        [1 + 2*I 1]

        One can force the factorization of a rational number
        by setting the domain :math:`D = I`:

        ::

        ? factor(-5, I)
        %10 =
        [ I 1]
        
        [ 2 + I 1]
        
        [1 + 2*I 1]
        ? factorback(%)
        %11 = -5

        :strong:`Univariate polynomials and rational functions.`
        PARI can factor univariate polynomials in :math:`K[t]`. The following base fields
        :math:`K` are currently supported: :math:`\mathbb{Q}`, :math:`\mathbb{R}`, :math:`\mathbb{C}`, :math:`\mathbb{Q}_{p}`, finite fields and
        number fields. See :literal:`factormod` and :literal:`factorff` for the algorithms used
        over finite fields and :literal:`nffactor` for the algorithms over number fields.
        The irreducible factors are sorted by increasing degree and normalized: they
        are monic except when :math:`K = \mathbb{Q}` where they are primitive in :math:`\mathbb{Z}[t]`.

        The content is :emphasis:`not` included in the factorization, in particular
        :literal:`factorback` will in general recover the original :math:`x` only up to
        multiplication by an element of :math:`K^{*}`: when :math:`K ! = \mathbb{Q}`, this scalar is
        :literal:`pollead`:math:`(x)` (since irreducible factors are monic); and when :math:`K = \mathbb{Q}`
        you can either ask for the :math:`\mathbb{Q}`-content explicitly of use factorback:

        ::

        ? P = t^2 + 5*t/2 + 1; F = factor(P)
        %12 =
        [t + 2 1]
        
        [2*t + 1 1]
        
        ? content(P, 1) \\ Q-content
        %13 = 1/2
        
        ? pollead(factorback(F)) / pollead(P)
        %14 = 2

        You can specify :math:`K` using the optional "domain" argument :math:`D` as follows

        - :math:`K = \mathbb{Q}` : :math:`D` a rational number (:literal:`t_INT` or :literal:`t_FRAC`),

        - :math:`K = \mathbb{Z}/p\mathbb{Z}` with :math:`p` prime : :math:`D` a :literal:`t_INTMOD` modulo :math:`p`;
        factoring modulo a composite number is not supported.

        - :math:`K = \mathbb{F}_{q}` : :math:`D` a :literal:`t_FFELT` encoding the finite field; you can also
        use a :literal:`t_POLMOD` of :literal:`t_INTMOD` modulo a prime :math:`p` but this is usualy
        less convenient;

        - :math:`K = \mathbb{Q}[X]/(T)` a number field : :math:`D` a :literal:`t_POLMOD` modulo :math:`T`,

        - :math:`K = \mathbb{Q} (i)` (alternate syntax for special case): :math:`D = I`,

        - :math:`K = \mathbb{Q} (w)` a quadratic number field (alternate syntax for special
        case): :math:`D` a :literal:`t_QUAD`,

        - :math:`K = \mathbb{R}` : :math:`D` a real number (:literal:`t_REAL`); truncate the factorization
        at accuracy :literal:`precision`:math:`(D)`. If :math:`x` is inexact and :literal:`precision`:math:`(x)`
        is less than :literal:`precision`:math:`(D)`, then the precision of :math:`x` is used instead.

        - :math:`K = \mathbb{C}` : :math:`D` a complex number with a :literal:`t_REAL` component, e.g.
        :literal:`I * 1.`; truncate the factorization as for :math:`K = \mathbb{R}`,

        - :math:`K = \mathbb{Q}_{p}` : :math:`D` a :literal:`t_PADIC`; truncate the factorization at
        :math:`p`-adic accuracy :literal:`padicprec`:math:`(D)`, possibly less if :math:`x` is inexact
        with insufficient :math:`p`-adic accuracy;

        ::

        ? T = x^2+1;
        ? factor(T, 1); \\ over Q
        ? factor(T, Mod(1,3)) \\ over F_3
        ? factor(T, ffgen(ffinit(3,2,'t))^0) \\ over F_{3^2}
        ? factor(T, Mod(Mod(1,3), t^2+t+2)) \\ over F_{3^2}, again
        ? factor(T, O(3^6)) \\ over Q_3, precision 6
        ? factor(T, 1.) \\ over R, current precision
        ? factor(T, I*1.) \\ over C
        ? factor(T, Mod(1, y^3-2)) \\ over Q(2^{1/3})

        In most cases, it is possible and simpler to call a
        specialized variant rather than use the above scheme:

        ::

        ? factormod(T, 3) \\ over F_3
        ? factormod(T, [t^2+t+2, 3]) \\ over F_{3^2}
        ? factormod(T, ffgen(3^2, 't)) \\ over F_{3^2}
        ? factorpadic(T, 3,6) \\ over Q_3, precision 6
        ? nffactor(y^3-2, T) \\ over Q(2^{1/3})
        ? polroots(T) \\ over C
        ? polrootsreal(T) \\ over R (real polynomial)

        It is also possible to let the routine use the smallest field containing all
        coefficients, taking into account quotient structures induced by
        :literal:`t_INTMOD` s and :literal:`t_POLMOD` s (e.g. if a coefficient in :math:`\mathbb{Z}/n\mathbb{Z}` is known,
        all rational numbers encountered are first mapped to :math:`\mathbb{Z}/n\mathbb{Z}`; different
        moduli will produce an error):

        ::

        ? T = x^2+1;
        ? factor(T); \\ over Q
        ? factor(T*Mod(1,3)) \\ over F_3
        ? factor(T*ffgen(ffinit(3,2,'t))^0) \\ over F_{3^2}
        ? factor(T*Mod(Mod(1,3), t^2+t+2)) \\ over F_{3^2}, again
        ? factor(T*(1 + O(3^6)) \\ over Q_3, precision 6
        ? factor(T*1.) \\ over R, current precision
        ? factor(T*(1.+0.*I)) \\ over C
        ? factor(T*Mod(1, y^3-2)) \\ over Q(2^{1/3})

        Multiplying by a suitable field element equal to :math:`1 \in K`
        in this way is error-prone and is not recommanded. Factoring existing
        polynomials with obvious fields of coefficients is fine, the domain
        argument :math:`D` should be used instead ad hoc conversions.

        :strong:`Note on inexact polynomials.`
        Polynomials with inexact coefficients
        (e.g. floating point or :math:`p`-adic numbers)
        are first rounded to an exact representation, then factored to (potentially)
        infinite accuracy and we return a truncated approximation of that
        virtual factorization. To avoid pitfalls, we advise to only factor
        :emphasis:`exact` polynomials:

        ::

        ? factor(x^2-1+O(2^2)) \\ rounded to x^2 + 3, irreducible in Q_2
        %1 =
        [(1 + O(2^2))*x^2 + O(2^2)*x + (1 + 2 + O(2^2)) 1]
        
        ? factor(x^2-1+O(2^3)) \\ rounded to x^2 + 7, reducible !
        %2 =
        [ (1 + O(2^3))*x + (1 + 2 + O(2^3)) 1]
        
        [(1 + O(2^3))*x + (1 + 2^2 + O(2^3)) 1]
        
        ? factor(x^2-1, O(2^2)) \\ no ambiguity now
        %3 =
        [ (1 + O(2^2))*x + (1 + O(2^2)) 1]
        
        [(1 + O(2^2))*x + (1 + 2 + O(2^2)) 1]

        :strong:`Note about inseparable polynomials.` Polynomials with inexact
        coefficients are considered to be squarefree: indeed, there exist a
        squarefree polynomial arbitrarily close to the input, and they cannot be
        distinguished at the input accuracy. This means that irreducible factors are
        repeated according to their apparent multiplicity. On the contrary, using a
        specialized function such as :literal:`factorpadic` with an :emphasis:`exact` rational
        input yields the correct multiplicity when the (now exact) input is not
        separable. Compare:

        ::

        ? factor(z^2 + O(5^2)))
        %1 =
        [(1 + O(5^2))*z + O(5^2) 1]
        
        [(1 + O(5^2))*z + O(5^2) 1]
        ? factor(z^2, O(5^2))
        %2 =
        [1 + O(5^2))*z + O(5^2) 2]

        :strong:`Multivariate polynomials and rational functions.`
        PARI recursively factors :emphasis:`multivariate` polynomials in
        :math:`K[t_{1},..., t_{d}]` for the same fields :math:`K` as above and the argument :math:`D`
        is used in the same way to specify :math:`K`. The irreducible factors are sorted
        by their main variable (least priority first) then by increasing degree.

        ::

        ? factor(x^2 + y^2, Mod(1,5))
        %1 =
        [ x + Mod(2, 5)*y 1]
        
        [Mod(1, 5)*x + Mod(3, 5)*y 1]
        
        ? factor(x^2 + y^2, O(5^2))
        %2 =
        [ (1 + O(5^2))*x + (O(5^2)*y^2 + (2 + 5 + O(5^2))*y + O(5^2)) 1]
        
        [(1 + O(5^2))*x + (O(5^2)*y^2 + (3 + 3*5 + O(5^2))*y + O(5^2)) 1]
        
        ? lift(%)
        %3 =
        [ x + 7*y 1]
        
        [x + 18*y 1]

        Note that the implementation does not really support inexact
        real fields (:math:`\mathbb{R}` or :math:`\mathbb{C}`) and usually misses factors even if the input
        is exact:

        ::

        ? factor(x^2 + y^2, I) \\ over Q(i)
        %4 =
        [x - I*y 1]
        
        [x + I*y 1]
        
        ? factor(x^2 + y^2, I*1.) \\ over C
        %5 =
        [x^2 + y^2 1]
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = factor0(_x, _D)
        return new_gen(_ret)

    def factorback(f, e=None):
        r'''
        Gives back the factored object corresponding to a factorization. The
        integer :math:`1` corresponds to the empty factorization.

        If :math:`e` is present, :math:`e` and :math:`f` must be vectors of the same length (:math:`e` being
        integral), and the corresponding factorization is the product of the
        :math:`f[i]^{e[i]}`.

        If not, and :math:`f` is vector, it is understood as in the preceding case with :math:`e`
        a vector of 1s: we return the product of the :math:`f[i]`. Finally, :math:`f` can be a
        regular factorization, as produced with any :literal:`factor` command. A few
        examples:

        ::

        ? factor(12)
        %1 =
        [2 2]
        
        [3 1]
        
        ? factorback(%)
        %2 = 12
        ? factorback([2,3], [2,1]) \\ 2^2 * 3^1
        %3 = 12
        ? factorback([5,2,3])
        %4 = 30
        '''
        cdef bint _have_e = (e is not None)
        if _have_e:
            e = objtogen(e)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _e = NULL
        if _have_e:
            _e = (<Gen>e).g
        cdef GEN _ret = factorback2(_f, _e)
        return new_gen(_ret)

    def factorcantor(x, p):
        r'''
        This function is obsolete, use factormod.
        '''
        from warnings import warn
        warn('the PARI/GP function factorcantor is obsolete (2018-02-28)', DeprecationWarning)
        p = objtogen(p)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = factmod(_x, _p)
        return new_gen(_ret)

    def factorff(x, p=None, a=None):
        r'''
        Obsolete, kept for backward compatibility: use factormod.
        '''
        from warnings import warn
        warn('the PARI/GP function factorff is obsolete (2018-03-11)', DeprecationWarning)
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        cdef bint _have_a = (a is not None)
        if _have_a:
            a = objtogen(a)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _a = NULL
        if _have_a:
            _a = (<Gen>a).g
        cdef GEN _ret = factorff(_x, _p, _a)
        return new_gen(_ret)

    def factorint(x, long flag=0):
        r'''
        Factors the integer :math:`n` into a product of
        pseudoprimes (see :literal:`ispseudoprime`), using a combination of the
        Shanks SQUFOF and Pollard Rho method (with modifications due to
        Brent), Lenstra's ECM (with modifications by Montgomery), and
        MPQS (the latter adapted from the LiDIA code with the kind
        permission of the LiDIA maintainers), as well as a search for pure powers.
        The output is a two-column matrix as for :literal:`factor`: the first column
        contains the "prime" divisors of :math:`n`, the second one contains the
        (positive) exponents.

        By convention :math:`0` is factored as :math:`0^{1}`, and :math:`1` as the empty factorization;
        also the divisors are by default not proven primes if they are larger than
        :math:`2^{64}`, they only failed the BPSW compositeness test (see
        :literal:`ispseudoprime`). Use :literal:`isprime` on the result if you want to
        guarantee primality or set the :literal:`factor_proven` default to :math:`1`.
        Entries of the private prime tables (see :literal:`addprimes`) are also included
        as is.

        This gives direct access to the integer factoring engine called by most
        arithmetical functions. :emphasis:`flag` is optional; its binary digits mean 1: avoid
        MPQS, 2: skip first stage ECM (we may still fall back to it later), 4: avoid
        Rho and SQUFOF, 8: don't run final ECM (as a result, a huge composite may be
        declared to be prime). Note that a (strong) probabilistic primality test is
        used; thus composites might not be detected, although no example is known.

        You are invited to play with the flag settings and watch the internals at
        work by using :literal:`gp`'s :literal:`debug` default parameter (level 3 shows
        just the outline, 4 turns on time keeping, 5 and above show an increasing
        amount of internal details).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = factorint(_x, flag)
        return new_gen(_ret)

    def factormod(f, D=None, long flag=0):
        r'''
        Factors the polynomial :math:`f` over the finite field defined by the domain
        :math:`D` as follows:

        - :math:`D = p` a prime: factor over :math:`\mathbb{F}_{p}`;

        - :math:`D = [T,p]` for a prime :math:`p` and :math:`T(y)` an irreducible polynomial over
        :math:`\mathbb{F}_{p}`: factor over :math:`\mathbb{F}_{p}[y]/(T)` (as usual the main variable of :math:`T` must have
        lower priority than the main variable of :math:`f`);

        - :math:`D` a :literal:`t_FFELT`: factor over the attached field;

        - :math:`D` omitted: factor over the field of definition of :math:`f`, which
        must be a finite field.

        The coefficients of :math:`f` must be operation-compatible with the corresponding
        finite field. The result is a two-column matrix, the first column being the
        irreducible polynomials dividing :math:`f`, and the second the exponents.
        By convention, the :math:`0` polynomial factors as :math:`0^{1}`; a nonzero constant
        polynomial has empty factorization, a :math:`0 x 2` matrix. The irreducible
        factors are ordered by increasing degree and the result is canonical: it will
        not change across multiple calls or sessions.

        ::

        ? factormod(x^2 + 1, 3) \\ over F_3
        %1 =
        [Mod(1, 3)*x^2 + Mod(1, 3) 1]
        ? liftall( factormod(x^2 + 1, [t^2+1, 3]) ) \\ over F_9
        %2 =
        [ x + t 1]
        
        [x + 2*t 1]
        
        \\ same, now letting GP choose a model
        ? T = ffinit(3,2,'t)
        %3 = Mod(1, 3)*t^2 + Mod(1, 3)*t + Mod(2, 3)
        ? liftall( factormod(x^2 + 1, [T, 3]) )
        %4 = \\ t is a root of T !
        [ x + (t + 2) 1]
        
        [x + (2*t + 1) 1]
        ? t = ffgen(t^2+Mod(1,3)); factormod(x^2 + t^0) \\ same using t_FFELT
        %5 =
        [ x + t 1]
        
        [x + 2*t 1]
        ? factormod(x^2+Mod(1,3))
        %6 =
        [Mod(1, 3)*x^2 + Mod(1, 3) 1]
        ? liftall( factormod(x^2 + Mod(Mod(1,3), y^2+1)) )
        %7 =
        [ x + y 1]
        
        [x + 2*y 1]

        If :math:`flag` is nonzero, outputs only the :emphasis:`degrees` of the irreducible
        polynomials (for example to compute an :math:`L`-function). By convention, a
        constant polynomial (including the :math:`0` polynomial) has empty factorization.
        The degrees appear in increasing order but need not correspond to the
        ordering with :math:`flag = 0` when multiplicities are present.

        ::

        ? f = x^3 + 2*x^2 + x + 2;
        ? factormod(f, 5) \\ (x+2)^2 * (x+3)
        %1 =
        [Mod(1, 5)*x + Mod(2, 5) 2]
        
        [Mod(1, 5)*x + Mod(3, 5) 1]
        ? factormod(f, 5, 1) \\ (deg 1) * (deg 1)^2
        %2 =
        [1 1]
        
        [1 2]
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = factormod0(_f, _D, flag)
        return new_gen(_ret)

    def factormodDDF(f, D=None):
        r'''
        Distinct-degree factorization of the squarefree polynomial :math:`f` over the
        finite field defined by the domain :math:`D` as follows:

        - :math:`D = p` a prime: factor over :math:`\mathbb{F}_{p}`;

        - :math:`D = [T,p]` for a prime :math:`p` and :math:`T` an irreducible polynomial over
        :math:`\mathbb{F}_{p}`: factor over :math:`\mathbb{F}_{p}[x]/(T)`;

        - :math:`D` a :literal:`t_FFELT`: factor over the attached field;

        - :math:`D` omitted: factor over the field of definition of :math:`f`, which
        must be a finite field.

        If :math:`f` is not squarefree, the result is undefined.
        The coefficients of :math:`f` must be operation-compatible with the corresponding
        finite field. The result is a two-column matrix:

        - the first column contains monic (squarefree, pairwise coprime)
        polynomials dividing :math:`f`, all of whose irreducible factors have
        the same degree :math:`d`;

        - the second column contains the degrees of the irreducible factors.

        The factorization is ordered by increasing degree :math:`d` of irreducible factors,
        and the result is obviously canonical.
        This function is somewhat faster than full factorization.

        ::

        ? f = (x^2 + 1) * (x^2-1);
        ? factormodSQF(f,3) \\ squarefree over F_3
        %2 =
        [Mod(1, 3)*x^4 + Mod(2, 3) 1]
        
        ? factormodDDF(f, 3)
        %3 =
        [Mod(1, 3)*x^2 + Mod(2, 3) 1] \\ two degree 1 factors
        
        [Mod(1, 3)*x^2 + Mod(1, 3) 2] \\ irred of degree 2
        
        ? for(i=1,10^5,factormodDDF(f,3))
        time = 424 ms.
        ? for(i=1,10^5,factormod(f,3)) \\ full factorization is a little slower
        time = 464 ms.
        
        ? liftall( factormodDDF(x^2 + 1, [3, t^2+1]) ) \\ over F_9
        %6 =
        [x^2 + 1 1] \\ product of two degree 1 factors
        
        ? t = ffgen(t^2+Mod(1,3)); factormodDDF(x^2 + t^0) \\ same using t_FFELT
        %7 =
        [x^2 + 1 1]
        
        ? factormodDDF(x^2-Mod(1,3))
        %8 =
        [Mod(1, 3)*x^2 + Mod(2, 3) 1]
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = factormodDDF(_f, _D)
        return new_gen(_ret)

    def factormodSQF(f, D=None):
        r'''
        Squarefree factorization of the polynomial :math:`f` over the finite field
        defined by the domain :math:`D` as follows:

        - :math:`D = p` a prime: factor over :math:`\mathbb{F}_{p}`;

        - :math:`D = [T,p]` for a prime :math:`p` and :math:`T` an irreducible polynomial over
        :math:`\mathbb{F}_{p}`: factor over :math:`\mathbb{F}_{p}[x]/(T)`;

        - :math:`D` a :literal:`t_FFELT`: factor over the attached field;

        - :math:`D` omitted: factor over the field of definition of :math:`f`, which
        must be a finite field.

        The coefficients of :math:`f` must be operation-compatible with the corresponding
        finite field. The result is a two-column matrix:

        - the first column contains monic squarefree pairwise coprime polynomials
        dividing :math:`f`;

        - the second column contains the power to which the polynomial in column
        :math:`1` divides :math:`f`;

        This is somewhat faster than full factorization. The factors are ordered by
        increasing exponent and the result is obviously canonical.

        ::

        ? f = (x^2 + 1)^3 * (x^2-1)^2;
        ? factormodSQF(f, 3) \\ over F_3
        %1 =
        [Mod(1, 3)*x^2 + Mod(2, 3) 2]
        
        [Mod(1, 3)*x^2 + Mod(1, 3) 3]
        
        ? for(i=1,10^5,factormodSQF(f,3))
        time = 192 ms.
        ? for(i=1,10^5,factormod(f,3)) \\ full factorization is slower
        time = 409 ms.
        
        ? liftall( factormodSQF((x^2 + 1)^3, [3, t^2+1]) ) \\ over F_9
        %4 =
        [x^2 + 1 3]
        
        ? t = ffgen(t^2+Mod(1,3)); factormodSQF((x^2 + t^0)^3) \\ same using t_FFELT
        %5 =
        [x^2 + 1 3]
        
        ? factormodSQF(x^8 + x^7 + x^6 + x^2 + x + Mod(1,2))
        %6 =
        [ Mod(1, 2)*x + Mod(1, 2) 2]
        
        [Mod(1, 2)*x^2 + Mod(1, 2)*x + Mod(1, 2) 3]
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _ret = factormodSQF(_f, _D)
        return new_gen(_ret)

    def factornf(x, t):
        r'''
        This function is obsolete, use :literal:`nffactor`.

        factorization of the univariate polynomial :math:`x`
        over the number field defined by the (univariate) polynomial :math:`t`. :math:`x` may
        have coefficients in :math:`\mathbb{Q}` or in the number field. The algorithm reduces to
        factorization over :math:`\mathbb{Q}` (Trager's trick). The direct approach of
        :literal:`nffactor`, which uses van Hoeij's method in a relative setting, is
        in general faster.

        The main variable of :math:`t` must be of :emphasis:`lower` priority than that of :math:`x`
        (see ``priority`` (in the PARI manual)). However if nonrational number field elements
        occur (as polmods or polynomials) as coefficients of :math:`x`, the variable of
        these polmods :emphasis:`must` be the same as the main variable of :math:`t`. For
        example

        ::

        ? factornf(x^2 + Mod(y, y^2+1), y^2+1);
        ? factornf(x^2 + y, y^2+1); \\ these two are OK
        ? factornf(x^2 + Mod(z,z^2+1), y^2+1)
        *** at top-level: factornf(x^2+Mod(z,z
        *** ^--------------------
        *** factornf: inconsistent data in rnf function.
        ? factornf(x^2 + z, y^2+1)
        *** at top-level: factornf(x^2+z,y^2+1
        *** ^--------------------
        *** factornf: incorrect variable in rnf function.
        '''
        from warnings import warn
        warn('the PARI/GP function factornf is obsolete (2016-08-08)', DeprecationWarning)
        t = objtogen(t)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = polfnf(_x, _t)
        return new_gen(_ret)

    def factorpadic(pol, p, long r):
        r'''
        :math:`p`-adic factorization
        of the polynomial :emphasis:`pol` to precision :math:`r`, the result being a
        two-column matrix as in :literal:`factor`. Note that this is not the same
        as a factorization over :math:`\mathbb{Z}/p^{r}\mathbb{Z}` (polynomials over that ring do not form a
        unique factorization domain, anyway), but approximations in :math:`\mathbb{Q}/p^{r}\mathbb{Z}` of
        the true factorization in :math:`\mathbb{Q}_{p}[X]`.

        ::

        ? factorpadic(x^2 + 9, 3,5)
        %1 =
        [(1 + O(3^5))*x^2 + O(3^5)*x + (3^2 + O(3^5)) 1]
        ? factorpadic(x^2 + 1, 5,3)
        %2 =
        [ (1 + O(5^3))*x + (2 + 5 + 2*5^2 + O(5^3)) 1]
        
        [(1 + O(5^3))*x + (3 + 3*5 + 2*5^2 + O(5^3)) 1]

        The factors are normalized so that their leading coefficient is a power of
        :math:`p`. The method used is a modified version of the round 4 algorithm of
        Zassenhaus.

        If :emphasis:`pol` has inexact :literal:`t_PADIC` coefficients, this is not always
        well-defined; in this case, the polynomial is first made integral by dividing
        out the :math:`p`-adic content, then lifted to :math:`\mathbb{Z}` using :literal:`truncate`
        coefficientwise.
        Hence we actually factor exactly a polynomial which is only :math:`p`-adically
        close to the input. To avoid pitfalls, we advise to only factor polynomials
        with exact rational coefficients.
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _pol = (<Gen>pol).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = factorpadic(_pol, _p, r)
        return new_gen(_ret)

    def ffcompomap(f, g):
        r'''
        Let :math:`k`, :math:`l`, :math:`m` be three finite fields and :math:`f` a (partial) map from :math:`l`
        to :math:`m` and :math:`g` a (partial) map from :math:`k` to :math:`l`, return the (partial) map :math:`f
        o g` from :math:`k` to :math:`m`.

        ::

        a = ffgen([3,5],'a); b = ffgen([3,10],'b); c = ffgen([3,20],'c);
        m = ffembed(a, b); n = ffembed(b, c);
        rm = ffinvmap(m); rn = ffinvmap(n);
        nm = ffcompomap(n,m);
        ffmap(n,ffmap(m,a)) == ffmap(nm, a)
        %5 = 1
        ffcompomap(rm, rn) == ffinvmap(nm)
        %6 = 1
        '''
        g = objtogen(g)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _g = (<Gen>g).g
        cdef GEN _ret = ffcompomap(_f, _g)
        return new_gen(_ret)

    def ffembed(a, b):
        r'''
        Given two finite fields elements :math:`a` and :math:`b`, return a :emphasis:`map`
        embedding the definition field of :math:`a` to the definition field of :math:`b`.
        Assume that the latter contains the former.

        ::

        ? a = ffgen([3,5],'a);
        ? b = ffgen([3,10],'b);
        ? m = ffembed(a, b);
        ? A = ffmap(m, a);
        ? minpoly(A) == minpoly(a)
        %5 = 1
        '''
        b = objtogen(b)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _ret = ffembed(_a, _b)
        return new_gen(_ret)

    def ffextend(a, P, v=None):
        r'''
        Extend the field :math:`K` of definition of :math:`a` by a root of the polynomial
        :math:`P\in K[X]` assumed to be irreducible over :math:`K`. Return :math:`[r, m]` where :math:`r`
        is a root of :math:`P` in the extension field :math:`L` and :math:`m` is a map from :math:`K` to :math:`L`,
        see :literal:`ffmap`.
        If :math:`v` is given, the variable name is used to display the generator of :math:`L`,
        else the name of the variable of :math:`P` is used.
        A generator of :math:`L` can be recovered using :math:`b = ffgen(r)`.
        The image of :math:`P` in :math:`L[X]` can be recovered using :math:`PL = ffmap(m,P)`.

        ::

        ? a = ffgen([3,5],'a);
        ? P = x^2-a; polisirreducible(P)
        %2 = 1
        ? [r,m] = ffextend(a, P, 'b);
        ? r
        %3 = b^9+2*b^8+b^7+2*b^6+b^4+1
        ? subst(ffmap(m, P), x, r)
        %4 = 0
        ? ffgen(r)
        %5 = b
        '''
        P = objtogen(P)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = ffextend(_a, _P, _v)
        return new_gen(_ret)

    def fffrobenius(m, long n=1):
        r'''
        Return the :math:`n`-th power of the Frobenius map over the field of definition
        of :math:`m`.

        ::

        ? a = ffgen([3,5],'a);
        ? f = fffrobenius(a);
        ? ffmap(f,a) == a^3
        %3 = 1
        ? g = fffrobenius(a, 5);
        ? ffmap(g,a) == a
        %5 = 1
        ? h = fffrobenius(a, 2);
        ? h == ffcompomap(f,f)
        %7 = 1
        '''
        sig_on()
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = fffrobenius(_m, n)
        return new_gen(_ret)

    def ffgen(k, v=None):
        r'''
        Return a generator for the finite field :math:`k` as a :literal:`t_FFELT`.
        The field :math:`k` can be given by

        - its order :math:`q`

        - the pair :math:`[p,f]` where :math:`q = p^{f}`

        - a monic irreducible polynomial with :literal:`t_INTMOD` coefficients modulo a
        prime.

        - a :literal:`t_FFELT` belonging to :math:`k`.

        If :literal:`v` is given, the variable name is used to display :math:`g`, else the
        variable of the polynomial or the :literal:`t_FFELT` is used, else :math:`x` is used.
        For efficiency, the characteristic is not checked to be prime; similarly
        if a polynomial is given, we do not check whether it is irreducible.

        When only the order is specified, the function uses the polynomial generated
        by :literal:`ffinit` and is deterministic: two calls to the function with the
        same parameters will always give the same generator.

        To obtain a multiplicative generator, call :literal:`ffprimroot` on the result
        (which is randomized). Its minimal polynomial then gives a :emphasis:`primitive`
        polynomial, which can be used to redefine the finite field so that all
        subsequent computations use the new primitive polynomial:

        ::

        ? g = ffgen(16, 't);
        ? g.mod \\ recover the underlying polynomial.
        %2 = t^4 + t^3 + t^2 + t + 1
        ? g.pol \\ lift g as a t_POL
        %3 = t
        ? g.p \\ recover the characteristic
        %4 = 2
        ? fforder(g) \\ g is not a multiplicative generator
        %5 = 5
        ? a = ffprimroot(g) \\ recover a multiplicative generator
        %6 = t^3 + t^2 + t
        ? fforder(a)
        %7 = 15
        ? T = minpoly(a) \\ primitive polynomial
        %8 = Mod(1, 2)*x^4 + Mod(1, 2)*x^3 + Mod(1, 2)
        ? G = ffgen(T); \\ is now a multiplicative generator
        ? fforder(G)
        %10 = 15
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _k = (<Gen>k).g
        cdef GEN _ret = ffgen(_k, _v)
        return new_gen(_ret)

    def ffinit(p, long n, v=None):
        r'''
        Computes a monic polynomial of degree :math:`n` which is irreducible over
        :math:`\mathbb{F}_{p}`, where :math:`p` is assumed to be prime. This function uses a fast variant
        of Adleman and Lenstra's algorithm.

        It is useful in conjunction with :literal:`ffgen`; for instance if
        :literal:`P = ffinit(3,2)`, you can represent elements in :math:`\mathbb{F}_{3^{2}}` in term of
        :literal:`g = ffgen(P,'t)`. This can be abbreviated as
        :literal:`g = ffgen(3^2, 't)`, where the defining polynomial :math:`P` can be later
        recovered as :literal:`g.mod`.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = ffinit(_p, n, _v)
        return new_gen(_ret)

    def ffinvmap(m):
        r'''
        :math:`m` being a map from :math:`K` to :math:`L` two finite fields, return the partial map
        :math:`p` from :math:`L` to :math:`K` such that for all :math:`k\in K`, :math:`p(m(k)) = k`.

        ::

        ? a = ffgen([3,5],'a);
        ? b = ffgen([3,10],'b);
        ? m = ffembed(a, b);
        ? p = ffinvmap(m);
        ? u = random(a);
        ? v = ffmap(m, u);
        ? ffmap(p, v^2+v+2) == u^2+u+2
        %7 = 1
        ? ffmap(p, b)
        %8 = []
        '''
        sig_on()
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = ffinvmap(_m)
        return new_gen(_ret)

    def fflog(x, g, o=None):
        r'''
        Discrete logarithm of the finite field element :math:`x` in base :math:`g`,
        i.e. an :math:`e` in :math:`\mathbb{Z}` such that :math:`g^{e} = o`. If
        present, :math:`o` represents the multiplicative order of :math:`g`, see
        ``DLfun`` (in the PARI manual); the preferred format for
        this parameter is :literal:`[ord, factor(ord)]`, where :literal:`ord` is the
        order of :math:`g`. It may be set as a side effect of calling :literal:`ffprimroot`.
        The result is undefined if :math:`e` does not exist. This function uses

        - a combination of generic discrete log algorithms (see :literal:`znlog`)

        - a cubic sieve index calculus algorithm for large fields of degree at
        least :math:`5`.

        - Coppersmith's algorithm for fields of characteristic at most :math:`5`.

        ::

        ? t = ffgen(ffinit(7,5));
        ? o = fforder(t)
        %2 = 5602 \\ not a primitive root.
        ? fflog(t^10,t)
        %3 = 10
        ? fflog(t^10,t, o)
        %4 = 10
        ? g = ffprimroot(t, &o);
        ? o \\ order is 16806, bundled with its factorization matrix
        %6 = [16806, [2, 1; 3, 1; 2801, 1]]
        ? fforder(g, o)
        %7 = 16806
        ? fflog(g^10000, g, o)
        %8 = 10000
        '''
        g = objtogen(g)
        cdef bint _have_o = (o is not None)
        if _have_o:
            o = objtogen(o)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _g = (<Gen>g).g
        cdef GEN _o = NULL
        if _have_o:
            _o = (<Gen>o).g
        cdef GEN _ret = fflog(_x, _g, _o)
        return new_gen(_ret)

    def ffmap(m, x):
        r'''
        Given a (partial) map :math:`m` between two finite fields, return the image of
        :math:`x` by :math:`m`. The function is applied recursively to the component of vectors,
        matrices and polynomials. If :math:`m` is a partial map that is not defined at :math:`x`,
        return :math:`[]`.

        ::

        ? a = ffgen([3,5],'a);
        ? b = ffgen([3,10],'b);
        ? m = ffembed(a, b);
        ? P = x^2+a*x+1;
        ? Q = ffmap(m,P);
        ? ffmap(m,poldisc(P)) == poldisc(Q)
        %6 = 1
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _m = (<Gen>m).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = ffmap(_m, _x)
        return new_gen(_ret)

    def ffmaprel(m, x):
        r'''
        Given a (partial) map :math:`m` between two finite fields, express :math:`x` as an
        algebraic element over the codomain of :math:`m` in a way which is compatible
        with :math:`m`.
        The function is applied recursively to the component of vectors,
        matrices and polynomials.

        ::

        ? a = ffgen([3,5],'a);
        ? b = ffgen([3,10],'b);
        ? m = ffembed(a, b);
        ? mi= ffinvmap(m);
        ? R = ffmaprel(mi,b)
        %5 = Mod(b,b^2+(a+1)*b+(a^2+2*a+2))

        In particular, this function can be used to compute the relative minimal
        polynomial, norm and trace:

        ::

        ? minpoly(R)
        %6 = x^2+(a+1)*x+(a^2+2*a+2)
        ? trace(R)
        %7 = 2*a+2
        ? norm(R)
        %8 = a^2+2*a+2
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _m = (<Gen>m).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = ffmaprel(_m, _x)
        return new_gen(_ret)

    def ffnbirred(q, long n, long flag=0):
        r'''
        Computes the number of monic irreducible polynomials over :math:`\mathbb{F}_{q}`
        of degree exactly :math:`n` (:math:`flag = 0` or omitted) or at most :math:`n` (:math:`flag = 1`).
        '''
        sig_on()
        cdef GEN _q = (<Gen>q).g
        cdef GEN _ret = ffnbirred0(_q, n, flag)
        return new_gen(_ret)

    def fforder(x, o=None):
        r'''
        Multiplicative order of the finite field element :math:`x`. If :math:`o` is
        present, it represents a multiple of the order of the element,
        see ``DLfun`` (in the PARI manual); the preferred format for
        this parameter is :literal:`[N, factor(N)]`, where :literal:`N` is the cardinality
        of the multiplicative group of the underlying finite field.

        ::

        ? t = ffgen(ffinit(nextprime(10^8), 5));
        ? g = ffprimroot(t, &o); \\ o will be useful!
        ? fforder(g^1000000, o)
        time = 0 ms.
        %5 = 5000001750000245000017150000600250008403
        ? fforder(g^1000000)
        time = 16 ms. \\ noticeably slower, same result of course
        %6 = 5000001750000245000017150000600250008403
        '''
        cdef bint _have_o = (o is not None)
        if _have_o:
            o = objtogen(o)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _o = NULL
        if _have_o:
            _o = (<Gen>o).g
        cdef GEN _ret = fforder(_x, _o)
        return new_gen(_ret)

    def ffprimroot(x, o=None):
        r'''
        Return a primitive root of the multiplicative
        group of the definition field of the finite field element :math:`x` (not necessarily
        the same as the field generated by :math:`x`). If present, :math:`o` is set to
        a vector :literal:`[ord, fa]`, where :literal:`ord` is the order of the group
        and :literal:`fa` its factorization :literal:`factor(ord)`. This last parameter is
        useful in :literal:`fflog` and :literal:`fforder`, see ``DLfun`` (in the PARI manual).

        ::

        ? t = ffgen(ffinit(nextprime(10^7), 5));
        ? g = ffprimroot(t, &o);
        ? o[1]
        %3 = 100000950003610006859006516052476098
        ? o[2]
        %4 =
        [2 1]
        
        [7 2]
        
        [31 1]
        
        [41 1]
        
        [67 1]
        
        [1523 1]
        
        [10498781 1]
        
        [15992881 1]
        
        [46858913131 1]
        
        ? fflog(g^1000000, g, o)
        time = 1,312 ms.
        %5 = 1000000
        '''
        cdef bint _have_o = (o is not None)
        if _have_o:
            raise NotImplementedError("optional argument o not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _o = NULL
        cdef GEN _ret = ffprimroot(_x, _o)
        return new_gen(_ret)

    def fft(w, P):
        r'''
        Let :math:`w = [1,z,...,z^{N-1}]` from some primitive :math:`N`-roots of unity :math:`z`
        where :math:`N` is a power of :math:`2`, and :math:`P` be a polynomial :math:`< N`,
        return the unnormalized discrete Fourier transform of :math:`P`,
        :math:`{ P(w[i]), 1 <= i <= N}`. Also allow :math:`P` to be a vector
        :math:`[p_{0},...,p_{n}]` representing the polynomial :math:`\sum_{i} p_{i} X^{i}`.
        Composing :literal:`fft` and :literal:`fftinv` returns :math:`N` times the original input
        coefficients.

        ::

        ? w = rootsof1(4); fft(w, x^3+x+1)
        %1 = [3, 1, -1, 1]
        ? fftinv(w, %)
        %2 = [4, 4, 0, 4]
        ? Polrev(%) / 4
        %3 = x^3 + x + 1
        ? w = powers(znprimroot(5),3); fft(w, x^3+x+1)
        %4 = [Mod(3,5),Mod(1,5),Mod(4,5),Mod(1,5)]
        ? fftinv(w, %)
        %5 = [Mod(4,5),Mod(4,5),Mod(0,5),Mod(4,5)]
        '''
        P = objtogen(P)
        sig_on()
        cdef GEN _w = (<Gen>w).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = FFT(_w, _P)
        return new_gen(_ret)

    def fftinv(w, P):
        r'''
        Let :math:`w = [1,z,...,z^{N-1}]` from some primitive :math:`N`-roots of unity :math:`z`
        where :math:`N` is a power of :math:`2`, and :math:`P` be a polynomial :math:`< N`,
        return the unnormalized discrete Fourier transform of :math:`P`,
        :math:`{ P(1 / w[i]), 1 <= i <= N}`. Also allow :math:`P` to be a vector
        :math:`[p_{0},...,p_{n}]` representing the polynomial :math:`\sum_{i} p_{i} X^{i}`.
        Composing
        :literal:`fft` and :literal:`fftinv` returns :math:`N` times the original input coefficients.

        ::

        ? w = rootsof1(4); fft(w, x^3+x+1)
        %1 = [3, 1, -1, 1]
        ? fftinv(w, %)
        %2 = [4, 4, 0, 4]
        ? Polrev(%) / 4
        %3 = x^3 + x + 1
        
        ? N = 512; w = rootsof1(N); T = random(1000 * x^(N-1));
        ? U = fft(w, T);
        time = 3 ms.
        ? V = vector(N, i, subst(T, 'x, w[i]));
        time = 65 ms.
        ? exponent(V - U)
        %7 = -97
        ? round(Polrev(fftinv(w,U) / N)) == T
        %8 = 1
        '''
        P = objtogen(P)
        sig_on()
        cdef GEN _w = (<Gen>w).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _ret = FFTinv(_w, _P)
        return new_gen(_ret)

    def fileflush(n):
        r'''
        Flushes the file descriptor :math:`n`, created via :literal:`fileopen` or
        :literal:`fileextern`. On files opened for writing, this function forces a write
        of all buffered data to the file system and completes all pending write
        operations. This function is implicitly called by :literal:`fileclose` but you may
        want to call it explicitly at synchronization points, for instance after
        writing a large result to file and before printing diagnostics on screen.
        (In order to be sure that the file contains the expected content on
        inspection.)

        If :math:`n` is omitted, flush all descriptors to output streams.

        ::

        ? n = fileopen("./here", "w");
        ? for (i = 1, 10^5, \
        filewrite(n, i^2+1); \
        if (i % 10000 == 0, fileflush(n)))

        Until a :literal:`fileflush` or :literal:`fileclose`, there is no guarantee
        that the file contains all the expected data from previous :literal:`filewrite` s.
        '''
        sig_on()
        cdef GEN _n = (<Gen>n).g
        gp_fileflush0(_n)
        clear_stack()

    def floor(x):
        r'''
        Floor of :math:`x`. When :math:`x` is in :math:`\mathbb{R}`, the result is the
        largest integer smaller than or equal to :math:`x`. Applied to a rational function,
        :math:`floor (x)` returns the Euclidean quotient of the numerator by the
        denominator.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gfloor(_x)
        return new_gen(_ret)

    def fold(f, A):
        r'''
        Apply the :literal:`t_CLOSURE` :literal:`f` of arity :math:`2` to the entries of :literal:`A`,
        in order to return :literal:`f(...f(f(A[1],A[2]),A[3])...,A[\#A])`.

        ::

        ? fold((x,y)->x*y, [1,2,3,4])
        %1 = 24
        ? fold((x,y)->[x,y], [1,2,3,4])
        %2 = [[[1, 2], 3], 4]
        ? fold((x,f)->f(x), [2,sqr,sqr,sqr])
        %3 = 256
        ? fold((x,y)->(x+y)/(1-x*y),[1..5])
        %4 = -9/19
        ? bestappr(tan(sum(i=1,5,atan(i))))
        %5 = -9/19
        '''
        A = objtogen(A)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _A = (<Gen>A).g
        cdef GEN _ret = fold0(_f, _A)
        return new_gen(_ret)

    def frac(x):
        r'''
        Fractional part of :math:`x`. Identical to
        :math:`x-floor(x)`. If :math:`x` is real, the result is in :math:`[0,1[`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gfrac(_x)
        return new_gen(_ret)

    def fromdigits(x, b=None):
        r'''
        Gives the integer formed by the elements of :math:`x` seen as the digits of a
        number in base :math:`b` (:math:`b = 10` by default); :math:`b` must be an integer satisfying
        :math:`\|b\| > 1`. This is the reverse of :literal:`digits`:

        ::

        ? digits(1234, 5)
        %1 = [1,4,4,1,4]
        ? fromdigits([1,4,4,1,4],5)
        %2 = 1234

        By convention, :math:`0` has no digits:

        ::

        ? fromdigits([])
        %3 = 0

        This function works with :math:`x` a :literal:`t_VECSMALL`; and
        also with :math:`b < 0` or :math:`x[i]` not an actual digit in base :math:`b` (i.e.,
        :math:`x[i] < 0` or :math:`x[i] >= b`): if :math:`x` has length :math:`n`, we return
        :math:`\sum_{i = 1}^{n} x[i] b^{n-i}`.
        '''
        cdef bint _have_b = (b is not None)
        if _have_b:
            b = objtogen(b)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _b = NULL
        if _have_b:
            _b = (<Gen>b).g
        cdef GEN _ret = fromdigits(_x, _b)
        return new_gen(_ret)

    def galoischardet(gal, chi, long o=1):
        r'''
        Let :math:`G` be the group attached to the :literal:`galoisinit`
        structure :emphasis:`gal`, and
        let :math:`\chi` be the character of some representation :math:`\rho` of the group :math:`G`,
        where a polynomial variable is to be interpreted as an :math:`o`-th root of 1.
        For instance, if :literal:`[T,o] = galoischartable(gal)` the characters
        :math:`\chi` are input as the columns of :literal:`T`.

        Return the degree-:math:`1` character :math:`\det\rho` as the list of :math:`\det \rho (g)`,
        where :math:`g` runs through representatives of the conjugacy classes
        in :literal:`galoisconjclasses(gal)`, with the same ordering.

        ::

        ? P = x^5 - x^4 - 5*x^3 + 4*x^2 + 3*x - 1;
        ? polgalois(P)
        %2 = [10, 1, 1, "D(5) = 5:2"]
        ? K = nfsplitting(P);
        ? gal = galoisinit(K); \\ dihedral of order 10
        ? [T,o] = galoischartable(gal);
        ? chi = T[,1]; \\ trivial character
        ? galoischardet(gal, chi, o)
        %7 = [1, 1, 1, 1]~
        ? [galoischardet(gal, T[,i], o) | i <- [1..#T]] \\ all characters
        %8 = [[1, 1, 1, 1]~, [1, 1, -1, 1]~, [1, 1, -1, 1]~, [1, 1, -1, 1]~]
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = galoischardet(_gal, _chi, o)
        return new_gen(_ret)

    def galoischarpoly(gal, chi, long o=1):
        r'''
        Let :math:`G` be the group attached to the :literal:`galoisinit`
        structure :emphasis:`gal`, and
        let :math:`\chi` be the character of some representation :math:`\rho` of the group
        :math:`G`, where a polynomial variable is to be interpreted as an :math:`o`-th root of
        1, e.g., if :literal:`[T,o] = galoischartable(gal)` and :math:`\chi` is a column of
        :literal:`T`.
        Return the list of characteristic polynomials :math:`\det (1 - \rho (g)T)`,
        where :math:`g` runs through representatives of the conjugacy classes
        in :literal:`galoisconjclasses(gal)`, with the same ordering.

        ::

        ? T = x^5 - x^4 - 5*x^3 + 4*x^2 + 3*x - 1;
        ? polgalois(T)
        %2 = [10, 1, 1, "D(5) = 5:2"]
        ? K = nfsplitting(T);
        ? gal = galoisinit(K); \\ dihedral of order 10
        ? [T,o] = galoischartable(gal);
        ? o
        %5 = 5
        ? galoischarpoly(gal, T[,1], o) \\ T[,1] is the trivial character
        %6 = [-x + 1, -x + 1, -x + 1, -x + 1]~
        ? galoischarpoly(gal, T[,3], o)
        %7 = [x^2 - 2*x + 1,
        x^2 + (y^3 + y^2 + 1)*x + 1,
        -x^2 + 1,
        x^2 + (-y^3 - y^2)*x + 1]~
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = galoischarpoly(_gal, _chi, o)
        return new_gen(_ret)

    def galoischartable(gal):
        r'''
        Compute the character table of :math:`G`, where :math:`G` is the underlying group of
        the :literal:`galoisinit` structure :emphasis:`gal`. The input :emphasis:`gal` is also allowed
        to be a :literal:`t_VEC` of permutations that is closed under products.
        Let :math:`N` be the number of conjugacy classes of :math:`G`.
        Return a :literal:`t_VEC` :math:`[M,e]` where :math:`e >= 1` is an integer
        and :math:`M` is a square :literal:`t_MAT` of size :math:`N` giving the character table
        of :math:`G`.

        - Each column corresponds to an irreducible character; the characters
        are ordered by increasing dimension and the first column is the trivial
        character (hence contains only :math:`1`'s).

        - Each row corresponds to a conjugacy class; the conjugacy classes are
        ordered as specified by :literal:`galoisconjclasses(gal)`, in particular the
        first row corresponds to the identity and gives the dimension :math:`\chi (1)`
        of the irreducible representation attached to the successive characters
        :math:`\chi`.

        The value :math:`M[i,j]` of the character :math:`j` at the conjugacy class :math:`i`
        is represented by a polynomial in :literal:`y` whose variable should be
        interpreted as an :math:`e`-th root of unity, i.e. as the lift of

        ::

        Mod(y, polcyclo(e,'y))

        (Note that :math:`M` is the transpose of the usual orientation for
        character tables.)

        The integer :math:`e` divides the exponent of the group :math:`G` and is chosen as small
        as posible; for instance :math:`e = 1` when the characters are all defined over
        :math:`\mathbb{Q}`, as is the case for :math:`S_{n}`. Examples:

        ::

        ? K = nfsplitting(x^4+x+1);
        ? gal = galoisinit(K);
        ? [M,e] = galoischartable(gal);
        ? M~ \\ take the transpose to get the usual orientation
        %4 =
        [1 1 1 1 1]
        
        [1 -1 -1 1 1]
        
        [2 0 0 -1 2]
        
        [3 -1 1 0 -1]
        
        [3 1 -1 0 -1]
        ? e
        %5 = 1
        ? {G = [Vecsmall([1, 2, 3, 4, 5]), Vecsmall([1, 5, 4, 3, 2]),
        Vecsmall([2, 1, 5, 4, 3]), Vecsmall([2, 3, 4, 5, 1]),
        Vecsmall([3, 2, 1, 5, 4]), Vecsmall([3, 4, 5, 1, 2]),
        Vecsmall([4, 3, 2, 1, 5]), Vecsmall([4, 5, 1, 2, 3]),
        Vecsmall([5, 1, 2, 3, 4]), Vecsmall([5, 4, 3, 2, 1])];}
        \\G = D10
        ? [M,e] = galoischartable(G);
        ? M~
        %8 =
        [1 1 1 1]
        
        [1 -1 1 1]
        
        [2 0 -y^3 - y^2 - 1 y^3 + y^2]
        
        [2 0 y^3 + y^2 -y^3 - y^2 - 1]
        ? e
        %9 = 5
        '''
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _ret = galoischartable(_gal)
        return new_gen(_ret)

    def galoisconjclasses(gal):
        r'''
        :emphasis:`gal` being output by :literal:`galoisinit`,
        return the list of conjugacy classes of the underlying group.
        The ordering of the classes is consistent with :literal:`galoischartable`
        and the trivial class comes first.

        ::

        ? G = galoisinit(x^6+108);
        ? galoisidentify(G)
        %2 = [6, 1] \\ S_3
        ? S = galoisconjclasses(G)
        %3 = [[Vecsmall([1,2,3,4,5,6])],
        [Vecsmall([3,1,2,6,4,5]),Vecsmall([2,3,1,5,6,4])],
        [Vecsmall([6,5,4,3,2,1]),Vecsmall([5,4,6,2,1,3]),
        Vecsmall([4,6,5,1,3,2])]]
        ? [[permorder(c[1]),#c] | c <- S ]
        %4 = [[1,1], [3,2], [2,3]]

        This command also accepts subgroups returned by :literal:`galoissubgroups`:

        ::

        ? subs = galoissubgroups(G); H = subs[5];
        ? galoisidentify(H)
        %2 = [2, 1] \\ Z/2
        ? S = galoisconjclasses(subgroups_of_G[5]);
        ? [[permorder(c[1]),#c] | c <- S ]
        %4 = [[1,1], [2,1]]
        '''
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _ret = galoisconjclasses(_gal)
        return new_gen(_ret)

    def galoisexport(gal, long flag=0):
        r'''
        :emphasis:`gal` being be a Galois group as output by :literal:`galoisinit`,
        export the underlying permutation group as a string suitable
        for (no flags or :math:`flag = 0`) GAP or (:math:`flag = 1`) Magma. The following example
        compute the index of the underlying abstract group in the GAP library:

        ::

        ? G = galoisinit(x^6+108);
        ? s = galoisexport(G)
        %2 = "Group((1, 2, 3)(4, 5, 6), (1, 4)(2, 6)(3, 5))"
        ? extern("echo \"IdGroup("s");\" | gap -q")
        %3 = [6, 1]
        ? galoisidentify(G)
        %4 = [6, 1]

        This command also accepts subgroups returned by :literal:`galoissubgroups`.

        To :emphasis:`import` a GAP permutation into gp (for :literal:`galoissubfields` for
        instance), the following GAP function may be useful:

        ::

        PermToGP := function(p, n)
        return Permuted([1..n],p);
        end;
        
        gap> p:= (1,26)(2,5)(3,17)(4,32)(6,9)(7,11)(8,24)(10,13)(12,15)(14,27)
        (16,22)(18,28)(19,20)(21,29)(23,31)(25,30)
        gap> PermToGP(p,32);
        [ 26, 5, 17, 32, 2, 9, 11, 24, 6, 13, 7, 15, 10, 27, 12, 22, 3, 28, 20, 19,
        29, 16, 31, 8, 30, 1, 14, 18, 21, 25, 23, 4 ]
        '''
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _ret = galoisexport(_gal, flag)
        return new_gen(_ret)

    def galoisfixedfield(gal, perm, long flag=0, v=None):
        r'''
        :emphasis:`gal` being be a Galois group as output by :literal:`galoisinit` and
        :emphasis:`perm` an element of :math:`gal.group`, a vector of such elements
        or a subgroup of :emphasis:`gal` as returned by galoissubgroups,
        computes the fixed field of :emphasis:`gal` by the automorphism defined by the
        permutations :emphasis:`perm` of the roots :math:`gal.roots`. :math:`P` is guaranteed to
        be squarefree modulo :math:`gal.p`.

        If no flags or :math:`flag = 0`, output format is the same as for :literal:`nfsubfield`,
        returning :math:`[P,x]` such that :math:`P` is a polynomial defining the fixed field, and
        :math:`x` is a root of :math:`P` expressed as a polmod in :math:`gal.pol`.

        If :math:`flag = 1` return only the polynomial :math:`P`.

        If :math:`flag = 2` return :math:`[P,x,F]` where :math:`P` and :math:`x` are as above and :math:`F` is the
        factorization of :math:`gal.pol` over the field defined by :math:`P`, where
        variable :math:`v` (:math:`y` by default) stands for a root of :math:`P`. The priority of :math:`v`
        must be less than the priority of the variable of :math:`gal.pol` (see
        ``priority`` (in the PARI manual)).
        In this case, :math:`P` is also expressed in the variable :math:`v` for compatibility
        with :math:`F`. Example:

        ::

        ? G = galoisinit(x^4+1);
        ? galoisfixedfield(G,G.group[2],2)
        %2 = [y^2 - 2, Mod(- x^3 + x, x^4 + 1), [x^2 - y*x + 1, x^2 + y*x + 1]]

        computes the factorization :math:`x^{4}+1 = (x^{2}-\sqrt{2}x+1)(x^{2}+\sqrt{2}x+1)`
        '''
        perm = objtogen(perm)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _perm = (<Gen>perm).g
        cdef GEN _ret = galoisfixedfield(_gal, _perm, flag, _v)
        return new_gen(_ret)

    def galoisidentify(gal):
        r'''
        :emphasis:`gal` being be a Galois group as output by :literal:`galoisinit`,
        output the isomorphism class of the underlying abstract group as a
        two-components vector :math:`[o,i]`, where :math:`o` is the group order, and :math:`i` is the
        group index in the GAP4 Small Group library, by Hans Ulrich Besche, Bettina
        Eick and Eamonn O'Brien.

        This command also accepts subgroups returned by :literal:`galoissubgroups`.

        The current implementation is limited to degree less or equal to :math:`127`.
        Some larger "easy" orders are also supported.

        The output is similar to the output of the function :literal:`IdGroup` in GAP4.
        Note that GAP4 :literal:`IdGroup` handles all groups of order less than :math:`2000`
        except :math:`1024`, so you can use :literal:`galoisexport` and GAP4 to identify large
        Galois groups.
        '''
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _ret = galoisidentify(_gal)
        return new_gen(_ret)

    def galoisinit(pol, den=None):
        r'''
        Computes the Galois group
        and all necessary information for computing the fixed fields of the
        Galois extension :math:`K/\mathbb{Q}` where :math:`K` is the number field defined by
        :math:`pol` (monic irreducible polynomial in :math:`\mathbb{Z}[X]` or
        a number field as output by :literal:`nfinit`). The extension :math:`K/\mathbb{Q}` must be
        Galois with Galois group "weakly" super-solvable, see below;
        returns 0 otherwise. Hence this permits to quickly check whether a polynomial
        of order strictly less than :math:`48` is Galois or not.

        The algorithm used is an improved version of the paper
        "An efficient algorithm for the computation of Galois automorphisms",
        Bill Allombert, Math. Comp, vol. 73, 245, 2001, pp. 359--375.

        A group :math:`G` is said to be "weakly" super-solvable if there exists a
        normal series

        :math:`{1} = H_{0} \triangleleft H_{1} \triangleleft...\triangleleft H_{n-1}
        \triangleleft H_{n}`

        such that each :math:`H_{i}` is normal in :math:`G` and for :math:`i < n`, each quotient group
        :math:`H_{i+1}/H_{i}` is cyclic, and either :math:`H_{n} = G` (then :math:`G` is super-solvable) or
        :math:`G/H_{n}` is isomorphic to either :math:`A_{4}`, :math:`S_{4}` or the group
        :math:`(3 x 3):4` (:literal:`GAP4(36,9)`).

        In practice, almost all small groups are WKSS, the exceptions having order
        48(2), 56(1), 60(1), 72(3), 75(1), 80(1), 96(10), 112(1), 120(3) and :math:`>= 144`.

        This function is a prerequisite for most of the :literal:`galois`:math:`xxx` routines.
        For instance:

        ::

        P = x^6 + 108;
        G = galoisinit(P);
        L = galoissubgroups(G);
        vector(#L, i, galoisisabelian(L[i],1))
        vector(#L, i, galoisidentify(L[i]))

        The output is an 8-component vector :emphasis:`gal`.

        :math:`gal[1]` contains the polynomial :emphasis:`pol`
        (:literal:`:emphasis:`gal`.pol`).

        :math:`gal[2]` is a three-components vector :math:`[p,e,q]` where :math:`p` is a
        prime number (:literal:`:emphasis:`gal`.p`) such that :emphasis:`pol` totally split
        modulo :math:`p` , :math:`e` is an integer and :math:`q = p^{e}` (:literal:`:emphasis:`gal`.mod`) is the
        modulus of the roots in :literal:`:emphasis:`gal`.roots`.

        :math:`gal[3]` is a vector :math:`L` containing the :math:`p`-adic roots of
        :emphasis:`pol` as integers implicitly modulo :literal:`:emphasis:`gal`.mod`.
        (:literal:`:emphasis:`gal`.roots`).

        :math:`gal[4]` is the inverse of the Vandermonde matrix of the
        :math:`p`-adic roots of :emphasis:`pol`, multiplied by :math:`gal[5]`.

        :math:`gal[5]` is a multiple of the least common denominator of the
        automorphisms expressed as polynomial in a root of :emphasis:`pol`.

        :math:`gal[6]` is the Galois group :math:`G` expressed as a vector of
        permutations of :math:`L` (:literal:`:emphasis:`gal`.group`).

        :math:`gal[7]` is a generating subset :math:`S = [s_{1},...,s_{g}]` of :math:`G`
        expressed as a vector of permutations of :math:`L` (:literal:`:emphasis:`gal`.gen`).

        :math:`gal[8]` contains the relative orders :math:`[o_{1},...,o_{g}]` of
        the generators of :math:`S` (:literal:`:emphasis:`gal`.orders`).

        Let :math:`H_{n}` be as above, we have the following properties:

        :strong:`*` if :math:`G/H_{n} ~ A_{4}` then :math:`[o_{1},...,o_{g}]` ends by
        :math:`[2,2,3]`.

        :strong:`*` if :math:`G/H_{n} ~ S_{4}` then :math:`[o_{1},...,o_{g}]` ends by
        :math:`[2,2,3,2]`.

        :strong:`*` if :math:`G/H_{n} ~ (3 x 3):4` (:literal:`GAP4(36,9)`) then
        :math:`[o_{1},...,o_{g}]` ends by :math:`[3,3,4]`.

        :strong:`*` for :math:`1 <= i <= g` the subgroup of :math:`G` generated by
        :math:`[s_{1},...,s_{i}]` is normal, with the exception of :math:`i = g-2` in the
        :math:`A_{4}` and :math:`(3 x 3):4` cases and of :math:`i = g-3` in the :math:`S_{4}` case.

        :strong:`*` the relative order :math:`o_{i}` of :math:`s_{i}` is its order in the
        quotient group :math:`G/< s_{1},...,s_{i-1}>`, with the same
        exceptions.

        :strong:`*` for any :math:`x\in G` there exists a unique family
        :math:`[e_{1},...,e_{g}]` such that (no exceptions):

        -- for :math:`1 <= i <= g` we have :math:`0 <= e_{i} < o_{i}`

        -- :math:`x = g_{1}^{e_{1}}g_{2}^{e_{2}}...g_{n}^{e_{n}}`

        If present :math:`den` must be a suitable value for :math:`gal[5]`.
        '''
        cdef bint _have_den = (den is not None)
        if _have_den:
            den = objtogen(den)
        sig_on()
        cdef GEN _pol = (<Gen>pol).g
        cdef GEN _den = NULL
        if _have_den:
            _den = (<Gen>den).g
        cdef GEN _ret = galoisinit(_pol, _den)
        return new_gen(_ret)

    def galoisisabelian(gal, long flag=0):
        r'''
        :emphasis:`gal` being as output by :literal:`galoisinit`, return :math:`0` if
        :emphasis:`gal` is not an abelian group, and the HNF matrix of :emphasis:`gal` over
        :literal:`gal.gen` if :math:`flag = 0`, :math:`1` if :math:`flag = 1`, and the SNF matrix of :emphasis:`gal`
        if :math:`flag = 2`.

        This command also accepts subgroups returned by :literal:`galoissubgroups`.
        '''
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _ret = galoisisabelian(_gal, flag)
        return new_gen(_ret)

    def galoisisnormal(gal, subgrp):
        r'''
        :emphasis:`gal` being as output by :literal:`galoisinit`, and :emphasis:`subgrp` a subgroup
        of :emphasis:`gal` as output by :literal:`galoissubgroups`,return :math:`1` if :emphasis:`subgrp` is a
        normal subgroup of :emphasis:`gal`, else return 0.

        This command also accepts subgroups returned by :literal:`galoissubgroups`.
        '''
        subgrp = objtogen(subgrp)
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _subgrp = (<Gen>subgrp).g
        cdef long _ret = galoisisnormal(_gal, _subgrp)
        clear_stack()
        return _ret

    def galoispermtopol(gal, perm):
        r'''
        :emphasis:`gal` being a
        Galois group as output by :literal:`galoisinit` and :emphasis:`perm` a element of
        :math:`gal.group`, return the polynomial defining the Galois
        automorphism, as output by :literal:`nfgaloisconj`, attached to the
        permutation :emphasis:`perm` of the roots :math:`gal.roots`. :emphasis:`perm` can
        also be a vector or matrix, in this case, :literal:`galoispermtopol` is
        applied to all components recursively.

        Note that

        ::

        G = galoisinit(pol);
        galoispermtopol(G, G[6])~

        is equivalent to :literal:`nfgaloisconj(pol)`, if degree of :emphasis:`pol` is greater
        or equal to :math:`2`.
        '''
        perm = objtogen(perm)
        sig_on()
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _perm = (<Gen>perm).g
        cdef GEN _ret = galoispermtopol(_gal, _perm)
        return new_gen(_ret)

    def galoissplittinginit(P, d=None):
        r'''
        Compute the Galois group over :math:`Q` of the splitting field of :math:`P`, that is the smallest field over which :math:`P` is totally split. :math:`P` is assumed to be integral, monic and irreducible; it can also be given by a :literal:`nf` structure. If :math:`d` is given, it must be a multiple of
        the splitting field degree. The output is compatible with functions expecting
        a :literal:`galoisinit` structure.
        '''
        cdef bint _have_d = (d is not None)
        if _have_d:
            d = objtogen(d)
        sig_on()
        cdef GEN _P = (<Gen>P).g
        cdef GEN _d = NULL
        if _have_d:
            _d = (<Gen>d).g
        cdef GEN _ret = galoissplittinginit(_P, _d)
        return new_gen(_ret)

    def galoissubcyclo(N, H=None, long flag=0, v=None):
        r'''
        Computes the subextension :math:`L` of :math:`\mathbb{Q} (\zeta_{n})` fixed by the subgroup
        :math:`H \subset (\mathbb{Z}/n\mathbb{Z})^{*}`. By the Kronecker-Weber theorem, all abelian number
        fields can be generated in this way (uniquely if :math:`n` is taken to be minimal).
        This function output is somewhat canonical, as it returns the minimal
        polynomial of a Gaussian period :math:`Tr_{\mathbb{Q} (\zeta_{n})/L}(\zeta_{n})`.

        The pair :math:`(n, H)` is deduced from the parameters :math:`(N, H)` as follows

        - :math:`N` an integer: then :math:`n = N`; :math:`H` is a generator, i.e. an
        integer or an integer modulo :math:`n`; or a vector of generators.

        - :math:`N` the output of :literal:`znstar`:math:`(n)` or :literal:`znstar`:math:`(n,1)`.
        :math:`H` as in the first case above, or a matrix, taken to be a HNF left divisor
        of the SNF for :math:`(\mathbb{Z}/n\mathbb{Z})^{*}`
        (:literal:`:math:`N`.cyc`), giving the generators of :math:`H` in terms of :literal:`:math:`N`.gen`.

        - :math:`N` the output of :literal:`bnrinit(bnfinit(y), :math:`m`)` where :math:`m` is a
        module. :math:`H` as in the first case, or a matrix taken to be a HNF left
        divisor of the SNF for the ray class group modulo :math:`m`
        (of type :literal:`:math:`N`.cyc`), giving the generators of :math:`H` in terms of
        :literal:`:math:`N`.bid.gen` ( = :literal:`:math:`N``.gen if :math:`N` includes generators).

        In this last case, beware that :math:`H` is understood relatively to :math:`N`; in
        particular, if the infinite place does not divide the module, e.g if :math:`m` is
        an integer, then it is not a subgroup of :math:`(\mathbb{Z}/n\mathbb{Z})^{*}`, but of its quotient by
        :math:`{± 1}`.

        If :math:`flag = 0`, computes a polynomial (in the variable :emphasis:`v`) defining
        the subfield of :math:`\mathbb{Q} (\zeta_{n})` fixed by the subgroup :emphasis:`H` of
        :math:`(\mathbb{Z}/n\mathbb{Z})^{*}`.

        If :math:`flag = 1`, computes only the conductor of the abelian extension, as a module.

        If :math:`flag = 2`, outputs :math:`[pol, N]`, where :math:`pol` is the polynomial as output when
        :math:`flag = 0` and :math:`N` the conductor as output when :math:`flag = 1`.

        If :math:`flag = 3`; outputs :literal:`galoisinit(pol)`.

        The following function can be used to compute all subfields of
        :math:`\mathbb{Q} (\zeta_{n})` (of exact degree :literal:`d`, if :literal:`d` is set):

        ::

        subcyclo(n, d = -1)=
        { my(bnr,L,IndexBound);
        IndexBound = if (d < 0, n, [d]);
        bnr = bnrinit(bnfinit(y), [n,[1]]);
        L = subgrouplist(bnr, IndexBound, 1);
        vector(#L,i, galoissubcyclo(bnr,L[i]));
        }

        Setting :literal:`L = subgrouplist(bnr, IndexBound)` would produce subfields of
        exact conductor :math:`n oo`.
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = galoissubcyclo(_N, _H, flag, _v)
        return new_gen(_ret)

    def galoissubfields(G, long flag=0, v=None):
        r'''
        Outputs all the subfields of the Galois group :emphasis:`G`, as a vector.
        This works by applying :literal:`galoisfixedfield` to all subgroups. The meaning of
        :math:`flag` is the same as for :literal:`galoisfixedfield`.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _G = (<Gen>G).g
        cdef GEN _ret = galoissubfields(_G, flag, _v)
        return new_gen(_ret)

    def galoissubgroups(G):
        r'''
        Outputs all the subgroups of the Galois group :literal:`gal`. A subgroup is a
        vector [:emphasis:`gen`, :emphasis:`orders`], with the same meaning
        as for :math:`gal.gen` and :math:`gal.orders`. Hence :emphasis:`gen` is a vector of
        permutations generating the subgroup, and :emphasis:`orders` is the relatives
        orders of the generators. The cardinality of a subgroup is the product of the
        relative orders. Such subgroup can be used instead of a Galois group in the
        following command: :literal:`galoisisabelian`, :literal:`galoissubgroups`,
        :literal:`galoisexport` and :literal:`galoisidentify`.

        To get the subfield fixed by a subgroup :emphasis:`sub` of :emphasis:`gal`, use

        ::

        galoisfixedfield(gal,sub[1])
        '''
        sig_on()
        cdef GEN _G = (<Gen>G).g
        cdef GEN _ret = galoissubgroups(_G)
        return new_gen(_ret)

    def gamma(s, long precision=DEFAULT_BITPREC):
        r'''
        For :math:`s` a complex number, evaluates Euler's gamma
        function, which is the analytic continuation of

        .. MATH::

        \Gamma (s) = \int_{0}^{ oo } t^{s-1}\exp (-t)dt, \Re (s) > 0.

        Error if :math:`s` is a nonpositive integer, where :math:`\Gamma` has a (simple) pole.

        ::

        ? gamma(5) \\  Gamma (n) = (n-1)! for a positive integer n
        %1 = 24.000000000000000000000000000000000000
        ? gamma(0)
        *** at top-level: gamma(0)
        *** ^--------
        *** gamma: domain error in gamma: argument = nonpositive integer
        
        ? gamma(x + O(x^3))
        %2 = x^-1 - 0.57721566490153286060651209008240243104 + O(x)

        For :math:`s` a :literal:`t_PADIC`, evaluates the Morita gamma function at :math:`s`, that
        is the unique continuous :math:`p`-adic function on the :math:`p`-adic integers
        extending :math:`\Gamma_{p}(k) = (-1)^{k} \prod_{j < k}'j`, where the prime means that
        :math:`p` does not divide :math:`j`.

        ::

        ? gamma(1/4 + O(5^10))
        %1= 1 + 4*5 + 3*5^4 + 5^6 + 5^7 + 4*5^9 + O(5^10)
        ? algdep(%,4)
        %2 = x^4 + 4*x^2 + 5
        '''
        sig_on()
        cdef GEN _s = (<Gen>s).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ggamma(_s, precision)
        return new_gen(_ret)

    def gammah(x, long precision=DEFAULT_BITPREC):
        r'''
        Gamma function evaluated at the argument :math:`x+1/2`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = ggammah(_x, precision)
        return new_gen(_ret)

    def gammamellininv(G, t, long m=0, long precision=DEFAULT_BITPREC):
        r'''
        Returns the value at :math:`t` of the inverse Mellin transform
        :math:`G` initialized by :literal:`gammamellininvinit`. If the optional parameter
        :math:`m` is present, return the :math:`m`-th derivative :math:`G^{(m)}(t)`.

        ::

        ? G = gammamellininvinit([0]);
        ? gammamellininv(G, 2) - 2*exp(-Pi*2^2)
        %2 = -4.484155085839414627 E-44

        The shortcut

        ::

        gammamellininv(A,t,m)

        for

        ::

        gammamellininv(gammamellininvinit(A,m), t)

        is available.
        '''
        t = objtogen(t)
        sig_on()
        cdef GEN _G = (<Gen>G).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = gammamellininv(_G, _t, m, precision)
        return new_gen(_ret)

    def gammamellininvasymp(A, long serprec=-1, long n=0):
        r'''
        Return the first :math:`n` terms of the asymptotic expansion at infinity
        of the :math:`m`-th derivative :math:`K^{(m)}(t)` of the inverse Mellin transform of the
        function

        .. MATH::

        f(s) = \Gamma_{\mathbb{R}}(s+a_{1})...\Gamma_{\mathbb{R}}(s+a_{d}) ,

        where :literal:`A` is the vector :math:`[a_{1},...,a_{d}]` and
        :math:`\Gamma_{\mathbb{R}}(s) = \pi^{-s/2} \Gamma (s/2)` (Euler's :literal:`gamma`).
        The result is a vector
        :math:`[M[1]...M[n]]` with M[1] = 1, such that

        .. MATH::

        K^{(m)}(t) = \sqrt{2^{d+1}/d}t^{a+m(2/d-1)}e^{-d\pi t^{2/d}}
        \sum_{n >= 0} M[n+1] (\pi t^{2/d})^{-n}

        with :math:`a = (1-d+\sum_{1 <= j <= d}a_{j})/d`. We also allow :math:`A` to be the
        output of :literal:`gammamellininvinit`.
        '''
        sig_on()
        cdef GEN _A = (<Gen>A).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = gammamellininvasymp(_A, serprec, n)
        return new_gen(_ret)

    def gammamellininvinit(A, long m=0, long precision=DEFAULT_BITPREC):
        r'''
        Initialize data for the computation by :literal:`gammamellininv` of
        the :math:`m`-th derivative of the inverse Mellin transform of the function

        .. MATH::

        f(s) = \Gamma_{\mathbb{R}}(s+a_{1})...\Gamma_{\mathbb{R}}(s+a_{d})

        where :literal:`A` is the vector :math:`[a_{1},...,a_{d}]` and
        :math:`\Gamma_{\mathbb{R}}(s) = \pi^{-s/2} \Gamma (s/2)` (Euler's :literal:`gamma`). This is the
        special case of Meijer's :math:`G` functions used to compute :math:`L`-values via the
        approximate functional equation. By extension, :math:`A` is allowed to be an
        :literal:`Ldata` or an :literal:`Linit`, understood as the inverse Mellin transform
        of the :math:`L`-function gamma factor.

        :strong:`Caveat.` Contrary to the PARI convention, this function
        guarantees an :emphasis:`absolute` (rather than relative) error bound.

        For instance, the inverse Mellin transform of :math:`\Gamma_{\mathbb{R}}(s)` is
        :math:`2\exp (-\pi z^{2})`:

        ::

        ? G = gammamellininvinit([0]);
        ? gammamellininv(G, 2) - 2*exp(-Pi*2^2)
        %2 = -4.484155085839414627 E-44

        The inverse Mellin transform of :math:`\Gamma_{\mathbb{R}}(s+1)` is
        :math:`2 z\exp (-\pi z^{2})`, and its second derivative is
        :math:`4\pi z \exp (-\pi z^{2})(2\pi z^{2} - 3)`:

        ::

        ? G = gammamellininvinit([1], 2);
        ? a(z) = 4*Pi*z*exp(-Pi*z^2)*(2*Pi*z^2-3);
        ? b(z) = gammamellininv(G,z);
        ? t(z) = b(z) - a(z);
        ? t(3/2)
        %3 = -1.4693679385278593850 E-39
        '''
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _ret = gammamellininvinit(_A, m, precision)
        return new_gen(_ret)

    def gcd(x, y=None):
        r'''
        Creates the greatest common divisor of :math:`x` and :math:`y`.
        If you also need the :math:`u` and :math:`v` such that :math:`x*u + y*v = \mathrm{gcd} (x,y)`,
        use the :literal:`gcdext` function. :math:`x` and :math:`y` can have rather quite general
        types, for instance both rational numbers. If :math:`y` is omitted and :math:`x` is a
        vector, returns the :math:`gcd` of all components of :math:`x`, i.e. this is
        equivalent to :literal:`content(x)`.

        When :math:`x` and :math:`y` are both given and one of them is a vector/matrix type,
        the GCD is again taken recursively on each component, but in a different way.
        If :math:`y` is a vector, resp. matrix, then the result has the same type as :math:`y`,
        and components equal to :literal:`gcd(x, y[i])`, resp. :literal:`gcd(x, y[,i])`. Else
        if :math:`x` is a vector/matrix the result has the same type as :math:`x` and an
        analogous definition. Note that for these types, :literal:`gcd` is not
        commutative.

        The algorithm used is a naive Euclid except for the following inputs:

        - integers: use modified right-shift binary ("plus-minus"
        variant).

        - univariate polynomials with coefficients in the same number
        field (in particular rational): use modular gcd algorithm.

        - general polynomials: use the subresultant algorithm if
        coefficient explosion is likely (non modular coefficients).

        If :math:`u` and :math:`v` are polynomials in the same variable with :emphasis:`inexact`
        coefficients, their gcd is defined to be scalar, so that

        ::

        ? a = x + 0.0; gcd(a,a)
        %1 = 1
        ? b = y*x + O(y); gcd(b,b)
        %2 = y
        ? c = 4*x + O(2^3); gcd(c,c)
        %3 = 4

        A good quantitative check to decide whether such a
        gcd "should be" nontrivial, is to use :literal:`polresultant`: a value
        close to :math:`0` means that a small deformation of the inputs has nontrivial gcd.
        You may also use :literal:`gcdext`, which does try to compute an approximate gcd
        :math:`d` and provides :math:`u`, :math:`v` to check whether :math:`u x + v y` is close to :math:`d`.
        '''
        cdef bint _have_y = (y is not None)
        if _have_y:
            y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = NULL
        if _have_y:
            _y = (<Gen>y).g
        cdef GEN _ret = ggcd0(_x, _y)
        return new_gen(_ret)

    def gcdext(x, y):
        r'''
        Returns :math:`[u,v,d]` such that :math:`d` is the gcd of :math:`x,y`,
        :math:`x*u+y*v = \mathrm{gcd} (x,y)`, and :math:`u` and :math:`v` minimal in a natural sense.
        The arguments must be integers or polynomials.

        ::

        ? [u, v, d] = gcdext(32,102)
        %1 = [16, -5, 2]
        ? d
        %2 = 2
        ? gcdext(x^2-x, x^2+x-2)
        %3 = [-1/2, 1/2, x - 1]

        If :math:`x,y` are polynomials in the same variable and :emphasis:`inexact`
        coefficients, then compute :math:`u,v,d` such that :math:`x*u+y*v = d`, where :math:`d`
        approximately divides both and :math:`x` and :math:`y`; in particular, we do not obtain
        :literal:`gcd(x,y)` which is :emphasis:`defined` to be a scalar in this case:

        ::

        ? a = x + 0.0; gcd(a,a)
        %1 = 1
        
        ? gcdext(a,a)
        %2 = [0, 1, x + 0.E-28]
        
        ? gcdext(x-Pi, 6*x^2-zeta(2))
        %3 = [-6*x - 18.8495559, 1, 57.5726923]

        For inexact inputs, the output is thus not well defined
        mathematically, but you obtain explicit polynomials to check whether the
        approximation is close enough for your needs.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gcdext0(_x, _y)
        return new_gen(_ret)

    def gcharalgebraic(gc, type=None):
        r'''
        :emphasis:`gc` being the structure returned by :literal:`gcharinit`, returns a :literal:`t_MAT`
        whose columns form a basis of the subgroup of algebraic Grossencharacters in
        :emphasis:`gc` (Weil type A0). The last component is interpreted as a power of the
        norm.

        If :emphasis:`type` is a :literal:`t_VEC` of length :math:`gc.r1+gc.r2`,
        containing a pair of integers :math:`[p_{\tau},q_{\tau}]` for each complex
        embedding :math:`\tau`, returns a :literal:`t_VEC` containing a character whose infinity type
        at :math:`\tau` is

        .. MATH::

        z :---> z^{-p_{\tau}}\bar{z}^{-q_{\tau}}

        if such a character exists, or empty otherwise.
        The full set of characters of that infinity type is obtained by multiplying by
        the group of finite order characters.

        ::

        ? bnf = bnfinit(x^4-2*x^3+23*x^2-22*x+6,1);
        ? gc = gcharinit(bnf,1);
        ? gc.cyc
        % = [6, 0, 0, 0, 0.E-57]
        ? gcharalgebraic(gc)
        % =
        [1 0 0 0]
        [0 1 0 0]
        [0 0 1 0]
        [0 0 0 0]
        [0 0 -1/2 -1]
        ? gcharalgebraic(gc,[[1,1],[0,1]])
        % = [] \\  p_{tau}+q_{tau} must be constant for an algebraic character to exist
        ? chi = gcharalgebraic(gc,[[1,1],[0,2]])[1]
        % = [0, 1, 2, 0, -1]~
        ? for(i=0,5,print(lfuneuler([gc,chi+[i,0,0,0,0]~],3)));
        \\ all characters with this infinity type: multiply by finite order characters

        When the torsion subgroup is not cyclic, we can enumerate the characters of a
        given type with :literal:`forvec`.

        ::

        ? bnf = bnfinit(x^4+15*x^2+45,1);
        ? gc = gcharinit(bnf,1);
        ? gc.cyc
        % = [2, 2, 0, 0, 0, 0.E-57]
        ? [chi] = gcharalgebraic(gc,[[2,0],[2,0]]);
        ? {forvec(v=vectorv(2,i,[0,gc.cyc[i]-1]),
        print(round(lfunan([gc,chi+concat(v,[0,0,0,0]~)],20)));
        )};
        [1, 0, 0, 4, -5, 0, 0, 0, -9, 0, 16, 0, 0, 0, 0, 16, 0, 0, 16, -20]
        [1, 0, 0, -4, 5, 0, 0, 0, 9, 0, 16, 0, 0, 0, 0, 16, 0, 0, -16, -20]
        [1, 0, 0, 4, 5, 0, 0, 0, 9, 0, -16, 0, 0, 0, 0, 16, 0, 0, 16, 20]
        [1, 0, 0, -4, -5, 0, 0, 0, -9, 0, -16, 0, 0, 0, 0, 16, 0, 0, -16, 20]

        Some algebraic Hecke characters are related to CM Abelian varieties. We first
        show an example with an elliptic curve.

        ::

        ? E = ellinit([0, 0, 1, -270, -1708]); \\ elliptic curve with potential CM by Q (sqrt{-3})
        ? bnf = bnfinit(x^2+3,1);
        ? p3 = idealprimedec(bnf,3)[1];
        ? gc = gcharinit(bnf,Mat([p3,2]));
        ? gc.cyc
        % = [0, 0.E-57]
        ? [chi] = gcharalgebraic(gc,[[1,0]])
        % = [[-1, -1/2]~]
        ? LE = lfuncreate(E);
        ? lfunan(LE,20)
        % = [1, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, 5, 0, 0, 4, 0, 0, -7, 0]
        ? Lchi = lfuncreate([gc,chi]);
        ? round(lfunan(Lchi,20))
        % = [1, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0, 0, 5, 0, 0, 4, 0, 0, -7, 0]

        Here is an example with a CM Abelian surface.

        ::

        ? L = lfungenus2([-2*x^4 - 2*x^3 + 2*x^2 + 3*x - 2, x^3]);
        ? bnf = bnfinit(a^4 - a^3 + 2*a^2 + 4*a + 3, 1);
        ? pr = idealprimedec(bnf,13)[1];
        ? gc = gcharinit(bnf,pr);
        ? gc.cyc
        % = [3, 0, 0, 0, 0.E-57]
        ? chitors = [1,0,0,0,0]~;
        ? typ = [[1,0],[1,0]];
        ? [chi0] = gcharalgebraic(gc,typ);
        ? igood = oo; nbgood = 0;
        ? {for(i=0,gc.cyc[1]-1,
        chi = chi0 + i*chitors;
        Lchi = lfuncreate([gc,chi]);
        if(lfunparams(L) == lfunparams(Lchi)
        && exponent(lfunan(L,10) - lfunan(Lchi,10)) < -50,
        igood=i; nbgood++
        );
        )};
        ? nbgood
        % = 1
        ? chi = chi0 + igood*chitors;
        ? Lchi = lfuncreate([gc,chi]);
        ? lfunan(L,30)
        % = [1, 0, -3, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, -4, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, -6, 0, -3, 0]
        ? round(lfunan(Lchi,30))
        % = [1, 0, -3, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, -4, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, -6, 0, -3, 0]
        '''
        cdef bint _have_type = (type is not None)
        if _have_type:
            type = objtogen(type)
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _type = NULL
        if _have_type:
            _type = (<Gen>type).g
        cdef GEN _ret = gcharalgebraic(_gc, _type)
        return new_gen(_ret)

    def gcharconductor(gc, chi):
        r'''
        Returns the conductor of :literal:`chi`, as a modulus over :literal:`gc.bnf`. This is
        the minimum modulus :math:`m` such that
        :math:`U(m)\subsetker(chi)`
        indicating the exact ramification of :emphasis:`chi`.

        - for a real place :math:`v`, :math:`v \| m` iff :math:`\chi_{v}(-1) = -1`.

        - for a finite place :math:`p`, the prime power :math:`p^{e}` divides
        exactly :math:`m` if :math:`e >= 0` is the smallest integer such that :math:`\chi_{p}
        (U_{e}) = 1` where :math:`U_{0} = \mathbb{Z}_{p}^{ x }` and :math:`U_{i} =
        1+p^{i}\mathbb{Z}_{p}` for :math:`i > 0`.

        ::

        ? bnf = bnfinit(x^2-5,1);
        ? gc = gcharinit(bnf,[(13*19)^2,[1,1]]);
        ? gc.cyc
        % = [8892, 6, 2, 0, 0.E-57]
        ? chi = [0,0,1,1]~;
        ? gcharconductor(gc,chi)
        % = [[61009, 7267; 0, 169], [1, 0]]
        ? gcharconductor(gc,13*chi)
        % = [[4693, 559; 0, 13], [1, 0]]
        ? gcharconductor(gc,13*19*chi)
        % = [[247, 65; 0, 13], [1, 0]]
        ? gcharconductor(gc,13*19*168*chi)
        % = [[19, 5; 0, 1], [0, 0]]
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = gchar_conductor(_gc, _chi)
        return new_gen(_ret)

    def gcharduallog(gc, chi):
        r'''
        Returns internal logarithm vector of character :literal:`chi`
        as a :literal:`t_VEC` in :math:`\mathbb{R}^{n}`, so that for all :emphasis:`x`,
        :literal:`gchareval` (:emphasis:`gc`,:emphasis:`chi`,:emphasis:`x`,:math:`0`) is equal to
        :literal:`gcharduallog` (:emphasis:`gc`,:emphasis:`chi`) * :literal:`gcharlog` (:emphasis:`gc`,:emphasis:`x`) in
        :math:`\mathbb{R}/ \mathbb{Z}`.

        The components are organized as follows:

        - the first :literal:`ns` components are in :math:`\mathbb{R}` and describe the character on
        the class group generators: :math:`\theta` encodes :math:`p:--->
        \exp (2i\pi\theta)`,

        - the next :literal:`nc` components are in :math:`\mathbb{R}` and describe the :literal:`idealstar`
        group character via its image on generators: :math:`\theta` encodes the
        image :math:`\exp (2i\pi\theta)`,

        - the next :math:`r_{1}+r_{2}` components are in :math:`\mathbb{R}` and correspond to characters
        of :math:`\mathbb{R}` for each infinite place: :math:`\varphi` encodes :math:`x:--->\|x\|^{i\varphi}` in
        the real case and :math:`z:--->\|z\|^{2i\varphi}` in the complex case,

        - the last :math:`r_{2}` components are in :math:`\mathbb{Z}` and correspond to characters of
        :math:`\mathbb{R}/\mathbb{Z}` for each complex place: :math:`k` encodes :math:`z:---> (z/\|z\|)^{k}`.

        - the last component :math:`s` is in :math:`\mathbb{C}` and corresponds to a
        power :math:`\|.\|^{s}` of the adélic norm.

        See also :literal:`gcharlog`.

        ::

        ? bnf = bnfinit(x^3+4*x-1,1);
        ? gc = gcharinit(bnf,[1,[1]]);
        ? gc.cyc
        % = [2, 0, 0, 0.E-57]
        ? chi = [0,1,0]~;
        ? f = gcharduallog(gc,chi)
        % = [0.153497221319231, 1/2, 0.776369647248353, -0.388184823624176, 1, 0]
        ? pr = idealprimedec(bnf,2)[1];
        ? v = gcharlog(gc,pr);
        ? exp(2*I*Pi*f*v)
        % = -0.569867696226731232993110144 - 0.821736459454756074068598760*I
        ? gchareval(gc,chi,pr)
        % = -0.569867696226731232993110144 - 0.821736459454756074068598760*I
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = gcharduallog(_gc, _chi)
        return new_gen(_ret)

    def gchareval(gc, chi, x, long flag=1):
        r'''
        :emphasis:`gc` being the structure returned by :literal:`gcharinit`, :emphasis:`chi` a
        character in :emphasis:`gc`, and :emphasis:`x` an ideal of the base field, returns the
        value :math:`\chi (x)`. If :math:`flag = 1` (default), returns a value in :math:`\mathbb{C}^{ x }`;
        if :math:`flag = 0`, returns a value in :math:`\mathbb{C}/\mathbb{Z}`, normalized so that the real part is
        between :math:`-1/2` and :math:`1/2`.

        ::

        ? bnf = bnfinit(x^2-5);
        ? gc = gcharinit(bnf,1);
        ? chi = [1]~;
        ? pr = idealprimedec(bnf,11)[1];
        ? a = gchareval(gc,chi,pr)
        % = -0.3804107379142448929315340886 - 0.9248176417432464199580504588*I
        ? b = gchareval(gc,chi,pr,0)
        % = -0.3121086861831031476247589216
        ? a == exp(2*Pi*I*b)
        %7 = 1
        '''
        chi = objtogen(chi)
        x = objtogen(x)
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gchareval(_gc, _chi, _x, flag)
        return new_gen(_ret)

    def gcharidentify(gc, Lv, Lchiv, long precision=DEFAULT_BITPREC):
        r'''
        :emphasis:`gc` being a Grossencharacter group as output by :literal:`gcharinit`, :math:`Lv`
        being :literal:`t_VEC` of places :math:`v` encoded by a :literal:`t_INT` (infinite place) or a prime
        ideal structure representing a prime not dividing the modulus of :math:`gc` (finite
        place), and :math:`Lchiv` being a :literal:`t_VEC` of local characters :math:`\chi_{v}` encoded
        by :math:`[k,\varphi]` with :math:`k` a :literal:`t_INT` and :math:`\varphi` a :literal:`t_REAL` or
        :literal:`t_COMPLEX` representing :math:`x:---> sign(x)^{k}\|x\|^{i\varphi}` (real
        place) or :math:`z:---> (z/\|z\|)^{k}\|z\|^{2i\varphi}`(complex place) or by a :literal:`t_REAL`
        or :literal:`t_COMPLEX` :math:`\theta` representing :math:`p :--->\exp (2i\pi \theta)`
        (finite place), returns a Grossencharacter :math:`\psi` belonging to :math:`g` such
        that :math:`\psi_{v} ~ \chi_{v}` for all :math:`v`.
        At finite places, in place of a scalar one can provide a :literal:`t_VEC` whose
        last component is :math:`\theta`, as output by :literal:`gcharlocal`.
        To ensure proper identification, it is recommended to provide all infinite
        places together with a set of primes that generate the ray class group of
        modulus :emphasis:`gc`:literal:`.mod`.

        ::

        ? bnf = bnfinit(x^2-5,1);
        ? gc = gcharinit(bnf,1);
        ? chi = gcharidentify(gc,[2],[[0,13.]]);
        ? gcharlocal(gc,chi,2)
        % = [0, 13.057005210545987626926134713745179631]
        ? pr = idealprimedec(bnf,11)[1];
        ? chi = gcharidentify(gc,[pr],[0.3]);
        ? gchareval(gc,chi,pr,0)
        % = 0.30000006229129706787363344444425752636

        If you know only few digits, it may be a good idea to reduce the current
        precision to obtain a meaningful result.

        ::

        ? bnf = bnfinit(x^2-5,1);
        ? gc = gcharinit(bnf,1);
        ? pr = idealprimedec(bnf,11)[1];
        ? chi = gcharidentify(gc,[pr],[0.184760])
        % = [-420226]~ \\  unlikely to be meaningful
        ? gchareval(gc,chi,pr,0)
        % = 0.18475998070331376194260927294721168954
        ? \p 10
        realprecision = 19 significant digits (10 digits displayed)
        ? chi = gcharidentify(gc,[pr],[0.184760])
        % = [-7]~ \\  probably what we were looking for
        ? gchareval(gc,chi,pr,0)
        % = 0.1847608033
        ? \p 38
        realprecision = 38 significant digits
        ? gchareval(gc,chi,pr,0)
        % = 0.18476080328172203337331245154966763237

        The output may be a quasi-character.

        ::

        ? bnf = bnfinit(x^2-2,1);
        ? gc = gcharinit(bnf,1); gc.cyc
        % = [0, 0.E-57]
        ? gcharidentify(gc,[1,2],[[0,3.5+1/3*I],[0,-3.5+1/3*I]])
        % = [-1, 1/3]~
        '''
        Lv = objtogen(Lv)
        Lchiv = objtogen(Lchiv)
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _Lv = (<Gen>Lv).g
        cdef GEN _Lchiv = (<Gen>Lchiv).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gchar_identify(_gc, _Lv, _Lchiv, precision)
        return new_gen(_ret)

    def gcharinit(bnf, f, long precision=DEFAULT_BITPREC):
        r'''
        :math:`bnf` being a number field output by :literal:`bnfinit` (including
        fundamental units), :math:`f` a modulus, initializes a structure (:literal:`gc`)
        describing the group of Hecke Grossencharacters of modulus :math:`f`.
        (As in :literal:`idealstar`, the finite part of the conductor may be given
        by a factorization into prime ideals, as produced by :literal:`idealfactor`.)

        The following member functions are available
        on the result: :literal:`.bnf` is the underlying :emphasis:`bnf`,
        :literal:`.mod` the modulus, :literal:`.cyc` its elementary divisors.

        The internal representation uses a logarithm map on ideals
        :math:`L: I \to \mathbb{R}^{n}`,
        so that a Hecke Grossencharacter :math:`\chi` can be described by a :math:`n`
        components vector :math:`v` via
        :math:`\chi: a\in I :--->\exp (2i\pi v.{L (a)})`.

        See :literal:`gcharlog` for more details on the map :math:`L`.

        ::

        ? bnf = bnfinit(polcyclo(5),1); \\  initializes number field Q (zeta_5)
        ? pr = idealprimedec(bnf,5)[1]; \\  prime p = (1-zeta_5) above 5
        ? gc = gcharinit(bnf,idealpow(bnf,pr,2)); \\  characters of modulus dividing p^{2}
        ? gc.cyc \\  structure as an abelian group
        % = [0,0,0,0.E-57]
        ? chi = [1,1,-1,0]~; \\  a character
        ? gcharconductor(gc,chi)[1]
        % =
        [5 4 1 4]
        [0 1 0 0]
        [0 0 1 0]
        [0 0 0 1]

        Currently, :literal:`gc` is a row vector with 11 components:

        :math:`gc[1]` is a matrix whose rows describe a system of generators
        of the characters as vectors of :math:`\mathbb{R}^{n}`, under the above description.

        :math:`gc[2]` contains the underlying number field :emphasis:`bnf`
        (:literal:`:emphasis:`gc`.bnf`).

        :math:`gc[3]` contains the underlying number field :emphasis:`nf`
        (:literal:`:emphasis:`gc`.nf`), possibly stored at higher precision than :emphasis:`bnf`.

        :math:`gc[4]` contains data for computing in :math:`(\mathbb{Z}_{K}/f)^{ x }`.

        :math:`gc[5]` is a vector :math:`S` of prime ideals which generate the class group.

        :math:`gc[6]` contains data to compute discrete logarithms with respect to :math:`S`
        in the class group.

        :math:`gc[7]` is a vector :literal:`[Sunits,m]`, where :literal:`Sunits` describes
        the :math:`S`-units of :math:`bnf` and :math:`m` is a relation matrix for internal usage.

        :math:`gc[8]` is
        :literal:`[Vecsmall([evalprec,prec,nfprec]), Vecsmall([ntors,nfree,nalg])]`
        caching precisions and various dimensions.

        :math:`gc[9]` is a vector describing :math:`gc` as a :math:`\mathbb{Z}`-module
        via its SNF invariants (:literal:`:emphasis:`gc`.cyc`), the last component
        representing the norm character.

        :math:`gc[10]` is a vector :literal:`[R,U,Ui]` allowing to convert characters
        from SNF basis to internal combination of generators.

        Specifically, a character :literal:`chi` in SNF basis has coordinates
        :literal:`chi*Ui` in internal basis (the rows of :math:`gc[1]`).

        :math:`gc[11] = m` is the matrix of :math:`L (v)` for all :math:`S`-units :math:`v`.

        :math:`gc[12] = u` is an integral base change matrix such that :math:`gc[1]`
        corresponds to :math:`(mu)^{-1}`.
        '''
        f = objtogen(f)
        sig_on()
        cdef GEN _bnf = (<Gen>bnf).g
        cdef GEN _f = (<Gen>f).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcharinit(_bnf, _f, precision)
        return new_gen(_ret)

    def gcharisalgebraic(gc, chi, type=None):
        r'''
        :emphasis:`gc` being the structure returned by :literal:`gcharinit` and :emphasis:`chi`
        a character on :emphasis:`gc`, returns 1 if and only if :emphasis:`chi` is an algebraic
        (Weil type A0) character, so that its infinity type at every complex
        embedding :math:`\tau` can be written

        .. MATH::

        z :---> z^{-p_{\tau}}\bar{z}^{-q_{\tau}}

        for some pair of integers :math:`(p_{\tau},q_{\tau})`.

        If :emphasis:`type` is given, it is set to the :literal:`t_VEC` of exponents
        :math:`[p_{\tau},q_{\tau}]`.

        ::

        ? bnf = bnfinit(x^4+1,1);
        ? gc = gcharinit(bnf,1);
        ? gc.cyc
        % = [0, 0, 0, 0.E-57]
        ? chi1 = [0,0,1]~;
        ? gcharisalgebraic(gc,chi1)
        % = 0
        ? gcharlocal(gc,chi1,1)
        % = [-3, -0.89110698909568455588720672648627467040]
        ? chi2 = [1,0,0,-3]~;
        ? gcharisalgebraic(gc,chi2,&typ)
        % = 1
        ? typ
        % = [[6, 0], [2, 4]]
        ? gcharlocal(gc,chi2,1)
        % = [-6, 3*I]
        '''
        chi = objtogen(chi)
        cdef bint _have_type = (type is not None)
        if _have_type:
            raise NotImplementedError("optional argument type not available")
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN * _type = NULL
        cdef int _ret = gcharisalgebraic(_gc, _chi, _type)
        clear_stack()
        return _ret

    def gcharlocal(gc, chi, v, long precision=DEFAULT_BITPREC, BID=None):
        r'''
        :literal:`gc` being a gchar structure initialised by :literal:`gcharinit`, returns
        the local component :math:`\chi_{v}`, where :math:`v` is either an integer between :math:`1`
        and :math:`r_{1}+r_{2}` encoding an infinite place, or a prime ideal structure
        encoding a finite place.

        - if :math:`v` is a real place, :math:`\chi_{v}(x) = {\rm sign}(x)^{k}
        \|x\|^{i\varphi}` is encoded as :math:`[k,\varphi]`;

        - if :math:`v` is a complex place, :math:`\chi_{v}(z) = (z/\|z\|)^{k} \|z\|^{2i\varphi}` is
        encoded as :math:`[k,\varphi]`;

        - if :math:`v = p` is a finite place not dividing :emphasis:`gc`:literal:`.mod`,
        :math:`\chi_{v}(\pi_{v}) = \exp (2i\pi \theta)` is encoded as :math:`[\theta]`;

        - if :math:`v = p` is a finite place dividing :emphasis:`gc`:literal:`.mod`,
        we can define a :emphasis:`bid` structure attached to the multiplicative group
        :math:`G = (\mathbb{Z}_{K}/p^{k})^{*}`, where :math:`p^{k}` divides exactly
        :emphasis:`gc`:literal:`.mod` (see :literal:`idealstar`).
        Then :math:`\chi_{v}` is encoded as :math:`[c_{1},...,c_{n},\theta]`
        where :math:`[c_{1},...,c_{n}]` defines a character on :math:`G`
        (see :literal:`gchareval`) and :math:`\chi_{v}(\pi_{v}) = \exp (2i\pi\theta)`.
        This :emphasis:`bid` structure only depends on :literal:`gc` and :math:`v`
        (and not on the character :math:`\chi`);
        it can be recovered through the optional argument :emphasis:`BID`.

        ::

        ? bnf = bnfinit(x^3-x-1);
        ? gc = gcharinit(bnf,1);
        ? gc.cyc
        % = [0, 0, 0.E-57]
        ? chi = [0,1,1/3]~;
        ? pr = idealprimedec(bnf,5)[1];
        ? gcharlocal(gc,chi,1)
        % = [0, -4.8839310048284836274074581373242545693 - 1/3*I]
        ? gcharlocal(gc,chi,2)
        % = [6, 2.4419655024142418137037290686621272847 - 1/3*I]
        ? gcharlocal(gc,chi,pr)
        % = [0.115465135184293124024408915 + 0.0853833331211293579127218326*I]
        ? bnf = bnfinit(x^2+1,1);
        ? pr3 = idealprimedec(bnf,3)[1];
        ? pr5 = idealprimedec(bnf,5)[1];
        ? gc = gcharinit(bnf,[pr3,2;pr5,3]);
        ? gc.cyc
        % = [600, 3, 0, 0.E-57]
        ? chi = [1,1,1]~;
        ? gcharlocal(gc,chi,pr3,&bid)
        % = [1, 1, -21/50]
        ? bid.cyc
        % = [24, 3]
        ? gcharlocal(gc,chi,pr5,&bid)
        % = [98, -0.30120819117478336291229946188762973702]
        ? bid.cyc
        % = [100]
        '''
        chi = objtogen(chi)
        v = objtogen(v)
        cdef bint _have_BID = (BID is not None)
        if _have_BID:
            raise NotImplementedError("optional argument BID not available")
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _v = (<Gen>v).g
        precision = nbits2prec(precision)
        cdef GEN * _BID = NULL
        cdef GEN _ret = gcharlocal(_gc, _chi, _v, precision, _BID)
        return new_gen(_ret)

    def gcharlog(gc, x, long precision=DEFAULT_BITPREC):
        r'''
        Returns the internal (logarithmic) representation of the ideal :math:`x` suitable
        for computations in :math:`gc`, as a :literal:`t_COL` in :math:`\mathbb{R}^{n}`.

        Its :math:`n = ns+nc+(r_{1}+r_{2})+r_{2}+1` components correspond to a
        logarithm map on the group of fractional ideals :math:`L: I \to \mathbb{R}^{n}`, see
        :literal:`gcharinit`.

        More precisely, let :math:`x = (\alpha) \prod p_{i}^{a_{i}}` a
        principalization of :math:`x` on a set :math:`S` of primes generating
        the class group (see :literal:`bnfisprincipal`),
        then the logarithm of :math:`x` is the :literal:`t_COL`

        .. MATH::

        L (x) = [ (a_{i}), \log_{f}(\alpha),
        (\log\|x/\alpha\|_{\tau})/(2\pi),
        (\arg (x/\alpha)_{\tau})/(2\pi),
        (\log N(x))/(2\pi).i ]

        where

        - the exponent vector :math:`(a_{i})` has :literal:`ns` components, where
        :math:`ns = \#S` is the number of prime ideals used to generate the class group,

        - :math:`\log_{f}(\alpha)` is a discrete logarithm of
        :math:`\alpha` in the :literal:`idealstar` group :math:`(\mathbb{Z}_{K}/f)^{ x }`,
        with :literal:`nc` components,

        - :math:`\log\|x/\alpha\|_{\tau}` has :math:`r_{1}+r_{2}` components, one for each
        real embedding and pair of complex embeddings :math:`\tau: K\to\mathbb{C}`
        (and :math:`\|z\|_{\tau} = \|z\|^{2}` for complex :math:`\tau`).

        - :math:`\arg{(x/\alpha)_{\tau}}` has :math:`r_{2}` components, one for each
        pair of complex embeddings :math:`\tau: K\to\mathbb{C}`.

        - :math:`N(x)` is the norm of the ideal :math:`x`.

        ::

        ? bnf = bnfinit(x^3-x^2+5*x+1,1);
        ? gc = gcharinit(bnf,3);
        ? gc.cyc
        % = [3, 0, 0, 0.E-57]
        ? chi = [1,1,0,-1]~;
        ? f = gcharduallog(gc,chi);
        ? pr = idealprimedec(bnf,5)[1];
        ? v = gcharlog(gc,pr)
        % = [2, -5, -1, 0.0188115475004995312411, -0.0188115475004995312411,
        -0.840176314833856764413, 0.256149999363388073738*I]~
        ? exp(2*I*Pi*f*v)
        % = -4.5285995080704456583673312 + 2.1193835177957097598574507*I
        ? gchareval(gc,chi,pr)
        % = -4.5285995080704456583673312 + 2.1193835177957097598574507*I
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcharlog(_gc, _x, precision)
        return new_gen(_ret)

    def gcharnewprec(gc, long precision=DEFAULT_BITPREC):
        r'''
        :math:`gc` being a Grossencharacter group output by :literal:`gcharinit`,
        recomputes its archimedean components ensuring accurate computations to
        current precision.

        It is advisable to increase the precision before computing several
        values at large ideals.
        '''
        sig_on()
        cdef GEN _gc = (<Gen>gc).g
        precision = nbits2prec(precision)
        cdef GEN _ret = gcharnewprec(_gc, precision)
        return new_gen(_ret)

    def genus2igusa(PQ, long k=0):
        r'''
        Let :math:`PQ` be a polynomial :math:`P`, resp. a vector :math:`[P,Q]` of polynomials
        defined over a field :math:`F` of characteristic :math:`! = 2`.
        Returns the Igusa invariants :math:`[J_{2},J_{4},J_{6},J_{8},J_{10}]` of the
        hyperelliptic curve :math:`C/F`, defined by the equation :math:`y^{2} = P(x)`,
        resp. :math:`y^{2} + Q(x)*y = P(x)`. If :math:`k` is given, only return the invariant
        of degree :math:`k` (:math:`k` must be even between :math:`2` and :math:`10`).

        ::

        ? genus2igusa(x^5+3*x^2-4)
        %1 = [0, 9600, 20736, -23040000, 177926144]
        ? genus2igusa([x^6+x^5-x^4+3*x^3+x^2-2*x+1,x^3-x^2+x-1])
        %2 = [-788, 1958, 341220, -68178781, -662731520]
        ? genus2igusa([x^6+x^5-x^4+3*x^3+x^2-2*x+1,x^3-x^2+x-1],4)
        %3 = 1958
        ? genus2igusa(x^5+3*Mod(a,a^2-3)*x^2-4) \\ {over Q (sqrt{3})}
        %4 = [Mod(0, a^2 - 3), Mod(9600*a, a^2 - 3), Mod(186624, a^2 - 3),
        Mod(-69120000, a^2 - 3), Mod(-241864704*a + 204800000, a^2 - 3)]
        ? a = ffgen(3^4,'a); \\ {over F_{3^4} = F_3[a]}
        ? genus2igusa(x^6+a*x^5-a*x^4+2*x^3+a*x+a+1)
        %6 = [2*a^2, a^3 + a^2 + a + 1, a^2 + a + 2, 2*a^3 + 2*a^2 + a + 1,
        2*a^2 + 2]
        ? a = ffgen(2^4,'a); \\ {F_{2^4} = F_2[a]}
        ? genus2igusa(x^6+a*x^5+a*x^4+a*x+a+1) \\ doesn't work in characteristic 2
        *** at top-level: genus2igusa(x^6+a*x^5+a*x^4+a*x+a+1)
        *** ^------------------------------------
        *** genus2igusa: impossible inverse in FF_mul2n: 2.
        '''
        sig_on()
        cdef GEN _PQ = (<Gen>PQ).g
        cdef GEN _ret = genus2igusa(_PQ, k)
        return new_gen(_ret)

    def genus2red(PQ, p=None):
        r'''
        Let :math:`PQ` be a polynomial :math:`P`, resp. a vector :math:`[P,Q]` of polynomials, with
        rational coefficients.
        Determines the reduction at :math:`p > 2` of the (proper, smooth) genus 2
        curve :math:`C/\mathbb{Q}`, defined by the hyperelliptic equation :math:`y^{2} = P(x)`, resp.
        :math:`y^{2} + Q(x)*y = P(x)`.
        (The special fiber :math:`X_{p}` of the minimal regular model :math:`X` of :math:`C` over :math:`\mathbb{Z}`.)

        If :math:`p` is omitted, determines the reduction type for all (odd) prime
        divisors of the discriminant.

        This function was rewritten from an implementation of Liu's
        algorithm by Cohen and Liu (1994), :literal:`genus2reduction-0.3`, see
        :literal:`https://www.math.u-bordeaux.fr/~liu/G2R/`.

        :strong:`CAVEAT.` The function interface may change: for the
        time being, it returns :math:`[N,FaN, [P_{m}, Q_{m}], V]`
        where :math:`N` is either the local conductor at :math:`p` or the
        global conductor, :emphasis:`FaN` is its factorization, :math:`y^{2} +Q_{m} y = P_{m}`
        defines a
        minimal model over :math:`\mathbb{Z}` and :math:`V` describes the reduction type at the
        various considered :math:`p`. Unfortunately, the program is not complete for
        :math:`p = 2`, and we may return the odd part of the conductor only: this is the
        case if the factorization includes the (impossible) term :math:`2^{-1}`; if the
        factorization contains another power of :math:`2`, then this is the exact local
        conductor at :math:`2` and :math:`N` is the global conductor.

        ::

        ? default(debuglevel, 1);
        ? genus2red(x^6 + 3*x^3 + 63, 3)
        (potential) stable reduction: [1, []]
        reduction at p: [III{9}] page 184, [3, 3], f = 10
        %1 = [59049, Mat([3, 10]), x^6 + 3*x^3 + 63, [3, [1, []],
        ["[III{9}] page 184", [3, 3]]]]
        ? [N, FaN, T, V] = genus2red(x^3-x^2-1, x^2-x); \\ X_1(13), global reduction
        p = 13
        (potential) stable reduction: [5, [Mod(0, 13), Mod(0, 13)]]
        reduction at p: [I{0}-II-0] page 159, [], f = 2
        ? N
        %3 = 169
        ? FaN
        %4 = Mat([13, 2]) \\ in particular, good reduction at 2 !
        ? T
        %5 = x^6 + 58*x^5 + 1401*x^4 + 18038*x^3 + 130546*x^2 + 503516*x + 808561
        ? V
        %6 = [[13, [5, [Mod(0, 13), Mod(0, 13)]], ["[I{0}-II-0] page 159", []]]]

        We now first describe the format of the vector :math:`V = V_{p}` in the case where
        :math:`p` was specified (local reduction at :math:`p`): it is a triple :math:`[p, stable,
        red]`. The component :math:`stable = [type, vecj]` contains
        information about the stable reduction after a field extension;
        depending on :emphasis:`type` s, the stable reduction is

        - 1: smooth (i.e. the curve has potentially good reduction). The
        Jacobian :math:`J(C)` has potentially good reduction.

        - 2: an elliptic curve :math:`E` with an ordinary double point; :emphasis:`vecj`
        contains :math:`j` mod :math:`p`, the modular invariant of :math:`E`. The (potential)
        semi-abelian reduction of :math:`J(C)` is the extension of an elliptic curve (with
        modular invariant :math:`j` mod :math:`p`) by a torus.

        - 3: a projective line with two ordinary double points. The Jacobian
        :math:`J(C)` has potentially multiplicative reduction.

        - 4: the union of two projective lines crossing transversally at three
        points. The Jacobian :math:`J(C)` has potentially multiplicative reduction.

        - 5: the union of two elliptic curves :math:`E_{1}` and :math:`E_{2}` intersecting
        transversally at one point; :emphasis:`vecj` contains their modular invariants
        :math:`j_{1}` and :math:`j_{2}`, which may live in a quadratic extension of :math:`\mathbb{F}_{p}`
        and need not be distinct. The Jacobian :math:`J(C)` has potentially good reduction,
        isomorphic to the product of the reductions of :math:`E_{1}` and :math:`E_{2}`.

        - 6: the union of an elliptic curve :math:`E` and a projective line which has
        an ordinary double point, and these two components intersect transversally
        at one point; :emphasis:`vecj` contains :math:`j` mod :math:`p`, the modular invariant of :math:`E`.
        The (potential) semi-abelian reduction of :math:`J(C)` is the extension of an
        elliptic curve (with modular invariant :math:`j` mod :math:`p`) by a torus.

        - 7: as in type 6, but the two components are both singular. The
        Jacobian :math:`J(C)` has potentially multiplicative reduction.

        The component :math:`red = [NUtype, neron]` contains two data
        concerning the reduction at :math:`p` without any ramified field extension.

        The :emphasis:`NUtype` is a :literal:`t_STR` describing the reduction at :math:`p` of :math:`C`,
        following Namikawa-Ueno, :emphasis:`The complete classification of fibers in
        pencils of curves of genus two`, Manuscripta Math., vol. 9, (1973), pages
        143-186. The reduction symbol is followed by the corresponding page number
        or page range in this article.

        The second datum :emphasis:`neron` is the group of connected components (over an
        algebraic closure of :math:`\mathbb{F}_{p}`) of the Néron model of :math:`J(C)`, given as a
        finite abelian group (vector of elementary divisors).

        If :math:`p = 2`, the :emphasis:`red` component may be omitted altogether (and
        replaced by :literal:`[]`, in the case where the program could not compute it.
        When :math:`p` was not specified, :math:`V` is the vector of all :math:`V_{p}`, for all
        considered :math:`p`.

        :strong:`Notes about Namikawa-Ueno types.`

        - A lower index is denoted between braces: for instance,
        :literal:`[I{2}-II-5]` means :literal:`[I_2-II-5]`.

        - If :math:`K` and :math:`K'` are Kodaira symbols for singular fibers of elliptic
        curves, then :literal:`[:math:`K`-:math:`K'`-m]` and :literal:`[:math:`K'`-:math:`K`-m]` are the same.

        We define a total ordering on Kodaira symbol by fixing :math:`I < I* <
        II < II*,...`. If the reduction type is the same, we order by
        the number of components, e.g. :math:`I_{2} < I_{4}`, etc.
        Then we normalize our output so that :math:`K <= K'`.

        - :literal:`[:math:`K`-:math:`K'`-:math:`-1`]` is :literal:`[:math:`K`-:math:`K'`-:math:`\alpha`]` in the notation of
        Namikawa-Ueno.

        - The figure :literal:`[2I_0-m]` in Namikawa-Ueno, page 159, must be denoted
        by :literal:`[2I_0-(m+1)]`.
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _PQ = (<Gen>PQ).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = genus2red(_PQ, _p)
        return new_gen(_ret)

    def halfgcd(x, y):
        r'''
        Let inputs :math:`x` and :math:`y` be both integers, or both polynomials in the same
        variable. Return a vector :literal:`[M, [a,b]~]`, where :math:`M` is an invertible
        :math:`2 x 2` matrix such that :literal:`M*[x,y]~ = [a,b]~`, where :math:`b` is
        small. More precisely,

        - polynomial case: :math:`\det M` has degree :math:`0` and we
        have

        .. MATH::

        \deg a >= ceil{\max (\deg x,\deg y))/2} > \deg b.

        - integer case: :math:`\det M = ± 1` and we have
        

        .. MATH::

        a >= ceil{\sqrt{\max (\|x\|,\|y\|)}} > b.

        Assuming :math:`x` and :math:`y` are nonnegative, then :math:`M^{-1}` has nonnegative
        coefficients, and :math:`\det M` is equal to the sign of both main diagonal terms
        :math:`M[1,1]` and :math:`M[2,2]`.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = ghalfgcd(_x, _y)
        return new_gen(_ret)

    def hammingweight(x):
        r'''
        If :math:`x` is a :literal:`t_INT`, return the binary Hamming weight of :math:`\|x\|`. Otherwise
        :math:`x` must be of type :literal:`t_POL`, :literal:`t_VEC`, :literal:`t_COL`, :literal:`t_VECSMALL`, or
        :literal:`t_MAT` and the function returns the number of nonzero coefficients of
        :math:`x`.

        ::

        ? hammingweight(15)
        %1 = 4
        ? hammingweight(x^100 + 2*x + 1)
        %2 = 3
        ? hammingweight([Mod(1,2), 2, Mod(0,3)])
        %3 = 2
        ? hammingweight(matid(100))
        %4 = 100
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = hammingweight(_x)
        clear_stack()
        return _ret

    def hgmalpha(H):
        r'''
        Returns the alpha and beta parameters of the hypergeometric motive
        template :math:`H`.

        ::

        ? H = hgminit([5]); \\ template given by cyclotomic parameters
        ? hgmalpha(H)
        %2 = [[1/5, 2/5, 3/5, 4/5], [0, 0, 0, 0]]
        '''
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _ret = hgmalpha(_H)
        return new_gen(_ret)

    def hgmcoef(H, t, n):
        r'''
        :math:`(H,t)` being a hypergeometric motive, returns the
        :math:`n`-th coefficient of its :math:`L`-function. This is not implemented for wild
        primes :math:`p` and will raise an exception if such a :math:`p` divides :math:`n`.
        '''
        t = objtogen(t)
        n = objtogen(n)
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = hgmcoef(_H, _t, _n)
        return new_gen(_ret)

    def hgmcoefs(H, t, long n):
        r'''
        :math:`(H,t)` being a hypergeometric motive, returns the
        first :math:`n` coefficients of its :math:`L`-function, where Euler factors at wild primes
        are set to 1. The argument :math:`t` may be replaced by :math:`[t,bad]`
        where :emphasis:`bad` is a vector of pairs :math:`[p,L_{p}]`, :math:`p` being a prime and :math:`L_{p}`
        being the corresponding local Euler factor, overriding the default.

        If you hope that the wild Euler factors can be computed not too slowly
        from the functional equation, you can also set :literal:`L = lfunhgm(H,t)`, and then
        :literal:`lfunan(L,n)`, and then the Euler factors at wild primes should
        be correct.
        '''
        t = objtogen(t)
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = hgmcoefs(_H, _t, n)
        return new_gen(_ret)

    def hgmcyclo(H):
        r'''
        Returns the cyclotomic parameters :math:`(D,E)` of the
        hypergeometric motive template :math:`H`.

        ::

        \\ template given by alpha (implied beta is [0,0,0,0])
        ? H = hgminit([1/5, 2/5, 3/5, 4/5]);
        ? hgmcyclo(H)
        %3 = [Vecsmall([5]), Vecsmall([1, 1, 1, 1])]
        ? apply(Vec, %) \\ for readability
        %4 = [[5], [1, 1, 1, 1]]
        '''
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _ret = hgmcyclo(_H)
        return new_gen(_ret)

    def hgmeulerfactor(H, t, long p, e=None):
        r'''
        :math:`(H,t)` being a hypergeometric motive, returns the inverse of its
        Euler factor at the prime :math:`p` and the exponent :math:`e` of the conductor at :math:`p`.
        This is not implemented when :math:`p` is a wild prime: the function returns :math:`0` and
        sets :math:`e` to :math:`-1`. Caveat: contrary to :literal:`lfuneuler`, this function returns
        the :emphasis:`inverse` of the Euler factor, given by a polynomial :math:`P_{p}` such that
        the Euler factor is :math:`1 / P_{p}(p^{-s})`.

        ::

        ? H = hgminit([5]); \\ cyclotomic parameters [5] and [1,1,1,1]
        ? hgmeulerfactor(H, 1/2, 3)
        %2 = 729*x^4 + 135*x^3 + 45*x^2 + 5*x + 1
        ? hgmeulerfactor(H, 1/2, 3, &e)
        %3 = 729*x^4 + 135*x^3 + 45*x^2 + 5*x + 1
        ? e
        %4 = 0
        ? hgmeulerfactor(H, 1/2, 2, &e)
        %5 = -x + 1
        ? e
        %6 = 3
        ? hgmeulerfactor(H, 1/2, 5)
        %7 = 0 \\ 5 is wild

        If the conductor is small, the wild Euler factors can be computed
        from the functional equation: set :literal:`L = lfunhgm(H,t)` (the complexity
        should be roughly proportional to the conductor) then
        the :literal:`lfuneuler` function should give you the correct Euler factors
        at all primes:

        ::

        ? L = lfunhgm(H, 1/2);
        time = 790 ms. \\ fast in this case, only 5 is wild
        ? lfunparams(L) \\ ... and the conductor 5000 is small
        %8 = [5000, 4, [-1, 0, 0, 1]]
        ? lfuneuler(L, 5)
        %9 = 1 \\ trivial Euler factor
        
        ? L = lfunhgm(H, 1/64); lfunparams(L)
        time = 20,122 ms. \\ slower: the conductor is larger
        %10 = [525000, 4, [-1, 0, 0, 1]]
        
        ? L = lfunhgm(H, 1/128); lfunparams(L)
        time = 2min, 16,205 ms. \\ even slower, etc.
        %11 = [3175000, 4, [-1, 0, 0, 1]]
        '''
        t = objtogen(t)
        cdef bint _have_e = (e is not None)
        if _have_e:
            raise NotImplementedError("optional argument e not available")
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN * _e = NULL
        cdef GEN _ret = hgmeulerfactor(_H, _t, p, _e)
        return new_gen(_ret)

    def hgmgamma(H):
        r'''
        Returns the gamma vector of the hypergeometric motive
        template :math:`H`.

        ::

        ? H = hgminit([5]);
        ? hgmgamma(H)
        %2 = Vecsmall([-5, 0, 0, 0, 1])
        '''
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _ret = hgmgamma(_H)
        return new_gen(_ret)

    def hgminit(a, b=None):
        r'''
        Create the template for the hypergeometric motive with parameters
        :math:`a` and possibly :math:`b`. The format of the parameters may be

        - alpha: lists of rational numbers :math:`a = (\alpha_{j})` and
        :math:`b = (\beta_{k})` of the same length (and defined over :math:`\mathbb{Q}`); if :math:`b` is
        omitted, we take it to be :math:`(0,...,0)`.

        - cyclo: lists :math:`a = D` and :math:`b = E` of positive integers corresponding
        to the denominators of the :math:`(\alpha_{i})` and :math:`(\beta_{i})`; if :math:`b` is omitted
        we take it to be :math:`(1,...,1)`. This is the simplest and most compact input
        format.

        - gamma: list of :math:`\gamma_{n}` such that the
        :math:`\prod_{j}(x-\exp (2\pi i\alpha_{j})) / \prod_{k}(x-\exp (2\pi i\beta_{k}))
        = \prod_{n}(x^{n}-1)^{\gamma_{n}}`.

        The hypergeometric motive itself is given by a pair :math:`(H,t)`, where :math:`H`
        is a template as above and :math:`t\in \mathbb{Q}^{*}`. Note that the motives given by
        :math:`(\alpha, \beta; t)` and :math:`(\beta,\alpha; 1/t)` are identical.

        ::

        ? H = hgminit([5]); \\ template given by cyclotomic parameters 5 and 1,1,1,1
        ? L = lfunhgm(H, 1); \\ global L-function attached to motive (H,1)
        ? lfunparams(L)
        %3 = [25, 4, [0, 1]]
        
        ? hgmalpha(H)
        %4 = [[1/5, 2/5, 3/5, 4/5], [0, 0, 0, 0]]
        ? hgmgamma(H)
        %5 = Vecsmall([-5, 0, 0, 0, 1])
        '''
        cdef bint _have_b = (b is not None)
        if _have_b:
            b = objtogen(b)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = NULL
        if _have_b:
            _b = (<Gen>b).g
        cdef GEN _ret = hgminit(_a, _b)
        return new_gen(_ret)

    def hgmissymmetrical(H):
        r'''
        Is the hypergeometric motive template :math:`H` symmetrical
        at :math:`t = 1`? This means that the :math:`\alpha_{j}` and :math:`\beta_{k}` defining the
        template are obtained from one another by adding :math:`1/2` (modulo :math:`1`), see
        :literal:`hgmtwist`.

        ::

        ? H = hgminit([2,2]);
        ? hgmalpha(H)
        %2 = [[1/2, 1/2], [0, 0]]
        ? hgmissymmetrical(H)
        %3 = 1 \\ this template is symmetrical
        
        ? H = hgminit([5]);
        ? hgmalpha(H)
        %5 = [[1/5, 2/5, 3/5, 4/5], [0, 0, 0, 0]]
        ? hgmissymmetrical(H)
        %6 = 1 \\ this one is not
        '''
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef long _ret = hgmissymmetrical(_H)
        clear_stack()
        return _ret

    def hgmparams(H):
        r'''
        :math:`H` being a hypergeometric motive template, returns
        :math:`[d,w,[P,T], M]`, where :math:`d` is the degree, :math:`w` the weight,
        :math:`P` the Hodge polynomial, and :math:`T` the Tate twist number (so that the Hodge
        function itself is :math:`P/x^{T}`); finally the normalizing factor :math:`M` is the
        so-called :math:`M`-value, :math:`M = \prod_{n} n^{n\gamma_{n}}`.
        '''
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _ret = hgmparams(_H)
        return new_gen(_ret)

    def hgmtwist(H):
        r'''
        Twist by :math:`1/2` of alpha and beta of the hypergeometric motive
        template :math:`H`.

        ::

        ? H = hgminit([5]);
        ? hgmalpha(H)
        %2 = [[1/5, 2/5, 3/5, 4/5], [0, 0, 0, 0]]
        ? H2 = hgmtwist(H);
        ? hgmalpha(H2)
        %4 = [[1/10, 3/10, 7/10, 9/10], [1/2, 1/2, 1/2, 1/2]]

        The template is symmetrical (:literal:`hgmissymmetrical`)
        if it is equal to its twist.
        '''
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _ret = hgmtwist(_H)
        return new_gen(_ret)

    def hilbert(x, y, p=None):
        r'''
        Hilbert symbol of :math:`x` and :math:`y` modulo the prime :math:`p`, :math:`p = 0` meaning
        the place at infinity (the result is undefined if :math:`p ! = 0` is not prime).

        It is possible to omit :math:`p`, in which case we take :math:`p = 0` if both :math:`x`
        and :math:`y` are rational, or one of them is a real number. And take :math:`p = q`
        if one of :math:`x`, :math:`y` is a :literal:`t_INTMOD` modulo :math:`q` or a :math:`q`-adic. (Incompatible
        types will raise an error.)
        '''
        y = objtogen(y)
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef long _ret = hilbert(_x, _y, _p)
        clear_stack()
        return _ret

    def hyperellchangecurve(C, m):
        r'''
        :math:`C` being a nonsingular hyperelliptic model of a curve,
        apply the change of coordinate given by :math:`m = [e, [a,b;c,d], H]`.

        If :math:`(x,y)` is a point on the new model, the corresponding
        point :math:`(X,Y)` on :math:`C` is given by

        .. MATH::

        X = (a*x + b) / (c*x + d),
        Y = e (y + H(x)) / (c*x + d)^{g+1}.

        :math:`C` can be given either by a squarefree polynomial :math:`P` such that
        :math:`C: y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`C: y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.
        '''
        m = objtogen(m)
        sig_on()
        cdef GEN _C = (<Gen>C).g
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = hyperellchangecurve(_C, _m)
        return new_gen(_ret)

    def hyperellcharpoly(X):
        r'''
        :math:`X` being a nonsingular hyperelliptic curve defined over a finite field,
        return the characteristic polynomial of the Frobenius automorphism.
        :math:`X` can be given either by a squarefree polynomial :math:`P` such that
        :math:`X: y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`X: y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.
        '''
        sig_on()
        cdef GEN _X = (<Gen>X).g
        cdef GEN _ret = hyperellcharpoly(_X)
        return new_gen(_ret)

    def hyperelldisc(X):
        r'''
        :math:`X` being a nonsingular hyperelliptic model of a curve,
        defined over a field of characteristic distinct from 2, returns its discriminant.
        :math:`X` can be given either by a squarefree polynomial :math:`P` such that
        :math:`X` has equation :math:`y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`X` has equation :math:`y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.

        ::

        ? hyperelldisc([x^3,1])
        %1 = -27
        ? hyperelldisc(x^5+1)
        %2 = 800000
        '''
        sig_on()
        cdef GEN _X = (<Gen>X).g
        cdef GEN _ret = hyperelldisc(_X)
        return new_gen(_ret)

    def hyperellisoncurve(X, p):
        r'''
        :math:`X` being a nonsingular hyperelliptic model of a curve, test whether the
        point :math:`p` is on the curve.

        :math:`X` can be given either by a squarefree polynomial :math:`P` such that
        :math:`X: y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`X: y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.

        ::

        ? W = [2*x^6+3*x^5+x^4+x^3-x,x^3+1]; p = [px, py] = [1/3,-14/27];
        ? hyperellisoncurve(W, p)
        %2 = 1
        ? [Px,Qx]=subst(W,x,px); py^2+py*Qx == Px
        %3 = 1
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _X = (<Gen>X).g
        cdef GEN _p = (<Gen>p).g
        cdef int _ret = hyperellisoncurve(_X, _p)
        clear_stack()
        return _ret

    def hyperellminimaldisc(C, pr=None):
        r'''
        :math:`C` being a nonsingular integral hyperelliptic model of a curve,
        return the minimal discriminant of an integral model of :math:`C`.
        If :math:`pr` is given, it must be a list of primes and
        the discriminant is then only garanteed minimal at the elements of :math:`pr`.
        :math:`C` can be given either by a squarefree polynomial :math:`P` such that
        :math:`C: y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`C: y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.

        ::

        ? W = [x^6+216*x^3+324,0];
        ? D = hyperelldisc(W)
        %2 = 1828422898924853919744000
        ? M = hyperellminimaldisc(W)
        %4 = 29530050606000
        '''
        cdef bint _have_pr = (pr is not None)
        if _have_pr:
            pr = objtogen(pr)
        sig_on()
        cdef GEN _C = (<Gen>C).g
        cdef GEN _pr = NULL
        if _have_pr:
            _pr = (<Gen>pr).g
        cdef GEN _ret = hyperellminimaldisc(_C, _pr)
        return new_gen(_ret)

    def hyperellminimalmodel(C, m=None, pr=None):
        r'''
        :math:`C` being a nonsingular integral hyperelliptic model of a curve,
        return an integral model of :math:`C` with minimal discriminant.
        If :math:`pr` is given, it must be a list of primes and
        the model is then only garanteed minimal at the elements of :math:`pr`.
        If present, :math:`m` is set to the mapping from the original model to the new
        one: a three-component vector :math:`[e,[a,b;c,d],H]` such that
        if :math:`(x,y)` is a point on :math:`W`, the corresponding point on :math:`C` is given by

        .. MATH::

        x_{C} = (a*x+b)/(c*x+d)

        .. MATH::

        y_{C} = (e*y+H(x))/(c*x+d)^{g+1}

        where :math:`g` is the genus.
        :math:`C` can be given either by a squarefree polynomial :math:`P` such that
        :math:`C: y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`C: y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.

        ::

        ? W = [x^6+216*x^3+324,0];
        ? D = hyperelldisc(W)
        %2 = 1828422898924853919744000
        ? Wn = hyperellminimalmodel(W,&M)
        %3 = [2*x^6+18*x^3+1,x^3];
        ? M
        %4 = [18, [3, 0; 0, 1], 9*x^3]
        ? hyperelldisc(Wn)
        %5 = 29530050606000
        ? hyperellchangecurve(W, M)
        %6 = [2*x^6+18*x^3+1,x^3]
        '''
        cdef bint _have_m = (m is not None)
        if _have_m:
            raise NotImplementedError("optional argument m not available")
        cdef bint _have_pr = (pr is not None)
        if _have_pr:
            pr = objtogen(pr)
        sig_on()
        cdef GEN _C = (<Gen>C).g
        cdef GEN * _m = NULL
        cdef GEN _pr = NULL
        if _have_pr:
            _pr = (<Gen>pr).g
        cdef GEN _ret = hyperellminimalmodel(_C, _m, _pr)
        return new_gen(_ret)

    def hyperellordinate(H, x):
        r'''
        Gives a 0, 1 or 2-component vector containing
        the :math:`y`-coordinates of the points of the curve :math:`H` having :math:`x` as
        :math:`x`-coordinate.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = hyperellordinate(_H, _x)
        return new_gen(_ret)

    def hyperellpadicfrobenius(Q, q, long n):
        r'''
        Let :math:`X` be the curve defined by :math:`y^{2} = Q(x)`, where :math:`Q` is a polynomial of
        degree :math:`d` over :math:`\mathbb{Q}` and :math:`q >= d` is a prime such that :math:`X` has good reduction
        at :math:`q`. Return the matrix of the Frobenius endomorphism :math:`\varphi` on the
        crystalline module :math:`D_{p}(X) = \mathbb{Q}_{p} \otimes H^{1}_{dR}(X/\mathbb{Q})` with respect to the
        basis of the given model :math:`(\omega, x \omega,...,x^{g-1} \omega)`, where
        :math:`\omega = dx/(2 y)` is the invariant differential, where :math:`g` is the genus of
        :math:`X` (either :math:`d = 2 g+1` or :math:`d = 2 g+2`). The characteristic polynomial of
        :math:`\varphi` is the numerator of the zeta-function of the reduction of the curve
        :math:`X` modulo :math:`q`. The matrix is computed to absolute :math:`q`-adic precision :math:`q^{n}`.

        Alternatively, :math:`q` may be of the form :math:`[T,p]` where :math:`p` is a prime,
        :math:`T` is a polynomial with integral coefficients whose projection to
        :math:`\mathbb{F}_{p}[t]` is irreducible, :math:`X` is defined over :math:`K = \mathbb{Q}[t]/(T)` and has good
        reduction to the finite field :math:`\mathbb{F}_{q} = \mathbb{F}_{p}[t]/(T)`. The matrix of
        :math:`\varphi` on :math:`D_{q}(X) = \mathbb{Q}_{q} \otimes H^{1}_{dR}(X/K)` is computed
        to absolute :math:`p`-adic precision :math:`p^{n}`.

        ::

        ? M=hyperellpadicfrobenius(x^5+'a*x+1,['a^2+1,3],10);
        ? liftall(M)
        [48107*a + 38874 9222*a + 54290 41941*a + 8931 39672*a + 28651]
        
        [ 21458*a + 4763 3652*a + 22205 31111*a + 42559 39834*a + 40207]
        
        [ 13329*a + 4140 45270*a + 25803 1377*a + 32931 55980*a + 21267]
        
        [15086*a + 26714 33424*a + 4898 41830*a + 48013 5913*a + 24088]
        ? centerlift(simplify(liftpol(charpoly(M))))
        %8 = x^4+4*x^2+81
        ? hyperellcharpoly((x^5+Mod(a,a^2+1)*x+1)*Mod(1,3))
        %9 = x^4+4*x^2+81
        '''
        q = objtogen(q)
        sig_on()
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _q = (<Gen>q).g
        cdef GEN _ret = hyperellpadicfrobenius0(_Q, _q, n)
        return new_gen(_ret)

    def hyperellratpoints(X, h, long flag=0):
        r'''
        :math:`X` being a nonsingular hyperelliptic curve given by an rational model,
        return a vector containing the affine rational points on the curve of naive
        height less than :math:`h`. If :math:`flag = 1`, stop as soon as a point is found; return
        either an empty vector or a vector containing a single point.

        :math:`X` is given either by a squarefree polynomial :math:`P` such that :math:`X: y^{2} = P(x)`
        or by a vector :math:`[P,Q]` such that :math:`X: y^{2}+Q(x) y = P(x)` and :math:`Q^{2}+4 P` is
        squarefree.

        The parameter :math:`h` can be

        - an integer :math:`H`: find the points :math:`[n/d,y]` whose abscissas :math:`x = n/d` have
        naive height ( = :math:`\max (\|n\|, d)`) less than :math:`H`;

        - a vector :math:`[N,D]` with :math:`D <= N`: find the points :math:`[n/d,y]` with
        :math:`\|n\| <= N`, :math:`d <= D`.

        - a vector :math:`[N,[D_{1},D_{2}]]` with :math:`D_{1} < D_{2} <= N` find the points
        :math:`[n/d,y]` with :math:`\|n\| <= N` and :math:`D_{1} <= d <= D_{2}`.
        '''
        h = objtogen(h)
        sig_on()
        cdef GEN _X = (<Gen>X).g
        cdef GEN _h = (<Gen>h).g
        cdef GEN _ret = hyperellratpoints(_X, _h, flag)
        return new_gen(_ret)

    def hyperellred(C, m=None):
        r'''
        Let :math:`C` be a nonsingular integral hyperelliptic model of a curve of positive
        genus :math:`g > 0`. Return an integral model of :math:`C` with the same discriminant
        but small coefficients, using Cremona-Stoll reduction.

        The optional argument :math:`m` is set to the mapping from the original model to
        the new one, given by a three-component vector :literal:`[1,[a,b;c,d],H]`
        such that :math:`a*d-b*c = 1` and if :math:`(x,y)` is a point on :math:`W`, the corresponding
        point :math:`(X,Y)` on :math:`C` is given by

        .. MATH::

        X = (a*x + b) / (c*x + d),
        Y = (y + H(x)) / (c*x + d)^{g+1}.

        :math:`C` can be given either by a squarefree polynomial :math:`P` such that
        :math:`C: y^{2} = P(x)` or by a vector :math:`[P,Q]` such that
        :math:`C: y^{2} + Q(x) y = P(x)` and :math:`Q^{2}+4 P` is squarefree.

        ::

        ? P = 1001*x^4 + 3704*x^3 + 5136*x^2 + 3163*x + 730;
        ? hyperellred(P, &m)
        %2 = [x^3 + 1, 0]
        ? hyperellchangecurve(P, m)
        %3 = [x^3 + 1, 0]
        '''
        cdef bint _have_m = (m is not None)
        if _have_m:
            raise NotImplementedError("optional argument m not available")
        sig_on()
        cdef GEN _C = (<Gen>C).g
        cdef GEN * _m = NULL
        cdef GEN _ret = hyperellred(_C, _m)
        return new_gen(_ret)

    def hypergeom(N, D=None, z=None, long precision=DEFAULT_BITPREC):
        r'''
        General hypergeometric function, where :literal:`N` and :literal:`D` are
        the vector of parameters in the numerator and denominator respectively,
        evaluated at the argument :math:`z`, which may be complex, :math:`p`-adic or a power
        series.

        This function implements hypergeometric functions

        .. MATH::

        _{p}F_{q}((a_{i})_{1 <= i <= p},(b_{j})_{1 <= j <= q};z)
        = \sum_{n >= 0}(\prod_{1 <= i <= p}(a_{i})_{n})/(\prod_{1 <= j <= q}(b_{j})_{n})
        (z^{n})/(n!) ,

        where :math:`(a)_{n} = a(a+1)...(a+n-1)` is the rising Pochhammer symbol. For this
        to make sense, none of the :math:`b_{j}` must be a negative or zero integer. The
        corresponding general GP command is

        ::

        hypergeom([a1,a2,...,ap], [b1,b2,...,bq], z)

        Whenever :math:`p = 1` or :math:`q = 1`, a one-element vector can be
        replaced by the element it contains. Whenever :math:`p = 0` or :math:`q = 0`, an empty
        vector can be omitted. For instance hypergeom(,b,z) computes
        :math:`_{0}F_{1}(;b;z)`.

        The non-archimedean cases (:math:`z` a :math:`p`-adic or power series) are handled
        trivially. We now discuss the case of a complex :math:`z`; we distinguish three
        kinds of such functions according to their radius of convergence :math:`R`:

        - :math:`q >= p`: :math:`R = oo`.

        - :math:`q = p-1`: :math:`R = 1`. Nonetheless, by integral representations, :math:`_{p}F_{q}`
        can be analytically continued outside the disc of convergence.

        - :math:`q <= p-2`: :math:`R = 0`. By integral representations, one can make sense of
        the function in a suitable domain, by analytic continuation.

        The list of implemented functions and their domain of validity in
        our implementation is as follows:

        :literal:`F01`: :literal:`hypergeom(,a,z)` (or :literal:`[a]`).
        This is essentially a Bessel function and computed as such. :math:`R = oo`.

        :literal:`F10`: :literal:`hypergeom(a,,z)`
        This is :math:`(1-z)^{-a}`.

        :literal:`F11`: :literal:`hypergeom(a,b,z)` is the Kummer confluent hypergeometric
        function, computed by summing the series. :math:`R = oo`

        :literal:`F20`: :literal:`hypergeom([a,b],,z)`. :math:`R = 0`, computed as

        .. MATH::

        (1)/(\Gamma (a))\int_{0}^{ oo } t^{a-1}(1-zt)^{-b}e^{-t}dt .

        :literal:`F21`: :literal:`hypergeom([a,b],c,z)` (or :literal:`[c]`).
        :math:`R = 1`, extended by

        .. MATH::

        (\Gamma (c))/(\Gamma (b)\Gamma (c-b))
        \int_{0}^{1} t^{b-1}(1-t)^{c-b-1}(1-zt)^{a}dt .

        This is Gauss's Hypergeometric function, and almost all of the implementation
        work is done for this function.

        :literal:`F31`: :literal:`hypergeom([a,b,c],d,z)` (or :literal:`[d]`). :math:`R = 0`, computed as

        .. MATH::

        (1)/(\Gamma (a))\int_{0}^{ oo } t^{a-1}e^{-t}
        _{2}F_{1}(b,c;d;tz)dt .

        :literal:`F32`: :literal:`hypergeom([a,b,c],[d,e],z)`. :math:`R = 1`, extended by

        .. MATH::

        (\Gamma (e))/(\Gamma (c)\Gamma (e-c))
        \int_{0}^{1}t^{c-1}(1-t)^{e-c-1}_{2}F_{1}(a,b;d;tz)dt .

        For other inputs: if :math:`R = oo` or :math:`R = 1` and :math:`\|z\| < 1- \varepsilon` is not
        too close to the circle of convergence, we simply sum the series.

        ::

        ? hypergeom([3,2], 3.4, 0.7) \\ 2F1(3,2; 3.4; 0.7)
        %1 = 7.9999999999999999999999999999999999999
        ? a=5/3; T1=hypergeom([1,1,1],[a,a],1) \\ 3F2(1,1,1; a,a; 1)
        %2 = 3.1958592952314032651578713968927593818
        ? T2=hypergeom([2,1,1],[a+1,a+1],1)
        %3 = 1.6752931349345765309211012564734179541
        ? T3=hypergeom([2*a-1,1,1],[a+1,a+1],1)
        %4 = 1.9721037126267142061807688820853354440
        ? T1 + (a-1)^2/(a^2*(2*a-3)) * (T2-2*(a-1)*T3) \\
        - gamma(a)^2/((2*a-3)*gamma(2*a-2))
        %5 = -1.880790961315660013 E-37 \\ ~ 0

        This identity is due to Bercu.
        '''
        cdef bint _have_D = (D is not None)
        if _have_D:
            D = objtogen(D)
        if z is None:
            raise TypeError("missing required argument: 'z'")
        z = objtogen(z)
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _D = NULL
        if _have_D:
            _D = (<Gen>D).g
        cdef GEN _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = hypergeom(_N, _D, _z, precision)
        return new_gen(_ret)

    def hyperu(a, b, z, long precision=DEFAULT_BITPREC):
        r'''
        :math:`U`-confluent hypergeometric function with complex
        parameters :math:`a, b, z`. Note that :math:`_{2}F_{0}(a,b,z)
        = (-z)^{-a}U(a, a+1-b, -1/z)`,

        ::

        ? hyperu(1, 3/2, I)
        %1 = 0.23219... - 0.80952...*I
        ? -I * hypergeom([1, 1+1-3/2], [], -1/I)
        %2 = 0.23219... - 0.80952...*I
        '''
        b = objtogen(b)
        z = objtogen(z)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN _z = (<Gen>z).g
        precision = nbits2prec(precision)
        cdef GEN _ret = hyperu(_a, _b, _z, precision)
        return new_gen(_ret)

    def idealadd(nf, x, y):
        r'''
        Sum of the two ideals :math:`x` and :math:`y` in the number field :math:`nf`. The
        result is given in HNF.

        ::

        ? K = nfinit(x^2 + 1);
        ? a = idealadd(K, 2, x + 1) \\ ideal generated by 2 and 1+I
        %2 =
        [2 1]
        
        [0 1]
        ? pr = idealprimedec(K, 5)[1]; \\ a prime ideal above 5
        ? idealadd(K, a, pr) \\ coprime, as expected
        %4 =
        [1 0]
        
        [0 1]

        This function cannot be used to add arbitrary :math:`\mathbb{Z}`-modules, since it assumes
        that its arguments are ideals:

        ::

        ? b = Mat([1,0]~);
        ? idealadd(K, b, b) \\ only square t_MATs represent ideals
        *** idealadd: nonsquare t_MAT in idealtyp.
        ? c = [2, 0; 2, 0]; idealadd(K, c, c) \\ nonsense
        %6 =
        [2 0]
        
        [0 2]
        ? d = [1, 0; 0, 2]; idealadd(K, d, d) \\ nonsense
        %7 =
        [1 0]
        
        [0 1]
        

        In the last two examples, we get wrong results since the
        matrices :math:`c` and :math:`d` do not correspond to an ideal: the :math:`\mathbb{Z}`-span of their
        columns (as usual interpreted as coordinates with respect to the integer basis
        :literal:`K.zk`) is not an :math:`\mathbb{Z}_{K}`-module. To add arbitrary :math:`\mathbb{Z}`-modules generated
        by the columns of matrices :math:`A` and :math:`B`, use :literal:`mathnf(concat(A,B))`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = idealadd(_nf, _x, _y)
        return new_gen(_ret)

    def idealaddtoone(nf, x, y=None):
        r'''
        :math:`x` and :math:`y` being two co-prime
        integral ideals (given in any form), this gives a two-component row vector
        :math:`[a,b]` such that :math:`a\in x`, :math:`b\in y` and :math:`a+b = 1`.

        The alternative syntax :math:`idealaddtoone (nf,v)`, is supported, where
        :math:`v` is a :math:`k`-component vector of ideals (given in any form) which sum to
        :math:`\mathbb{Z}_{K}`. This outputs a :math:`k`-component vector :math:`e` such that :math:`e[i]\in x[i]` for
        :math:`1 <= i <= k` and :math:`\sum_{1 <= i <= k}e[i] = 1`.
        '''
        x = objtogen(x)
        cdef bint _have_y = (y is not None)
        if _have_y:
            y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = NULL
        if _have_y:
            _y = (<Gen>y).g
        cdef GEN _ret = idealaddtoone0(_nf, _x, _y)
        return new_gen(_ret)

    def idealappr(nf, x, long flag=0):
        r'''
        If :math:`x` is a fractional ideal
        (given in any form), gives an element :math:`\alpha` in :math:`nf` such that for
        all prime ideals :math:`p` such that the valuation of :math:`x` at :math:`p` is
        nonzero, we have :math:`v_{p}(\alpha) = v_{p}(x)`, and
        :math:`v_{p}(\alpha) >= 0` for all other :math:`p`.

        The argument :math:`x` may also be given as a prime ideal factorization, as
        output by :literal:`idealfactor`, but allowing zero exponents.
        This yields an element :math:`\alpha` such that for all prime ideals :math:`p`
        occurring in :math:`x`, :math:`v_{p}(\alpha) = v_{p}(x)`;
        for all other prime ideals, :math:`v_{p}(\alpha) >= 0`.

        :math:`flag` is deprecated (ignored), kept for backward compatibility.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealappr0(_nf, _x, flag)
        return new_gen(_ret)

    def idealchinese(nf, x, y=None):
        r'''
        :math:`x` being a prime ideal factorization (i.e. a 2-columns matrix whose first
        column contains prime ideals and the second column contains integral
        exponents), :math:`y` a vector of elements in :math:`nf` indexed by the ideals in
        :math:`x`, computes an element :math:`b` such that

        :math:`v_{p}(b - y_{p}) >= v_{p}(x)` for all prime ideals
        in :math:`x` and :math:`v_{p}(b) >= 0` for all other :math:`p`.

        ::

        ? K = nfinit(t^2-2);
        ? x = idealfactor(K, 2^2*3)
        %2 =
        [[2, [0, 1]~, 2, 1, [0, 2; 1, 0]] 4]
        
        [ [3, [3, 0]~, 1, 2, 1] 1]
        ? y = [t,1];
        ? idealchinese(K, x, y)
        %4 = [4, -3]~

        The argument :math:`x` may also be of the form :math:`[x, s]` where the first component
        is as above and :math:`s` is a vector of signs, with :math:`r_{1}` components
        :math:`s_{i}` in :math:`{-1,0,1}`:
        if :math:`\sigma_{i}` denotes the :math:`i`-th real embedding of the number field,
        the element :math:`b` returned satisfies further
        :math:`sign (\sigma_{i}(b)) = s_{i}` for all :math:`i` such that :math:`s_{i} = ±1`.
        In other words, the sign is fixed to :math:`s_{i}` at the :math:`i`-th embedding whenever
        :math:`s_{i}` is nonzero.

        ::

        ? idealchinese(K, [x, [1,1]], y)
        %5 = [16, -3]~
        ? idealchinese(K, [x, [-1,-1]], y)
        %6 = [-20, -3]~
        ? idealchinese(K, [x, [1,-1]], y)
        %7 = [4, -3]~

        If :math:`y` is omitted, return a data structure which can be used in
        place of :math:`x` in later calls and allows to solve many chinese remainder
        problems for a given :math:`x` more efficiently. In this case, the right hand side
        :math:`y` is not allowed to have denominators, unless they are coprime to :math:`x`.

        ::

        ? C = idealchinese(K, [x, [1,1]]);
        ? idealchinese(K, C, y) \\ as above
        %9 = [16, -3]~
        ? for(i=1,10^4, idealchinese(K,C,y)) \\ ... but faster !
        time = 80 ms.
        ? for(i=1,10^4, idealchinese(K,[x,[1,1]],y))
        time = 224 ms.

        Finally, this structure is itself allowed in place of :math:`x`, the
        new :math:`s` overriding the one already present in the structure. This allows to
        initialize for different sign conditions more efficiently when the underlying
        ideal factorization remains the same.

        ::

        ? D = idealchinese(K, [C, [1,-1]]); \\ replaces [1,1]
        ? idealchinese(K, D, y)
        %13 = [4, -3]~
        ? for(i=1,10^4,idealchinese(K,[C,[1,-1]]))
        time = 40 ms. \\ faster than starting from scratch
        ? for(i=1,10^4,idealchinese(K,[x,[1,-1]]))
        time = 128 ms.
        '''
        x = objtogen(x)
        cdef bint _have_y = (y is not None)
        if _have_y:
            y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = NULL
        if _have_y:
            _y = (<Gen>y).g
        cdef GEN _ret = idealchinese(_nf, _x, _y)
        return new_gen(_ret)

    def idealcoprime(nf, x, y):
        r'''
        Given two integral ideals :math:`x` and :math:`y`
        in the number field :math:`nf`, returns a :math:`\beta` in the field,
        such that :math:`\beta.x` is an integral ideal coprime to :math:`y`. In fact,
        :math:`\beta` is also guaranteed to be integral outside primes dividing :math:`y`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = idealcoprime(_nf, _x, _y)
        return new_gen(_ret)

    def idealdiv(nf, x, y, long flag=0):
        r'''
        Quotient :math:`x.y^{-1}` of the two ideals :math:`x` and :math:`y` in the number
        field :math:`nf`. The result is given in HNF.

        If :math:`flag` is nonzero, the quotient :math:`x.y^{-1}` is assumed to be an
        integral ideal. This can be much faster when the norm of the quotient is
        small even though the norms of :math:`x` and :math:`y` are large. More precisely,
        the algorithm cheaply removes all maximal ideals above rational
        primes such that :math:`v_{p}(Nx) = v_{p}(Ny)`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = idealdiv0(_nf, _x, _y, flag)
        return new_gen(_ret)

    def idealdown(nf, x):
        r'''
        Let :math:`nf` be a number field as output by :literal:`nfinit`, and :math:`x` a
        fractional ideal. This function returns the nonnegative rational generator
        of :math:`x \cap \mathbb{Q}`. If :math:`x` is an extended ideal, the extended part is ignored.

        ::

        ? nf = nfinit(y^2+1);
        ? idealdown(nf, -1/2)
        %2 = 1/2
        ? idealdown(nf, (y+1)/3)
        %3 = 2/3
        ? idealdown(nf, [2, 11]~)
        %4 = 125
        ? x = idealprimedec(nf, 2)[1]; idealdown(nf, x)
        %5 = 2
        ? idealdown(nf, [130, 94; 0, 2])
        %6 = 130
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealdown(_nf, _x)
        return new_gen(_ret)

    def idealfactor(nf, x, lim=None):
        r'''
        Factors into prime ideal powers the ideal :math:`x` in the number field
        :math:`nf`. The output format is similar to the :literal:`factor` function, and
        the prime ideals are represented in the form output by the
        :literal:`idealprimedec` function. If :emphasis:`lim` is set, return partial
        factorization, including only prime ideals above rational primes
        :math:`< lim`.

        ::

        ? nf = nfinit(x^3-2);
        ? idealfactor(nf, x) \\ a prime ideal above 2
        %2 =
        [[2, [0, 1, 0]~, 3, 1, ...] 1]
        
        ? A = idealhnf(nf, 6*x, 4+2*x+x^2)
        %3 =
        [6 0 4]
        
        [0 6 2]
        
        [0 0 1]
        
        ? idealfactor(nf, A)
        %4 =
        [[2, [0, 1, 0]~, 3, 1, ...] 2]
        
        [[3, [1, 1, 0]~, 3, 1, ...] 2]
        
        ? idealfactor(nf, A, 3) \\ restrict to primes above p < 3
        %5 =
        [[2, [0, 1, 0]~, 3, 1, ...] 2]
        '''
        x = objtogen(x)
        cdef bint _have_lim = (lim is not None)
        if _have_lim:
            lim = objtogen(lim)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _lim = NULL
        if _have_lim:
            _lim = (<Gen>lim).g
        cdef GEN _ret = gpidealfactor(_nf, _x, _lim)
        return new_gen(_ret)

    def idealfactorback(nf, f, e=None, long flag=0):
        r'''
        Gives back the ideal corresponding to a factorization. The integer :math:`1`
        corresponds to the empty factorization.
        If :math:`e` is present, :math:`e` and :math:`f` must be vectors of the same length (:math:`e` being
        integral), and the corresponding factorization is the product of the
        :math:`f[i]^{e[i]}`.

        If not, and :math:`f` is vector, it is understood as in the preceding case with :math:`e`
        a vector of 1s: we return the product of the :math:`f[i]`. Finally, :math:`f` can be a
        regular factorization, as produced by :literal:`idealfactor`.

        ::

        ? nf = nfinit(y^2+1); idealfactor(nf, 4 + 2*y)
        %1 =
        [[2, [1, 1]~, 2, 1, [1, 1]~] 2]
        
        [[5, [2, 1]~, 1, 1, [-2, 1]~] 1]
        
        ? idealfactorback(nf, %)
        %2 =
        [10 4]
        
        [0 2]
        
        ? f = %1[,1]; e = %1[,2]; idealfactorback(nf, f, e)
        %3 =
        [10 4]
        
        [0 2]
        
        ? % == idealhnf(nf, 4 + 2*y)
        %4 = 1

        If :math:`flag` is nonzero, perform ideal reductions (:literal:`idealred`) along the
        way. This is most useful if the ideals involved are all :emphasis:`extended`
        ideals (for instance with trivial principal part), so that the principal parts
        extracted by :literal:`idealred` are not lost. Here is an example:

        ::

        ? f = vector(#f, i, [f[i], [;]]); \\ transform to extended ideals
        ? idealfactorback(nf, f, e, 1)
        %6 = [[1, 0; 0, 1], [2, 1; [2, 1]~, 1]]
        ? nffactorback(nf, %[2])
        %7 = [4, 2]~

        The extended ideal returned in :literal:`\%6` is the trivial ideal :math:`1`, extended
        with a principal generator given in factored form. We use :literal:`nffactorback`
        to recover it in standard form.
        '''
        f = objtogen(f)
        cdef bint _have_e = (e is not None)
        if _have_e:
            e = objtogen(e)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _f = (<Gen>f).g
        cdef GEN _e = NULL
        if _have_e:
            _e = (<Gen>e).g
        cdef GEN _ret = idealfactorback(_nf, _f, _e, flag)
        return new_gen(_ret)

    def idealfrobenius(nf, gal, pr):
        r'''
        Let :math:`K` be the number field defined by :math:`nf` and assume :math:`K/\mathbb{Q}` be a
        Galois extension with Galois group given :literal:`gal = galoisinit(nf)`,
        and that :emphasis:`pr` is an unramified prime ideal :math:`p` in :literal:`prid`
        format.
        This function returns a permutation of :literal:`gal.group` which defines
        the Frobenius element :math:`\text{Frob}_{p}` attached to :math:`p`.
        If :math:`p` is the unique prime number in :math:`p`, then
        :math:`\text{Frob} (x) = x^{p} mod p` for all :math:`x\in\mathbb{Z}_{K}`.

        ::

        ? nf = nfinit(polcyclo(31));
        ? gal = galoisinit(nf);
        ? pr = idealprimedec(nf,101)[1];
        ? g = idealfrobenius(nf,gal,pr);
        ? galoispermtopol(gal,g)
        %5 = x^8

        This is correct since :math:`101 = 8 mod 31`.
        '''
        gal = objtogen(gal)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = idealfrobenius(_nf, _gal, _pr)
        return new_gen(_ret)

    def idealhnf(nf, u, v=None):
        r'''
        Gives the Hermite normal form of the ideal :math:`u\mathbb{Z}_{K}+v\mathbb{Z}_{K}`,
        where :math:`u` and :math:`v` are elements of the number field :math:`K` defined by :emphasis:`nf`.

        ::

        ? nf = nfinit(y^3 - 2);
        ? idealhnf(nf, 2, y+1)
        %2 =
        [1 0 0]
        
        [0 1 0]
        
        [0 0 1]
        ? idealhnf(nf, y/2, [0,0,1/3]~)
        %3 =
        [1/3 0 0]
        
        [0 1/6 0]
        
        [0 0 1/6]

        If :math:`v` is omitted, returns the HNF of the ideal defined by :math:`u`: :math:`u` may be an
        algebraic number (defining a principal ideal), a maximal ideal (as given by
        :literal:`idealprimedec` or :literal:`idealfactor`), or a matrix whose columns give
        generators for the ideal. This last format is a little complicated, but
        useful to reduce general modules to the canonical form once in a while:

        - if strictly less than :math:`N = [K:\mathbb{Q}]` generators are given, :math:`u`
        is the :math:`\mathbb{Z}_{K}`-module they generate,

        - if :math:`N` or more are given, it is :emphasis:`assumed` that they form a
        :math:`\mathbb{Z}`-basis of the ideal, in particular that the matrix has maximal rank :math:`N`.
        This acts as :literal:`mathnf` since the :math:`\mathbb{Z}_{K}`-module structure is (taken for
        granted hence) not taken into account in this case.

        ::

        ? idealhnf(nf, idealprimedec(nf,2)[1])
        %4 =
        [2 0 0]
        
        [0 1 0]
        
        [0 0 1]
        ? idealhnf(nf, [1,2;2,3;3,4])
        %5 =
        [1 0 0]
        
        [0 1 0]
        
        [0 0 1]

        Finally, when :math:`K` is quadratic with discriminant :math:`D_{K}`, we
        allow :math:`u =` :literal:`Qfb(a,b,c)`, provided :math:`b^{2} - 4ac = D_{K}`. As usual,
        this represents the ideal :math:`a \mathbb{Z} + (1/2)(-b + \sqrt{D_{K}}) \mathbb{Z}`.

        ::

        ? K = nfinit(x^2 - 60); K.disc
        %1 = 60
        ? idealhnf(K, qfbprimeform(60,2))
        %2 =
        [2 1]
        
        [0 1]
        ? idealhnf(K, Qfb(1,2,3))
        *** at top-level: idealhnf(K,Qfb(1,2,3
        *** ^--------------------
        *** idealhnf: Qfb(1, 2, 3) has discriminant != 60 in idealhnf.
        '''
        u = objtogen(u)
        cdef bint _have_v = (v is not None)
        if _have_v:
            v = objtogen(v)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _u = (<Gen>u).g
        cdef GEN _v = NULL
        if _have_v:
            _v = (<Gen>v).g
        cdef GEN _ret = idealhnf0(_nf, _u, _v)
        return new_gen(_ret)

    def idealintersect(nf, A, B):
        r'''
        Intersection of the two ideals
        :math:`A` and :math:`B` in the number field :math:`nf`. The result is given in HNF.

        ::

        ? nf = nfinit(x^2+1);
        ? idealintersect(nf, 2, x+1)
        %2 =
        [2 0]
        
        [0 2]

        This function does not apply to general :math:`\mathbb{Z}`-modules, e.g. orders, since its
        arguments are replaced by the ideals they generate. The following script
        intersects :math:`\mathbb{Z}`-modules :math:`A` and :math:`B` given by matrices of compatible
        dimensions with integer coefficients:

        ::

        ZM_intersect(A,B) =
        { my(Ker = matkerint(concat(A,B)));
        mathnf( A * Ker[1..#A,] )
        }
        '''
        A = objtogen(A)
        B = objtogen(B)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _A = (<Gen>A).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = idealintersect(_nf, _A, _B)
        return new_gen(_ret)

    def idealinv(nf, x):
        r'''
        Inverse of the ideal :math:`x` in the
        number field :math:`nf`, given in HNF. If :math:`x` is an extended
        ideal, its principal part is suitably
        updated: i.e. inverting :math:`[I,t]`, yields :math:`[I^{-1}, 1/t]`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealinv(_nf, _x)
        return new_gen(_ret)

    def idealismaximal(nf, x):
        r'''
        Given :emphasis:`nf` a number field as output by :literal:`nfinit` and an ideal
        :math:`x`, return :math:`0` if :math:`x` is not a maximal ideal. Otherwise return a :literal:`prid`
        structure :emphasis:`nf` attached to the ideal. This function uses
        :literal:`ispseudoprime` and may return a wrong result in case the underlying
        rational pseudoprime is not an actual prime number: apply :literal:`isprime(pr.p)`
        to guarantee correctness. If :math:`x` is an extended ideal, the extended part is
        ignored.

        ::

        ? K = nfinit(y^2 + 1);
        ? idealismaximal(K, 3) \\ 3 is inert
        %2 = [3, [3, 0]~, 1, 2, 1]
        ? idealismaximal(K, 5) \\ 5 is not
        %3 = 0
        ? pr = idealprimedec(K,5)[1] \\ already a prid
        %4 = [5, [-2, 1]~, 1, 1, [2, -1; 1, 2]]
        ? idealismaximal(K, pr) \\ trivial check
        %5 = [5, [-2, 1]~, 1, 1, [2, -1; 1, 2]]
        ? x = idealhnf(K, pr)
        %6 =
        [5 3]
        
        [0 1]
        ? idealismaximal(K, x) \\ converts from matrix form to prid
        %7 = [5, [-2, 1]~, 1, 1, [2, -1; 1, 2]]

        This function is noticeably faster than :literal:`idealfactor`
        since it never involves an actually factorization, in particular when :math:`x
        \cap \mathbb{Z}` is not a prime number.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealismaximal(_nf, _x)
        return new_gen(_ret)

    def idealispower(nf, A, long n, B=None):
        r'''
        Let :emphasis:`nf` be a number field and :math:`n > 0` be a positive integer.
        Return :math:`1` if the fractional ideal :math:`A = B^{n}` is an :math:`n`-th power and :math:`0`
        otherwise. If the argument :math:`B` is present, set it to the :math:`n`-th root of :math:`A`,
        in HNF.

        ::

        ? K = nfinit(x^3 - 2);
        ? A = [46875, 30966, 9573; 0, 3, 0; 0, 0, 3];
        ? idealispower(K, A, 3, &B)
        %3 = 1
        ? B
        %4 =
        [75 22 41]
        
        [ 0 1 0]
        
        [ 0 0 1]
        
        ? A = [9375, 2841, 198; 0, 3, 0; 0, 0, 3];
        ? idealispower(K, A, 3)
        %5 = 0
        '''
        A = objtogen(A)
        cdef bint _have_B = (B is not None)
        if _have_B:
            raise NotImplementedError("optional argument B not available")
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _A = (<Gen>A).g
        cdef GEN * _B = NULL
        cdef long _ret = idealispower(_nf, _A, n, _B)
        clear_stack()
        return _ret

    def ideallist(nf, bound, long flag=4):
        r'''
        Computes the list of all ideals of norm less or equal to :emphasis:`bound` in
        the number field
        :emphasis:`nf`. The result is a row vector with exactly :emphasis:`bound` components.
        Each component is itself a row vector containing the information about
        ideals of a given norm, in no specific order. The information is inferred
        from local data and Chinese remainders and less expensive than computing
        than a direct global computation.

        The binary digits of :math:`flag` mean:

        - 1: if the ideals are given by a :emphasis:`bid`, include generators;
        otherwise don't.

        - 2: if this bit is set, :emphasis:`nf` must be a :emphasis:`bnf` with units. Each
        component is of the form :math:`[bid,U]`, where :emphasis:`bid` is attached to
        an ideal :math:`f` and :math:`U` is a vector of discrete logarithms of the units in
        :math:`(\mathbb{Z}_{K}/f)^{*}`. More precisely, :math:`U` gives the :literal:`ideallog` s with respect
        to :emphasis:`bid` of :math:`(\zeta,u_{1},...,u_{r})`
        where :math:`\zeta` is the torsion unit generator :literal:`bnf.tu[2]` and :math:`(u_{i})`
        are the fundamental units in :literal:`bnf.fu`.
        This structure is technical, meant to be used in conjunction with
        :literal:`bnrclassnolist` or :literal:`bnrdisclist`.

        - 4: give only the ideal (in HNF), else a :emphasis:`bid`.

        - 8: omit ideals which cannot be conductors, i.e. divisible exactly by
        a prime ideal of norm :math:`2`.

        ::

        ? nf = nfinit(x^2+1);
        ? L = ideallist(nf, 100);
        ? L[1]
        %3 = [[1, 0; 0, 1]] \\ A single ideal of norm 1
        ? #L[65]
        %4 = 4 \\ There are 4 ideals of norm 65 in Z[i]

        If one wants more information:

        ::

        ? L = ideallist(nf, 100, 0);
        ? l = L[25]; vector(#l, i, l[i].clgp)
        %6 = [[20, [20]], [16, [4, 4]], [20, [20]]]
        ? l[1].mod
        %7 = [[25, 18; 0, 1], []]
        ? l[2].mod
        %8 = [[5, 0; 0, 5], []]
        ? l[3].mod
        %9 = [[25, 7; 0, 1], []]

        where we ask for the structures of the :math:`(\mathbb{Z}[i]/f)^{*}` for all
        three ideals of norm :math:`25`. In fact, for all moduli with finite part of norm
        :math:`25` and trivial Archimedean part, as the last 3 commands show. See
        :literal:`ideallistarch` to treat general moduli.

        Finally, one can input a negative :literal:`bound`. The function
        then returns the ideals of norm :math:`\|bound\|`, given by their
        factorization matrix. The only valid value of :emphasis:`flag` is then the default.
        If needed, one can obtain their HNF using
        :literal:`idealfactorback`, and the corresponding :emphasis:`bid` structures using
        :literal:`idealstar` (which accepts ideals in factored form).
        '''
        bound = objtogen(bound)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _bound = (<Gen>bound).g
        cdef GEN _ret = gideallist(_nf, _bound, flag)
        return new_gen(_ret)

    def ideallistarch(nf, list, arch):
        r'''
        :emphasis:`list` is a vector of vectors of bid's, as output by :literal:`ideallist` with
        flag :math:`0` to :math:`3`. Return a vector of vectors with the same number of
        components as the original :emphasis:`list`. The leaves give information about
        moduli whose finite part is as in original list, in the same order, and
        Archimedean part is now :emphasis:`arch` (it was originally trivial). The
        information contained is of the same kind as was present in the input; see
        :literal:`ideallist`, in particular the meaning of :emphasis:`flag`.

        ::

        ? bnf = bnfinit(x^2-2);
        ? bnf.sign
        %2 = [2, 0] \\ two places at infinity
        ? L = ideallist(bnf, 100, 0);
        ? l = L[98]; vector(#l, i, l[i].clgp)
        %4 = [[42, [42]], [36, [6, 6]], [42, [42]]]
        ? La = ideallistarch(bnf, L, [1,1]); \\ add them to the modulus
        ? l = La[98]; vector(#l, i, l[i].clgp)
        %6 = [[168, [42, 2, 2]], [144, [6, 6, 2, 2]], [168, [42, 2, 2]]]

        Of course, the results above are obvious: adding :math:`t` places at infinity will
        add :math:`t` copies of :math:`\mathbb{Z}/2\mathbb{Z}` to :math:`(\mathbb{Z}_{K}/f)^{*}`. The following application
        is more typical:

        ::

        ? L = ideallist(bnf, 100, 2); \\ units are required now
        ? La = ideallistarch(bnf, L, [1,1]);
        ? H = bnrclassnolist(bnf, La);
        ? H[98];
        %4 = [2, 12, 2]
        '''
        list = objtogen(list)
        arch = objtogen(arch)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _list = (<Gen>list).g
        cdef GEN _arch = (<Gen>arch).g
        cdef GEN _ret = ideallistarch(_nf, _list, _arch)
        return new_gen(_ret)

    def ideallog(nf, x, bid):
        r'''
        :math:`nf` is a number field,
        :emphasis:`bid` is as output by :literal:`idealstar(nf, D,...)` and :math:`x` an
        element of :emphasis:`nf` which must have valuation
        equal to 0 at all prime ideals in the support of :math:`D` and need not be
        integral. This function
        computes the discrete logarithm of :math:`x` on the generators given in
        :literal:`:emphasis:`bid`.gen`. In other words, if :math:`g_{i}` are these generators, of orders
        :math:`d_{i}` respectively, the result is a column vector of integers :math:`(x_{i})` such
        that :math:`0 <= x_{i} < d_{i}` and

        .. MATH::

        x = \prod_{i} g_{i}^{x_{i}} (mod ^{*}D) .

        Note that when the support of :literal:`D` contains places at infinity, this
        congruence implies also sign conditions on the attached real embeddings.
        See :literal:`znlog` for the limitations of the underlying discrete log algorithms.

        When :emphasis:`nf` is omitted, take it to be the rational number field. In that
        case, :math:`x` must be a :literal:`t_INT` and :emphasis:`bid` must have been initialized by
        :literal:`znstar(N,1)`.
        '''
        x = objtogen(x)
        bid = objtogen(bid)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _bid = (<Gen>bid).g
        cdef GEN _ret = ideallog(_nf, _x, _bid)
        return new_gen(_ret)

    def idealmin(nf, ix, vdir=None):
        r'''
        :emphasis:`This function is useless and kept for backward compatibility only,
        use :literal:`idealred``. Computes a pseudo-minimum of the ideal :math:`x` in the
        direction :emphasis:`vdir` in the number field :emphasis:`nf`.
        '''
        ix = objtogen(ix)
        cdef bint _have_vdir = (vdir is not None)
        if _have_vdir:
            vdir = objtogen(vdir)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _ix = (<Gen>ix).g
        cdef GEN _vdir = NULL
        if _have_vdir:
            _vdir = (<Gen>vdir).g
        cdef GEN _ret = idealmin(_nf, _ix, _vdir)
        return new_gen(_ret)

    def idealmul(nf, x, y, long flag=0):
        r'''
        Ideal multiplication of the ideals :math:`x` and :math:`y` in the number field
        :emphasis:`nf`; the result is the ideal product in HNF. If either :math:`x` or :math:`y`
        are extended ideals, their principal part is suitably
        updated: i.e. multiplying :math:`[I,t]`, :math:`[J,u]` yields :math:`[IJ, tu]`; multiplying
        :math:`I` and :math:`[J, u]` yields :math:`[IJ, u]`.

        ::

        ? nf = nfinit(x^2 + 1);
        ? idealmul(nf, 2, x+1)
        %2 =
        [4 2]
        
        [0 2]
        ? idealmul(nf, [2, x], x+1) \\ extended ideal * ideal
        %3 = [[4, 2; 0, 2], x]
        ? idealmul(nf, [2, x], [x+1, x]) \\ two extended ideals
        %4 = [[4, 2; 0, 2], [-1, 0]~]

        If :math:`flag` is nonzero, reduce the result using :literal:`idealred`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = idealmul0(_nf, _x, _y, flag)
        return new_gen(_ret)

    def idealnorm(nf, x):
        r'''
        Computes the norm of the ideal :math:`x` in the number field :math:`nf`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealnorm(_nf, _x)
        return new_gen(_ret)

    def idealnumden(nf, x):
        r'''
        Returns :math:`[A,B]`, where :math:`A,B` are coprime integer ideals
        such that :math:`x = A/B`, in the number field :math:`nf`.

        ::

        ? nf = nfinit(x^2+1);
        ? idealnumden(nf, (x+1)/2)
        %2 = [[1, 0; 0, 1], [2, 1; 0, 1]]
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealnumden(_nf, _x)
        return new_gen(_ret)

    def idealpow(nf, x, k, long flag=0):
        r'''
        Computes the :math:`k`-th power of
        the ideal :math:`x` in the number field :math:`nf`; :math:`k\in\mathbb{Z}`.
        If :math:`x` is an extended
        ideal, its principal part is suitably
        updated: i.e. raising :math:`[I,t]` to the :math:`k`-th power, yields :math:`[I^{k}, t^{k}]`.

        If :math:`flag` is nonzero, reduce the result using :literal:`idealred`, :emphasis:`throughout
        the (binary) powering process`; in particular, this is :emphasis:`not` the same
        as :math:`idealpow (nf,x,k)` followed by reduction.
        '''
        x = objtogen(x)
        k = objtogen(k)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _k = (<Gen>k).g
        cdef GEN _ret = idealpow0(_nf, _x, _k, flag)
        return new_gen(_ret)

    def idealprimedec(nf, p, long f=0):
        r'''
        Computes the prime ideal
        decomposition of the (positive) prime number :math:`p` in the number field :math:`K`
        represented by :emphasis:`nf`. If a nonprime :math:`p` is given the result is undefined.
        If :math:`f` is present and nonzero, restrict the result to primes of residue
        degree :math:`<= f`.

        The result is a vector of :emphasis:`prid` structures, each representing one of the
        prime ideals above :math:`p` in the number field :math:`nf`. The representation
        :math:`pr = [p,a,e,f,mb]` of a prime ideal means the following: :math:`a`
        is an algebraic integer in the maximal order :math:`\mathbb{Z}_{K}` and the prime ideal is
        equal to :math:`p = p\mathbb{Z}_{K} + a\mathbb{Z}_{K}`;
        :math:`e` is the ramification index; :math:`f` is the residual index;
        finally, :emphasis:`mb` is the multiplication table attached to an algebraic
        integer :math:`b` such that :math:`p^{-1} = \mathbb{Z}_{K}+ b/ p\mathbb{Z}_{K}`, which is used
        internally to compute valuations. In other words if :math:`p` is inert,
        then :emphasis:`mb` is the integer :math:`1`, and otherwise it is a square :literal:`t_MAT`
        whose :math:`j`-th column is :math:`b.nf.zk[j]`.

        The algebraic number :math:`a` is guaranteed to have a
        valuation equal to 1 at the prime ideal (this is automatic if :math:`e > 1`).

        The components of :literal:`pr` should be accessed by member functions: :literal:`pr.p`,
        :literal:`pr.e`, :literal:`pr.f`, and :literal:`pr.gen` (returns the vector :math:`[p,a]`):

        ::

        ? K = nfinit(x^3-2);
        ? P = idealprimedec(K, 5);
        ? #P \\ 2 primes above 5 in Q(2^(1/3))
        %3 = 2
        ? [p1,p2] = P;
        ? [p1.e, p1.f] \\ the first is unramified of degree 1
        %5 = [1, 1]
        ? [p2.e, p2.f] \\ the second is unramified of degree 2
        %6 = [1, 2]
        ? p1.gen
        %7 = [5, [2, 1, 0]~]
        ? nfbasistoalg(K, %[2]) \\ a uniformizer for p1
        %8 = Mod(x + 2, x^3 - 2)
        ? #idealprimedec(K, 5, 1) \\ restrict to f = 1
        %9 = 1 \\ now only p1
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = idealprimedec_limit_f(_nf, _p, f)
        return new_gen(_ret)

    def idealprincipalunits(nf, pr, long k):
        r'''
        Given a prime ideal in :literal:`idealprimedec` format,
        returns the multiplicative group :math:`(1 + pr) / (1 + pr^{k})` as an
        abelian group. This function is much faster than :literal:`idealstar` when the
        norm of :emphasis:`pr` is large, since it avoids (useless) work in the
        multiplicative group of the residue field.

        ::

        ? K = nfinit(y^2+1);
        ? P = idealprimedec(K,2)[1];
        ? G = idealprincipalunits(K, P, 20);
        ? G.cyc
        %4 = [512, 256, 4] \\ Z/512 x Z/256 x Z/4
        ? G.gen
        %5 = [[-1, -2]~, 1021, [0, -1]~] \\ minimal generators of given order
        '''
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = idealprincipalunits(_nf, _pr, k)
        return new_gen(_ret)

    def idealramgroups(nf, gal, pr):
        r'''
        Let :math:`K` be the number field defined by :emphasis:`nf` and assume that :math:`K/\mathbb{Q}` is
        Galois with Galois group :math:`G` given by :literal:`gal = galoisinit(nf)`.
        Let :emphasis:`pr` be the prime ideal :math:`P` in prid format.
        This function returns a vector :math:`g` of subgroups of :literal:`gal`
        as follows:

        - :literal:`g[1]` is the decomposition group of :math:`P`,

        - :literal:`g[2]` is :math:`G_{0}(P)`, the inertia group of :math:`P`,

        and for :math:`i >= 2`,

        - :literal:`g[i]` is :math:`G_{i-2}(P)`, the :math:`i-2`-th
        ramification group of :math:`P`.

        The length of :math:`g` is the number of nontrivial groups in the
        sequence, thus is :math:`0` if :math:`e = 1` and :math:`f = 1`, and :math:`1` if :math:`f > 1` and :math:`e = 1`.
        The following function computes the cardinality of a subgroup of :math:`G`,
        as given by the components of :math:`g`:

        ::

        card(H) =my(o=H[2]); prod(i=1,#o,o[i]);

        ::

        ? nf=nfinit(x^6+3); gal=galoisinit(nf); pr=idealprimedec(nf,3)[1];
        ? g = idealramgroups(nf, gal, pr);
        ? apply(card,g)
        %3 = [6, 6, 3, 3, 3] \\ cardinalities of the G_i

        ::

        ? nf=nfinit(x^6+108); gal=galoisinit(nf); pr=idealprimedec(nf,2)[1];
        ? iso=idealramgroups(nf,gal,pr)[2]
        %5 = [[Vecsmall([2, 3, 1, 5, 6, 4])], Vecsmall([3])]
        ? nfdisc(galoisfixedfield(gal,iso,1))
        %6 = -3

        The field fixed by the inertia group of :math:`2` is not ramified at
        :math:`2`.
        '''
        gal = objtogen(gal)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = idealramgroups(_nf, _gal, _pr)
        return new_gen(_ret)

    def idealred(nf, I, v=None):
        r'''
        LLL reduction of
        the ideal :math:`I` in the number field :math:`K` attached to :emphasis:`nf`, along the
        direction :math:`v`. The :math:`v` parameter is best left omitted, but if it is present,
        it must be an :math:`nf.r1 + nf.r2`-component vector of
        :emphasis:`nonnegative` integers. (What counts is the relative magnitude of the
        entries: if all entries are equal, the effect is the same as if the vector
        had been omitted.)

        This function finds an :math:`a\in K^{*}` such that :math:`J = (a)I` is
        "small" and integral (see the end for technical details).
        The result is the Hermite normal form of
        the "reduced" ideal :math:`J`.

        ::

        ? K = nfinit(y^2+1);
        ? P = idealprimedec(K,5)[1];
        ? idealred(K, P)
        %3 =
        [1 0]
        
        [0 1]

        More often than not, a principal ideal yields the unit
        ideal as above. This is a quick and dirty way to check if ideals are principal,
        but it is not a necessary condition: a nontrivial result does not prove that
        the ideal is nonprincipal. For guaranteed results, see :literal:`bnfisprincipal`,
        which requires the computation of a full :literal:`bnf` structure.

        If the input is an extended ideal :math:`[I,s]`, the output is :math:`[J, sa]`; in
        this way, one keeps track of the principal ideal part:

        ::

        ? idealred(K, [P, 1])
        %5 = [[1, 0; 0, 1], [2, -1]~]

        meaning that :math:`P` is generated by :math:`[2, -1]`. The number field element in the
        extended part is an algebraic number in any form :emphasis:`or` a factorization
        matrix (in terms of number field elements, not ideals!). In the latter case,
        elements stay in factored form, which is a convenient way to avoid
        coefficient explosion; see also :literal:`idealpow`.

        :strong:`Technical note.` The routine computes an LLL-reduced
        basis for the lattice :math:`I^{-1}` equipped with the quadratic
        form

        .. MATH::

        \|\| x \|\|_{v}^{2} = \sum_{i = 1}^{r_{1}+r_{2}}
        2^{v_{i}}\varepsilon_{i}\|\sigma_{i}(x)\|^{2},

        where as usual the :math:`\sigma_{i}` are the (real and) complex embeddings and
        :math:`\varepsilon_{i} = 1`, resp. :math:`2`, for a real, resp. complex place. The element
        :math:`a` is simply the first vector in the LLL basis. The only reason you may want
        to try to change some directions and set some :math:`v_{i} ! = 0` is to randomize
        the elements found for a fixed ideal, which is heuristically useful in index
        calculus algorithms like :literal:`bnfinit` and :literal:`bnfisprincipal`.

        :strong:`Even more technical note.` In fact, the above is a white lie.
        We do not use :math:`\|\|.\|\|_{v}` exactly but a rescaled rounded variant which
        gets us faster and simpler LLLs. There's no harm since we are not using any
        theoretical property of :math:`a` after all, except that it belongs to :math:`I^{-1}`
        and that :math:`a I` is "expected to be small".
        '''
        I = objtogen(I)
        cdef bint _have_v = (v is not None)
        if _have_v:
            v = objtogen(v)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _I = (<Gen>I).g
        cdef GEN _v = NULL
        if _have_v:
            _v = (<Gen>v).g
        cdef GEN _ret = idealred0(_nf, _I, _v)
        return new_gen(_ret)

    def idealredmodpower(nf, x, unsigned long n, unsigned long B=0):
        r'''
        Let :emphasis:`nf` be a number field, :math:`x` an ideal in :emphasis:`nf` and :math:`n > 0` be a
        positive integer. Return a number field element :math:`b` such that :math:`x b^{n} = v`
        is small. If :math:`x` is integral, then :math:`v` is also integral.

        More precisely, :literal:`idealnumden` reduces the problem to :math:`x` integral. Then,
        factoring out the prime ideals dividing a rational prime :math:`p <= B`,
        we rewrite :math:`x = I J^{n}` where the ideals :math:`I` and :math:`J` are both integral and
        :math:`I` is :math:`B`-smooth. Then we return a small element :math:`b` in :math:`J^{-1}`.

        The bound :math:`B` avoids a costly complete factorization of :math:`x`; as soon as the
        :math:`n`-core of :math:`x` is :math:`B`-smooth (i.e., as soon as :math:`I` is :math:`n`-power free),
        then :math:`J` is as large as possible and so is the expected reduction.

        ::

        ? T = x^6+108; nf = nfinit(T); a = Mod(x,T);
        ? setrand(1); u = (2*a^2+a+3)*random(2^1000*x^6)^6;
        ? sizebyte(u)
        %3 = 4864
        ? b = idealredmodpower(nf,u,2);
        ? v2 = nfeltmul(nf,u, nfeltpow(nf,b,2))
        %5 = [34, 47, 15, 35, 9, 3]~
        ? b = idealredmodpower(nf,u,6);
        ? v6 = nfeltmul(nf,u, nfeltpow(nf,b,6))
        %7 = [3, 0, 2, 6, -7, 1]~

        The last element :literal:`v6`, obtained by reducing
        modulo :math:`6`-th powers instead of squares, looks smaller than :literal:`v2`
        but its norm is actually a little larger:

        ::

        ? idealnorm(nf,v2)
        %8 = 81309
        ? idealnorm(nf,v6)
        %9 = 731781
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = idealredmodpower(_nf, _x, n, B)
        return new_gen(_ret)

    def idealstar(nf, N, long flag=1, cycmod=None):
        r'''
        Outputs a :literal:`bid` structure,
        necessary for computing in the finite abelian group :math:`G = (\mathbb{Z}_{K}/N)^{*}`. Here,
        :emphasis:`nf` is a number field and :math:`N` is a :emphasis:`modulus`: either an ideal in any
        form, or a row vector whose first component is an ideal and whose second
        component is a row vector of :math:`r_{1}` 0 or 1. Ideals can also be given
        by a factorization into prime ideals, as produced by :literal:`idealfactor`.

        If the positive integer :literal:`cycmod` is present, only compute the group
        modulo :literal:`cycmod`-th powers, which may save a lot of time when some
        maximal ideals in the modulus have a huge residue field. Whereas you might
        only be interested in quadratic or cubic residuosity; see also :literal:`bnrinit`
        for applications in class field theory.

        This :emphasis:`bid` is used in :literal:`ideallog` to compute discrete logarithms. It
        also contains useful information which can be conveniently retrieved as
        :literal:`:emphasis:`bid`.mod` (the modulus),
        :literal:`:emphasis:`bid`.clgp` (:math:`G` as a finite abelian group),
        :literal:`:emphasis:`bid`.no` (the cardinality of :math:`G`),
        :literal:`:emphasis:`bid`.cyc` (elementary divisors) and
        :literal:`:emphasis:`bid`.gen` (generators).

        If :math:`flag = 1` (default), the result is a :literal:`bid` structure without
        generators: they are well defined but not explicitly computed, which saves
        time.

        If :math:`flag = 2`, as :math:`flag = 1`, but including generators.

        If :math:`flag = 0`, only outputs :math:`(\mathbb{Z}_{K}/N)^{*}` as an abelian group,
        i.e as a 3-component vector :math:`[h,d,g]`: :math:`h` is the order, :math:`d` is the vector of
        SNF cyclic components and :math:`g` the corresponding
        generators.

        If :emphasis:`nf` is omitted, we take it to be the rational number fields, :math:`N` must
        be an integer and we return the structure of :math:`(\mathbb{Z}/N\mathbb{Z})^{*}`. In other words
        :literal:`idealstar(, N, flag)` is short for

        ::

        idealstar(nfinit(x), N, flag)

        but faster. The alternative syntax :literal:`znstar(N, flag)`
        is also available for an analogous effect but, due to an unfortunate
        historical oversight, the default value of :math:`flag` is different in
        the two functions (:literal:`znstar` does not initialize by default, you probably
        want :literal:`znstar(N,1)`).
        '''
        N = objtogen(N)
        cdef bint _have_cycmod = (cycmod is not None)
        if _have_cycmod:
            cycmod = objtogen(cycmod)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _N = (<Gen>N).g
        cdef GEN _cycmod = NULL
        if _have_cycmod:
            _cycmod = (<Gen>cycmod).g
        cdef GEN _ret = idealstarmod(_nf, _N, flag, _cycmod)
        return new_gen(_ret)

    def idealtwoelt(nf, x, a=None):
        r'''
        Computes a two-element representation of the ideal :math:`x` in the number
        field :math:`nf`, combining a random search and an approximation theorem; :math:`x`
        is an ideal in any form (possibly an extended ideal, whose principal part is
        ignored)

        - When called as :literal:`idealtwoelt(nf,x)`, the result is a row vector
        :math:`[a,\alpha]` with two components such that :math:`x = a\mathbb{Z}_{K}+\alpha\mathbb{Z}_{K}` and :math:`a` is
        chosen to be the positive generator of :math:`x\cap\mathbb{Z}`, unless :math:`x` was given as a
        principal ideal in which case we may choose :math:`a = 0`. The algorithm
        uses a fast lazy factorization of :math:`x\cap \mathbb{Z}` and runs in randomized
        polynomial time.

        ::

        ? K = nfinit(t^5-23);
        ? x = idealhnf(K, t^2*(t+1), t^3*(t+1))
        %2 = \\ some random ideal of norm 552*23
        [552 23 23 529 23]
        
        [ 0 23 0 0 0]
        
        [ 0 0 1 0 0]
        
        [ 0 0 0 1 0]
        
        [ 0 0 0 0 1]
        
        ? [a,alpha] = idealtwoelt(K, x)
        %3 = [552, [23, 0, 1, 0, 0]~]
        ? nfbasistoalg(K, alpha)
        %4 = Mod(t^2 + 23, t^5 - 23)

        - When called as :literal:`idealtwoelt(nf,x,a)` with an explicit nonzero :math:`a`
        supplied as third argument, the function assumes that :math:`a \in x` and returns
        :math:`\alpha\in x` such that :math:`x = a\mathbb{Z}_{K} + \alpha\mathbb{Z}_{K}`. Note that we must factor
        :math:`a` in this case, and the algorithm is generally slower than the
        default variant and gives larger generators:

        ::

        ? alpha2 = idealtwoelt(K, x, 552)
        %5 = [-161, -161, -183, -207, 0]~
        ? idealhnf(K, 552, alpha2) == x
        %6 = 1

        Note that, in both cases, the return value is :emphasis:`not`
        recognized as an ideal by GP functions; one must use :literal:`idealhnf` as
        above to recover a valid ideal structure from the two-element representation.
        '''
        x = objtogen(x)
        cdef bint _have_a = (a is not None)
        if _have_a:
            a = objtogen(a)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _a = NULL
        if _have_a:
            _a = (<Gen>a).g
        cdef GEN _ret = idealtwoelt0(_nf, _x, _a)
        return new_gen(_ret)

    def idealval(nf, x, pr):
        r'''
        Gives the valuation of the ideal :math:`x` at the prime ideal :emphasis:`pr` in the
        number field :math:`nf`, where :emphasis:`pr` is in :literal:`idealprimedec` format.
        The valuation of the :math:`0` ideal is :literal:`+oo`.
        '''
        x = objtogen(x)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = gpidealval(_nf, _x, _pr)
        return new_gen(_ret)

    def imag(x):
        r'''
        Imaginary part of :math:`x`. When :math:`x` is a quadratic number, this is the
        coefficient of :math:`\omega` in the "canonical" integral basis :math:`(1,\omega)`.

        ::

        ? imag(3 + I)
        %1 = 1
        ? x = 3 + quadgen(-23);
        ? imag(x) \\ as a quadratic number
        %3 = 1
        ? imag(x * 1.) \\ as a complex number
        %4 = 2.3979157616563597707987190320813469600
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gimag(_x)
        return new_gen(_ret)

    def incgam(s, x, g=None, long precision=DEFAULT_BITPREC):
        r'''
        Incomplete gamma function :math:`\int_{x}^{ oo } e^{-t}t^{s-1}dt`,
        extended by
        analytic continuation to all complex :math:`x, s` not both :math:`0`. The relative error
        is bounded in terms of the precision of :math:`s` (the accuracy of :math:`x` is ignored
        when determining the output precision). When :math:`g` is given, assume that
        :math:`g = \Gamma (s)`. For small :math:`\|x\|`, this will speed up the computation.
        '''
        x = objtogen(x)
        cdef bint _have_g = (g is not None)
        if _have_g:
            g = objtogen(g)
        sig_on()
        cdef GEN _s = (<Gen>s).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _g = NULL
        if _have_g:
            _g = (<Gen>g).g
        precision = nbits2prec(precision)
        cdef GEN _ret = incgam0(_s, _x, _g, precision)
        return new_gen(_ret)

    def incgamc(s, x, long precision=DEFAULT_BITPREC):
        r'''
        Complementary incomplete gamma function.
        The arguments :math:`x` and :math:`s` are complex numbers such that :math:`s` is not a pole of
        :math:`\Gamma` and :math:`\|x\|/(\|s\|+1)` is not much larger than 1 (otherwise the
        convergence is very slow). The result returned is :math:`\int_{0}^{x}
        e^{-t}t^{s-1}dt`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _s = (<Gen>s).g
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = incgamc(_s, _x, precision)
        return new_gen(_ret)

    def intformal(x, v=None):
        r'''
        formal integration of :math:`x` with respect to the variable :math:`v` (wrt.
        the main variable if :math:`v` is omitted). Since PARI cannot represent
        logarithmic or arctangent terms, any such term in the result will yield an
        error:

        ::

        ? intformal(x^2)
        %1 = 1/3*x^3
        ? intformal(x^2, y)
        %2 = y*x^2
        ? intformal(1/x)
        *** at top-level: intformal(1/x)
        *** ^--------------
        *** intformal: domain error in intformal: residue(series, pole) != 0

        The argument :math:`x` can be of any type. When :math:`x` is a rational function, we
        assume that the base ring is an integral domain of characteristic zero.

        By definition, the main variable of a :literal:`t_POLMOD` is the main variable
        among the coefficients from its two polynomial components
        (representative and modulus); in other words, assuming a polmod represents an
        element of :math:`R[X]/(T(X))`, the variable :math:`X` is a mute variable and the
        integral is taken with respect to the main variable used in the base ring :math:`R`.
        In particular, it is meaningless to integrate with respect to the main
        variable of :literal:`x.mod`:

        ::

        ? intformal(Mod(1,x^2+1), 'x)
        *** intformal: incorrect priority in intformal: variable x = x
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = integ(_x, _v)
        return new_gen(_ret)

    def intnuminit(a, b, long m=0, long precision=DEFAULT_BITPREC):
        r'''
        Initialize tables for integration from
        :math:`a` to :math:`b`, where :math:`a` and :math:`b` are coded as in :literal:`intnum`. Only the
        compactness, the possible existence of singularities, the speed of decrease
        or the oscillations at infinity are taken into account, and not the values.
        For instance ``intnuminit(-1,1)`` is equivalent to ``intnuminit(0,Pi)``,
        and ``intnuminit([0,-1/2],oo)`` is equivalent to
        ``intnuminit([-1,-1/2], -oo)``; on the other hand, the order matters
        and
        ``intnuminit([0,-1/2], [1,-1/3])`` is :emphasis:`not` equivalent to
        ``intnuminit([0,-1/3], [1,-1/2])`` !

        If :math:`m` is present, it must be nonnegative and we multiply the default
        number of sampling points by :math:`2^{m}` (increasing the running time by a
        similar factor).

        The result is technical and liable to change in the future, but we document
        it here for completeness. Let :math:`x = \phi (t)`, :math:`t\in ]- oo , oo [` be an
        internally chosen change of variable, achieving double exponential decrease of
        the integrand at infinity. The integrator :literal:`intnum` will compute

        .. MATH::

        h \sum_{\|n\| < N} \phi'(nh) F(\phi (nh))

        for some integration step :math:`h` and truncation parameter :math:`N`.
        In basic use, let

        ::

        [h, x0, w0, xp, wp, xm, wm] = intnuminit(a,b);

        - :math:`h` is the integration step

        - :math:`x_{0} = \phi (0)` and :math:`w_{0} = \phi'(0)`,

        - :emphasis:`xp` contains the :math:`\phi (nh)`, :math:`0 < n < N`,

        - :emphasis:`xm` contains the :math:`\phi (nh)`, :math:`0 < -n < N`, or is empty.

        - :emphasis:`wp` contains the :math:`\phi'(nh)`, :math:`0 < n < N`,

        - :emphasis:`wm` contains the :math:`\phi'(nh)`, :math:`0 < -n < N`, or is empty.

        The arrays :emphasis:`xm` and :emphasis:`wm` are left empty when :math:`\phi` is an odd
        function. In complicated situations,
        :literal:`intnuminit` may return up to :math:`3` such arrays, corresponding
        to a splitting of up to :math:`3` integrals of basic type.

        If the functions to be integrated later are of the form :math:`F = f(t) k(t,z)`
        for some kernel :math:`k` (e.g. Fourier, Laplace, Mellin,...), it is
        useful to also precompute the values of :math:`f(\phi (nh))`, which is accomplished
        by :literal:`intfuncinit`. The hard part is to determine the behavior
        of :math:`F` at endpoints, depending on :math:`z`.
        '''
        b = objtogen(b)
        sig_on()
        cdef GEN _a = (<Gen>a).g
        cdef GEN _b = (<Gen>b).g
        precision = nbits2prec(precision)
        cdef GEN _ret = intnuminit(_a, _b, m, precision)
        return new_gen(_ret)

    def isfundamental(D):
        r'''
        True (1) if :math:`D` is equal to 1 or to the discriminant of a quadratic
        field, false (0) otherwise. :math:`D` can be input in factored form as for
        arithmetic functions:

        ::

        ? isfundamental(factor(-8))
        %1 = 1
        \\ count fundamental discriminants up to 10^8
        ? c = 0; forfactored(d = 1, 10^8, if (isfundamental(d), c++)); c
        time = 40,840 ms.
        %2 = 30396325
        ? c = 0; for(d = 1, 10^8, if (isfundamental(d), c++)); c
        time = 1min, 33,593 ms. \\ slower !
        %3 = 30396325
        '''
        sig_on()
        cdef GEN _D = (<Gen>D).g
        cdef long _ret = isfundamental(_D)
        clear_stack()
        return _ret

    def ispolygonal(x, s, N=None):
        r'''
        True (1) if the integer :math:`x` is an s-gonal number, false (0) if not.
        The parameter :math:`s > 2` must be a :literal:`t_INT`. If :math:`N` is given, set it to :math:`n`
        if :math:`x` is the :math:`n`-th :math:`s`-gonal number.

        ::

        ? ispolygonal(36, 3, &N)
        %1 = 1
        ? N
        '''
        s = objtogen(s)
        cdef bint _have_N = (N is not None)
        if _have_N:
            raise NotImplementedError("optional argument N not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN * _N = NULL
        cdef long _ret = ispolygonal(_x, _s, _N)
        clear_stack()
        return _ret

    def ispower(x, k=None, n=None):
        r'''
        If :math:`k` is given, returns true (1) if :math:`x` is a :math:`k`-th power, false
        (0) if not. What it means to be a :math:`k`-th power depends on the type of
        :math:`x`; see :literal:`issquare` for details.

        If :math:`k` is omitted, only integers and fractions are allowed for :math:`x` and the
        function returns the maximal :math:`k >= 2` such that :math:`x = n^{k}` is a perfect
        power, or 0 if no such :math:`k` exist; in particular :literal:`ispower(-1)`,
        :literal:`ispower(0)`, and :literal:`ispower(1)` all return :math:`0`.

        If a third argument :math:`&n` is given and :math:`x` is indeed a :math:`k`-th power, sets
        :math:`n` to a :math:`k`-th root of :math:`x`.

        For a :literal:`t_FFELT` :literal:`x`, instead of omitting :literal:`k` (which is
        not allowed for this type), it may be natural to set

        ::

        k = (x.p ^ x.f - 1) / fforder(x)
        '''
        cdef bint _have_k = (k is not None)
        if _have_k:
            k = objtogen(k)
        cdef bint _have_n = (n is not None)
        if _have_n:
            raise NotImplementedError("optional argument n not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _k = NULL
        if _have_k:
            _k = (<Gen>k).g
        cdef GEN * _n = NULL
        cdef long _ret = ispower(_x, _k, _n)
        clear_stack()
        return _ret

    def ispowerful(x):
        r'''
        True (1) if :math:`x` is a powerful integer, false (0) if not;
        an integer is powerful if and only if its valuation at all primes dividing
        :math:`x` is greater than 1.

        ::

        ? ispowerful(50)
        %1 = 0
        ? ispowerful(100)
        %2 = 1
        ? ispowerful(5^3*(10^1000+1)^2)
        %3 = 1
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = ispowerful(_x)
        clear_stack()
        return _ret

    def isprime(x, long flag=0):
        r'''
        True (1) if :math:`x` is a prime
        number, false (0) otherwise. A prime number is a positive integer having
        exactly two distinct divisors among the natural numbers, namely 1 and
        itself.

        This routine proves or disproves rigorously that a number is prime, which can
        be very slow when :math:`x` is indeed a large prime integer. For instance
        a :math:`1000` digits prime should require 15 to 30 minutes with default algorithms.
        Use :literal:`ispseudoprime` to quickly check for compositeness. Use
        :literal:`primecert` in order to obtain a primality proof instead of a yes/no
        answer; see also :literal:`factor`.

        The function accepts vector/matrices arguments, and is then
        applied componentwise.

        If :math:`flag = 0`, use a combination of

        - Baillie-Pomerance-Selfridge-Wagstaff compositeness test
        (see :literal:`ispseudoprime`),

        - Selfridge ":math:`p-1`" test if :math:`x-1` is smooth enough,

        - Adleman-Pomerance-Rumely-Cohen-Lenstra (APRCL) for general
        medium-sized :math:`x` (less than 1500 bits),

        - Atkin-Morain's Elliptic Curve Primality Prover (ECPP) for general
        large :math:`x`.

        If :math:`flag = 1`, use Selfridge-Pocklington-Lehmer ":math:`p-1`" test; this requires
        partially factoring various auxilliary integers and is likely to be very slow.

        If :math:`flag = 2`, use APRCL only.

        If :math:`flag = 3`, use ECPP only.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gisprime(_x, flag)
        return new_gen(_ret)

    def isprimepower(x, n=None):
        r'''
        If :math:`x = p^{k}` is a prime power (:math:`p` prime, :math:`k > 0`), return :math:`k`, else
        return 0. If a second argument :math:`&n` is given and :math:`x` is indeed
        the :math:`k`-th power of a prime :math:`p`, sets :math:`n` to :math:`p`.
        '''
        cdef bint _have_n = (n is not None)
        if _have_n:
            raise NotImplementedError("optional argument n not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _n = NULL
        cdef long _ret = isprimepower(_x, _n)
        clear_stack()
        return _ret

    def ispseudoprime(x, long flag=0):
        r'''
        True (1) if :math:`x` is a strong pseudo
        prime (see below), false (0) otherwise. If this function returns false, :math:`x`
        is not prime; if, on the other hand it returns true, it is only highly likely
        that :math:`x` is a prime number. Use :literal:`isprime` (which is of course much
        slower) to prove that :math:`x` is indeed prime.
        The function accepts vector/matrices arguments, and is then applied
        componentwise.

        If :math:`flag = 0`, checks whether :math:`x` has no small prime divisors (up to :math:`101`
        included) and is a Baillie-Pomerance-Selfridge-Wagstaff pseudo prime.
        Such a pseudo prime passes a Rabin-Miller test for base :math:`2`,
        followed by a Lucas test for the sequence :math:`(P,1)`, where :math:`P >= 3`
        is the smallest odd integer such that :math:`P^{2} - 4` is not a square mod :math:`x`.
        (Technically, we are using an "almost extra strong Lucas test" that
        checks whether :math:`V_{n}` is :math:`± 2`, without computing :math:`U_{n}`.)

        There are no known composite numbers passing the above test, although it is
        expected that infinitely many such numbers exist. In particular, all
        composites :math:`<= 2^{64}` are correctly detected (checked using
        :literal:`https://www.cecm.sfu.ca/Pseudoprimes/index-2-to-64.html`).

        If :math:`flag > 0`, checks whether :math:`x` is a strong Miller-Rabin pseudo prime for
        :math:`flag` randomly chosen bases (with end-matching to catch square roots of :math:`-1`).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gispseudoprime(_x, flag)
        return new_gen(_ret)

    def ispseudoprimepower(x, n=None):
        r'''
        If :math:`x = p^{k}` is a pseudo-prime power (:math:`p` pseudo-prime as per
        :literal:`ispseudoprime`, :math:`k > 0`), return :math:`k`, else
        return 0. If a second argument :math:`&n` is given and :math:`x` is indeed
        the :math:`k`-th power of a prime :math:`p`, sets :math:`n` to :math:`p`.

        More precisely, :math:`k` is always the largest integer such that :math:`x = n^{k}` for
        some integer :math:`n` and, when :math:`n <= 2^{64}` the function returns :math:`k > 0` if and
        only if :math:`n` is indeed prime. When :math:`n > 2^{64}` is larger than the threshold,
        the function may return :math:`1` even though :math:`n` is composite: it only passed
        an :literal:`ispseudoprime(n)` test.
        '''
        cdef bint _have_n = (n is not None)
        if _have_n:
            raise NotImplementedError("optional argument n not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _n = NULL
        cdef long _ret = ispseudoprimepower(_x, _n)
        clear_stack()
        return _ret

    def issquare(x, n=None):
        r'''
        True (1) if :math:`x` is a square, false (0)
        if not. What "being a square" means depends on the type of :math:`x`: all
        :literal:`t_COMPLEX` are squares, as well as all nonnegative :literal:`t_REAL`; for
        exact types such as :literal:`t_INT`, :literal:`t_FRAC` and :literal:`t_INTMOD`, squares are
        numbers of the form :math:`s^{2}` with :math:`s` in :math:`\mathbb{Z}`, :math:`\mathbb{Q}` and :math:`\mathbb{Z}/N\mathbb{Z}` respectively.

        ::

        ? issquare(3) \\ as an integer
        %1 = 0
        ? issquare(3.) \\ as a real number
        %2 = 1
        ? issquare(Mod(7, 8)) \\ in Z/8Z
        %3 = 0
        ? issquare( 5 + O(13^4) ) \\ in Q_13
        %4 = 0

        If :math:`n` is given, a square root of :math:`x` is put into :math:`n`.

        ::

        ? issquare(4, &n)
        %1 = 1
        ? n
        %2 = 2

        For polynomials, either we detect that the characteristic is 2 (and check
        directly odd and even-power monomials) or we assume that :math:`2` is invertible
        and check whether squaring the truncated power series for the square root
        yields the original input.

        For :literal:`t_POLMOD` :math:`x`, we only support :literal:`t_POLMOD` s of :literal:`t_INTMOD` s
        encoding finite fields, assuming without checking that the intmod modulus
        :math:`p` is prime and that the polmod modulus is irreducible modulo :math:`p`.

        ::

        ? issquare(Mod(Mod(2,3), x^2+1), &n)
        %1 = 1
        ? n
        %2 = Mod(Mod(2, 3)*x, Mod(1, 3)*x^2 + Mod(1, 3))
        '''
        cdef bint _have_n = (n is not None)
        if _have_n:
            raise NotImplementedError("optional argument n not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _n = NULL
        cdef long _ret = issquareall(_x, _n)
        clear_stack()
        return _ret

    def issquarefree(x):
        r'''
        True (1) if :math:`x` is squarefree, false (0) if not. Here :math:`x` can be an
        integer or a polynomial with coefficients in an integral domain.

        ::

        ? issquarefree(12)
        %1 = 0
        ? issquarefree(6)
        %2 = 1
        ? issquarefree(x^3+x^2)
        %3 = 0
        ? issquarefree(Mod(1,4)*(x^2+x+1)) \\ Z/4Z is not a domain !
        *** at top-level: issquarefree(Mod(1,4)*(x^2+x+1))
        *** ^--------------------------------
        *** issquarefree: impossible inverse in Fp_inv: Mod(2, 4).

        A polynomial is declared squarefree if :literal:`gcd`:math:`(x,x')` is
        :math:`1`. In particular a nonzero polynomial with inexact coefficients is
        considered to be squarefree. Note that this may be inconsistent with
        :literal:`factor`, which first rounds the input to some exact approximation before
        factoring in the apropriate domain; this is correct when the input is not
        close to an inseparable polynomial (the resultant of :math:`x` and :math:`x'` is not
        close to :math:`0`).

        An integer can be input in factored form as in arithmetic functions.

        ::

        ? issquarefree(factor(6))
        %1 = 1
        \\ count squarefree integers up to 10^8
        ? c = 0; for(d = 1, 10^8, if (issquarefree(d), c++)); c
        time = 3min, 2,590 ms.
        %2 = 60792694
        ? c = 0; forfactored(d = 1, 10^8, if (issquarefree(d), c++)); c
        time = 45,348 ms. \\ faster !
        %3 = 60792694
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = issquarefree(_x)
        clear_stack()
        return _ret

    def istotient(x, N=None):
        r'''
        True (1) if :math:`x = \phi (n)` for some integer :math:`n`, false (0)
        if not.

        ::

        ? istotient(14)
        %1 = 0
        ? istotient(100)
        %2 = 0

        If :math:`N` is given, set :math:`N = n` as well.

        ::

        ? istotient(4, &n)
        %1 = 1
        ? n
        %2 = 10
        '''
        cdef bint _have_N = (N is not None)
        if _have_N:
            raise NotImplementedError("optional argument N not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _N = NULL
        cdef long _ret = istotient(_x, _N)
        clear_stack()
        return _ret

    def kronecker(x, y):
        r'''
        Kronecker symbol :math:`(x\|y)`, where :math:`x` and :math:`y` must be of type integer. By
        definition, this is the extension of Legendre symbol to :math:`\mathbb{Z} x \mathbb{Z}`
        by total multiplicativity in both arguments with the following special rules
        for :math:`y = 0, -1` or :math:`2`:

        - :math:`(x\|0) = 1` if :math:`\|x \|= 1` and :math:`0` otherwise.

        - :math:`(x\|-1) = 1` if :math:`x >= 0` and :math:`-1` otherwise.

        - :math:`(x\|2) = 0` if :math:`x` is even and :math:`1` if :math:`x = 1,-1 mod 8` and :math:`-1`
        if :math:`x = 3,-3 mod 8`.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef long _ret = kronecker(_x, _y)
        clear_stack()
        return _ret

    def lambertw(y, long branch=0, long precision=DEFAULT_BITPREC):
        r'''
        Lambert :math:`W` function, solution of the implicit equation :math:`xe^{x} = y`.

        - For real inputs :math:`y`:
        If :literal:`branch = 0`, principal branch :math:`W_{0}` defined for :math:`y >= -\exp (-1)`.
        If :literal:`branch = -1`, branch :math:`W_{-1}` defined for :math:`-\exp (-1) <= y < 0`.

        - For :math:`p`-adic inputs, :math:`p` odd: give a solution of :math:`x\exp (x) = y` if :math:`y` has
        positive valuation, of :math:`\log (x)+x = \log (y)` otherwise.

        - For :math:`2`-adic inputs: give a solution of :math:`x\exp (x) = y` if :math:`y` has
        valuation :math:`> 1`, of :math:`\log (x)+x = \log (y)` otherwise.

        :strong:`Caveat.`
        Complex values of :math:`y` are also supported but experimental. The other
        branches :math:`W_{k}` for :math:`k` not equal to :math:`0` or :math:`-1` (set :literal:`branch` to :math:`k`)
        are also experimental.

        For :math:`k >= 1`, :math:`W_{-1-k}(x) = \overline{W_{k}(x)}`, and :math:`\Im (W_{k}(x))` is
        close to :math:`(\pi/2)(4k-sign(x))`.
        '''
        sig_on()
        cdef GEN _y = (<Gen>y).g
        precision = nbits2prec(precision)
        cdef GEN _ret = glambertW(_y, branch, precision)
        return new_gen(_ret)

    def laurentseries(f, long serprec=-1, M=None, long precision=DEFAULT_BITPREC):
        r'''
        Expand :math:`f` as a Laurent series around :math:`x = 0` to order :math:`M`. This
        function computes :math:`f(x + O(x^{n}))` until :math:`n` is large enough: it
        must be possible to evaluate :math:`f` on a power series with :math:`0` constant term.

        ::

        ? laurentseries(t->sin(t)/(1-cos(t)), 5)
        %1 = 2*x^-1 - 1/6*x - 1/360*x^3 - 1/15120*x^5 + O(x^6)
        ? laurentseries(log)
        *** at top-level: laurentseries(log)
        *** ^------------------
        *** in function laurentseries: log
        *** ^---
        *** log: domain error in log: series valuation != 0

        Note that individual Laurent coefficients of order :math:`<= M`
        can be retrieved from :math:`s = laurentseries (f,M)` via :literal:`polcoef(s,i)`
        for any :math:`i <= M`. The series :math:`s` may occasionally be more precise that
        the required :math:`O(x^{M+1})`.

        With respect to successive calls to :literal:`derivnum`,
        :literal:`laurentseries` is both faster and more precise:

        ::

        ? laurentseries(t->log(3+t),1)
        %1 = 1.0986122886681096913952452369225257047 + 1/3*x - 1/18*x^2 + O(x^3)
        ? derivnum(t=0,log(3+t),1)
        %2 = 0.33333333333333333333333333333333333333
        ? derivnum(t=0,log(3+t),2)
        %3 = -0.11111111111111111111111111111111111111
        
        ? f = x->sin(exp(x));
        ? polcoef(laurentseries(x->f(x+2), 1), 1)
        %5 = 3.3129294231043339804683687620360224365
        ? exp(2) * cos(exp(2));
        %6 = 3.3129294231043339804683687620360224365
        ? derivnum(x = 2, f(x))
        %7 = 3.3129294231043339804683687620360224364 \\ 1 ulp off
        
        ? default(realprecision,115);
        ? for(i=1,10^4, laurentseries(x->f(x+2),1))
        time = 279 ms.
        ? for(i=1,10^4, derivnum(x=2,f(x))) \\ ... and slower
        time = 1,134 ms.
        '''
        cdef long _M = -1
        if M is not None:
            _M = get_var(M)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        precision = nbits2prec(precision)
        cdef GEN _ret = laurentseries0(_f, serprec, _M, precision)
        return new_gen(_ret)

    def lcm(x, y=None):
        r'''
        Least common multiple of :math:`x` and :math:`y`, i.e. such
        that :math:`\mathrm{lcm} (x,y)*\mathrm{gcd} (x,y) = x*y`, up to units. If :math:`y` is omitted and :math:`x`
        is a vector, returns the :math:`lcm` of all components of :math:`x`.
        For integer arguments, return the nonnegative lcm.

        When :math:`x` and :math:`y` are both given and one of them is a vector/matrix type,
        the LCM is again taken recursively on each component, but in a different way.
        If :math:`y` is a vector, resp. matrix, then the result has the same type as :math:`y`,
        and components equal to :literal:`lcm(x, y[i])`, resp. :literal:`lcm(x, y[,i])`. Else
        if :math:`x` is a vector/matrix the result has the same type as :math:`x` and an
        analogous definition. Note that for these types, :literal:`lcm` is not
        commutative.

        Note that :literal:`lcm(v)` is quite different from

        ::

        l = v[1]; for (i = 1, #v, l = lcm(l, v[i]))

        Indeed, :literal:`lcm(v)` is a scalar, but :literal:`l` may not be (if one of
        the :literal:`v[i]` is a vector/matrix). The computation uses a divide-conquer tree
        and should be much more efficient, especially when using the GMP
        multiprecision kernel (and more subquadratic algorithms become available):

        ::

        ? v = vector(10^5, i, random);
        ? lcm(v);
        time = 546 ms.
        ? l = v[1]; for (i = 1, #v, l = lcm(l, v[i]))
        time = 4,561 ms.
        '''
        cdef bint _have_y = (y is not None)
        if _have_y:
            y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = NULL
        if _have_y:
            _y = (<Gen>y).g
        cdef GEN _ret = glcm0(_x, _y)
        return new_gen(_ret)

    def length(x):
        r'''
        Length of :math:`x`; :literal:`\#`:math:`x` is a shortcut for :literal:`length`:math:`(x)`.
        This is mostly useful for

        - vectors: dimension (0 for empty vectors),

        - lists: number of entries (0 for empty lists),

        - maps: number of entries (0 for empty maps),

        - matrices: number of columns,

        - character strings: number of actual characters (without
        trailing :literal:`\\0`, should you expect it from :math:`C` :literal:`char*`).

        ::

        ? #"a string"
        %1 = 8
        ? #[3,2,1]
        %2 = 3
        ? #[]
        %3 = 0
        ? #matrix(2,5)
        %4 = 5
        ? L = List([1,2,3,4]); #L
        %5 = 4
        ? M = Map([a,b; c,d; e,f]); #M
        %6 = 3

        The routine is in fact defined for arbitrary GP types, but is awkward and
        useless in other cases: it returns the number of non-code words in :math:`x`, e.g.
        the effective length minus 2 for integers since the :literal:`t_INT` type has two code
        words.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = glength(_x)
        clear_stack()
        return _ret

    def lerchphi(z, s, a, long precision=DEFAULT_BITPREC):
        r'''
        Lerch transcendent :math:`\Phi (z,s,a) = \sum_{n >= 0}z^{n}(n+a)^{-s}` and
        analytically continued, for reasonable values of the arguments.
        '''
        s = objtogen(s)
        a = objtogen(a)
        sig_on()
        cdef GEN _z = (<Gen>z).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _a = (<Gen>a).g
        precision = nbits2prec(precision)
        cdef GEN _ret = lerchphi(_z, _s, _a, precision)
        return new_gen(_ret)

    def lerchzeta(s, a, lam, long precision=DEFAULT_BITPREC):
        r'''
        Lerch zeta function

        .. MATH::

        L(s,a,\lambda) = \sum_{n >= 0}e^{2\pi i\lambda n}(n+a)^{-s}

        and analytically continued, for reasonable values of the arguments.
        '''
        a = objtogen(a)
        lam = objtogen(lam)
        sig_on()
        cdef GEN _s = (<Gen>s).g
        cdef GEN _a = (<Gen>a).g
        cdef GEN _lam = (<Gen>lam).g
        precision = nbits2prec(precision)
        cdef GEN _ret = lerchzeta(_s, _a, _lam, precision)
        return new_gen(_ret)

    def lex(x, y):
        r'''
        Gives the result of a lexicographic comparison
        between :math:`x` and :math:`y` (as :math:`-1`, :math:`0` or :math:`1`). This is to be interpreted in quite
        a wide sense: it is admissible to compare objects of different types
        (scalars, vectors, matrices), provided the scalars can be compared, as well
        as vectors/matrices of different lengths; finally, when comparing two scalars,
        a complex number :math:`a + I*b` is interpreted as a vector :math:`[a,b]` and a real
        number :math:`a` as :math:`[a,0]`. The comparison is recursive.

        In case all components are equal up to the smallest length of the operands,
        the more complex is considered to be larger. More precisely, the longest is
        the largest; when lengths are equal, we have matrix :math:`>` vector :math:`>` scalar.
        For example:

        ::

        ? lex([1,3], [1,2,5])
        %1 = 1
        ? lex([1,3], [1,3,-1])
        %2 = -1
        ? lex([1], [[1]])
        %3 = -1
        ? lex([1], [1]~)
        %4 = 0
        ? lex(2 - I, 1)
        %5 = 1
        ? lex(2 - I, 2)
        %6 = -1
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef int _ret = lexcmp(_x, _y)
        clear_stack()
        return _ret

    def lfun(L, s, long D=0, long precision=DEFAULT_BITPREC):
        r'''
        Compute the L-function value :math:`L(s)`, or if :literal:`D` is set, the
        derivative of order :literal:`D` at :math:`s`. The parameter
        :literal:`L` is either an Lmath, an Ldata (created by :literal:`lfuncreate`, or an
        Linit (created by :literal:`lfuninit`), preferrably the latter if many values
        are to be computed.

        The argument :math:`s` is also allowed to be a power series; for instance, if :math:`s =
        \alpha + x + O(x^{n})`, the function returns the Taylor expansion of order :math:`n`
        around :math:`\alpha`. The result is given with absolute error less than :math:`2^{-B}`,
        where :math:`B = realbitprecision`.

        :strong:`Caveat.` The requested precision has a major impact on runtimes.
        It is advised to manipulate precision via :literal:`realbitprecision` as
        explained above instead of :literal:`realprecision` as the latter allows less
        granularity: :literal:`realprecision` increases by increments of 64 bits, i.e. 19
        decimal digits at a time.

        ::

        ? lfun(x^2+1, 2) \\ Lmath: Dedekind zeta for Q(i) at 2
        %1 = 1.5067030099229850308865650481820713960
        
        ? L = lfuncreate(ellinit("5077a1")); \\ Ldata: Hasse-Weil zeta function
        ? lfun(L, 1+x+O(x^4)) \\ zero of order 3 at the central point
        %3 = 0.E-58 - 5.[...] E-40*x + 9.[...] E-40*x^2 + 1.7318[...]*x^3 + O(x^4)
        
        \\ Linit: zeta(1/2+it), |t| < 100, and derivative
        ? L = lfuninit(1, [100], 1);
        ? T = lfunzeros(L, [1,25]);
        %5 = [14.134725[...], 21.022039[...]]
        ? z = 1/2 + I*T[1];
        ? abs( lfun(L, z) )
        %7 = 8.7066865533412207420780392991125136196 E-39
        ? abs( lfun(L, z, 1) )
        %8 = 0.79316043335650611601389756527435211412 \\ simple zero
        '''
        s = objtogen(s)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _ret = lfun0(_L, _s, D, precision)
        return new_gen(_ret)

    def lfunan(L, long n, long precision=DEFAULT_BITPREC):
        r'''
        Compute the first :math:`n` terms of the Dirichlet series attached to the
        :math:`L`-function given by :literal:`L` (:literal:`Lmath`, :literal:`Ldata` or :literal:`Linit`).

        ::

        ? lfunan(1, 10) \\ Riemann zeta
        %1 = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        ? lfunan(5, 10) \\ Dirichlet L-function for kronecker(5,.)
        %2 = [1, -1, -1, 1, 0, 1, -1, -1, 1, 0]
        '''
        sig_on()
        cdef GEN _L = (<Gen>L).g
        precision = nbits2prec(precision)
        cdef GEN _ret = lfunan(_L, n, precision)
        return new_gen(_ret)

    def lfunartin(nf, gal, rho, long n, long precision=DEFAULT_BITPREC):
        r'''
        Returns the :literal:`Ldata` structure attached to the
        Artin :math:`L`-function provided by the representation :math:`\rho` of the Galois group
        of the extension :math:`K/\mathbb{Q}`, defined over the cyclotomic field :math:`\mathbb{Q} (\zeta_{n})`,
        where :emphasis:`nf` is the nfinit structure attached to :math:`K`,
        :emphasis:`gal` is the galoisinit structure attached to :math:`K/\mathbb{Q}`, and :emphasis:`rho` is
        given either

        - by the values of its character on the conjugacy classes
        (see :literal:`galoisconjclasses` and :literal:`galoischartable`)

        - or by the matrices that are the images of the generators
        :literal:`:emphasis:`gal`.gen`.

        Cyclotomic numbers in :literal:`rho` are represented by polynomials, whose
        variable is understood as the complex number :math:`\exp (2 i \pi/n)`.

        In the following example we build the Artin :math:`L`-functions attached to the two
        irreducible degree :math:`2` representations of the dihedral group :math:`D_{10}` defined
        over :math:`\mathbb{Q} (\zeta_{5})`, for the extension :math:`H/\mathbb{Q}` where :math:`H` is the Hilbert class
        field of :math:`\mathbb{Q} (\sqrt{-47})`.
        We show numerically some identities involving Dedekind :math:`\zeta` functions and
        Hecke :math:`L` series.

        ::

        ? P = quadhilbert(-47)
        %1 = x^5 + 2*x^4 + 2*x^3 + x^2 - 1
        ? N = nfinit(nfsplitting(P));
        ? G = galoisinit(N); \\ D_10
        ? [T,n] = galoischartable(G);
        ? T \\ columns give the irreducible characters
        %5 =
        [1 1 2 2]
        
        [1 -1 0 0]
        
        [1 1 -y^3 - y^2 - 1 y^3 + y^2]
        
        [1 1 y^3 + y^2 -y^3 - y^2 - 1]
        ? n
        %6 = 5
        ? L2 = lfunartin(N,G, T[,2], n);
        ? L3 = lfunartin(N,G, T[,3], n);
        ? L4 = lfunartin(N,G, T[,4], n);
        ? s = 1 + x + O(x^4);
        ? lfun(-47,s) - lfun(L2,s)
        %11 ~ 0
        ? lfun(1,s)*lfun(-47,s)*lfun(L3,s)^2*lfun(L4,s)^2 - lfun(N,s)
        %12 ~ 0
        ? lfun(1,s)*lfun(L3,s)*lfun(L4,s) - lfun(P,s)
        %13 ~ 0
        ? bnr = bnrinit(bnfinit(x^2+47),1,1);
        ? bnr.cyc
        %15 = [5] \\ Z/5Z: 4 nontrivial ray class characters
        ? lfun([bnr,[1]], s) - lfun(L3, s)
        %16 ~ 0
        ? lfun([bnr,[2]], s) - lfun(L4, s)
        %17 ~ 0
        ? lfun([bnr,[3]], s) - lfun(L3, s)
        %18 ~ 0
        ? lfun([bnr,[4]], s) - lfun(L4, s)
        %19 ~ 0

        The first identity identifies the nontrivial abelian character with
        :math:`(-47,.)`; the second is the factorization of the regular representation of
        :math:`D_{10}`; the third is the factorization of the natural representation of
        :math:`D_{10}\subset S_{5}`; and the final four are the expressions of the degree :math:`2`
        representations as induced from degree :math:`1` representations.
        '''
        gal = objtogen(gal)
        rho = objtogen(rho)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _gal = (<Gen>gal).g
        cdef GEN _rho = (<Gen>rho).g
        cdef GEN _ret = lfunartin(_nf, _gal, _rho, n, precision)
        return new_gen(_ret)

    def lfuncheckfeq(L, t=None, long precision=DEFAULT_BITPREC):
        r'''
        Given the data attached to an :math:`L`-function (:literal:`Lmath`, :literal:`Ldata`
        or :literal:`Linit`), check whether the functional equation is satisfied.
        This is most useful for an :literal:`Ldata` constructed "by hand", via
        :literal:`lfuncreate`, to detect mistakes.

        If the function has poles, the polar part must be specified. The routine
        returns a bit accuracy :math:`b` such that :math:`\|w - ^{w}\| < 2^{b}`, where :math:`w` is
        the root number contained in :literal:`data`, and

        .. MATH::

        ^{w} = \theta (1/t) t^{-k} / \overline{\theta}(t)

        is a computed value
        derived from the assumed functional equation.
        Of course, the expected result is a large negative value of the order of
        :literal:`realbitprecision`. But if :math:`\overline{\theta}` is very small
        at :math:`t`, you should first increase :literal:`realbitprecision` by
        :math:`-\log_{2} \|\overline{\theta}(t)\|`, which is
        positive if :math:`\theta` is small, to get a meaningful result.
        Note that :math:`t` should be close to the unit disc for efficiency and such that
        :math:`\overline{\theta}(t) ! = 0`. If the parameter :math:`t` is omitted, we check the
        functional equation at the "random" complex number :math:`t = 335/339 + I/7`.

        ::

        ? \pb 128 \\ 128 bits of accuracy
        ? default(realbitprecision)
        %1 = 128
        ? L = lfuncreate(1); \\ Riemann zeta
        ? lfuncheckfeq(L)
        %3 = -124

        i.e. the given data is consistent to within 4 bits for the
        particular check consisting of estimating the root number from all other
        given quantities. Checking away from the unit disc will either fail with
        a precision error, or give disappointing results (if :math:`\theta (1/t)` is
        large it will be computed with a large absolute error)

        ::

        ? lfuncheckfeq(L, 2+I)
        %4 = -115
        ? lfuncheckfeq(L,10)
        *** at top-level: lfuncheckfeq(L,10)
        *** ^------------------
        *** lfuncheckfeq: precision too low in lfuncheckfeq.

        :strong:`The case of Dedekind zeta functions.` Dedekind zeta function for
        a number field :math:`K = \mathbb{Q}[X]/(T)` is in general computed
        (assuming Artin conjecture) as :math:`(\zeta_{K}/\zeta_{k}) x \zeta_{k}`,
        where :math:`k` is a
        maximal subfield, applied recursively if possible. When :math:`K/\mathbb{Q}` is Galois,
        the zeta function is directly decomposed as a product of Artin
        :math:`L`-functions.

        These decompositions are computed when :literal:`lfuninit` is called. The
        behavior of :literal:`lfuncheckfeq` is then different depending of its argument

        - the artificial query :literal:`lfuncheckfeq`:math:`(T)` serves little purpose
        since we already know that the technical parameters are theoretically
        correct; we just obtain an estimate on the accuracy they allow. This is
        computed directly, without using the above decomposition. And is likely to
        be very costly if the degree of :math:`T` is large, possibly overflowing the
        possibilities of the implementation.

        - a query :literal:`L = lfuninit(T, ...); lfuncheckfeq(L)` on the other hand
        returns the maximum of the :literal:`lfuncheckfeq` values for all involved
        :math:`L`-functions, giving a general consistency check and again an estimate
        for the accuracy of computed values.

        At the default accuracy of 128 bits:

        ::

        ? T = polcyclo(43);
        ? lfuncheckfeq(T);
        *** at top-level: lfuncheckfeq(T)
        *** ^---------------
        *** lfuncheckfeq: overflow in lfunthetacost.
        ? lfuncheckfeq(lfuninit(T, [2]))
        time = 107 ms.
        %2 = -122
        '''
        cdef bint _have_t = (t is not None)
        if _have_t:
            t = objtogen(t)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _t = NULL
        if _have_t:
            _t = (<Gen>t).g
        cdef long _ret = lfuncheckfeq(_L, _t, precision)
        clear_stack()
        return _ret

    def lfunconductor(L, setN=None, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Computes the conductor of the given :math:`L`-function (if the structure
        contains a conductor, it is ignored). Two methods are available,
        depending on what we know about the conductor, encoded in the :literal:`setN`
        parameter:

        - :literal:`setN` is a scalar: we know nothing but expect that the conductor
        lies in the interval :math:`[1, setN]`.

        If :math:`flag` is :math:`0` (default), gives either the conductor found as an
        integer, or a vector (possibly empty) of conductors found. If :math:`flag` is
        :math:`1`, same but gives the computed floating point approximations to the
        conductors found, without rounding to integers. It :math:`flag` is :math:`2`, gives
        all the conductors found, even those far from integers.

        :strong:`Caveat.` This is a heuristic program and the result is not
        proven in any way:

        ::

        ? L = lfuncreate(857); \\ Dirichlet L function for kronecker(857,.)
        ? \p19
        realprecision = 19 significant digits
        ? lfunconductor(L)
        %2 = [17, 857]
        ? lfunconductor(L,,1) \\ don't round
        %3 = [16.99999999999999999, 857.0000000000000000]
        
        ? \p38
        realprecision = 38 significant digits
        ? lfunconductor(L)
        %4 = 857

        Increasing :literal:`setN` or increasing :literal:`realbitprecision`
        slows down the program but gives better accuracy for the result. This
        algorithm should only be used if the primes dividing the conductor are
        unknown, which is uncommon.

        - :literal:`setN` is a vector of possible conductors; for instance
        of the form :literal:`D1 * divisors(D2)`, where :math:`D_{1}` is the known part
        of the conductor and :math:`D_{2}` is a multiple of the contribution of the
        bad primes.

        In that case, :math:`flag` is ignored and the routine uses :literal:`lfuncheckfeq`.
        It returns :math:`[N,e]` where :math:`N` is the best conductor in the list and :math:`e` is the
        value of :literal:`lfuncheckfeq` for that :math:`N`. When no suitable conductor exist or
        there is a tie among best potential conductors, return the empty vector
        :literal:`[]`.

        ::

        ? E = ellinit([0,0,0,4,0]); /* Elliptic curve y^2 = x^3+4x */
        ? E.disc \\ |disc E| = 2^12
        %2 = -4096
        \\ create Ldata by hand. Guess that root number is 1 and conductor N
        ? L(N) = lfuncreate([n->ellan(E,n), 0, [0,1], 2, N, 1]);
        \\ lfunconductor ignores conductor = 1 in Ldata !
        ? lfunconductor(L(1), divisors(E.disc))
        %5 = [32, -127]
        ? fordiv(E.disc, d, print(d,": ",lfuncheckfeq(L(d)))) \\ direct check
        1: 0
        2: 0
        4: -1
        8: -2
        16: -3
        32: -127
        64: -3
        128: -2
        256: -2
        512: -1
        1024: -1
        2048: 0
        4096: 0

        The above code assumed that root number was :math:`1`;
        had we set it to :math:`-1`, none of the :literal:`lfuncheckfeq` values would have been
        acceptable:

        ::

        ? L2 = lfuncreate([n->ellan(E,n), 0, [0,1], 2, 0, -1]);
        ? lfunconductor(L2, divisors(E.disc))
        %7 = []
        '''
        cdef bint _have_setN = (setN is not None)
        if _have_setN:
            setN = objtogen(setN)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _setN = NULL
        if _have_setN:
            _setN = (<Gen>setN).g
        cdef GEN _ret = lfunconductor(_L, _setN, flag, precision)
        return new_gen(_ret)

    def lfuncost(L, sdom=None, long der=0, long precision=DEFAULT_BITPREC):
        r'''
        Estimate the cost of running
        :literal:`lfuninit(L,sdom,der)` at current bit precision, given by a vector
        :math:`[t, b]`.

        - If :math:`L` contains the root number, indicate that :math:`t` coefficients :math:`a_{n}`
        will be computed, as well as :math:`t` values of :literal:`gammamellininv`, all at bit
        accuracy :math:`b`. A subsequent call to :literal:`lfun` at :math:`s` evaluates a polynomial
        of degree :math:`t` at :math:`\exp (h s)` for some real parameter :math:`h`, at the same bit
        accuracy :math:`b`.

        - If the root number is :emphasis:`not` known, then more values of :math:`a_{n}` may
        be needed in order to compute it, and the returned value of :math:`t` takes this
        into account (it may not be the exact value in this case but is always
        an upper bound). Fewer than :math:`t` :literal:`gammamellininv` will be needed, and
        a call to :literal:`lfun` evaluates a polynomial of degree less that :math:`t`, still
        at bit accuracy :math:`b`.

        If :math:`L` is already an :literal:`Linit`, then :emphasis:`sdom` and :emphasis:`der` are ignored
        and are best left omitted; the bit accuracy is also inferred from :math:`L`: in
        short we get an estimate of the cost of using that particular :literal:`Linit`.
        Note that in this case, the root number is always already known and you get
        the right value of :math:`t` (corresponding to the number of past calls to
        :literal:`gammamellinv` and the actual degree of the evaluated polynomial).

        ::

        ? \pb 128
        ? lfuncost(1, [100]) \\ for zeta(1/2+I*t), |t| < 100
        %1 = [7, 242] \\ 7 coefficients, 242 bits
        ? lfuncost(1, [1/2, 100]) \\ for zeta(s) in the critical strip, |Im s| < 100
        %2 = [7, 246] \\ now 246 bits
        ? lfuncost(1, [100], 10) \\ for zeta(1/2+I*t), |t| < 100
        %3 = [8, 263] \\ 10th derivative increases the cost by a small amount
        ? lfuncost(1, [10^5])
        %3 = [158, 113438] \\ larger imaginary part: huge accuracy increase
        
        ? L = lfuncreate(polcyclo(5)); \\ Dedekind zeta for Q(zeta_5)
        ? lfuncost(L, [100]) \\ at s = 1/2+I*t), |t| < 100
        %5 = [11457, 582]
        ? lfuncost(L, [200]) \\ twice higher
        %6 = [36294, 1035]
        ? lfuncost(L, [10^4]) \\ much higher: very costly !
        %7 = [70256473, 45452]
        ? \pb 256
        ? lfuncost(L, [100]); \\ doubling bit accuracy is cheaper
        %8 = [17080, 710]
        
        ? \p38
        ? K = bnfinit(y^2 - 4493); [P] = idealprimedec(K,1123); f = [P,[1,1]];
        ? R = bnrinit(K, f); R.cyc
        %10 = [1122]
        ? L = lfuncreate([R, [7]]); \\ Hecke L-function
        ? L[6]
        %12 = 0 \\ unknown root number
        ? \pb 3000
        ? lfuncost(L, [0], 1)
        %13 = [1171561, 3339]
        ? L = lfuninit(L, [0], 1);
        time = 1min, 56,426 ms.
        ? lfuncost(L)
        %14 = [826966, 3339]

        In the final example, the root number was unknown and
        extra coefficients :math:`a_{n}` were needed to compute it (:math:`1171561`). Once the
        initialization is performed we obtain the lower value :math:`t = 826966`, which
        corresponds to the number of :literal:`gammamellinv` computed and the actual
        degree of the polynomial to be evaluated to compute a value within the
        prescribed domain.

        Finally, some :math:`L` functions can be factorized algebraically
        by the :literal:`lfuninit` call, e.g. the Dedekind zeta function of abelian
        fields, leading to much faster evaluations than the above upper bounds.
        In that case, the function returns a vector of costs as above for each
        individual function in the product actually evaluated:

        ::

        ? L = lfuncreate(polcyclo(5)); \\ Dedekind zeta for Q(zeta_5)
        ? lfuncost(L, [100]) \\ a priori cost
        %2 = [11457, 582]
        ? L = lfuninit(L, [100]); \\ actually perform all initializations
        ? lfuncost(L)
        %4 = [[16, 242], [16, 242], [7, 242]]

        The Dedekind function of this abelian quartic field
        is the product of four Dirichlet :math:`L`-functions attached to the trivial
        character, a nontrivial real character and two complex conjugate
        characters. The nontrivial characters happen to have the same conductor
        (hence same evaluation costs), and correspond to two evaluations only
        since the two conjugate characters are evaluated simultaneously.
        For a total of three :math:`L`-functions evaluations, which explains the three
        components above. Note that the actual cost is much lower than the a priori
        cost in this case.
        '''
        cdef bint _have_sdom = (sdom is not None)
        if _have_sdom:
            sdom = objtogen(sdom)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _sdom = NULL
        if _have_sdom:
            _sdom = (<Gen>sdom).g
        cdef GEN _ret = lfuncost0(_L, _sdom, der, precision)
        return new_gen(_ret)

    def lfuncreate(obj):
        r'''
        This low-level routine creates :literal:`Ldata` structures, needed by
        :emphasis:`lfun` functions, describing an :math:`L`-function and its functional equation.
        We advise using a high-level constructor when one is available, see
        :literal:`??lfun`, and this function accepts them:

        ::

        ? L = lfuncreate(1); \\ Riemann zeta
        ? L = lfuncreate(5); \\ Dirichlet L-function for quadratic character (5/.)
        ? L = lfuncreate(x^2+1); \\ Dedekind zeta for Q(i)
        ? L = lfuncreate(ellinit([0,1])); \\ L-function of E/Q: y^2=x^3+1

        One can then use, e.g., :literal:`lfun(L,s)` to directly
        evaluate the respective :math:`L`-functions at :math:`s`, or :literal:`lfuninit(L, [c,w,h]`
        to initialize computations in the rectangular box :math:`\Re (s-c) <= w`,
        :math:`\Im (s) <= h`.

        We now describe the low-level interface, used to input nonbuiltin
        :math:`L`-functions. The input is now a :math:`6` or :math:`7` component vector
        :math:`V = [a, astar, Vga, k, N, eps, poles]`, whose components are as follows:

        - :literal:`V[1] = a` encodes the Dirichlet series coefficients :math:`(a_{n})`. The
        preferred format is a closure of arity 1: :literal:`n- > vector(n,i,a(i))` giving
        the vector of the first :math:`n` coefficients. The closure is allowed to return
        a vector of more than :math:`n` coefficients (only the first :math:`n` will be
        considered) or even less than :math:`n`, in which case loss of accuracy will occur
        and a warning that :literal:`\#an` is less than expected is issued. This
        allows to precompute and store a fixed large number of Dirichlet
        coefficients in a vector :math:`v` and use the closure :literal:`n- > v`, which
        does not depend on :math:`n`. As a shorthand for this latter case, you can input
        the vector :math:`v` itself instead of the closure.

        ::

        ? z = lfuncreate([n->vector(n,i,1), 1, [0], 1, 1, 1, 1]); \\ Riemann zeta
        ? lfun(z,2) - Pi^2/6
        %2 = -5.877471754111437540 E-39

        A second format is limited to :math:`L`-functions affording an
        Euler product. It is a closure of arity 2 :literal:`(p,d)- > F(p)` giving the
        local factor :math:`L_{p}(X)` at :math:`p` as a rational function, to be evaluated at
        :math:`p^{-s}` as in :literal:`direuler`; :math:`d` is set to :literal:`logint`:math:`(n,p)` + 1, where
        :math:`n` is the total number of Dirichlet coefficients :math:`(a_{1},...,a_{n})` that will
        be computed. In other words, the smallest integer :math:`d` such that :math:`p^{d} > n`.
        This parameter :math:`d` allows to compute only part of
        :math:`L_{p}` when :math:`p` is large and :math:`L_{p}` expensive to compute: any polynomial
        (or :literal:`t_SER`) congruent to :math:`L_{p}` modulo :math:`X^{d}` is acceptable since only
        the coefficients of :math:`X^{0},..., X^{d-1}` are needed to expand the Dirichlet
        series. The closure can of course ignore this parameter:

        ::

        ? z = lfuncreate([(p,d)->1/(1-x), 1, [0], 1, 1, 1, 1]); \\ Riemann zeta
        ? lfun(z,2) - Pi^2/6
        %4 = -5.877471754111437540 E-39

        One can describe separately the generic local factors coefficients
        and the bad local factors by setting :math:`dir = [F, L_{bad}]`,
        were :math:`L_{bad} = [[p_{1},L_{p_{1}}],...,[p_{k},L_{p_{k}}]]`, where :math:`F`
        describes the generic local factors as above, except that when :math:`p = p_{i}`
        for some :math:`i <= k`, the coefficient :math:`a_{p}` is directly set to :math:`L_{p_{i}}`
        instead of calling :math:`F`.

        ::

        N = 15;
        E = ellinit([1, 1, 1, -10, -10]); \\ = "15a1"
        F(p,d) = 1 / (1 - ellap(E,p)*'x + p*'x^2);
        Lbad = [[3, 1/(1+'x)], [5, 1/(1-'x)]];
        L = lfuncreate([[F,Lbad], 0, [0,1], 2, N, ellrootno(E)]);

        Of course, in this case, :literal:`lfuncreate(E)` is preferable!

        - :literal:`V[2] = astar` is the Dirichlet series coefficients of the dual
        function, encoded as :literal:`a` above. The sentinel values :math:`0` and :math:`1` may
        be used for the special cases where :math:`a = a^{*}` and :math:`a = \overline{a^{*}}`,
        respectively.

        - :literal:`V[3] = Vga` is the vector of :math:`\alpha_{j}` such that the gamma
        factor of the :math:`L`-function is equal to
        

        .. MATH::

        \gamma_{A}(s) = \prod_{1 <= j <= d}\Gamma_{\mathbb{R}}(s+\alpha_{j}),

        where :math:`\Gamma_{\mathbb{R}}(s) = \pi^{-s/2}\Gamma (s/2)`.
        This same syntax is used in the :literal:`gammamellininv` functions.
        In particular the length :math:`d` of :literal:`Vga` is the degree of the :math:`L`-function.
        In the present implementation, the :math:`\alpha_{j}` are assumed to be exact
        rational numbers. However when calling theta functions with :emphasis:`complex`
        (as opposed to real) arguments, determination problems occur which may
        give wrong results when the :math:`\alpha_{j}` are not integral.

        - :literal:`V[4] = k` is a positive integer :math:`k`. The functional equation relates
        values at :math:`s` and :math:`k-s`. For instance, for an Artin :math:`L`-series such as a
        Dedekind zeta function we have :math:`k = 1`, for an elliptic curve :math:`k = 2`, and
        for a modular form, :math:`k` is its weight. For motivic :math:`L`-functions, the
        :emphasis:`motivic` weight :math:`w` is :math:`w = k-1`.

        By default we assume that :math:`a_{n} = O_{\epsilon}(n^{k_{1}+\epsilon})`, where
        :math:`k_{1} = w` and even :math:`k_{1} = w/2` when the :math:`L` function has no pole
        (Ramanujan-Petersson). If this is not the case, you can replace the
        :math:`k` argument by a vector :math:`[k,k_{1}]`, where :math:`k_{1}` is the upper bound you can
        assume.

        - :literal:`V[5] = N` is the conductor, an integer :math:`N >= 1`, such that
        :math:`\Lambda (s) = N^{s/2}\gamma_{A}(s)L(s)` with :math:`\gamma_{A}(s)` as above.

        - :literal:`V[6] = eps` is the root number :math:`\varepsilon`, i.e., the
        complex number (usually of modulus :math:`1`) such that
        :math:`\Lambda (a, k-s) = \varepsilon \Lambda (a^{*}, s)`.

        - The last optional component :literal:`V[7] = poles` encodes the poles of the
        :math:`L` or :math:`\Lambda`-functions, and is omitted if they have no poles.
        A polar part is given by a list of :math:`2`-component vectors
        :math:`[\beta,P_{\beta}(x)]`, where
        :math:`\beta` is a pole and the power series :math:`P_{\beta}(x)` describes
        the attached polar part, such that :math:`L(s) - P_{\beta}(s-\beta)` is holomorphic
        in a neighbourhood of :math:`\beta`. For instance :math:`P_{\beta} = r/x+O(1)` for a
        simple pole at :math:`\beta` or :math:`r_{1}/x^{2}+r_{2}/x+O(1)` for a double pole.
        The type of the list describing the polar part allows to distinguish between
        :math:`L` and :math:`\Lambda`: a :literal:`t_VEC` is attached to :math:`L`, and a :literal:`t_COL`
        is attached to :math:`\Lambda`. Unless :math:`a = \overline{a^{*}}` (coded by :literal:`astar`
        equal to :math:`0` or :math:`1`), it is mandatory to specify the polar part of :math:`\Lambda`
        rather than those of :math:`L` since the poles of :math:`L^{*}` cannot be infered from the
        latter ! Whereas the functional equation allows to deduce the polar part of
        :math:`\Lambda^{*}` from the polar part of :math:`\Lambda`.

        Finally, if :math:`a = \overline{a^{*}}`, we allow a shortcut to describe
        the frequent situation where :math:`L` has at most simple pole, at :math:`s = k`,
        with residue :math:`r` a complex scalar: you may then input :math:`poles = r`.
        This value :math:`r` can be set to :math:`0` if unknown and it will be computed.

        :strong:`When one component is not exact.`
        Alternatively, :literal:`obj` can be a closure of arity :math:`0` returning the above
        vector to the current real precision. This is needed if some components
        are not available exactly but only through floating point approximations.
        The closure allows algorithms to recompute them to higher accuracy when
        needed. Compare

        ::

        ? Ld1() = [n->lfunan(Mod(2,7),n),1,[0],1,7,((-13-3*sqrt(-3))/14)^(1/6)];
        ? Ld2 = [n->lfunan(Mod(2,7),n),1,[0],1,7,((-13-3*sqrt(-3))/14)^(1/6)];
        ? L1 = lfuncreate(Ld1);
        ? L2 = lfuncreate(Ld2);
        ? lfun(L1,1/2+I*200) \\ OK
        %5 = 0.55943925130316677665287870224047183265 -
        0.42492662223174071305478563967365980756*I
        ? lfun(L2,1/2+I*200) \\ all accuracy lost
        %6 = 0.E-38 + 0.E-38*I

        The accuracy lost in :literal:`Ld2` is due to the root number being given to
        an insufficient precision. To see what happens try

        ::

        ? Ld3() = printf("prec needed: %ld bits",getlocalbitprec());Ld1()
        ? L3 = lfuncreate(Ld3);
        prec needed: 64 bits
        ? z3 = lfun(L3,1/2+I*200)
        prec needed: 384 bits
        %16 = 0.55943925130316677665287870224047183265 -
        0.42492662223174071305478563967365980756*I
        '''
        sig_on()
        cdef GEN _obj = (<Gen>obj).g
        cdef GEN _ret = lfuncreate(_obj)
        return new_gen(_ret)

    def lfundiv(L1, L2, long precision=DEFAULT_BITPREC):
        r'''
        Creates the :literal:`Ldata` structure (without initialization) corresponding
        to the quotient of the Dirichlet series :math:`L_{1}` and :math:`L_{2}` given by
        :literal:`L1` and :literal:`L2`. Assume that :math:`v_{z}(L_{1}) >= v_{z}(L_{2})` at all
        complex numbers :math:`z`: the construction may not create new poles, nor increase
        the order of existing ones.
        '''
        L2 = objtogen(L2)
        sig_on()
        cdef GEN _L1 = (<Gen>L1).g
        cdef GEN _L2 = (<Gen>L2).g
        cdef GEN _ret = lfundiv(_L1, _L2, precision)
        return new_gen(_ret)

    def lfundual(L, long precision=DEFAULT_BITPREC):
        r'''
        Creates the :literal:`Ldata` structure (without initialization) corresponding
        to the dual L-function :math:`^{L}` of :math:`L`. If :math:`k` and :math:`\varepsilon` are
        respectively the weight and root number of :math:`L`, then the following formula
        holds outside poles, up to numerical errors:

        .. MATH::

        \Lambda (L, s) = \varepsilon \Lambda (^{L}, k - s).

        ::

        ? L = lfunqf(matdiagonal([1,2,3,4]));
        ? eps = lfunrootres(L)[3]; k = L[4];
        ? M = lfundual(L); lfuncheckfeq(M)
        %3 = -127
        ? s= 1+Pi*I;
        ? a = lfunlambda(L,s);
        ? b = eps * lfunlambda(M,k-s);
        ? exponent(a - b)
        %7 = -130
        '''
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _ret = lfundual(_L, precision)
        return new_gen(_ret)

    def lfunetaquo(M):
        r'''
        Returns the :literal:`Ldata` structure attached to the :math:`L` function
        attached to the modular form
        :math:`z:--->\prod_{i = 1}^{n} \eta (M_{i,1} z)^{M_{i,2}}`
        It is currently assumed that :math:`f` is a self-dual cuspidal form on
        :math:`\Gamma_{0}(N)` for some :math:`N`.
        For instance, the :math:`L`-function :math:`\sum \tau (n) n^{-s}`
        attached to Ramanujan's :math:`\Delta` function is encoded as follows

        ::

        ? L = lfunetaquo(Mat([1,24]));
        ? lfunan(L, 100) \\ first 100 values of tau(n)

        For convenience, a :literal:`t_VEC` is also accepted instead of
        a factorization matrix with a single row:

        ::

        ? L = lfunetaquo([1,24]); \\ same as above
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = lfunetaquo(_M)
        return new_gen(_ret)

    def lfuneuler(L, p, long precision=DEFAULT_BITPREC):
        r'''
        Return the Euler factor at :math:`p` of the
        :math:`L`-function given by :literal:`L` (:literal:`Lmath`, :literal:`Ldata` or :literal:`Linit`),
        assuming the :math:`L`-function admits an Euler product factorization and that it
        can be determined.

        ::

        ? E=ellinit([1,3]);
        ? lfuneuler(E,7)
        %2 = 1/(7*x^2-2*x+1)
        ? L=lfunsympow(E,2);
        ? lfuneuler(L,11)
        %4 = 1/(-1331*x^3+275*x^2-25*x+1)
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _p = (<Gen>p).g
        precision = nbits2prec(precision)
        cdef GEN _ret = lfuneuler(_L, _p, precision)
        return new_gen(_ret)

    def lfungenus2(F):
        r'''
        Returns the :literal:`Ldata` structure attached to the :math:`L` function
        attached to the genus-2 curve defined by :math:`y^{2} = F(x)` or
        :math:`y^{2}+Q(x) y = P(x)` if :math:`F = [P,Q]`.
        Currently, if the conductor is even, its valuation at :math:`2` might be incorrect
        (a warning is issued).
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = lfungenus2(_F)
        return new_gen(_ret)

    def lfunhardy(L, t, long precision=DEFAULT_BITPREC):
        r'''
        Variant of the Hardy :math:`Z`-function given by :literal:`L`, used for
        plotting or locating zeros of :math:`L(k/2+it)` on the critical line.
        The precise definition is as
        follows: let :math:`k/2` be the center of the critical strip, :math:`d` be the
        degree, :math:`Vga = (\alpha_{j})_{j <= d}` given the gamma factors,
        and :math:`\varepsilon` be the root number; we set
        :math:`s = k/2+it = \rho e^{i\theta}` and
        :math:`2E = d(k/2-1) + \Re (\sum_{1 <= j <= d}\alpha_{j})`. Assume first that
        :math:`\Lambda` is self-dual, then the computed function at :math:`t` is equal to

        .. MATH::

        Z(t) = \varepsilon^{-1/2}\Lambda (s).\rho^{-E}e^{dt\theta/2} ,

        which is a real function of :math:`t`
        vanishing exactly when :math:`L(k/2+it)` does on the critical line. The
        normalizing factor :math:`\|s\|^{-E}e^{dt\theta/2}` compensates the
        exponential decrease of :math:`\gamma_{A}(s)` as :math:`t\to oo` so that
        :math:`Z(t) ~ 1`. For non-self-dual :math:`\Lambda`, the definition is the same
        except we drop the :math:`\varepsilon^{-1/2}` term (which is not well defined since
        it depends on the chosen dual sequence :math:`a^{*}(n)`): :math:`Z(t)` is still of the
        order of :math:`1` and still vanishes where :math:`L(k/2+it)` does, but it needs no
        longer be real-valued.

        ::

        ? T = 100; \\ maximal height
        ? L = lfuninit(1, [T]); \\ initialize for zeta(1/2+it), |t|<T
        ? \p19 \\ no need for large accuracy
        ? ploth(t = 0, T, lfunhardy(L,t))

        Using :literal:`lfuninit` is critical for this particular
        applications since thousands of values are computed. Make sure to initialize
        up to the maximal :math:`t` needed: otherwise expect to see many warnings for
        unsufficient initialization and suffer major slowdowns.
        '''
        t = objtogen(t)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = lfunhardy(_L, _t, precision)
        return new_gen(_ret)

    def lfunhgm(H, t, hint=None, long precision=DEFAULT_BITPREC):
        r'''
        :math:`(H,t)` being a hypergeometric motive, returns the corresponding
        :literal:`lfuncreate` data for use with the :math:`L`-function package. This function
        needs to guess local conductors and euler factors at wild primes and
        will be very costly if there are many such primes: the complexity is roughly
        proportional to the conductor. The optional parameter :literal:`hint`
        allows to speed up the function by making various assumptions:

        - :math:`hint = lim` a :literal:`t_INT`: assume that Euler factors at wild
        primes have degree less than :emphasis:`lim`, which may speed it up a little.

        - :math:`hint = [N]`: guess that the conductor is :math:`N`.

        - :math:`hint = [N, lim]`: initial guess :math:`N` for the conductor
        and limit degrees to :emphasis:`lim`.

        If your guess for :emphasis:`lim` is wrong, the function will enter an infinite loop.
        If your guess for an initial :math:`N` is wrong, the function silently restarts
        (it will not enter an infinite loop unless a simultaneous failed guess for
        :emphasis:`lim` is made).

        ::

        ? H = hgminit([5]);
        ? L = lfunhgm(H, 1/64);
        time = 23,113 ms.
        ? L=lfunhgm(H,1/64,0); \\ assume Euler factors at wild primes are trivial
        time = 19,721 ms. \\ a little faster
        ? L=lfunhgm(H,1/64,[525000]); \\ initial guess N = 525000
        time = 15,486 ms. \\ a little faster
        ? L=lfunhgm(H,1/64,[525000, 0]);
        time = 15,293 ms. \\ marginally faster with both assumptions
        '''
        t = objtogen(t)
        cdef bint _have_hint = (hint is not None)
        if _have_hint:
            hint = objtogen(hint)
        sig_on()
        cdef GEN _H = (<Gen>H).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _hint = NULL
        if _have_hint:
            _hint = (<Gen>hint).g
        cdef GEN _ret = lfunhgm(_H, _t, _hint, precision)
        return new_gen(_ret)

    def lfuninit(L, sdom, long der=0, long precision=DEFAULT_BITPREC):
        r'''
        Initalization function for all functions linked to the
        computation of the :math:`L`-function :math:`L(s)` encoded by :literal:`L`, where
        :math:`s` belongs to the rectangular domain :math:`sdom = [center,w,h]`
        centered on the real axis, :math:`\|\Re (s)-center\| <= w`, :math:`\|\Im (s)\| <= h`,
        where all three components of :literal:`sdom` are real and :math:`w`, :math:`h` are
        nonnegative. :literal:`der` is the maximum order of derivation that will be used.
        The subdomain :math:`[k/2, 0, h]` on the critical line (up to height :math:`h`)
        can be encoded as :math:`[h]` for brevity. The subdomain :math:`[k/2, w, h]`
        centered on the critical line can be encoded as :math:`[w, h]` for brevity.

        The argument :literal:`L` is an :literal:`Lmath`, an :literal:`Ldata` or an :literal:`Linit`. See
        :literal:`??Ldata` and :literal:`??lfuncreate` for how to create it.

        The height :math:`h` of the domain is a :emphasis:`crucial` parameter: if you only
        need :math:`L(s)` for real :math:`s`, set :math:`h` to 0.
        The running time is roughly proportional to

        .. MATH::

        (B / d+\pi h/4)^{d/2+3}N^{1/2},

        where :math:`B` is the default bit accuracy, :math:`d` is the degree of the
        :math:`L`-function, and :math:`N` is the conductor (the exponent :math:`d/2+3` is reduced
        to :math:`d/2+2` when :math:`d = 1` and :math:`d = 2`). There is also a dependency on :math:`w`,
        which is less crucial, but make sure to use the smallest rectangular
        domain that you need.

        ::

        ? L0 = lfuncreate(1); \\ Riemann zeta
        ? L = lfuninit(L0, [1/2, 0, 100]); \\ for zeta(1/2+it), |t| < 100
        ? lfun(L, 1/2 + I)
        ? L = lfuninit(L0, [100]); \\ same as above !

        :strong:`Riemann-Siegel formula.`
        If :math:`L` is a function of degree :math:`d = 1`, then a completely different
        algorithm is implemented which can compute with complexity :math:`N \sqrt{h}` (for
        fixed accuracy :math:`B`). So it handles larger imaginary parts than the default
        implementation. But this variant is less efficient when the imaginary part of
        :math:`s` is tiny and the dependency in :math:`B` is still in :math:`O(B^{2+1/2})`.

        For such functions, you can use :math:`sdom = []` to indicate that you
        are only interested in relatively high imaginary parts and do not want to
        perform any initialization:

        ::

        ? L = lfuninit(1, []); \\ Riemann zeta
        ? #lfunzeros(L, [10^12, 10^12+1])
        time = 1min, 31,496 ms.
        %2 = 4

        If you ask instead for
        :literal:`lfuninit(1, [10^12+1])`, the initialization is restricted by some
        cutoff value (depending on the conductor, but less than :math:`10^4` in any case):
        up to that point, the standard algorithm is used (and uses the
        initialization); and above the cutoff, we switch to Riemann-Siegel. Note that
        this is quite wasteful if only values with imaginary parts larger than :math:`10^4`
        are needed.
        '''
        sdom = objtogen(sdom)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _sdom = (<Gen>sdom).g
        cdef GEN _ret = lfuninit0(_L, _sdom, der, precision)
        return new_gen(_ret)

    def lfunlambda(L, s, long D=0, long precision=DEFAULT_BITPREC):
        r'''
        Compute the completed :math:`L`-function :math:`\Lambda (s) = N^{s/2}\gamma (s)L(s)`,
        or if :literal:`D` is set, the derivative of order :literal:`D` at :math:`s`.
        The parameter :literal:`L` is either an :literal:`Lmath`, an :literal:`Ldata` (created by
        :literal:`lfuncreate`, or an :literal:`Linit` (created by :literal:`lfuninit`), preferrably the
        latter if many values are to be computed.

        The result is given with absolute error less than :math:`2^{-B}\|\gamma (s)N^{s/2}\|`,
        where :math:`B = realbitprecision`.
        '''
        s = objtogen(s)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _ret = lfunlambda0(_L, _s, D, precision)
        return new_gen(_ret)

    def lfunmf(mf, F=None, long precision=DEFAULT_BITPREC):
        r'''
        If :math:`F` is a modular form in :literal:`mf`, output the L-functions
        corresponding to its :math:`[\mathbb{Q} (F):\mathbb{Q} (\chi)]` complex embeddings, ready for use with
        the :literal:`lfun` package. If :math:`F` is omitted, output the :math:`L`-functions attached
        to all eigenforms in the new space; the result is a vector whose length is
        the number of Galois orbits of newforms. Each entry contains the vector of
        :math:`L`-functions corresponding to the :math:`d` complex embeddings of an orbit of
        dimension :math:`d` over :math:`\mathbb{Q} (\chi)`.

        ::

        ? mf = mfinit([35,2],0);mffields(mf)
        %1 = [y, y^2 - y - 4]
        ? f = mfeigenbasis(mf)[2]; mfparams(f) \\ orbit of dimension two
        %2 = [35, 2, 1, y^2 - y - 4, t - 1]
        ? [L1,L2] = lfunmf(mf, f); \\ Two L-functions
        ? lfun(L1,1)
        %4 = 0.81018461849460161754947375433874745585
        ? lfun(L2,1)
        %5 = 0.46007635204895314548435893464149369804
        ? [ lfun(L,1) | L <- concat(lfunmf(mf)) ]
        %6 = [0.70291..., 0.81018..., 0.46007...]

        The :literal:`concat` instruction concatenates the vectors
        corresponding to the various (here two) orbits, so that we obtain the vector
        of all the :math:`L`-functions attached to eigenforms.
        '''
        cdef bint _have_F = (F is not None)
        if _have_F:
            F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = NULL
        if _have_F:
            _F = (<Gen>F).g
        cdef GEN _ret = lfunmf(_mf, _F, precision)
        return new_gen(_ret)

    def lfunmfspec(L, long precision=DEFAULT_BITPREC):
        r'''
        Let :math:`L` be the :math:`L`-function attached to a modular eigenform :math:`f` of
        weight :math:`k`, as given by :literal:`lfunmf`. In even weight, returns
        :literal:`[ve,vo,om,op]`, where :literal:`ve` (resp., :literal:`vo`) is the vector of even
        (resp., odd) periods of :math:`f` and :literal:`om` and :literal:`op` the corresponding
        real numbers :math:`\omega^{-}` and :math:`\omega^{+}` normalized in a noncanonical way.
        In odd weight :literal:`ominus` is the same as :literal:`op` and we
        return :literal:`[v,op]` where :math:`v` is the vector of all periods.

        ::

        ? D = mfDelta(); mf = mfinit(D); L = lfunmf(mf, D);
        ? [ve, vo, om, op] = lfunmfspec(L)
        %2 = [[1, 25/48, 5/12, 25/48, 1], [1620/691, 1, 9/14, 9/14, 1, 1620/691],\
        0.0074154209298961305890064277459002287248,\
        0.0050835121083932868604942901374387473226]
        ? DS = mfsymbol(mf, D); bestappr(om*op / mfpetersson(DS), 10^8)
        %3 = 8192/225
        ? mf = mfinit([4, 9, -4], 0);
        ? F = mfeigenbasis(mf)[1]; L = lfunmf(mf, F);
        ? [v, om] = lfunmfspec(L)
        %6 = [[1, 10/21, 5/18, 5/24, 5/24, 5/18, 10/21, 1],\
        1.1302643192034974852387822584241400608]
        ? FS = mfsymbol(mf, F); bestappr(om^2 / mfpetersson(FS), 10^8)
        %7 = 113246208/325
        '''
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _ret = lfunmfspec(_L, precision)
        return new_gen(_ret)

    def lfunmul(L1, L2, long precision=DEFAULT_BITPREC):
        r'''
        Creates the :literal:`Ldata` structure (without initialization) corresponding
        to the product of the Dirichlet series given by :literal:`L1` and
        :literal:`L2`.
        '''
        L2 = objtogen(L2)
        sig_on()
        cdef GEN _L1 = (<Gen>L1).g
        cdef GEN _L2 = (<Gen>L2).g
        cdef GEN _ret = lfunmul(_L1, _L2, precision)
        return new_gen(_ret)

    def lfunorderzero(L, long m=-1, long precision=DEFAULT_BITPREC):
        r'''
        Computes the order of the possible zero of the :math:`L`-function at the
        center :math:`k/2` of the critical strip; return :math:`0` if :math:`L(k/2)` does not vanish.

        If :math:`m` is given and has a nonnegative value, assumes the order is at most :math:`m`.
        Otherwise, the algorithm chooses a sensible default:

        - if the :math:`L` argument is an :literal:`Linit`, assume that a multiple zero at
        :math:`s = k / 2` has order less than or equal to the maximal allowed derivation
        order.

        - else assume the order is less than :math:`4`.

        You may explicitly increase this value using optional argument :math:`m`; this
        overrides the default value above. (Possibly forcing a recomputation
        of the :literal:`Linit`.)
        '''
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef long _ret = lfunorderzero(_L, m, precision)
        clear_stack()
        return _ret

    def lfunparams(ldata, long precision=DEFAULT_BITPREC):
        r'''
        Returns the parameters :math:`[N, k, Vga]` of the :math:`L`-function
        defined by :literal:`ldata`, corresponding respectively to
        the conductor, the functional equation relating values at :math:`s` and :math:`k-s`,
        and the gamma shifts of the :math:`L`-function (see :literal:`lfuncreate`). The gamma
        shifts are returned to the current precision.

        ::

        ? L = lfuncreate(1); /* Riemann zeta function */
        ? lfunparams(L)
        %2 = [1, 1, [0]]
        '''
        sig_on()
        cdef GEN _ldata = (<Gen>ldata).g
        precision = nbits2prec(precision)
        cdef GEN _ret = lfunparams(_ldata, precision)
        return new_gen(_ret)

    def lfunqf(Q, long precision=DEFAULT_BITPREC):
        r'''
        Returns the :literal:`Ldata` structure attached to the :math:`\Theta` function
        of the lattice attached to the primitive form proportional to the definite
        positive quadratic form :math:`Q`.

        ::

        ? L = lfunqf(matid(2));
        ? lfunqf(L,2)
        %2 = 6.0268120396919401235462601927282855839
        ? lfun(x^2+1,2)*4
        %3 = 6.0268120396919401235462601927282855839

        The following computes the Madelung constant:

        ::

        ? L1=lfunqf(matdiagonal([1,1,1]));
        ? L2=lfunqf(matdiagonal([4,1,1]));
        ? L3=lfunqf(matdiagonal([4,4,1]));
        ? F(s)=6*lfun(L2,s)-12*lfun(L3,s)-lfun(L1,s)*(1-8/4^s);
        ? F(1/2)
        %5 = -1.7475645946331821906362120355443974035
        '''
        sig_on()
        cdef GEN _Q = (<Gen>Q).g
        precision = nbits2prec(precision)
        cdef GEN _ret = lfunqf(_Q, precision)
        return new_gen(_ret)

    def lfunrootres(data, long precision=DEFAULT_BITPREC):
        r'''
        Given the :literal:`Ldata` attached to an :math:`L`-function (or the output of
        :literal:`lfunthetainit`), compute the root number and the residues.

        The output is a 3-component vector
        :math:`[[[a_{1},r_{1}],...,[a_{n}, r_{n}], [[b_{1}, R_{1}],...,[b_{m}, R_{m}]] , w]`,
        where :math:`r_{i}` is the
        polar part of :math:`L(s)` at :math:`a_{i}`, :math:`R_{i}` is is the polar part of :math:`\Lambda (s)` at
        :math:`b_{i}` or :math:`[0,0,r]` if there is no pole,
        and :math:`w` is the root number. In the present implementation,

        - either the polar part must be completely known (and is then arbitrary):
        the function determines the root number,

        ::

        ? L = lfunmul(1,1); \\ zeta^2
        ? [r,R,w] = lfunrootres(L);
        ? r \\ single pole at 1, double
        %3 = [[1, 1.[...]*x^-2 + 1.1544[...]*x^-1 + O(x^0)]]
        ? w
        %4 = 1
        ? R \\ double pole at 0 and 1
        %5 = [[1,[...]], [0,[...]]]~

        - or at most a single pole is allowed: the function computes both
        the root number and the residue (:math:`0` if no pole).
        '''
        sig_on()
        cdef GEN _data = (<Gen>data).g
        cdef GEN _ret = lfunrootres(_data, precision)
        return new_gen(_ret)

    def lfunshift(L, d, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Creates the Ldata structure (without initialization) corresponding to the
        shift of :math:`L` by :math:`d`, that is to the function :math:`L_{d}` such that
        :math:`L_{d}(s) = L(s-d)`. If :math:`flag = 1`, return the product :math:`L x L_{d}` instead.

        ::

        ? Z = lfuncreate(1); \\ zeta(s)
        ? L = lfunshift(Z,1); \\ zeta(s-1)
        ? normlp(Vec(lfunlambda(L,s)-lfunlambda(L,3-s)))
        %3 = 0.E-38 \\ the expansions coincide to 'seriesprecision'
        ? lfun(L,1)
        %4 = -0.50000000000000000000000000000000000000 \\ = zeta(0)
        ? M = lfunshift(Z,1,1); \\ zeta(s)*zeta(s-1)
        ? normlp(Vec(lfunlambda(M,s)-lfunlambda(M,2-s)))
        %6 = 2.350988701644575016 E-38
        ? lfun(M,2) \\ simple pole at 2, residue zeta(2)
        %7 = 1.6449340668482264364724151666460251892*x^-1+O(x^0)
        '''
        d = objtogen(d)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = lfunshift(_L, _d, flag, precision)
        return new_gen(_ret)

    def lfunsympow(E, unsigned long m):
        r'''
        Returns the :literal:`Ldata` structure attached to the :math:`L` function
        attached to the :math:`m`-th symmetric power of the elliptic curve :math:`E` defined over
        the rationals.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = lfunsympow(_E, m)
        return new_gen(_ret)

    def lfuntheta(data, t, long m=0, long precision=DEFAULT_BITPREC):
        r'''
        Compute the value of the :math:`m`-th derivative
        at :math:`t` of the theta function attached to the :math:`L`-function given by :literal:`data`.
        :literal:`data` can be either the standard :math:`L`-function data, or the output of
        :literal:`lfunthetainit`. The result is given with absolute error less than
        :math:`2^{-B}`, where :math:`B = realbitprecision`.

        The theta function is defined by the formula
        :math:`\Theta (t) = \sum_{n >= 1}a(n)K(nt/\sqrt{N})`, where :math:`a(n)` are the coefficients
        of the Dirichlet series, :math:`N` is the conductor, and :math:`K` is the inverse Mellin
        transform of the gamma product defined by the :literal:`Vga` component.
        Its Mellin transform is equal to :math:`\Lambda (s)-P(s)`, where :math:`\Lambda (s)`
        is the completed :math:`L`-function and the rational function :math:`P(s)` its polar part.
        In particular, if the :math:`L`-function is the :math:`L`-function of a modular form
        :math:`f(\tau) = \sum_{n >= 0}a(n)q^{n}` with :math:`q = \exp (2\pi i\tau)`, we have
        :math:`\Theta (t) = 2(f(it/\sqrt{N})-a(0))`. Note that :math:`a(0) = -L(f,0)` in this case.
        '''
        t = objtogen(t)
        sig_on()
        cdef GEN _data = (<Gen>data).g
        cdef GEN _t = (<Gen>t).g
        cdef GEN _ret = lfuntheta(_data, _t, m, precision)
        return new_gen(_ret)

    def lfunthetacost(L, tdom=None, long m=0, long precision=DEFAULT_BITPREC):
        r'''
        This function estimates the cost of running
        :literal:`lfunthetainit(L,tdom,m)` at current bit precision. Returns the number of
        coefficients :math:`a_{n}` that would be computed. This also estimates the
        cost of a subsequent evaluation :literal:`lfuntheta`, which must compute
        that many values of :literal:`gammamellininv` at the current bit precision.
        If :math:`L` is already an :literal:`Linit`, then :emphasis:`tdom` and :math:`m` are ignored
        and are best left omitted: we get an estimate of the cost of using that
        particular :literal:`Linit`.

        ::

        ? \pb 1000
        ? L = lfuncreate(1); \\ Riemann zeta
        ? lfunthetacost(L); \\ cost for theta(t), t real >= 1
        %1 = 15
        ? lfunthetacost(L, 1 + I); \\ cost for theta(1+I). Domain error !
        *** at top-level: lfunthetacost(1,1+I)
        *** ^--------------------
        *** lfunthetacost: domain error in lfunthetaneed: arg t > 0.785
        ? lfunthetacost(L, 1 + I/2) \\ for theta(1+I/2).
        %2 = 23
        ? lfunthetacost(L, 1 + I/2, 10) \\ for theta^((10))(1+I/2).
        %3 = 24
        ? lfunthetacost(L, [2, 1/10]) \\ cost for theta(t), |t| >= 2, |arg(t)| < 1/10
        %4 = 8
        
        ? L = lfuncreate( ellinit([1,1]) );
        ? lfunthetacost(L) \\ for t >= 1
        %6 = 2471
        '''
        cdef bint _have_tdom = (tdom is not None)
        if _have_tdom:
            tdom = objtogen(tdom)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _tdom = NULL
        if _have_tdom:
            _tdom = (<Gen>tdom).g
        cdef long _ret = lfunthetacost0(_L, _tdom, m, precision)
        clear_stack()
        return _ret

    def lfunthetainit(L, tdom=None, long m=0, long precision=DEFAULT_BITPREC):
        r'''
        Initalization function for evaluating the :math:`m`-th derivative of theta
        functions with argument :math:`t` in domain :emphasis:`tdom`. By default (:emphasis:`tdom`
        omitted), :math:`t` is real, :math:`t >= 1`. Otherwise, :emphasis:`tdom` may be

        - a positive real scalar :math:`\rho`: :math:`t` is real, :math:`t >= \rho`.

        - a nonreal complex number: compute at this particular :math:`t`; this
        allows to compute :math:`\theta (z)` for any complex :math:`z` satisfying :math:`\|z\| >= \|t\|`
        and :math:`\|\arg z\| <= \|\arg t\|`; we must have :math:`\|2 \arg z / d\| < \pi/2`, where
        :math:`d` is the degree of the :math:`\Gamma` factor.

        - a pair :math:`[\rho,\alpha]`: assume that :math:`\|t\| >= \rho` and :math:`\|\arg t\| \leq
        \alpha`; we must have :math:`\|2\alpha / d\| < \pi/2`, where :math:`d` is the degree of
        the :math:`\Gamma` factor.

        ::

        ? \p500
        ? L = lfuncreate(1); \\ Riemann zeta
        ? t = 1+I/2;
        ? lfuntheta(L, t); \\ direct computation
        time = 30 ms.
        ? T = lfunthetainit(L, 1+I/2);
        time = 30 ms.
        ? lfuntheta(T, t); \\ instantaneous

        The :math:`T` structure would allow to quickly compute :math:`\theta (z)`
        for any :math:`z` in the cone delimited by :math:`t` as explained above. On the other hand

        ::

        ? lfuntheta(T,I)
        *** at top-level: lfuntheta(T,I)
        *** ^--------------
        *** lfuntheta: domain error in lfunthetaneed: arg t > 0.785398163397448

        The initialization is equivalent to

        ::

        ? lfunthetainit(L, [abs(t), arg(t)])
        '''
        cdef bint _have_tdom = (tdom is not None)
        if _have_tdom:
            tdom = objtogen(tdom)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _tdom = NULL
        if _have_tdom:
            _tdom = (<Gen>tdom).g
        cdef GEN _ret = lfunthetainit(_L, _tdom, m, precision)
        return new_gen(_ret)

    def lfuntwist(L, chi, long precision=DEFAULT_BITPREC):
        r'''
        Creates the Ldata structure (without initialization) corresponding to the
        twist of L by the primitive character attached to the Dirichlet character
        :literal:`chi`. The conductor of the character must be coprime to the conductor
        of the L-function :math:`L`.
        '''
        chi = objtogen(chi)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _chi = (<Gen>chi).g
        cdef GEN _ret = lfuntwist(_L, _chi, precision)
        return new_gen(_ret)

    def lfunzeros(L, lim, long divz=8, long precision=DEFAULT_BITPREC):
        r'''
        :literal:`lim` being either a positive upper limit or a nonempty real
        interval, computes an ordered list of zeros of :math:`L(s)` on the critical line up
        to the given upper limit or in the given interval. Use a naive algorithm
        which may miss some zeros: it assumes that two consecutive zeros at height
        :math:`T >= 1` differ at least by :math:`2\pi/\omega`, where

        .. MATH::

        \omega := divz.
        (d\log (T/2\pi) + d+ 2\log (N/(\pi/2)^{d})).

        To use a finer search mesh, set divz to some integral value
        larger than the default ( = 8).

        ::

        ? lfunzeros(1, 30) \\ zeros of Rieman zeta up to height 30
        %1 = [14.134[...], 21.022[...], 25.010[...]]
        ? #lfunzeros(1, [100,110]) \\ count zeros with 100 <= Im(s) <= 110
        %2 = 4

        The algorithm also assumes that all zeros are simple except
        possibly on the real axis at :math:`s = k/2` and that there are no poles in the
        search interval. (The possible zero at :math:`s = k/2` is repeated according to
        its multiplicity.)

        If you pass an :literal:`Linit` to the function, the algorithm assumes that a
        multiple zero at :math:`s = k / 2` has order less than or equal to the maximal
        derivation order allowed by the :literal:`Linit`. You may increase that value in
        the :literal:`Linit` but this is costly: only do it for zeros of low height or in
        :literal:`lfunorderzero` instead.
        '''
        lim = objtogen(lim)
        sig_on()
        cdef GEN _L = (<Gen>L).g
        cdef GEN _lim = (<Gen>lim).g
        cdef GEN _ret = lfunzeros(_L, _lim, divz, precision)
        return new_gen(_ret)

    def lift(x, v=None):
        r'''
        If :math:`v` is omitted, lifts intmods from :math:`\mathbb{Z}/n\mathbb{Z}` in :math:`\mathbb{Z}`,
        :math:`p`-adics from :math:`\mathbb{Q}_{p}` to :math:`\mathbb{Q}` (as :literal:`truncate`), and polmods to
        polynomials. Otherwise, lifts only polmods whose modulus has main
        variable :math:`v`. :literal:`t_FFELT` are not lifted, nor are List elements: you may
        convert the latter to vectors first, or use :literal:`apply(lift,L)`. More
        generally, components for which such lifts are meaningless (e.g. character
        strings) are copied verbatim.

        ::

        ? lift(Mod(5,3))
        %1 = 2
        ? lift(3 + O(3^9))
        %2 = 3
        ? lift(Mod(x,x^2+1))
        %3 = x
        ? lift(Mod(x,x^2+1))
        %4 = x

        Lifts are performed recursively on an object components, but only
        by :emphasis:`one level`: once a :literal:`t_POLMOD` is lifted, the components of
        the result are :emphasis:`not` lifted further.

        ::

        ? lift(x * Mod(1,3) + Mod(2,3))
        %4 = x + 2
        ? lift(x * Mod(y,y^2+1) + Mod(2,3))
        %5 = y*x + Mod(2, 3) \\ do you understand this one?
        ? lift(x * Mod(y,y^2+1) + Mod(2,3), 'x)
        %6 = Mod(y, y^2 + 1)*x + Mod(Mod(2, 3), y^2 + 1)
        ? lift(%, y)
        %7 = y*x + Mod(2, 3)

        To recursively lift all components not only by one level,
        but as long as possible, use :literal:`liftall`. To lift only :literal:`t_INTMOD` s and
        :literal:`t_PADIC` s components, use :literal:`liftint`. To lift only :literal:`t_POLMOD` s
        components, use :literal:`liftpol`. Finally, :literal:`centerlift` allows to lift
        :literal:`t_INTMOD` s and :literal:`t_PADIC` s using centered residues (lift of smallest
        absolute value).
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = lift0(_x, _v)
        return new_gen(_ret)

    def liftall(x):
        r'''
        Recursively lift all components of :math:`x` from :math:`\mathbb{Z}/n\mathbb{Z}` to :math:`\mathbb{Z}`,
        from :math:`\mathbb{Q}_{p}` to :math:`\mathbb{Q}` (as :literal:`truncate`), and polmods to
        polynomials. :literal:`t_FFELT` are not lifted, nor are List elements: you may
        convert the latter to vectors first, or use :literal:`apply(liftall,L)`. More
        generally, components for which such lifts are meaningless (e.g. character
        strings) are copied verbatim.

        ::

        ? liftall(x * (1 + O(3)) + Mod(2,3))
        %1 = x + 2
        ? liftall(x * Mod(y,y^2+1) + Mod(2,3)*Mod(z,z^2))
        %2 = y*x + 2*z
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = liftall(_x)
        return new_gen(_ret)

    def liftint(x):
        r'''
        Recursively lift all components of :math:`x` from :math:`\mathbb{Z}/n\mathbb{Z}` to :math:`\mathbb{Z}` and
        from :math:`\mathbb{Q}_{p}` to :math:`\mathbb{Q}` (as :literal:`truncate`).
        :literal:`t_FFELT` are not lifted, nor are List elements: you may
        convert the latter to vectors first, or use :literal:`apply(liftint,L)`. More
        generally, components for which such lifts are meaningless (e.g. character
        strings) are copied verbatim.

        ::

        ? liftint(x * (1 + O(3)) + Mod(2,3))
        %1 = x + 2
        ? liftint(x * Mod(y,y^2+1) + Mod(2,3)*Mod(z,z^2))
        %2 = Mod(y, y^2 + 1)*x + Mod(Mod(2*z, z^2), y^2 + 1)
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = liftint(_x)
        return new_gen(_ret)

    def liftpol(x):
        r'''
        Recursively lift all components of :math:`x` which are polmods to
        polynomials. :literal:`t_FFELT` are not lifted, nor are List elements: you may
        convert the latter to vectors first, or use :literal:`apply(liftpol,L)`. More
        generally, components for which such lifts are meaningless (e.g. character
        strings) are copied verbatim.

        ::

        ? liftpol(x * (1 + O(3)) + Mod(2,3))
        %1 = (1 + O(3))*x + Mod(2, 3)
        ? liftpol(x * Mod(y,y^2+1) + Mod(2,3)*Mod(z,z^2))
        %2 = y*x + Mod(2, 3)*z
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = liftpol(_x)
        return new_gen(_ret)

    def limitnum(expr, alpha=None, long precision=DEFAULT_BITPREC):
        r'''
        Lagrange-Zagier numerical extrapolation of :emphasis:`expr`, corresponding to
        a sequence :math:`u_{n}`, either given by a closure :literal:`n- > u(n)`. I.e., assuming
        that :math:`u_{n}` tends to a finite limit :math:`\ell`, try to determine :math:`\ell`.

        The routine assume that :math:`u_{n}` has an asymptotic expansion in :math:`n^{-\alpha}` :

        .. MATH::

        u_{n} = \ell + \sum_{i >= 1} a_{i} n^{-i\alpha}

        for some :math:`a_{i}`. It is purely numerical and heuristic, thus may or may not
        work on your examples. The expression will be evaluated for :math:`n = 1, 2,
        ..., N` for an :math:`N = O(B)` at a bit accuracy bounded by :math:`1.612 B`.

        ::

        ? limitnum(n -> n*sin(1/n))
        %1 = 1.0000000000000000000000000000000000000
        
        ? limitnum(n -> (1+1/n)^n) - exp(1)
        %2 = 0.E-37
        
        ? limitnum(n -> 2^(4*n+1)*(n!)^4 / (2*n)! /(2*n+1)! ) - Pi
        %3 = 0.E -37

        It is not mandatory to specify :math:`\alpha` when the :math:`u_{n}` have an asymptotic
        expansion in :math:`n^{-1}`. However, if the series in :math:`n^{-1}` is lacunary,
        specifying :math:`\alpha` allows faster computation:

        ::

        ? \p1000
        ? limitnum(n->(1+1/n^2)^(n^2)) - exp(1)
        time = 1min, 44,681 ms.
        %4 = 0.E-1001
        ? limitnum(n->(1+1/n^2)^(n^2), 2) - exp(1)
        time = 27,271 ms.
        %5 = 0.E-1001 \\ still perfect, 4 times faster

        When :math:`u_{n}` has an asymptotic expansion in :math:`n^{-\alpha}` with :math:`\alpha` not an
        integer, leaving :math:`\alpha` unspecified will bring an inexact limit. Giving a
        satisfying optional argument improves precision; the program runs faster when
        the optional argument gives non lacunary series.

        ::

        ? \p50
        ? limitnum(n->(1+1/n^(7/2))^(n^(7/2))) - exp(1)
        time = 982 ms.
        %6 = 4.13[...] E-12
        ? limitnum(n->(1+1/n^(7/2))^(n^(7/2)), 1/2) - exp(1)
        time = 16,745 ms.
        %7 = 0.E-57
        ? limitnum(n->(1+1/n^(7/2))^(n^(7/2)), 7/2) - exp(1)
        time = 105 ms.
        %8 = 0.E-57

        Alternatively, :math:`u_{n}` may be given by a closure
        :math:`N:--->[u_{1},..., u_{N}]`
        which can often be programmed in a more efficient way, for instance
        when :math:`u_{n+1}` is a simple function of the preceding terms:

        ::

        ? \p2000
        ? limitnum(n -> 2^(4*n+1)*(n!)^4 / (2*n)! /(2*n+1)! ) - Pi
        time = 1,755 ms.
        %9 = 0.E-2003
        ? vu(N) = \\ exploit hypergeometric property
        { my(v = vector(N)); v[1] = 8./3;\
        for (n=2, N, my(q = 4*n^2); v[n] = v[n-1]*q/(q-1));\
        return(v);
        }
        ? limitnum(vu) - Pi \\ much faster
        time = 106 ms.
        %11 = 0.E-2003

        All sums and recursions can be handled in the same way.
        In the above it is essential that :math:`u_{n}` be defined as a closure because
        it must be evaluated at a higher precision than the one expected for the
        limit. Make sure that the closure does not depend on a global variable which
        would be computed at a priori fixed accuracy. For instance, precomputing
        :literal:`v1 = 8.0/3` first and using :literal:`v1` in :literal:`vu` above would be wrong
        because the resulting vector of values will use the accuracy of :literal:`v1`
        instead of the ambient accuracy at which :literal:`limitnum` will call it.

        Alternatively, and more clumsily, :math:`u_{n}` may be given by a vector of values:
        it must be long and precise enough for the extrapolation
        to make sense. Let :math:`B` be the current :literal:`realbitprecision`, the vector
        length must be at least :math:`1.102 B` and the values computed with bit accuracy
        :math:`1.612 B`.

        ::

        ? limitnum(vector(10,n,(1+1/n)^n))
        *** ^--------------------
        *** limitnum: nonexistent component in limitnum: index < 43
        \\ at this accuracy, we must have at least 43 values
        ? limitnum(vector(43,n,(1+1/n)^n)) - exp(1)
        %12 = 0.E-37
        
        ? v = vector(43);
        ? s = 0; for(i=1,#v, s += 1/i; v[i]= s - log(i));
        ? limitnum(v) - Euler
        %15 = -1.57[...] E-16
        
        ? v = vector(43);
        \\ ~ 128 bit * 1.612
        ? localbitprec(207);\
        s = 0; for(i=1,#v, s += 1/i; v[i]= s - log(i));
        ? limitnum(v) - Euler
        %18 = 0.E-38

        Because of the above problems, the preferred format is thus a closure,
        given either a single value or the vector of values :math:`[u_{1},...,u_{N}]`. The
        function distinguishes between the two formats by evaluating the closure
        at :math:`N ! = 1` and :math:`1` and checking whether it yields vectors of respective
        length :math:`N` and :math:`1` or not.

        :strong:`Warning.` The expression is evaluated for :math:`n = 1, 2,..., N`
        for an :math:`N = O(B)` if the current bit accuracy is :math:`B`. If it is not defined
        for one of these values, translate or rescale accordingly:

        ::

        ? limitnum(n->log(1-1/n)) \\ can't evaluate at n = 1 !
        *** at top-level: limitnum(n->log(1-1/n))
        *** ^-----------------------
        *** in function limitnum: log(1-1/n)
        *** ^----------
        *** log: domain error in log: argument = 0
        ? limitnum(n->-log(1-1/(2*n)))
        %19 = -6.11[...] E-58

        We conclude with a complicated example. Since the function is heuristic,
        it is advisable to check whether it produces the same limit for
        :math:`u_{n}, u_{2n},...u_{km}` for a suitable small multiplier :math:`k`.
        The following function implements the recursion for the Motzkin numbers
        :math:`M_{n}` which count the number of ways to draw non intersecting chords between
        :math:`n` points on a circle:

        .. MATH::

        M_{n} = M_{n-1} + \sum_{i < n-1} M_{i} M_{n-2-i}
        = ((n+1)M_{n-1}+(3n-3)M_{n-2}) / (n+2).

        It is known that :math:`M_{n}^2 ~ (9^{n+1})/(12\pi n^{3})`.

        ::

        \\ [M_k, M_{k*2}, ..., M_{k*N}] / (3^n / n^(3/2))
        vM(N, k = 1) =
        { my(q = k*N, V);
        if (q == 1, return ([1/3]));
        V = vector(q); V[1] = V[2] = 1;
        for(n = 2, q - 1,
        V[n+1] = ((2*n + 1)*V[n] + 3*(n - 1)*V[n-1]) / (n + 2));
        f = (n -> 3^n / n^(3/2));
        return (vector(N, n, V[n*k] / f(n*k)));
        }
        ? limitnum(vM) - 3/sqrt(12*Pi) \\ complete junk
        %1 = 35540390.753542730306762369615276452646
        ? limitnum(N->vM(N,5)) - 3/sqrt(12*Pi) \\ M_{5n}: better
        %2 = 4.130710262178469860 E-25
        ? limitnum(N->vM(N,10)) - 3/sqrt(12*Pi) \\ M_{10n}: perfect
        %3 = 0.E-38
        ? \p2000
        ? limitnum(N->vM(N,10)) - 3/sqrt(12*Pi) \\ also at high accuracy
        time = 409 ms.
        %4 = 1.1048895470044788191 E-2004

        In difficult cases such as the above a multiplier of 5 to 10
        is usually sufficient. The above example is typical: a good multiplier usually
        remains sufficient when the requested precision increases!
        '''
        cdef bint _have_alpha = (alpha is not None)
        if _have_alpha:
            alpha = objtogen(alpha)
        sig_on()
        cdef GEN _expr = (<Gen>expr).g
        cdef GEN _alpha = NULL
        if _have_alpha:
            _alpha = (<Gen>alpha).g
        precision = nbits2prec(precision)
        cdef GEN _ret = limitnum0(_expr, _alpha, precision)
        return new_gen(_ret)

    def lindep(v, long flag=0):
        r'''
        finds a small nontrivial integral linear
        combination between components of :math:`v`. If none can be found return an empty
        vector.

        If :math:`v` is a vector with real/complex entries we use a floating point
        (variable precision) LLL algorithm. If :math:`flag = 0` the accuracy is chosen
        internally using a crude heuristic. If :math:`flag > 0` the computation is done with
        an accuracy of :math:`flag` decimal digits. To get meaningful results in the latter
        case, the parameter :math:`flag` should be smaller than the number of correct
        decimal digits in the input.

        ::

        ? lindep([sqrt(2), sqrt(3), sqrt(2)+sqrt(3)])
        %1 = [-1, -1, 1]~

        If :math:`v` is :math:`p`-adic, :math:`flag` is ignored and the algorithm LLL-reduces a
        suitable (dual) lattice.

        ::

        ? lindep([1, 2 + 3 + 3^2 + 3^3 + 3^4 + O(3^5)])
        %2 = [1, -2]~

        If :math:`v` is a matrix (or a vector of column vectors, or a vector of row
        vectors), :math:`flag` is ignored and the function returns a non trivial kernel
        vector if one exists, else an empty vector.

        ::

        ? lindep([1,2,3;4,5,6;7,8,9])
        %3 = [1, -2, 1]~
        ? lindep([[1,0], [2,0]])
        %4 = [2, -1]~
        ? lindep([[1,0], [0,1]])
        %5 = []~

        If :math:`v` contains polynomials or power series over some base field, finds a
        linear relation with coefficients in the field.

        ::

        ? lindep([x*y, x^2 + y, x^2*y + x*y^2, 1])
        %4 = [y, y, -1, -y^2]~

        For better control, it is preferable to use :literal:`t_POL` rather
        than :literal:`t_SER` in the input, otherwise one gets a linear combination which is
        :math:`t`-adically small, but not necessarily :math:`0`. Indeed, power series are first
        converted to the minimal absolute accuracy occurring among the entries of :math:`v`
        (which can cause some coefficients to be ignored), then truncated to
        polynomials:

        ::

        ? v = [t^2+O(t^4), 1+O(t^2)]; L=lindep(v)
        %1 = [1, 0]~
        ? v*L
        %2 = t^2+O(t^4) \\ small but not 0
        '''
        sig_on()
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = lindep0(_v, flag)
        return new_gen(_ret)

    def listinsert(x, n, long _arg2):
        r'''
        Inserts the object :math:`x` at
        position :math:`n` in :math:`L` (which must be of type :literal:`t_LIST`).
        This has complexity :math:`O(\#L - n + 1)`: all the
        remaining elements of :emphasis:`list` (from position :math:`n+1` onwards) are shifted
        to the right. If :math:`n` is greater than the list length, appends :math:`x`.

        ::

        ? L = List([1,2,3]);
        ? listput(~L, 4); L \\ listput inserts at end
        %4 = List([1, 2, 3, 4])
        ? listinsert(~L, 5, 1); L \\insert at position 1
        %5 = List([5, 1, 2, 3, 4])
        ? listinsert(~L, 6, 1000); L \\ trying to insert beyond position #L
        %6 = List([5, 1, 2, 3, 4, 6]) \\ ... inserts at the end

        Note the :literal:`~ L`: this means that the function is
        called with a :emphasis:`reference` to :literal:`L` and changes :literal:`L` in place.
        '''
        if _arg2 is not None:
            from warnings import warn
            warn('argument 2 of the PARI/GP function listinsert is undocumented and deprecated', DeprecationWarning)
        n = objtogen(n)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = listinsert0(_x, _n, _arg2)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def listkill(_arg0):
        r'''
        Obsolete, retained for backward compatibility. Just use :literal:`L = List()`
        instead of :literal:`listkill(L)`. In most cases, you won't even need that, e.g.
        local variables are automatically cleared when a user function returns.
        '''
        from warnings import warn
        warn('the PARI/GP function listkill is obsolete (2007-08-10)', DeprecationWarning)
        if _arg0 is not None:
            from warnings import warn
            warn('argument 0 of the PARI/GP function listkill is undocumented and deprecated', DeprecationWarning)
        sig_on()
        cdef GEN __arg0 = (<Gen>_arg0).g
        listkill(__arg0)
        clear_stack()

    def listpop(n, long _arg1=0):
        r'''
        Removes the :math:`n`-th element of the list
        :emphasis:`list` (which must be of type :literal:`t_LIST`). If :math:`n` is omitted,
        or greater than the list current length, removes the last element.
        If the list is already empty, do nothing. This runs in time :math:`O(\#L - n + 1)`.

        ::

        ? L = List([1,2,3,4]);
        ? listpop(~L); L \\ remove last entry
        %2 = List([1, 2, 3])
        ? listpop(~L, 1); L \\ remove first entry
        %3 = List([2, 3])

        Note the :literal:`~ L`: this means that the function is
        called with a :emphasis:`reference` to :literal:`L` and changes :literal:`L` in place.
        '''
        if _arg1 is not None:
            from warnings import warn
            warn('argument 1 of the PARI/GP function listpop is undocumented and deprecated', DeprecationWarning)
        sig_on()
        cdef GEN _n = (<Gen>n).g
        listpop0(_n, _arg1)
        clear_stack()

    def listput(x, n, long _arg2=0):
        r'''
        Sets the :math:`n`-th element of the list
        :emphasis:`list` (which must be of type :literal:`t_LIST`) equal to :math:`x`. If :math:`n` is omitted,
        or greater than the list length, appends :math:`x`.

        ::

        ? L = List();
        ? listput(~L, 1)
        ? listput(~L, 2)
        ? L
        %4 = List([1, 2])

        Note the :literal:`~ L`: this means that the function is
        called with a :emphasis:`reference` to :literal:`L` and changes :literal:`L` in place.

        You may put an element into an occupied cell (not changing the
        list length), but it is easier to use the standard :literal:`list[n] = x`
        construct.

        ::

        ? listput(~L, 3, 1) \\ insert at position 1
        ? L
        %6 = List([3, 2])
        ? L[2] = 4 \\ simpler
        %7 = List([3, 4])
        ? L[10] = 1 \\ can't insert beyond the end of the list
        *** at top-level: L[10]=1
        *** ^------
        *** nonexistent component: index > 2
        ? listput(L, 1, 10) \\ but listput can
        ? L
        %9 = List([3, 2, 1])

        This function runs in time :math:`O(\#L)` in the worst case (when the list must
        be reallocated), but in time :math:`O(1)` on average: any number of successive
        :literal:`listput` s run in time :math:`O(\#L)`, where :math:`\#L` denotes the list
        :emphasis:`final` length.
        '''
        if _arg2 is not None:
            from warnings import warn
            warn('argument 2 of the PARI/GP function listput is undocumented and deprecated', DeprecationWarning)
        n = objtogen(n)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _n = (<Gen>n).g
        cdef GEN _ret = listput0(_x, _n, _arg2)
        _ret = gcopy(_ret)
        return new_gen(_ret)

    def listsort(flag, long _arg1=0):
        r'''
        Sorts the :literal:`t_LIST` :emphasis:`list` in place, with respect to the (somewhat
        arbitrary) universal comparison function :literal:`cmp`. In particular, the
        ordering is the same as for sets and :literal:`setsearch` can be used on a sorted
        list. No value is returned. If :math:`flag` is nonzero, suppresses all repeated
        coefficients.

        ::

        ? L = List([1,2,4,1,3,-1]); listsort(~L); L
        %1 = List([-1, 1, 1, 2, 3, 4])
        ? setsearch(L, 4)
        %2 = 6
        ? setsearch(L, -2)
        %3 = 0
        ? listsort(~L, 1); L \\ remove duplicates
        %4 = List([-1, 1, 2, 3, 4])

        Note the :literal:`~ L`: this means that the function is
        called with a :emphasis:`reference` to :literal:`L` and changes :literal:`L` in place:
        this is faster than the :literal:`vecsort` command since the list
        is sorted in place and we avoid unnecessary copies.

        ::

        ? v = vector(100,i,random); L = List(v);
        ? for(i=1,10^4, vecsort(v))
        time = 162 ms.
        ? for(i=1,10^4, vecsort(L))
        time = 162 ms.
        ? for(i=1,10^4, listsort(~L))
        time = 63 ms.
        '''
        if _arg1 is not None:
            from warnings import warn
            warn('argument 1 of the PARI/GP function listsort is undocumented and deprecated', DeprecationWarning)
        sig_on()
        cdef GEN _flag = (<Gen>flag).g
        listsort(_flag, _arg1)
        clear_stack()

    def lngamma(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of the logarithm of the gamma function of :math:`x`. This
        function is analytic on the complex plane with nonpositive integers
        removed, and can have much larger arguments than :literal:`gamma` itself.

        For :math:`x` a power series such that :math:`x(0)` is not a pole of :literal:`gamma`,
        compute the Taylor expansion. (PARI only knows about regular power series
        and can't include logarithmic terms.)

        ::

        ? lngamma(1+x+O(x^2))
        %1 = -0.57721566490153286060651209008240243104*x + O(x^2)
        ? lngamma(x+O(x^2))
        *** at top-level: lngamma(x+O(x^2))
        *** ^-----------------
        *** lngamma: domain error in lngamma: valuation != 0
        ? lngamma(-1+x+O(x^2))
        *** lngamma: Warning: normalizing a series with 0 leading term.
        *** at top-level: lngamma(-1+x+O(x^2))
        *** ^--------------------
        *** lngamma: domain error in intformal: residue(series, pole) != 0

        For :math:`x` a :literal:`t_PADIC`, return the :math:`p`-adic :math:`\log\Gamma_{p}` function, which
        is the :math:`p`-adic logarithm of Morita's gamma function for :math:`x \in \mathbb{Z}_{p}`,
        and Diamond's function if :math:`\|x\| > 1`.

        ::

        ? lngamma(5+O(5^7))
        %2 = 4*5^2 + 4*5^3 + 5^4 + 2*5^5 + O(5^6)
        ? log(gamma(5+O(5^7)))
        %3 = 4*5^2 + 4*5^3 + 5^4 + 2*5^5 + O(5^6)
        ? lngamma(1/5+O(5^4))
        %4 = 4*5^-1 + 4 + 2*5 + 5^2 + 5^3 + O(5^4)
        ? gamma(1/5+O(5^4))
        *** at top-level: gamma(1/5+O(5^4))
        *** ^-----------------
        *** gamma: domain error in gamma: v_p(x) < 0
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = glngamma(_x, precision)
        return new_gen(_ret)

    def localbitprec(p):
        r'''
        Set the real precision to :math:`p` bits in the dynamic scope.
        All computations are performed as if :literal:`realbitprecision` was :math:`p`:
        transcendental constants (e.g. :literal:`Pi`) and
        conversions from exact to floating point inexact data use :math:`p` bits, as well as
        iterative routines implicitly using a floating point
        accuracy as a termination criterion (e.g. :literal:`solve` or :literal:`intnum`).
        But :literal:`realbitprecision` itself is unaffected
        and is "unmasked" when we exit the dynamic (:emphasis:`not` lexical) scope.
        In effect, this is similar to

        ::

        my(bit = default(realbitprecision));
        default(realbitprecision,p);
        ...
        default(realbitprecision, bit);

        but is both less cumbersome, cleaner (no need to manipulate
        a global variable, which in fact never changes and is only temporarily masked)
        and more robust: if the above computation is interrupted or an exception
        occurs, :literal:`realbitprecision` will not be restored as intended.

        Such :literal:`localbitprec` statements can be nested, the innermost one taking
        precedence as expected. Beware that :literal:`localbitprec` follows the semantic of
        :literal:`local`, not :literal:`my`: a subroutine called from :literal:`localbitprec` scope
        uses the local accuracy:

        ::

        ? f()=bitprecision(1.0);
        ? f()
        %2 = 128
        ? localbitprec(1000); f()
        %3 = 1024

        Note that the bit precision of :emphasis:`data` (:literal:`1.0` in the
        above example) increases by steps of 64 (32 on a 32-bit machine) so we get
        :math:`1024` instead of the expected :math:`1000`; :literal:`localbitprec` bounds the
        relative error exactly as specified in functions that support that
        granularity (e.g. :literal:`lfun`), and rounded to the next multiple of 64
        (resp. 32) everywhere else.

        :strong:`Warning.` Changing :literal:`realbitprecision` or :literal:`realprecision`
        in programs is deprecated in favor of :literal:`localbitprec` and
        :literal:`localprec`. Think about the :literal:`realprecision` and
        :literal:`realbitprecision` defaults as interactive commands for the :literal:`gp`
        interpreter, best left out of GP programs. Indeed, the above rules imply that
        mixing both constructs yields surprising results:

        ::

        ? \p38
        ? localprec(19); default(realprecision,1000); Pi
        %1 = 3.141592653589793239
        ? \p
        realprecision = 1001 significant digits (1000 digits displayed)

        Indeed, :literal:`realprecision` itself is ignored within
        :literal:`localprec` scope, so :literal:`Pi` is computed to a low accuracy. And when
        we leave the :literal:`localprec` scope, :literal:`realprecision` only regains precedence,
        it is not "restored" to the original value.
        '''
        sig_on()
        cdef GEN _p = (<Gen>p).g
        localbitprec(_p)
        clear_stack()

    def localprec(p):
        r'''
        Set the real precision to :math:`p` in the dynamic scope and return :math:`p`.
        All computations are performed as if :literal:`realprecision` was :math:`p`:
        transcendental constants (e.g. :literal:`Pi`) and
        conversions from exact to floating point inexact data use :math:`p` decimal
        digits, as well as iterative routines implicitly using a floating point
        accuracy as a termination criterion (e.g. :literal:`solve` or :literal:`intnum`).
        But :literal:`realprecision` itself is unaffected
        and is "unmasked" when we exit the dynamic (:emphasis:`not` lexical) scope.
        In effect, this is similar to

        ::

        my(prec = default(realprecision));
        default(realprecision,p);
        ...
        default(realprecision, prec);

        but is both less cumbersome, cleaner (no need to manipulate
        a global variable, which in fact never changes and is only temporarily masked)
        and more robust: if the above computation is interrupted or an exception
        occurs, :literal:`realprecision` will not be restored as intended.

        Such :literal:`localprec` statements can be nested, the innermost one taking
        precedence as expected. Beware that :literal:`localprec` follows the semantic of
        :literal:`local`, not :literal:`my`: a subroutine called from :literal:`localprec` scope
        uses the local accuracy:

        ::

        ? f()=precision(1.);
        ? f()
        %2 = 38
        ? localprec(19); f()
        %3 = 19

        :strong:`Warning.` Changing :literal:`realprecision` itself in programs is
        now deprecated in favor of :literal:`localprec`. Think about the
        :literal:`realprecision` default as an interactive command for the :literal:`gp`
        interpreter, best left out of GP programs. Indeed, the above rules
        imply that mixing both constructs yields surprising results:

        ::

        ? \p38
        ? localprec(19); default(realprecision,100); Pi
        %1 = 3.141592653589793239
        ? \p
        realprecision = 115 significant digits (100 digits displayed)

        Indeed, :literal:`realprecision` itself is ignored within
        :literal:`localprec` scope, so :literal:`Pi` is computed to a low accuracy. And when
        we leave :literal:`localprec` scope, :literal:`realprecision` only regains precedence,
        it is not "restored" to the original value.
        '''
        sig_on()
        cdef GEN _p = (<Gen>p).g
        localprec(_p)
        clear_stack()

    def log(x, long precision=DEFAULT_BITPREC):
        r'''
        Principal branch of the natural logarithm of
        :math:`x \in \mathbb{C}^{*}`, i.e. such that :math:`\Im (\log (x))\in ]-\pi,\pi]`.
        The branch cut lies
        along the negative real axis, continuous with quadrant 2, i.e. such that
        :math:`\lim_{b\to 0^{+}} \log (a+bi) = \log a` for :math:`a \in\mathbb{R}^{*}`.
        The result is complex
        (with imaginary part equal to :math:`\pi`) if :math:`x\in \mathbb{R}` and :math:`x < 0`. In general,
        the algorithm uses the formula

        .. MATH::

        \log (x) ~ (\pi)/(2agm(1, 4/s)) - m \log 2,

        if :math:`s = x 2^{m}` is large enough. (The result is exact to :math:`B` bits provided
        :math:`s > 2^{B/2}`.) At low accuracies, the series expansion near :math:`1` is used.

        :math:`p`-adic arguments are also accepted for :math:`x`, with the convention that
        :math:`\log (p) = 0`. Hence in particular :math:`\exp (\log (x))/x` is not in general equal to
        1 but to a :math:`(p-1)`-th root of unity (or :math:`±1` if :math:`p = 2`) times a power of :math:`p`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = glog(_x, precision)
        return new_gen(_ret)

    def log1p(x, long precision=DEFAULT_BITPREC):
        r'''
        Return :math:`\log (1+x)`, computed in a way that is also accurate
        when the real part of :math:`x` is near :math:`0`. This is the reciprocal function
        of :literal:`expm1`:math:`(x) = \exp (x)-1`.

        ::

        ? default(realprecision, 10000); x = Pi*1e-100;
        ? (expm1(log1p(x)) - x) / x
        %2 = -7.668242895059371866 E-10019
        ? (log1p(expm1(x)) - x) / x
        %3 = -7.668242895059371866 E-10019

        When :math:`x` is small, this function is both faster and more
        accurate than :math:`\log (1+x)`:

        ::

        ? \p38
        ? x = 1e-20;
        ? localprec(100); c = log1p(x); \\ reference point
        ? a = log1p(x); abs((a - c)/c)
        %6 = 0.E-38
        ? b = log(1+x); abs((b - c)/c) \\ slightly less accurate
        %7 = 1.5930919111324522770 E-38
        ? for (i=1,10^5,log1p(x))
        time = 81 ms.
        ? for (i=1,10^5,log(1+x))
        time = 100 ms. \\ slower, too
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = glog1p(_x, precision)
        return new_gen(_ret)

    def logint(x, b, z=None):
        r'''
        Return the largest non-negative integer :math:`e` so that :math:`b^{e} <= x`, where
        :math:`b > 1` is an integer and :math:`x >= 1` is a real number. If the parameter :math:`z`
        is present, set it to :math:`b^{e}`.

        ::

        ? logint(1000, 2)
        %1 = 9
        ? 2^9
        %2 = 512
        ? logint(1000, 2, &z)
        %3 = 9
        ? z
        %4 = 512
        ? logint(Pi^2, 2, &z)
        %5 = 3
        ? z
        %6 = 8

        The number of digits used to write :math:`x` in base :math:`b` is
        :literal:`1 + logint(x,b)`:

        ::

        ? #digits(1000!, 10)
        %5 = 2568
        ? logint(1000!, 10)
        %6 = 2567

        This function may conveniently replace

        ::

        floor( log(x) / log(b) )

        which may not give the correct answer since PARI
        does not guarantee exact rounding.
        '''
        b = objtogen(b)
        cdef bint _have_z = (z is not None)
        if _have_z:
            raise NotImplementedError("optional argument z not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _b = (<Gen>b).g
        cdef GEN * _z = NULL
        cdef long _ret = logint0(_x, _b, _z)
        clear_stack()
        return _ret

    def mapapply(x, f, u, _arg3=None):
        r'''
        Applies the closure :math:`f` to the image :math:`y` of :math:`x` by the map :math:`M`
        and returns the evaluation :math:`f(y)`. The closure :math:`f` is allowed to
        modify the components of :math:`y` in place. If :math:`M` is not defined at :math:`x`, and
        the optional argument :literal:`u` (for :emphasis:`undefined`) is present and is
        a closure of arity :math:`0`, return the evaluation :math:`u()`.

        To apply :math:`f` to :emphasis:`all` entries (values) of :math:`M`, use :literal:`apply`:math:`(f, M)`
        instead. There are two main use-cases:

        - performing a computation on a value directly, without using
        :literal:`mapget`, avoiding a copy:

        ::

        ? M = Map(); mapput(~M, "a", mathilbert(2000));
        ? matsize(mapget(M, "a")) \\ Slow because mapget(M, "a") copies the value
        %2 = [2000, 2000]
        time = 101 ms.
        ? mapapply(~M, "a", matsize) \\ Fast
        time = 0 ms.
        %3 = [2000, 2000]

        - modifying a value in place, for example to append an element to a value
        in a map of lists. This requires to use :literal:`~` in the function
        declaration. In the following :literal:`maplistput`, :math:`M` is a map of lists and we
        append :math:`v` to the list :literal:`mapget(M,k)`, except this is done in place !
        When the map is undefined at :math:`k`, we use the :math:`u`(ndefined) argument
        :literal:`()- > List(v)` to convert :math:`v` to a list then insert it in the map:

        ::

        ? maplistput(~M, k, v) = mapapply(~M, k, (~y)->listput(~y,v), ()->List(v));
        
        ? M = Map();
        %2 = Map([;])
        ? maplistput(~M, "a", 1); M
        %3 = Map(["a", List([1])])
        ? maplistput(~M, "a", 2); M
        %4 = Map(["a", List([1, 2])])
        ? maplistput(~M, "b", 3); M
        %5 = Map(["a", List([1, 2]); "b", List([3])])
        ? maplistput(~M, "a", 4); M
        %6 = Map(["a", List([1, 2, 4]); "b", List([])])
        '''
        if _arg3 is not None:
            from warnings import warn
            warn('argument 3 of the PARI/GP function mapapply is undocumented and deprecated', DeprecationWarning)
        f = objtogen(f)
        u = objtogen(u)
        cdef bint _have__arg3 = (_arg3 is not None)
        if _have__arg3:
            _arg3 = objtogen(_arg3)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _f = (<Gen>f).g
        cdef GEN _u = (<Gen>u).g
        cdef GEN __arg3 = NULL
        if _have__arg3:
            __arg3 = (<Gen>_arg3).g
        cdef GEN _ret = mapapply(_x, _f, _u, __arg3)
        return new_gen(_ret)

    def mapdelete(x, _arg1):
        r'''
        Removes :math:`x` from the domain of the map :math:`M`.

        ::

        ? M = Map(["a",1; "b",3; "c",7]);
        ? mapdelete(M,"b");
        ? Mat(M)
        ["a" 1]
        
        ["c" 7]
        '''
        if _arg1 is not None:
            from warnings import warn
            warn('argument 1 of the PARI/GP function mapdelete is undocumented and deprecated', DeprecationWarning)
        _arg1 = objtogen(_arg1)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN __arg1 = (<Gen>_arg1).g
        mapdelete(_x, __arg1)
        clear_stack()

    def mapget(M, x):
        r'''
        Returns the image of :math:`x` by the map :math:`M`.

        ::

        ? M=Map(["a",23;"b",43]);
        ? mapget(M,"a")
        %2 = 23
        ? mapget(M,"b")
        %3 = 43

        Raises an exception when the key :math:`x` is not present in :math:`M`.

        ::

        ? mapget(M,"c")
        *** at top-level: mapget(M,"c")
        *** ^-------------
        *** mapget: nonexistent component in mapget: index not in map
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = mapget(_M, _x)
        return new_gen(_ret)

    def mapisdefined(M, x, z=None):
        r'''
        Returns true (:math:`1`) if :math:`x` has an image by the map :math:`M`, false (:math:`0`)
        otherwise. If :math:`z` is present, set :math:`z` to the image of :math:`x`, if it exists.

        ::

        ? M1 = Map([1, 10; 2, 20]);
        ? mapisdefined(M1,3)
        %1 = 0
        ? mapisdefined(M1, 1, &z)
        %2 = 1
        ? z
        %3 = 10

        ::

        ? M2 = Map(); N = 19;
        ? for (a=0, N-1, mapput(M2, a^3%N, a));
        ? {for (a=0, N-1,
        if (mapisdefined(M2, a, &b),
        printf("%d is the cube of %d mod %d\n",a,b,N)));}
        0 is the cube of 0 mod 19
        1 is the cube of 11 mod 19
        7 is the cube of 9 mod 19
        8 is the cube of 14 mod 19
        11 is the cube of 17 mod 19
        12 is the cube of 15 mod 19
        18 is the cube of 18 mod 19
        '''
        x = objtogen(x)
        cdef bint _have_z = (z is not None)
        if _have_z:
            raise NotImplementedError("optional argument z not available")
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _z = NULL
        cdef int _ret = mapisdefined(_M, _x, _z)
        clear_stack()
        return _ret

    def mapput(x, y, _arg2):
        r'''
        Associates :math:`x` to :math:`y` in the map :math:`M`. The value :math:`y` can be retrieved
        with :literal:`mapget`.

        ::

        ? M = Map();
        ? mapput(~M, "foo", 23);
        ? mapput(~M, 7718, "bill");
        ? mapget(M, "foo")
        %4 = 23
        ? mapget(M, 7718)
        %5 = "bill"
        ? Vec(M) \\ keys
        %6 = [7718, "foo"]
        ? Mat(M)
        %7 =
        [ 7718 "bill"]
        
        ["foo" 23]
        '''
        if _arg2 is not None:
            from warnings import warn
            warn('argument 2 of the PARI/GP function mapput is undocumented and deprecated', DeprecationWarning)
        y = objtogen(y)
        _arg2 = objtogen(_arg2)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN __arg2 = (<Gen>_arg2).g
        mapput(_x, _y, __arg2)
        clear_stack()

    def matadjoint(M, long flag=0):
        r'''
        adjoint matrix of :math:`M`, i.e. a matrix :math:`N`
        of cofactors of :math:`M`, satisfying :math:`M*N = \det (M)*\mathrm{Id}`. :math:`M` must be a
        (not necessarily invertible) square matrix of dimension :math:`n`.
        If :math:`flag` is 0 or omitted, we try to use Leverrier-Faddeev's algorithm,
        which assumes that :math:`n!` invertible. If it fails or :math:`flag = 1`,
        computes :math:`T = charpoly (M)` independently first and returns
        :math:`(-1)^{n-1} (T(x)-T(0))/x` evaluated at :math:`M`.

        ::

        ? a = [1,2,3;3,4,5;6,7,8] * Mod(1,4);
        ? matadjoint(a)
        %2 =
        [Mod(1, 4) Mod(1, 4) Mod(2, 4)]
        
        [Mod(2, 4) Mod(2, 4) Mod(0, 4)]
        
        [Mod(1, 4) Mod(1, 4) Mod(2, 4)]

        Both algorithms use :math:`O(n^{4})` operations in the base ring. Over a field,
        they are usually slower than computing the characteristic polynomial or
        the inverse of :math:`M` directly.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = matadjoint0(_M, flag)
        return new_gen(_ret)

    def matalgtobasis(nf, x):
        r'''
        This function is deprecated, use :literal:`apply`.

        :math:`nf` being a number field in :literal:`nfinit` format, and :math:`x` a
        (row or column) vector or matrix, apply :literal:`nfalgtobasis` to each entry
        of :math:`x`.
        '''
        from warnings import warn
        warn('the PARI/GP function matalgtobasis is obsolete (2016-08-08)', DeprecationWarning)
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matalgtobasis(_nf, _x)
        return new_gen(_ret)

    def matbasistoalg(nf, x):
        r'''
        This function is deprecated, use :literal:`apply`.

        :math:`nf` being a number field in :literal:`nfinit` format, and :math:`x` a
        (row or column) vector or matrix, apply :literal:`nfbasistoalg` to each entry
        of :math:`x`.
        '''
        from warnings import warn
        warn('the PARI/GP function matbasistoalg is obsolete (2016-08-08)', DeprecationWarning)
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matbasistoalg(_nf, _x)
        return new_gen(_ret)

    def matcompanion(x):
        r'''
        The left companion matrix to the nonzero polynomial :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matcompanion(_x)
        return new_gen(_ret)

    def matconcat(v):
        r'''
        Returns a :literal:`t_MAT` built from the entries of :math:`v`, which may
        be a :literal:`t_VEC` (concatenate horizontally), a :literal:`t_COL` (concatenate
        vertically), or a :literal:`t_MAT` (concatenate vertically each column, and
        concatenate vertically the resulting matrices). The entries of :math:`v` are always
        considered as matrices: they can themselves be :literal:`t_VEC` (seen as a row
        matrix), a :literal:`t_COL` seen as a column matrix), a :literal:`t_MAT`, or a scalar (seen
        as an :math:`1 x 1` matrix).

        ::

        ? A=[1,2;3,4]; B=[5,6]~; C=[7,8]; D=9;
        ? matconcat([A, B]) \\ horizontal
        %1 =
        [1 2 5]
        
        [3 4 6]
        ? matconcat([A, C]~) \\ vertical
        %2 =
        [1 2]
        
        [3 4]
        
        [7 8]
        ? matconcat([A, B; C, D]) \\ block matrix
        %3 =
        [1 2 5]
        
        [3 4 6]
        
        [7 8 9]

        If the dimensions of the entries to concatenate do not match up, the above
        rules are extended as follows:

        - each entry :math:`v_{i,j}` of :math:`v` has a natural length and height: :math:`1 x
        1` for a scalar, :math:`1 x n` for a :literal:`t_VEC` of length :math:`n`, :math:`n x 1`
        for a :literal:`t_COL`, :math:`m x n` for an :math:`m x n` :literal:`t_MAT`

        - let :math:`H_{i}` be the maximum over :math:`j` of the lengths of the :math:`v_{i,j}`,
        let :math:`L_{j}` be the maximum over :math:`i` of the heights of the :math:`v_{i,j}`.
        The dimensions of the :math:`(i,j)`-th block in the concatenated matrix are
        :math:`H_{i} x L_{j}`.

        - a scalar :math:`s = v_{i,j}` is considered as :math:`s` times an identity matrix
        of the block dimension :math:`\min (H_{i},L_{j})`

        - blocks are extended by 0 columns on the right and 0 rows at the
        bottom, as needed.

        ::

        ? matconcat([1, [2,3]~, [4,5,6]~]) \\ horizontal
        %4 =
        [1 2 4]
        
        [0 3 5]
        
        [0 0 6]
        ? matconcat([1, [2,3], [4,5,6]]~) \\ vertical
        %5 =
        [1 0 0]
        
        [2 3 0]
        
        [4 5 6]
        ? matconcat([B, C; A, D]) \\ block matrix
        %6 =
        [5 0 7 8]
        
        [6 0 0 0]
        
        [1 2 9 0]
        
        [3 4 0 9]
        ? U=[1,2;3,4]; V=[1,2,3;4,5,6;7,8,9];
        ? matconcat(matdiagonal([U, V])) \\ block diagonal
        %7 =
        [1 2 0 0 0]
        
        [3 4 0 0 0]
        
        [0 0 1 2 3]
        
        [0 0 4 5 6]
        
        [0 0 7 8 9]
        '''
        sig_on()
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = matconcat(_v)
        return new_gen(_ret)

    def matdet(x, long flag=0):
        r'''
        Determinant of the square matrix :math:`x`.

        If :math:`flag = 0`, uses an appropriate algorithm depending on the coefficients:

        - integer entries: modular method due to Dixon, Pernet and Stein.

        - real or :math:`p`-adic entries: classical Gaussian elimination using maximal
        pivot.

        - intmod entries: classical Gaussian elimination using first nonzero
        pivot.

        - other cases: Gauss-Bareiss.

        If :math:`flag = 1`, uses classical Gaussian elimination with appropriate pivoting
        strategy (maximal pivot for real or :math:`p`-adic coefficients). This is usually
        worse than the default.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = det0(_x, flag)
        return new_gen(_ret)

    def matdetint(B):
        r'''
        Let :math:`B` be an :math:`m x n` matrix with integer coefficients. The
        :emphasis:`determinant` :math:`D` of the lattice generated by the columns of :math:`B` is
        the square root of :math:`\det (B^{T} B)` if :math:`B` has maximal rank :math:`m`, and :math:`0`
        otherwise.

        This function uses the Gauss-Bareiss algorithm to compute a positive
        :emphasis:`multiple` of :math:`D`. When :math:`B` is square, the function actually returns
        :math:`D = \|\det B\|`.

        This function is useful in conjunction with :literal:`mathnfmod`, which needs to
        know such a multiple. If the rank is maximal but the matrix is nonsquare,
        you can obtain :math:`D` exactly using

        ::

        matdet( mathnfmod(B, matdetint(B)) )

        Note that as soon as one of the dimensions gets large (:math:`m` or :math:`n` is larger
        than 20, say), it will often be much faster to use :literal:`mathnf(B, 1)` or
        :literal:`mathnf(B, 4)` directly.
        '''
        sig_on()
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = detint(_B)
        return new_gen(_ret)

    def matdetmod(x, d):
        r'''
        Given a matrix :math:`x` with :literal:`t_INT` entries and :math:`d` an arbitrary positive
        integer, return the determinant of :math:`x` modulo :math:`d`.

        ::

        ? A = [4,2,3; 4,5,6; 7,8,9]
        
        ? matdetmod(A,27)
        %2 = 9

        Note that using the generic function :literal:`matdet` on a matrix with
        :literal:`t_INTMOD` entries uses Gaussian reduction and will fail in general when
        the modulus is not prime.

        ::

        ? matdet(A * Mod(1,27))
        *** at top-level: matdet(A*Mod(1,27))
        *** ^------------------
        *** matdet: impossible inverse in Fl_inv: Mod(3, 27).
        '''
        d = objtogen(d)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = matdetmod(_x, _d)
        return new_gen(_ret)

    def matdiagonal(x):
        r'''
        :math:`x` being a vector, creates the diagonal matrix
        whose diagonal entries are those of :math:`x`.

        ::

        ? matdiagonal([1,2,3]);
        %1 =
        [1 0 0]
        
        [0 2 0]
        
        [0 0 3]

        Block diagonal matrices are easily created using
        :literal:`matconcat`:

        ::

        ? U=[1,2;3,4]; V=[1,2,3;4,5,6;7,8,9];
        ? matconcat(matdiagonal([U, V]))
        %1 =
        [1 2 0 0 0]
        
        [3 4 0 0 0]
        
        [0 0 1 2 3]
        
        [0 0 4 5 6]
        
        [0 0 7 8 9]
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = diagonal(_x)
        return new_gen(_ret)

    def mateigen(x, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Returns the (complex) eigenvectors of :math:`x` as columns of a matrix.
        If :math:`flag = 1`, return :math:`[L,H]`, where :math:`L` contains the
        eigenvalues and :math:`H` the corresponding eigenvectors; multiple eigenvalues are
        repeated according to the eigenspace dimension (which may be less
        than the eigenvalue multiplicity in the characteristic polynomial).

        This function first computes the characteristic polynomial of :math:`x` and
        approximates its complex roots :math:`(\lambda_{i})`, then tries to compute the
        eigenspaces as kernels of the :math:`x - \lambda_{i}`. This algorithm is
        ill-conditioned and is likely to miss kernel vectors if some roots of the
        characteristic polynomial are close, in particular if it has multiple roots.

        ::

        ? A = [13,2; 10,14]; mateigen(A)
        %1 =
        [-1/2 2/5]
        
        [ 1 1]
        ? [L,H] = mateigen(A, 1);
        ? L
        %3 = [9, 18]
        ? H
        %4 =
        [-1/2 2/5]
        
        [ 1 1]
        ? A * H == H * matdiagonal(L)
        %5 = 1

        For symmetric matrices, use :literal:`qfjacobi` instead; for Hermitian matrices,
        compute

        ::

        A = real(x);
        B = imag(x);
        y = matconcat([A, -B; B, A]);

        and apply :literal:`qfjacobi` to :math:`y`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mateigen(_x, flag, precision)
        return new_gen(_ret)

    def matfrobenius(M, long flag=0, v=None):
        r'''
        Returns the Frobenius form of
        the square matrix :literal:`M`. If :math:`flag = 1`, returns only the elementary divisors as
        a vector of polynomials in the variable :literal:`v`. If :math:`flag = 2`, returns a
        two-components vector [F,B] where :literal:`F` is the Frobenius form and :literal:`B` is
        the basis change so that :math:`M = B^{-1}FB`.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = matfrobenius(_M, flag, _v)
        return new_gen(_ret)

    def mathess(x):
        r'''
        Returns a matrix similar to the square matrix :math:`x`, which is in upper Hessenberg
        form (zero entries below the first subdiagonal).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = hess(_x)
        return new_gen(_ret)

    def mathnf(M, long flag=0):
        r'''
        Let :math:`R` be a Euclidean ring, equal to :math:`\mathbb{Z}` or to :math:`K[X]` for some field
        :math:`K`. If :math:`M` is a (not necessarily square) matrix with entries in :math:`R`, this
        routine finds the :emphasis:`upper triangular` Hermite normal form of :math:`M`.
        If the rank of :math:`M` is equal to its number of rows, this is a square
        matrix. In general, the columns of the result form a basis of the :math:`R`-module
        spanned by the columns of :math:`M`.

        The values of :math:`flag` are:

        - 0 (default): only return the Hermite normal form :math:`H`

        - 1 (complete output): return :math:`[H,U]`, where :math:`H` is the Hermite
        normal form of :math:`M`, and :math:`U` is a transformation matrix such that :math:`MU = [0\|H]`.
        The matrix :math:`U` belongs to :math:`GL(R)`. When :math:`M` has a large kernel, the
        entries of :math:`U` are in general huge.

        For these two values, we use a naive algorithm, which behaves well
        in small dimension only. Larger values correspond to different algorithms,
        are restricted to :emphasis:`integer` matrices, and all output the unimodular
        matrix :math:`U`. From now on all matrices have integral entries.

        - :math:`flag = 4`, returns :math:`[H,U]` as in "complete output" above, using a
        variant of LLL reduction along the way. The matrix :math:`U` is provably
        small in the :math:`L_{2}` sense, and often close to optimal; but the
        reduction is in general slow, although provably polynomial-time.

        If :math:`flag = 5`, uses Batut's algorithm and output :math:`[H,U,P]`, such that :math:`H` and
        :math:`U` are as before and :math:`P` is a permutation of the rows such that :math:`P` applied
        to :math:`MU` gives :math:`H`. This is in general faster than :math:`flag = 4` but the matrix :math:`U`
        is usually worse; it is heuristically smaller than with the default algorithm.

        When the matrix is dense and the dimension is large (bigger than 100, say),
        :math:`flag = 4` will be fastest. When :math:`M` has maximal rank, then

        ::

        H = mathnfmod(M, matdetint(M))

        will be even faster. You can then recover :math:`U` as :math:`M^{-1}H`.

        ::

        ? M = matrix(3,4,i,j,random([-5,5]))
        %1 =
        [ 0 2 3 0]
        
        [-5 3 -5 -5]
        
        [ 4 3 -5 4]
        
        ? [H,U] = mathnf(M, 1);
        ? U
        %3 =
        [-1 0 -1 0]
        
        [ 0 5 3 2]
        
        [ 0 3 1 1]
        
        [ 1 0 0 0]
        
        ? H
        %5 =
        [19 9 7]
        
        [ 0 9 1]
        
        [ 0 0 1]
        
        ? M*U
        %6 =
        [0 19 9 7]
        
        [0 0 9 1]
        
        [0 0 0 1]

        For convenience, :math:`M` is allowed to be a :literal:`t_VEC`, which is then
        automatically converted to a :literal:`t_MAT`, as per the :literal:`Mat` function.
        For instance to solve the generalized extended gcd problem, one may use

        ::

        ? v = [116085838, 181081878, 314252913,10346840];
        ? [H,U] = mathnf(v, 1);
        ? U
        %2 =
        [ 103 -603 15 -88]
        
        [-146 13 -1208 352]
        
        [ 58 220 678 -167]
        
        [-362 -144 381 -101]
        ? v*U
        %3 = [0, 0, 0, 1]

        This also allows to input a matrix as a :literal:`t_VEC` of
        :literal:`t_COL` s of the same length (which :literal:`Mat` would concatenate to
        the :literal:`t_MAT` having those columns):

        ::

        ? v = [[1,0,4]~, [3,3,4]~, [0,-4,-5]~]; mathnf(v)
        %1 =
        [47 32 12]
        
        [ 0 1 0]
        
        [ 0 0 1]
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = mathnf0(_M, flag)
        return new_gen(_ret)

    def mathnfmod(x, d):
        r'''
        If :math:`x` is a (not necessarily square) matrix of
        maximal rank with integer entries, and :math:`d` is a multiple of the (nonzero)
        determinant of the lattice spanned by the columns of :math:`x`, finds the
        :emphasis:`upper triangular` Hermite normal form of :math:`x`.

        If the rank of :math:`x` is equal to its number of rows, the result is a square
        matrix. In general, the columns of the result form a basis of the lattice
        spanned by the columns of :math:`x`. Even when :math:`d` is known, this is in general
        slower than :literal:`mathnf` but uses much less memory.
        '''
        d = objtogen(d)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = hnfmod(_x, _d)
        return new_gen(_ret)

    def mathnfmodid(x, d):
        r'''
        Outputs the (upper triangular)
        Hermite normal form of :math:`x` concatenated with the diagonal
        matrix with diagonal :math:`d`. Assumes that :math:`x` has integer entries.
        Variant: if :math:`d` is an integer instead of a vector, concatenate :math:`d` times the
        identity matrix.

        ::

        ? m=[0,7;-1,0;-1,-1]
        %1 =
        [ 0 7]
        
        [-1 0]
        
        [-1 -1]
        ? mathnfmodid(m, [6,2,2])
        %2 =
        [2 1 1]
        
        [0 1 0]
        
        [0 0 1]
        ? mathnfmodid(m, 10)
        %3 =
        [10 7 3]
        
        [ 0 1 0]
        
        [ 0 0 1]
        '''
        d = objtogen(d)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = hnfmodid(_x, _d)
        return new_gen(_ret)

    def mathouseholder(Q, v):
        r'''
        applies a sequence :math:`Q` of Householder
        transforms, as returned by :literal:`matqr`:math:`(M,1)` to the vector or matrix :math:`v`.

        ::

        ? m = [2,1; 3,2]; \\ some random matrix
        ? [Q,R] = matqr(m);
        ? Q
        %3 =
        [-0.554... -0.832...]
        
        [-0.832... 0.554...]
        
        ? R
        %4 =
        [-3.605... -2.218...]
        
        [0 0.277...]
        
        ? v = [1, 2]~; \\ some random vector
        ? Q * v
        %6 = [-2.218..., 0.277...]~
        
        ? [q,r] = matqr(m, 1);
        ? exponent(r - R) \\ r is the same as R
        %8 = -128
        ? q \\ but q has a different structure
        %9 = [[0.0494..., [5.605..., 3]]]]
        ? mathouseholder(q, v) \\ applied to v
        %10 = [-2.218..., 0.277...]~

        The point of the Householder structure is that it efficiently
        represents the linear operator :math:`v :---> Q v` in a more stable way
        than expanding the matrix :math:`Q`:

        ::

        ? m = mathilbert(20); v = vectorv(20,i,i^2+1);
        ? [Q,R] = matqr(m);
        ? [q,r] = matqr(m, 1);
        ? \p100
        ? [q2,r2] = matqr(m, 1); \\ recompute at higher accuracy
        ? exponent(R - r)
        %5 = -127
        ? exponent(R - r2)
        %6 = -127
        ? exponent(mathouseholder(q,v) - mathouseholder(q2,v))
        %7 = -119
        ? exponent(Q*v - mathouseholder(q2,v))
        %8 = 9

        We see that :math:`R` is OK with or without a flag to :literal:`matqr`
        but that multiplying by :math:`Q` is considerably less precise than applying the
        sequence of Householder transforms encoded by :math:`q`.
        '''
        v = objtogen(v)
        sig_on()
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = mathouseholder(_Q, _v)
        return new_gen(_ret)

    def matimage(x, long flag=0):
        r'''
        Gives a basis for the image of the
        matrix :math:`x` as columns of a matrix. A priori the matrix can have entries of
        any type. If :math:`flag = 0`, use standard Gauss pivot. If :math:`flag = 1`, use
        :literal:`matsupplement` (much slower: keep the default flag!).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matimage0(_x, flag)
        return new_gen(_ret)

    def matimagecompl(x):
        r'''
        Gives the vector of the column indices which
        are not extracted by the function :literal:`matimage`, as a permutation
        (:literal:`t_VECSMALL`). Hence the number of
        components of :literal:`matimagecompl(x)` plus the number of columns of
        :literal:`matimage(x)` is equal to the number of columns of the matrix :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = imagecompl(_x)
        return new_gen(_ret)

    def matimagemod(x, d, U=None):
        r'''
        Gives a Howell basis (unique representation for submodules
        of :math:`(\mathbb{Z}/d\mathbb{Z})^{n}`)
        for the image of the matrix :math:`x` modulo :math:`d` as columns of a matrix :math:`H`. The
        matrix :math:`x` must have :literal:`t_INT` entries, and :math:`d` can be an arbitrary positive
        integer. If :math:`U` is present, set it to a matrix such that :math:`AU = H`.

        ::

        ? A = [2,1;0,2];
        ? matimagemod(A,6,&U)
        %2 =
        [1 0]
        
        [0 2]
        
        ? U
        %3 =
        [5 1]
        
        [3 4]
        
        ? (A*U)%6
        %4 =
        [1 0]
        
        [0 2]

        :strong:`Caveat.` In general the number of columns of the Howell form is not
        the minimal number of generators of the submodule. Example:

        ::

        ? matimagemod([1;2],4)
        %5 =
        [2 1]
        
        [0 2]

        :strong:`Caveat 2.` In general the matrix :math:`U` is not invertible, even if :math:`A`
        and :math:`H` have the same size. Example:

        ::

        ? matimagemod([4,1;0,4],8,&U)
        %6 =
        [2 1]
        
        [0 4]
        
        ? U
        %7 =
        [0 0]
        
        [2 1]
        '''
        d = objtogen(d)
        cdef bint _have_U = (U is not None)
        if _have_U:
            raise NotImplementedError("optional argument U not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN * _U = NULL
        cdef GEN _ret = matimagemod(_x, _d, _U)
        return new_gen(_ret)

    def matindexrank(M):
        r'''
        :math:`M` being a matrix of rank :math:`r`, returns a vector with two
        :literal:`t_VECSMALL` components :math:`y` and :math:`z` of length :math:`r` giving a list of rows
        and columns respectively (starting from 1) such that the extracted matrix
        obtained from these two vectors using :math:`vecextract (M,y,z)` is
        invertible. The vectors :math:`y` and :math:`z` are sorted in increasing order.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = indexrank(_M)
        return new_gen(_ret)

    def matintersect(x, y):
        r'''
        :math:`x` and :math:`y` being two matrices with the same number of rows, finds a
        basis of the vector space equal to the intersection of the spaces spanned by
        the columns of :math:`x` and :math:`y` respectively. For efficiency, the columns of :math:`x`
        (resp. :math:`y`) should be independent.

        The faster function :literal:`idealintersect` can be used to intersect
        fractional ideals (projective :math:`\mathbb{Z}_{K}` modules of rank :math:`1`); the slower but
        more general function :literal:`nfhnf` can be used to intersect general
        :math:`\mathbb{Z}_{K}`-modules.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = intersect(_x, _y)
        return new_gen(_ret)

    def matinverseimage(x, y):
        r'''
        Given a matrix :math:`x` and
        a column vector or matrix :math:`y`, returns a preimage :math:`z` of :math:`y` by :math:`x` if one
        exists (i.e such that :math:`x z = y`), an empty vector or matrix otherwise. The
        complete inverse image is :math:`z + Ker x`, where a basis of the kernel of
        :math:`x` may be obtained by :literal:`matker`.

        ::

        ? M = [1,2;2,4];
        ? matinverseimage(M, [1,2]~)
        %2 = [1, 0]~
        ? matinverseimage(M, [3,4]~)
        %3 = []~ \\ no solution
        ? matinverseimage(M, [1,3,6;2,6,12])
        %4 =
        [1 3 6]
        
        [0 0 0]
        ? matinverseimage(M, [1,2;3,4])
        %5 = [;] \\ no solution
        ? K = matker(M)
        %6 =
        [-2]
        
        [1]
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = inverseimage(_x, _y)
        return new_gen(_ret)

    def matinvmod(x, d):
        r'''
        Computes a left inverse of the matrix :math:`x` modulo :math:`d`. The matrix :math:`x` must
        have :literal:`t_INT` entries, and :math:`d` can be an arbitrary positive integer.

        ::

        ? A = [3,1,2;1,2,1;3,1,1];
        ? U = matinvmod(A,6)
        %2 =
        [1 1 3]
        
        [2 3 5]
        
        [1 0 5]
        
        ? (U*A)%6
        %3 =
        [1 0 0]
        
        [0 1 0]
        
        [0 0 1]
        ? matinvmod(A,5)
        *** at top-level: matinvmod(A,5)
        *** ^--------------
        *** matinvmod: impossible inverse in gen_inv: 0.
        '''
        d = objtogen(d)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = matinvmod(_x, _d)
        return new_gen(_ret)

    def matisdiagonal(x):
        r'''
        Returns true (1) if :math:`x` is a diagonal matrix, false (0) if not.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef int _ret = isdiagonal(_x)
        clear_stack()
        return _ret

    def matker(x, long flag=0):
        r'''
        Gives a basis for the kernel of the matrix :math:`x` as columns of a matrix.
        The matrix can have entries of any type, provided they are compatible with
        the generic arithmetic operations (:math:`+`, :math:`x` and :math:`/`).

        If :math:`x` is known to have integral entries, set :math:`flag = 1`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matker0(_x, flag)
        return new_gen(_ret)

    def matkerint(x, long flag=0):
        r'''
        Gives an LLL-reduced :math:`\mathbb{Z}`-basis
        for the lattice equal to the kernel of the matrix :math:`x` with rational entries.
        :emphasis:`flag` is deprecated, kept for backward compatibility. The function
        :literal:`matsolvemod` allows to solve more general linear systems over :math:`\mathbb{Z}`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matkerint0(_x, flag)
        return new_gen(_ret)

    def matkermod(x, d, im=None):
        r'''
        Gives a Howell basis (unique representation for submodules
        of :math:`(\mathbb{Z}/d\mathbb{Z})^{n}`,
        cf. :literal:`matimagemod`) for the kernel of the matrix :math:`x` modulo :math:`d` as columns
        of a matrix. The matrix :math:`x` must have :literal:`t_INT` entries, and :math:`d` can be an
        arbitrary positive integer. If :math:`im` is present, set it to a basis of the image
        of :math:`x` (which is computed on the way).

        ::

        ? A = [1,2,3;5,1,4]
        %1 =
        [1 2 3]
        
        [5 1 4]
        
        ? K = matkermod(A,6)
        %2 =
        [2 1]
        
        [2 1]
        
        [0 3]
        
        ? (A*K)%6
        %3 =
        [0 0]
        
        [0 0]
        '''
        d = objtogen(d)
        cdef bint _have_im = (im is not None)
        if _have_im:
            raise NotImplementedError("optional argument im not available")
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN * _im = NULL
        cdef GEN _ret = matkermod(_x, _d, _im)
        return new_gen(_ret)

    def matmuldiagonal(x, d):
        r'''
        Product of the matrix :math:`x` by the diagonal
        matrix whose diagonal entries are those of the vector :math:`d`. Equivalent to,
        but much faster than :math:`x*matdiagonal (d)`.
        '''
        d = objtogen(d)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _d = (<Gen>d).g
        cdef GEN _ret = matmuldiagonal(_x, _d)
        return new_gen(_ret)

    def matmultodiagonal(x, y):
        r'''
        Product of the matrices :math:`x` and :math:`y` assuming that the result is a
        diagonal matrix. Much faster than :math:`x*y` in that case. The result is
        undefined if :math:`x*y` is not diagonal.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = matmultodiagonal(_x, _y)
        return new_gen(_ret)

    def matpermanent(x):
        r'''
        Permanent of the square matrix :math:`x` using Ryser's formula in Gray code
        order.

        ::

        ? n = 20; m = matrix(n,n,i,j, i!=j);
        ? matpermanent(m)
        %2 = 895014631192902121
        ? n! * sum(i=0,n, (-1)^i/i!)
        %3 = 895014631192902121

        This function runs in time :math:`O(2^{n} n)` for a matrix of size
        :math:`n` and is not implemented for :math:`n` large.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matpermanent(_x)
        return new_gen(_ret)

    def matqr(M, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Returns :math:`[Q,R]`, the QR-decomposition of the square invertible
        matrix :math:`M` with real entries: :math:`Q` is orthogonal and :math:`R` upper triangular. If
        :math:`flag = 1`, the orthogonal matrix is returned as a sequence of Householder
        transforms: applying such a sequence is stabler and faster than
        multiplication by the corresponding :math:`Q` matrix.
        More precisely, if

        ::

        [Q,R] = matqr(M);
        [q,r] = matqr(M, 1);

        then :math:`r = R` and :literal:`mathouseholder`:math:`(q, M)` is
        (close to) :math:`R`; furthermore

        ::

        mathouseholder(q, matid(#M)) == Q~

        the inverse of :math:`Q`. This function raises an error if the
        precision is too low or :math:`x` is singular.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        precision = nbits2prec(precision)
        cdef GEN _ret = matqr(_M, flag, precision)
        return new_gen(_ret)

    def matrank(x):
        r'''
        Rank of the matrix :math:`x`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = rank(_x)
        clear_stack()
        return _ret

    def matreduce(m):
        r'''
        Let :math:`m` be a factorization matrix, i.e., a 2-column matrix whose
        columns contains arbitrary "generators" and integer "exponents"
        respectively. Returns the canonical form of :math:`m`: the
        first column is sorted with unique elements and the second one contains the
        merged "exponents" (exponents of identical entries in the first column of
        :math:`m` are added, rows attached to :math:`0` exponents are deleted). The generators are
        sorted with respect to the universal :literal:`cmp` routine; in particular, this
        function is the identity on true integer factorization matrices, but not on
        other factorizations (in products of polynomials or maximal ideals, say). It
        is idempotent.

        For convenience, this function also allows a vector :math:`m`, which is handled as a
        factorization with all exponents equal to :math:`1`, as in :literal:`factorback`.

        ::

        ? A=[x,2;y,4]; B=[x,-2; y,3; 3, 4]; C=matconcat([A,B]~)
        %1 =
        [x 2]
        
        [y 4]
        
        [x -2]
        
        [y 3]
        
        [3 4]
        
        ? matreduce(C)
        %2 =
        [3 4]
        
        [y 7]
        
        ? matreduce([x,x,y,x,z,x,y]) \\ vector argument
        %3 =
        [x 4]
        
        [y 2]
        
        [z 1]

        The following one-line functions will list elements
        occurring exactly once (resp. more than once) in the vector or list :math:`v`:

        ::

        unique(v) = [ x[1] | x <- matreduce(v)~, x[2] == 1 ];
        duplicates(v) = [ x[1] | x <- matreduce(v)~, x[2] > 1 ];
        
        ? v = [0,1,2,3,1,2];
        ? unique(v)
        %2 = [0, 3]
        
        ? duplicates(v)
        %3 = [1, 2]
        '''
        sig_on()
        cdef GEN _m = (<Gen>m).g
        cdef GEN _ret = matreduce(_m)
        return new_gen(_ret)

    def matrixqz(A, p=None):
        r'''
        :math:`A` being an :math:`m x n` matrix in :math:`M_{m,n}(\mathbb{Q})`, let
        :math:`Im_{\mathbb{Q}} A` (resp. :math:`Im_{\mathbb{Z}} A`) the :math:`\mathbb{Q}`-vector space
        (resp. the :math:`\mathbb{Z}`-module) spanned by the columns of :math:`A`. This function has
        varying behavior depending on the sign of :math:`p`:

        If :math:`p >= 0`, :math:`A` is assumed to have maximal rank :math:`n <= m`. The function
        returns a matrix :math:`B\in M_{m,n}(\mathbb{Z})`, with :math:`Im_{\mathbb{Q}} B =
        Im_{\mathbb{Q}} A`,
        such that the GCD of all its :math:`n x n` minors is coprime to
        :math:`p`; in particular, if :math:`p = 0` (default), this GCD is :math:`1`.

        If :math:`p = -1`, returns a basis of the lattice :math:`\mathbb{Z}^{m} \cap Im_{\mathbb{Z}} A`.

        If :math:`p = -2`, returns a basis of the lattice :math:`\mathbb{Z}^{m} \cap Im_{\mathbb{Q}} A`.

        :strong:`Caveat.` (:math:`p = -1` or :math:`-2`) For efficiency reason, we do not compute
        the HNF of the resulting basis.

        ::

        ? minors(x) = vector(#x[,1], i, matdet(x[^i,]));
        ? A = [3,1/7; 5,3/7; 7,5/7]; minors(A)
        %1 = [4/7, 8/7, 4/7] \\ determinants of all 2x2 minors
        ? B = matrixqz(A)
        %2 =
        [3 1]
        
        [5 2]
        
        [7 3]
        ? minors(%)
        %3 = [1, 2, 1] \\ B integral with coprime minors
        ? matrixqz(A,-1)
        %4 =
        [3 1]
        
        [5 3]
        
        [7 5]
        
        ? matrixqz(A,-2)
        %5 =
        [3 1]
        
        [5 2]
        
        [7 3]
        '''
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = matrixqz0(_A, _p)
        return new_gen(_ret)

    def matsize(x):
        r'''
        :math:`x` being a vector or matrix, returns a row vector
        with two components, the first being the number of rows (1 for a row vector),
        the second the number of columns (1 for a column vector).
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = matsize(_x)
        return new_gen(_ret)

    def matsnf(X, long flag=0):
        r'''
        If :math:`X` is a (singular or nonsingular) matrix outputs the vector of
        elementary divisors of :math:`X`, i.e. the diagonal of the
        Smith normal form of :math:`X`, normalized so that :math:`d_{n} \| d_{n-1} \|
        ... \| d_{1}`. :math:`X` must have integer or polynomial entries; in the latter
        case, :math:`X` must be a square matrix.

        The binary digits of :emphasis:`flag` mean:

        1 (complete output): if set, outputs :math:`[U,V,D]`, where :math:`U` and :math:`V` are two
        unimodular matrices such that :math:`UXV` is the diagonal matrix :math:`D`. Otherwise
        output only the diagonal of :math:`D`. If :math:`X` is not a square matrix, then :math:`D`
        will be a square diagonal matrix padded with zeros on the left or the top.

        4 (cleanup): if set, cleans up the output. This means that elementary
        divisors equal to :math:`1` will be deleted, i.e. outputs a shortened vector :math:`D'`
        instead of :math:`D`. If complete output was required, returns :math:`[U',V',D']` so
        that :math:`U'XV' = D'` holds. If this flag is set, :math:`X` is allowed to be of the
        form `vector of elementary divisors' or :math:`[U,V,D]` as would normally be
        output with the cleanup flag unset.

        If :math:`v` is an output from :literal:`matsnf` and :math:`p` is a power of an irreducible
        element, then :literal:`snfrank(v, p)` returns the :math:`p`-rank of the attached
        module.

        ::

        ? X = [27,0; 0,3; 1,1; 0,0]; matsnf(X)
        %1 = [0, 0, 3, 1]
        ? [U,V,D] = v = matsnf(X, 1); U*X*V == D
        %2
        ? U
        %3 =
        [0 0 0 1]
        
        [1 9 -27 0]
        
        [0 1 0 0]
        
        [0 0 1 0]
        
        ? V
        %4 =
        [-1 1]
        
        [ 1 0]
        
        ? snfrank(v, 3)
        %5 = 3

        Continuing the same example after cleanup:

        ::

        ? [U,V,D] = v = matsnf(X, 1+4); U*X*V == D
        %6 = 1
        
        ? D
        %7 =
        [0]
        
        [0]
        
        [3]
        
        ? snfrank(v, 3)
        %8 = 3
        
        ? snfrank(v, 2)
        %9 = 2
        '''
        sig_on()
        cdef GEN _X = (<Gen>X).g
        cdef GEN _ret = matsnf0(_X, flag)
        return new_gen(_ret)

    def matsolve(M, B):
        r'''
        Let :math:`M` be a left-invertible matrix and :math:`B` a column vector
        such that there exists a solution :math:`X` to the system of linear equations
        :math:`MX = B`; return the (unique) solution :math:`X`. This has the same effect as, but
        is faster, than :math:`M^{-1}*B`. Uses Dixon :math:`p`-adic lifting method if :math:`M` and
        :math:`B` are integral and Gaussian elimination otherwise. When there is no
        solution, the function returns an :math:`X` such that :math:`MX - B` is nonzero
        although it has at least :math:`\#M` zero entries:

        ::

        ? M = [1,2;3,4;5,6];
        ? B = [4,6,8]~; X = matsolve(M, B)
        %2 = [-2, 3]~
        ? M*X == B
        %3 = 1
        ? B = [1,2,4]~; X = matsolve(M, [1,2,4]~)
        %4 = [0, 1/2]~
        ? M*X - B
        %5 = [0, 0, -1]~

        Raises an exception if :math:`M` is not left-invertible, even if
        there is a solution:

        ::

        ? M = [1,1;1,1]; matsolve(M, [1,1]~)
        *** at top-level: matsolve(M,[1,1]~)
        *** ^------------------
        *** matsolve: impossible inverse in gauss: [1, 1; 1, 1].

        The function also works when :math:`B` is a matrix and we return
        the unique matrix solution :math:`X` provided it exists. Again, if there is no
        solution, the function returns an :math:`X` such that :math:`MX - B` is nonzero
        although it has at least :math:`\#M` zero rows.
        '''
        B = objtogen(B)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = gauss(_M, _B)
        return new_gen(_ret)

    def matsolvemod(M, D, B, long flag=0):
        r'''
        :math:`M` being any integral matrix,
        :math:`D` a column vector of nonnegative integer moduli, and :math:`B` an integral
        column vector, gives an integer solution to the system of congruences
        :math:`\sum_{i} m_{i,j}x_{j} = b_{i} (mod d_{i})` if one exists, otherwise
        returns the integer zero. Note that we explicitly allow :math:`d_{i} = 0`
        corresponding to an equality in :math:`\mathbb{Z}`. Shorthand notation: :math:`B` (resp. :math:`D`)
        can be given as a single integer, in which case all the :math:`b_{i}`
        (resp. :math:`d_{i}`) above are taken to be equal to :math:`B`
        (resp. :math:`D`). Again, :math:`D = 0` solves the linear system of equations over :math:`\mathbb{Z}`.

        ::

        ? M = [1,2;3,4];
        ? matsolvemod(M, [3,4]~, [1,2]~)
        %2 = [10, 0]~
        ? matsolvemod(M, 3, 1) \\ M X = [1,1]~ over F_3
        %3 = [2, 1]~
        ? matsolvemod(M, [3,0]~, [1,2]~) \\ x + 2y = 1 (mod 3), 3x + 4y = 2 (in Z)
        %4 = [6, -4]~
        ? matsolvemod(M, 0, [1,2]~) \\ no solution in Z for x + 2y = 1, 3x + 4y = 2

        If :math:`flag = 1`, all solutions are returned in the form of a two-component row
        vector :math:`[x,u]`, where :math:`x` is an integer solution to the system of
        congruences and :math:`u` is a matrix whose columns give a basis of the homogeneous
        system (so that all solutions can be obtained by adding :math:`x` to any linear
        combination of columns of :math:`u`). If no solution exists, returns zero.
        '''
        D = objtogen(D)
        B = objtogen(B)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _D = (<Gen>D).g
        cdef GEN _B = (<Gen>B).g
        cdef GEN _ret = matsolvemod(_M, _D, _B, flag)
        return new_gen(_ret)

    def matsupplement(x):
        r'''
        Assuming that the columns of the matrix :math:`x`
        are linearly independent (if they are not, an error message is issued), finds
        a square invertible matrix whose first columns are the columns of :math:`x`,
        i.e. supplement the columns of :math:`x` to a basis of the whole space.

        ::

        ? matsupplement([1;2])
        %1 =
        [1 0]
        
        [2 1]

        Raises an error if :math:`x` has 0 columns, since (due to a long standing design
        bug), the dimension of the ambient space (the number of rows) is unknown in
        this case:

        ::

        ? matsupplement(matrix(2,0))
        *** at top-level: matsupplement(matrix
        *** ^--------------------
        *** matsupplement: sorry, suppl [empty matrix] is not yet implemented.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = suppl(_x)
        return new_gen(_ret)

    def mattranspose(x):
        r'''
        Transpose of :math:`x` (also :math:`x~`).
        This has an effect only on vectors and matrices.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = gtrans(_x)
        return new_gen(_ret)

    def max(x, y):
        r'''
        Creates the maximum of :math:`x` and :math:`y` when they can be compared.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gmax(_x, _y)
        return new_gen(_ret)

    def mfEH(k):
        r'''
        :math:`k` being in :math:`1/2+\mathbb{Z}_{ >= 0}`, return the mf structure corresponding to
        the Cohen-Eisenstein series :math:`H_{k}` of weight :math:`k` on :math:`\Gamma_{0}(4)`.

        ::

        ? H = mfEH(13/2); mfcoefs(H,4)
        %1 = [691/32760, -1/252, 0, 0, -2017/252]

        The coefficients of :math:`H` are given by the Cohen-Hurwitz function
        :math:`H(k-1/2,N)` and can be obtained for moderately large values of :math:`N` (the
        algorithm uses :math:`~{O}(N)` time):

        ::

        ? mfcoef(H,10^5+1)
        time = 55 ms.
        %2 = -12514802881532791504208348
        ? mfcoef(H,10^7+1)
        time = 6,044 ms.
        %3 = -1251433416009877455212672599325104476
        '''
        sig_on()
        cdef GEN _k = (<Gen>k).g
        cdef GEN _ret = mfEH(_k)
        return new_gen(_ret)

    def mfTheta(psi):
        r'''
        The unary theta function corresponding to the primitive Dirichlet
        character :math:`\psi`. Its level is :math:`4 F(\psi)^{2}` and its weight is
        :math:`1 - \psi (-1)/2`.

        ::

        ? Ser(mfcoefs(mfTheta(),30))
        %1 = 1 + 2*x + 2*x^4 + 2*x^9 + 2*x^16 + 2*x^25 + O(x^31)
        
        ? f = mfTheta(8); Ser(mfcoefs(f,30))
        %2 = 2*x - 2*x^9 - 2*x^25 + O(x^31)
        ? mfparams(f)
        %3 = [256, 1/2, 8, y, t + 1]
        
        ? g = mfTheta(-8); Ser(mfcoefs(g,30))
        %4 = 2*x + 6*x^9 - 10*x^25 + O(x^31)
        ? mfparams(g)
        %5 = [256, 3/2, 8, y, t + 1]
        
        ? h = mfTheta(Mod(2,5)); mfparams(h)
        %6 = [100, 3/2, Mod(7, 20), y, t^2 + 1]
        '''
        sig_on()
        cdef GEN _psi = (<Gen>psi).g
        cdef GEN _ret = mfTheta(_psi)
        return new_gen(_ret)

    def mfatkin(mfatk, f):
        r'''
        Given a :literal:`mfatk` output by :literal:`mfatk = mfatkininit(mf,Q)` and
        a modular form :math:`f` belonging to the pace :literal:`mf`, returns the modular
        form :math:`g = C x f\|W_{Q}`, where :math:`C = mfatk[3]` is a normalizing
        constant such that :math:`g` has the same field of coefficients as :math:`f`;
        :literal:`mfatk[3]` gives the constant :math:`C`, and :literal:`mfatk[1]` gives
        the modular form space to which :math:`g` belongs (or is set to :math:`0` if
        it is :literal:`mf`).

        ::

        ? mf = mfinit([35,2],0); [f] = mfbasis(mf);
        ? mfcoefs(f, 4)
        %2 = [0, 3, -1, 0, 3]
        ? mfatk = mfatkininit(mf,7);
        ? g = mfatkin(mfatk, f); mfcoefs(g, 4)
        %4 = [0, 1, -1, -2, 7]
        ? mfatk = mfatkininit(mf,35);
        ? g = mfatkin(mfatk, f); mfcoefs(g, 4)
        %6 = [0, -3, 1, 0, -3]
        '''
        f = objtogen(f)
        sig_on()
        cdef GEN _mfatk = (<Gen>mfatk).g
        cdef GEN _f = (<Gen>f).g
        cdef GEN _ret = mfatkin(_mfatk, _f)
        return new_gen(_ret)

    def mfatkineigenvalues(mf, long Q, long precision=DEFAULT_BITPREC):
        r'''
        Given a modular form space :literal:`mf` of integral weight :math:`k` and a primitive
        divisor :math:`Q` of the level :math:`N` of :literal:`mf`, outputs the Atkin-Lehner
        eigenvalues of :math:`w_{Q}` on the new space, grouped by orbit. If the Nebentypus
        :math:`\chi` of :literal:`mf` is a
        (trivial or) quadratic character defined modulo :math:`N/Q`, the result is rounded
        and the eigenvalues are :math:`± i^{k}`.

        ::

        ? mf = mfinit([35,2],0); mffields(mf)
        %1 = [y, y^2 - y - 4] \\ two orbits, dimension 1 and 2
        ? mfatkineigenvalues(mf,5)
        %2 = [[1], [-1, -1]]
        ? mf = mfinit([12,7,Mod(3,4)],0);
        ? mfatkineigenvalues(mf,3)
        %4 = [[I, -I, -I, I, I, -I]] \\ one orbit

        To obtain the eigenvalues on a larger space than the new space,
        e.g., the full space, you can directly call :literal:`[mfB,M,C] = mfatkininit` and
        compute the eigenvalues as the roots of the characteristic polynomial of
        :math:`M/C`, by dividing the roots of :literal:`charpoly(M)` by :math:`C`. Note that the
        characteristic polynomial is computed exactly since :math:`M` has coefficients in
        :math:`\mathbb{Q} (\chi)`, whereas :math:`C` may be given by a complex number. If the coefficients
        of the characteristic polynomial are polmods modulo :math:`T` they must be embedded
        to :math:`\mathbb{C}` first using :literal:`subst(lift(), t, exp(2*I*Pi/n))`, when :math:`T` is
        :literal:`poliscyclo(n)`; note that :math:`T = mf.mod`.
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mfatkineigenvalues(_mf, Q, precision)
        return new_gen(_ret)

    def mfatkininit(mf, long Q, long precision=DEFAULT_BITPREC):
        r'''
        Given a modular form space with parameters :math:`N,k,\chi` and a
        primitive divisor :math:`Q` of the level :math:`N`, initializes data necessary for
        working with the Atkin-Lehner operator :math:`W_{Q}`, for now only the function
        :literal:`mfatkin`. We write :math:`\chi ~ \chi_{Q} \chi_{N/Q}` where
        the two characters are primitive with (coprime) conductors dividing
        :math:`Q` and :math:`N/Q` respectively. For :math:`F\in M_{k}(\Gamma_{0}(N),\chi)`,
        the form :math:`F \| W_{Q}` still has level :math:`N` and weight :math:`k` but its
        Nebentypus may no longer be :math:`\chi`: it becomes
        :math:`\overline{\chi_{Q}} \chi_{N/Q})`
        if :math:`k` is integral and :math:`\overline{\chi_{Q}} \chi_{N/Q})(4Q/.)` if not.

        The result is a technical 4-component vector :literal:`[mfB, MC, C, mf]`, where

        - :literal:`mfB` encodes the modular form space to which
        :math:`F\|W_{Q}` belongs when :math:`F \in M_{k}(\Gamma_{0}(N), \chi)`: an :literal:`mfinit`
        corresponding to a new Nebentypus or the integer :math:`0` when the character does
        not change. This does not depend on :math:`F`.

        - :literal:`MC` is the matrix of :math:`W_{Q}` on the bases of :literal:`mf` and :literal:`mfB`
        multiplied by a normalizing constant :math:`C(k,\chi,Q)`. This matrix has polmod
        coefficients in :math:`\mathbb{Q} (\chi)`.

        - :literal:`C` is the complex constant :math:`C(k,\chi,Q)`. For :math:`k`
        integral, let :math:`A(k,\chi, Q) = Q^{\varepsilon}/g(\chi_{Q})`, where
        :math:`\varepsilon = 0` for :math:`k` even and :math:`1/2` for :math:`k` odd and
        where :math:`g(\chi_{Q})` is the Gauss sum attached to :math:`\chi_{Q}`). (A similar, more
        complicated, definition holds in half-integral weight depending on the parity
        of :math:`k - 1/2`.) Then if :math:`M` denotes the matrix of :math:`W_{Q}` on the bases
        of :literal:`mf` and :literal:`mfB`, :math:`A.M` has coefficients in :math:`\mathbb{Q} (\chi)`.
        If :math:`A` is rational, we let :math:`C = 1` and :math:`C = A` as a floating point complex
        number otherwise, and finally :math:`MC := M.C`.

        ::

        ? mf=mfinit([32,4],0); [mfB,MC,C]=mfatkininit(mf,32); MC
        %1 =
        [5/16 11/2 55/8]
        
        [ 1/8 0 -5/4]
        
        [1/32 -1/4 11/16]
        
        ? C
        %2 = 1
        ? mf=mfinit([32,4,8],0); [mfB,MC,C]=mfatkininit(mf,32); MC
        %3 =
        [ 1/8 -7/4]
        
        [-1/16 -1/8]
        ? C
        %4 = 0.35355339059327376220042218105242451964
        ? algdep(C,2) \\ C = 1/sqrt(8)
        %5 = 8*x^2 - 1
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mfatkininit(_mf, Q, precision)
        return new_gen(_ret)

    def mfbasis(NK, long space=4):
        r'''
        If :math:`NK = [N,k,CHI]` as in :literal:`mfinit`, gives a basis of the
        corresponding subspace of :math:`M_{k}(\Gamma_{0}(N),\chi)`. :math:`NK` can also be the
        output of :literal:`mfinit`, in which case :literal:`space` can be omitted.
        To obtain the eigenforms, use :literal:`mfeigenbasis`.

        If :literal:`space` is a full space :math:`M_{k}`, the output is the union of first, a
        basis of the space of Eisenstein series, and second, a basis of the cuspidal
        space.

        ::

        ? see(L) = apply(f->mfcoefs(f,3), L);
        ? mf = mfinit([35,2],0);
        ? see( mfbasis(mf) )
        %2 = [[0, 3, -1, 0], [0, -1, 9, -8], [0, 0, -8, 10]]
        ? see( mfeigenbasis(mf) )
        %3 = [[0, 1, 0, 1], [Mod(0, z^2 - z - 4), Mod(1, z^2 - z - 4), \
        Mod(-z, z^2 - z - 4), Mod(z - 1, z^2 - z - 4)]]
        ? mf = mfinit([35,2]);
        ? see( mfbasis(mf) )
        %5 = [[1/6, 1, 3, 4], [1/4, 1, 3, 4], [17/12, 1, 3, 4], \
        [0, 3, -1, 0], [0, -1, 9, -8], [0, 0, -8, 10]]
        ? see( mfbasis([48,4],0) )
        %6 = [[0, 3, 0, -3], [0, -3, 0, 27], [0, 2, 0, 30]]
        '''
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _ret = mfbasis(_NK, space)
        return new_gen(_ret)

    def mfbd(F, long d):
        r'''
        :math:`F` being a generalized modular form, return :math:`B(d)(F)`, where :math:`B(d)` is
        the expanding operator :math:`\tau:---> d\tau`.

        ::

        ? D2=mfbd(mfDelta(),2); mfcoefs(D2, 6)
        %1 = [0, 0, 1, 0, -24, 0, 252]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfbd(_F, d)
        return new_gen(_ret)

    def mfbracket(F, G, long m=0):
        r'''
        Compute the :math:`m`-th Rankin-Cohen bracket of the generalized modular
        forms :math:`F` and :math:`G`.

        ::

        ? E4 = mfEk(4); E6 = mfEk(6);
        ? D1 = mfbracket(E4,E4,2); mfcoefs(D1,5)/4800
        %2 = [0, 1, -24, 252, -1472, 4830]
        ? D2 = mfbracket(E4,E6,1); mfcoefs(D2,10)/(-3456)
        %3 = [0, 1, -24, 252, -1472, 4830]
        '''
        G = objtogen(G)
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _G = (<Gen>G).g
        cdef GEN _ret = mfbracket(_F, _G, m)
        return new_gen(_ret)

    def mfcoef(F, long n):
        r'''
        Compute the :math:`n`-th Fourier coefficient :math:`a(n)` of the generalized modular
        form :math:`F`. Note that this is the :math:`n+1`-st component of the vector
        :literal:`mfcoefs(F,n)` as well as the second component of :literal:`mfcoefs(F,1,n)`.

        ::

        ? mfcoef(mfDelta(),10)
        %1 = -115920
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfcoef(_F, n)
        return new_gen(_ret)

    def mfcoefs(F, long n, long d=1):
        r'''
        Compute the vector of Fourier coefficients :math:`[a[0],a[d],...,a[nd]]` of the
        generalized modular form :math:`F`; :math:`d` must be positive and :math:`d = 1` by default.

        ::

        ? D = mfDelta();
        ? mfcoefs(D,10)
        %2 = [0, 1, -24, 252, -1472, 4830, -6048, -16744, 84480, -113643, -115920]
        ? mfcoefs(D,5,2)
        %3 = [0, -24, -1472, -6048, 84480, -115920]
        ? mfcoef(D,10)
        %4 = -115920

        This function also applies when :math:`F` is a modular form space as output by
        :literal:`mfinit`; it then returns the matrix whose columns give the Fourier
        expansions of the elements of :literal:`mfbasis`:math:`(F)`:

        ::

        ? mf = mfinit([1,12]);
        ? mfcoefs(mf,5)
        %2 =
        [691/65520 0]
        
        [ 1 1]
        
        [ 2049 -24]
        
        [ 177148 252]
        
        [ 4196353 -1472]
        
        [ 48828126 4830]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfcoefs(_F, n, d)
        return new_gen(_ret)

    def mfconductor(mf, F):
        r'''
        :literal:`mf` being output by :literal:`mfinit` for the cuspidal space and
        :math:`F` a modular form, gives the smallest level at which :math:`F` is defined.
        In particular, if :math:`F` is cuspidal and we write :math:`F = \sum_{j} B(d_{j}) f_{j}`
        for new forms :math:`f_{j}` of level :math:`N_{j}` (see :literal:`mftonew`), then its conductor
        is the least common multiple of the :math:`d_{j} N_{j}`.

        ::

        ? mf=mfinit([96,6],1); vF = mfbasis(mf); mfdim(mf)
        %1 = 72
        ? vector(10,i, mfconductor(mf, vF[i]))
        %2 = [3, 6, 12, 24, 48, 96, 4, 8, 12, 16]
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef long _ret = mfconductor(_mf, _F)
        clear_stack()
        return _ret

    def mfcosets(N):
        r'''
        Let :math:`N` be a positive integer. Return the list of right cosets of
        :math:`\Gamma_{0}(N) \\Gamma`, i.e., matrices :math:`\gamma_{j} \in \Gamma` such that
        :math:`\Gamma = \bigsqcup_{j} \Gamma_{0}(N) \gamma_{j}`.
        The :math:`\gamma_{j}` are chosen in the form :math:`[a,b;c,d]` with :math:`c \| N`.

        ::

        ? mfcosets(4)
        %1 = [[0, -1; 1, 0], [1, 0; 1, 1], [0, -1; 1, 2], [0, -1; 1, 3],\
        [1, 0; 2, 1], [1, 0; 4, 1]]

        We also allow the argument :math:`N` to be a modular form space,
        in which case it is replaced by the level of the space:

        ::

        ? M = mfinit([4, 12, 1], 0); mfcosets(M)
        %2 = [[0, -1; 1, 0], [1, 0; 1, 1], [0, -1; 1, 2], [0, -1; 1, 3],\
        [1, 0; 2, 1], [1, 0; 4, 1]]

        :strong:`Warning.` In the present implementation, the trivial coset is
        represented by :math:`[1,0;N,1]` and is the last in the list.
        '''
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _ret = mfcosets(_N)
        return new_gen(_ret)

    def mfcuspisregular(NK, cusp):
        r'''
        In the space defined by :literal:`NK = [N,k,CHI]` or :literal:`NK = mf`,
        determine if :literal:`cusp` in canonical format (oo or denominator
        dividing :math:`N`) is regular or not.

        ::

        ? mfcuspisregular([4,3,-4],1/2)
        %1 = 0
        '''
        cusp = objtogen(cusp)
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _cusp = (<Gen>cusp).g
        cdef long _ret = mfcuspisregular(_NK, _cusp)
        clear_stack()
        return _ret

    def mfcusps(N):
        r'''
        Let :math:`N` be a positive integer. Return the list of cusps of :math:`\Gamma_{0}(N)`
        in the form :math:`a/b` with :math:`b \| N`.

        ::

        ? mfcusps(24)
        %1 = [0, 1/2, 1/3, 1/4, 1/6, 1/8, 1/12, 1/24]

        We also allow the argument :math:`N` to be a modular form space,
        in which case it is replaced by the level of the space:

        ::

        ? M = mfinit([4, 12, 1], 0); mfcusps(M)
        %2 = [0, 1/2, 1/4]
        '''
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _ret = mfcusps(_N)
        return new_gen(_ret)

    def mfcuspval(mf, F, cusp, long precision=DEFAULT_BITPREC):
        r'''
        Valuation of modular form :math:`F` in the space :literal:`mf` at
        :literal:`cusp`, which can be either :math:`oo` or any rational number. The
        result is either a rational number or :math:`oo` if :math:`F` is zero. Let
        :math:`\chi` be the Nebentypus of the space :literal:`mf`; if :math:`\mathbb{Q} (F) ! = \mathbb{Q} (\chi)`,
        return the vector of valuations attached to the :math:`[\mathbb{Q} (F):\mathbb{Q} (chi)]` complex
        embeddings of :math:`F`.

        ::

        ? T=mfTheta(); mf=mfinit([12,1/2]); mfcusps(12)
        %1 = [0, 1/2, 1/3, 1/4, 1/6, 1/12]
        ? apply(x->mfcuspval(mf,T,x), %1)
        %2 = [0, 1/4, 0, 0, 1/4, 0]
        ? mf=mfinit([12,6,12],1); F=mfbasis(mf)[5];
        ? apply(x->mfcuspval(mf,F,x),%1)
        %4 = [1/12, 1/6, 1/2, 2/3, 1/2, 2]
        ? mf=mfinit([12,3,-4],1); F=mfbasis(mf)[1];
        ? apply(x->mfcuspval(mf,F,x),%1)
        %6 = [1/12, 1/6, 1/4, 2/3, 1/2, 1]
        
        ? mf = mfinit([625,2],0); [F] = mfeigenbasis(mf); mfparams(F)
        %7 = [625, 2, 1, y^2 - y - 1, t - 1] \\ [Q(F):Q(chi)] = 2
        ? mfcuspval(mf, F, 1/25)
        %8 = [1, 2] \\ one conjugate has valuation 1, and the other is 2
        ? mfcuspval(mf, F, 1/5)
        %9 = [1/25, 1/25]
        '''
        F = objtogen(F)
        cusp = objtogen(cusp)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _cusp = (<Gen>cusp).g
        cdef GEN _ret = mfcuspval(_mf, _F, _cusp, precision)
        return new_gen(_ret)

    def mfcuspwidth(N, cusp):
        r'''
        Width of :literal:`cusp` in :math:`\Gamma_{0}(N)`.

        ::

        ? mfcusps(12)
        %1 = [0, 1/2, 1/3, 1/4, 1/6, 1/12]
        ? [mfcuspwidth(12,c) | c <- mfcusps(12)]
        %2 = [12, 3, 4, 3, 1, 1]
        ? mfcuspwidth(12, oo)
        %3 = 1

        We also allow the argument :math:`N` to be a modular form space,
        in which case it is replaced by the level of the space:

        ::

        ? M = mfinit([4, 12, 1], 0); mfcuspwidth(M, 1/2)
        %4 = 1
        '''
        cusp = objtogen(cusp)
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _cusp = (<Gen>cusp).g
        cdef long _ret = mfcuspwidth(_N, _cusp)
        clear_stack()
        return _ret

    def mfderiv(F, long m=1):
        r'''
        :math:`m`-th formal derivative of the power series corresponding to
        the generalized modular form :math:`F`, with respect to the differential operator
        :math:`qd/dq` (default :math:`m = 1`).

        ::

        ? D=mfDelta();
        ? mfcoefs(D, 4)
        %2 = [0, 1, -24, 252, -1472]
        ? mfcoefs(mfderiv(D), 4)
        %3 = [0, 1, -48, 756, -5888]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfderiv(_F, m)
        return new_gen(_ret)

    def mfderivE2(F, long m=1):
        r'''
        Compute the Serre derivative :math:`(q d/dq)F - kE_{2}F/12`
        of the generalized modular form :math:`F`, which has weight :math:`k+2`;
        if :math:`F` is a true modular form, then its Serre derivative is also modular.
        If :math:`m > 1`, compute the :math:`m`-th iterate, of weight :math:`k + 2m`.

        ::

        ? mfcoefs(mfderivE2(mfEk(4)),5)*(-3)
        %1 = [1, -504, -16632, -122976, -532728]
        ? mfcoefs(mfEk(6),5)
        %2 = [1, -504, -16632, -122976, -532728]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfderivE2(_F, m)
        return new_gen(_ret)

    def mfdescribe(F, G=None):
        r'''
        Gives a human-readable description of :math:`F`, which is either a modular
        form space or a generalized modular form. If the address of :math:`G` is given,
        puts into :math:`G` the vector of parameters of the outermost operator defining :math:`F`;
        this vector is empty if :math:`F` is a leaf (an atomic object such as
        :literal:`mfDelta()`, not defined in terms of other forms) or a modular form space.

        ::

        ? E1 = mfeisenstein(4,-3,-4); mfdescribe(E1)
        %1 = "F_4(-3, -4)"
        ? E2 = mfeisenstein(3,5,-7); mfdescribe(E2)
        %2 = "F_3(5, -7)"
        ? E3 = mfderivE2(mfmul(E1,E2), 3); mfdescribe(E3,&G)
        %3 = "DERE2^3(MUL(F_4(-3, -4), F_3(5, -7)))"
        ? mfdescribe(G[1][1])
        %4 = "MUL(F_4(-3, -4), F_3(5, -7))"
        ? G[2]
        %5 = 3
        ? for (i = 0, 4, mf = mfinit([37,4],i); print(mfdescribe(mf)));
        S_4^new(G_0(37, 1))
        S_4(G_0(37, 1))
        S_4^old(G_0(37, 1))
        E_4(G_0(37, 1))
        M_4(G_0(37, 1))
        '''
        cdef bint _have_G = (G is not None)
        if _have_G:
            raise NotImplementedError("optional argument G not available")
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN * _G = NULL
        cdef GEN _ret = mfdescribe(_F, _G)
        return new_gen(_ret)

    def mfdim(NK, long space=4):
        r'''
        If :math:`NK = [N,k,CHI]` as in :literal:`mfinit`, gives the dimension of the
        corresponding subspace of :math:`M_{k}(\Gamma_{0}(N),\chi)`. :math:`NK` can also be the
        output of :literal:`mfinit`, in which case space must be omitted.

        The subspace is described by the small integer :literal:`space`: :math:`0` for the
        newspace :math:`S_{k}^{new}(\Gamma_{0}(N),\chi)`, :math:`1` for the cuspidal
        space :math:`S_{k}`, :math:`2` for the oldspace :math:`S_{k}^{old}`, :math:`3` for the space of
        Eisenstein series :math:`E_{k}` and :math:`4` for the full space :math:`M_{k}`.

        :strong:`Wildcards.`
        As in :literal:`mfinit`, :emphasis:`CHI` may be the wildcard 0
        (all Galois orbits of characters); in this case, the output is a vector of
        :math:`[order, conrey, dim, dimdih]` corresponding
        to the nontrivial spaces, where

        - :emphasis:`order` is the order of the character,

        - :emphasis:`conrey` its Conrey label from which the character may be recovered
        via :literal:`znchar`:math:`(conrey)`,

        - :emphasis:`dim` the dimension of the corresponding space,

        - :emphasis:`dimdih` the dimension of the subspace of dihedral forms
        corresponding to Hecke characters if :math:`k = 1` (this is not implemented for
        the old space and set to :math:`-1` for the time being) and 0 otherwise.

        The spaces are sorted by increasing order of the character; the characters are
        taken up to Galois conjugation and the Conrey number is the minimal one among
        Galois conjugates. In weight :math:`1`, this is only implemented when
        the space is 0 (newspace), 1 (cusp space), 2(old space) or 3(Eisenstein
        series).

        :strong:`Wildcards for sets of characters.` :emphasis:`CHI` may be a set
        of characters, and we return the set of :math:`[dim,dimdih]`.

        :strong:`Wildcard for :math:`M_{k}(\Gamma_{1}(N))`.`
        Additionally, the wildcard :math:`CHI = -1` is available in which case we
        output the total dimension of the corresponding
        subspace of :math:`M_{k}(\Gamma_{1}(N))`. In weight :math:`1`, this is not implemented
        when the space is 4 (fullspace).

        ::

        ? mfdim([23,2], 0) \\ new space
        %1 = 2
        ? mfdim([96,6], 0)
        %2 = 10
        ? mfdim([10^9,4], 3) \\ Eisenstein space
        %1 = 40000
        ? mfdim([10^9+7,4], 3)
        %2 = 2
        ? mfdim([68,1,-1],0)
        %3 = 3
        ? mfdim([68,1,0],0)
        %4 = [[2, Mod(67, 68), 1, 1], [4, Mod(47, 68), 1, 1]]
        ? mfdim([124,1,0],0)
        %5 = [[6, Mod(67, 124), 2, 0]]

        This last example shows that there exists a nondihedral form of weight 1
        in level 124.
        '''
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _ret = mfdim(_NK, space)
        return new_gen(_ret)

    def mfdiv(F, G):
        r'''
        Given two generalized modular forms :math:`F` and :math:`G`, compute :math:`F/G` assuming
        that the quotient will not have poles at infinity. If this is the
        case, use :literal:`mfshift` before doing the division.

        ::

        ? D = mfDelta(); \\ Delta
        ? H = mfpow(mfEk(4), 3);
        ? J = mfdiv(H, D)
        *** at top-level: J=mfdiv(H,mfdeltac
        *** ^--------------------
        *** mfdiv: domain error in mfdiv: ord(G) > ord(F)
        ? J = mfdiv(H, mfshift(D,1));
        ? mfcoefs(J, 4)
        %4 = [1, 744, 196884, 21493760, 864299970]
        '''
        G = objtogen(G)
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _G = (<Gen>G).g
        cdef GEN _ret = mfdiv(_F, _G)
        return new_gen(_ret)

    def mfeigenbasis(mf):
        r'''
        Vector of the eigenforms for the space :literal:`mf`.
        The initial basis of forms computed by :literal:`mfinit` before splitting
        is also available via :literal:`mfbasis`.

        ::

        ? mf = mfinit([26,2],0);
        ? see(L) = for(i=1,#L,print(mfcoefs(L[i],6)));
        ? see( mfeigenbasis(mf) )
        [0, 1, -1, 1, 1, -3, -1]
        [0, 1, 1, -3, 1, -1, -3]
        ? see( mfbasis(mf) )
        [0, 2, 0, -2, 2, -4, -4]
        [0, -2, -4, 10, -2, 0, 8]

        The eigenforms are internally expressed as (algebraic) linear combinations of
        :literal:`mfbasis(mf)` and it is very inefficient to compute many coefficients
        of those forms individually: you should rather use :literal:`mfcoefs(mf)`
        to expand the basis once and for all, then multiply by :literal:`mftobasis(mf,f)`
        for the forms you're interested in:

        ::

        ? mf = mfinit([96,6],0); B = mfeigenbasis(mf); #B
        %1 = 8;
        ? vector(#B, i, mfcoefs(B[i],1000)); \\ expanded individually: slow
        time = 7,881 ms.
        ? M = mfcoefs(mf, 1000); \\ initialize once
        time = 982 ms.
        ? vector(#B, i, M * mftobasis(mf,B[i])); \\ then expand: much faster
        time = 623 ms.

        When the eigenforms are defined over an extension field of :math:`\mathbb{Q} (\chi)` for a
        nonrational character, their coefficients are hard to read and you may want
        to lift them or to express them in an absolute number field. In the
        construction below :math:`T` defines :math:`\mathbb{Q} (f)` over :math:`\mathbb{Q}`, :math:`a` is the image of the
        generator :literal:`Mod`:math:`(t, t^{2}+t+1)` of :math:`\mathbb{Q} (\chi)` in :math:`\mathbb{Q} (f)`
        and :math:`y - ka` is the image of the root :math:`y` of :literal:`f.mod`:

        ::

        ? mf = mfinit([31, 2, Mod(25,31)], 0); [f] = mfeigenbasis(mf);
        ? f.mod
        %2 = Mod(1, t^2 + t + 1)*y^2 + Mod(2*t + 2, t^2 + t + 1)
        ? v = liftpol(mfcoefs(f,5))
        %3 = [0, 1, (-t - 1)*y - 1, t*y + (t + 1), (2*t + 2)*y + 1, t]
        ? [T,a,k] = rnfequation(mf.mod, f.mod, 1)
        %4 = [y^4 + 2*y^2 + 4, Mod(-1/2*y^2 - 1, y^4 + 2*y^2 + 4), 0]
        ? liftpol(substvec(v, [t,y], [a, y-k*a]))
        %5 = [0, 1, 1/2*y^3 - 1, -1/2*y^3 - 1/2*y^2 - y, -y^3 + 1, -1/2*y^2 - 1]

        Beware that the meaning of :math:`y` has changed in the last line
        is different: it now represents of root of :math:`T`, no longer of :literal:`f.mod`
        (the notions coincide if :math:`k = 0` as here but it will not always be the case).
        This can be avoided with an extra variable substitution, for instance

        ::

        ? [T,a,k] = rnfequation(mf.mod, subst(f.mod,'y,'x), 1)
        %6 = [x^4 + 2*x^2 + 4, Mod(-1/2*x^2 - 1, x^4 + 2*x^2 + 4), 0]
        ? liftpol(substvec(v, [t,y], [a, x-k*a]))
        %7 = [0, 1, 1/2*x^3 - 1, -1/2*x^3 - 1/2*x^2 - x, -x^3 + 1, -1/2*x^2 - 1]
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _ret = mfeigenbasis(_mf)
        return new_gen(_ret)

    def mfeigensearch(NK, AP=None):
        r'''
        Search for a normalized rational eigen cuspform with quadratic
        character given restrictions on a few initial coefficients. The meaning of
        the parameters is as follows:

        - :literal:`NK` governs the limits of the search: it is of the form
        :math:`[N,k]`: search for given level :math:`N`, weight :math:`k` and quadratic
        character; note that the character :math:`(D/.)` is uniquely determined by :math:`(N,k)`.
        The level :math:`N` can be replaced by a vector of allowed levels.

        - :literal:`AP` is the search criterion, which can be omitted: a list of
        pairs :math:`[..., [p,a_{p}],...]`, where :math:`p` is a prime number and :math:`a_{p}` is
        either a :literal:`t_INT` (the :math:`p`-th Fourier coefficient must match :math:`a_{p}` exactly)
        or a :literal:`t_INTMOD` :literal:`Mod`:math:`(a,b)` (the :math:`p`-th coefficient must be congruent
        to :math:`a` modulo :math:`b`).

        The result is a vector of newforms :math:`f` matching the search criteria, sorted
        by increasing level then increasing :math:`\|D\|`.

        ::

        ? #mfeigensearch([[1..80],2], [[2,2],[3,-1]])
        %1 = 1
        ? #mfeigensearch([[1..80],2], [[2,2],[5,2]])
        %2 = 1
        ? v = mfeigensearch([[1..20],2], [[3,Mod(2,3)],[7,Mod(5,7)]]); #v
        %3 = 1
        ? F=v[1]; [mfparams(F)[1], mfcoefs(F,15)]
        %4 = [11, [0, 1, -2, -1, 2, 1, 2, -2, 0, -2, -2, 1, -2, 4, 4, -1]]
        '''
        cdef bint _have_AP = (AP is not None)
        if _have_AP:
            AP = objtogen(AP)
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _AP = NULL
        if _have_AP:
            _AP = (<Gen>AP).g
        cdef GEN _ret = mfeigensearch(_NK, _AP)
        return new_gen(_ret)

    def mfembed(f, v=None, long precision=DEFAULT_BITPREC):
        r'''
        Let :math:`f` be a generalized modular form with parameters :math:`[N,k,\chi,P]` (see
        :literal:`mfparams`, we denote :math:`\mathbb{Q} (\chi)` the subfield of :math:`\mathbb{C}` generated by the
        values of :math:`\chi` and :math:`\mathbb{Q} (f)` the field of definition of :math:`f`. In this context
        :math:`\mathbb{Q} (\chi)` has a single canonical complex embeding given by
        :math:`s: Mod(t, polcyclo(n,t)) :--->\exp (2i\pi/n)` and the number field
        :math:`\mathbb{Q} (f)` has :math:`[\mathbb{Q} (f):\mathbb{Q} (\chi)]` induced embeddings attached to the complex
        roots of the polynomial :math:`s(P)`. If :math:`\mathbb{Q} (f)` is stricly larger than :math:`\mathbb{Q} (\chi)`
        we only allow an :math:`f` which is an eigenform, produced by :literal:`mfeigenbasis`.

        This function is meant to create embeddings of :math:`\mathbb{Q} (f)` and/or apply them
        to the object :math:`v`, typically a vector of Fourier coefficients of :math:`f`
        from :literal:`mfcoefs`.

        - If :math:`v` is omitted and :math:`f` is a modular form as above, we return the
        embedding of :math:`\mathbb{Q} (\chi)` if :math:`\mathbb{Q} (\chi) = \mathbb{Q} (f)` and a vector containing
        :math:`[\mathbb{Q} (f):\mathbb{Q} (\chi)]` embeddings of :math:`\mathbb{Q} (f)` otherwise.

        - If :math:`v` is given, it must be a scalar in :math:`\mathbb{Q} (f)`, or a vector/matrix of
        such, we apply the embeddings coefficientwise and return either
        a single result if :math:`\mathbb{Q} (f) = \mathbb{Q} (\chi)` and a vector of :math:`[\mathbb{Q} (f):\mathbb{Q} (\chi)]`
        results otherwise.

        - Finally :math:`f` can be replaced by a single embedding produced by
        :literal:`mfembed`:math:`(f)` (:math:`v` was omitted) and we apply that particular embedding
        to :math:`v`.

        ::

        ? mf = mfinit([35,2,Mod(11,35)], 0);
        ? [f] = mfbasis(mf);
        ? f.mod \\ Q (chi) = Q (zeta_{3})
        %3 = t^2 + t + 1
        ? v = mfcoefs(f,5); lift(v) \\ coefficients in Q (chi)
        %4 = [0, 2, -2*t - 2, 2*t, 2*t, -2*t - 2]
        ? mfembed(f, v) \\ single embedding
        %5 = [0, 2, -1 - 1.7320...*I, -1 + 1.73205...*I, -1 + 1.7320...*I, ...]
        
        ? [F] = mfeigenbasis(mf);
        ? mffields(mf)
        %7 = [y^2 + Mod(-2*t, t^2 + t + 1)] \\ [Q (f):Q (chi)] = 2
        ? V = liftpol( mfcoefs(F,5) );
        %8 = [0, 1, y + (-t - 1), (t + 1)*y + t, (-2*t - 2)*y + t, -t - 1]
        ? vall = mfembed(F, V); #vall
        %9 = 2 \\ 2 embeddings, both applied to V
        ? vall[1] \\ the first
        %10 = [0, 1, -1.2071... - 2.0907...*I, 0.2071... - 0.3587...*I, ...]
        ? vall[2] \\ and the second one
        %11 = [0, 1, 0.2071... + 0.3587...*I, -1.2071... + 2.0907...*I, ...]
        
        ? vE = mfembed(F); #vE \\ same 2 embeddings
        %12 = 2
        ? mfembed(vE[1], V) \\ apply first embedding to V
        %13 = [0, 1, -1.2071... - 2.0907...*I, 0.2071... - 0.3587...*I, ...]

        For convenience, we also allow a modular form space from :literal:`mfinit`
        instead of :math:`f`, corresponding to the single embedding of :math:`\mathbb{Q} (\chi)`.

        ::

        ? [mfB,MC,C] = mfatkininit(mf,7); MC \\ coefs in Q (chi)
        %13 =
        [ Mod(2/7*t, t^2 + t + 1) Mod(-1/7*t - 2/7, t^2 + t + 1)]
        
        [Mod(-1/7*t - 2/7, t^2 + t + 1) Mod(2/7*t, t^2 + t + 1)]
        
        ? C \\ normalizing constant
        %14 = 0.33863... - 0.16787*I
        ? M = mfembed(mf, MC) / C \\ the true matrix for the action of w_7
        [-0.6294... + 0.4186...*I -0.3625... - 0.5450...*I]
        
        [-0.3625... - 0.5450...*I -0.6294... + 0.4186...*I]
        
        ? exponent(M*conj(M) - 1) \\ M * conj(M) is close to 1
        %16 = -126
        '''
        cdef bint _have_v = (v is not None)
        if _have_v:
            v = objtogen(v)
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _v = NULL
        if _have_v:
            _v = (<Gen>v).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mfembed0(_f, _v, precision)
        return new_gen(_ret)

    def mfeval(mf, F, vtau, long precision=DEFAULT_BITPREC):
        r'''
        Computes the numerical value of the modular form :math:`F`, belonging
        to :emphasis:`mf`, at the complex number :literal:`vtau` or the vector :literal:`vtau`
        of complex numbers in the completed upper-half plane. The result is given
        with absolute error less than :math:`2^{-B}`, where :math:`B = realbitprecision`.

        If the field of definition :math:`\mathbb{Q} (F)` is larger than :math:`\mathbb{Q} (\chi)` then :math:`F` may be
        embedded into :math:`\mathbb{C}` in :math:`d = [\mathbb{Q} (F):\mathbb{Q} (\chi)]` ways, in which case a vector of
        the :math:`d` results is returned.

        ::

        ? mf = mfinit([11,2],0); F = mfbasis(mf)[1]; mfparams(F)
        %1 = [11, 2, 1, y, t-1] \\ Q(F) = Q(chi) = Q
        ? mfeval(mf,F,I/2)
        %2 = 0.039405471130100890402470386372028382117
        ? mf = mfinit([35,2],0); F = mfeigenbasis(mf)[2]; mfparams(F)
        %3 = [35, 2, 1, y^2 - y - 4, t - 1] \\ [Q(F) : Q(chi)] = 2
        ? mfeval(mf,F,I/2)
        %4 = [0.045..., 0.0385...] \\ sigma_1(F) and sigma_2(F) at I/2
        ? mf = mfinit([12,4],1); F = mfbasis(mf)[1];
        ? mfeval(mf, F, 0.318+10^(-7)*I)
        %6 = 3.379... E-21 + 6.531... E-21*I \\ instantaneous !

        In order to maximize the imaginary part of the argument,
        the function computes :math:`(f \| _{k} \gamma)(\gamma^{-1}.\tau)` for a
        suitable :math:`\gamma` not necessarily in :math:`\Gamma_{0}(N)` (in which case :math:`f \|
        \gamma` is evaluated using :literal:`mfslashexpansion`).

        ::

        ? T = mfTheta(); mf = mfinit(T); mfeval(mf,T,[0,1/2,1,oo])
        %1 = [1/2 - 1/2*I, 0, 1/2 - 1/2*I, 1]
        '''
        F = objtogen(F)
        vtau = objtogen(vtau)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _vtau = (<Gen>vtau).g
        cdef GEN _ret = mfeval(_mf, _F, _vtau, precision)
        return new_gen(_ret)

    def mffields(mf):
        r'''
        Given :literal:`mf` as output by :literal:`mfinit` with parameters
        :math:`(N,k,\chi)`, returns the vector of polynomials defining each Galois orbit of
        newforms over :math:`\mathbb{Q} (\chi)`.

        ::

        ? mf = mfinit([35,2],0); mffields(mf)
        %1 = [y, y^2 - y - 4]

        Here the character is trivial so :math:`\mathbb{Q} (\chi) = \mathbb{Q})` and there
        are 3 newforms: one is rational (corresponding to :math:`y`), the other two are
        conjugate and defined over the quadratic field :math:`\mathbb{Q}[y]/(y^{2}-y-4)`.

        ::

        ? [G,chi] = znchar(Mod(3,35));
        ? zncharconductor(G,chi)
        %2 = 35
        ? charorder(G,chi)
        %3 = 12
        ? mf = mfinit([35, 2, [G,chi]],0); mffields(mf)
        %4 = [y, y]

        Here the character is primitive of order 12 and the two newforms are
        defined over :math:`\mathbb{Q} (\chi) = \mathbb{Q} (\zeta_{12})`.

        ::

        ? mf = mfinit([35, 2, Mod(13,35)],0); mffields(mf)
        %3 = [y^2 + Mod(5*t, t^2 + 1)]

        This time the character has order 4 and there are two conjugate
        newforms over :math:`\mathbb{Q} (\chi) = Q(i)`.
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _ret = mffields(_mf)
        return new_gen(_ret)

    def mffromell(E):
        r'''
        :math:`E` being an elliptic curve defined over :math:`Q` given by an
        integral model in :literal:`ellinit` format, computes a 3-component vector
        :literal:`[mf,F,v]`, where :math:`F` is the newform corresponding to :math:`E` by
        modularity, :literal:`mf` is the newspace to which :math:`F` belongs, and
        :literal:`v` gives the coefficients of :math:`F` on :literal:`mfbasis(mf)`.

        ::

        ? E = ellinit("26a1");
        ? [mf,F,co] = mffromell(E);
        ? co
        %2 = [3/4, 1/4]~
        ? mfcoefs(F, 5)
        %3 = [0, 1, -1, 1, 1, -3]
        ? ellan(E, 5)
        %4 = [1, -1, 1, 1, -3]
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = mffromell(_E)
        return new_gen(_ret)

    def mffrometaquo(eta, long flag=0):
        r'''
        Modular form corresponding to the eta quotient matrix :literal:`eta`.
        If the valuation :math:`v` at infinity is fractional, returns :math:`0`. If the eta
        quotient is not holomorphic but simply meromorphic, returns :math:`0` if
        :math:`flag = 0`; returns the eta quotient (divided by :math:`q` to the power :math:`-v` if
        :math:`v < 0`, i.e., with valuation :math:`0`) if :math:`flag` is set.

        ::

        ? mffrometaquo(Mat([1,1]),1)
        %1 = 0
        ? mfcoefs(mffrometaquo(Mat([1,24])),6)
        %2 = [0, 1, -24, 252, -1472, 4830, -6048]
        ? mfcoefs(mffrometaquo([1,1;23,1]),10)
        %3 = [0, 1, -1, -1, 0, 0, 1, 0, 1, 0, 0]
        ? F = mffrometaquo([1,2;2,-1]); mfparams(F)
        %4 = [16, 1/2, 1, y, t - 1]
        ? mfcoefs(F,10)
        %5 = [1, -2, 0, 0, 2, 0, 0, 0, 0, -2, 0]
        ? mffrometaquo(Mat([1,-24]))
        %6 = 0
        ? f = mffrometaquo(Mat([1,-24]),1); mfcoefs(f,6)
        %7 = [1, 24, 324, 3200, 25650, 176256, 1073720]

        For convenience, a :literal:`t_VEC` is also accepted instead of
        a factorization matrix with a single row:

        ::

        ? f = mffrometaquo([1,24]); \\ also valid
        '''
        sig_on()
        cdef GEN _eta = (<Gen>eta).g
        cdef GEN _ret = mffrometaquo(_eta, flag)
        return new_gen(_ret)

    def mffromlfun(L, long precision=DEFAULT_BITPREC):
        r'''
        Let :math:`L` being an :math:`L`-function in any of the :literal:`lfun` formats representing
        a self-dual modular form (for instance an eigenform). Return
        :literal:`[NK,space,v]` when :literal:`mf = mfinit(NK,space)` is the modular
        form space containing the form and :literal:`mftobasis(mf, v)` will represent it
        on the space basis. If :math:`L` has rational coefficients, this will be enough
        to recognize the modular form in :emphasis:`mf`:

        ::

        ? L = lfuncreate(x^2+1);
        ? lfunan(L,10)
        %2 = [1, 1, 0, 1, 2, 0, 0, 1, 1, 2]
        ? [NK,space,v] = mffromlfun(L); NK
        %4 = [4, 1, -4]
        ? mf=mfinit(NK,space); w = mftobasis(mf,v)
        %5 = [1.0000000000000000000000000000000000000]~
        ? [f] = mfbasis(mf); mfcoefs(f,10) \\ includes a_0 !
        %6 = [1/4, 1, 1, 0, 1, 2, 0, 0, 1, 1, 2]

        If :math:`L` has inexact complex coefficients, one can for instance
        compute an eigenbasis for :emphasis:`mf` and check whether one of the attached
        :math:`L`-function is reasonably close to :math:`L`. In the example, we cheat by
        producing the :math:`L` function from an eigenform in a known space, but the
        function does not use this information:

        ::

        ? mf = mfinit([32,6,Mod(5,32)],0);
        ? [poldegree(K) | K<-mffields(mf)]
        %2 = [19] \\ one orbit, [Q(F) : Q(chi)] = 19
        ? L = lfunmf(mf)[1][1]; \\ one of the 19 L-functions attached to F
        ? lfunan(L,3)
        %4 = [1, 5.654... - 0.1812...*I, -7.876... - 19.02...*I]
        ? [NK,space,v] = mffromlfun(L); NK
        %5 = [32, 6, Mod(5, 32)]
        ? vL = concat(lfunmf(mf)); \\ L functions for all cuspidal eigenforms
        ? an = lfunan(L,10);
        ? for (i = 1, #vL, if (normlp(lfunan(vL[i],10) - an, oo) < 1e-10, print(i)));
        1
        '''
        sig_on()
        cdef GEN _L = (<Gen>L).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mffromlfun(_L, precision)
        return new_gen(_ret)

    def mffromqf(Q, P=None):
        r'''
        :math:`Q` being an even integral positive definite quadratic form
        and :math:`P` a homogeneous spherical polynomial for :math:`Q`, computes
        a 3-component vector :math:`[mf,F,v]`, where :math:`F` is the theta function
        corresponding to :math:`(Q,P)`, :emphasis:`mf` is the corresponding space of modular
        forms (from :literal:`mfinit`), and :math:`v` gives the coefficients of :math:`F` on
        :literal:`mfbasis(mf)`.

        ::

        ? [mf,F,v] = mffromqf(2*matid(10)); v
        %1 = [64/5, 4/5, 32/5]~
        ? mfcoefs(F, 5)
        %2 = [1, 20, 180, 960, 3380, 8424]
        ? mfcoef(F, 10000) \\ number of ways of writing 10000 as sum of 10 squares
        %3 = 128205250571893636
        ? mfcoefs(F, 10000); \\ fast !
        time = 220ms
        ? [mf,F,v] = mffromqf([2,0;0,2],x^4-6*x^2*y^2+y^4);
        ? mfcoefs(F,10)
        %6 = [0, 4, -16, 0, 64, -56, 0, 0, -256, 324, 224]
        ? mfcoef(F,100000) \\ instantaneous
        %7 = 41304367104

        Odd dimensions are supported, corresponding to forms of half-integral weight:

        ::

        ? [mf,F,v] = mffromqf(2*matid(3));
        ? mfisequal(F, mfpow(mfTheta(),3))
        %2 = 1
        ? mfcoefs(F, 32) \\ illustrate Legendre's 3-square theorem
        %3 = [ 1,
        6, 12, 8, 6, 24, 24, 0, 12,
        30, 24, 24, 8, 24, 48, 0, 6,
        48, 36, 24,24, 48, 24, 0, 24,
        30, 72, 32, 0, 72, 48, 0, 12]
        '''
        cdef bint _have_P = (P is not None)
        if _have_P:
            P = objtogen(P)
        sig_on()
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _P = NULL
        if _have_P:
            _P = (<Gen>P).g
        cdef GEN _ret = mffromqf(_Q, _P)
        return new_gen(_ret)

    def mfgaloisprojrep(mf, F, long precision=DEFAULT_BITPREC):
        r'''
        :emphasis:`mf` being an :literal:`mf` output by :literal:`mfinit` in weight :math:`1`,
        return a polynomial defining the field fixed by the kernel of the projective
        Artin representation attached to :emphasis:`F` (by Deligne-Serre).
        Currently only implemented for projective images :math:`A_{4}`, :math:`A_{5}` and :math:`S_{4}`.
        The type :math:`A_{5}` requires the :literal:`nflistdata` package to be installed.

        ::

        \\ A4 example
        ? mf = mfinit([4*31,1,Mod(87,124)],0);
        ? F = mfeigenbasis(mf)[1];
        ? mfgaloistype(mf,F)
        %3 = -12
        ? pol = mfgaloisprojrep(mf,F)
        %4 = x^12 + 68*x^10 + 4808*x^8 + ... + 4096
        ? G = galoisinit(pol); galoisidentify(G)
        %5 = [12,3] \\A4
        ? pol4 = polredbest(galoisfixedfield(G,G.gen[3], 1))
        %6 = x^4 + 7*x^2 - 2*x + 14
        ? polgalois(pol4)
        %7 = [12, 1, 1, "A4"]
        ? factor(nfdisc(pol4))
        %8 =
        [ 2 4]
        
        [31 2]
        
        \\ S4 example
        ? mf = mfinit([4*37,1,Mod(105,148)],0);
        ? F = mfeigenbasis(mf)[1];
        ? mfgaloistype(mf,F)
        %11 = -24
        ? pol = mfgaloisprojrep(mf,F)
        %12 = x^24 + 24*x^22 + 256*x^20 + ... + 255488256
        ? G = galoisinit(pol); galoisidentify(G)
        %13 = [24, 12] \\S4
        ? pol4 = polredbest(galoisfixedfield(G,G.gen[3..4], 1))
        %14 = x^4 - x^3 + 5*x^2 - 7*x + 12
        ? polgalois(pol4)
        %15 = [24, -1, 1, "S4"]
        ? factor(nfdisc(pol4))
        %16 =
        [ 2 2]
        
        [37 3]
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mfgaloisprojrep(_mf, _F, precision)
        return new_gen(_ret)

    def mfgaloistype(NK, F=None):
        r'''
        :literal:`NK` being either :literal:`[N,1,CHI]` or an :literal:`mf` output by
        :literal:`mfinit` in weight :math:`1`, gives the vector of types of Galois
        representations attached to each cuspidal eigenform,
        unless the modular form :literal:`F` is specified, in which case only for :literal:`F`
        (note that it is not tested whether :literal:`F` belongs to the correct modular
        form space, nor whether it is a cuspidal eigenform). Types :math:`A_{4}`, :math:`S_{4}`,
        :math:`A_{5}` are represented by minus their cardinality :math:`-12`, :math:`-24`, or :math:`-60`,
        and type :math:`D_{n}` is represented by its cardinality, the integer :math:`2n`:

        ::

        ? mfgaloistype([124,1, Mod(67,124)]) \\ A4
        %1 = [-12]
        ? mfgaloistype([148,1, Mod(105,148)]) \\ S4
        %2 = [-24]
        ? mfgaloistype([633,1, Mod(71,633)]) \\ D10, A5
        %3 = [10, -60]
        ? mfgaloistype([239,1, -239]) \\ D6, D10, D30
        %4 = [6, 10, 30]
        ? mfgaloistype([71,1, -71])
        %5 = [14]
        ? mf = mfinit([239,1, -239],0); F = mfeigenbasis(mf)[2];
        ? mfgaloistype(mf, F)
        %7 = 10

        The function may also return :math:`0` as a type when it failed to determine it; in
        this case the correct type is either :math:`-12` or :math:`-60`, and most likely :math:`-12`.
        '''
        cdef bint _have_F = (F is not None)
        if _have_F:
            F = objtogen(F)
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _F = NULL
        if _have_F:
            _F = (<Gen>F).g
        cdef GEN _ret = mfgaloistype(_NK, _F)
        return new_gen(_ret)

    def mfhecke(mf, F, long n):
        r'''
        :math:`F` being a modular form in modular form space :emphasis:`mf`, returns
        :math:`T(n)F`, where :math:`T(n)` is the :math:`n`-th Hecke operator.

        :strong:`Warning.` If :math:`F` is of level :math:`M < N`, then :math:`T(n)F`
        is in general not the same in :math:`M_{k}(\Gamma_{0}(M),\chi)` and in
        :math:`M_{k}(\Gamma_{0}(N),\chi)`. We take :math:`T(n)` at the same level as the one
        used in :literal:`mf`.

        ::

        ? mf = mfinit([26,2],0); F = mfbasis(mf)[1]; mftobasis(mf,F)
        %1 = [1, 0]~
        ? G2 = mfhecke(mf,F,2); mftobasis(mf,G2)
        %2 = [0, 1]~
        ? G5 = mfhecke(mf,F,5); mftobasis(mf,G5)
        %3 = [-2, 1]~

        Modular forms of half-integral weight are supported, in
        which case :math:`n` must be a perfect square, else :math:`T_{n}` will act as :math:`0` (the
        operator :math:`T_{p}` for :math:`p \| N` is not supported yet):

        ::

        ? F = mfpow(mfTheta(),3); mf = mfinit(F);
        ? mfisequal(mfhecke(mf,F,9), mflinear([F],[4]))
        %2 = 1

        (:math:`F` is an eigenvector of all :math:`T_{p^{2}}`, with eigenvalue :math:`p+1` for
        odd :math:`p`.)

        :strong:`Warning.` When :math:`n` is a large composite, resp. the square of a large
        composite in half-integral weight, it is in general more efficient to use
        :literal:`mfheckemat` on the :literal:`mftobasis` coefficients:

        ::

        ? mfcoefs(mfhecke(mf,F,3^10), 10)
        time = 917 ms.
        %3 = [324, 1944, 3888, 2592, 1944, 7776, 7776, 0, 3888, 9720, 7776]
        ? M = mfheckemat(mf,3^10) \\ instantaneous
        %4 =
        [324]
        ? G = mflinear(mf, M*mftobasis(mf,F));
        ? mfcoefs(G, 10) \\ instantaneous
        %6 = [324, 1944, 3888, 2592, 1944, 7776, 7776, 0, 3888, 9720, 7776]
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfhecke(_mf, _F, n)
        return new_gen(_ret)

    def mfheckemat(mf, vecn):
        r'''
        If :literal:`vecn` is an integer, matrix of the Hecke operator :math:`T(n)` on the
        basis formed by :literal:`mfbasis(mf)`. If it is a vector, vector of
        such matrices, usually faster than calling each one individually.

        ::

        ? mf=mfinit([32,4],0); mfheckemat(mf,3)
        %1 =
        [0 44 0]
        
        [1 0 -10]
        
        [0 -2 0]
        ? mfheckemat(mf,[5,7])
        %2 = [[0, 0, 220; 0, -10, 0; 1, 0, 12], [0, 88, 0; 2, 0, -20; 0, -4, 0]]
        '''
        vecn = objtogen(vecn)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _vecn = (<Gen>vecn).g
        cdef GEN _ret = mfheckemat(_mf, _vecn)
        return new_gen(_ret)

    def mfinit(NK, long space=4):
        r'''
        Create the space of modular forms corresponding to the data contained in
        :literal:`NK` and :literal:`space`. :literal:`NK` is a vector which can be
        either :math:`[N,k]` (:math:`N` level, :math:`k` weight) corresponding to a subspace of
        :math:`M_{k}(\Gamma_{0}(N))`, or :math:`[N,k,CHI]` (:emphasis:`CHI` a character)
        corresponding to a subspace of :math:`M_{k}(\Gamma_{0}(N),\chi)`. Alternatively,
        it can be a modular form :math:`F` or modular form space, in which case we use
        :literal:`mfparams` to define the space parameters.

        The subspace is described by the small integer :literal:`space`: :math:`0` for the
        newspace :math:`S_{k}^{new}(\Gamma_{0}(N),\chi)`, :math:`1` for the cuspidal
        space :math:`S_{k}`, :math:`2` for the oldspace :math:`S_{k}^{old}`, :math:`3` for the space of
        Eisenstein series :math:`E_{k}` and :math:`4` for the full space :math:`M_{k}`.

        :strong:`Wildcards.` For given level and weight, it is advantageous to
        compute simultaneously spaces attached to different Galois orbits
        of characters, especially in weight :math:`1`. The parameter :emphasis:`CHI` may be set
        to 0 (wildcard), in which case we return a vector of all :literal:`mfinit` (s) of
        non trivial spaces in :math:`S_{k}(\Gamma_{1}(N))`, one for each Galois orbit
        (see :literal:`znchargalois`). One may also set :emphasis:`CHI` to a vector of
        characters and we return a vector of all mfinits of subspaces of
        :math:`M_{k}(G_{0}(N),\chi)` for :math:`\chi` in the list, in the same order. In weight :math:`1`,
        only :math:`S_{1}^{new}`, :math:`S_{1}` and :math:`E_{1}` support wildcards.

        The output is a technical structure :math:`S`, or a vector of structures if
        :emphasis:`CHI` was a wildcard, which contains the following information:
        :math:`[N,k,\chi]` is given by :literal:`mfparams`:math:`(S)`, the space
        dimension is :literal:`mfdim`:math:`(S)` and a :math:`\mathbb{C}`-basis for the space is
        :literal:`mfbasis`:math:`(S)`. The structure is entirely algebraic and does not depend
        on the current :literal:`realbitprecision`.

        ::

        ? S = mfinit([36,2], 0); \\ new space
        ? mfdim(S)
        %2 = 1
        ? mfparams
        %3 = [36, 2, 1, y] \\ trivial character
        ? f = mfbasis(S)[1]; mfcoefs(f,10)
        %4 = [0, 1, 0, 0, 0, 0, 0, -4, 0, 0, 0]
        
        ? vS = mfinit([36,2,0],0); \\ with wildcard
        ? #vS
        %6 = 4 \\ 4 non trivial spaces (mod Galois action)
        ? apply(mfdim,vS)
        %7 = [1, 2, 1, 4]
        ? mfdim([36,2,0], 0)
        %8 = [[1, Mod(1, 36), 1, 0], [2, Mod(35, 36), 2, 0], [3, Mod(13, 36), 1, 0],
        [6, Mod(11, 36), 4, 0]]
        '''
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _ret = mfinit(_NK, space)
        return new_gen(_ret)

    def mfisCM(F):
        r'''
        Tests whether the eigenform :math:`F` is a CM form. The answer
        is :math:`0` if it is not, and if it is, either the unique negative discriminant
        of the CM field, or the pair of two negative discriminants of CM fields,
        this latter case occurring only in weight :math:`1` when the projective image is
        :math:`D_{2} = C_{2} x C_{2}`, i.e., coded :math:`4` by :literal:`mfgaloistype`.

        ::

        ? F = mffromell(ellinit([0,1]))[2]; mfisCM(F)
        %1 = -3
        ? mf = mfinit([39,1,-39],0); F=mfeigenbasis(mf)[1]; mfisCM(F)
        %2 = Vecsmall([-3, -39])
        ? mfgaloistype(mf)
        %3 = [4]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfisCM(_F)
        return new_gen(_ret)

    def mfisequal(F, G, long lim=0):
        r'''
        Checks whether the modular forms :math:`F` and :math:`G` are equal. If :literal:`lim`
        is nonzero, only check equality of the first :math:`lim+1` Fourier coefficients
        and the function then also applies to generalized modular forms.

        ::

        ? D = mfDelta(); F = mfderiv(D);
        ? G = mfmul(mfEk(2), D);
        ? mfisequal(F, G)
        %2 = 1
        '''
        G = objtogen(G)
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _G = (<Gen>G).g
        cdef long _ret = mfisequal(_F, _G, lim)
        clear_stack()
        return _ret

    def mfisetaquo(f, long flag=0):
        r'''
        If the generalized modular form :math:`f` is a holomorphic eta quotient,
        return the eta quotient matrix, else return 0. If :emphasis:`flag` is set, also accept
        meromorphic eta quotients: check whether :math:`f = q^{-v(g)} g(q)` for some
        eta quotient :math:`g`; if so, return the eta quotient matrix attached to :math:`g`,
        else return :math:`0`.
        See :literal:`mffrometaquo`.

        ::

        ? mfisetaquo(mfDelta())
        %1 =
        [1 24]
        ? f = mffrometaquo([1,1;23,1]);
        ? mfisetaquo(f)
        %3 =
        [ 1 1]
        
        [23 1]
        ? f = mffrometaquo([1,-24], 1);
        ? mfisetaquo(f) \\ nonholomorphic
        %5 = 0
        ? mfisetaquo(f,1)
        %6 =
        [1 -24]
        '''
        sig_on()
        cdef GEN _f = (<Gen>f).g
        cdef GEN _ret = mfisetaquo(_f, flag)
        return new_gen(_ret)

    def mfkohnenbasis(mf):
        r'''
        :literal:`mf` being a cuspidal space of half-integral weight :math:`k >= 3/2`
        with level :math:`N` and character :math:`\chi`, gives a
        basis :math:`B` of the Kohnen :math:`+`-space of :literal:`mf` as a matrix whose columns are
        the coefficients of :math:`B` on the basis of :literal:`mf`. The conductor of either
        :math:`\chi` or :math:`\chi.(-4/.)` must divide :math:`N/4`.

        ::

        ? mf = mfinit([36,5/2],1); K = mfkohnenbasis(mf); K~
        %1 =
        [-1 0 0 2 0 0]
        
        [ 0 0 0 0 1 0]
        ? (mfcoefs(mf,20) * K)~
        %4 =
        [0 -1 0 0 2 0 0 0 0 0 0 0 0 -6 0 0 8 0 0 0 0]
        
        [0 0 0 0 0 1 0 0 -2 0 0 0 0 0 0 0 0 1 0 0 2]
        
        ? mf = mfinit([40,3/2,8],1); mfkohnenbasis(mf)
        *** at top-level: mfkohnenbasis(mf)
        *** ^-----------------
        *** mfkohnenbasis: incorrect type in mfkohnenbasis [incorrect CHI] (t_VEC).

        In the final example both :math:`\chi = (8/.)` and :math:`\chi.(-4/.)`
        have conductor :math:`8`, which does not divide N/4 = 10.
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _ret = mfkohnenbasis(_mf)
        return new_gen(_ret)

    def mfkohnenbijection(mf):
        r'''
        Let :literal:`mf` be a cuspidal space of half-integral weight and weight :math:`4N`,
        with :math:`N` squarefree and let :math:`S_{k}^{+}(\Gamma_{0}(4N),\chi)` be the Kohnen
        :math:`+`-space. Returns :literal:`[mf2,M,K,shi]`, where

        - :literal:`mf2` gives the cuspidal space :math:`S_{2k-1}(\Gamma_{0}(N),\chi^{2})`;

        - :math:`M` is a matrix giving a Hecke-module isomorphism from that space to the
        Kohnen :math:`+`-space :math:`S_{k}^{+}(\Gamma_{0}(4N),\chi)`;

        - :literal:`K` represents a basis :math:`B` of the Kohnen :math:`+`-space as a matrix
        whose columns are the coefficients of :math:`B` on the basis of :literal:`mf`;

        - :literal:`shi` is a vector of pairs :math:`(t_{i},n_{i})` gives the linear
        combination of Shimura lifts giving :math:`M^{-1}`: :math:`t_{i}` is a squarefree positive
        integer and :math:`n_{i}` is a small nonzero integer.

        ::

        ? mf=mfinit([60,5/2],1); [mf2,M,K,shi]=mfkohnenbijection(mf); M
        %2 =
        [-3 0 5/2 7/2]
        
        [ 1 -1/2 -7 -7]
        
        [ 1 1/2 0 -3]
        
        [ 0 0 5/2 5/2]
        
        ? shi
        %2 = [[1, 1], [2, 1]]

        This last command shows that the map giving the bijection is the sum of the
        Shimura lift with :math:`t = 1` and the one with :math:`t = 2`.

        Since it gives a bijection of Hecke modules, this matrix can be used to
        transport modular form data from the easily computed space of level :math:`N`
        and weight :math:`2k-1` to the more difficult space of level :math:`4N` and weight
        :math:`k`: matrices of Hecke operators, new space, splitting into eigenspaces and
        eigenforms. Examples:

        ::

        ? K^(-1)*mfheckemat(mf,121)*K /* matrix of T_11^2 on K. Slowish. */
        time = 1,280 ms.
        %1 =
        [ 48 24 24 24]
        
        [ 0 32 0 -20]
        
        [-48 -72 -40 -72]
        
        [ 0 0 0 52]
        ? M*mfheckemat(mf2,11)*M^(-1) /* instantaneous via T_11 on S_{2k-1} */
        time = 0 ms.
        %2 =
        [ 48 24 24 24]
        
        [ 0 32 0 -20]
        
        [-48 -72 -40 -72]
        
        [ 0 0 0 52]
        ? mf20=mfinit(mf2,0); [mftobasis(mf2,b) | b<-mfbasis(mf20)]
        %3 = [[0, 0, 1, 0]~, [0, 0, 0, 1]~]
        ? F1=M*[0,0,1,0]~
        %4 = [1/2, 1/2, -3/2, -1/2]~
        ? F2=M*[0,0,0,1]~
        %5 = [3/2, 1/2, -9/2, -1/2]
        ? K*F1
        %6 = [1, 0, 0, 1, 1, 0, 0, 1, -3, 0, 0, -3, 0, 0]~
        ? K*F2
        %7 = [3, 0, 0, 3, 1, 0, 0, 1, -9, 0, 0, -3, 0, 0]~

        This gives a basis of the new space of :math:`S_{5/2}^{+}(\Gamma_{0}(60))` expressed
        on the initial basis of :math:`S_{5/2}(\Gamma_{0}(60))`. To obtain the eigenforms,
        we write instead:

        ::

        ? BE=mfeigenbasis(mf20);[E1,E2]=apply(x->K*M*mftobasis(mf2,x),BE)
        %1 = [[1, 0, 0, 1, 0, 0, 0, 0, -3, 0, 0, 0, 0, 0]~,\
        [0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, -3, 0, 0]~
        ? EI1 = mflinear(mf, E1); EI2=mflinear(mf, E2);

        These are the two eigenfunctions in the space :literal:`mf`, the first (resp.,
        second) will have Shimura image a multiple of :math:`BE[1]` (resp., :math:`BE[2]`).
        The function :literal:`mfkohneneigenbasis` does this directly.
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _ret = mfkohnenbijection(_mf)
        return new_gen(_ret)

    def mfkohneneigenbasis(mf, bij):
        r'''
        :literal:`mf` being a cuspidal space of half-integral weight :math:`k >= 3/2` and
        :literal:`bij` being the output of :literal:`mfkohnenbijection(mf)`, outputs a
        :math:`3`-component vector :literal:`[mf0,BNEW,BEIGEN]`, where :literal:`BNEW` and
        :literal:`BEIGEN` are two matrices whose columns are the coefficients
        of a basis of the Kohnen new space and of the eigenforms on the basis of
        :literal:`mf` respectively, and :literal:`mf0` is the corresponding new space of
        integral weight :math:`2k-1`.

        ::

        ? mf=mfinit([44,5/2],1);bij=mfkohnenbijection(mf);
        ? [mf0,BN,BE]=mfkohneneigenbasis(mf,bij);
        ? BN~
        %2 =
        [2 0 0 -2 2 0 -8]
        
        [2 0 0 4 14 0 -32]
        
        ? BE~
        %3 = [1 0 0 Mod(y-1, y^2-3) Mod(2*y+1, y^2-3) 0 Mod(-4*y-4, y^2-3)]
        ? lift(mfcoefs(mf,20)*BE[,1])
        %4 = [0, 1, 0, 0, y - 1, 2*y + 1, 0, 0, 0, -4*y - 4, 0, 0,\
        -5*y + 3, 0, 0, 0, -6, 0, 0, 0, 7*y + 9]~
        '''
        bij = objtogen(bij)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _bij = (<Gen>bij).g
        cdef GEN _ret = mfkohneneigenbasis(_mf, _bij)
        return new_gen(_ret)

    def mflinear(vF, v):
        r'''
        :literal:`vF` being a vector of generalized modular forms and :literal:`v`
        a vector of coefficients of same length, compute the linear
        combination of the entries of :literal:`vF` with coefficients :literal:`v`.
        :strong:`Note.` Use this in particular to subtract two forms :math:`F` and :math:`G`
        (with :math:`vF = [F,G]` and :math:`v = [1,-1]`), or to multiply an form by
        a scalar :math:`\lambda` (with :math:`vF = [F]` and :math:`v = [\lambda]`).

        ::

        ? D = mfDelta(); G = mflinear([D],[-3]);
        ? mfcoefs(G,4)
        %2 = [0, -3, 72, -756, 4416]

        For user convenience, we allow

        - a modular form space :literal:`mf` as a :literal:`vF` argument, which is
        understood as :literal:`mfbasis(mf)`;

        - in this case, we also allow a modular form :math:`f` as :math:`v`, which
        is understood as :literal:`mftobasis`:math:`(mf, f)`.

        ::

        ? T = mfpow(mfTheta(),7); F = mfShimura(T,-3); \\ Shimura lift for D=-3
        ? mfcoefs(F,8)
        %2 = [-5/9, 280, 9240, 68320, 295960, 875280, 2254560, 4706240, 9471000]
        ? mf = mfinit(F); G = mflinear(mf,F);
        ? mfcoefs(G,8)
        %4 = [-5/9, 280, 9240, 68320, 295960, 875280, 2254560, 4706240, 9471000]

        This last construction allows to replace a general modular
        form by a simpler linear combination of basis functions, which is often
        more efficient:

        ::

        ? T10=mfpow(mfTheta(),10); mfcoef(T10, 10^4) \\ direct evaluation
        time = 399 ms.
        %5 = 128205250571893636
        ? mf=mfinit(T10); F=mflinear(mf,T10); \\ instantaneous
        ? mfcoef(F, 10^4) \\ after linearization
        time = 67 ms.
        %7 = 128205250571893636
        '''
        v = objtogen(v)
        sig_on()
        cdef GEN _vF = (<Gen>vF).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _ret = mflinear(_vF, _v)
        return new_gen(_ret)

    def mfmanin(FS, long precision=DEFAULT_BITPREC):
        r'''
        Given the modular symbol :math:`FS` associated to an eigenform :math:`F` by
        :literal:`mfsymbol(mf,F)`, computes the even and odd special polynomials as well
        as the even and odd periods :math:`\omega^{+}` and :math:`\omega^{-}` as a vector
        :math:`[[P^{+},P^{-}],[\omega^{+},\omega^{-},r]]`, where
        :math:`r = \Im (\omega^{+}\overline{\omega^{-}})/ < F,F >`. If :math:`F` has several embeddings
        into :math:`\mathbb{C}`, give the vector of results corresponding to each embedding.

        ::

        ? D=mfDelta(); mf=mfinit(D); DS=mfsymbol(mf,D);
        ? [pols,oms]=mfmanin(DS); pols
        %2 = [[4*x^9 - 25*x^7 + 42*x^5 - 25*x^3 + 4*x],\
        [-36*x^10 + 691*x^8 - 2073*x^6 + 2073*x^4 - 691*x^2 + 36]]
        ? oms
        %3 = [0.018538552324740326472516069364750571812,\
        -0.00033105361053212432521308691198949874026*I, 4096/691]
        ? mf=mfinit([11,2],0); F=mfeigenbasis(mf)[1]; FS=mfsymbol(mf,F);
        ? [pols,oms]=mfmanin(FS);pols
        %5 = [[0, 0, 0, 1, 1, 0, 0, -1, -1, 0, 0, 0],\
        [2, 0, 10, 5, -5, -10, -10, -5, 5, 10, 0, -2]]
        ? oms[3]
        %6 = 24/5
        '''
        sig_on()
        cdef GEN _FS = (<Gen>FS).g
        cdef GEN _ret = mfmanin(_FS, precision)
        return new_gen(_ret)

    def mfmul(F, G):
        r'''
        Multiply the two generalized modular forms :math:`F` and :math:`G`.

        ::

        ? E4 = mfEk(4); G = mfmul(mfmul(E4,E4),E4);
        ? mfcoefs(G, 4)
        %2 = [1, 720, 179280, 16954560, 396974160]
        ? mfcoefs(mfpow(E4,3), 4)
        %3 = [1, 720, 179280, 16954560, 396974160]
        '''
        G = objtogen(G)
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _G = (<Gen>G).g
        cdef GEN _ret = mfmul(_F, _G)
        return new_gen(_ret)

    def mfnumcusps(N):
        r'''
        Number of cusps of :math:`\Gamma_{0}(N)`

        ::

        ? mfnumcusps(24)
        %1 = 8
        ? mfcusps(24)
        %1 = [0, 1/2, 1/3, 1/4, 1/6, 1/8, 1/12, 1/24]
        '''
        sig_on()
        cdef GEN _N = (<Gen>N).g
        cdef GEN _ret = mfnumcusps(_N)
        return new_gen(_ret)

    def mfparams(F):
        r'''
        If :math:`F` is a modular form space, returns :literal:`[N,k,CHI,space,:math:`\Phi`]`,
        level, weight, character :math:`\chi`, and space code; where :math:`\Phi` is the
        cyclotomic polynomial
        defining the field of values of :literal:`CHI`. If :math:`F` is a generalized modular
        form, returns :literal:`[N,k,CHI,P,:math:`\Phi`]`, where :math:`P` is the (polynomial giving
        the) field of definition of :math:`F` as a relative extension of the cyclotomic field
        :math:`\mathbb{Q} (\chi) = \mathbb{Q}[t]/(\Phi)`: in that case the level :math:`N` may be a multiple of the
        level of :math:`F` and the polynomial :math:`P` may define a larger field than :math:`\mathbb{Q} (F)`.
        If you want the true level of :math:`F` from this result, use
        :literal:`mfconductor(mfinit(F),F)`. The polynomial :math:`P` defines an extension of
        :math:`\mathbb{Q} (\chi) = \mathbb{Q}[t]/(\Phi (t))`; it has coefficients in that number field
        (polmods in :math:`t`).

        In contrast with :literal:`mfparams(F)[4]` which always gives the polynomial
        :math:`P` defining the relative extension :math:`\mathbb{Q} (F)/\mathbb{Q} (\chi)`, the member function
        :literal:`:math:`F`.mod` returns the polynomial used to define :math:`\mathbb{Q} (F)` over :math:`\mathbb{Q}`
        (either a cyclotomic polynomial or a polynomial with cyclotomic
        coefficients).

        ::

        ? E1 = mfeisenstein(4,-3,-4); E2 = mfeisenstein(3,5,-7); E3 = mfmul(E1,E2);
        ? apply(mfparams, [E1,E2,E3])
        %2 = [[12, 4, 12, y, t-1], [35, 3, -35, y, t-1], [420, 7, -420, y, t-1]]
        
        ? mf = mfinit([36,2,Mod(13,36)],0); [f] = mfeigenbasis(mf); mfparams(mf)
        %3 = [36, 2, Mod(13, 36), 0, t^2 + t + 1]
        ? mfparams(f)
        %4 = [36, 2, Mod(13, 36), y, t^2 + t + 1]
        ? f.mod
        %5 = t^2 + t + 1
        
        ? mf = mfinit([36,4,Mod(13,36)],0); [f] = mfeigenbasis(mf);
        ? lift(mfparams(f))
        %7 = [36, 4, 13, y^3 + (2*t-2)*y^2 + (-4*t+6)*y + (10*t-1), t^2+t+1]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfparams(_F)
        return new_gen(_ret)

    def mfperiodpol(mf, f, long flag=0, long precision=DEFAULT_BITPREC):
        r'''
        Period polynomial of the cuspidal part of the form :math:`f`, in other words
        :math:`\int_{0}^{i oo }(X-\tau)^{k-2}f(\tau)d\tau`. If :math:`flag = 0`,
        ordinary period polynomial. If it is :math:`1` or :math:`-1`, even or odd part of that
        polynomial. :math:`f` can also be the modular symbol output by :literal:`mfsymbol` (mf,f).

        ::

        ? D = mfDelta(); mf = mfinit(D,0);
        ? PP = mfperiodpol(mf, D, -1); PP/=polcoef(PP, 1); bestappr(PP)
        %1 = x^9 - 25/4*x^7 + 21/2*x^5 - 25/4*x^3 + x
        ? PM = mfperiodpol(mf, D, 1); PM/=polcoef(PM, 0); bestappr(PM)
        %2 = -x^10 + 691/36*x^8 - 691/12*x^6 + 691/12*x^4 - 691/36*x^2 + 1
        '''
        f = objtogen(f)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _f = (<Gen>f).g
        cdef GEN _ret = mfperiodpol(_mf, _f, flag, precision)
        return new_gen(_ret)

    def mfpetersson(fs, gs=None):
        r'''
        Petersson scalar product of the modular forms :math:`f` and :math:`g` belonging to
        the same modular form space :literal:`mf`, given by the corresponding
        "modular symbols" :literal:`fs` and :literal:`gs` output by :literal:`mfsymbol`
        (also in weight :math:`1` and half-integral weight, where symbols do not exist).
        If :literal:`gs` is omitted it is understood to be equal to :literal:`fs`.
        The scalar product is normalized by the factor :math:`1/[\Gamma:\Gamma_{0}(N)]`.
        Note that :math:`f` and :math:`g` can both be noncuspidal, in which case the program
        returns an error if the product is divergent.
        If the fields of definition :math:`\mathbb{Q} (f)` and :math:`\mathbb{Q} (g)` are equal to :math:`\mathbb{Q} (\chi)`
        the result is a scalar. If :math:`[\mathbb{Q} (f):\mathbb{Q} (\chi)] = d > 1` and
        :math:`[\mathbb{Q} (g):\mathbb{Q} (\chi)] = e > 1` the result is a :math:`d x e` matrix corresponding
        to all the embeddings of :math:`f` and :math:`g`. In the intermediate cases :math:`d = 1` or
        :math:`e = 1` the result is a row or column vector.

        ::

        ? D=mfDelta(); mf=mfinit(D); DS=mfsymbol(mf,D); mfpetersson(DS)
        %1 = 1.0353620568043209223478168122251645932 E-6
        ? mf=mfinit([11,6],0);B=mfeigenbasis(mf);BS=vector(#B,i,mfsymbol(mf,B[i]));
        ? mfpetersson(BS[1])
        %3 = 1.6190120685220988139111708455305245466 E-5
        ? mfpetersson(BS[1],BS[2])
        %4 = [-3.826479006582967148 E-42 - 2.801547395385577002 E-41*I,\
        1.6661127341163336125 E-41 + 1.1734725972345985061 E-41*I,\
        0.E-42 - 6.352626992842664490 E-41*I]~
        ? mfpetersson(BS[2])
        %5 =
        [ 2.7576133733... E-5 2.0... E-42 6.3... E-43 ]
        
        [ -4.1... E-42 6.77837030070... E-5 3.3...E-42 ]
        
        [ -6.32...E-43 3.6... E-42 2.27268958069... E-5]
        
        ? mf=mfinit([23,2],0); F=mfeigenbasis(mf)[1]; FS=mfsymbol(mf,F);
        ? mfpetersson(FS)
        %5 =
        [0.0039488965740025031688548076498662860143 -3.56 ... E-40]
        
        [ -3.5... E-40 0.0056442542987647835101583821368582485396]

        Noncuspidal example:

        ::

        ? E1=mfeisenstein(5,1,-3);E2=mfeisenstein(5,-3,1);
        ? mf=mfinit([12,5,-3]); cusps=mfcusps(12);
        ? apply(x->mfcuspval(mf,E1,x),cusps)
        %3 = [0, 0, 1, 0, 1, 1]
        ? apply(x->mfcuspval(mf,E2,x),cusps)
        %4 = [1/3, 1/3, 0, 1/3, 0, 0]
        ? E1S=mfsymbol(mf,E1);E2S=mfsymbol(mf,E2);
        ? mfpetersson(E1S,E2S)
        %6 = -1.884821671646... E-5 - 1.9... E-43*I

        Weight 1 and 1/2-integral weight example:

        ::

        ? mf=mfinit([23,1,-23],1);F=mfbasis(mf)[1];FS=mfsymbol(mf,F);
        ? mfpetersson(mf,FS)
        %2 = 0.035149946790370230814006345508484787443
        ? mf=mfinit([4,9/2],1);F=mfbasis(mf)[1];FS=mfsymbol(mf,F);
        ? mfpetersson(FS)
        %4 = 0.00015577084407139192774373662467908966030
        '''
        cdef bint _have_gs = (gs is not None)
        if _have_gs:
            gs = objtogen(gs)
        sig_on()
        cdef GEN _fs = (<Gen>fs).g
        cdef GEN _gs = NULL
        if _have_gs:
            _gs = (<Gen>gs).g
        cdef GEN _ret = mfpetersson(_fs, _gs)
        return new_gen(_ret)

    def mfpow(F, long n):
        r'''
        Compute :math:`F^{n}`, where :math:`n` is an integer and :math:`F` is a generalized modular
        form:

        ::

        ? G = mfpow(mfEk(4), 3); \\ E4^3
        ? mfcoefs(G, 4)
        %2 = [1, 720, 179280, 16954560, 396974160]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfpow(_F, n)
        return new_gen(_ret)

    def mfsearch(NK, V, long space=4):
        r'''
        :literal:`NK` being of the form :literal:`[N,k]` with :math:`k` possibly half-integral,
        search for a modular form with rational coefficients, of weight :math:`k` and
        level :math:`N`, whose initial coefficients :math:`a(0)`,... are equal to :math:`V`;
        :literal:`space` specifies the modular form spaces in which to search, in
        :literal:`mfinit` or :literal:`mfdim` notation. The output is a list of matching forms
        with that given level and weight. Note that the character is of the form
        :math:`(D/.)`, where :math:`D` is a (positive or negative) fundamental discriminant
        dividing :math:`N`. The forms are sorted by increasing :math:`\|D\|`.

        The parameter :math:`N` can be replaced by a vector of allowed levels, in which
        case the list of forms is sorted by increasing level, then increasing :math:`\|D\|`.
        If a form is found at level :math:`N`, any multiple of :math:`N` with the same :math:`D` is not
        considered. Some useful possibilities are

        - :literal:`[:math:`N_{1}`..:math:`N_{2}`]`: all levels between :math:`N_{1}` and :math:`N_{2}`,
        endpoints included;

        - :literal:`:math:`F` * [:math:`N_{1}`..:math:`N_{2}`]`: same but levels divisible by :math:`F`;

        - :literal:`divisors`:math:`(N_{0})`: all levels dividing :math:`N_{0}`.

        Note that this is different from :literal:`mfeigensearch`, which only searches
        for rational eigenforms.

        ::

        ? F = mfsearch([[1..40], 2], [0,1,2,3,4], 1); #F
        %1 = 3
        ? [ mfparams(f)[1..3] | f <- F ]
        %2 = [[38, 2, 1], [40, 2, 8], [40, 2, 40]]
        ? mfcoefs(F[1],10)
        %3 = [0, 1, 2, 3, 4, -5, -8, 1, -7, -5, 7]
        '''
        V = objtogen(V)
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _V = (<Gen>V).g
        cdef GEN _ret = mfsearch(_NK, _V, space)
        return new_gen(_ret)

    def mfshift(F, long s):
        r'''
        Divide the generalized modular form :math:`F` by :math:`q^{s}`, omitting the remainder
        if there is one. One can have :math:`s < 0`.

        ::

        ? D=mfDelta(); mfcoefs(mfshift(D,1), 4)
        %1 = [1, -24, 252, -1472, 4830]
        ? mfcoefs(mfshift(D,2), 4)
        %2 = [-24, 252, -1472, 4830, -6048]
        ? mfcoefs(mfshift(D,-1), 4)
        %3 = [0, 0, 1, -24, 252]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfshift(_F, s)
        return new_gen(_ret)

    def mfshimura(mf, F, long D=1):
        r'''
        :math:`F` being a modular form of half-integral weight :math:`k >= 3/2` and :math:`D` a
        positive squarefree integer, returns the Shimura lift :math:`G` of weight :math:`2k-1`
        corresponding to :math:`D`. This function returns :math:`[mf2,G,v]`
        where :emphasis:`mf2` is a modular form space containing :math:`G` and :math:`v` expresses :math:`G`
        in terms of :literal:`mfbasis`:math:`(mf2)`; so that :math:`G` is
        :literal:`mflinear`:math:`(mf2,v)`.

        ::

        ? F = mfpow(mfTheta(), 7); mf = mfinit(F);
        ? [mf2, G, v] = mfshimura(mf, F, 3); mfcoefs(G,5)
        %2 = [-5/9, 280, 9240, 68320, 295960, 875280]
        ? mfparams(G) \\ the level may be lower than expected
        %3 = [1, 6, 1, y, t - 1]
        ? mfparams(mf2)
        %4 = [2, 6, 1, 4, t - 1]
        ? v
        %5 = [280, 0]~
        ? mfcoefs(mf2, 5)
        %6 =
        [-1/504 -1/504]
        
        [ 1 0]
        
        [ 33 1]
        
        [ 244 0]
        
        [ 1057 33]
        
        [ 3126 0]
        ? mf = mfinit([60,5/2],1); F = mflinear(mf,mfkohnenbasis(mf)[,1]);
        ? mfparams(mfshimura(mf,F)[2])
        %8 = [15, 4, 1, y, t - 1]
        ? mfparams(mfshimura(mf,F,6)[2])
        %9 = [15, 4, 1, y, t - 1]
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mfshimura(_mf, _F, D)
        return new_gen(_ret)

    def mfslashexpansion(mf, f, g, long n, long flrat, params=None, long precision=DEFAULT_BITPREC):
        r'''
        Let :emphasis:`mf` be a modular form space in level :math:`N`, :math:`f` a modular form
        belonging to :emphasis:`mf` and let :math:`g` be in :math:`M_{2}^{+}(Q)`. This function
        computes the Fourier expansion of :math:`f\|_{k} g` to :math:`n` terms. We first describe
        the behaviour when :literal:`flrat` is 0: the result is a
        vector :math:`v` of floating point complex numbers such that

        .. MATH::

        f\|_{k} g(\tau) = q^{\alpha} \sum_{m >= 0} v[m+1] q^{m/w},

        where :math:`q = e(\tau)`, :math:`w` is the width of the cusp :math:`g(i oo )`
        (namely :math:`(N/(c^{2},N)` if :math:`g` is integral) and :math:`\alpha` is a rational number.
        If :literal:`params` is given, it is set to the parameters :math:`[\alpha,w,
        matid (2)]`.

        If :literal:`flrat` is 1, the program tries to rationalize the expression, i.e.,
        to express the coefficients as rational numbers or polmods. We
        write :math:`g = \lambda.M.A` where :math:`\lambda \in \mathbb{Q}^{*}`,
        :math:`M\in SL_{2}(\mathbb{Z})` and :math:`A = [a,b;0,d]` is upper triangular,
        integral and primitive with :math:`a > 0`, :math:`d > 0` and :math:`0 <= b < d`. Let
        :math:`\alpha` and :math:`w` by the parameters attached to the expansion of
        :math:`F := f \|_{k} M` as above, i.e.

        .. MATH::

        F(\tau) = q^{\alpha} \sum_{m >= 0} v[m+1] q^{m/w}.

        The function returns the expansion :math:`v` of :math:`F = f \|_{k} M` and sets
        the parameters to :math:`[\alpha, w, A]`. Finally, the desired expansion is
        :math:`(a/d)^{k/2} F(\tau + b/d)`. The latter is identical to the returned
        expansion when :math:`A` is the identity, i.e. when :math:`g\in PSL_{2}(\mathbb{Z})`.
        If this is not the case, the expansion differs from :math:`v` by the multiplicative
        constant :math:`(a/d)^{k/2} e(\alpha b/(dw))` and a twist by a root of unity
        :math:`q^{1/w} \to e(b/(dw)) q^{1/w}`. The complications introduced by this extra
        matrix :math:`A` allow to recognize the coefficients in a much smaller cyclotomic
        field, hence to obtain a simpler description overall. (Note that this
        rationalization step may result in an error if the program cannot perform it.)

        ::

        ? mf = mfinit([32,4],0); f = mfbasis(mf)[1];
        ? mfcoefs(f, 10)
        %2 = [0, 3, 0, 0, 0, 2, 0, 0, 0, 47, 0]
        ? mfatk = mfatkininit(mf,32); mfcoefs(mfatkin(mfatk,f),10) / mfatk[3]
        %3 = [0, 1, 0, 16, 0, 22, 0, 32, 0, -27, 0]
        ? mfatk[3] \\ here normalizing constant C = 1, but need in general
        %4 = 1
        ? mfslashexpansion(mf,f,[0,-1;1,0],10,1,&params) * 32^(4/2)
        %5 = [0, 1, 0, 16, 0, 22, 0, 32, 0, -27, 0]
        ? params
        %6 = [0, 32, [1, 0; 0, 1]]
        
        ? mf = mfinit([12,8],0); f = mfbasis(mf)[1];
        ? mfslashexpansion(mf,f,[1,0;2,1],7,0)
        %7 = [0, 0, 0, 0.6666666... + 0.E-38*I, 0, -3.999999... + 6.92820...*I, 0,\
        -11.99999999... - 20.78460969...*I]
        ? mfslashexpansion(mf,f,[1,0;2,1],7,1, &params)
        %8 = [0, 0, 0, 2/3, 0, Mod(8*t, t^2+t+1), 0, Mod(-24*t-24, t^2+t+1)]
        ? params
        %9 = [0, 3, [1, 0; 0, 1]]

        If :math:`[\mathbb{Q} (f):\mathbb{Q} (\chi)] > 1`, the coefficients may be polynomials in :math:`y`,
        where :math:`y` is any root of the polynomial giving the field of definition of
        :math:`f` (:literal:`f.mod` or :literal:`mfparams(f)[4]`).

        ::

        ? mf=mfinit([23,2],0);f=mfeigenbasis(mf)[1];
        ? mfcoefs(f,5)
        %1 = [Mod(0, y^2 - y - 1), Mod(1, y^2 - y - 1), Mod(-y, y^2 - y - 1),\
        Mod(2*y - 1, y^2 - y - 1), Mod(y - 1, y^2 - y - 1), Mod(-2*y, y^2 - y - 1)]
        ? mfslashexpansion(mf,f,[1,0;0,1],5,1)
        %2 = [0, 1, -y, 2*y - 1, y - 1, -2*y]
        ? mfslashexpansion(mf,f,[0,-1;1,0],5,1)
        %3 = [0, -1/23, 1/23*y, -2/23*y + 1/23, -1/23*y + 1/23, 2/23*y]

        :strong:`Caveat.` In half-integral weight, we :emphasis:`define` the "slash"
        operation as

        .. MATH::

        (f \|_{k} g)(\tau) := ((c \tau + d)^{-1/2})^{2k} f( g.\tau),

        with the principal determination of the square root. In particular,
        the standard cocycle condition is no longer satisfied and we only
        have :math:`f \| (gg') = ± (f \| g) \| g'`.
        '''
        f = objtogen(f)
        g = objtogen(g)
        cdef bint _have_params = (params is not None)
        if _have_params:
            raise NotImplementedError("optional argument params not available")
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _f = (<Gen>f).g
        cdef GEN _g = (<Gen>g).g
        cdef GEN * _params = NULL
        precision = nbits2prec(precision)
        cdef GEN _ret = mfslashexpansion(_mf, _f, _g, n, flrat, _params, precision)
        return new_gen(_ret)

    def mfspace(mf, f=None):
        r'''
        Identify the modular space :emphasis:`mf`, resp. the modular form :math:`f` in
        :emphasis:`mf` if present, as the flag given to :literal:`mfinit`.
        Returns 0 (newspace), 1 (cuspidal space), 2 (old space),
        3 (Eisenstein space) or 4 (full space).

        ::

        ? mf = mfinit([1,12],1); mfspace(mf)
        %1 = 1
        ? mfspace(mf, mfDelta())
        %2 = 0 \\ new space

        This function returns :math:`-1` when the form :math:`f` is modular
        but does not belong to the space.

        ::

        ? mf = mfinit([1,2]; mfspace(mf, mfEk(2))
        %3 = -1

        When :math:`f` is not modular and is for instance only quasi-modular, the
        function returns nonsense:

        ::

        ? M6 = mfinit([1,6]);
        ? dE4 = mfderiv(mfEk(4)); \\ not modular !
        ? mfspace(M6,dE4) \\ asserts (wrongly) that E4' belongs to new space
        %3 = 0
        '''
        cdef bint _have_f = (f is not None)
        if _have_f:
            f = objtogen(f)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _f = NULL
        if _have_f:
            _f = (<Gen>f).g
        cdef long _ret = mfspace(_mf, _f)
        clear_stack()
        return _ret

    def mfsplit(mf, long dimlim=0, long flag=0):
        r'''
        :literal:`mf` from :literal:`mfinit` with integral weight containing the new space
        (either the new space itself or the cuspidal space or the full space), and
        preferably the newspace itself for efficiency, split the space into Galois
        orbits of eigenforms of the newspace, satisfying various restrictions.

        The functions returns :math:`[vF, vK]`, where :math:`vF` gives (Galois orbit of)
        eigenforms and :math:`vK` is a list of polynomials defining each Galois orbit.
        The eigenforms are given in :literal:`mftobasis` format, i.e. as a matrix
        whose columns give the forms with respect to :literal:`mfbasis(mf)`.

        If :literal:`dimlim` is set, only the Galois orbits of dimension :math:`<= dimlim`
        are computed (i.e. the rational eigenforms if :math:`dimlim = 1` and the
        character is real). This can considerably speed up the function when a Galois
        orbit is defined over a large field.

        :math:`flag` speeds up computations when the dimension is large: if :math:`flag = d > 0`,
        when the dimension of the eigenspace is :math:`> d`, only the Galois polynomial is
        computed.

        Note that the function :literal:`mfeigenbasis` returns all eigenforms in an
        easier to use format (as modular forms which can be input as is in other
        functions); :literal:`mfsplit` is only useful when you can restrict
        to orbits of small dimensions, e.g. rational eigenforms.

        ::

        ? mf=mfinit([11,2],0); f=mfeigenbasis(mf)[1]; mfcoefs(f,16)
        %1 = [0, 1, -2, -1, ...]
        ? mf=mfinit([23,2],0); f=mfeigenbasis(mf)[1]; mfcoefs(f,16)
        %2 = [Mod(0, z^2 - z - 1), Mod(1, z^2 - z - 1), Mod(-z, z^2 - z - 1), ...]
        ? mf=mfinit([179,2],0); apply(poldegree, mffields(mf))
        %3 = [1, 3, 11]
        ? mf=mfinit([719,2],0);
        ? [vF,vK] = mfsplit(mf, 5); \\ fast when restricting to small orbits
        time = 192 ms.
        ? #vF \\ a single orbit
        %5 = 1
        ? poldegree(vK[1]) \\ of dimension 5
        %6 = 5
        ? [vF,vK] = mfsplit(mf); \\ general case is slow
        time = 2,104 ms.
        ? apply(poldegree,vK)
        %8 = [5, 10, 45] \\ because degree 45 is large...
        '''
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _ret = mfsplit(_mf, dimlim, flag)
        return new_gen(_ret)

    def mfsturm(NK):
        r'''
        Gives the Sturm bound for modular forms on :math:`\Gamma_{0}(N)` and
        weight :math:`k`, i.e., an upper bound for the order of the zero at infinity of
        a nonzero form. :literal:`NK` is either

        - a pair :math:`[N,k]`, in which case the bound is the floor of :math:`(kN/12).\prod_{p \| N} (1+1/p)`;

        - or the output of :literal:`mfinit` in which case the exact upper bound is returned.

        ::

        ? NK = [96,6]; mfsturm(NK)
        %1 = 97
        ? mf=mfinit(NK,1); mfsturm(mf)
        %2 = 76
        ? mfdim(NK,0) \\ new space
        %3 = 72
        '''
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef long _ret = mfsturm(_NK)
        clear_stack()
        return _ret

    def mfsymbol(mf, f=None, long precision=DEFAULT_BITPREC):
        r'''
        Initialize data for working with all period polynomials of the modular
        form :math:`f`: this is essential for efficiency for functions such as
        :literal:`mfsymboleval`, :literal:`mfmanin`, and :literal:`mfpetersson`. An :literal:`mfsymbol`
        contains an :literal:`mf` structure and can always be used whenever an :literal:`mf`
        would be needed.

        ::

        ? mf=mfinit([23,2],0);F=mfeigenbasis(mf)[1];
        ? FS=mfsymbol(mf,F);
        ? mfsymboleval(FS,[0,oo])
        %3 = [8.762565143790690142 E-39 + 0.0877907874...*I,
        -5.617375463602574564 E-39 + 0.0716801031...*I]
        ? mfpetersson(FS)
        %4 =
        [0.0039488965740025031688548076498662860143 1.2789721111175127425 E-40]
        
        [1.2630501762985554269 E-40 0.0056442542987647835101583821368582485396]

        By abuse of language, initialize data for working with :literal:`mfpetersson` in
        weight :math:`1` and half-integral weight (where no symbol exist); the :literal:`mf`
        argument may be an :literal:`mfsymbol` attached to a form on the space,
        which avoids recomputing data independent of the form.

        ::

        ? mf=mfinit([12,9/2],1); F=mfbasis(mf);
        ? fs=mfsymbol(mf,F[1]);
        time = 476 ms
        ? mfpetersson(fs)
        %2 = 1.9722437519492014682047692073275406145 E-5
        ? f2s = mfsymbol(mf,F[2]);
        time = 484 ms.
        ? mfpetersson(f2s)
        %4 = 1.2142222531326333658647877864573002476 E-5
        ? gs = mfsymbol(fs,F[2]); \\ re-use existing symbol, a little faster
        time = 430 ms.
        ? mfpetersson(gs) == %4 \\ same value
        %6 = 1

        For simplicity, we also allow :literal:`mfsymbol(f)` instead of
        :literal:`mfsymbol(mfinit(f), f)`:
        '''
        cdef bint _have_f = (f is not None)
        if _have_f:
            f = objtogen(f)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _f = NULL
        if _have_f:
            _f = (<Gen>f).g
        cdef GEN _ret = mfsymbol(_mf, _f, precision)
        return new_gen(_ret)

    def mfsymboleval(fs, path, ga=None, long precision=DEFAULT_BITPREC):
        r'''
        Evaluation of the modular symbol :math:`fs` (corresponding to the modular
        form :math:`f`) output by :literal:`mfsymbol` on the given path :literal:`path`, where
        :literal:`path` is either a vector :math:`[s_{1},s_{2}]` or an integral matrix :math:`[a,b;c,d]`
        representing the path :math:`[a/c,b/d]`. In both cases :math:`s_{1}` or :math:`s_{2}`
        (or :math:`a/c` or :math:`b/d`) can also be elements of the upper half-plane.
        To avoid possibly lengthy :literal:`mfsymbol` computations, the program also
        accepts :math:`fs` of the form :literal:`[mf,F]`, but in that case :math:`s_{1}` and :math:`s_{2}`
        are limited to :literal:`oo` and elements of the upper half-plane.
        The result is the polynomial equal to
        :math:`\int_{s_{1}}^{s_{2}}(X-\tau)^{k-2}F(\tau)d\tau`, the integral being
        computed along a geodesic joining :math:`s_{1}` and :math:`s_{2}`. If :literal:`ga` in
        :math:`GL_{2}^{+}(\mathbb{Q})`
        is given, replace :math:`F` by :math:`F\|_{k}\gamma`. Note that if the integral diverges,
        the result will be a rational function.
        If the field of definition :math:`\mathbb{Q} (f)` is larger than :math:`\mathbb{Q} (\chi)` then :math:`f` can be
        embedded into :math:`\mathbb{C}` in :math:`d = [\mathbb{Q} (f):\mathbb{Q} (\chi)]` ways, in which case a vector of
        the :math:`d` results is returned.

        ::

        ? mf=mfinit([35,2],1);f=mfbasis(mf)[1];fs=mfsymbol(mf,f);
        ? mfsymboleval(fs,[0,oo])
        %1 = 0.31404011074188471664161704390256378537*I
        ? mfsymboleval(fs,[1,3;2,5])
        %2 = -0.1429696291... - 0.2619975641...*I
        ? mfsymboleval(fs,[I,2*I])
        %3 = 0.00088969563028739893631700037491116258378*I
        ? E2=mfEk(2);E22=mflinear([E2,mfbd(E2,2)],[1,-2]);mf=mfinit(E22);
        ? E2S = mfsymbol(mf,E22);
        ? mfsymboleval(E2S,[0,1])
        %6 = (-1.00000...*x^2 + 1.00000...*x - 0.50000...)/(x^2 - x)

        The rational function which is given in case the integral diverges is
        easy to interpret. For instance:

        ::

        ? E4=mfEk(4);mf=mfinit(E4);ES=mfsymbol(mf,E4);
        ? mfsymboleval(ES,[I,oo])
        %2 = 1/3*x^3 - 0.928067...*I*x^2 - 0.833333...*x + 0.234978...*I
        ? mfsymboleval(ES,[0,I])
        %3 = (-0.234978...*I*x^3 - 0.833333...*x^2 + 0.928067...*I*x + 0.333333...)/x

        :literal:`mfsymboleval(ES,[a,oo])` is the limit as :math:`T\to oo` of

        .. MATH::

        \int_{a}^{iT}(X-\tau)^{k-2}F(\tau)d\tau + a(0)(X-iT)^{k-1}/(k-1) ,

        where :math:`a(0)` is the :math:`0`th coefficient of :math:`F` at infinity. Similarly,
        :literal:`mfsymboleval(ES,[0,a])` is the limit as :math:`T\to oo` of

        .. MATH::

        \int_{i/T}^{a}(X-\tau)^{k-2}F(\tau)d\tau+b(0)(1+iTX)^{k-1}/(k-1) ,

        where :math:`b(0)` is the :math:`0`th coefficient of :math:`F\|_{k} S` at infinity.
        '''
        path = objtogen(path)
        cdef bint _have_ga = (ga is not None)
        if _have_ga:
            ga = objtogen(ga)
        sig_on()
        cdef GEN _fs = (<Gen>fs).g
        cdef GEN _path = (<Gen>path).g
        cdef GEN _ga = NULL
        if _have_ga:
            _ga = (<Gen>ga).g
        cdef GEN _ret = mfsymboleval(_fs, _path, _ga, precision)
        return new_gen(_ret)

    def mftaylor(F, long n, long flreal=0, long precision=DEFAULT_BITPREC):
        r'''
        :math:`F` being a form in :math:`M_{k}(SL_{2}(\mathbb{Z}))`, computes the first :math:`n+1`
        canonical Taylor expansion of :math:`F` around :math:`\tau = I`. If :literal:`flreal = 0`,
        computes only an algebraic equivalence class. If :literal:`flreal` is set,
        compute :math:`p_{n}` such that for :math:`\tau` close enough to :math:`I` we have

        .. MATH::

        f(\tau) = (2I/(\tau+I))^{k}\sum_{n >= 0}p_{n}((\tau-I)/(\tau+I))^{n} .

        ::

        ? D=mfDelta();
        ? mftaylor(D,8)
        %2 = [1/1728, 0, -1/20736, 0, 1/165888, 0, 1/497664, 0, -11/3981312]
        '''
        sig_on()
        cdef GEN _F = (<Gen>F).g
        precision = nbits2prec(precision)
        cdef GEN _ret = mftaylor(_F, n, flreal, precision)
        return new_gen(_ret)

    def mftobasis(mf, F, long flag=0):
        r'''
        Coefficients of the form :math:`F` on the basis given by :literal:`mfbasis(mf)`.
        A :math:`q`-expansion or vector of coefficients
        can also be given instead of :math:`F`, but in this case an error message may occur
        if the expansion is too short. An error message is also given if :math:`F` does not
        belong to the modular form space. If :math:`flag` is set, instead of
        error messages the output is an affine space of solutions if a :math:`q`-expansion
        or vector of coefficients is given, or the empty column otherwise.

        ::

        ? mf = mfinit([26,2],0); mfdim(mf)
        %1 = 2
        ? F = mflinear(mf,[a,b]); mftobasis(mf,F)
        %2 = [a, b]~

        A :math:`q`-expansion or vector of coefficients can also be given instead of :math:`F`.

        ::

        ? Th = 1 + 2*sum(n=1, 8, q^(n^2), O(q^80));
        ? mf = mfinit([4,5,Mod(3,4)]);
        ? mftobasis(mf, Th^10)
        %3 = [64/5, 4/5, 32/5]~

        If :math:`F` does not belong to the corresponding space, the result is incorrect
        and simply matches the coefficients of :math:`F` up to some bound, and
        the function may either return an empty column or an error message.
        If :math:`flag` is set, there are no error messages, and the result is
        an empty column if :math:`F` is a modular form; if :math:`F` is supplied via a series
        or vector of coefficients which does not contain enough information to force
        a unique (potential) solution, the function returns :math:`[v,K]` where :math:`v` is a
        solution and :math:`K` is a matrix of maximal rank describing the affine space of
        potential solutions :math:`v + K.x`.

        ::

        ? mf = mfinit([4,12],1);
        ? mftobasis(mf, q-24*q^2+O(q^3), 1)
        %2 = [[43/64, -63/8, 800, 21/64]~, [1, 0; 24, 0; 2048, 768; -1, 0]]
        ? mftobasis(mf, [0,1,-24,252], 1)
        %3 = [[1, 0, 1472, 0]~, [0; 0; 768; 0]]
        ? mftobasis(mf, [0,1,-24,252,-1472], 1)
        %4 = [1, 0, 0, 0]~ \\ now uniquely determined
        ? mftobasis(mf, [0,1,-24,252,-1472,0], 1)
        %5 = [1, 0, 0, 0]~ \\ wrong result: no such form exists
        ? mfcoefs(mflinear(mf,%), 5) \\ double check
        %6 = [0, 1, -24, 252, -1472, 4830]
        ? mftobasis(mf, [0,1,-24,252,-1472,0])
        *** at top-level: mftobasis(mf,[0,1,
        *** ^--------------------
        *** mftobasis: domain error in mftobasis: form does not belong to space
        ? mftobasis(mf, mfEk(10))
        *** at top-level: mftobasis(mf,mfEk(
        *** ^--------------------
        *** mftobasis: domain error in mftobasis: form does not belong to space
        ? mftobasis(mf, mfEk(10), 1)
        %7 = []~
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mftobasis(_mf, _F, flag)
        return new_gen(_ret)

    def mftonew(mf, F):
        r'''
        :literal:`mf` being being a full or cuspidal space with parameters :math:`[N,k,\chi]`
        and :math:`F` a cusp form in that space, returns a vector of 3-component vectors
        :math:`[M,d,G]`, where :math:`f(\chi) \| M \| N`, :math:`d \| N/M`, and :math:`G` is a form
        in :math:`S_{k}^{new}(\Gamma_{0}(M),\chi)` such that :math:`F` is equal to the sum
        of the :math:`B(d)(G)` over all these 3-component vectors.

        ::

        ? mf = mfinit([96,6],1); F = mfbasis(mf)[60]; s = mftonew(mf,F); #s
        %1 = 1
        ? [M,d,G] = s[1]; [M,d]
        %2 = [48, 2]
        ? mfcoefs(F,10)
        %3 = [0, 0, -160, 0, 0, 0, 0, 0, 0, 0, -14400]
        ? mfcoefs(G,10)
        %4 = [0, 0, -160, 0, 0, 0, 0, 0, 0, 0, -14400]
        '''
        F = objtogen(F)
        sig_on()
        cdef GEN _mf = (<Gen>mf).g
        cdef GEN _F = (<Gen>F).g
        cdef GEN _ret = mftonew(_mf, _F)
        return new_gen(_ret)

    def mftraceform(NK, long space=0):
        r'''
        If :math:`NK = [N,k,CHI,.]` as in :literal:`mfinit` with :math:`k` integral, gives the
        trace form in the corresponding subspace of :math:`S_{k}(\Gamma_{0}(N),\chi)`.
        The supported values for :literal:`space` are 0: the newspace (default),
        1: the full cuspidal space.

        ::

        ? F = mftraceform([23,2]); mfcoefs(F,16)
        %1 = [0, 2, -1, 0, -1, -2, -5, 2, 0, 4, 6, -6, 5, 6, 4, -10, -3]
        ? F = mftraceform([23,1,-23]); mfcoefs(F,16)
        %2 = [0, 1, -1, -1, 0, 0, 1, 0, 1, 0, 0, 0, 0, -1, 0, 0, -1]
        '''
        sig_on()
        cdef GEN _NK = (<Gen>NK).g
        cdef GEN _ret = mftraceform(_NK, space)
        return new_gen(_ret)

    def mftwist(F, D):
        r'''
        :math:`F` being a generalized modular form, returns the twist of :math:`F` by the
        integer :math:`D`, i.e., the form :math:`G` such that
        :literal:`mfcoef(G,n) = `:math:`(D/n)`:literal:`mfcoef(F,n)`, where :math:`(D/n)` is the Kronecker
        symbol.

        ::

        ? mf = mfinit([11,2],0); F = mfbasis(mf)[1]; mfcoefs(F, 5)
        %1 = [0, 1, -2, -1, 2, 1]
        ? G = mftwist(F,-3); mfcoefs(G, 5)
        %2 = [0, 1, 2, 0, 2, -1]
        ? mf2 = mfinit([99,2],0); mftobasis(mf2, G)
        %3 = [1/3, 0, 1/3, 0]~

        Note that twisting multiplies the level by :math:`D^{2}`. In
        particular it is not an involution:

        ::

        ? H = mftwist(G,-3); mfcoefs(H, 5)
        %4 = [0, 1, -2, 0, 2, 1]
        ? mfparams(G)
        %5 = [99, 2, 1, y, t - 1]
        '''
        D = objtogen(D)
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _D = (<Gen>D).g
        cdef GEN _ret = mftwist(_F, _D)
        return new_gen(_ret)

    def min(x, y):
        r'''
        Creates the minimum of :math:`x` and :math:`y` when they can be compared.
        '''
        y = objtogen(y)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = gmin(_x, _y)
        return new_gen(_ret)

    def minpoly(A, v=None):
        r'''
        minimal polynomial
        of :math:`A` with respect to the variable :math:`v`., i.e. the monic polynomial :math:`P`
        of minimal degree (in the variable :math:`v`) such that :math:`P(A) = 0`.
        '''
        cdef long _v = -1
        if v is not None:
            _v = get_var(v)
        sig_on()
        cdef GEN _A = (<Gen>A).g
        cdef GEN _ret = minpoly(_A, _v)
        return new_gen(_ret)

    def modreverse(z):
        r'''
        Let :math:`z = Mod(A, T)` be a polmod, and :math:`Q` be its minimal
        polynomial, which must satisfy :math:`deg(Q) = deg(T)`.
        Returns a "reverse polmod" :literal:`Mod(B, Q)`, which is a root of :math:`T`.

        This is quite useful when one changes the generating element in algebraic
        extensions:

        ::

        ? u = Mod(x, x^3 - x -1); v = u^5;
        ? w = modreverse(v)
        %2 = Mod(x^2 - 4*x + 1, x^3 - 5*x^2 + 4*x - 1)

        which means that :math:`x^{3} - 5x^{2} + 4x -1` is another defining polynomial
        for the cubic field

        .. MATH::

        \mathbb{Q} (u) = \mathbb{Q}[x]/(x^{3} - x - 1) = \mathbb{Q}[x]/(x^{3} - 5x^{2} + 4x - 1) = \mathbb{Q} (v),

        and that :math:`u \to v^{2} - 4v + 1` gives an explicit isomorphism. From this, it is
        easy to convert elements between the :math:`A(u)\in \mathbb{Q} (u)` and :math:`B(v)\in \mathbb{Q} (v)`
        representations:

        ::

        ? A = u^2 + 2*u + 3; subst(lift(A), 'x, w)
        %3 = Mod(x^2 - 3*x + 3, x^3 - 5*x^2 + 4*x - 1)
        ? B = v^2 + v + 1; subst(lift(B), 'x, v)
        %4 = Mod(26*x^2 + 31*x + 26, x^3 - x - 1)

        If the minimal polynomial of :math:`z` has lower degree than expected, the routine
        fails

        ::

        ? u = Mod(-x^3 + 9*x, x^4 - 10*x^2 + 1)
        ? modreverse(u)
        *** modreverse: domain error in modreverse: deg(minpoly(z)) < 4
        *** Break loop: type 'break' to go back to GP prompt
        break> Vec( dbg_err() ) \\ ask for more info
        ["e_DOMAIN", "modreverse", "deg(minpoly(z))", "<", 4,
        Mod(-x^3 + 9*x, x^4 - 10*x^2 + 1)]
        break> minpoly(u)
        x^2 - 8
        '''
        sig_on()
        cdef GEN _z = (<Gen>z).g
        cdef GEN _ret = modreverse(_z)
        return new_gen(_ret)

    def moebius(x):
        r'''
        Moebius :math:`\mu`-function of :math:`\|x\|`; :math:`x` must be a nonzero integer.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef long _ret = moebius(_x)
        clear_stack()
        return _ret

    def msatkinlehner(M, long Q, H=None):
        r'''
        Let :math:`M` be a full modular symbol space of level :math:`N`,
        as given by :literal:`msinit`, let :math:`Q \| N`, :math:`(Q,N/Q) = 1`,
        and let :math:`H` be a subspace stable under the Atkin-Lehner involution :math:`w_{Q}`.
        Return the matrix of :math:`w_{Q}` acting on :math:`H` (:math:`M` if omitted).

        ::

        ? M = msinit(36,2); \\ M_2(Gamma_0(36))
        ? w = msatkinlehner(M,4); w^2 == 1
        %2 = 1
        ? #w \\ involution acts on a 13-dimensional space
        %3 = 13
        ? M = msinit(36,2, -1); \\ M_2(Gamma_0(36))^-
        ? w = msatkinlehner(M,4); w^2 == 1
        %5 = 1
        ? #w
        %6 = 4
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = msatkinlehner(_M, Q, _H)
        return new_gen(_ret)

    def mscosets(gen, inH):
        r'''
        :literal:`gen` being a system of generators for a group :math:`G` and :math:`H` being a
        subgroup of finite index in :math:`G`, return a list of right cosets of
        :math:`H\G` and the right action of :math:`G` on :math:`H\G`. The subgroup
        :math:`H` is given by a criterion :literal:`inH` (closure) deciding whether an element
        of :math:`G` belongs to :math:`H`. The group :math:`G` is restricted to types handled by generic
        multiplication (:literal:`*`) and inversion (:literal:`g^(-1)`), such as matrix
        groups or permutation groups.

        Let :math:`gens = [g_{1},..., g_{r}]`. The function returns :math:`[C,M]` where :math:`C`
        lists the :math:`h = [G:H]` representatives :math:`[\gamma_{1},..., \gamma_{h}]`
        for the right cosets :math:`H\gamma_{1},...,H\gamma_{h}`; :math:`\gamma_{1}` is always
        the neutral element in :math:`G`. For all :math:`i <= h`, :math:`j <= r`, if :math:`M[i][j] = k`
        then :math:`H \gamma_{i} g_{j} = H\gamma_{k}`.

        ::

        ? PSL2 = [[0,1;-1,0], [1,1;0,1]]; \\ S and T
        \\ G = PSL2, H = Gamma0(2)
        ? [C, M] = mscosets(PSL2, g->g[2,1] % 2 == 0);
        ? C \\ three cosets
        %3 = [[1, 0; 0, 1], [0, 1; -1, 0], [0, 1; -1, -1]]
        ? M
        %4 = [Vecsmall([2, 1]), Vecsmall([1, 3]), Vecsmall([3, 2])]

        Looking at :math:`M[1]` we see that :math:`S` belongs to the second
        coset and :math:`T` to the first (trivial) coset.
        '''
        inH = objtogen(inH)
        sig_on()
        cdef GEN _gen = (<Gen>gen).g
        cdef GEN _inH = (<Gen>inH).g
        cdef GEN _ret = mscosets0(_gen, _inH)
        return new_gen(_ret)

    def mscuspidal(M, long flag=0):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        return its cuspidal part :math:`S`. If :math:`flag = 1`, return
        :math:`[S,E]` its decomposition into cuspidal and Eisenstein parts.

        A subspace is given by a structure allowing quick projection and
        restriction of linear operators; its first component is
        a matrix with integer coefficients whose columns form a :math:`\mathbb{Q}`-basis of
        the subspace.

        ::

        ? M = msinit(2,8, 1); \\ M_8(Gamma_0(2))^+
        ? [S,E] = mscuspidal(M, 1);
        ? E[1] \\ 2-dimensional
        %3 =
        [0 -10]
        
        [0 -15]
        
        [0 -3]
        
        [1 0]
        
        ? S[1] \\ 1-dimensional
        %4 =
        [ 3]
        
        [30]
        
        [ 6]
        
        [-8]
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = mscuspidal(_M, flag)
        return new_gen(_ret)

    def msdim(M):
        r'''
        :math:`M` being a full modular symbol space or subspace, for instance
        as given by :literal:`msinit` or :literal:`mscuspidal`, return
        its dimension as a :math:`\mathbb{Q}`-vector space.

        ::

        ? M = msinit(11,4); msdim(M)
        %1 = 6
        ? M = msinit(11,4,1); msdim(M)
        %2 = 4 \\ dimension of the '+' part
        ? [S,E] = mscuspidal(M,1);
        ? [msdim(S), msdim(E)]
        %4 = [2, 2]

        Note that :literal:`mfdim([N,k])` is going to be much faster if
        you only need the dimension of the space and not really to work with it.
        This function is only useful to quickly check the dimension of an existing
        space.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef long _ret = msdim(_M)
        clear_stack()
        return _ret

    def mseisenstein(M):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        return its Eisenstein subspace.
        A subspace is given by a structure allowing quick projection and
        restriction of linear operators; its first component is
        a matrix with integer coefficients whose columns form a :math:`\mathbb{Q}`-basis of
        the subspace.
        This is the same basis as given by the second component of
        :literal:`mscuspidal`:math:`(M, 1)`.

        ::

        ? M = msinit(2,8, 1); \\ M_8(Gamma_0(2))^+
        ? E = mseisenstein(M);
        ? E[1] \\ 2-dimensional
        %3 =
        [0 -10]
        
        [0 -15]
        
        [0 -3]
        
        [1 0]
        
        ? E == mscuspidal(M,1)[2]
        %4 = 1
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = mseisenstein(_M)
        return new_gen(_ret)

    def mseval(M, s, p=None):
        r'''
        Let :math:`\Delta_{0} := Div^{0}(\mathbb{P}^{1} (\mathbb{Q}))`.
        Let :math:`M` be a full modular symbol space, as given by :literal:`msinit`,
        let :math:`s` be a modular symbol from :math:`M`, i.e. an element
        of :math:`\text{Hom}_{G}(\Delta_{0}, V)`, and let :math:`p = [a,b] \in \Delta_{0}` be a path between
        two elements in :math:`\mathbb{P}^{1}(\mathbb{Q})`, return :math:`s(p)\in V`. The path extremities :math:`a` and
        :math:`b` may be given as :literal:`t_INT`, :literal:`t_FRAC` or :math:`oo = (1:0)`; it
        is also possible to describe the path by a :math:`2 x 2` integral matrix
        whose columns give the two cusps. The symbol :math:`s` is either

        - a :literal:`t_COL` coding a modular symbol in terms of
        the fixed basis of :math:`\text{Hom}_{G}(\Delta_{0},V)` chosen in :math:`M`; if :math:`M` was
        initialized with a nonzero :emphasis:`sign` (:math:`+` or :math:`-`), then either the
        basis for the full symbol space or the :math:`±`-part can be used (the dimension
        being used to distinguish the two).

        - a :literal:`t_MAT` whose columns encode modular symbols as above. This is
        much faster than evaluating individual symbols on the same path :math:`p`
        independently.

        - a :literal:`t_VEC` :math:`(v_{i})` of elements of :math:`V`, where the :math:`v_{i} = s(g_{i})`
        give
        the image of the generators :math:`g_{i}` of :math:`\Delta_{0}`, see :literal:`mspathgens`.
        We assume that :math:`s` is a proper symbol, i.e. that the :math:`v_{i}` satisfy
        the :literal:`mspathgens` relations.

        If :math:`p` is omitted, convert a single symbol :math:`s` to the second form: a vector
        of the :math:`s(g_{i})`. A :literal:`t_MAT` is converted to a vector of such.

        ::

        ? M = msinit(2,8,1); \\ M_8(Gamma_0(2))^+
        ? g = mspathgens(M)[1]
        %2 = [[+oo, 0], [0, 1]]
        ? N = msnew(M)[1]; #N \\ Q-basis of new subspace, dimension 1
        %3 = 1
        ? s = N[,1] \\ t_COL representation
        %4 = [-3, 6, -8]~
        ? S = mseval(M, s) \\ t_VEC representation
        %5 = [64*x^6-272*x^4+136*x^2-8, 384*x^5+960*x^4+192*x^3-672*x^2-432*x-72]
        ? mseval(M,s, g[1])
        %6 = 64*x^6 - 272*x^4 + 136*x^2 - 8
        ? mseval(M,S, g[1])
        %7 = 64*x^6 - 272*x^4 + 136*x^2 - 8

        Note that the symbol should have values in
        :math:`V = \mathbb{Q}[x,y]_{k-2}`, we return the de-homogenized values corresponding to :math:`y
        = 1` instead.
        '''
        s = objtogen(s)
        cdef bint _have_p = (p is not None)
        if _have_p:
            p = objtogen(p)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _p = NULL
        if _have_p:
            _p = (<Gen>p).g
        cdef GEN _ret = mseval(_M, _s, _p)
        return new_gen(_ret)

    def msfarey(F, inH, CM=None):
        r'''
        :math:`F` being a Farey symbol attached to a group :math:`G` contained in
        :math:`PSL_{2}(\mathbb{Z})` and :math:`H` a subgroup of :math:`G`, return a Farey symbol attached
        to :math:`H`. The subgroup :math:`H` is given by a criterion :literal:`inH` (closure) deciding
        whether an element of :math:`G` belongs to :math:`H`. The symbol :math:`F` can be created using

        - :literal:`mspolygon`: :math:`G = \Gamma_{0}(N)`, which runs in time :math:`~{O}(N)`;

        - or :literal:`msfarey` itself, which runs in time :math:`O([G:H]^{2})`.

        If present, the argument :literal:`CM` is set to :literal:`mscosets(F[3])`, giving
        the right cosets of :math:`H \G` and the action of :math:`G` by right
        multiplication. Since :literal:`msfarey`'s algorithm is quadratic in the index
        :math:`[G:H]`, it is advisable to construct subgroups by a chain of inclusions if
        possible.

        ::

        \\ Gamma_0(N)
        G0(N) = mspolygon(N);
        
        \\ Gamma_1(N): direct construction, slow
        G1(N) = msfarey(mspolygon(1), g -> my(a = g[1,1]%N, c = g[2,1]%N);\
        c == 0 && (a == 1 || a == N-1));
        \\ Gamma_1(N) via Gamma_0(N): much faster
        G1(N) = msfarey(G0(N), g -> my(a=g[1,1]%N); a==1 || a==N-1);

        Note that the simpler criterion :literal:`g[1,1]\%N == 1` would not
        be correct since it must apply to elements of :math:`PSL_{2}(\mathbb{Z})` hence be
        invariant under :math:`g :--->-g`. Here are other examples:

        ::

        \\ Gamma(N)
        G(N) = msfarey(G1(N), g -> g[1,2]%N==0);
        
        G_00(N) = msfarey(G0(N), x -> x[1,2]%N==0);
        G1_0(N1,N2) = msfarey(G0(1), x -> x[2,1]%N1==0 && x[1,2]%N2==0);
        
        \\ Gamma_0(91) has 4 elliptic points of order 3, Gamma_1(91) has none
        D0 = mspolygon(G0(91), 2)[4];
        D1 = mspolygon(G1(91), 2)[4];
        write("F.tex","\\documentclass{article}\\usepackage{tikz}\\begin{document}",\
        D0,"\n",D1,"\\end{document}");
        '''
        inH = objtogen(inH)
        cdef bint _have_CM = (CM is not None)
        if _have_CM:
            raise NotImplementedError("optional argument CM not available")
        sig_on()
        cdef GEN _F = (<Gen>F).g
        cdef GEN _inH = (<Gen>inH).g
        cdef GEN * _CM = NULL
        cdef GEN _ret = msfarey0(_F, _inH, _CM)
        return new_gen(_ret)

    def msfromcusp(M, c):
        r'''
        Returns the modular symbol attached to the cusp
        :math:`c`, where :math:`M` is a modular symbol space of level :math:`N`, attached to
        :math:`G = \Gamma_{0}(N)`. The cusp :math:`c` in :math:`\mathbb{P}^{1}(\mathbb{Q})/G` is given either as :literal:`oo`
        (:math:`= (1:0)`) or as a rational number :math:`a/b` (:math:`= (a:b)`). The attached symbol maps
        the path :math:`[b] - [a] \in Div^{0} (\mathbb{P}^{1}(\mathbb{Q}))` to :math:`E_{c}(b) - E_{c}(a)`,
        where
        :math:`E_{c}(r)` is :math:`0` when :math:`r ! = c` and :math:`X^{k-2} \| \gamma_{r}` otherwise,
        where
        :math:`\gamma_{r}.r = (1:0)`. These symbols span the Eisenstein subspace
        of :math:`M`.

        ::

        ? M = msinit(2,8); \\ M_8(Gamma_0(2))
        ? E = mseisenstein(M);
        ? E[1] \\ two-dimensional
        %3 =
        [0 -10]
        
        [0 -15]
        
        [0 -3]
        
        [1 0]
        
        ? s = msfromcusp(M,oo)
        %4 = [0, 0, 0, 1]~
        ? mseval(M, s)
        %5 = [1, 0]
        ? s = msfromcusp(M,1)
        %6 = [-5/16, -15/32, -3/32, 0]~
        ? mseval(M,s)
        %7 = [-x^6, -6*x^5 - 15*x^4 - 20*x^3 - 15*x^2 - 6*x - 1]

        In case :math:`M` was initialized with a nonzero :emphasis:`sign`, the symbol is given
        in terms of the fixed basis of the whole symbol space, not the :math:`+` or :math:`-`
        part (to which it need not belong).

        ::

        ? M = msinit(2,8, 1); \\ M_8(Gamma_0(2))^+
        ? E = mseisenstein(M);
        ? E[1] \\ still two-dimensional, in a smaller space
        %3 =
        [ 0 -10]
        
        [ 0 3]
        
        [-1 0]
        
        ? s = msfromcusp(M,oo) \\ in terms of the basis for M_8(Gamma_0(2)) !
        %4 = [0, 0, 0, 1]~
        ? mseval(M, s) \\ same symbol as before
        %5 = [1, 0]
        '''
        c = objtogen(c)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _c = (<Gen>c).g
        cdef GEN _ret = msfromcusp(_M, _c)
        return new_gen(_ret)

    def msfromell(E, long sign=0):
        r'''
        Let :math:`E/\mathbb{Q}` be an elliptic curve of conductor :math:`N`. For :math:`\varepsilon =
        ±1`, we define the (cuspidal, new) modular symbol :math:`x^{\varepsilon}` in
        :math:`H^{1}_{c}(X_{0}(N),\mathbb{Q})^{\varepsilon}` attached to :math:`E`. For all primes :math:`p`
        not dividing :math:`N` we have
        :math:`T_{p}(x^{\varepsilon}) = a_{p} x^{\varepsilon}`, where :math:`a_{p} =
        p+1-\#E(\mathbb{F}_{p})`.

        Let :math:`\Omega^{+} = E.omega[1]` be the real period of :math:`E`
        (integration of the Néron differential :math:`dx/(2y+a_{1}x+a_{3})` on the
        connected
        component of :math:`E(\mathbb{R})`, i.e. the generator of :math:`H_{1}(E,\mathbb{Z})^{+}`) normalized by
        :math:`\Omega^{+} > 0`. Let :math:`i\Omega^{-}` the integral on a generator of
        :math:`H_{1}(E,\mathbb{Z})^{-}` with
        :math:`\Omega^{-} \in \mathbb{R}_{ > 0}`. If :math:`c_{ oo }` is the number of connected components of
        :math:`E(\mathbb{R})`, :math:`\Omega^{-}` is equal to :math:`(-2/c_{ oo }) x imag(E.omega[2])`.
        The complex modular symbol is defined by

        .. MATH::

        F: \delta \to 2i\pi \int_{\delta} f(z) dz

        The modular symbols :math:`x^{\varepsilon}` are normalized so that
        :math:`F = x^{+} \Omega^{+} + x^{-} i\Omega^{-}`. In particular, we have

        .. MATH::

        x^{+}([0]-[ oo ]) = L(E,1) / \Omega^{+},

        which defines :math:`x^{±}` unless :math:`L(E,1) = 0`. Furthermore, for all fundamental
        discriminants :math:`D` such that :math:`\varepsilon.D > 0`, we also have

        .. MATH::

        \sum_{0 <= a < \|D\|} (D\|a) x^{\varepsilon}([a/\|D\|]-[ oo ])
        = L(E,(D\|.),1) / \Omega^{\varepsilon},

        where :math:`(D\|.)` is the Kronecker symbol. The period :math:`\Omega^{-}` is also
        :math:`2/c_{ oo } x` the real period of the twist
        :math:`E^{(-4)} = elltwist(E,-4)`.

        This function returns the pair :math:`[M, x]`, where :math:`M` is
        :literal:`msinit`:math:`(N,2)` and :math:`x` is :math:`x^{sign}` as above when :math:`sign =
        ±1`, and :math:`x = [x^{+},x^{-}, L_{E}]` when :emphasis:`sign` is :math:`0`, where :math:`L_{E}`
        is a matrix giving the canonical :math:`\mathbb{Z}`-lattice attached to :math:`E` in the sense
        of :literal:`mslattice` applied to :math:`\mathbb{Q} x^{+} + \mathbb{Q} x^{-}`. Explicitly, it
        is generated by :math:`(x^{+},x^{-})` when :math:`E(\mathbb{R})` has two connected components
        and by :math:`(x^{+} - x^{-},2x^{-})` otherwise.

        The modular symbols :math:`x^{±}` are given as a :literal:`t_COL` (in terms
        of the fixed basis of :math:`\text{Hom}_{G}(\Delta_{0},\mathbb{Q})` chosen in :math:`M`).

        ::

        ? E=ellinit([0,-1,1,-10,-20]); \\ X_0(11)
        ? [M,xp]= msfromell(E,1);
        ? xp
        %3 = [1/5, -1/2, -1/2]~
        ? [M,x]= msfromell(E);
        ? x \\ x^+, x^- and L_E
        %5 = [[1/5, -1/2, -1/2]~, [0, 1/2, -1/2]~, [1/5, 0; -1, 1; 0, -1]]
        ? p = 23; (mshecke(M,p) - ellap(E,p))*x[1]
        %6 = [0, 0, 0]~ \\ true at all primes, including p = 11; same for x[2]
        ? (mshecke(M,p) - ellap(E,p))*x[3] == 0
        %7 = 1

        Instead of a single curve :math:`E`, one may use instead a vector
        of :emphasis:`isogenous` curves. The function then returns :math:`M` and the
        vector of attached modular symbols.
        '''
        sig_on()
        cdef GEN _E = (<Gen>E).g
        cdef GEN _ret = msfromell(_E, sign)
        return new_gen(_ret)

    def msfromhecke(M, v, H=None):
        r'''
        Given a msinit :math:`M` and a vector :math:`v` of pairs :math:`[p, P]` (where :math:`p` is prime
        and :math:`P` is a polynomial with integer coefficients), return a basis of all
        modular symbols such that :math:`P(T_{p})(s) = 0`. If :math:`H` is present, it must
        be a Hecke-stable subspace and we restrict to :math:`s \in H`. When :math:`T_{p}` has
        a rational eigenvalue and :math:`P(x) = x-a_{p}` has degree :math:`1`, we also accept the
        integer :math:`a_{p}` instead of :math:`P`.

        ::

        ? E = ellinit([0,-1,1,-10,-20]) \\11a1
        ? ellap(E,2)
        %2 = -2
        ? ellap(E,3)
        %3 = -1
        ? M = msinit(11,2);
        ? S = msfromhecke(M, [[2,-2],[3,-1]])
        %5 =
        [ 1 1]
        
        [-5 0]
        
        [ 0 -5]
        ? mshecke(M, 2, S)
        %6 =
        [-2 0]
        
        [ 0 -2]
        
        ? M = msinit(23,4);
        ? S = msfromhecke(M, [[5, x^4-14*x^3-244*x^2+4832*x-19904]]);
        ? factor( charpoly(mshecke(M,5,S)) )
        %9 =
        [x^4 - 14*x^3 - 244*x^2 + 4832*x - 19904 2]
        '''
        v = objtogen(v)
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _v = (<Gen>v).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = msfromhecke(_M, _v, _H)
        return new_gen(_ret)

    def msgetlevel(M):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`, return
        its level :math:`N`.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef long _ret = msgetlevel(_M)
        clear_stack()
        return _ret

    def msgetsign(M):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`, return
        its sign: :math:`±1` or 0 (unset).

        ::

        ? M = msinit(11,4, 1);
        ? msgetsign(M)
        %2 = 1
        ? M = msinit(11,4);
        ? msgetsign(M)
        %4 = 0
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef long _ret = msgetsign(_M)
        clear_stack()
        return _ret

    def msgetweight(M):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`, return
        its weight :math:`k`.

        ::

        ? M = msinit(11,4);
        ? msgetweight(M)
        %2 = 4
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef long _ret = msgetweight(_M)
        clear_stack()
        return _ret

    def mshecke(M, long p, H=None):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        :math:`p` being a prime number, and :math:`H` being a Hecke-stable subspace (:math:`M` if
        omitted), return the matrix of :math:`T_{p}` acting on :math:`H`
        (:math:`U_{p}` if :math:`p` divides :math:`N`). Result is undefined if :math:`H` is not stable
        by :math:`T_{p}` (resp. :math:`U_{p}`).

        ::

        ? M = msinit(11,2); \\ M_2(Gamma_0(11))
        ? T2 = mshecke(M,2)
        %2 =
        [3 0 0]
        
        [1 -2 0]
        
        [1 0 -2]
        ? M = msinit(11,2, 1); \\ M_2(Gamma_0(11))^+
        ? T2 = mshecke(M,2)
        %4 =
        [ 3 0]
        
        [-1 -2]
        
        ? N = msnew(M)[1] \\ Q-basis of new cuspidal subspace
        %5 =
        [-2]
        
        [-5]
        
        ? p = 1009; mshecke(M, p, N) \\ action of T_1009 on N
        %6 =
        [-10]
        ? ellap(ellinit("11a1"), p)
        %7 = -10
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = mshecke(_M, p, _H)
        return new_gen(_ret)

    def msinit(G, V, long sign=0):
        r'''
        Given :math:`G` a finite index subgroup of :math:`SL(2,\mathbb{Z})`
        and a finite dimensional representation :math:`V` of :math:`GL(2,\mathbb{Q})`, creates a
        space of modular symbols, the :math:`G`-module
        :math:`\text{Hom}_{G}(Div^{0}(\mathbb{P}^{1}(\mathbb{Q})), V)`.
        This is canonically isomorphic to :math:`H^{1}_{c}(X(G), V)`, and allows to
        compute modular forms for :math:`G`. If :emphasis:`sign` is present and nonzero, it
        must be :math:`±1` and we consider the subspace defined by :math:`Ker (\sigma -
        sign)`, where :math:`\sigma` is induced by :literal:`[-1,0;0,1]`. Currently the
        only supported groups are the :math:`\Gamma_{0}(N)`, coded by the integer :math:`N > 0`.
        The only supported representation is :math:`V_{k} = \mathbb{Q}[X,Y]_{k-2}`, coded by the
        integer :math:`k >= 2`.

        ::

        ? M = msinit(11,2); msdim(M) \\ Gamma0(11), weight 2
        %1 = 3
        ? mshecke(M,2) \\ T_2 acting on M
        %2 =
        [3 1 1]
        
        [0 -2 0]
        
        [0 0 -2]
        ? msstar(M) \\ * involution
        %3 =
        [1 0 0]
        
        [0 0 1]
        
        [0 1 0]
        
        ? Mp = msinit(11,2, 1); msdim(Mp) \\ + part
        %4 = 2
        ? mshecke(Mp,2) \\ T_2 action on M^+
        %5 =
        [3 2]
        
        [0 -2]
        ? msstar(Mp)
        %6 =
        [1 0]
        
        [0 1]
        '''
        V = objtogen(V)
        sig_on()
        cdef GEN _G = (<Gen>G).g
        cdef GEN _V = (<Gen>V).g
        cdef GEN _ret = msinit(_G, _V, sign)
        return new_gen(_ret)

    def msissymbol(M, s):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        check whether :math:`s` is a modular symbol attached to :math:`M`. If :math:`A` is a matrix,
        check whether its columns represent modular symbols and return a :math:`0-1`
        vector.

        ::

        ? M = msinit(7,8, 1); \\ M_8(Gamma_0(7))^+
        ? A = msnew(M)[1];
        ? s = A[,1];
        ? msissymbol(M, s)
        %4 = 1
        ? msissymbol(M, A)
        %5 = [1, 1, 1]
        ? S = mseval(M,s);
        ? msissymbol(M, S)
        %7 = 1
        ? [g,R] = mspathgens(M); g
        %8 = [[+oo, 0], [0, 1/2], [1/2, 1]]
        ? #R \\ 3 relations among the generators g_i
        %9 = 3
        ? T = S; T[3]++; \\ randomly perturb S(g_3)
        ? msissymbol(M, T)
        %11 = 0 \\ no longer satisfies the relations
        '''
        s = objtogen(s)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _s = (<Gen>s).g
        cdef GEN _ret = msissymbol(_M, _s)
        return new_gen(_ret)

    def mslattice(M, H=None):
        r'''
        Let :math:`\Delta_{0} := Div^{0}(\mathbb{P}^{1}(\mathbb{Q}))` and :math:`V_{k} = \mathbb{Q}[x,y]_{k-2}`.
        Let :math:`M` be a full modular symbol space, as given by :literal:`msinit`
        and let :math:`H` be a subspace, e.g. as given by :literal:`mscuspidal`.
        This function returns a canonical :math:`\mathbb{Z}`-structure on :math:`H` defined as follows.
        Consider the map :math:`c: M = \text{Hom}_{\Gamma_{0}(N)}(\Delta_{0}, V_{k}) \to
        H^{1}(\Gamma_{0}(N), V_{k})` given by
        :math:`\phi :--->class (\gamma \to \phi ({0, \gamma^{-1} 0}))`.
        Let :math:`L_{k} = \mathbb{Z}[x,y]_{k-2}` be the natural :math:`\mathbb{Z}`-structure of :math:`V_{k}`.
        The result of
        :literal:`mslattice` is a :math:`\mathbb{Z}`-basis of the inverse image by :math:`c` of
        :math:`H^{1}(\Gamma_{0}(N), L_{k})` in the space of modular symbols generated by :math:`H`.

        For user convenience, :math:`H` can be defined by a matrix representing the
        :math:`\mathbb{Q}`-basis of :math:`H` (in terms of the canonical :math:`\mathbb{Q}`-basis of :math:`M` fixed by
        :literal:`msinit` and used to represent modular symbols).

        If omitted, :math:`H` is the cuspidal part of :math:`M` as given by :literal:`mscuspidal`.
        The Eisenstein part :math:`\text{Hom}_{\Gamma_{0}(N)}(Div(\mathbb{P}^{1}(\mathbb{Q})), V_{k})` is in
        the kernel of :math:`c`, so the result has no meaning for the Eisenstein part
        :literal:`H`.

        ::

        ? M=msinit(11,2);
        ? [S,E] = mscuspidal(M,1); S[1] \\ a primitive Q-basis of S
        %2 =
        [ 1 1]
        [-5 0]
        [ 0 -5]
        ? mslattice(M,S)
        %3 =
        [-1/5 -1/5]
        [ 1 0]
        [ 0 1]
        ? mslattice(M,E)
        %4 =
        [1]
        [0]
        [0]
        ? M=msinit(5,4);
        ? S=mscuspidal(M); S[1]
        %6 =
        [ 7 20]
        [ 3 3]
        [-10 -23]
        [-30 -30]
        ? mslattice(M,S)
        %7 =
        [-1/10 -11/130]
        [ 0 -1/130]
        [ 1/10 6/65]
        [ 0 1/13]
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = mslattice(_M, _H)
        return new_gen(_ret)

    def msnew(M):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        return the :emphasis:`new` part of its cuspidal subspace. A subspace is given by
        a structure allowing quick projection and restriction of linear operators;
        its first component is a matrix with integer coefficients whose columns form
        a :math:`\mathbb{Q}`-basis of the subspace.

        ::

        ? M = msinit(11,8, 1); \\ M_8(Gamma_0(11))^+
        ? N = msnew(M);
        ? #N[1] \\ 6-dimensional
        %3 = 6
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = msnew(_M)
        return new_gen(_ret)

    def msomseval(Mp, PHI, path):
        r'''
        Return the vectors of moments of the :math:`p`-adic distribution attached
        to the path :literal:`path` by the overconvergent modular symbol :literal:`PHI`.

        ::

        ? M = msinit(3,6,1);
        ? Mp= mspadicinit(M,5,10);
        ? phi = [5,-3,-1]~;
        ? msissymbol(M,phi)
        %4 = 1
        ? PHI = mstooms(Mp,phi);
        ? ME = msomseval(Mp,PHI,[oo, 0]);
        '''
        PHI = objtogen(PHI)
        path = objtogen(path)
        sig_on()
        cdef GEN _Mp = (<Gen>Mp).g
        cdef GEN _PHI = (<Gen>PHI).g
        cdef GEN _path = (<Gen>path).g
        cdef GEN _ret = msomseval(_Mp, _PHI, _path)
        return new_gen(_ret)

    def mspadicL(mu, s=None, long r=0):
        r'''
        Returns the value (or :math:`r`-th derivative)
        on a character :math:`\chi^{s}` of :math:`\mathbb{Z}_{p}^{*}` of the :math:`p`-adic :math:`L`-function
        attached to :literal:`mu`.

        Let :math:`\Phi` be the :math:`p`-adic distribution-valued overconvergent symbol
        attached to a modular symbol :math:`\phi` for :math:`\Gamma_{0}(N)` (eigenvector for
        :math:`T_{N}(p)` for the eigenvalue :math:`a_{p}`).
        Then :math:`L_{p}(\Phi,\chi^{s}) = L_{p}(\mu,s)` is the
        :math:`p`-adic :math:`L` function defined by

        .. MATH::

        L_{p}(\Phi,\chi^{s}) = \int_{\mathbb{Z}_{p}^{*}} \chi^{s}(z) d\mu (z)

        where :math:`\mu` is the distribution on :math:`\mathbb{Z}_{p}^{*}` defined by the restriction of
        :math:`\Phi ([ oo ]-[0])` to :math:`\mathbb{Z}_{p}^{*}`. The :math:`r`-th derivative is taken in
        direction :math:`<\chi>`:

        .. MATH::

        L_{p}^{(r)}(\Phi,\chi^{s}) = \int_{\mathbb{Z}_{p}^{*}} \chi^{s}(z)
        (\log z)^{r} d\mu (z).

        In the argument list,

        - :literal:`mu` is as returned by :literal:`mspadicmoments` (distributions
        attached to :math:`\Phi` by restriction to discs :math:`a + p^{\nu}\mathbb{Z}_{p}`, :math:`(a,p) = 1`).

        - :math:`s = [s_{1},s_{2}]` with :math:`s_{1} \in \mathbb{Z} \subset \mathbb{Z}_{p}` and
        :math:`s_{2} mod p-1` or
        :math:`s_{2} mod 2` for :math:`p = 2`, encoding the :math:`p`-adic character :math:`\chi^{s} :=
        <\chi >^{s_{1}} \tau^{s_{2}}`; here :math:`\chi` is the cyclotomic
        character from :math:`Gal(\mathbb{Q}_{p}(\mu_{p^{ oo }})/\mathbb{Q}_{p})` to :math:`\mathbb{Z}_{p}^{*}`,
        and :math:`\tau` is the Teichmüller character (for :math:`p > 2` and the character of
        order 2 on :math:`(\mathbb{Z}/4\mathbb{Z})^{*}` if :math:`p = 2`); for convenience, the character :math:`[s,s]`
        can also be represented by the integer :math:`s`.

        When :math:`a_{p}` is a :math:`p`-adic unit, :math:`L_{p}` takes its values in :math:`\mathbb{Q}_{p}`.
        When :math:`a_{p}` is not a unit, it takes its values in the
        two-dimensional :math:`\mathbb{Q}_{p}`-vector space :math:`D_{cris}(M(\phi))` where :math:`M(\phi)` is
        the "motive" attached to :math:`\phi`, and we return the two :math:`p`-adic components
        with respect to some fixed :math:`\mathbb{Q}_{p}`-basis.

        ::

        ? M = msinit(3,6,1); phi=[5, -3, -1]~;
        ? msissymbol(M,phi)
        %2 = 1
        ? Mp = mspadicinit(M, 5, 4);
        ? mu = mspadicmoments(Mp, phi); \\ no twist
        \\ End of initializations
        
        ? mspadicL(mu,0) \\ L_p(chi^0)
        %5 = 5 + 2*5^2 + 2*5^3 + 2*5^4 + ...
        ? mspadicL(mu,1) \\ L_p(chi), zero for parity reasons
        %6 = [O(5^13)]~
        ? mspadicL(mu,2) \\ L_p(chi^2)
        %7 = 3 + 4*5 + 4*5^2 + 3*5^5 + ...
        ? mspadicL(mu,[0,2]) \\ L_p(tau^2)
        %8 = 3 + 5 + 2*5^2 + 2*5^3 + ...
        ? mspadicL(mu, [1,0]) \\ L_p(<chi>)
        %9 = 3*5 + 2*5^2 + 5^3 + 2*5^7 + 5^8 + 5^10 + 2*5^11 + O(5^13)
        ? mspadicL(mu,0,1) \\ L_p'(chi^0)
        %10 = 2*5 + 4*5^2 + 3*5^3 + ...
        ? mspadicL(mu, 2, 1) \\ L_p'(chi^2)
        %11 = 4*5 + 3*5^2 + 5^3 + 5^4 + ...

        Now several quadratic twists: :literal:`mstooms` is indicated.

        ::

        ? PHI = mstooms(Mp,phi);
        ? mu = mspadicmoments(Mp, PHI, 12); \\ twist by 12
        ? mspadicL(mu)
        %14 = 5 + 5^2 + 5^3 + 2*5^4 + ...
        ? mu = mspadicmoments(Mp, PHI, 8); \\ twist by 8
        ? mspadicL(mu)
        %16 = 2 + 3*5 + 3*5^2 + 2*5^4 + ...
        ? mu = mspadicmoments(Mp, PHI, -3); \\ twist by -3 < 0
        ? mspadicL(mu)
        %18 = O(5^13) \\ always 0, phi is in the + part and D < 0

        One can locate interesting symbols of level :math:`N` and weight :math:`k` with
        :literal:`msnew` and :literal:`mssplit`. Note that instead of a symbol, one can
        input a 1-dimensional Hecke-subspace from :literal:`mssplit`: the function will
        automatically use the underlying basis vector.

        ::

        ? M=msinit(5,4,1); \\ M_4(Gamma_0(5))^+
        ? L = mssplit(M, msnew(M)); \\ list of irreducible Hecke-subspaces
        ? phi = L[1]; \\ one Galois orbit of newforms
        ? #phi[1] \\... this one is rational
        %4 = 1
        ? Mp = mspadicinit(M, 3, 4);
        ? mu = mspadicmoments(Mp, phi);
        ? mspadicL(mu)
        %7 = 1 + 3 + 3^3 + 3^4 + 2*3^5 + 3^6 + O(3^9)
        
        ? M = msinit(11,8, 1); \\ M_8(Gamma_0(11))^+
        ? Mp = mspadicinit(M, 3, 4);
        ? L = mssplit(M, msnew(M));
        ? phi = L[1]; #phi[1] \\ ... this one is two-dimensional
        %11 = 2
        ? mu = mspadicmoments(Mp, phi);
        *** at top-level: mu=mspadicmoments(Mp,ph
        *** ^--------------------
        *** mspadicmoments: incorrect type in mstooms [dim_Q (eigenspace) > 1]
        '''
        cdef bint _have_s = (s is not None)
        if _have_s:
            s = objtogen(s)
        sig_on()
        cdef GEN _mu = (<Gen>mu).g
        cdef GEN _s = NULL
        if _have_s:
            _s = (<Gen>s).g
        cdef GEN _ret = mspadicL(_mu, _s, r)
        return new_gen(_ret)

    def mspadicinit(M, long p, long n, long flag=-1):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`, and :math:`p`
        a prime, initialize technical data needed to compute with overconvergent
        modular symbols, modulo :math:`p^{n}`. If :math:`flag` is unset, allow
        all symbols; else initialize only for a restricted range of symbols
        depending on :math:`flag`: if :math:`flag = 0` restrict to ordinary symbols, else
        restrict to symbols :math:`\phi` such that :math:`T_{p}(\phi) = a_{p} \phi`,
        with :math:`v_{p}(a_{p}) >= flag`, which is faster as :math:`flag` increases.
        (The fastest initialization is obtained for :math:`flag = 0` where we only allow
        ordinary symbols.) For supersingular eigensymbols, such that :math:`p \| a_{p}`, we
        must further assume that :math:`p` does not divide the level.

        ::

        ? E = ellinit("11a1");
        ? [M,phi] = msfromell(E,1);
        ? ellap(E,3)
        %3 = -1
        ? Mp = mspadicinit(M, 3, 10, 0); \\ commit to ordinary symbols
        ? PHI = mstooms(Mp,phi);

        If we restrict the range of allowed symbols with :emphasis:`flag` (for faster
        initialization), exceptions will occur if :math:`v_{p}(a_{p})` violates this bound:

        ::

        ? E = ellinit("15a1");
        ? [M,phi] = msfromell(E,1);
        ? ellap(E,7)
        %3 = 0
        ? Mp = mspadicinit(M,7,5,0); \\ restrict to ordinary symbols
        ? PHI = mstooms(Mp,phi)
        *** at top-level: PHI=mstooms(Mp,phi)
        *** ^---------------
        *** mstooms: incorrect type in mstooms [v_p(ap) > mspadicinit flag] (t_VEC).
        ? Mp = mspadicinit(M,7,5); \\ no restriction
        ? PHI = mstooms(Mp,phi);

        This function uses :math:`O(N^{2}(n+k)^{2}p)` memory,
        where :math:`N` is the level of :math:`M`.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = mspadicinit(_M, p, n, flag)
        return new_gen(_ret)

    def mspadicmoments(Mp, PHI, long D=1):
        r'''
        Given :literal:`Mp` from :literal:`mspadicinit`, an overconvergent
        eigensymbol :literal:`PHI` from :literal:`mstooms` and a fundamental discriminant
        :math:`D` coprime to :math:`p`,
        let :math:`PHI^{D}` denote the twisted symbol. This function computes
        the distribution :math:`\mu = PHI^{D}([0] - oo ]) \| \mathbb{Z}_{p}^{*}`
        restricted
        to :math:`\mathbb{Z}_{p}^{*}`. More precisely, it returns
        the moments of the :math:`p-1` distributions :math:`PHI^{D}([0]-[ oo ])
        | (a + p\mathbb{Z}_{p})`, :math:`0 < a < p`.
        We also allow :literal:`PHI` to be given as a classical
        symbol, which is then lifted to an overconvergent symbol by :literal:`mstooms`;
        but this is wasteful if more than one twist is later needed.

        The returned data :math:`\mu` (:math:`p`-adic distributions attached to :literal:`PHI`)
        can then be used in :literal:`mspadicL` or :literal:`mspadicseries`.
        This precomputation allows to quickly compute derivatives of different
        orders or values at different characters.

        ::

        ? M = msinit(3,6, 1);
        ? phi = [5,-3,-1]~;
        ? msissymbol(M, phi)
        %3 = 1
        ? p = 5; mshecke(M,p) * phi \\ eigenvector of T_5, a_5 = 6
        %4 = [30, -18, -6]~
        ? Mp = mspadicinit(M, p, 10, 0); \\ restrict to ordinary symbols, mod p^10
        ? PHI = mstooms(Mp, phi);
        ? mu = mspadicmoments(Mp, PHI);
        ? mspadicL(mu)
        %8 = 5 + 2*5^2 + 2*5^3 + ...
        ? mu = mspadicmoments(Mp, PHI, 12); \\ twist by 12
        ? mspadicL(mu)
        %10 = 5 + 5^2 + 5^3 + 2*5^4 + ...
        '''
        PHI = objtogen(PHI)
        sig_on()
        cdef GEN _Mp = (<Gen>Mp).g
        cdef GEN _PHI = (<Gen>PHI).g
        cdef GEN _ret = mspadicmoments(_Mp, _PHI, D)
        return new_gen(_ret)

    def mspadicseries(mu, long i=0):
        r'''
        Let :math:`\Phi` be the :math:`p`-adic distribution-valued overconvergent symbol
        attached to a modular symbol :math:`\phi` for :math:`\Gamma_{0}(N)` (eigenvector for
        :math:`T_{N}(p)` for the eigenvalue :math:`a_{p}`).
        If :math:`\mu` is the distribution on :math:`\mathbb{Z}_{p}^{*}` defined by the restriction of
        :math:`\Phi ([ oo ]-[0])` to :math:`\mathbb{Z}_{p}^{*}`, let

        .. MATH::

        ^{L}_{p}(\mu,\tau^{i})(x)
        = \int_{\mathbb{Z}_{p}^{*}} \tau^{i}(t) (1+x)^{\log_{p}(t)/\log_{p}(u)}d\mu (t)

        Here, :math:`\tau` is the Teichmüller character and :math:`u` is a specific
        multiplicative generator of :math:`1+2p\mathbb{Z}_{p}`, namely :math:`1+p` if :math:`p > 2` or :math:`5`
        if :math:`p = 2`. To explain
        the formula, let :math:`G_{ oo } := Gal(\mathbb{Q} (\mu_{p^{ oo }})/ \mathbb{Q})`,
        let :math:`\chi:G_{ oo }\to \mathbb{Z}_{p}^{*}` be the cyclotomic character (isomorphism)
        and :math:`\gamma` the element of :math:`G_{ oo }` such that :math:`\chi (\gamma) = u`;
        then
        :math:`\chi (\gamma)^{\log_{p}(t)/\log_{p}(u)} = < t >`.

        The :math:`p`-padic precision of individual terms is maximal given the precision of
        the overconvergent symbol :math:`\mu`.

        ::

        ? [M,phi] = msfromell(ellinit("17a1"),1);
        ? Mp = mspadicinit(M, 5,7);
        ? mu = mspadicmoments(Mp, phi,1); \\ overconvergent symbol
        ? mspadicseries(mu)
        %4 = (4 + 3*5 + 4*5^2 + 2*5^3 + 2*5^4 + 5^5 + 4*5^6 + 3*5^7 + O(5^9)) \
        + (3 + 3*5 + 5^2 + 5^3 + 2*5^4 + 5^6 + O(5^7))*x \
        + (2 + 3*5 + 5^2 + 4*5^3 + 2*5^4 + O(5^5))*x^2 \
        + (3 + 4*5 + 4*5^2 + O(5^3))*x^3 \
        + (3 + O(5))*x^4 + O(x^5)

        An example with nonzero Teichmüller:

        ::

        ? [M,phi] = msfromell(ellinit("11a1"),1);
        ? Mp = mspadicinit(M, 3,10);
        ? mu = mspadicmoments(Mp, phi,1);
        ? mspadicseries(mu, 2)
        %4 = (2 + 3 + 3^2 + 2*3^3 + 2*3^5 + 3^6 + 3^7 + 3^10 + 3^11 + O(3^12)) \
        + (1 + 3 + 2*3^2 + 3^3 + 3^5 + 2*3^6 + 2*3^8 + O(3^9))*x \
        + (1 + 2*3 + 3^4 + 2*3^5 + O(3^6))*x^2 \
        + (3 + O(3^2))*x^3 + O(x^4)

        Supersingular example (not checked)

        ::

        ? E = ellinit("17a1"); ellap(E,3)
        %1 = 0
        ? [M,phi] = msfromell(E,1);
        ? Mp = mspadicinit(M, 3,7);
        ? mu = mspadicmoments(Mp, phi,1);
        ? mspadicseries(mu)
        %5 = [(2*3^-1 + 1 + 3 + 3^2 + 3^3 + 3^4 + 3^5 + 3^6 + O(3^7)) \
        + (2 + 3^3 + O(3^5))*x \
        + (1 + 2*3 + O(3^2))*x^2 + O(x^3),\
        (3^-1 + 1 + 3 + 3^2 + 3^3 + 3^4 + 3^5 + 3^6 + O(3^7)) \
        + (1 + 2*3 + 2*3^2 + 3^3 + 2*3^4 + O(3^5))*x \
        + (3^-2 + 3^-1 + O(3^2))*x^2 + O(3^-2)*x^3 + O(x^4)]

        Example with a twist:

        ::

        ? E = ellinit("11a1");
        ? [M,phi] = msfromell(E,1);
        ? Mp = mspadicinit(M, 3,10);
        ? mu = mspadicmoments(Mp, phi,5); \\ twist by 5
        ? L = mspadicseries(mu)
        %5 = (2*3^2 + 2*3^4 + 3^5 + 3^6 + 2*3^7 + 2*3^10 + O(3^12)) \
        + (2*3^2 + 2*3^6 + 3^7 + 3^8 + O(3^9))*x \
        + (3^3 + O(3^6))*x^2 + O(3^2)*x^3 + O(x^4)
        ? mspadicL(mu)
        %6 = [2*3^2 + 2*3^4 + 3^5 + 3^6 + 2*3^7 + 2*3^10 + O(3^12)]~
        ? ellpadicL(E,3,10,,5)
        %7 = 2 + 2*3^2 + 3^3 + 2*3^4 + 2*3^5 + 3^6 + 2*3^7 + O(3^10)
        ? mspadicseries(mu,1) \\ must be 0
        %8 = O(3^12) + O(3^9)*x + O(3^6)*x^2 + O(3^2)*x^3 + O(x^4)
        '''
        sig_on()
        cdef GEN _mu = (<Gen>mu).g
        cdef GEN _ret = mspadicseries(_mu, i)
        return new_gen(_ret)

    def mspathgens(M):
        r'''
        Let :math:`\Delta_{0} := Div^{0}(\mathbb{P}^{1}(\mathbb{Q}))`.
        Let :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        return a set of :math:`\mathbb{Z}[G]`-generators for :math:`\Delta_{0}`. The output
        is :math:`[g,R]`, where :math:`g` is a minimal system of generators and :math:`R`
        the vector of :math:`\mathbb{Z}[G]`-relations between the given generators. A
        relation is coded by a vector of pairs :math:`[a_{i},i]` with :math:`a_{i}\in \mathbb{Z}[G]`
        and :math:`i` the index of a generator, so that :math:`\sum_{i} a_{i} g[i] = 0`.

        An element :math:`[v]-[u]` in :math:`\Delta_{0}` is coded by the "path" :math:`[u,v]`,
        where :literal:`oo` denotes the point at infinity :math:`(1:0)` on the projective
        line.
        An element of :math:`\mathbb{Z}[G]` is either an integer :math:`n` (:math:`= n [id_{2}]`) or a
        "factorization matrix": the first column contains distinct elements :math:`g_{i}`
        of :math:`G` and the second integers :math:`n_{i}` and the matrix codes
        :math:`\sum_{i} n_{i} [g_{i}]`:

        ::

        ? M = msinit(11,8); \\ M_8(Gamma_0(11))
        ? [g,R] = mspathgens(M);
        ? g
        %3 = [[+oo, 0], [0, 1/3], [1/3, 1/2]] \\ 3 paths
        ? #R \\ a single relation
        %4 = 1
        ? r = R[1]; #r \\ ...involving all 3 generators
        %5 = 3
        ? r[1]
        %6 = [[1, 1; [1, 1; 0, 1], -1], 1]
        ? r[2]
        %7 = [[1, 1; [7, -2; 11, -3], -1], 2]
        ? r[3]
        %8 = [[1, 1; [8, -3; 11, -4], -1], 3]

        The given relation is of the form :math:`\sum_{i} (1-\gamma_{i}) g_{i} = 0`, with
        :math:`\gamma_{i}\in \Gamma_{0}(11)`. There will always be a single relation
        involving
        all generators (corresponding to a round trip along all cusps), then
        relations involving a single generator (corresponding to :math:`2` and :math:`3`-torsion
        elements in the group:

        ::

        ? M = msinit(2,8); \\ M_8(Gamma_0(2))
        ? [g,R] = mspathgens(M);
        ? g
        %3 = [[+oo, 0], [0, 1]]

        Note that the output depends only on the group :math:`G`, not on the
        representation :math:`V`.
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = mspathgens(_M)
        return new_gen(_ret)

    def mspathlog(M, p):
        r'''
        Let :math:`\Delta_{0} := Div^{0}(\mathbb{P}^{1}(\mathbb{Q}))`.
        Let :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        encoding fixed :math:`\mathbb{Z}[G]`-generators :math:`(g_{i})` of :math:`\Delta_{0}`
        (see :literal:`mspathgens`).
        A path :math:`p = [a,b]` between two elements in :math:`\mathbb{P}^{1}(\mathbb{Q})` corresponds to
        :math:`[b]-[a]\in \Delta_{0}`. The path extremities :math:`a` and :math:`b` may be given as
        :literal:`t_INT`, :literal:`t_FRAC` or :math:`oo = (1:0)`. Finally, we also allow
        to input a path as a :math:`2 x 2` integer matrix, whose first
        and second column give :math:`a` and :math:`b` respectively, with the convention
        :math:`[x,y]~ = (x:y)` in :math:`\mathbb{P}^{1}(\mathbb{Q})`.

        Returns :math:`(p_{i})` in :math:`\mathbb{Z}[G]` such that :math:`p = \sum_{i} p_{i} g_{i}`.

        ::

        ? M = msinit(2,8); \\ M_8(Gamma_0(2))
        ? [g,R] = mspathgens(M);
        ? g
        %3 = [[+oo, 0], [0, 1]]
        ? p = mspathlog(M, [1/2,2/3]);
        ? p[1]
        %5 =
        [[1, 0; 2, 1] 1]
        
        ? p[2]
        %6 =
        [[1, 0; 0, 1] 1]
        
        [[3, -1; 4, -1] 1]
        ? mspathlog(M, [1,2;2,3]) == p \\ give path via a 2x2 matrix
        %7 = 1

        Note that the output depends only on the group :math:`G`, not on the
        representation :math:`V`.
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = mspathlog(_M, _p)
        return new_gen(_ret)

    def mspetersson(M, F=None, G=None):
        r'''
        :math:`M` being a full modular symbol space for :math:`\Gamma = \Gamma_{0}(N)`,
        as given by :literal:`msinit`,
        calculate the intersection product :math:`{F, G}` of modular symbols :math:`F` and :math:`G`
        on :math:`M = \text{Hom}_{\Gamma}(\Delta_{0}, V_{k})` extended to an hermitian bilinear
        form on :math:`M \otimes \mathbb{C}` whose radical is the Eisenstein subspace of :math:`M`.

        Suppose that :math:`f_{1}` and :math:`f_{2}` are two parabolic forms. Let :math:`F_{1}`
        and :math:`F_{2}` be the attached modular symbols

        .. MATH::

        F_{i}(\delta) = \int_{\delta} f_{i}(z).(z X + Y)^{k-2} dz

        and let :math:`F^{\mathbb{R}}_{1}`, :math:`F^{\mathbb{R}}_{2}` be the attached real modular symbols

        .. MATH::

        F^{\mathbb{R}}_{i}(\delta) = \int_{\delta}
        \Re (f_{i}(z).(z X + Y)^{k-2} dz)

        Then we have

        .. MATH::

        \{ F^{\mathbb{R}}_{1}, F^{\mathbb{R}}_{2} } = -2 (2i)^{k-2}.
        \Im ( < f_{1},f_{2} > _{Petersson})

        and

        .. MATH::

        { F_{1}, \bar{F_{2}} } = (2i)^{k-2} < f_{1},f_{2} > _{Petersson}

        In weight 2, the intersection product :math:`{F, G}` has integer values on the
        :math:`\mathbb{Z}`-structure on :math:`M` given by :literal:`mslattice` and defines a Riemann form on
        :math:`H^{1}_{par}(\Gamma,\mathbb{R})`.

        For user convenience, we allow :math:`F` and :math:`G` to be matrices and return the
        attached Gram matrix. If :math:`F` is omitted: treat it as the full modular space
        attached to :math:`M`; if :math:`G` is omitted, take it equal to :math:`F`.

        ::

        ? M = msinit(37,2);
        ? C = mscuspidal(M)[1];
        ? mspetersson(M, C)
        %3 =
        [ 0 -17 -8 -17]
        [17 0 -8 -25]
        [ 8 8 0 -17]
        [17 25 17 0]
        ? mspetersson(M, mslattice(M,C))
        %4 =
        [0 -1 0 -1]
        [1 0 0 -1]
        [0 0 0 -1]
        [1 1 1 0]
        ? E = ellinit("33a1");
        ? [M,xpm] = msfromell(E); [xp,xm,L] = xpm;
        ? mspetersson(M, mslattice(M,L))
        %7 =
        [0 -3]
        [3 0]
        ? ellmoddegree(E)
        %8 = [3, -126]

        The coefficient :math:`3` in the matrix is the degree of the
        modular parametrization.
        '''
        cdef bint _have_F = (F is not None)
        if _have_F:
            F = objtogen(F)
        cdef bint _have_G = (G is not None)
        if _have_G:
            G = objtogen(G)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _F = NULL
        if _have_F:
            _F = (<Gen>F).g
        cdef GEN _G = NULL
        if _have_G:
            _G = (<Gen>G).g
        cdef GEN _ret = mspetersson(_M, _F, _G)
        return new_gen(_ret)

    def mspolygon(M, long flag=0):
        r'''
        :math:`M` describes a subgroup :math:`G` of finite index in the modular group
        :math:`PSL_{2}(\mathbb{Z})`, as given by :literal:`msinit` or a positive integer :math:`N`
        (encoding the group :math:`G = \Gamma_{0}(N)`), or by :literal:`msfarey` (arbitrary
        subgroup). Return an hyperbolic polygon (Farey symbol) attached to :math:`G`.
        More precisely:

        - Its vertices are an ordered list in :math:`\mathbb{P}^{1}(\mathbb{Q})` and contain
        a representatives of all cusps.

        - Its edges are hyperbolic arcs joining two consecutive vertices;
        each edge :math:`e` is labelled by an integer :math:`\mu (e) \in { oo ,2,3}`.

        - Given a path :math:`(a,b)` between two elements of :math:`\mathbb{P}^{1}(\mathbb{Q})`, let
        :math:`\overline{(a,b)} = (b,a)` be the opposite path. There is an involution :math:`e
        \to e^{*}` on the edges. We have :math:`\mu (e) = oo` if and only if :math:`e ! =
        e^{*}`;
        when :math:`\mu (e) ! = 3`, :math:`e` is :math:`G`-equivalent to :math:`\overline{e^{*}}`, i.e. there
        exists :math:`\gamma_{e} \in G` such that :math:`e = \gamma_{e} \overline{e^{*}}`;
        if :math:`\mu (e) = 3`
        there exists :math:`\gamma_{e} \in G` of order :math:`3` such that the hyperbolic triangle
        :math:`(e, \gamma_{e} e, \gamma_{e}^{2} e)` is invariant by :math:`\gamma_{e}`.
        In all cases,
        to each edge we have attached :math:`\gamma_{e} \in G` of order :math:`\mu (e)`.

        The polygon is given by a triple :math:`[E, A, g]`

        - The list :math:`E` of its consecutive edges as matrices in :math:`M_{2}(\mathbb{Z})`.

        - The permutation :math:`A` attached to the involution: if :math:`e = E[i]` is the
        :math:`i`-th edge, then :literal:`A[i]` is the index of :math:`e^{*}` in :math:`E`.

        - The list :math:`g` of pairing matrices :math:`\gamma_{e}`.
        Remark that :math:`\gamma_{e^{*}} = \gamma_{e}^{-1}` if :math:`\mu (e) ! = 3`,
        i.e., :math:`g[i]^{-1} = g[A[i]]` whenever :math:`i ! = A[i]` (:math:`\mu (g[i]) = 1`) or
        :math:`\mu (g[i]) = 2` (:math:`g[i]^{2} = 1`). Modulo these trivial relations,
        the pairing matrices form a system of independant generators of :math:`G`. Note
        that :math:`\gamma_{e}` is elliptic if and only if :math:`e^{*} = e`.

        The above data yields a fundamental domain for :math:`G` acting
        on Poincaré's half-plane: take the convex hull of the polygon defined by

        - The edges in :math:`E` such that :math:`e ! = e^{*}` or :math:`e^{*} = e`, where the pairing
        matrix :math:`\gamma_{e}` has order :math:`2`;

        - The edges :math:`(r,t)` and :math:`(t,s)` where the edge :math:`e = (r,s) \in E` is such
        that :math:`e = e^{*}` and :math:`\gamma_{e}` has order :math:`3` and the triangle :math:`(r,t,s)`
        is the image of :math:`(0,\exp (2i\pi/3), oo )` by some element of :math:`PSL_{2}(\mathbb{Q})`
        formed around the edge.

        Binary digits of flag mean:

        1: return a normalized hyperbolic polygon if set, else a polygon with
        unimodular edges (matrices of determinant :math:`1`). A polygon is normalized
        in the sense of compact orientable surfaces if the distance :math:`d(a,a^{*})`
        between
        an edge :math:`a` and its image by the involution :math:`a^{*}` is less than 2, with
        equality if and only if :math:`a` is :emphasis:`linked` with another edge :math:`b`
        (:math:`a`, :math:`b`, :math:`a^{*}` et :math:`b^{*}` appear consecutively in :math:`E` up to cyclic
        permutation). In particular, the vertices of all edges such that that
        :math:`d(a,a^{*}) ! = 1` (distance is 0 or 2) are all equivalent to :math:`0` modulo
        :math:`G`. The external vertices of :math:`a a^{*}` such that :math:`d(a,a^{*}) = 1` are
        also equivalent to :math:`0`; the internal vertices :math:`a\cap a^{*}` (a single point),
        together with :math:`0`, form a system of representatives of the cusps of
        :math:`G\\mathbb{P}^{1}(\mathbb{Q})`. This is useful to compute the homology group
        :math:`H_{1}(G,\mathbb{Z})` as it gives a symplectic basis for the intersection pairing.
        In this case, the number of parabolic matrices (trace 2) in the system of
        generators :math:`G` is :math:`2(t-1)`, where :math:`t` is the number of non equivalent cusps
        for :math:`G`. This is currently only implemented for :math:`G = \Gamma_{0}(N)`.

        2: add graphical representations (in LaTeX form) for the hyperbolic polygon
        in Poincaré's half-space and the involution :math:`a\to a^{*}` of the Farey symbol.
        The corresponding character strings can be included in a LaTeX document
        provided the preamble contains :literal:`\\usepackage{ tikz}`.

        ::

        ? [V,A,g] = mspolygon(3);
        ? V
        %2 = [[-1, 1; -1, 0], [1, 0; 0, 1], [0, 1; -1, 1]]
        ? A
        %3 = Vecsmall([2, 1, 3])
        ? g
        %4 = [[-1, -1; 0, -1], [1, -1; 0, 1], [1, -1; 3, -2]]
        ? [V,A,g, D1,D2] = mspolygon(11,2); \\ D1 and D2 contains pictures
        ? {write("F.tex",
        "\\documentclass{article}\\usepackage{tikz}\\begin{document}"
        D1, "\n", D2,
        "\\end{document}");}
        
        ? [V1,A1] = mspolygon(6,1); \\ normalized
        ? V1
        %8 = [[-1, 1; -1, 0], [1, 0; 0, 1], [0, 1; -1, 3],
        [1, -2; 3, -5], [-2, 1; -5, 2], [1, -1; 2, -1]]
        ? A1
        %9 = Vecsmall([2, 1, 4, 3, 6, 5])
        
        ? [V0,A0] = mspolygon(6); \\ not normalized V[3]^* = V[6], d(V[3],V[6]) = 3
        ? A0
        %11 = Vecsmall([2, 1, 6, 5, 4, 3])
        
        ? [V,A] = mspolygon(14, 1);
        ? A
        %13 = Vecsmall([2, 1, 4, 3, 6, 5, 9, 10, 7, 8])

        One can see from this last example that the (normalized) polygon has the form

        .. MATH::

        (a_{1}, a_{1}^{*}, a_{2}, a_{2}^{*}, a_{3}, a_{3}^{*}, a_{4}, a_{5}, a_{4}^{*}, a_{5}^{*}),

        that :math:`X_{0}(14)` is of genus 1 (in general the genus is the number of blocks
        of the form :math:`aba^{*}b^{*}`), has no elliptic points (:math:`A` has no fixed point)
        and 4 cusps (number of blocks of the form :math:`aa^{*}` plus 1). The vertices
        of edges :math:`a_{4}` and :math:`a_{5}` all project to :math:`0` in :math:`X_{0}(14)`: the paths :math:`a_{4}`
        and :math:`a_{5}` project as loops in :math:`X_{0}(14)` and give a symplectic basis of the
        homology :math:`H_{1}(X_{0}(14),\mathbb{Z})`.

        ::

        ? [V,A] = mspolygon(15);
        ? apply(matdet, V) \\ all unimodular
        %2 = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1]
        ? [V,A] = mspolygon(15,1);
        ? apply(matdet, V) \\ normalized polygon but no longer unimodular edges
        %4 = [1, 1, 1, 1, 2, 2, 47, 11, 47, 11]
        '''
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _ret = mspolygon(_M, flag)
        return new_gen(_ret)

    def msqexpansion(M, projH, long serprec=-1):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        and :emphasis:`projH` being a projector on a Hecke-simple subspace (as given
        by :literal:`mssplit`), return the Fourier coefficients :math:`a_{n}`, :math:`n <= B` of the
        corresponding normalized newform. If :math:`B` is omitted, use
        :literal:`seriesprecision`.

        This function uses a naive :math:`O(B^{2} d^{3})`
        algorithm, where :math:`d = O(kN)` is the dimension of :math:`M_{k}(\Gamma_{0}(N))`.

        ::

        ? M = msinit(11,2, 1); \\ M_2(Gamma_0(11))^+
        ? L = mssplit(M, msnew(M));
        ? msqexpansion(M,L[1], 20)
        %3 = [1, -2, -1, 2, 1, 2, -2, 0, -2, -2, 1, -2, 4, 4, -1, -4, -2, 4, 0, 2]
        ? ellan(ellinit("11a1"), 20)
        %4 = [1, -2, -1, 2, 1, 2, -2, 0, -2, -2, 1, -2, 4, 4, -1, -4, -2, 4, 0, 2]

        The shortcut :literal:`msqexpansion(M, s, B)` is available for
        a symbol :math:`s`, provided it is a Hecke eigenvector:

        ::

        ? E = ellinit("11a1");
        ? [M,S] = msfromell(E); [sp,sm] = S;
        ? msqexpansion(M,sp,10) \\ in the + eigenspace
        %3 = [1, -2, -1, 2, 1, 2, -2, 0, -2, -2]
        ? msqexpansion(M,sm,10) \\ in the - eigenspace
        %4 = [1, -2, -1, 2, 1, 2, -2, 0, -2, -2]
        ? ellan(E, 10)
        %5 = [1, -2, -1, 2, 1, 2, -2, 0, -2, -2]
        '''
        projH = objtogen(projH)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _projH = (<Gen>projH).g
        if serprec < 0:
            serprec = precdl  # Global PARI series precision
        cdef GEN _ret = msqexpansion(_M, _projH, serprec)
        return new_gen(_ret)

    def mssplit(M, H=None, long dimlim=0):
        r'''
        Let :math:`M` denote a full modular symbol space, as given by :literal:`msinit`:math:`(N,k,1)`
        or :math:`msinit (N,k,-1)` and let :math:`H` be a Hecke-stable subspace of
        :literal:`msnew`:math:`(M)` (the full new subspace if :math:`H` is omitted). This function
        splits :math:`H` into Hecke-simple subspaces. If :literal:`dimlim` is present and
        positive, restrict to subspaces of dimension :math:`<= dimlim`. A subspace
        is given by a structure allowing quick projection and restriction of linear
        operators; its first component is a matrix with integer coefficients whose
        columns form a :math:`\mathbb{Q}`-basis of the subspace.

        ::

        ? M = msinit(11,8, 1); \\ M_8(Gamma_0(11))^+
        ? L = mssplit(M); \\ split msnew(M)
        ? #L
        %3 = 2
        ? f = msqexpansion(M,L[1],5); f[1].mod
        %4 = x^2 + 8*x - 44
        ? lift(f)
        %5 = [1, x, -6*x - 27, -8*x - 84, 20*x - 155]
        ? g = msqexpansion(M,L[2],5); g[1].mod
        %6 = x^4 - 558*x^2 + 140*x + 51744

        To a Hecke-simple subspace corresponds an orbit of
        (normalized) newforms, defined over a number field. In the above example,
        we printed the polynomials defining the said fields, as well as the first
        5 Fourier coefficients (at the infinite cusp) of one such form.
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = mssplit(_M, _H, dimlim)
        return new_gen(_ret)

    def msstar(M, H=None):
        r'''
        :math:`M` being a full modular symbol space, as given by :literal:`msinit`,
        return the matrix of the :literal:`*` involution, induced by complex conjugation,
        acting on the (stable) subspace :math:`H` (:math:`M` if omitted).

        ::

        ? M = msinit(11,2); \\ M_2(Gamma_0(11))
        ? w = msstar(M);
        ? w^2 == 1
        %3 = 1
        '''
        cdef bint _have_H = (H is not None)
        if _have_H:
            H = objtogen(H)
        sig_on()
        cdef GEN _M = (<Gen>M).g
        cdef GEN _H = NULL
        if _have_H:
            _H = (<Gen>H).g
        cdef GEN _ret = msstar(_M, _H)
        return new_gen(_ret)

    def mstooms(Mp, phi):
        r'''
        Given :literal:`Mp` from :literal:`mspadicinit`, lift the (classical) eigen symbol
        :literal:`phi` to a :math:`p`-adic distribution-valued overconvergent symbol in the
        sense of Pollack and Stevens. More precisely, let :math:`\phi` belong to the space
        :math:`W` of modular symbols of level :math:`N`, :math:`v_{p}(N) <= 1`, and weight :math:`k` which is
        an eigenvector for the Hecke operator :math:`T_{N}(p)` for a nonzero eigenvalue
        :math:`a_{p}` and let :math:`N_{0} = lcm(N,p)`.

        Under the action of :math:`T_{N_{0}}(p)`, :math:`\phi` generates a subspace :math:`W_{\phi}` of
        dimension :math:`1` (if :math:`p \| N`) or :math:`2` (if :math:`p` does not divide :math:`N`) in the
        space of modular symbols of level :math:`N_{0}`.

        Let :math:`V_{p} = [p,0;0,1]` and :math:`C_{p} = [a_{p},p^{k-1};-1,0]`.
        When :math:`p` does not divide :math:`N` and :math:`a_{p}` is divisible by :math:`p`, :literal:`mstooms`
        returns the lift :math:`\Phi` of :math:`(\phi,\phi\|_{k} V_{p})` such that

        .. MATH::

        T_{N_{0}}(p) \Phi = C_{p} \Phi

        When :math:`p` does not divide :math:`N` and :math:`a_{p}` is not divisible by :math:`p`, :literal:`mstooms`
        returns the lift :math:`\Phi` of :math:`\phi - \alpha^{-1} \phi\|_{k} V_{p}`
        which is an eigenvector of :math:`T_{N_{0}}(p)` for the unit eigenvalue
        where :math:`\alpha^{2} - a_{p} \alpha + p^{k-1} = 0`.

        The resulting overconvergent eigensymbol can then be used in
        :literal:`mspadicmoments`, then :literal:`mspadicL` or :literal:`mspadicseries`.

        ::

        ? M = msinit(3,6, 1); p = 5;
        ? Tp = mshecke(M, p); factor(charpoly(Tp))
        %2 =
        [x - 3126 2]
        
        [ x - 6 1]
        ? phi = matker(Tp - 6)[,1] \\ generator of p-Eigenspace, a_p = 6
        %3 = [5, -3, -1]~
        ? Mp = mspadicinit(M, p, 10, 0); \\ restrict to ordinary symbols, mod p^10
        ? PHI = mstooms(Mp, phi);
        ? mu = mspadicmoments(Mp, PHI);
        ? mspadicL(mu)
        %7 = 5 + 2*5^2 + 2*5^3 + ...

        A non ordinary symbol.

        ::

        ? M = msinit(4,6,1); p = 3;
        ? Tp = mshecke(M, p); factor(charpoly(Tp))
        %2 =
        [x - 244 3]
        
        [ x + 12 1]
        ? phi = matker(Tp + 12)[,1] \\ a_p = -12 is divisible by p = 3
        %3 = [-1/32, -1/4, -1/32, 1]~
        ? msissymbol(M,phi)
        %4 = 1
        ? Mp = mspadicinit(M,3,5,0);
        ? PHI = mstooms(Mp,phi);
        *** at top-level: PHI=mstooms(Mp,phi)
        *** ^---------------
        *** mstooms: incorrect type in mstooms [v_p(ap) > mspadicinit flag] (t_VEC).
        ? Mp = mspadicinit(M,3,5,1);
        ? PHI = mstooms(Mp,phi);
        '''
        phi = objtogen(phi)
        sig_on()
        cdef GEN _Mp = (<Gen>Mp).g
        cdef GEN _phi = (<Gen>phi).g
        cdef GEN _ret = mstooms(_Mp, _phi)
        return new_gen(_ret)

    def newtonpoly(x, p):
        r'''
        Gives the vector of the slopes of the Newton
        polygon of the polynomial :math:`x` with respect to the prime number :math:`p`. The :math:`n`
        components of the vector are in decreasing order, where :math:`n` is equal to the
        degree of :math:`x`. Vertical slopes occur iff the constant coefficient of :math:`x` is
        zero and are denoted by :literal:`+oo`.
        '''
        p = objtogen(p)
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _p = (<Gen>p).g
        cdef GEN _ret = newtonpoly(_x, _p)
        return new_gen(_ret)

    def nextprime(x):
        r'''
        Finds the smallest pseudoprime (see
        :literal:`ispseudoprime`) greater than or equal to :math:`x`. :math:`x` can be of any real
        type. Note that if :math:`x` is a pseudoprime, this function returns :math:`x` and not
        the smallest pseudoprime strictly larger than :math:`x`. To rigorously prove that
        the result is prime, use :literal:`isprime`.

        ::

        ? nextprime(2)
        %1 = 2
        ? nextprime(Pi)
        %2 = 5
        ? nextprime(-10)
        %3 = 2 \\ primes are positive

        Despite the name, please note that the function is not guaranteed to return
        a prime number, although no counter-example is known at present. The return
        value :emphasis:`is` a guaranteed prime if :math:`x <= 2^{64}`. To rigorously prove
        that the result is prime in all cases, use :literal:`isprime`.
        '''
        sig_on()
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = nextprime(_x)
        return new_gen(_ret)

    def nfalgtobasis(nf, x):
        r'''
        Given an algebraic number :math:`x` in the number field :math:`nf`,
        transforms it to a column vector on the integral basis :literal:`:emphasis:`nf`.zk`.

        ::

        ? nf = nfinit(y^2 + 4);
        ? nf.zk
        %2 = [1, 1/2*y]
        ? nfalgtobasis(nf, [1,1]~)
        %3 = [1, 1]~
        ? nfalgtobasis(nf, y)
        %4 = [0, 2]~
        ? nfalgtobasis(nf, Mod(y, y^2+4))
        %5 = [0, 2]~

        This is the inverse function of :literal:`nfbasistoalg`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = algtobasis(_nf, _x)
        return new_gen(_ret)

    def nfbasis(T, dK=None):
        r'''
        Let :math:`T(X)` be an irreducible polynomial with integral coefficients. This
        function returns an integral basis of the number field defined by :math:`T`,
        that is a :math:`\mathbb{Z}`-basis of its maximal order. If present, :literal:`dK` is set
        to the discriminant of the returned order. The basis elements are given as
        elements in :math:`K = \mathbb{Q}[X]/(T)`, in Hermite normal form with respect to the
        :math:`\mathbb{Q}`-basis :math:`(1,X,...,X^{\deg T-1})` of :math:`K`, lifted to :math:`\mathbb{Q}[X]`.
        In particular its first element is always :math:`1` and its :math:`i`-th element is a
        polynomial of degree :math:`i-1` whose leading coefficient is the inverse of an
        integer: the product of those integers is the index of :math:`\mathbb{Z}[X]/(T)` in the
        maximal order :math:`\mathbb{Z}_{K}`:

        ::

        ? nfbasis(x^2 + 4) \\ Z[X]/(T) has index 2 in Z_K
        %1 = [1, x/2]
        ? nfbasis(x^2 + 4, &D)
        %2 = [1, x/2]
        ? D
        %3 = -4

        This function uses a modified version of the round 4 algorithm,
        due to David Ford, Sebastian Pauli and Xavier Roblot.

        :strong:`Local basis, orders maximal at certain primes.`

        Obtaining the maximal order is hard: it requires factoring the discriminant
        :math:`D` of :math:`T`. Obtaining an order which is maximal at a finite explicit set of
        primes is easy, but it may then be a strict suborder of the maximal order. To
        specify that we are interested in a given set of places only, we can replace
        the argument :math:`T` by an argument :math:`[T,listP]`, where :emphasis:`listP` encodes
        the primes we are interested in: it must be a factorization matrix, a vector
        of integers or a single integer.

        - Vector: we assume that it contains distinct :emphasis:`prime` numbers.

        - Matrix: we assume that it is a two-column matrix of a
        (partial) factorization of :math:`D`; namely the first column contains
        distinct :emphasis:`primes` and the second one the valuation of :math:`D` at each of
        these primes.

        - Integer :math:`B`: this is replaced by the vector of primes up to :math:`B`. Note
        that the function will use at least :math:`O(B)` time: a small value, about
        :math:`10^{5}`, should be enough for most applications. Values larger than :math:`2^{32}`
        are not supported.

        In all these cases, the primes may or may not divide the discriminant :math:`D`
        of :math:`T`. The function then returns a :math:`\mathbb{Z}`-basis of an order whose index is
        not divisible by any of these prime numbers. The result may actually be
        a global integral basis, in particular if all the prime divisors of the
        :emphasis:`field` discriminant are included, but this is not guaranteed!
        Note that :literal:`nfinit` has built-in support for such a check:

        ::

        ? K = nfinit([T, listP]);
        ? nfcertify(K) \\ we computed an actual maximal order
        %2 = [];

        The first line initializes a number field structure
        incorporating :literal:`nfbasis([T, listP]` in place of a proven integral basis.
        The second line certifies that the resulting structure is correct. This
        allows to create an :literal:`nf` structure attached to the number field :math:`K =
        \mathbb{Q}[X]/(T)`, when the discriminant of :math:`T` cannot be factored completely,
        whereas the prime divisors of :math:`\mathrm{disc} K` are known. If present, the argument
        :literal:`dK` is set to the discriminant of the returned order, and is
        equal to the field discriminant if and only if the order is maximal.

        Of course, if :emphasis:`listP` contains a single prime number :math:`p`,
        the function returns a local integral basis for :math:`\mathbb{Z}_{p}[X]/(T)`:

        ::

        ? nfbasis(x^2+x-1001)
        %1 = [1, 1/3*x - 1/3]
        ? nfbasis( [x^2+x-1001, [2]] )
        %2 = [1, x]

        The following function computes the index :math:`i_{T}`
        of :math:`\mathbb{Z}[X]/(T)` in the order generated by the :math:`\mathbb{Z}`-basis :math:`B`:

        ::

        nfbasisindex(T, B) = vecprod([denominator(pollead(Q)) | Q <- B]);

        In particular, :math:`B` is a basis of the maximal order
        if and only if :math:`poldisc (T) / i_{T}^{2}` is equal to the field
        discriminant. More generally, this formula gives the square of index of the
        order given by :math:`B` in :math:`\mathbb{Z}_{K}`. For instance, assume that :math:`P` is a vector
        of prime numbers containing (at least) all prime divisors of the field
        discriminant, then the following construct allows to provably compute the
        field discriminant and to check whether the returned basis is actually
        a basis of the maximal order

        ::

        ? B = nfbasis([T, P], &D);
        ? dK = sign(D) * vecprod([p^valuation(D,p) | p<-P]);
        ? dK * nfbasisindex(T, B)^2 == poldisc(T)

        The variable :literal:`dK` contains the field discriminant and
        the last command returns :math:`1` if and only if :math:`B` is a :math:`\mathbb{Z}`-basis of the
        maximal order. Of course, the :literal:`nfinit` / :literal:`nfcertify` approach is
        simpler, but it is also more costly.

        :strong:`The Buchmann-Lenstra algorithm.`

        We now complicate the picture: it is in fact allowed to include
        :emphasis:`composite` numbers instead of primes
        in :literal:`listP` (Vector or Matrix case), provided they are pairwise coprime.
        The result may still be a correct integral basis if
        the field discriminant factors completely over the actual primes in the
        list; again, this is not guaranteed. Adding a composite :math:`C` such that :math:`C^{2}`
        :emphasis:`divides` :math:`D` may help because when we consider :math:`C` as a prime and run
        the algorithm, two good things can happen: either we succeed in proving that
        no prime dividing :math:`C` can divide the index (without actually needing to find
        those primes), or the computation exhibits a nontrivial zero divisor,
        thereby factoring :math:`C` and we go on with the refined factorization. (Note that
        including a :math:`C` such that :math:`C^{2}` does not divide :math:`D` is useless.) If neither
        happen, then the computed basis need not generate the maximal order. Here is
        an example:

        ::

        ? B = 10^5;
        ? listP = factor(poldisc(T), B); \\ primes <= B dividing D + cofactor
        ? basis = nfbasis([T, listP], &D)

        If the computed discriminant :math:`D` factors completely
        over the primes less than :math:`B` (together with the primes contained in the
        :literal:`addprimes` table), then everything is certified: :math:`D` is the field
        discriminant and :literal:`basis` generates the maximal order.
        This can be tested as follows:

        ::

        F = factor(D, B); P = F[,1]; E = F[,2];
        for (i = 1, #P,
        if (P[i] > B && !isprime(P[i]), warning("nf may be incorrect")));

        This is a sufficient but not a necessary condition, hence the warning,
        instead of an error.

        The function :literal:`nfcertify` speeds up and automates the above process:

        ::

        ? B = 10^5;
        ? nf = nfinit([T, B]);
        ? nfcertify(nf)
        %3 = [] \\ nf is unconditionally correct
        ? [basis, disc] = [nf.zk, nf.disc];
        '''
        cdef bint _have_dK = (dK is not None)
        if _have_dK:
            raise NotImplementedError("optional argument dK not available")
        sig_on()
        cdef GEN _T = (<Gen>T).g
        cdef GEN * _dK = NULL
        cdef GEN _ret = nfbasis(_T, _dK)
        return new_gen(_ret)

    def nfbasistoalg(nf, x):
        r'''
        Given an algebraic number :math:`x` in the number field :emphasis:`nf`, transforms it
        into :literal:`t_POLMOD` form.

        ::

        ? nf = nfinit(y^2 + 4);
        ? nf.zk
        %2 = [1, 1/2*y]
        ? nfbasistoalg(nf, [1,1]~)
        %3 = Mod(1/2*y + 1, y^2 + 4)
        ? nfbasistoalg(nf, y)
        %4 = Mod(y, y^2 + 4)
        ? nfbasistoalg(nf, Mod(y, y^2+4))
        %5 = Mod(y, y^2 + 4)

        This is the inverse function of :literal:`nfalgtobasis`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = basistoalg(_nf, _x)
        return new_gen(_ret)

    def nfcertify(nf):
        r'''
        :math:`nf` being as output by
        :literal:`nfinit`, checks whether the integer basis is known unconditionally.
        This is in particular useful when the argument to :literal:`nfinit` was of the
        form :math:`[T, listP]`, specifying a finite list of primes when
        :math:`p`-maximality had to be proven, or a list of coprime integers to which
        Buchmann-Lenstra algorithm was to be applied.

        The function returns a vector of coprime composite integers. If this vector
        is empty, then :literal:`nf.zk` and :literal:`nf.disc` are correct. Otherwise, the
        result is dubious. In order to obtain a certified result, one must completely
        factor each of the given integers, then :literal:`addprime` each of their prime
        factors, then check whether :literal:`nfdisc(nf.pol)` is equal to :literal:`nf.disc`.
        '''
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _ret = nfcertify(_nf)
        return new_gen(_ret)

    def nfcompositum(nf, P, Q, long flag=0):
        r'''
        Let :emphasis:`nf` be a number field structure attached to the field :math:`K`
        and let :math:`P` and :math:`Q`
        be squarefree polynomials in :math:`K[X]` in the same variable. Outputs
        the simple factors of the étale :math:`K`-algebra :math:`A = K[X, Y] / (P(X), Q(Y))`.
        The factors are given by a list of polynomials :math:`R` in :math:`K[X]`, attached to
        the number field :math:`K[X]/ (R)`, and sorted by increasing degree (with respect
        to lexicographic ordering for factors of equal degrees). Returns an error if
        one of the polynomials is not squarefree.

        Note that it is more efficient to reduce to the case where :math:`P` and :math:`Q` are
        irreducible first. The routine will not perform this for you, since it may be
        expensive, and the inputs are irreducible in most applications anyway. In
        this case, there will be a single factor :math:`R` if and only if the number
        fields defined by :math:`P` and :math:`Q` are linearly disjoint (their intersection is
        :math:`K`).

        The binary digits of :math:`flag` mean

        1: outputs a vector of 4-component vectors :math:`[R,a,b,k]`, where :math:`R`
        ranges through the list of all possible compositums as above, and :math:`a`
        (resp. :math:`b`) expresses the root of :math:`P` (resp. :math:`Q`) as an element of
        :math:`K[X]/(R)`. Finally, :math:`k` is a small integer such that :math:`b + ka = X` modulo
        :math:`R`.

        2: assume that :math:`P` and :math:`Q` define number fields that are linearly disjoint:
        both polynomials are irreducible and the corresponding number fields
        have no common subfield besides :math:`K`. This allows to save a costly
        factorization over :math:`K`. In this case return the single simple factor
        instead of a vector with one element.

        A compositum is often defined by a complicated polynomial, which it is
        advisable to reduce before further work. Here is an example involving
        the field :math:`K(\zeta_{5}, 5^{1/10})`, :math:`K = \mathbb{Q} (\sqrt{5})`:

        ::

        ? K = nfinit(y^2-5);
        ? L = nfcompositum(K, x^5 - y, polcyclo(5), 1); \\ list of [R,a,b,k]
        ? [R, a] = L[1]; \\ pick the single factor, extract R,a (ignore b,k)
        ? lift(R) \\ defines the compositum
        %4 = x^10 + (-5/2*y + 5/2)*x^9 + (-5*y + 20)*x^8 + (-20*y + 30)*x^7 + \
        (-45/2*y + 145/2)*x^6 + (-71/2*y + 121/2)*x^5 + (-20*y + 60)*x^4 + \
        (-25*y + 5)*x^3 + 45*x^2 + (-5*y + 15)*x + (-2*y + 6)
        ? a^5 - y \\ a fifth root of y
        %5 = 0
        ? [T, X] = rnfpolredbest(K, R, 1);
        ? lift(T) \\ simpler defining polynomial for K[x]/(R)
        %7 = x^10 + (-11/2*y + 25/2)
        ? liftall(X) \\  root of R in K[x]/(T(x))
        %8 = (3/4*y + 7/4)*x^7 + (-1/2*y - 1)*x^5 + 1/2*x^2 + (1/4*y - 1/4)
        ? a = subst(a.pol, 'x, X); \\ a in the new coordinates
        ? liftall(a)
        %10 = (-3/4*y - 7/4)*x^7 - 1/2*x^2
        ? a^5 - y
        %11 = 0

        The main variables of :math:`P` and :math:`Q` must be the same and have higher priority
        than that of :emphasis:`nf` (see :literal:`varhigher` and :literal:`varlower`).
        '''
        P = objtogen(P)
        Q = objtogen(Q)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _P = (<Gen>P).g
        cdef GEN _Q = (<Gen>Q).g
        cdef GEN _ret = nfcompositum(_nf, _P, _Q, flag)
        return new_gen(_ret)

    def nfdetint(nf, x):
        r'''
        Given a pseudo-matrix :math:`x`, computes a
        nonzero ideal contained in (i.e. multiple of) the determinant of :math:`x`. This
        is particularly useful in conjunction with :literal:`nfhnfmod`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = nfdetint(_nf, _x)
        return new_gen(_ret)

    def nfdisc(T):
        r'''
        field discriminant of the number field defined by the integral,
        preferably monic, irreducible polynomial :math:`T(X)`. Returns the discriminant of
        the number field :math:`\mathbb{Q}[X]/(T)`, using the Round :math:`4` algorithm.

        :strong:`Local discriminants, valuations at certain primes.`

        As in :literal:`nfbasis`, the argument :math:`T` can be replaced by :math:`[T,listP]`,
        where :literal:`listP` is as in :literal:`nfbasis`: a vector of pairwise coprime
        integers (usually distinct primes), a factorization matrix, or a single
        integer. In that case, the function returns the discriminant of an order
        whose basis is given by :literal:`nfbasis(T,listP)`, which need not be the maximal
        order, and whose valuation at a prime entry in :literal:`listP` is the same as the
        valuation of the field discriminant.

        In particular, if :literal:`listP` is :math:`[p]` for a prime :math:`p`, we can
        return the :math:`p`-adic discriminant of the maximal order of :math:`\mathbb{Z}_{p}[X]/(T)`,
        as a power of :math:`p`, as follows:

        ::

        ? padicdisc(T,p) = p^valuation(nfdisc([T,[p]]), p);
        ? nfdisc(x^2 + 6)
        %2 = -24
        ? padicdisc(x^2 + 6, 2)
        %3 = 8
        ? padicdisc(x^2 + 6, 3)
        %4 = 3

        The following function computes the discriminant of the
        maximal order under the assumption that :math:`P` is a vector of prime numbers
        containing (at least) all prime divisors of the field discriminant:

        ::

        globaldisc(T, P) =
        { my (D = nfdisc([T, P]));
        sign(D) * vecprod([p^valuation(D,p) | p <-P]);
        }
        ? globaldisc(x^2 + 6, [2, 3, 5])
        %1 = -24
        '''
        sig_on()
        cdef GEN _T = (<Gen>T).g
        cdef GEN _ret = nfdisc(_T)
        return new_gen(_ret)

    def nfdiscfactors(T):
        r'''
        Given a polynomial :math:`T` with integer coefficients, return
        :math:`[D, faD]` where :math:`D` is :literal:`nfdisc`:math:`(T)` and
        :emphasis:`faD` is the factorization of :math:`\|D\|`. All the variants :literal:`[T,listP]`
        are allowed (see :literal:`??nfdisc`), in which case :emphasis:`faD` is the
        factorization of the discriminant underlying order (which need not be maximal
        at the primes not specified by :literal:`listP`) and the factorization may
        contain large composites.

        ::

        ? T = x^3 - 6021021*x^2 + 12072210077769*x - 8092423140177664432;
        ? [D,faD] = nfdiscfactors(T); print(faD); D
        [3, 3; 500009, 2]
        %2 = -6750243002187]
        
        ? T = x^3 + 9*x^2 + 27*x - 125014250689643346789780229390526092263790263725;
        ? [D,faD] = nfdiscfactors(T); print(faD); D
        [3, 3; 1000003, 2]
        %4 = -27000162000243
        
        ? [D,faD] = nfdiscfactors([T, 10^3]); print(faD)
        [3, 3; 125007125141751093502187, 2]

        In the final example, we only get a partial factorization,
        which is only guaranteed correct at primes :math:`<= 10^{3}`.

        The function also accept number field structures, for instance as output by
        :literal:`nfinit`, and returns the field discriminant and its factorization:

        ::

        ? T = x^3 + 9*x^2 + 27*x - 125014250689643346789780229390526092263790263725;
        ? nf = nfinit(T); [D,faD] = nfdiscfactors(T); print(faD); D
        %2 = -27000162000243
        ? nf.disc
        %3 = -27000162000243
        '''
        sig_on()
        cdef GEN _T = (<Gen>T).g
        cdef GEN _ret = nfdiscfactors(_T)
        return new_gen(_ret)

    def nfeltadd(nf, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in
        :emphasis:`nf`, computes their sum :math:`x+y` in the number field :math:`nf`.

        ::

        ? nf = nfinit(1+x^2);
        ? nfeltadd(nf, 1, x) \\ 1 + I
        %2 = [1, 1]~
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = nfadd(_nf, _x, _y)
        return new_gen(_ret)

    def nfeltdiv(nf, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in
        :emphasis:`nf`, computes their quotient :math:`x/y` in the number field :math:`nf`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = nfdiv(_nf, _x, _y)
        return new_gen(_ret)

    def nfeltdiveuc(nf, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in
        :emphasis:`nf`, computes an algebraic integer :math:`q` in the number field :math:`nf`
        such that the components of :math:`x-qy` are reasonably small. In fact, this is
        functionally identical to :literal:`round(nfdiv(:emphasis:`nf`,x,y))`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = nfdiveuc(_nf, _x, _y)
        return new_gen(_ret)

    def nfeltdivmodpr(nf, x, y, pr):
        r'''
        This function is obsolete, use :literal:`nfmodpr`.

        Given two elements :math:`x`
        and :math:`y` in :emphasis:`nf` and :emphasis:`pr` a prime ideal in :literal:`modpr` format (see
        :literal:`nfmodprinit`), computes their quotient :math:`x / y` modulo the prime ideal
        :emphasis:`pr`.
        '''
        from warnings import warn
        warn('the PARI/GP function nfeltdivmodpr is obsolete (2016-08-09)', DeprecationWarning)
        x = objtogen(x)
        y = objtogen(y)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = nfdivmodpr(_nf, _x, _y, _pr)
        return new_gen(_ret)

    def nfeltdivrem(nf, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in
        :emphasis:`nf`, gives a two-element row vector :math:`[q,r]` such that :math:`x = qy+r`, :math:`q` is
        an algebraic integer in :math:`nf`, and the components of :math:`r` are
        reasonably small.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = nfdivrem(_nf, _x, _y)
        return new_gen(_ret)

    def nfeltembed(nf, x, pl=None, long precision=DEFAULT_BITPREC):
        r'''
        Given an element :math:`x` in the number field :emphasis:`nf`, return
        the (real or) complex embeddings of :math:`x` specified by optional argument
        :emphasis:`pl`, at the current :literal:`realprecision`:

        - :emphasis:`pl` omitted: return the vector of embeddings at all :math:`r_{1}+r_{2}`
        places;

        - :emphasis:`pl` an integer between :math:`1` and :math:`r_{1}+r_{2}`: return the
        :math:`i`-th embedding of :math:`x`, attached to the :math:`i`-th root of :literal:`nf.pol`,
        i.e. :literal:`nf.roots:math:`[i]``;

        - :emphasis:`pl` a vector or :literal:`t_VECSMALL`: return the vector of embeddings; the :math:`i`-th
        entry gives the embedding at the place attached to the :math:`pl[i]`-th real
        root of :literal:`nf.pol`.

        ::

        ? nf = nfinit('y^3 - 2);
        ? nf.sign
        %2 = [1, 1]
        ? nfeltembed(nf, 'y)
        %3 = [1.25992[...], -0.62996[...] + 1.09112[...]*I]]
        ? nfeltembed(nf, 'y, 1)
        %4 = 1.25992[...]
        ? nfeltembed(nf, 'y, 3) \\ there are only 2 arch. places
        *** at top-level: nfeltembed(nf,'y,3)
        *** ^-----------------
        *** nfeltembed: domain error in nfeltembed: index > 2
        '''
        x = objtogen(x)
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        precision = nbits2prec(precision)
        cdef GEN _ret = nfeltembed(_nf, _x, _pl, precision)
        return new_gen(_ret)

    def nfeltispower(nf, x, long n, y=None):
        r'''
        Returns :math:`1` if :math:`x` is an :math:`n`-th power in the number field :literal:`nf` (and sets :math:`y` to an :math:`n`-th root if the
        argument is present), else returns 0.

        ::

        ? nf = nfinit(1+x^2);
        ? nfeltispower(nf, -4, 4, &y)
        %2 = 1
        ? y
        %3 = [-1, -1]~
        '''
        x = objtogen(x)
        cdef bint _have_y = (y is not None)
        if _have_y:
            raise NotImplementedError("optional argument y not available")
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _y = NULL
        cdef long _ret = nfispower(_nf, _x, n, _y)
        clear_stack()
        return _ret

    def nfeltissquare(nf, x, y=None):
        r'''
        Returns :math:`1` if :math:`x` is a square in :literal:`nf` (and sets :math:`y` to a square root if the
        argument is present), else returns 0.

        ::

        ? nf = nfinit(1+x^2);
        ? nfeltissquare(nf, -1, &y)
        %2 = 1
        ? y
        %3 = [0, -1]~
        '''
        x = objtogen(x)
        cdef bint _have_y = (y is not None)
        if _have_y:
            raise NotImplementedError("optional argument y not available")
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN * _y = NULL
        cdef long _ret = nfissquare(_nf, _x, _y)
        clear_stack()
        return _ret

    def nfeltmod(nf, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in
        :emphasis:`nf`, computes an element :math:`r` of :math:`nf` of the form :math:`r = x-qy` with
        :math:`q` and algebraic integer, and such that :math:`r` is small. This is functionally
        identical to

        .. MATH::

        x - nfmul(nf,round(nfdiv(nf,x,y)),y).
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = nfmod(_nf, _x, _y)
        return new_gen(_ret)

    def nfeltmul(nf, x, y):
        r'''
        Given two elements :math:`x` and :math:`y` in :emphasis:`nf`, computes their product :math:`x*y`
        in the number field :math:`nf`.
        '''
        x = objtogen(x)
        y = objtogen(y)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _ret = nfmul(_nf, _x, _y)
        return new_gen(_ret)

    def nfeltmulmodpr(nf, x, y, pr):
        r'''
        This function is obsolete, use :literal:`nfmodpr`.

        Given two elements :math:`x` and
        :math:`y` in :emphasis:`nf` and :emphasis:`pr` a prime ideal in :literal:`modpr` format (see
        :literal:`nfmodprinit`), computes their product :math:`x*y` modulo the prime ideal
        :emphasis:`pr`.
        '''
        from warnings import warn
        warn('the PARI/GP function nfeltmulmodpr is obsolete (2016-08-09)', DeprecationWarning)
        x = objtogen(x)
        y = objtogen(y)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _y = (<Gen>y).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = nfmulmodpr(_nf, _x, _y, _pr)
        return new_gen(_ret)

    def nfeltnorm(nf, x):
        r'''
        Returns the absolute norm of :math:`x`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = nfnorm(_nf, _x)
        return new_gen(_ret)

    def nfeltpow(nf, x, k):
        r'''
        Given an element :math:`x` in :emphasis:`nf`, and a positive or negative integer :math:`k`,
        computes :math:`x^{k}` in the number field :math:`nf`.
        '''
        x = objtogen(x)
        k = objtogen(k)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _k = (<Gen>k).g
        cdef GEN _ret = nfpow(_nf, _x, _k)
        return new_gen(_ret)

    def nfeltpowmodpr(nf, x, k, pr):
        r'''
        This function is obsolete, use :literal:`nfmodpr`.

        Given an element :math:`x` in :emphasis:`nf`, an integer :math:`k` and a prime ideal
        :emphasis:`pr` in :literal:`modpr` format
        (see :literal:`nfmodprinit`), computes :math:`x^{k}` modulo the prime ideal :emphasis:`pr`.
        '''
        from warnings import warn
        warn('the PARI/GP function nfeltpowmodpr is obsolete (2016-08-09)', DeprecationWarning)
        x = objtogen(x)
        k = objtogen(k)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _k = (<Gen>k).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = nfpowmodpr(_nf, _x, _k, _pr)
        return new_gen(_ret)

    def nfeltreduce(nf, a, id):
        r'''
        Given an ideal :emphasis:`id` in
        Hermite normal form and an element :math:`a` of the number field :math:`nf`,
        finds an element :math:`r` in :math:`nf` such that :math:`a-r` belongs to the ideal
        and :math:`r` is small.
        '''
        a = objtogen(a)
        id = objtogen(id)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _a = (<Gen>a).g
        cdef GEN _id = (<Gen>id).g
        cdef GEN _ret = nfreduce(_nf, _a, _id)
        return new_gen(_ret)

    def nfeltreducemodpr(nf, x, pr):
        r'''
        This function is obsolete, use :literal:`nfmodpr`.

        Given an element :math:`x` of the number field :math:`nf` and a prime ideal
        :emphasis:`pr` in :literal:`modpr` format compute a canonical representative for the
        class of :math:`x` modulo :emphasis:`pr`.
        '''
        from warnings import warn
        warn('the PARI/GP function nfeltreducemodpr is obsolete (2016-08-09)', DeprecationWarning)
        x = objtogen(x)
        pr = objtogen(pr)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN _ret = nfreducemodpr(_nf, _x, _pr)
        return new_gen(_ret)

    def nfeltsign(nf, x, pl=None):
        r'''
        Given an element :math:`x` in the number field :emphasis:`nf`, returns the signs of
        the real embeddings of :math:`x` specified by optional argument :emphasis:`pl`:

        - :emphasis:`pl` omitted: return the vector of signs at all :math:`r_{1}` real places;

        - :emphasis:`pl` an integer between :math:`1` and :math:`r_{1}`: return the sign of the
        :math:`i`-th embedding of :math:`x`, attached to the :math:`i`-th real root of :literal:`nf.pol`,
        i.e. :literal:`nf.roots:math:`[i]``;

        - :emphasis:`pl` a vector or :literal:`t_VECSMALL`: return the vector of signs; the :math:`i`-th
        entry gives the sign at the real place attached to the :math:`pl[i]`-th real
        root of :literal:`nf.pol`.

        ::

        ? nf = nfinit(polsubcyclo(11,5,'y)); \\ Q(cos(2 pi/11))
        ? nf.sign
        %2 = [5, 0]
        ? x = Mod('y, nf.pol);
        ? nfeltsign(nf, x)
        %4 = [-1, -1, -1, 1, 1]
        ? nfeltsign(nf, x, 1)
        %5 = -1
        ? nfeltsign(nf, x, [1..4])
        %6 = [-1, -1, -1, 1]
        ? nfeltsign(nf, x, 6) \\ there are only 5 real embeddings
        *** at top-level: nfeltsign(nf,x,6)
        *** ^-----------------
        *** nfeltsign: domain error in nfeltsign: index > 5
        '''
        x = objtogen(x)
        cdef bint _have_pl = (pl is not None)
        if _have_pl:
            pl = objtogen(pl)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _pl = NULL
        if _have_pl:
            _pl = (<Gen>pl).g
        cdef GEN _ret = nfeltsign(_nf, _x, _pl)
        return new_gen(_ret)

    def nfelttrace(nf, x):
        r'''
        Returns the absolute trace of :math:`x`.
        '''
        x = objtogen(x)
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _ret = nftrace(_nf, _x)
        return new_gen(_ret)

    def nfeltval(nf, x, pr, y=None):
        r'''
        Given an element :math:`x` in
        :emphasis:`nf` and a prime ideal :emphasis:`pr` in the format output by
        :literal:`idealprimedec`, computes the valuation :math:`v` at :emphasis:`pr` of the
        element :math:`x`. The valuation of :math:`0` is :literal:`+oo`.

        ::

        ? nf = nfinit(x^2 + 1);
        ? P = idealprimedec(nf, 2)[1];
        ? nfeltval(nf, x+1, P)
        %3 = 1

        This particular valuation can also be obtained using
        :literal:`idealval(:emphasis:`nf`,x,:emphasis:`pr`)`, since :math:`x` is then converted to a
        principal ideal.

        If the :math:`y` argument is present, sets :math:`y = x \tau^{v}`, where :math:`\tau` is a
        fixed "anti-uniformizer" for :emphasis:`pr`: its valuation at :emphasis:`pr` is :math:`-1`;
        its valuation is :math:`0` at other prime ideals dividing :literal:`:emphasis:`pr`.p` and
        nonnegative at all other primes. In other words :math:`y` is the part of :math:`x`
        coprime to :emphasis:`pr`. If :math:`x` is an algebraic integer, so is :math:`y`.

        ::

        ? nfeltval(nf, x+1, P, &y); y
        %4 = [0, 1]~

        For instance if :math:`x = \prod_{i} x_{i}^{e_{i}}` is known to be coprime to
        :emphasis:`pr`, where the :math:`x_{i}` are algebraic integers and :math:`e_{i}\in\mathbb{Z}` then,
        if :math:`v_{i} = nfeltval (nf, x_{i}, pr, &y_{i})`, we still
        have :math:`x = \prod_{i} y_{i}^{e_{i}}`, where the :math:`y_{i}` are still algebraic
        integers but now all of them are coprime to :emphasis:`pr`. They can then be
        mapped to the residue field of :emphasis:`pr` more efficiently than if the product
        had been expanded beforehand: we can reduce mod :emphasis:`pr` after each ring
        operation.
        '''
        x = objtogen(x)
        pr = objtogen(pr)
        cdef bint _have_y = (y is not None)
        if _have_y:
            raise NotImplementedError("optional argument y not available")
        sig_on()
        cdef GEN _nf = (<Gen>nf).g
        cdef GEN _x = (<Gen>x).g
        cdef GEN _pr = (<Gen>pr).g
        cdef GEN * _y = NULL
        cdef GEN _ret = gpnfvalrem(_nf, _x, _pr, _y)
        return new_gen(_ret)

    def nffactor(nf, T):
        r'''
        Factorization of the univariate
        polynomial (or rational function) :math:`T` over the number field :math:`nf` given
        by :literal:`nfinit`; :math:`T` has coefficients in :math:`nf` (i.e. either scalar,
        polmod, polynomial or column vector). The factors are sorted by increasing
        degree.

        The main variable of :math:`nf` must be of :emphasis:`lower`
        priority than that of :math:`T`, see ``priority`` (in the PARI manual). However if
        the polynomial defining the number field occurs explicitly in the
        coefficients of :math:`T` as modulus of a :literal:`t_POLMOD` or as a :literal:`t_POL`
        coefficient, its main variable must be :emphasis:`the same` as the main variable
        of :math:`T`. For example,

        ::

        ? nf = nfinit(y^2 + 1);
        ? nffactor(nf, x^2 + y); \\ OK
        ? nffactor(nf, x^2 + Mod(y, y^2+1)); \\  OK
        ? nffactor(nf, x^2 + Mod(z, z^2+1)); \\  WRONG

        It is possible to input a defining polynomial for :emphasis:`nf`
        instead, but this is in general less efficient since parts of an :literal:`nf`
        structure will then be computed internally. This is useful in two
        situations: when you do not need the :literal:`nf` elsewhere, or when you cannot
        initialize an :literal:`nf` due to integer factorization difficulties when
        attempting to compute the field discriminant and maximal order. In all
        cases, the function runs in polynomial time using Belabas's variant
        of van Hoeij's algorithm, which copes with hundreds of modular factors.

        :strong:`Caveat.` :literal:`nfinit([T, listP])` allows to compute in polynomial
        time a conditional :emphasis:`nf` structure, which sets :literal:`nf.zk` to an order
        which is not guaranteed to be maximal at all primes. Always either use
        :literal:`nfcertify` first (which may not run in polynomial time) or make sure
        to input :literal:`nf.pol` instead of the conditional :emphasis:`nf`: :literal:`nffactor` is
        able to recover in polynomia