/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.FunctionsSet;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorProcedure
extends AbstractCodeIterator {
    private final FunctionsSet functionsSet;
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorProcedure(CodeIterator source, TContext context, TMemory memory, FunctionsSet functionsSet, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.functionsSet = functionsSet;
        this.logs = logs;
        this.memory = memory;
    }

    @Override
    public StringLocated peek() throws EaterException {
        StringLocated result;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            if (this.functionsSet.pendingFunction() != null && (this.functionsSet.pendingFunction().getFunctionType() == TFunctionType.PROCEDURE || this.functionsSet.pendingFunction().getFunctionType() == TFunctionType.LEGACY_DEFINELONG)) {
                this.logs.add(result);
                if (result.getType() == TLineType.END_FUNCTION) {
                    this.functionsSet.executeEndfunction();
                } else {
                    this.functionsSet.pendingFunction().addBody(result);
                }
                this.next();
                continue;
            }
            if (result.getType() != TLineType.DECLARE_PROCEDURE) break;
            this.logs.add(result);
            this.functionsSet.executeDeclareProcedure(this.context, this.memory, result);
            this.next();
        }
        return result;
    }
}

