/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.ExecutionContexts;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryGlobal;
import net.sourceforge.plantuml.tim.TVariableScope;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.TrieImpl;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.utils.Log;

public class TMemoryLocal
extends ExecutionContexts
implements TMemory {
    private final TMemoryGlobal memoryGlobal;
    private TrieImpl overridenVariables00;
    private final Map<String, TValue> overridenVariables01 = new HashMap<String, TValue>();
    private final TrieImpl localVariables00 = new TrieImpl();
    private final Map<String, TValue> localVariables01 = new HashMap<String, TValue>();

    public TMemoryLocal(TMemoryGlobal global, Map<String, TValue> input) {
        this.memoryGlobal = global;
        this.overridenVariables01.putAll(input);
    }

    @Override
    public void dumpDebug(String message) {
        Log.error("[MemLocal] Start of memory_dump " + message);
        this.memoryGlobal.dumpMemoryInternal();
        TreeMap<String, TValue> over = new TreeMap<String, TValue>(this.overridenVariables01);
        Log.error("[MemLocal] Number of overriden variable(s) : " + over.size());
        for (Map.Entry<String, TValue> ent : over.entrySet()) {
            String name = ent.getKey();
            TValue value = ent.getValue();
            Log.error("[MemLocal] " + name + " = " + value);
        }
        TreeMap<String, TValue> local = new TreeMap<String, TValue>(this.localVariables01);
        Log.error("[MemLocal] Number of local variable(s) : " + local.size());
        for (Map.Entry<String, TValue> ent : local.entrySet()) {
            String name = ent.getKey();
            TValue value = ent.getValue();
            Log.error("[MemLocal] " + name + " = " + value);
        }
        Log.error("[MemGlobal] End of memory_dump");
    }

    @Override
    public void putVariable(String varname, TValue value, TVariableScope scope, StringLocated location) throws EaterException {
        if (scope == TVariableScope.GLOBAL) {
            this.memoryGlobal.putVariable(varname, value, scope, location);
            return;
        }
        if (scope == TVariableScope.LOCAL || this.overridenVariables01.containsKey(varname)) {
            this.overridenVariables01.put(varname, value);
            if (this.overridenVariables00 != null) {
                this.overridenVariables00.add(varname);
            }
            Log.info(() -> "[MemLocal/overrriden] Setting " + varname);
        } else if (this.memoryGlobal.getVariable(varname) != null) {
            this.memoryGlobal.putVariable(varname, value, scope, location);
        } else {
            this.localVariables01.put(varname, value);
            this.localVariables00.add(varname);
            Log.info(() -> "[MemLocal/local] Setting " + varname);
        }
    }

    @Override
    public void removeVariable(String varname) {
        if (this.overridenVariables01.containsKey(varname)) {
            this.overridenVariables01.remove(varname);
            if (this.overridenVariables00 != null) {
                this.overridenVariables00.remove(varname);
            }
        } else if (this.memoryGlobal.getVariable(varname) != null) {
            this.memoryGlobal.removeVariable(varname);
        } else {
            this.localVariables01.remove(varname);
            this.localVariables00.remove(varname);
        }
    }

    @Override
    public TValue getVariable(String varname) {
        TValue result = this.overridenVariables01.get(varname);
        if (result != null) {
            return result;
        }
        result = this.memoryGlobal.getVariable(varname);
        if (result != null) {
            return result;
        }
        result = this.localVariables01.get(varname);
        return result;
    }

    @Override
    public Trie variablesNames3() {
        if (this.overridenVariables00 == null) {
            this.overridenVariables00 = new TrieImpl();
            for (String name : this.overridenVariables01.keySet()) {
                this.overridenVariables00.add(name);
            }
        }
        return new Trie(){

            @Override
            public void add(String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getLonguestMatchStartingIn(String s, int pos) {
                String s1 = TMemoryLocal.this.memoryGlobal.variablesNames3().getLonguestMatchStartingIn(s, pos);
                String s2 = TMemoryLocal.this.overridenVariables00.getLonguestMatchStartingIn(s, pos);
                String s3 = TMemoryLocal.this.localVariables00.getLonguestMatchStartingIn(s, pos);
                if (s1.length() >= s2.length() && s1.length() >= s3.length()) {
                    return s1;
                }
                if (s2.length() >= s3.length() && s2.length() >= s1.length()) {
                    return s2;
                }
                return s3;
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.memoryGlobal.isEmpty() && this.localVariables01.isEmpty() && this.overridenVariables01.isEmpty();
    }

    @Override
    public Set<String> variablesNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TMemory forkFromGlobal(Map<String, TValue> input) {
        return new TMemoryLocal(this.memoryGlobal, input);
    }
}

