/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Objects;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.url.Url;

public class StyleKey {
    public final EnumSet<SName> snames;
    public final boolean isStared;
    public final int level;
    private transient int cachedHashCode = 0;

    private StyleKey(EnumSet<SName> snames, int level, boolean isStared) {
        this.level = level;
        this.isStared = isStared;
        this.snames = snames;
    }

    public static StyleKey empty() {
        return new StyleKey(EnumSet.noneOf(SName.class), -1, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.snames + " ");
        if (this.level != -1) {
            sb.append(" " + this.level);
        }
        if (this.isStared) {
            sb.append(" (*)");
        }
        return sb.toString();
    }

    public StyleKey addClickable(Url url) {
        if (url == null) {
            return this;
        }
        Object result = this.snames.clone();
        ((AbstractCollection)result).add(SName.clickable);
        return new StyleKey((EnumSet<SName>)result, this.level, this.isStared);
    }

    public StyleKey addLevel(int level) {
        return new StyleKey(this.snames, level, this.isStared);
    }

    public StyleKey addSName(SName name) {
        Object result = this.snames.clone();
        ((AbstractCollection)result).add(name);
        return new StyleKey((EnumSet<SName>)result, this.level, this.isStared);
    }

    public StyleKey addStar() {
        return new StyleKey(this.snames, this.level, true);
    }

    public static StyleKey of(SName ... names) {
        EnumSet<SName> result = EnumSet.noneOf(SName.class);
        for (SName name : names) {
            result.add(name);
        }
        return new StyleKey(result, -1, false);
    }

    public StyleKey mergeWith(StyleKey other) {
        Object result1 = this.snames.clone();
        ((AbstractCollection)result1).addAll(other.snames);
        return new StyleKey((EnumSet<SName>)result1, Math.max(this.level, other.level), this.isStared || other.isStared);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StyleKey)) {
            return false;
        }
        StyleKey other = (StyleKey)obj;
        return Objects.equals(this.snames, other.snames) && this.isStared == other.isStared && this.level == other.level;
    }

    public int hashCode() {
        int result = this.cachedHashCode;
        if (result == 0) {
            this.cachedHashCode = result = Objects.hash(this.snames, this.isStared, this.level);
        }
        return result;
    }
}

