/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cheneer.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.cheneer.ChenEerDiagram;
import net.sourceforge.plantuml.cheneer.command.CommandCreateEntity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandAssociate
extends SingleLineCommand2<ChenEerDiagram> {
    public CommandAssociate() {
        super(CommandAssociate.getRegexConcat());
    }

    protected static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateEntity.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "NAME1", "([%pLN_.-]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "PARTICIPATION", "([-=])"), new RegexOptional((IRegex)new RegexLeaf(1, "CARDINALITY", "([%pLN]+|\\([%pLN]+,[%s]*[%pLN]+\\))")), new RegexLeaf(1, "PARTICIPATION2", "([-=])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "NAME2", "([%pLN_.-]+)"), RegexLeaf.spaceZeroOrMore(), CommandAssociate.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    @Override
    protected CommandExecutionResult executeArg(ChenEerDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String name1 = diagram.cleanId(arg.get("NAME1", 0));
        String name2 = diagram.cleanId(arg.get("NAME2", 0));
        boolean isDouble = arg.get("PARTICIPATION", 0).equals("=");
        String cardinality = arg.get("CARDINALITY", 0);
        Quark<Entity> quark1 = diagram.quarkInContext(true, name1);
        Entity entity1 = quark1.getData();
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity: " + name1);
        }
        Quark<Entity> quark2 = diagram.quarkInContext(true, name2);
        Entity entity2 = quark2.getData();
        if (entity2 == null) {
            return CommandExecutionResult.error("No such entity: " + name2);
        }
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        if (isDouble) {
            linkType = linkType.goBold();
        }
        Link link = new Link(location, diagram, diagram.getCurrentStyleBuilder(), entity1, entity2, linkType, LinkArg.build(Display.getWithNewlines(diagram.getPragma(), cardinality), 3));
        link.setPortMembers(diagram.getPortId(entity1.getName()), diagram.getPortId(entity2.getName()));
        link.setColors(CommandAssociate.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

