/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceSizingPBImpl
extends ResourceSizing {
    YarnProtos.ResourceSizingProto proto = YarnProtos.ResourceSizingProto.getDefaultInstance();
    YarnProtos.ResourceSizingProto.Builder builder = null;
    boolean viaProto = false;
    private Resource resources = null;

    public ResourceSizingPBImpl() {
        this.builder = YarnProtos.ResourceSizingProto.newBuilder();
    }

    public ResourceSizingPBImpl(YarnProtos.ResourceSizingProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceSizingProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.resources != null) {
            this.builder.setResources(this.convertToProtoFormat(this.resources));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceSizingProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getNumAllocations() {
        YarnProtos.ResourceSizingProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNumAllocations();
    }

    @Override
    public void setNumAllocations(int numAllocations) {
        this.maybeInitBuilder();
        this.builder.setNumAllocations(numAllocations);
    }

    @Override
    public Resource getResources() {
        YarnProtos.ResourceSizingProtoOrBuilder p;
        YarnProtos.ResourceSizingProtoOrBuilder resourceSizingProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resources != null) {
            return this.resources;
        }
        if (!p.hasResources()) {
            return null;
        }
        this.resources = this.convertFromProtoFormat(p.getResources());
        return this.resources;
    }

    @Override
    public void setResources(Resource resources) {
        this.maybeInitBuilder();
        if (resources == null) {
            this.builder.clearResources();
        }
        this.resources = resources;
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto r) {
        return new ResourcePBImpl(r);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ProtoUtils.convertToProtoFormat(r);
    }

    public String toString() {
        return "ResourceSizingPBImpl{numAllocations=" + this.getNumAllocations() + ", resources=" + this.getResources() + '}';
    }
}

