/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.Asn1Dumper;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.Tag;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Type;

public class Asn1Tagging<T extends Asn1Type>
extends AbstractAsn1Type<T>
implements Asn1Dumpable {
    public Asn1Tagging(int tagNo, T value, boolean isAppSpecific, boolean isImplicit) {
        super(Asn1Tagging.makeTag(isAppSpecific, tagNo), value);
        if (value == null) {
            this.initValue();
        }
        this.useImplicit(isImplicit);
    }

    private static Tag makeTag(boolean isAppSpecific, int tagNo) {
        return isAppSpecific ? Tag.newAppTag(tagNo) : Tag.newCtxTag(tagNo);
    }

    @Override
    public void useImplicit(boolean isImplicit) {
        super.useImplicit(isImplicit);
        if (!isImplicit) {
            this.usePrimitive(false);
        } else {
            this.usePrimitive(((Asn1Type)this.getValue()).isPrimitive());
        }
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        Asn1Encodeable value = (Asn1Encodeable)this.getValue();
        if (this.isImplicit()) {
            return value.encodingBodyLength();
        }
        return value.encodingLength();
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        Asn1Encodeable value = (Asn1Encodeable)this.getValue();
        if (this.isImplicit()) {
            value.encodeBody(buffer);
        } else {
            value.encode(buffer);
        }
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        Asn1Encodeable value = (Asn1Encodeable)this.getValue();
        if (this.isImplicit()) {
            value.decodeBody(parseResult);
        } else {
            Asn1Container container = (Asn1Container)parseResult;
            Asn1ParseResult body = container.getChildren().get(0);
            value.decode(body);
        }
    }

    private void initValue() {
        AbstractAsn1Type value;
        Class valueType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        try {
            value = (AbstractAsn1Type)valueType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create tagged value", e);
        }
        this.setValue(value);
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        Asn1Type taggedValue = (Asn1Type)this.getValue();
        dumper.indent(indents).appendType(this.getClass());
        dumper.append(this.simpleInfo()).newLine();
        dumper.dumpType(indents, taggedValue);
    }
}

