/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.ReindexRequestBuilder;
import org.opensearch.observability.action.GetObservabilityObjectRequest;
import org.opensearch.observability.index.ObservabilityIndex;
import org.opensearch.observability.index.ObservabilityQueryHelper;
import org.opensearch.observability.model.ObservabilityObjectDoc;
import org.opensearch.observability.model.ObservabilityObjectDocInfo;
import org.opensearch.observability.model.ObservabilityObjectSearchResult;
import org.opensearch.observability.model.SearchResults;
import org.opensearch.observability.settings.PluginSettings;
import org.opensearch.observability.util.HelpersKt;
import org.opensearch.observability.util.SecureIndexClient;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000*\u0001\u0016\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u00020\u000bJ\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(J\u001a\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+H\u0002J$\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0&2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!J\u000e\u00103\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000bJ \u00104\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000206052\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u00067"}, d2={"Lorg/opensearch/observability/index/ObservabilityIndex;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "INDEX_NAME", "", "NOTEBOOKS_INDEX_NAME", "OBSERVABILITY_MAPPING_FILE_NAME", "OBSERVABILITY_SETTINGS_FILE_NAME", "mappingsUpdated", "", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "searchHitParser", "org/opensearch/observability/index/ObservabilityIndex$searchHitParser$1", "Lorg/opensearch/observability/index/ObservabilityIndex$searchHitParser$1;", "initialize", "", "createIndex", "updateMappings", "reindexNotebooks", "isIndexExists", "index", "createObservabilityObject", "observabilityObjectDoc", "Lorg/opensearch/observability/model/ObservabilityObjectDoc;", "id", "getObservabilityObject", "Lorg/opensearch/observability/model/ObservabilityObjectDocInfo;", "getObservabilityObjects", "", "ids", "", "parseObservabilityObjectDoc", "response", "Lorg/opensearch/action/get/GetResponse;", "getAllObservabilityObjects", "Lorg/opensearch/observability/model/ObservabilityObjectSearchResult;", "tenant", "access", "request", "Lorg/opensearch/observability/action/GetObservabilityObjectRequest;", "updateObservabilityObject", "deleteObservabilityObject", "deleteObservabilityObjects", "", "Lorg/opensearch/core/rest/RestStatus;", "opensearch-observability"})
@SourceDebugExtension(value={"SMAP\nObservabilityIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservabilityIndex.kt\norg/opensearch/observability/index/ObservabilityIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n1869#2,2:404\n1869#2,2:419\n1869#2,2:421\n11546#3,9:406\n13472#3:415\n13473#3:417\n11555#3:418\n1#4:416\n*S KotlinDebug\n*F\n+ 1 ObservabilityIndex.kt\norg/opensearch/observability/index/ObservabilityIndex\n*L\n252#1:404,2\n384#1:419,2\n394#1:421,2\n255#1:406,9\n255#1:415\n255#1:417\n255#1:418\n255#1:416\n*E\n"})
public final class ObservabilityIndex {
    @NotNull
    public static final ObservabilityIndex INSTANCE = new ObservabilityIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ObservabilityIndex.class);
    @NotNull
    public static final String INDEX_NAME = ".opensearch-observability";
    @NotNull
    public static final String NOTEBOOKS_INDEX_NAME = ".opensearch-notebooks";
    @NotNull
    private static final String OBSERVABILITY_MAPPING_FILE_NAME = "observability-mapping.yml";
    @NotNull
    private static final String OBSERVABILITY_SETTINGS_FILE_NAME = "observability-settings.yml";
    private static boolean mappingsUpdated;
    private static Client client;
    private static ClusterService clusterService;
    @NotNull
    private static final searchHitParser.1 searchHitParser;

    private ObservabilityIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ObservabilityIndex.client = new SecureIndexClient(client);
        ObservabilityIndex.clusterService = clusterService;
        mappingsUpdated = false;
    }

    private final void createIndex() {
        if (!this.isIndexExists(INDEX_NAME)) {
            block12: {
                String string;
                String string2;
                Object object;
                Object object2;
                ClassLoader classLoader = ObservabilityIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(OBSERVABILITY_MAPPING_FILE_NAME);
                if (uRL != null) {
                    URL uRL2 = uRL;
                    object2 = Charsets.UTF_8;
                    object = TextStreamsKt.readBytes((URL)uRL2);
                    string2 = new String((byte[])object, (Charset)object2);
                } else {
                    string2 = null;
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(OBSERVABILITY_SETTINGS_FILE_NAME);
                if (uRL3 != null) {
                    object2 = uRL3;
                    object = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object2);
                    string = new String(byArray, (Charset)object);
                } else {
                    string = null;
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(INDEX_NAME).mapping(indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    ActionFuture actionFuture;
                    CreateIndexResponse response;
                    Client client = ObservabilityIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (CreateIndexResponse)(actionFuture = client.admin().indices().create(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        throw new IllegalStateException("observability:Index .opensearch-observability creation not Acknowledged".toString());
                    }
                    this.getLog().info("observability:Index .opensearch-observability creation Acknowledged");
                    this.reindexNotebooks();
                }
                catch (ResourceAlreadyExistsException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceAlreadyExistsException) break block12;
                    throw exception;
                }
            }
            mappingsUpdated = true;
        } else if (!mappingsUpdated) {
            this.updateMappings();
        }
    }

    private final void updateMappings() {
        String string;
        String[] stringArray;
        ClassLoader classLoader = ObservabilityIndex.class.getClassLoader();
        String[] stringArray2 = classLoader.getResource(OBSERVABILITY_MAPPING_FILE_NAME);
        if (stringArray2 != null) {
            stringArray = stringArray2;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)stringArray);
            string = new String(byArray, charset);
        } else {
            string = null;
        }
        Intrinsics.checkNotNull(string);
        String indexMappingSource = string;
        stringArray = new String[]{INDEX_NAME};
        PutMappingRequest request = new PutMappingRequest(stringArray).source(indexMappingSource, (MediaType)XContentType.YAML);
        try {
            ActionFuture actionFuture;
            AcknowledgedResponse response;
            Client client = ObservabilityIndex.client;
            if (client == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                client = null;
            }
            if (!(response = (AcknowledgedResponse)(actionFuture = client.admin().indices().putMapping(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                throw new IllegalStateException("observability:Index .opensearch-observability update mapping not Acknowledged".toString());
            }
            this.getLog().info("observability:Index .opensearch-observability update mapping Acknowledged");
            mappingsUpdated = true;
        }
        catch (IndexNotFoundException exception) {
            this.getLog().error("observability:IndexNotFoundException:", (Throwable)exception);
        }
    }

    private final void reindexNotebooks() {
        block9: {
            if (this.isIndexExists(NOTEBOOKS_INDEX_NAME)) {
                try {
                    String[] stringArray;
                    BulkByScrollResponse reindexResponse;
                    this.getLog().info("observability:Index - reindex .opensearch-notebooks to .opensearch-observability");
                    Client client = ObservabilityIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if ((reindexResponse = (BulkByScrollResponse)((ReindexRequestBuilder)((ReindexRequestBuilder)((ReindexRequestBuilder)new ReindexRequestBuilder((OpenSearchClient)client, (ActionType)ReindexAction.INSTANCE).source(stringArray = new String[]{NOTEBOOKS_INDEX_NAME})).destination(INDEX_NAME).abortOnVersionConflict(false)).refresh(true)).get()).isTimedOut()) {
                        throw new IllegalStateException("observability:Index - reindex .opensearch-notebooks timed out".toString());
                    }
                    List list = reindexResponse.getSearchFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSearchFailures(...)");
                    if (!((Collection)list).isEmpty()) {
                        throw new IllegalStateException("observability:Index - reindex .opensearch-notebooks failed with searchFailures".toString());
                    }
                    List list2 = reindexResponse.getBulkFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBulkFailures(...)");
                    if (!((Collection)list2).isEmpty()) {
                        throw new IllegalStateException("observability:Index - reindex .opensearch-notebooks failed with bulkFailures".toString());
                    }
                    if (reindexResponse.getTotal() != reindexResponse.getCreated() + reindexResponse.getUpdated()) {
                        throw new IllegalStateException("observability:Index - reindex number of docs created:" + reindexResponse.getCreated() + " + updated:" + reindexResponse.getUpdated() + " does not equal requested:" + reindexResponse.getTotal());
                    }
                    this.getLog().info("observability:Index - reindex " + reindexResponse.getCreated() + " docs created and " + reindexResponse.getUpdated() + " docs updated in .opensearch-observability");
                }
                catch (ResourceNotFoundException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceNotFoundException) break block9;
                    throw exception;
                }
            }
        }
    }

    private final boolean isIndexExists(String index) {
        ClusterService clusterService = ObservabilityIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(index);
    }

    @Nullable
    public final String createObservabilityObject(@NotNull ObservabilityObjectDoc observabilityObjectDoc, @Nullable String id) {
        String string;
        ActionFuture actionFuture;
        IndexResponse response;
        Client client;
        Intrinsics.checkNotNullParameter((Object)observabilityObjectDoc, (String)"observabilityObjectDoc");
        this.createIndex();
        XContentBuilder xContent = ObservabilityObjectDoc.toXContent$default(observabilityObjectDoc, null, 1, null);
        IndexRequest indexRequest = new IndexRequest(INDEX_NAME).source(xContent).create(true);
        if (id != null) {
            indexRequest.id(id);
        }
        if ((client = ObservabilityIndex.client) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.CREATED) {
            this.getLog().warn("observability:createObservabilityObject - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    public static /* synthetic */ String createObservabilityObject$default(ObservabilityIndex observabilityIndex, ObservabilityObjectDoc observabilityObjectDoc, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return observabilityIndex.createObservabilityObject(observabilityObjectDoc, string);
    }

    @Nullable
    public final ObservabilityObjectDocInfo getObservabilityObject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(INDEX_NAME).id(id);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.get(getRequest);
        GetResponse response = (GetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Intrinsics.checkNotNull((Object)response);
        return this.parseObservabilityObjectDoc(id, response);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ObservabilityObjectDocInfo> getObservabilityObjects(@NotNull Set<String> ids) {
        void $this$mapNotNullTo$iv$iv;
        Object[] it;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.createIndex();
        MultiGetRequest getRequest = new MultiGetRequest();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Object[])element$iv;
            boolean bl = false;
            getRequest.add(INDEX_NAME, (String)it);
        }
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.multiGet(getRequest);
        MultiGetResponse response = (MultiGetResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        MultiGetItemResponse[] multiGetItemResponseArray = response.getResponses();
        Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"getResponses(...)");
        Object[] $this$mapNotNull$iv = multiGetItemResponseArray;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ObservabilityObjectDocInfo it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            MultiGetItemResponse it2 = (MultiGetItemResponse)element$iv$iv;
            boolean bl2 = false;
            String string = it2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            GetResponse getResponse = it2.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)getResponse, (String)"getResponse(...)");
            if (INSTANCE.parseObservabilityObjectDoc(string, getResponse) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ObservabilityObjectDocInfo parseObservabilityObjectDoc(String id, GetResponse response) {
        ObservabilityObjectDocInfo observabilityObjectDocInfo;
        if (response.getSourceAsString() == null) {
            this.getLog().warn("observability:getObservabilityObject - " + id + " not found; response:" + response);
            observabilityObjectDocInfo = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNull((Object)parser);
            ObservabilityObjectDoc doc = ObservabilityObjectDoc.Companion.parse(parser, id);
            observabilityObjectDocInfo = new ObservabilityObjectDocInfo(id, response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), doc);
        }
        return observabilityObjectDocInfo;
    }

    @NotNull
    public final ObservabilityObjectSearchResult getAllObservabilityObjects(@NotNull String tenant, @NotNull List<String> access, @NotNull GetObservabilityObjectRequest request) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.createIndex();
        ObservabilityQueryHelper queryHelper = new ObservabilityQueryHelper(request.getTypes());
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).size(request.getMaxItems()).from(request.getFromIndex());
        Intrinsics.checkNotNull((Object)sourceBuilder);
        queryHelper.addSortField(sourceBuilder, request.getSortField(), request.getSortOrder());
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        String[] stringArray = new String[]{tenant};
        query.filter((QueryBuilder)QueryBuilders.termsQuery((String)"tenant", (String[])stringArray));
        if (!((Collection)access).isEmpty()) {
            query.filter((QueryBuilder)QueryBuilders.termsQuery((String)"access", (Collection)access));
        }
        Intrinsics.checkNotNull((Object)query);
        queryHelper.addTypeFilters(query);
        queryHelper.addQueryFilters(query, request.getFilterParams());
        sourceBuilder.query((QueryBuilder)query);
        String[] stringArray2 = new String[]{INDEX_NAME};
        SearchRequest searchRequest = new SearchRequest().indices(stringArray2).source(sourceBuilder);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = request.getFromIndex();
        Intrinsics.checkNotNull((Object)response);
        ObservabilityObjectSearchResult result = new ObservabilityObjectSearchResult(l, response, searchHitParser);
        this.getLog().info("observability:getAllObservabilityObjects types:" + request.getTypes() + " from:" + request.getFromIndex() + ", maxItems:" + request.getMaxItems() + ", sortField:" + request.getSortField() + ", sortOrder=" + request.getSortOrder() + ", filters=" + request.getFilterParams() + " retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateObservabilityObject(@NotNull String id, @NotNull ObservabilityObjectDoc observabilityObjectDoc) {
        ActionFuture actionFuture;
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)observabilityObjectDoc, (String)"observabilityObjectDoc");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(INDEX_NAME)).id(id).doc(ObservabilityObjectDoc.toXContent$default(observabilityObjectDoc, null, 1, null)).fetchSource(true);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (UpdateResponse)(actionFuture = client.update(updateRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            this.getLog().warn("observability:updateObservabilityObject failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteObservabilityObject(@NotNull String id) {
        ActionFuture actionFuture;
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(id);
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (DeleteResponse)(actionFuture = client.delete(deleteRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.DELETED) {
            this.getLog().warn("observability:deleteObservabilityObject failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }

    @NotNull
    public final Map<String, RestStatus> deleteObservabilityObjects(@NotNull Set<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.createIndex();
        BulkRequest bulkRequest = new BulkRequest();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(it);
            bulkRequest.add(deleteRequest);
        }
        Client client = ObservabilityIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.bulk(bulkRequest);
        BulkResponse response = (BulkResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        Map mutableMap = new LinkedHashMap();
        Intrinsics.checkNotNull((Object)response);
        Iterable $this$forEach$iv2 = (Iterable)response;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            BulkItemResponse it = (BulkItemResponse)element$iv;
            boolean bl = false;
            mutableMap.put(it.getId(), it.status());
            if (!it.isFailed()) continue;
            INSTANCE.getLog().warn("observability:deleteObservabilityObjects failed for " + it.getId() + "; response:" + it.getFailureMessage());
        }
        return mutableMap;
    }

    static {
        searchHitParser = new SearchResults.SearchHitParser<ObservabilityObjectDoc>(){

            public ObservabilityObjectDoc parse(SearchHit searchHit) {
                Intrinsics.checkNotNullParameter((Object)searchHit, (String)"searchHit");
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchHit.getSourceAsString());
                parser.nextToken();
                Intrinsics.checkNotNull((Object)parser);
                return ObservabilityObjectDoc.Companion.parse(parser, searchHit.getId());
            }
        };
    }
}

