/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TermsSetQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, TermsSetQuery> {
    @Nonnull
    private final String field;
    @Nullable
    private final String minimumShouldMatchField;
    @Nullable
    private final Script minimumShouldMatchScript;
    @Nonnull
    private final List<String> terms;
    public static final JsonpDeserializer<TermsSetQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsSetQuery::setupTermsSetQueryDeserializer);

    private TermsSetQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.minimumShouldMatchField = builder.minimumShouldMatchField;
        this.minimumShouldMatchScript = builder.minimumShouldMatchScript;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static TermsSetQuery of(Function<Builder, ObjectBuilder<TermsSetQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.TermsSet;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String minimumShouldMatchField() {
        return this.minimumShouldMatchField;
    }

    @Nullable
    public final Script minimumShouldMatchScript() {
        return this.minimumShouldMatchScript;
    }

    @Nonnull
    public final List<String> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.minimumShouldMatchField != null) {
            generator.writeKey("minimum_should_match_field");
            generator.write(this.minimumShouldMatchField);
        }
        if (this.minimumShouldMatchScript != null) {
            generator.writeKey("minimum_should_match_script");
            this.minimumShouldMatchScript.serialize(generator, mapper);
        }
        generator.writeKey("terms");
        generator.writeStartArray();
        for (String item0 : this.terms) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTermsSetQueryDeserializer(ObjectDeserializer<Builder> op) {
        TermsSetQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::minimumShouldMatchField, JsonpDeserializer.stringDeserializer(), "minimum_should_match_field");
        op.add(Builder::minimumShouldMatchScript, Script._DESERIALIZER, "minimum_should_match_script");
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "terms");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.minimumShouldMatchField);
        result = 31 * result + Objects.hashCode(this.minimumShouldMatchScript);
        result = 31 * result + this.terms.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermsSetQuery other = (TermsSetQuery)o;
        return this.field.equals(other.field) && Objects.equals(this.minimumShouldMatchField, other.minimumShouldMatchField) && Objects.equals(this.minimumShouldMatchScript, other.minimumShouldMatchScript) && this.terms.equals(other.terms);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TermsSetQuery> {
        private String field;
        @Nullable
        private String minimumShouldMatchField;
        @Nullable
        private Script minimumShouldMatchScript;
        private List<String> terms;

        public Builder() {
        }

        private Builder(TermsSetQuery o) {
            super(o);
            this.field = o.field;
            this.minimumShouldMatchField = o.minimumShouldMatchField;
            this.minimumShouldMatchScript = o.minimumShouldMatchScript;
            this.terms = Builder._listCopy(o.terms);
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.minimumShouldMatchField = o.minimumShouldMatchField;
            this.minimumShouldMatchScript = o.minimumShouldMatchScript;
            this.terms = Builder._listCopy(o.terms);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder minimumShouldMatchField(@Nullable String value) {
            this.minimumShouldMatchField = value;
            return this;
        }

        @Nonnull
        public final Builder minimumShouldMatchScript(@Nullable Script value) {
            this.minimumShouldMatchScript = value;
            return this;
        }

        @Nonnull
        public final Builder minimumShouldMatchScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.minimumShouldMatchScript(fn.apply(new Script.Builder()).build());
        }

        @Nonnull
        public final Builder terms(List<String> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        @Nonnull
        public final Builder terms(String value, String ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        @Override
        @Nonnull
        public TermsSetQuery build() {
            this._checkSingleUse();
            return new TermsSetQuery(this);
        }
    }
}

