/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcServerException;

public class CallBackSubscriber
extends Subscriber
implements CallBack {
    private String logicalAddress = "";
    private final Object registrationLock = new Object();
    private boolean registrationComplete = false;
    private String registrationError = null;
    private String rpcServerName;
    private volatile CallBack rpcCallBack = null;
    private boolean isLocal;
    private Map<String, String> addrProperties;
    private Publisher publisher;
    private Node serverNode = null;
    private String serverSubscriberId = null;
    private NotificationNetwork network;
    private Logger logger = oNS.getLogger();

    public CallBackSubscriber(String string, ONS oNS, String string2, String string3, CallBack callBack, CallBackMode callBackMode, Map<String, String> map, boolean bl) {
        super(oNS.getNetwork().config, string2, string3, null);
        this.network = oNS.getNetwork();
        this.rpcServerName = string;
        this.rpcCallBack = callBack;
        this.addrProperties = map;
        this.publisher = new Publisher(this.network, string);
        this.isLocal = bl;
        this.register_callback(this, 1);
        this.logger.info("created subscriber: rpcName=" + string);
        this.register();
    }

    public String getLogicalAddress() {
        return this.logicalAddress;
    }

    @Override
    protected void setServerSubscriberInfo(Node node, String string) {
        this.serverNode = node;
        this.serverSubscriberId = string;
    }

    @Override
    protected boolean handleInternalNotification(Notification notification) {
        boolean bl = super.handleInternalNotification(notification);
        if (bl && this.serverSubscriberId != null && notification.verb.equals("status") && this.isOpen()) {
            this.network.master.getWorkloadManager().schedule(new CallBackRegister(this));
        }
        return bl;
    }

    protected void sendRegister() {
        Notification notification = new Notification("ONSregister", "", "", null);
        notification.setLocalOnly();
        notification.put("ONSregisterID", "sONSrpc" + this.rpcServerName);
        notification.putInternalProperty("SubscriberID", this.serverSubscriberId);
        notification.put("ONSregisterGroup", "true");
        notification.put("DirectRoute", "true");
        if (this.isLocal) {
            notification.put("ONScount", "LocalOnly");
        }
        if (this.addrProperties != null) {
            for (Map.Entry<String, String> entry : this.addrProperties.entrySet()) {
                notification.put(entry.getKey(), entry.getValue());
            }
        }
        this.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notification_callback(Notification notification) {
        String string = notification.getEventType();
        this.logger.info("notification type=" + string);
        if (string.equals("ONSstatus")) {
            String string2 = notification.get("Result");
            String string3 = notification.get("Message");
            this.logger.info("status: result=" + string2);
            if (string2.equalsIgnoreCase("success")) {
                this.logicalAddress = string3;
                Object object = this.registrationLock;
                synchronized (object) {
                    this.registrationLock.notify();
                    this.registrationComplete = true;
                }
            } else {
                Object object = this.registrationLock;
                synchronized (object) {
                    this.registrationError = string3;
                    this.registrationLock.notify();
                    this.registrationComplete = true;
                }
            }
        } else if (this.registrationComplete && this.registrationError == null) {
            String string4 = notification.get("DirectSource");
            String string5 = notification.get("ONSbroadcastID");
            String string6 = notification.get("TraceRoute");
            if (string.equals("ONS_RPC_PING")) {
                Notification notification2 = new Notification("ONS_RPC_PINGREPLY", "", "", null);
                notification2.put("DirectRoute", string4);
                notification2.put("ONSbroadcastID", string5);
                notification2.put("BackRoute", string6);
                notification2.put("Result", "success");
                notification2.put("DirectSource", this.logicalAddress);
                if (this.addrProperties != null) {
                    for (Map.Entry<String, String> entry : this.addrProperties.entrySet()) {
                        notification2.put("|" + entry.getKey(), entry.getValue());
                    }
                }
                this.sendNotification(notification2);
            } else if (string.equals("ONS_RPC_REQUEST")) {
                this.rpcCallBack.notification_callback(notification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRpcServerRegistrationReply() throws RpcServerException {
        Object object = this.registrationLock;
        synchronized (object) {
            if (!this.registrationComplete) {
                try {
                    this.registrationLock.wait(120000L);
                }
                catch (InterruptedException interruptedException) {
                    this.registrationError = "timed out";
                }
            }
        }
        if (this.registrationError != null) {
            throw new RpcServerException("Rpc Server registration failed: " + this.registrationError);
        }
    }

    private void sendNotification(Notification notification) {
        try {
            if (this.serverNode.getProtocolVersion() >= 5) {
                this.serverNode.publish(notification.toMessage(this.publisher, this.serverNode.getProtocolVersion()));
            } else {
                this.serverNode.publish(notification.toMessageVersion4(this.publisher));
            }
        }
        catch (IOException iOException) {
            this.logger.severe("send: " + iOException + "\n" + ONS.exceptionMsg(iOException));
        }
    }

    private static class CallBackRegister
    implements Runnable {
        CallBackSubscriber callbackSubscriber;

        private CallBackRegister(CallBackSubscriber callBackSubscriber) {
            this.callbackSubscriber = callBackSubscriber;
        }

        @Override
        public void run() {
            this.callbackSubscriber.sendRegister();
        }
    }
}

