## Description

This is a generic arbitrary file overwrite technique, which typically results in remote command execution. This targets a simple yet widespread vulnerability that has been seen affecting a variety of popular products including HP, Amazon, Apache, Cisco, etc. The idea is that often archive extraction libraries have no mitigations against directory traversal attacks. If an application uses it, there is a risk when opening an archive that is maliciously modified, and result in the embedded payload being written to an arbitrary location (such as a web root), and result in remote code execution.

## Vulnerable Application

Since this is a generic module, it does not target a specific application. However, what it targets is potentially unsafe TAR extraction libraries, so if you happen to notice that, then you can consider using this.

For example, let's say you have a Python library that has code that can extract a TAR file like this:

```python
import tarfile
t = tarfile.open('example.tar')
t.extractall()
```

The above will extract a TAR file, but the `extractall` function does not have any protection (especially against directory traversal attacks), so it's dangerous.

An example that is safe from the attack is the `tar` command, for example:

```
$ tar -xf msf.tar 
../payload.bin: Path contains '..'
tar: Error exit delayed from previous errors.
```

## Verification Steps

1. Save the above Python script
2. Generate the malicious TAR file
3. Run Python on the TAR file:

```python
import tarfile
t = tarfile.open('example.tar')
t.extractall()
```
