/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: C++ Emscripten wrapper for WebAssembly

Interface version: 2.5.0

*/

#include <iostream>
#include <vector>
#include <string>
#include <emscripten.h>
#include <emscripten/bind.h>
#include "Cpp/lib3mf_implicit.hpp"

using namespace emscripten;
using namespace Lib3MF;

struct sTriangleWrapper {
    sTriangle value;
    Lib3MF_uint32 get_Indices0() const { return value.m_Indices[0]; }
    void set_Indices0(Lib3MF_uint32 v) { value.m_Indices[0] = v; }
    Lib3MF_uint32 get_Indices1() const { return value.m_Indices[1]; }
    void set_Indices1(Lib3MF_uint32 v) { value.m_Indices[1] = v; }
    Lib3MF_uint32 get_Indices2() const { return value.m_Indices[2]; }
    void set_Indices2(Lib3MF_uint32 v) { value.m_Indices[2] = v; }

    sTriangle toStruct() const { return value; }

    static sTriangleWrapper fromStruct(const emscripten::val &js) {
        sTriangleWrapper wrapper;
        wrapper.value.m_Indices[0] = js["Indices0"].as<Lib3MF_uint32>();
        wrapper.value.m_Indices[1] = js["Indices1"].as<Lib3MF_uint32>();
        wrapper.value.m_Indices[2] = js["Indices2"].as<Lib3MF_uint32>();
        return wrapper;
    }
};

struct sTrianglePropertiesWrapper {
    sTriangleProperties value;
    Lib3MF_uint32 get_ResourceID() const { return value.m_ResourceID; }
    void set_ResourceID(Lib3MF_uint32 v) { value.m_ResourceID = v; }
    Lib3MF_uint32 get_PropertyIDs0() const { return value.m_PropertyIDs[0]; }
    void set_PropertyIDs0(Lib3MF_uint32 v) { value.m_PropertyIDs[0] = v; }
    Lib3MF_uint32 get_PropertyIDs1() const { return value.m_PropertyIDs[1]; }
    void set_PropertyIDs1(Lib3MF_uint32 v) { value.m_PropertyIDs[1] = v; }
    Lib3MF_uint32 get_PropertyIDs2() const { return value.m_PropertyIDs[2]; }
    void set_PropertyIDs2(Lib3MF_uint32 v) { value.m_PropertyIDs[2] = v; }

    sTriangleProperties toStruct() const { return value; }

    static sTrianglePropertiesWrapper fromStruct(const emscripten::val &js) {
        sTrianglePropertiesWrapper wrapper;
        wrapper.value.m_ResourceID = js["ResourceID"].as<Lib3MF_uint32>();
        wrapper.value.m_PropertyIDs[0] = js["PropertyIDs0"].as<Lib3MF_uint32>();
        wrapper.value.m_PropertyIDs[1] = js["PropertyIDs1"].as<Lib3MF_uint32>();
        wrapper.value.m_PropertyIDs[2] = js["PropertyIDs2"].as<Lib3MF_uint32>();
        return wrapper;
    }
};

struct sPositionWrapper {
    sPosition value;
    Lib3MF_single get_Coordinates0() const { return value.m_Coordinates[0]; }
    void set_Coordinates0(Lib3MF_single v) { value.m_Coordinates[0] = v; }
    Lib3MF_single get_Coordinates1() const { return value.m_Coordinates[1]; }
    void set_Coordinates1(Lib3MF_single v) { value.m_Coordinates[1] = v; }
    Lib3MF_single get_Coordinates2() const { return value.m_Coordinates[2]; }
    void set_Coordinates2(Lib3MF_single v) { value.m_Coordinates[2] = v; }

    sPosition toStruct() const { return value; }

    static sPositionWrapper fromStruct(const emscripten::val &js) {
        sPositionWrapper wrapper;
        wrapper.value.m_Coordinates[0] = js["Coordinates0"].as<Lib3MF_single>();
        wrapper.value.m_Coordinates[1] = js["Coordinates1"].as<Lib3MF_single>();
        wrapper.value.m_Coordinates[2] = js["Coordinates2"].as<Lib3MF_single>();
        return wrapper;
    }
};

struct sPosition2DWrapper {
    sPosition2D value;
    Lib3MF_single get_Coordinates0() const { return value.m_Coordinates[0]; }
    void set_Coordinates0(Lib3MF_single v) { value.m_Coordinates[0] = v; }
    Lib3MF_single get_Coordinates1() const { return value.m_Coordinates[1]; }
    void set_Coordinates1(Lib3MF_single v) { value.m_Coordinates[1] = v; }

    sPosition2D toStruct() const { return value; }

    static sPosition2DWrapper fromStruct(const emscripten::val &js) {
        sPosition2DWrapper wrapper;
        wrapper.value.m_Coordinates[0] = js["Coordinates0"].as<Lib3MF_single>();
        wrapper.value.m_Coordinates[1] = js["Coordinates1"].as<Lib3MF_single>();
        return wrapper;
    }
};

struct sCompositeConstituentWrapper {
    sCompositeConstituent value;
    Lib3MF_uint32 get_PropertyID() const { return value.m_PropertyID; }
    void set_PropertyID(Lib3MF_uint32 v) { value.m_PropertyID = v; }
    Lib3MF_double get_MixingRatio() const { return value.m_MixingRatio; }
    void set_MixingRatio(Lib3MF_double v) { value.m_MixingRatio = v; }

    sCompositeConstituent toStruct() const { return value; }

    static sCompositeConstituentWrapper fromStruct(const emscripten::val &js) {
        sCompositeConstituentWrapper wrapper;
        wrapper.value.m_PropertyID = js["PropertyID"].as<Lib3MF_uint32>();
        wrapper.value.m_MixingRatio = js["MixingRatio"].as<Lib3MF_double>();
        return wrapper;
    }
};

struct sMultiPropertyLayerWrapper {
    sMultiPropertyLayer value;
    Lib3MF_uint32 get_ResourceID() const { return value.m_ResourceID; }
    void set_ResourceID(Lib3MF_uint32 v) { value.m_ResourceID = v; }
    eBlendMethod get_TheBlendMethod() const { return value.m_TheBlendMethod; }
    void set_TheBlendMethod(eBlendMethod v) { value.m_TheBlendMethod = v; }

    sMultiPropertyLayer toStruct() const { return value; }

    static sMultiPropertyLayerWrapper fromStruct(const emscripten::val &js) {
        sMultiPropertyLayerWrapper wrapper;
        wrapper.value.m_ResourceID = js["ResourceID"].as<Lib3MF_uint32>();
        wrapper.value.m_TheBlendMethod = js["TheBlendMethod"].as<eBlendMethod>();
        return wrapper;
    }
};

struct sTex2CoordWrapper {
    sTex2Coord value;
    Lib3MF_double get_U() const { return value.m_U; }
    void set_U(Lib3MF_double v) { value.m_U = v; }
    Lib3MF_double get_V() const { return value.m_V; }
    void set_V(Lib3MF_double v) { value.m_V = v; }

    sTex2Coord toStruct() const { return value; }

    static sTex2CoordWrapper fromStruct(const emscripten::val &js) {
        sTex2CoordWrapper wrapper;
        wrapper.value.m_U = js["U"].as<Lib3MF_double>();
        wrapper.value.m_V = js["V"].as<Lib3MF_double>();
        return wrapper;
    }
};

struct sTransformWrapper {
    sTransform value;
    Lib3MF_single get_Fields_0_0() const { return value.m_Fields[0][0]; }
    void set_Fields_0_0(Lib3MF_single v) { value.m_Fields[0][0] = v; }
    Lib3MF_single get_Fields_0_1() const { return value.m_Fields[0][1]; }
    void set_Fields_0_1(Lib3MF_single v) { value.m_Fields[0][1] = v; }
    Lib3MF_single get_Fields_0_2() const { return value.m_Fields[0][2]; }
    void set_Fields_0_2(Lib3MF_single v) { value.m_Fields[0][2] = v; }
    Lib3MF_single get_Fields_1_0() const { return value.m_Fields[1][0]; }
    void set_Fields_1_0(Lib3MF_single v) { value.m_Fields[1][0] = v; }
    Lib3MF_single get_Fields_1_1() const { return value.m_Fields[1][1]; }
    void set_Fields_1_1(Lib3MF_single v) { value.m_Fields[1][1] = v; }
    Lib3MF_single get_Fields_1_2() const { return value.m_Fields[1][2]; }
    void set_Fields_1_2(Lib3MF_single v) { value.m_Fields[1][2] = v; }
    Lib3MF_single get_Fields_2_0() const { return value.m_Fields[2][0]; }
    void set_Fields_2_0(Lib3MF_single v) { value.m_Fields[2][0] = v; }
    Lib3MF_single get_Fields_2_1() const { return value.m_Fields[2][1]; }
    void set_Fields_2_1(Lib3MF_single v) { value.m_Fields[2][1] = v; }
    Lib3MF_single get_Fields_2_2() const { return value.m_Fields[2][2]; }
    void set_Fields_2_2(Lib3MF_single v) { value.m_Fields[2][2] = v; }
    Lib3MF_single get_Fields_3_0() const { return value.m_Fields[3][0]; }
    void set_Fields_3_0(Lib3MF_single v) { value.m_Fields[3][0] = v; }
    Lib3MF_single get_Fields_3_1() const { return value.m_Fields[3][1]; }
    void set_Fields_3_1(Lib3MF_single v) { value.m_Fields[3][1] = v; }
    Lib3MF_single get_Fields_3_2() const { return value.m_Fields[3][2]; }
    void set_Fields_3_2(Lib3MF_single v) { value.m_Fields[3][2] = v; }

    sTransform toStruct() const { return value; }

    static sTransformWrapper fromStruct(const emscripten::val &js) {
        sTransformWrapper wrapper;
        wrapper.value.m_Fields[0][0] = js["Fields_0_0"].as<Lib3MF_single>();
        wrapper.value.m_Fields[1][0] = js["Fields_1_0"].as<Lib3MF_single>();
        wrapper.value.m_Fields[2][0] = js["Fields_2_0"].as<Lib3MF_single>();
        wrapper.value.m_Fields[3][0] = js["Fields_3_0"].as<Lib3MF_single>();
        wrapper.value.m_Fields[0][1] = js["Fields_0_1"].as<Lib3MF_single>();
        wrapper.value.m_Fields[1][1] = js["Fields_1_1"].as<Lib3MF_single>();
        wrapper.value.m_Fields[2][1] = js["Fields_2_1"].as<Lib3MF_single>();
        wrapper.value.m_Fields[3][1] = js["Fields_3_1"].as<Lib3MF_single>();
        wrapper.value.m_Fields[0][2] = js["Fields_0_2"].as<Lib3MF_single>();
        wrapper.value.m_Fields[1][2] = js["Fields_1_2"].as<Lib3MF_single>();
        wrapper.value.m_Fields[2][2] = js["Fields_2_2"].as<Lib3MF_single>();
        wrapper.value.m_Fields[3][2] = js["Fields_3_2"].as<Lib3MF_single>();
        return wrapper;
    }
};

struct sBoxWrapper {
    sBox value;
    Lib3MF_single get_MinCoordinate0() const { return value.m_MinCoordinate[0]; }
    void set_MinCoordinate0(Lib3MF_single v) { value.m_MinCoordinate[0] = v; }
    Lib3MF_single get_MinCoordinate1() const { return value.m_MinCoordinate[1]; }
    void set_MinCoordinate1(Lib3MF_single v) { value.m_MinCoordinate[1] = v; }
    Lib3MF_single get_MinCoordinate2() const { return value.m_MinCoordinate[2]; }
    void set_MinCoordinate2(Lib3MF_single v) { value.m_MinCoordinate[2] = v; }
    Lib3MF_single get_MaxCoordinate0() const { return value.m_MaxCoordinate[0]; }
    void set_MaxCoordinate0(Lib3MF_single v) { value.m_MaxCoordinate[0] = v; }
    Lib3MF_single get_MaxCoordinate1() const { return value.m_MaxCoordinate[1]; }
    void set_MaxCoordinate1(Lib3MF_single v) { value.m_MaxCoordinate[1] = v; }
    Lib3MF_single get_MaxCoordinate2() const { return value.m_MaxCoordinate[2]; }
    void set_MaxCoordinate2(Lib3MF_single v) { value.m_MaxCoordinate[2] = v; }

    sBox toStruct() const { return value; }

    static sBoxWrapper fromStruct(const emscripten::val &js) {
        sBoxWrapper wrapper;
        wrapper.value.m_MinCoordinate[0] = js["MinCoordinate0"].as<Lib3MF_single>();
        wrapper.value.m_MinCoordinate[1] = js["MinCoordinate1"].as<Lib3MF_single>();
        wrapper.value.m_MinCoordinate[2] = js["MinCoordinate2"].as<Lib3MF_single>();
        wrapper.value.m_MaxCoordinate[0] = js["MaxCoordinate0"].as<Lib3MF_single>();
        wrapper.value.m_MaxCoordinate[1] = js["MaxCoordinate1"].as<Lib3MF_single>();
        wrapper.value.m_MaxCoordinate[2] = js["MaxCoordinate2"].as<Lib3MF_single>();
        return wrapper;
    }
};

struct sColorWrapper {
    sColor value;
    Lib3MF_uint8 get_Red() const { return value.m_Red; }
    void set_Red(Lib3MF_uint8 v) { value.m_Red = v; }
    Lib3MF_uint8 get_Green() const { return value.m_Green; }
    void set_Green(Lib3MF_uint8 v) { value.m_Green = v; }
    Lib3MF_uint8 get_Blue() const { return value.m_Blue; }
    void set_Blue(Lib3MF_uint8 v) { value.m_Blue = v; }
    Lib3MF_uint8 get_Alpha() const { return value.m_Alpha; }
    void set_Alpha(Lib3MF_uint8 v) { value.m_Alpha = v; }

    sColor toStruct() const { return value; }

    static sColorWrapper fromStruct(const emscripten::val &js) {
        sColorWrapper wrapper;
        wrapper.value.m_Red = js["Red"].as<Lib3MF_uint8>();
        wrapper.value.m_Green = js["Green"].as<Lib3MF_uint8>();
        wrapper.value.m_Blue = js["Blue"].as<Lib3MF_uint8>();
        wrapper.value.m_Alpha = js["Alpha"].as<Lib3MF_uint8>();
        return wrapper;
    }
};

struct sBeamWrapper {
    sBeam value;
    Lib3MF_uint32 get_Indices0() const { return value.m_Indices[0]; }
    void set_Indices0(Lib3MF_uint32 v) { value.m_Indices[0] = v; }
    Lib3MF_uint32 get_Indices1() const { return value.m_Indices[1]; }
    void set_Indices1(Lib3MF_uint32 v) { value.m_Indices[1] = v; }
    Lib3MF_double get_Radii0() const { return value.m_Radii[0]; }
    void set_Radii0(Lib3MF_double v) { value.m_Radii[0] = v; }
    Lib3MF_double get_Radii1() const { return value.m_Radii[1]; }
    void set_Radii1(Lib3MF_double v) { value.m_Radii[1] = v; }
    eBeamLatticeCapMode get_CapModes0() const { return value.m_CapModes[0]; }
    void set_CapModes0(eBeamLatticeCapMode v) { value.m_CapModes[0] = v; }
    eBeamLatticeCapMode get_CapModes1() const { return value.m_CapModes[1]; }
    void set_CapModes1(eBeamLatticeCapMode v) { value.m_CapModes[1] = v; }

    sBeam toStruct() const { return value; }

    static sBeamWrapper fromStruct(const emscripten::val &js) {
        sBeamWrapper wrapper;
        wrapper.value.m_Indices[0] = js["Indices0"].as<Lib3MF_uint32>();
        wrapper.value.m_Indices[1] = js["Indices1"].as<Lib3MF_uint32>();
        wrapper.value.m_Radii[0] = js["Radii0"].as<Lib3MF_double>();
        wrapper.value.m_Radii[1] = js["Radii1"].as<Lib3MF_double>();
        wrapper.value.m_CapModes[0] = js["CapModes0"].as<eBeamLatticeCapMode>();
        wrapper.value.m_CapModes[1] = js["CapModes1"].as<eBeamLatticeCapMode>();
        return wrapper;
    }
};

struct sBallWrapper {
    sBall value;
    Lib3MF_uint32 get_Index() const { return value.m_Index; }
    void set_Index(Lib3MF_uint32 v) { value.m_Index = v; }
    Lib3MF_double get_Radius() const { return value.m_Radius; }
    void set_Radius(Lib3MF_double v) { value.m_Radius = v; }

    sBall toStruct() const { return value; }

    static sBallWrapper fromStruct(const emscripten::val &js) {
        sBallWrapper wrapper;
        wrapper.value.m_Index = js["Index"].as<Lib3MF_uint32>();
        wrapper.value.m_Radius = js["Radius"].as<Lib3MF_double>();
        return wrapper;
    }
};

struct sVectorWrapper {
    sVector value;
    Lib3MF_double get_Coordinates0() const { return value.m_Coordinates[0]; }
    void set_Coordinates0(Lib3MF_double v) { value.m_Coordinates[0] = v; }
    Lib3MF_double get_Coordinates1() const { return value.m_Coordinates[1]; }
    void set_Coordinates1(Lib3MF_double v) { value.m_Coordinates[1] = v; }
    Lib3MF_double get_Coordinates2() const { return value.m_Coordinates[2]; }
    void set_Coordinates2(Lib3MF_double v) { value.m_Coordinates[2] = v; }

    sVector toStruct() const { return value; }

    static sVectorWrapper fromStruct(const emscripten::val &js) {
        sVectorWrapper wrapper;
        wrapper.value.m_Coordinates[0] = js["Coordinates0"].as<Lib3MF_double>();
        wrapper.value.m_Coordinates[1] = js["Coordinates1"].as<Lib3MF_double>();
        wrapper.value.m_Coordinates[2] = js["Coordinates2"].as<Lib3MF_double>();
        return wrapper;
    }
};

struct sMatrix4x4Wrapper {
    sMatrix4x4 value;
    Lib3MF_double get_Field_0_0() const { return value.m_Field[0][0]; }
    void set_Field_0_0(Lib3MF_double v) { value.m_Field[0][0] = v; }
    Lib3MF_double get_Field_0_1() const { return value.m_Field[0][1]; }
    void set_Field_0_1(Lib3MF_double v) { value.m_Field[0][1] = v; }
    Lib3MF_double get_Field_0_2() const { return value.m_Field[0][2]; }
    void set_Field_0_2(Lib3MF_double v) { value.m_Field[0][2] = v; }
    Lib3MF_double get_Field_0_3() const { return value.m_Field[0][3]; }
    void set_Field_0_3(Lib3MF_double v) { value.m_Field[0][3] = v; }
    Lib3MF_double get_Field_1_0() const { return value.m_Field[1][0]; }
    void set_Field_1_0(Lib3MF_double v) { value.m_Field[1][0] = v; }
    Lib3MF_double get_Field_1_1() const { return value.m_Field[1][1]; }
    void set_Field_1_1(Lib3MF_double v) { value.m_Field[1][1] = v; }
    Lib3MF_double get_Field_1_2() const { return value.m_Field[1][2]; }
    void set_Field_1_2(Lib3MF_double v) { value.m_Field[1][2] = v; }
    Lib3MF_double get_Field_1_3() const { return value.m_Field[1][3]; }
    void set_Field_1_3(Lib3MF_double v) { value.m_Field[1][3] = v; }
    Lib3MF_double get_Field_2_0() const { return value.m_Field[2][0]; }
    void set_Field_2_0(Lib3MF_double v) { value.m_Field[2][0] = v; }
    Lib3MF_double get_Field_2_1() const { return value.m_Field[2][1]; }
    void set_Field_2_1(Lib3MF_double v) { value.m_Field[2][1] = v; }
    Lib3MF_double get_Field_2_2() const { return value.m_Field[2][2]; }
    void set_Field_2_2(Lib3MF_double v) { value.m_Field[2][2] = v; }
    Lib3MF_double get_Field_2_3() const { return value.m_Field[2][3]; }
    void set_Field_2_3(Lib3MF_double v) { value.m_Field[2][3] = v; }
    Lib3MF_double get_Field_3_0() const { return value.m_Field[3][0]; }
    void set_Field_3_0(Lib3MF_double v) { value.m_Field[3][0] = v; }
    Lib3MF_double get_Field_3_1() const { return value.m_Field[3][1]; }
    void set_Field_3_1(Lib3MF_double v) { value.m_Field[3][1] = v; }
    Lib3MF_double get_Field_3_2() const { return value.m_Field[3][2]; }
    void set_Field_3_2(Lib3MF_double v) { value.m_Field[3][2] = v; }
    Lib3MF_double get_Field_3_3() const { return value.m_Field[3][3]; }
    void set_Field_3_3(Lib3MF_double v) { value.m_Field[3][3] = v; }

    sMatrix4x4 toStruct() const { return value; }

    static sMatrix4x4Wrapper fromStruct(const emscripten::val &js) {
        sMatrix4x4Wrapper wrapper;
        wrapper.value.m_Field[0][0] = js["Field_0_0"].as<Lib3MF_double>();
        wrapper.value.m_Field[1][0] = js["Field_1_0"].as<Lib3MF_double>();
        wrapper.value.m_Field[2][0] = js["Field_2_0"].as<Lib3MF_double>();
        wrapper.value.m_Field[3][0] = js["Field_3_0"].as<Lib3MF_double>();
        wrapper.value.m_Field[0][1] = js["Field_0_1"].as<Lib3MF_double>();
        wrapper.value.m_Field[1][1] = js["Field_1_1"].as<Lib3MF_double>();
        wrapper.value.m_Field[2][1] = js["Field_2_1"].as<Lib3MF_double>();
        wrapper.value.m_Field[3][1] = js["Field_3_1"].as<Lib3MF_double>();
        wrapper.value.m_Field[0][2] = js["Field_0_2"].as<Lib3MF_double>();
        wrapper.value.m_Field[1][2] = js["Field_1_2"].as<Lib3MF_double>();
        wrapper.value.m_Field[2][2] = js["Field_2_2"].as<Lib3MF_double>();
        wrapper.value.m_Field[3][2] = js["Field_3_2"].as<Lib3MF_double>();
        wrapper.value.m_Field[0][3] = js["Field_0_3"].as<Lib3MF_double>();
        wrapper.value.m_Field[1][3] = js["Field_1_3"].as<Lib3MF_double>();
        wrapper.value.m_Field[2][3] = js["Field_2_3"].as<Lib3MF_double>();
        wrapper.value.m_Field[3][3] = js["Field_3_3"].as<Lib3MF_double>();
        return wrapper;
    }
};

static void wrap_Resource_SetPackagePart(CResource &self, PPackagePart& PackagePart) {
    self.SetPackagePart(classParam(PackagePart));
}

static void wrap_MetaDataGroup_RemoveMetaData(CMetaDataGroup &self, PMetaData& TheMetaData) {
    self.RemoveMetaData(classParam(TheMetaData));
}

static void wrap_TriangleSet_Merge(CTriangleSet &self, PTriangleSet& OtherTriangleSet, const bool& DeleteOther) {
    self.Merge(classParam(OtherTriangleSet), DeleteOther);
}

static void wrap_Object_SetAttachmentAsThumbnail(CObject &self, PAttachment& Attachment) {
    self.SetAttachmentAsThumbnail(classParam(Attachment));
}

static sBoxWrapper wrap_Object_GetOutbox(CObject &self) {
    auto result = self.GetOutbox();
    sBoxWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_Object_AssignSliceStack(CObject &self, PSliceStack& SliceStackInstance) {
    self.AssignSliceStack(classParam(SliceStackInstance));
}

static sPositionWrapper wrap_MeshObject_GetVertex(CMeshObject &self, const Lib3MF_uint32& Index) {
    auto result = self.GetVertex(Index);
    sPositionWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_MeshObject_SetVertex(CMeshObject &self, const Lib3MF_uint32& Index, const sPositionWrapper& Coordinates) {
    self.SetVertex(Index, Coordinates.toStruct());
}

static Lib3MF_uint32 wrap_MeshObject_AddVertex(CMeshObject &self, const sPositionWrapper& Coordinates) {
    auto result = self.AddVertex(Coordinates.toStruct());
    return result;
}

static sTriangleWrapper wrap_MeshObject_GetTriangle(CMeshObject &self, const Lib3MF_uint32& Index) {
    auto result = self.GetTriangle(Index);
    sTriangleWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_MeshObject_SetTriangle(CMeshObject &self, const Lib3MF_uint32& Index, const sTriangleWrapper& Indices) {
    self.SetTriangle(Index, Indices.toStruct());
}

static Lib3MF_uint32 wrap_MeshObject_AddTriangle(CMeshObject &self, const sTriangleWrapper& Indices) {
    auto result = self.AddTriangle(Indices.toStruct());
    return result;
}

static void wrap_MeshObject_SetTriangleProperties(CMeshObject &self, const Lib3MF_uint32& Index, const sTrianglePropertiesWrapper& Properties) {
    self.SetTriangleProperties(Index, Properties.toStruct());
}

static void wrap_MeshObject_SetAllTriangleProperties(CMeshObject &self, const std::vector<sTrianglePropertiesWrapper>& PropertiesArray) {
    std::vector<sTriangleProperties> converted_PropertiesArray;
    converted_PropertiesArray.reserve(PropertiesArray.size());
    for (const auto& w : PropertiesArray) converted_PropertiesArray.push_back(w.toStruct());
    self.SetAllTriangleProperties(converted_PropertiesArray);
}

static void wrap_MeshObject_SetGeometry(CMeshObject &self, const std::vector<sPositionWrapper>& Vertices, const std::vector<sTriangleWrapper>& Indices) {
    std::vector<sPosition> converted_Vertices;
    converted_Vertices.reserve(Vertices.size());
    for (const auto& w : Vertices) converted_Vertices.push_back(w.toStruct());
    std::vector<sTriangle> converted_Indices;
    converted_Indices.reserve(Indices.size());
    for (const auto& w : Indices) converted_Indices.push_back(w.toStruct());
    self.SetGeometry(converted_Vertices, converted_Indices);
}

static void wrap_MeshObject_SetVolumeData(CMeshObject &self, PVolumeData& TheVolumeData) {
    self.SetVolumeData(classParam(TheVolumeData));
}

static void wrap_LevelSet_SetFunction(CLevelSet &self, PFunction& TheFunction) {
    self.SetFunction(classParam(TheFunction));
}

static sTransformWrapper wrap_LevelSet_GetTransform(CLevelSet &self) {
    auto result = self.GetTransform();
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_LevelSet_SetTransform(CLevelSet &self, const sTransformWrapper& Transform) {
    self.SetTransform(Transform.toStruct());
}

static void wrap_LevelSet_SetMesh(CLevelSet &self, PMeshObject& TheMesh) {
    self.SetMesh(classParam(TheMesh));
}

static void wrap_LevelSet_SetVolumeData(CLevelSet &self, PVolumeData& TheVolumeData) {
    self.SetVolumeData(classParam(TheVolumeData));
}

static sBeamWrapper wrap_BeamLattice_GetBeam(CBeamLattice &self, const Lib3MF_uint32& Index) {
    auto result = self.GetBeam(Index);
    sBeamWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static Lib3MF_uint32 wrap_BeamLattice_AddBeam(CBeamLattice &self, const sBeamWrapper& BeamInfo) {
    auto result = self.AddBeam(BeamInfo.toStruct());
    return result;
}

static void wrap_BeamLattice_SetBeam(CBeamLattice &self, const Lib3MF_uint32& Index, const sBeamWrapper& BeamInfo) {
    self.SetBeam(Index, BeamInfo.toStruct());
}

static void wrap_BeamLattice_SetBeams(CBeamLattice &self, const std::vector<sBeamWrapper>& BeamInfo) {
    std::vector<sBeam> converted_BeamInfo;
    converted_BeamInfo.reserve(BeamInfo.size());
    for (const auto& w : BeamInfo) converted_BeamInfo.push_back(w.toStruct());
    self.SetBeams(converted_BeamInfo);
}

static sBallWrapper wrap_BeamLattice_GetBall(CBeamLattice &self, const Lib3MF_uint32& Index) {
    auto result = self.GetBall(Index);
    sBallWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static Lib3MF_uint32 wrap_BeamLattice_AddBall(CBeamLattice &self, const sBallWrapper& BallInfo) {
    auto result = self.AddBall(BallInfo.toStruct());
    return result;
}

static void wrap_BeamLattice_SetBall(CBeamLattice &self, const Lib3MF_uint32& Index, const sBallWrapper& BallInfo) {
    self.SetBall(Index, BallInfo.toStruct());
}

static void wrap_BeamLattice_SetBalls(CBeamLattice &self, const std::vector<sBallWrapper>& BallInfo) {
    std::vector<sBall> converted_BallInfo;
    converted_BallInfo.reserve(BallInfo.size());
    for (const auto& w : BallInfo) converted_BallInfo.push_back(w.toStruct());
    self.SetBalls(converted_BallInfo);
}

static sTransformWrapper wrap_FunctionReference_GetTransform(CFunctionReference &self) {
    auto result = self.GetTransform();
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_FunctionReference_SetTransform(CFunctionReference &self, const sTransformWrapper& Transform) {
    self.SetTransform(Transform.toStruct());
}

static void wrap_VolumeDataComposite_SetBaseMaterialGroup(CVolumeDataComposite &self, PBaseMaterialGroup& BaseMaterialGroupInstance) {
    self.SetBaseMaterialGroup(classParam(BaseMaterialGroupInstance));
}

static PMaterialMapping wrap_VolumeDataComposite_AddMaterialMapping(CVolumeDataComposite &self, const sTransformWrapper& Transform) {
    auto result = self.AddMaterialMapping(Transform.toStruct());
    return result;
}

static PVolumeDataColor wrap_VolumeData_CreateNewColor(CVolumeData &self, PFunction& TheFunction) {
    auto result = self.CreateNewColor(classParam(TheFunction));
    return result;
}

static PVolumeDataProperty wrap_VolumeData_AddPropertyFromFunction(CVolumeData &self, const std::string& Name, PFunction& TheFunction) {
    auto result = self.AddPropertyFromFunction(Name, classParam(TheFunction));
    return result;
}

static sTransformWrapper wrap_Component_GetTransform(CComponent &self) {
    auto result = self.GetTransform();
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_Component_SetTransform(CComponent &self, const sTransformWrapper& Transform) {
    self.SetTransform(Transform.toStruct());
}

static PComponent wrap_ComponentsObject_AddComponent(CComponentsObject &self, PObject& ObjectResource, const sTransformWrapper& Transform) {
    auto result = self.AddComponent(classParam(ObjectResource), Transform.toStruct());
    return result;
}

static Lib3MF_uint32 wrap_BaseMaterialGroup_AddMaterial(CBaseMaterialGroup &self, const std::string& Name, const sColorWrapper& DisplayColor) {
    auto result = self.AddMaterial(Name, DisplayColor.toStruct());
    return result;
}

static void wrap_BaseMaterialGroup_SetDisplayColor(CBaseMaterialGroup &self, const Lib3MF_uint32& PropertyID, const sColorWrapper& TheColor) {
    self.SetDisplayColor(PropertyID, TheColor.toStruct());
}

static sColorWrapper wrap_BaseMaterialGroup_GetDisplayColor(CBaseMaterialGroup &self, const Lib3MF_uint32& PropertyID) {
    auto result = self.GetDisplayColor(PropertyID);
    sColorWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static Lib3MF_uint32 wrap_ColorGroup_AddColor(CColorGroup &self, const sColorWrapper& TheColor) {
    auto result = self.AddColor(TheColor.toStruct());
    return result;
}

static void wrap_ColorGroup_SetColor(CColorGroup &self, const Lib3MF_uint32& PropertyID, const sColorWrapper& TheColor) {
    self.SetColor(PropertyID, TheColor.toStruct());
}

static sColorWrapper wrap_ColorGroup_GetColor(CColorGroup &self, const Lib3MF_uint32& PropertyID) {
    auto result = self.GetColor(PropertyID);
    sColorWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static Lib3MF_uint32 wrap_Texture2DGroup_AddTex2Coord(CTexture2DGroup &self, const sTex2CoordWrapper& UVCoordinate) {
    auto result = self.AddTex2Coord(UVCoordinate.toStruct());
    return result;
}

static sTex2CoordWrapper wrap_Texture2DGroup_GetTex2Coord(CTexture2DGroup &self, const Lib3MF_uint32& PropertyID) {
    auto result = self.GetTex2Coord(PropertyID);
    sTex2CoordWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static Lib3MF_uint32 wrap_CompositeMaterials_AddComposite(CCompositeMaterials &self, const std::vector<sCompositeConstituentWrapper>& Composite) {
    std::vector<sCompositeConstituent> converted_Composite;
    converted_Composite.reserve(Composite.size());
    for (const auto& w : Composite) converted_Composite.push_back(w.toStruct());
    auto result = self.AddComposite(converted_Composite);
    return result;
}

static Lib3MF_uint32 wrap_MultiPropertyGroup_AddLayer(CMultiPropertyGroup &self, const sMultiPropertyLayerWrapper& TheLayer) {
    auto result = self.AddLayer(TheLayer.toStruct());
    return result;
}

static sMultiPropertyLayerWrapper wrap_MultiPropertyGroup_GetLayer(CMultiPropertyGroup &self, const Lib3MF_uint32& LayerIndex) {
    auto result = self.GetLayer(LayerIndex);
    sMultiPropertyLayerWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_ImageStack_SetSheet(CImageStack &self, const Lib3MF_uint32& Index, PAttachment& Sheet) {
    self.SetSheet(Index, classParam(Sheet));
}

static void wrap_Texture2D_SetAttachment(CTexture2D &self, PAttachment& Attachment) {
    self.SetAttachment(classParam(Attachment));
}

static void wrap_ResourceIdNode_SetResource(CResourceIdNode &self, PResource& Resource) {
    self.SetResource(classParam(Resource));
}

static void wrap_ConstVecNode_SetVector(CConstVecNode &self, const sVectorWrapper& Value) {
    self.SetVector(Value.toStruct());
}

static sVectorWrapper wrap_ConstVecNode_GetVector(CConstVecNode &self) {
    auto result = self.GetVector();
    sVectorWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_ConstMatNode_SetMatrix(CConstMatNode &self, const sMatrix4x4Wrapper& Value) {
    self.SetMatrix(Value.toStruct());
}

static sMatrix4x4Wrapper wrap_ConstMatNode_GetMatrix(CConstMatNode &self) {
    auto result = self.GetMatrix();
    sMatrix4x4Wrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_Function_RemoveInput(CFunction &self, PImplicitPort& Input) {
    self.RemoveInput(classParam(Input));
}

static void wrap_Function_RemoveOutput(CFunction &self, PImplicitPort& Output) {
    self.RemoveOutput(classParam(Output));
}

static void wrap_ImplicitFunction_RemoveNode(CImplicitFunction &self, PImplicitNode& Node) {
    self.RemoveNode(classParam(Node));
}

static void wrap_ImplicitFunction_AddLink(CImplicitFunction &self, PImplicitPort& Source, PImplicitPort& Target) {
    self.AddLink(classParam(Source), classParam(Target));
}

static void wrap_FunctionFromImage3D_SetImage3D(CFunctionFromImage3D &self, PImage3D& Image3D) {
    self.SetImage3D(classParam(Image3D));
}

static sTransformWrapper wrap_BuildItem_GetObjectTransform(CBuildItem &self) {
    auto result = self.GetObjectTransform();
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_BuildItem_SetObjectTransform(CBuildItem &self, const sTransformWrapper& Transform) {
    self.SetObjectTransform(Transform.toStruct());
}

static sBoxWrapper wrap_BuildItem_GetOutbox(CBuildItem &self) {
    auto result = self.GetOutbox();
    sBoxWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_Slice_SetVertices(CSlice &self, const std::vector<sPosition2DWrapper>& Vertices) {
    std::vector<sPosition2D> converted_Vertices;
    converted_Vertices.reserve(Vertices.size());
    for (const auto& w : Vertices) converted_Vertices.push_back(w.toStruct());
    self.SetVertices(converted_Vertices);
}

static void wrap_SliceStack_AddSliceStackReference(CSliceStack &self, PSliceStack& TheSliceStack) {
    self.AddSliceStackReference(classParam(TheSliceStack));
}

static PAccessRight wrap_ResourceDataGroup_AddAccessRight(CResourceDataGroup &self, PConsumer& Consumer, const eWrappingAlgorithm& WrappingAlgorithm, const eMgfAlgorithm& MgfAlgorithm, const eDigestMethod& DigestMethod) {
    auto result = self.AddAccessRight(classParam(Consumer), WrappingAlgorithm, MgfAlgorithm, DigestMethod);
    return result;
}

static PAccessRight wrap_ResourceDataGroup_FindAccessRightByConsumer(CResourceDataGroup &self, PConsumer& Consumer) {
    auto result = self.FindAccessRightByConsumer(classParam(Consumer));
    return result;
}

static void wrap_ResourceDataGroup_RemoveAccessRight(CResourceDataGroup &self, PConsumer& Consumer) {
    self.RemoveAccessRight(classParam(Consumer));
}

static void wrap_KeyStore_RemoveConsumer(CKeyStore &self, PConsumer& Consumer) {
    self.RemoveConsumer(classParam(Consumer));
}

static void wrap_KeyStore_RemoveResourceDataGroup(CKeyStore &self, PResourceDataGroup& ResourceDataGroup) {
    self.RemoveResourceDataGroup(classParam(ResourceDataGroup));
}

static PResourceDataGroup wrap_KeyStore_FindResourceDataGroup(CKeyStore &self, PPackagePart& PartPath) {
    auto result = self.FindResourceDataGroup(classParam(PartPath));
    return result;
}

static PResourceData wrap_KeyStore_AddResourceData(CKeyStore &self, PResourceDataGroup& ResourceDataGroup, PPackagePart& PartPath, const eEncryptionAlgorithm& Algorithm, const eCompression& Compression, std::vector<Lib3MF_uint8>& AdditionalAuthenticationData) {
    auto result = self.AddResourceData(classParam(ResourceDataGroup), classParam(PartPath), Algorithm, Compression, AdditionalAuthenticationData);
    return result;
}

static void wrap_KeyStore_RemoveResourceData(CKeyStore &self, PResourceData& ResourceData) {
    self.RemoveResourceData(classParam(ResourceData));
}

static PResourceData wrap_KeyStore_FindResourceData(CKeyStore &self, PPackagePart& ResourcePath) {
    auto result = self.FindResourceData(classParam(ResourcePath));
    return result;
}

static sBoxWrapper wrap_Model_GetOutbox(CModel &self) {
    auto result = self.GetOutbox();
    sBoxWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static void wrap_Model_MergeFromModel(CModel &self, PModel& ModelInstance) {
    self.MergeFromModel(classParam(ModelInstance));
}

static PTexture2D wrap_Model_AddTexture2DFromAttachment(CModel &self, PAttachment& TextureAttachment) {
    auto result = self.AddTexture2DFromAttachment(classParam(TextureAttachment));
    return result;
}

static PTexture2DGroup wrap_Model_AddTexture2DGroup(CModel &self, PTexture2D& Texture2DInstance) {
    auto result = self.AddTexture2DGroup(classParam(Texture2DInstance));
    return result;
}

static PCompositeMaterials wrap_Model_AddCompositeMaterials(CModel &self, PBaseMaterialGroup& BaseMaterialGroupInstance) {
    auto result = self.AddCompositeMaterials(classParam(BaseMaterialGroupInstance));
    return result;
}

static PBuildItem wrap_Model_AddBuildItem(CModel &self, PObject& Object, const sTransformWrapper& Transform) {
    auto result = self.AddBuildItem(classParam(Object), Transform.toStruct());
    return result;
}

static void wrap_Model_RemoveBuildItem(CModel &self, PBuildItem& BuildItemInstance) {
    self.RemoveBuildItem(classParam(BuildItemInstance));
}

static void wrap_Model_RemoveAttachment(CModel &self, PAttachment& AttachmentInstance) {
    self.RemoveAttachment(classParam(AttachmentInstance));
}

static PFunctionFromImage3D wrap_Model_AddFunctionFromImage3D(CModel &self, PImage3D& Image3DInstance) {
    auto result = self.AddFunctionFromImage3D(classParam(Image3DInstance));
    return result;
}

static void wrap_Model_RemoveResource(CModel &self, PResource& Resource) {
    self.RemoveResource(classParam(Resource));
}

static void wrap_Wrapper_Release(CWrapper &self, PBase& Instance) {
    self.Release(classParam(Instance));
}

static void wrap_Wrapper_Acquire(CWrapper &self, PBase& Instance) {
    self.Acquire(classParam(Instance));
}

static sColorWrapper wrap_Wrapper_RGBAToColor(CWrapper &self, const Lib3MF_uint8& Red, const Lib3MF_uint8& Green, const Lib3MF_uint8& Blue, const Lib3MF_uint8& Alpha) {
    auto result = self.RGBAToColor(Red, Green, Blue, Alpha);
    sColorWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static sColorWrapper wrap_Wrapper_FloatRGBAToColor(CWrapper &self, const Lib3MF_single& Red, const Lib3MF_single& Green, const Lib3MF_single& Blue, const Lib3MF_single& Alpha) {
    auto result = self.FloatRGBAToColor(Red, Green, Blue, Alpha);
    sColorWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static sTransformWrapper wrap_Wrapper_GetIdentityTransform(CWrapper &self) {
    auto result = self.GetIdentityTransform();
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static sTransformWrapper wrap_Wrapper_GetUniformScaleTransform(CWrapper &self, const Lib3MF_single& Factor) {
    auto result = self.GetUniformScaleTransform(Factor);
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static sTransformWrapper wrap_Wrapper_GetScaleTransform(CWrapper &self, const Lib3MF_single& FactorX, const Lib3MF_single& FactorY, const Lib3MF_single& FactorZ) {
    auto result = self.GetScaleTransform(FactorX, FactorY, FactorZ);
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static sTransformWrapper wrap_Wrapper_GetTranslationTransform(CWrapper &self, const Lib3MF_single& VectorX, const Lib3MF_single& VectorY, const Lib3MF_single& VectorZ) {
    auto result = self.GetTranslationTransform(VectorX, VectorY, VectorZ);
    sTransformWrapper wrapper;
    wrapper.value = result;
    return wrapper;
}

static emscripten::val wrap_Writer_WriteToBuffer(CWriter &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> Buffer;
    self.WriteToBuffer(Buffer);
    output.set("Buffer", Buffer);
    return output;
}

static emscripten::val wrap_Writer_GetWarning(CWriter &self, const Lib3MF_uint32& Index) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_uint32 ErrorCode;
    std::string return_value = self.GetWarning(Index, ErrorCode);
    output.set("return", return_value);
    output.set("ErrorCode", ErrorCode);
    return output;
}

static emscripten::val wrap_Reader_GetWarning(CReader &self, const Lib3MF_uint32& Index) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_uint32 ErrorCode;
    std::string return_value = self.GetWarning(Index, ErrorCode);
    output.set("return", return_value);
    output.set("ErrorCode", ErrorCode);
    return output;
}

static emscripten::val wrap_TriangleSet_GetTriangleList(CTriangleSet &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> TriangleIndices;
    self.GetTriangleList(TriangleIndices);
    output.set("TriangleIndices", TriangleIndices);
    return output;
}

static emscripten::val wrap_Object_GetUUID(CObject &self) {
    emscripten::val output = emscripten::val::object();
    bool HasUUID;
    std::string return_value = self.GetUUID(HasUUID);
    output.set("return", return_value);
    output.set("HasUUID", HasUUID);
    return output;
}

static emscripten::val wrap_MeshObject_GetVertices(CMeshObject &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<sPosition> Vertices;
    self.GetVertices(Vertices);
    output.set("Vertices", Vertices);
    return output;
}

static emscripten::val wrap_MeshObject_GetTriangleIndices(CMeshObject &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<sTriangle> Indices;
    self.GetTriangleIndices(Indices);
    output.set("Indices", Indices);
    return output;
}

static emscripten::val wrap_MeshObject_GetObjectLevelProperty(CMeshObject &self) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_uint32 UniqueResourceID;
    Lib3MF_uint32 PropertyID;
    bool return_value = self.GetObjectLevelProperty(UniqueResourceID, PropertyID);
    output.set("return", return_value);
    output.set("UniqueResourceID", UniqueResourceID);
    output.set("PropertyID", PropertyID);
    return output;
}

static emscripten::val wrap_MeshObject_GetTriangleProperties(CMeshObject &self, const Lib3MF_uint32& Index) {
    emscripten::val output = emscripten::val::object();
    sTrianglePropertiesWrapper Property;
    self.GetTriangleProperties(Index, Property.value);
    output.set("Property", Property);
    return output;
}

static emscripten::val wrap_MeshObject_GetAllTriangleProperties(CMeshObject &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<sTriangleProperties> PropertiesArray;
    self.GetAllTriangleProperties(PropertiesArray);
    output.set("PropertiesArray", PropertiesArray);
    return output;
}

static emscripten::val wrap_BeamLattice_GetClipping(CBeamLattice &self) {
    emscripten::val output = emscripten::val::object();
    eBeamLatticeClipMode ClipMode;
    Lib3MF_uint32 UniqueResourceID;
    self.GetClipping(ClipMode, UniqueResourceID);
    output.set("ClipMode", ClipMode);
    output.set("UniqueResourceID", UniqueResourceID);
    return output;
}

static emscripten::val wrap_BeamLattice_GetRepresentation(CBeamLattice &self) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_uint32 UniqueResourceID;
    bool return_value = self.GetRepresentation(UniqueResourceID);
    output.set("return", return_value);
    output.set("UniqueResourceID", UniqueResourceID);
    return output;
}

static emscripten::val wrap_BeamLattice_GetBallOptions(CBeamLattice &self) {
    emscripten::val output = emscripten::val::object();
    eBeamLatticeBallMode BallMode;
    Lib3MF_double BallRadius;
    self.GetBallOptions(BallMode, BallRadius);
    output.set("BallMode", BallMode);
    output.set("BallRadius", BallRadius);
    return output;
}

static emscripten::val wrap_BeamLattice_GetBeams(CBeamLattice &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<sBeam> BeamInfo;
    self.GetBeams(BeamInfo);
    output.set("BeamInfo", BeamInfo);
    return output;
}

static emscripten::val wrap_BeamLattice_GetBalls(CBeamLattice &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<sBall> BallInfo;
    self.GetBalls(BallInfo);
    output.set("BallInfo", BallInfo);
    return output;
}

static emscripten::val wrap_Component_GetUUID(CComponent &self) {
    emscripten::val output = emscripten::val::object();
    bool HasUUID;
    std::string return_value = self.GetUUID(HasUUID);
    output.set("return", return_value);
    output.set("HasUUID", HasUUID);
    return output;
}

static emscripten::val wrap_BeamSet_GetReferences(CBeamSet &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> References;
    self.GetReferences(References);
    output.set("References", References);
    return output;
}

static emscripten::val wrap_BeamSet_GetBallReferences(CBeamSet &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> BallReferences;
    self.GetBallReferences(BallReferences);
    output.set("BallReferences", BallReferences);
    return output;
}

static emscripten::val wrap_BaseMaterialGroup_GetAllPropertyIDs(CBaseMaterialGroup &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> PropertyIDs;
    self.GetAllPropertyIDs(PropertyIDs);
    output.set("PropertyIDs", PropertyIDs);
    return output;
}

static emscripten::val wrap_ColorGroup_GetAllPropertyIDs(CColorGroup &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> PropertyIDs;
    self.GetAllPropertyIDs(PropertyIDs);
    output.set("PropertyIDs", PropertyIDs);
    return output;
}

static emscripten::val wrap_Texture2DGroup_GetAllPropertyIDs(CTexture2DGroup &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> PropertyIDs;
    self.GetAllPropertyIDs(PropertyIDs);
    output.set("PropertyIDs", PropertyIDs);
    return output;
}

static emscripten::val wrap_CompositeMaterials_GetAllPropertyIDs(CCompositeMaterials &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> PropertyIDs;
    self.GetAllPropertyIDs(PropertyIDs);
    output.set("PropertyIDs", PropertyIDs);
    return output;
}

static emscripten::val wrap_CompositeMaterials_GetComposite(CCompositeMaterials &self, const Lib3MF_uint32& PropertyID) {
    emscripten::val output = emscripten::val::object();
    std::vector<sCompositeConstituent> Composite;
    self.GetComposite(PropertyID, Composite);
    output.set("Composite", Composite);
    return output;
}

static emscripten::val wrap_MultiPropertyGroup_GetAllPropertyIDs(CMultiPropertyGroup &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> PropertyIDs;
    self.GetAllPropertyIDs(PropertyIDs);
    output.set("PropertyIDs", PropertyIDs);
    return output;
}

static emscripten::val wrap_MultiPropertyGroup_GetMultiProperty(CMultiPropertyGroup &self, const Lib3MF_uint32& PropertyID) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> PropertyIDs;
    self.GetMultiProperty(PropertyID, PropertyIDs);
    output.set("PropertyIDs", PropertyIDs);
    return output;
}

static emscripten::val wrap_Attachment_WriteToBuffer(CAttachment &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> Buffer;
    self.WriteToBuffer(Buffer);
    output.set("Buffer", Buffer);
    return output;
}

static emscripten::val wrap_Texture2D_GetTileStyleUV(CTexture2D &self) {
    emscripten::val output = emscripten::val::object();
    eTextureTileStyle TileStyleU;
    eTextureTileStyle TileStyleV;
    self.GetTileStyleUV(TileStyleU, TileStyleV);
    output.set("TileStyleU", TileStyleU);
    output.set("TileStyleV", TileStyleV);
    return output;
}

static emscripten::val wrap_FunctionFromImage3D_GetTileStyles(CFunctionFromImage3D &self) {
    emscripten::val output = emscripten::val::object();
    eTextureTileStyle TileStyleU;
    eTextureTileStyle TileStyleV;
    eTextureTileStyle TileStyleW;
    self.GetTileStyles(TileStyleU, TileStyleV, TileStyleW);
    output.set("TileStyleU", TileStyleU);
    output.set("TileStyleV", TileStyleV);
    output.set("TileStyleW", TileStyleW);
    return output;
}

static emscripten::val wrap_BuildItem_GetUUID(CBuildItem &self) {
    emscripten::val output = emscripten::val::object();
    bool HasUUID;
    std::string return_value = self.GetUUID(HasUUID);
    output.set("return", return_value);
    output.set("HasUUID", HasUUID);
    return output;
}

static emscripten::val wrap_Slice_GetVertices(CSlice &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<sPosition2D> Vertices;
    self.GetVertices(Vertices);
    output.set("Vertices", Vertices);
    return output;
}

static emscripten::val wrap_Slice_GetPolygonIndices(CSlice &self, const Lib3MF_uint64& Index) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint32> Indices;
    self.GetPolygonIndices(Index, Indices);
    output.set("Indices", Indices);
    return output;
}

static emscripten::val wrap_ContentEncryptionParams_GetKey(CContentEncryptionParams &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> ByteData;
    self.GetKey(ByteData);
    output.set("ByteData", ByteData);
    return output;
}

static emscripten::val wrap_ContentEncryptionParams_GetInitializationVector(CContentEncryptionParams &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> ByteData;
    self.GetInitializationVector(ByteData);
    output.set("ByteData", ByteData);
    return output;
}

static emscripten::val wrap_ContentEncryptionParams_GetAuthenticationTag(CContentEncryptionParams &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> ByteData;
    self.GetAuthenticationTag(ByteData);
    output.set("ByteData", ByteData);
    return output;
}

static emscripten::val wrap_ContentEncryptionParams_GetAdditionalAuthenticationData(CContentEncryptionParams &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> ByteData;
    self.GetAdditionalAuthenticationData(ByteData);
    output.set("ByteData", ByteData);
    return output;
}

static emscripten::val wrap_ResourceData_GetAdditionalAuthenticationData(CResourceData &self) {
    emscripten::val output = emscripten::val::object();
    std::vector<Lib3MF_uint8> ByteData;
    self.GetAdditionalAuthenticationData(ByteData);
    output.set("ByteData", ByteData);
    return output;
}

static emscripten::val wrap_KeyStore_GetUUID(CKeyStore &self) {
    emscripten::val output = emscripten::val::object();
    bool HasUUID;
    std::string return_value = self.GetUUID(HasUUID);
    output.set("return", return_value);
    output.set("HasUUID", HasUUID);
    return output;
}

static emscripten::val wrap_Model_GetBuildUUID(CModel &self) {
    emscripten::val output = emscripten::val::object();
    bool HasUUID;
    std::string return_value = self.GetBuildUUID(HasUUID);
    output.set("return", return_value);
    output.set("HasUUID", HasUUID);
    return output;
}

static emscripten::val wrap_Wrapper_GetLibraryVersion(CWrapper &self) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_uint32 Major;
    Lib3MF_uint32 Minor;
    Lib3MF_uint32 Micro;
    self.GetLibraryVersion(Major, Minor, Micro);
    output.set("Major", Major);
    output.set("Minor", Minor);
    output.set("Micro", Micro);
    return output;
}

static emscripten::val wrap_Wrapper_GetPrereleaseInformation(CWrapper &self) {
    emscripten::val output = emscripten::val::object();
    std::string PrereleaseInfo;
    bool return_value = self.GetPrereleaseInformation(PrereleaseInfo);
    output.set("return", return_value);
    output.set("PrereleaseInfo", PrereleaseInfo);
    return output;
}

static emscripten::val wrap_Wrapper_GetBuildInformation(CWrapper &self) {
    emscripten::val output = emscripten::val::object();
    std::string BuildInformation;
    bool return_value = self.GetBuildInformation(BuildInformation);
    output.set("return", return_value);
    output.set("BuildInformation", BuildInformation);
    return output;
}

static emscripten::val wrap_Wrapper_GetSpecificationVersion(CWrapper &self, const std::string& SpecificationURL) {
    emscripten::val output = emscripten::val::object();
    bool IsSupported;
    Lib3MF_uint32 Major;
    Lib3MF_uint32 Minor;
    Lib3MF_uint32 Micro;
    self.GetSpecificationVersion(SpecificationURL, IsSupported, Major, Minor, Micro);
    output.set("IsSupported", IsSupported);
    output.set("Major", Major);
    output.set("Minor", Minor);
    output.set("Micro", Micro);
    return output;
}

static emscripten::val wrap_Wrapper_GetLastError(CWrapper &self, PBase& Instance) {
    emscripten::val output = emscripten::val::object();
    std::string LastErrorString;
    bool return_value = self.GetLastError(classParam(Instance), LastErrorString);
    output.set("return", return_value);
    output.set("LastErrorString", LastErrorString);
    return output;
}

static emscripten::val wrap_Wrapper_RetrieveProgressMessage(CWrapper &self, const eProgressIdentifier& TheProgressIdentifier) {
    emscripten::val output = emscripten::val::object();
    std::string ProgressMessage;
    self.RetrieveProgressMessage(TheProgressIdentifier, ProgressMessage);
    output.set("ProgressMessage", ProgressMessage);
    return output;
}

static emscripten::val wrap_Wrapper_ColorToRGBA(CWrapper &self, const sColorWrapper& TheColor) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_uint8 Red;
    Lib3MF_uint8 Green;
    Lib3MF_uint8 Blue;
    Lib3MF_uint8 Alpha;
    self.ColorToRGBA(TheColor.toStruct(), Red, Green, Blue, Alpha);
    output.set("Red", Red);
    output.set("Green", Green);
    output.set("Blue", Blue);
    output.set("Alpha", Alpha);
    return output;
}

static emscripten::val wrap_Wrapper_ColorToFloatRGBA(CWrapper &self, const sColorWrapper& TheColor) {
    emscripten::val output = emscripten::val::object();
    Lib3MF_single Red;
    Lib3MF_single Green;
    Lib3MF_single Blue;
    Lib3MF_single Alpha;
    self.ColorToFloatRGBA(TheColor.toStruct(), Red, Green, Blue, Alpha);
    output.set("Red", Red);
    output.set("Green", Green);
    output.set("Blue", Blue);
    output.set("Alpha", Alpha);
    return output;
}

// ================== Emscripten Bindings ==================
EMSCRIPTEN_BINDINGS(Lib3MF) {
    // Enums
    enum_<ePropertyType>("ePropertyType")
        .value("NoPropertyType", ePropertyType::NoPropertyType)
        .value("BaseMaterial", ePropertyType::BaseMaterial)
        .value("TexCoord", ePropertyType::TexCoord)
        .value("Colors", ePropertyType::Colors)
        .value("Composite", ePropertyType::Composite)
        .value("Multi", ePropertyType::Multi)
    ;
    enum_<eSlicesMeshResolution>("eSlicesMeshResolution")
        .value("Fullres", eSlicesMeshResolution::Fullres)
        .value("Lowres", eSlicesMeshResolution::Lowres)
    ;
    enum_<eModelUnit>("eModelUnit")
        .value("MicroMeter", eModelUnit::MicroMeter)
        .value("MilliMeter", eModelUnit::MilliMeter)
        .value("CentiMeter", eModelUnit::CentiMeter)
        .value("Inch", eModelUnit::Inch)
        .value("Foot", eModelUnit::Foot)
        .value("Meter", eModelUnit::Meter)
    ;
    enum_<eObjectType>("eObjectType")
        .value("Other", eObjectType::Other)
        .value("Model", eObjectType::Model)
        .value("Support", eObjectType::Support)
        .value("SolidSupport", eObjectType::SolidSupport)
        .value("Surface", eObjectType::Surface)
    ;
    enum_<eTextureType>("eTextureType")
        .value("Unknown", eTextureType::Unknown)
        .value("PNG", eTextureType::PNG)
        .value("JPEG", eTextureType::JPEG)
    ;
    enum_<eTextureTileStyle>("eTextureTileStyle")
        .value("Wrap", eTextureTileStyle::Wrap)
        .value("Mirror", eTextureTileStyle::Mirror)
        .value("Clamp", eTextureTileStyle::Clamp)
        .value("NoTileStyle", eTextureTileStyle::NoTileStyle)
    ;
    enum_<eTextureFilter>("eTextureFilter")
        .value("Auto", eTextureFilter::Auto)
        .value("Linear", eTextureFilter::Linear)
        .value("Nearest", eTextureFilter::Nearest)
    ;
    enum_<eBeamLatticeCapMode>("eBeamLatticeCapMode")
        .value("Sphere", eBeamLatticeCapMode::Sphere)
        .value("HemiSphere", eBeamLatticeCapMode::HemiSphere)
        .value("Butt", eBeamLatticeCapMode::Butt)
    ;
    enum_<eBeamLatticeClipMode>("eBeamLatticeClipMode")
        .value("NoClipMode", eBeamLatticeClipMode::NoClipMode)
        .value("Inside", eBeamLatticeClipMode::Inside)
        .value("Outside", eBeamLatticeClipMode::Outside)
    ;
    enum_<eBeamLatticeBallMode>("eBeamLatticeBallMode")
        .value("BeamLatticeBallModeNone", eBeamLatticeBallMode::BeamLatticeBallModeNone)
        .value("Mixed", eBeamLatticeBallMode::Mixed)
        .value("All", eBeamLatticeBallMode::All)
    ;
    enum_<eProgressIdentifier>("eProgressIdentifier")
        .value("QUERYCANCELED", eProgressIdentifier::QUERYCANCELED)
        .value("DONE", eProgressIdentifier::DONE)
        .value("CLEANUP", eProgressIdentifier::CLEANUP)
        .value("READSTREAM", eProgressIdentifier::READSTREAM)
        .value("EXTRACTOPCPACKAGE", eProgressIdentifier::EXTRACTOPCPACKAGE)
        .value("READNONROOTMODELS", eProgressIdentifier::READNONROOTMODELS)
        .value("READROOTMODEL", eProgressIdentifier::READROOTMODEL)
        .value("READRESOURCES", eProgressIdentifier::READRESOURCES)
        .value("READMESH", eProgressIdentifier::READMESH)
        .value("READSLICES", eProgressIdentifier::READSLICES)
        .value("READBUILD", eProgressIdentifier::READBUILD)
        .value("READCUSTOMATTACHMENT", eProgressIdentifier::READCUSTOMATTACHMENT)
        .value("READTEXTURETACHMENTS", eProgressIdentifier::READTEXTURETACHMENTS)
        .value("CREATEOPCPACKAGE", eProgressIdentifier::CREATEOPCPACKAGE)
        .value("WRITEMODELSTOSTREAM", eProgressIdentifier::WRITEMODELSTOSTREAM)
        .value("WRITEROOTMODEL", eProgressIdentifier::WRITEROOTMODEL)
        .value("WRITENONROOTMODELS", eProgressIdentifier::WRITENONROOTMODELS)
        .value("WRITEATTACHMENTS", eProgressIdentifier::WRITEATTACHMENTS)
        .value("WRITECONTENTTYPES", eProgressIdentifier::WRITECONTENTTYPES)
        .value("WRITENOBJECTS", eProgressIdentifier::WRITENOBJECTS)
        .value("WRITENODES", eProgressIdentifier::WRITENODES)
        .value("WRITETRIANGLES", eProgressIdentifier::WRITETRIANGLES)
        .value("WRITESLICES", eProgressIdentifier::WRITESLICES)
        .value("WRITEKEYSTORE", eProgressIdentifier::WRITEKEYSTORE)
    ;
    enum_<eBlendMethod>("eBlendMethod")
        .value("NoBlendMethod", eBlendMethod::NoBlendMethod)
        .value("Mix", eBlendMethod::Mix)
        .value("Multiply", eBlendMethod::Multiply)
    ;
    enum_<eChannelName>("eChannelName")
        .value("Red", eChannelName::Red)
        .value("Green", eChannelName::Green)
        .value("Blue", eChannelName::Blue)
        .value("Alpha", eChannelName::Alpha)
    ;
    enum_<eCompositionMethod>("eCompositionMethod")
        .value("WeightedSum", eCompositionMethod::WeightedSum)
        .value("Multiply", eCompositionMethod::Multiply)
        .value("Min", eCompositionMethod::Min)
        .value("Max", eCompositionMethod::Max)
        .value("Mask", eCompositionMethod::Mask)
    ;
    enum_<eCompositionSpace>("eCompositionSpace")
        .value("Raw", eCompositionSpace::Raw)
        .value("LinearColor", eCompositionSpace::LinearColor)
    ;
    enum_<eImplicitNodeType>("eImplicitNodeType")
        .value("Addition", eImplicitNodeType::Addition)
        .value("Subtraction", eImplicitNodeType::Subtraction)
        .value("Multiplication", eImplicitNodeType::Multiplication)
        .value("Division", eImplicitNodeType::Division)
        .value("Constant", eImplicitNodeType::Constant)
        .value("ConstVec", eImplicitNodeType::ConstVec)
        .value("ConstMat", eImplicitNodeType::ConstMat)
        .value("ComposeVector", eImplicitNodeType::ComposeVector)
        .value("DecomposeVector", eImplicitNodeType::DecomposeVector)
        .value("ComposeMatrix", eImplicitNodeType::ComposeMatrix)
        .value("MatrixFromColumns", eImplicitNodeType::MatrixFromColumns)
        .value("MatrixFromRows", eImplicitNodeType::MatrixFromRows)
        .value("Dot", eImplicitNodeType::Dot)
        .value("Cross", eImplicitNodeType::Cross)
        .value("MatVecMultiplication", eImplicitNodeType::MatVecMultiplication)
        .value("Transpose", eImplicitNodeType::Transpose)
        .value("Inverse", eImplicitNodeType::Inverse)
        .value("Sinus", eImplicitNodeType::Sinus)
        .value("Cosinus", eImplicitNodeType::Cosinus)
        .value("Tan", eImplicitNodeType::Tan)
        .value("ArcSin", eImplicitNodeType::ArcSin)
        .value("ArcCos", eImplicitNodeType::ArcCos)
        .value("ArcTan", eImplicitNodeType::ArcTan)
        .value("ArcTan2", eImplicitNodeType::ArcTan2)
        .value("Min", eImplicitNodeType::Min)
        .value("Max", eImplicitNodeType::Max)
        .value("Abs", eImplicitNodeType::Abs)
        .value("Fmod", eImplicitNodeType::Fmod)
        .value("Pow", eImplicitNodeType::Pow)
        .value("Sqrt", eImplicitNodeType::Sqrt)
        .value("Exp", eImplicitNodeType::Exp)
        .value("Log", eImplicitNodeType::Log)
        .value("Log2", eImplicitNodeType::Log2)
        .value("Log10", eImplicitNodeType::Log10)
        .value("Select", eImplicitNodeType::Select)
        .value("Clamp", eImplicitNodeType::Clamp)
        .value("Sinh", eImplicitNodeType::Sinh)
        .value("Cosh", eImplicitNodeType::Cosh)
        .value("Tanh", eImplicitNodeType::Tanh)
        .value("Round", eImplicitNodeType::Round)
        .value("Ceil", eImplicitNodeType::Ceil)
        .value("Floor", eImplicitNodeType::Floor)
        .value("Sign", eImplicitNodeType::Sign)
        .value("Fract", eImplicitNodeType::Fract)
        .value("FunctionCall", eImplicitNodeType::FunctionCall)
        .value("Mesh", eImplicitNodeType::Mesh)
        .value("Length", eImplicitNodeType::Length)
        .value("ConstResourceID", eImplicitNodeType::ConstResourceID)
        .value("VectorFromScalar", eImplicitNodeType::VectorFromScalar)
        .value("UnsignedMesh", eImplicitNodeType::UnsignedMesh)
        .value("Mod", eImplicitNodeType::Mod)
        .value("BeamLattice", eImplicitNodeType::BeamLattice)
        .value("FunctionGradient", eImplicitNodeType::FunctionGradient)
        .value("NormalizeDistance", eImplicitNodeType::NormalizeDistance)
    ;
    enum_<eImplicitPortType>("eImplicitPortType")
        .value("Scalar", eImplicitPortType::Scalar)
        .value("Vector", eImplicitPortType::Vector)
        .value("Matrix", eImplicitPortType::Matrix)
        .value("ResourceID", eImplicitPortType::ResourceID)
    ;
    enum_<eImplicitNodeConfiguration>("eImplicitNodeConfiguration")
        .value("Default", eImplicitNodeConfiguration::Default)
        .value("ScalarToScalar", eImplicitNodeConfiguration::ScalarToScalar)
        .value("VectorToVector", eImplicitNodeConfiguration::VectorToVector)
        .value("MatrixToMatrix", eImplicitNodeConfiguration::MatrixToMatrix)
    ;
    enum_<eEncryptionAlgorithm>("eEncryptionAlgorithm")
        .value("AES256_GCM", eEncryptionAlgorithm::AES256_GCM)
    ;
    enum_<eWrappingAlgorithm>("eWrappingAlgorithm")
        .value("RSA_OAEP", eWrappingAlgorithm::RSA_OAEP)
    ;
    enum_<eMgfAlgorithm>("eMgfAlgorithm")
        .value("MGF1_SHA1", eMgfAlgorithm::MGF1_SHA1)
        .value("MGF1_SHA224", eMgfAlgorithm::MGF1_SHA224)
        .value("MGF1_SHA256", eMgfAlgorithm::MGF1_SHA256)
        .value("MGF1_SHA384", eMgfAlgorithm::MGF1_SHA384)
        .value("MGF1_SHA512", eMgfAlgorithm::MGF1_SHA512)
    ;
    enum_<eDigestMethod>("eDigestMethod")
        .value("SHA1", eDigestMethod::SHA1)
        .value("SHA256", eDigestMethod::SHA256)
    ;
    enum_<eCompression>("eCompression")
        .value("NoCompression", eCompression::NoCompression)
        .value("Deflate", eCompression::Deflate)
    ;

    // Register JS bindings for struct-array wrappers
    register_vector<sTriangleWrapper>("std::vector<sTriangle>");
    register_vector<sTrianglePropertiesWrapper>("std::vector<sTriangleProperties>");
    register_vector<sPositionWrapper>("std::vector<sPosition>");
    register_vector<sPosition2DWrapper>("std::vector<sPosition2D>");
    register_vector<sCompositeConstituentWrapper>("std::vector<sCompositeConstituent>");
    register_vector<sMultiPropertyLayerWrapper>("std::vector<sMultiPropertyLayer>");
    register_vector<sTex2CoordWrapper>("std::vector<sTex2Coord>");
    register_vector<sTransformWrapper>("std::vector<sTransform>");
    register_vector<sBoxWrapper>("std::vector<sBox>");
    register_vector<sColorWrapper>("std::vector<sColor>");
    register_vector<sBeamWrapper>("std::vector<sBeam>");
    register_vector<sBallWrapper>("std::vector<sBall>");
    register_vector<sVectorWrapper>("std::vector<sVector>");
    register_vector<sMatrix4x4Wrapper>("std::vector<sMatrix4x4>");

    // Structs as exposed JS classes
    class_<sTriangleWrapper>("sTriangle")
        .constructor<>()
        .class_function("fromStruct", &sTriangleWrapper::fromStruct)
        .function("get_Indices0", &sTriangleWrapper::get_Indices0)
        .function("set_Indices0", &sTriangleWrapper::set_Indices0)
        .function("get_Indices1", &sTriangleWrapper::get_Indices1)
        .function("set_Indices1", &sTriangleWrapper::set_Indices1)
        .function("get_Indices2", &sTriangleWrapper::get_Indices2)
        .function("set_Indices2", &sTriangleWrapper::set_Indices2)
    ;
    class_<sTrianglePropertiesWrapper>("sTriangleProperties")
        .constructor<>()
        .class_function("fromStruct", &sTrianglePropertiesWrapper::fromStruct)
        .function("get_ResourceID", &sTrianglePropertiesWrapper::get_ResourceID)
        .function("set_ResourceID", &sTrianglePropertiesWrapper::set_ResourceID)
        .function("get_PropertyIDs0", &sTrianglePropertiesWrapper::get_PropertyIDs0)
        .function("set_PropertyIDs0", &sTrianglePropertiesWrapper::set_PropertyIDs0)
        .function("get_PropertyIDs1", &sTrianglePropertiesWrapper::get_PropertyIDs1)
        .function("set_PropertyIDs1", &sTrianglePropertiesWrapper::set_PropertyIDs1)
        .function("get_PropertyIDs2", &sTrianglePropertiesWrapper::get_PropertyIDs2)
        .function("set_PropertyIDs2", &sTrianglePropertiesWrapper::set_PropertyIDs2)
    ;
    class_<sPositionWrapper>("sPosition")
        .constructor<>()
        .class_function("fromStruct", &sPositionWrapper::fromStruct)
        .function("get_Coordinates0", &sPositionWrapper::get_Coordinates0)
        .function("set_Coordinates0", &sPositionWrapper::set_Coordinates0)
        .function("get_Coordinates1", &sPositionWrapper::get_Coordinates1)
        .function("set_Coordinates1", &sPositionWrapper::set_Coordinates1)
        .function("get_Coordinates2", &sPositionWrapper::get_Coordinates2)
        .function("set_Coordinates2", &sPositionWrapper::set_Coordinates2)
    ;
    class_<sPosition2DWrapper>("sPosition2D")
        .constructor<>()
        .class_function("fromStruct", &sPosition2DWrapper::fromStruct)
        .function("get_Coordinates0", &sPosition2DWrapper::get_Coordinates0)
        .function("set_Coordinates0", &sPosition2DWrapper::set_Coordinates0)
        .function("get_Coordinates1", &sPosition2DWrapper::get_Coordinates1)
        .function("set_Coordinates1", &sPosition2DWrapper::set_Coordinates1)
    ;
    class_<sCompositeConstituentWrapper>("sCompositeConstituent")
        .constructor<>()
        .class_function("fromStruct", &sCompositeConstituentWrapper::fromStruct)
        .function("get_PropertyID", &sCompositeConstituentWrapper::get_PropertyID)
        .function("set_PropertyID", &sCompositeConstituentWrapper::set_PropertyID)
        .function("get_MixingRatio", &sCompositeConstituentWrapper::get_MixingRatio)
        .function("set_MixingRatio", &sCompositeConstituentWrapper::set_MixingRatio)
    ;
    class_<sMultiPropertyLayerWrapper>("sMultiPropertyLayer")
        .constructor<>()
        .class_function("fromStruct", &sMultiPropertyLayerWrapper::fromStruct)
        .function("get_ResourceID", &sMultiPropertyLayerWrapper::get_ResourceID)
        .function("set_ResourceID", &sMultiPropertyLayerWrapper::set_ResourceID)
        .function("get_TheBlendMethod", &sMultiPropertyLayerWrapper::get_TheBlendMethod)
        .function("set_TheBlendMethod", &sMultiPropertyLayerWrapper::set_TheBlendMethod)
    ;
    class_<sTex2CoordWrapper>("sTex2Coord")
        .constructor<>()
        .class_function("fromStruct", &sTex2CoordWrapper::fromStruct)
        .function("get_U", &sTex2CoordWrapper::get_U)
        .function("set_U", &sTex2CoordWrapper::set_U)
        .function("get_V", &sTex2CoordWrapper::get_V)
        .function("set_V", &sTex2CoordWrapper::set_V)
    ;
    class_<sTransformWrapper>("sTransform")
        .constructor<>()
        .class_function("fromStruct", &sTransformWrapper::fromStruct)
        .function("get_Fields_0_0", &sTransformWrapper::get_Fields_0_0)
        .function("set_Fields_0_0", &sTransformWrapper::set_Fields_0_0)
        .function("get_Fields_0_1", &sTransformWrapper::get_Fields_0_1)
        .function("set_Fields_0_1", &sTransformWrapper::set_Fields_0_1)
        .function("get_Fields_0_2", &sTransformWrapper::get_Fields_0_2)
        .function("set_Fields_0_2", &sTransformWrapper::set_Fields_0_2)
        .function("get_Fields_1_0", &sTransformWrapper::get_Fields_1_0)
        .function("set_Fields_1_0", &sTransformWrapper::set_Fields_1_0)
        .function("get_Fields_1_1", &sTransformWrapper::get_Fields_1_1)
        .function("set_Fields_1_1", &sTransformWrapper::set_Fields_1_1)
        .function("get_Fields_1_2", &sTransformWrapper::get_Fields_1_2)
        .function("set_Fields_1_2", &sTransformWrapper::set_Fields_1_2)
        .function("get_Fields_2_0", &sTransformWrapper::get_Fields_2_0)
        .function("set_Fields_2_0", &sTransformWrapper::set_Fields_2_0)
        .function("get_Fields_2_1", &sTransformWrapper::get_Fields_2_1)
        .function("set_Fields_2_1", &sTransformWrapper::set_Fields_2_1)
        .function("get_Fields_2_2", &sTransformWrapper::get_Fields_2_2)
        .function("set_Fields_2_2", &sTransformWrapper::set_Fields_2_2)
        .function("get_Fields_3_0", &sTransformWrapper::get_Fields_3_0)
        .function("set_Fields_3_0", &sTransformWrapper::set_Fields_3_0)
        .function("get_Fields_3_1", &sTransformWrapper::get_Fields_3_1)
        .function("set_Fields_3_1", &sTransformWrapper::set_Fields_3_1)
        .function("get_Fields_3_2", &sTransformWrapper::get_Fields_3_2)
        .function("set_Fields_3_2", &sTransformWrapper::set_Fields_3_2)
    ;
    class_<sBoxWrapper>("sBox")
        .constructor<>()
        .class_function("fromStruct", &sBoxWrapper::fromStruct)
        .function("get_MinCoordinate0", &sBoxWrapper::get_MinCoordinate0)
        .function("set_MinCoordinate0", &sBoxWrapper::set_MinCoordinate0)
        .function("get_MinCoordinate1", &sBoxWrapper::get_MinCoordinate1)
        .function("set_MinCoordinate1", &sBoxWrapper::set_MinCoordinate1)
        .function("get_MinCoordinate2", &sBoxWrapper::get_MinCoordinate2)
        .function("set_MinCoordinate2", &sBoxWrapper::set_MinCoordinate2)
        .function("get_MaxCoordinate0", &sBoxWrapper::get_MaxCoordinate0)
        .function("set_MaxCoordinate0", &sBoxWrapper::set_MaxCoordinate0)
        .function("get_MaxCoordinate1", &sBoxWrapper::get_MaxCoordinate1)
        .function("set_MaxCoordinate1", &sBoxWrapper::set_MaxCoordinate1)
        .function("get_MaxCoordinate2", &sBoxWrapper::get_MaxCoordinate2)
        .function("set_MaxCoordinate2", &sBoxWrapper::set_MaxCoordinate2)
    ;
    class_<sColorWrapper>("sColor")
        .constructor<>()
        .class_function("fromStruct", &sColorWrapper::fromStruct)
        .function("get_Red", &sColorWrapper::get_Red)
        .function("set_Red", &sColorWrapper::set_Red)
        .function("get_Green", &sColorWrapper::get_Green)
        .function("set_Green", &sColorWrapper::set_Green)
        .function("get_Blue", &sColorWrapper::get_Blue)
        .function("set_Blue", &sColorWrapper::set_Blue)
        .function("get_Alpha", &sColorWrapper::get_Alpha)
        .function("set_Alpha", &sColorWrapper::set_Alpha)
    ;
    class_<sBeamWrapper>("sBeam")
        .constructor<>()
        .class_function("fromStruct", &sBeamWrapper::fromStruct)
        .function("get_Indices0", &sBeamWrapper::get_Indices0)
        .function("set_Indices0", &sBeamWrapper::set_Indices0)
        .function("get_Indices1", &sBeamWrapper::get_Indices1)
        .function("set_Indices1", &sBeamWrapper::set_Indices1)
        .function("get_Radii0", &sBeamWrapper::get_Radii0)
        .function("set_Radii0", &sBeamWrapper::set_Radii0)
        .function("get_Radii1", &sBeamWrapper::get_Radii1)
        .function("set_Radii1", &sBeamWrapper::set_Radii1)
        .function("get_CapModes0", &sBeamWrapper::get_CapModes0)
        .function("set_CapModes0", &sBeamWrapper::set_CapModes0)
        .function("get_CapModes1", &sBeamWrapper::get_CapModes1)
        .function("set_CapModes1", &sBeamWrapper::set_CapModes1)
    ;
    class_<sBallWrapper>("sBall")
        .constructor<>()
        .class_function("fromStruct", &sBallWrapper::fromStruct)
        .function("get_Index", &sBallWrapper::get_Index)
        .function("set_Index", &sBallWrapper::set_Index)
        .function("get_Radius", &sBallWrapper::get_Radius)
        .function("set_Radius", &sBallWrapper::set_Radius)
    ;
    class_<sVectorWrapper>("sVector")
        .constructor<>()
        .class_function("fromStruct", &sVectorWrapper::fromStruct)
        .function("get_Coordinates0", &sVectorWrapper::get_Coordinates0)
        .function("set_Coordinates0", &sVectorWrapper::set_Coordinates0)
        .function("get_Coordinates1", &sVectorWrapper::get_Coordinates1)
        .function("set_Coordinates1", &sVectorWrapper::set_Coordinates1)
        .function("get_Coordinates2", &sVectorWrapper::get_Coordinates2)
        .function("set_Coordinates2", &sVectorWrapper::set_Coordinates2)
    ;
    class_<sMatrix4x4Wrapper>("sMatrix4x4")
        .constructor<>()
        .class_function("fromStruct", &sMatrix4x4Wrapper::fromStruct)
        .function("get_Field_0_0", &sMatrix4x4Wrapper::get_Field_0_0)
        .function("set_Field_0_0", &sMatrix4x4Wrapper::set_Field_0_0)
        .function("get_Field_0_1", &sMatrix4x4Wrapper::get_Field_0_1)
        .function("set_Field_0_1", &sMatrix4x4Wrapper::set_Field_0_1)
        .function("get_Field_0_2", &sMatrix4x4Wrapper::get_Field_0_2)
        .function("set_Field_0_2", &sMatrix4x4Wrapper::set_Field_0_2)
        .function("get_Field_0_3", &sMatrix4x4Wrapper::get_Field_0_3)
        .function("set_Field_0_3", &sMatrix4x4Wrapper::set_Field_0_3)
        .function("get_Field_1_0", &sMatrix4x4Wrapper::get_Field_1_0)
        .function("set_Field_1_0", &sMatrix4x4Wrapper::set_Field_1_0)
        .function("get_Field_1_1", &sMatrix4x4Wrapper::get_Field_1_1)
        .function("set_Field_1_1", &sMatrix4x4Wrapper::set_Field_1_1)
        .function("get_Field_1_2", &sMatrix4x4Wrapper::get_Field_1_2)
        .function("set_Field_1_2", &sMatrix4x4Wrapper::set_Field_1_2)
        .function("get_Field_1_3", &sMatrix4x4Wrapper::get_Field_1_3)
        .function("set_Field_1_3", &sMatrix4x4Wrapper::set_Field_1_3)
        .function("get_Field_2_0", &sMatrix4x4Wrapper::get_Field_2_0)
        .function("set_Field_2_0", &sMatrix4x4Wrapper::set_Field_2_0)
        .function("get_Field_2_1", &sMatrix4x4Wrapper::get_Field_2_1)
        .function("set_Field_2_1", &sMatrix4x4Wrapper::set_Field_2_1)
        .function("get_Field_2_2", &sMatrix4x4Wrapper::get_Field_2_2)
        .function("set_Field_2_2", &sMatrix4x4Wrapper::set_Field_2_2)
        .function("get_Field_2_3", &sMatrix4x4Wrapper::get_Field_2_3)
        .function("set_Field_2_3", &sMatrix4x4Wrapper::set_Field_2_3)
        .function("get_Field_3_0", &sMatrix4x4Wrapper::get_Field_3_0)
        .function("set_Field_3_0", &sMatrix4x4Wrapper::set_Field_3_0)
        .function("get_Field_3_1", &sMatrix4x4Wrapper::get_Field_3_1)
        .function("set_Field_3_1", &sMatrix4x4Wrapper::set_Field_3_1)
        .function("get_Field_3_2", &sMatrix4x4Wrapper::get_Field_3_2)
        .function("set_Field_3_2", &sMatrix4x4Wrapper::set_Field_3_2)
        .function("get_Field_3_3", &sMatrix4x4Wrapper::get_Field_3_3)
        .function("set_Field_3_3", &sMatrix4x4Wrapper::set_Field_3_3)
    ;

    // Binding Methods
    class_<CBase>("CBase")
        .smart_ptr<std::shared_ptr<CBase>>("shared_ptr<CBase>")
        .function("ClassTypeId", &CBase::ClassTypeId)
    ;
    class_<CWriter, base<CBase>>("CWriter")
        .smart_ptr<std::shared_ptr<CWriter>>("shared_ptr<CWriter>")
        .function("WriteToFile", &CWriter::WriteToFile)
        .function("GetStreamSize", &CWriter::GetStreamSize)
        .function("WriteToBuffer", &wrap_Writer_WriteToBuffer)
        // .function("WriteToCallback", &wrap_Writer_WriteToCallback) // Skipped due to callback
        // .function("SetProgressCallback", &wrap_Writer_SetProgressCallback) // Skipped due to callback
        .function("GetDecimalPrecision", &CWriter::GetDecimalPrecision)
        .function("SetDecimalPrecision", &CWriter::SetDecimalPrecision)
        .function("SetStrictModeActive", &CWriter::SetStrictModeActive)
        .function("GetStrictModeActive", &CWriter::GetStrictModeActive)
        .function("GetWarning", &wrap_Writer_GetWarning)
        .function("GetWarningCount", &CWriter::GetWarningCount)
        // .function("AddKeyWrappingCallback", &wrap_Writer_AddKeyWrappingCallback) // Skipped due to callback
        // .function("SetContentEncryptionCallback", &wrap_Writer_SetContentEncryptionCallback) // Skipped due to callback
    ;
    class_<CReader, base<CBase>>("CReader")
        .smart_ptr<std::shared_ptr<CReader>>("shared_ptr<CReader>")
        .function("ReadFromFile", &CReader::ReadFromFile)
        .function("ReadFromBuffer", &CReader::ReadFromBuffer)
        // .function("ReadFromCallback", &wrap_Reader_ReadFromCallback) // Skipped due to callback
        // .function("SetProgressCallback", &wrap_Reader_SetProgressCallback) // Skipped due to callback
        .function("AddRelationToRead", &CReader::AddRelationToRead)
        .function("RemoveRelationToRead", &CReader::RemoveRelationToRead)
        .function("SetStrictModeActive", &CReader::SetStrictModeActive)
        .function("GetStrictModeActive", &CReader::GetStrictModeActive)
        .function("GetWarning", &wrap_Reader_GetWarning)
        .function("GetWarningCount", &CReader::GetWarningCount)
        // .function("AddKeyWrappingCallback", &wrap_Reader_AddKeyWrappingCallback) // Skipped due to callback
        // .function("SetContentEncryptionCallback", &wrap_Reader_SetContentEncryptionCallback) // Skipped due to callback
    ;
    class_<CPackagePart, base<CBase>>("CPackagePart")
        .smart_ptr<std::shared_ptr<CPackagePart>>("shared_ptr<CPackagePart>")
        .function("GetPath", &CPackagePart::GetPath)
        .function("SetPath", &CPackagePart::SetPath)
    ;
    class_<CResource, base<CBase>>("CResource")
        .smart_ptr<std::shared_ptr<CResource>>("shared_ptr<CResource>")
        .function("GetResourceID", &CResource::GetResourceID)
        .function("GetUniqueResourceID", &CResource::GetUniqueResourceID)
        .function("PackagePart", &CResource::PackagePart)
        .function("SetPackagePart", &wrap_Resource_SetPackagePart)
        .function("GetModelResourceID", &CResource::GetModelResourceID)
    ;
    class_<CResourceIterator, base<CBase>>("CResourceIterator")
        .smart_ptr<std::shared_ptr<CResourceIterator>>("shared_ptr<CResourceIterator>")
        .function("MoveNext", &CResourceIterator::MoveNext)
        .function("MovePrevious", &CResourceIterator::MovePrevious)
        .function("GetCurrent", &CResourceIterator::GetCurrent)
        .function("Clone", &CResourceIterator::Clone)
        .function("Count", &CResourceIterator::Count)
    ;
    class_<CSliceStackIterator, base<CResourceIterator>>("CSliceStackIterator")
        .smart_ptr<std::shared_ptr<CSliceStackIterator>>("shared_ptr<CSliceStackIterator>")
        .function("GetCurrentSliceStack", &CSliceStackIterator::GetCurrentSliceStack)
    ;
    class_<CObjectIterator, base<CResourceIterator>>("CObjectIterator")
        .smart_ptr<std::shared_ptr<CObjectIterator>>("shared_ptr<CObjectIterator>")
        .function("GetCurrentObject", &CObjectIterator::GetCurrentObject)
    ;
    class_<CMeshObjectIterator, base<CResourceIterator>>("CMeshObjectIterator")
        .smart_ptr<std::shared_ptr<CMeshObjectIterator>>("shared_ptr<CMeshObjectIterator>")
        .function("GetCurrentMeshObject", &CMeshObjectIterator::GetCurrentMeshObject)
    ;
    class_<CComponentsObjectIterator, base<CResourceIterator>>("CComponentsObjectIterator")
        .smart_ptr<std::shared_ptr<CComponentsObjectIterator>>("shared_ptr<CComponentsObjectIterator>")
        .function("GetCurrentComponentsObject", &CComponentsObjectIterator::GetCurrentComponentsObject)
    ;
    class_<CTexture2DIterator, base<CResourceIterator>>("CTexture2DIterator")
        .smart_ptr<std::shared_ptr<CTexture2DIterator>>("shared_ptr<CTexture2DIterator>")
        .function("GetCurrentTexture2D", &CTexture2DIterator::GetCurrentTexture2D)
    ;
    class_<CBaseMaterialGroupIterator, base<CResourceIterator>>("CBaseMaterialGroupIterator")
        .smart_ptr<std::shared_ptr<CBaseMaterialGroupIterator>>("shared_ptr<CBaseMaterialGroupIterator>")
        .function("GetCurrentBaseMaterialGroup", &CBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup)
    ;
    class_<CColorGroupIterator, base<CResourceIterator>>("CColorGroupIterator")
        .smart_ptr<std::shared_ptr<CColorGroupIterator>>("shared_ptr<CColorGroupIterator>")
        .function("GetCurrentColorGroup", &CColorGroupIterator::GetCurrentColorGroup)
    ;
    class_<CTexture2DGroupIterator, base<CResourceIterator>>("CTexture2DGroupIterator")
        .smart_ptr<std::shared_ptr<CTexture2DGroupIterator>>("shared_ptr<CTexture2DGroupIterator>")
        .function("GetCurrentTexture2DGroup", &CTexture2DGroupIterator::GetCurrentTexture2DGroup)
    ;
    class_<CCompositeMaterialsIterator, base<CResourceIterator>>("CCompositeMaterialsIterator")
        .smart_ptr<std::shared_ptr<CCompositeMaterialsIterator>>("shared_ptr<CCompositeMaterialsIterator>")
        .function("GetCurrentCompositeMaterials", &CCompositeMaterialsIterator::GetCurrentCompositeMaterials)
    ;
    class_<CMultiPropertyGroupIterator, base<CResourceIterator>>("CMultiPropertyGroupIterator")
        .smart_ptr<std::shared_ptr<CMultiPropertyGroupIterator>>("shared_ptr<CMultiPropertyGroupIterator>")
        .function("GetCurrentMultiPropertyGroup", &CMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup)
    ;
    class_<CImage3DIterator, base<CResourceIterator>>("CImage3DIterator")
        .smart_ptr<std::shared_ptr<CImage3DIterator>>("shared_ptr<CImage3DIterator>")
        .function("GetCurrentImage3D", &CImage3DIterator::GetCurrentImage3D)
    ;
    class_<CFunctionIterator, base<CResourceIterator>>("CFunctionIterator")
        .smart_ptr<std::shared_ptr<CFunctionIterator>>("shared_ptr<CFunctionIterator>")
        .function("GetCurrentFunction", &CFunctionIterator::GetCurrentFunction)
    ;
    class_<CLevelSetIterator, base<CResourceIterator>>("CLevelSetIterator")
        .smart_ptr<std::shared_ptr<CLevelSetIterator>>("shared_ptr<CLevelSetIterator>")
        .function("GetCurrentLevelSet", &CLevelSetIterator::GetCurrentLevelSet)
    ;
    class_<CMetaData, base<CBase>>("CMetaData")
        .smart_ptr<std::shared_ptr<CMetaData>>("shared_ptr<CMetaData>")
        .function("GetNameSpace", &CMetaData::GetNameSpace)
        .function("SetNameSpace", &CMetaData::SetNameSpace)
        .function("GetName", &CMetaData::GetName)
        .function("SetName", &CMetaData::SetName)
        .function("GetKey", &CMetaData::GetKey)
        .function("GetMustPreserve", &CMetaData::GetMustPreserve)
        .function("SetMustPreserve", &CMetaData::SetMustPreserve)
        .function("GetType", &CMetaData::GetType)
        .function("SetType", &CMetaData::SetType)
        .function("GetValue", &CMetaData::GetValue)
        .function("SetValue", &CMetaData::SetValue)
    ;
    class_<CMetaDataGroup, base<CBase>>("CMetaDataGroup")
        .smart_ptr<std::shared_ptr<CMetaDataGroup>>("shared_ptr<CMetaDataGroup>")
        .function("GetMetaDataCount", &CMetaDataGroup::GetMetaDataCount)
        .function("GetMetaData", &CMetaDataGroup::GetMetaData)
        .function("GetMetaDataByKey", &CMetaDataGroup::GetMetaDataByKey)
        .function("RemoveMetaDataByIndex", &CMetaDataGroup::RemoveMetaDataByIndex)
        .function("RemoveMetaData", &wrap_MetaDataGroup_RemoveMetaData)
        .function("AddMetaData", &CMetaDataGroup::AddMetaData)
    ;
    class_<CTriangleSet, base<CBase>>("CTriangleSet")
        .smart_ptr<std::shared_ptr<CTriangleSet>>("shared_ptr<CTriangleSet>")
        .function("SetName", &CTriangleSet::SetName)
        .function("GetName", &CTriangleSet::GetName)
        .function("SetIdentifier", &CTriangleSet::SetIdentifier)
        .function("GetIdentifier", &CTriangleSet::GetIdentifier)
        .function("AddTriangle", &CTriangleSet::AddTriangle)
        .function("RemoveTriangle", &CTriangleSet::RemoveTriangle)
        .function("Clear", &CTriangleSet::Clear)
        .function("SetTriangleList", &CTriangleSet::SetTriangleList)
        .function("GetTriangleList", &wrap_TriangleSet_GetTriangleList)
        .function("AddTriangleList", &CTriangleSet::AddTriangleList)
        .function("Merge", &wrap_TriangleSet_Merge)
        .function("DeleteSet", &CTriangleSet::DeleteSet)
        .function("Duplicate", &CTriangleSet::Duplicate)
    ;
    class_<CObject, base<CResource>>("CObject")
        .smart_ptr<std::shared_ptr<CObject>>("shared_ptr<CObject>")
        .function("GetType", &CObject::GetType)
        .function("SetType", &CObject::SetType)
        .function("GetName", &CObject::GetName)
        .function("SetName", &CObject::SetName)
        .function("GetPartNumber", &CObject::GetPartNumber)
        .function("SetPartNumber", &CObject::SetPartNumber)
        .function("IsMeshObject", &CObject::IsMeshObject)
        .function("IsComponentsObject", &CObject::IsComponentsObject)
        .function("IsLevelSetObject", &CObject::IsLevelSetObject)
        .function("IsValid", &CObject::IsValid)
        .function("SetAttachmentAsThumbnail", &wrap_Object_SetAttachmentAsThumbnail)
        .function("GetThumbnailAttachment", &CObject::GetThumbnailAttachment)
        .function("ClearThumbnailAttachment", &CObject::ClearThumbnailAttachment)
        .function("GetOutbox", &wrap_Object_GetOutbox)
        .function("GetUUID", &wrap_Object_GetUUID)
        .function("SetUUID", &CObject::SetUUID)
        .function("GetMetaDataGroup", &CObject::GetMetaDataGroup)
        .function("SetSlicesMeshResolution", &CObject::SetSlicesMeshResolution)
        .function("GetSlicesMeshResolution", &CObject::GetSlicesMeshResolution)
        .function("HasSlices", &CObject::HasSlices)
        .function("ClearSliceStack", &CObject::ClearSliceStack)
        .function("GetSliceStack", &CObject::GetSliceStack)
        .function("AssignSliceStack", &wrap_Object_AssignSliceStack)
    ;
    class_<CMeshObject, base<CObject>>("CMeshObject")
        .smart_ptr<std::shared_ptr<CMeshObject>>("shared_ptr<CMeshObject>")
        .function("GetVertexCount", &CMeshObject::GetVertexCount)
        .function("GetTriangleCount", &CMeshObject::GetTriangleCount)
        .function("GetVertex", &wrap_MeshObject_GetVertex)
        .function("SetVertex", &wrap_MeshObject_SetVertex)
        .function("AddVertex", &wrap_MeshObject_AddVertex)
        .function("GetVertices", &wrap_MeshObject_GetVertices)
        .function("GetTriangle", &wrap_MeshObject_GetTriangle)
        .function("SetTriangle", &wrap_MeshObject_SetTriangle)
        .function("AddTriangle", &wrap_MeshObject_AddTriangle)
        .function("GetTriangleIndices", &wrap_MeshObject_GetTriangleIndices)
        .function("SetObjectLevelProperty", &CMeshObject::SetObjectLevelProperty)
        .function("GetObjectLevelProperty", &wrap_MeshObject_GetObjectLevelProperty)
        .function("SetTriangleProperties", &wrap_MeshObject_SetTriangleProperties)
        .function("GetTriangleProperties", &wrap_MeshObject_GetTriangleProperties)
        .function("SetAllTriangleProperties", &wrap_MeshObject_SetAllTriangleProperties)
        .function("GetAllTriangleProperties", &wrap_MeshObject_GetAllTriangleProperties)
        .function("ClearAllProperties", &CMeshObject::ClearAllProperties)
        .function("SetGeometry", &wrap_MeshObject_SetGeometry)
        .function("IsManifoldAndOriented", &CMeshObject::IsManifoldAndOriented)
        .function("BeamLattice", &CMeshObject::BeamLattice)
        .function("GetVolumeData", &CMeshObject::GetVolumeData)
        .function("SetVolumeData", &wrap_MeshObject_SetVolumeData)
        .function("AddTriangleSet", &CMeshObject::AddTriangleSet)
        .function("HasTriangleSet", &CMeshObject::HasTriangleSet)
        .function("FindTriangleSet", &CMeshObject::FindTriangleSet)
        .function("GetTriangleSetCount", &CMeshObject::GetTriangleSetCount)
        .function("GetTriangleSet", &CMeshObject::GetTriangleSet)
    ;
    class_<CLevelSet, base<CObject>>("CLevelSet")
        .smart_ptr<std::shared_ptr<CLevelSet>>("shared_ptr<CLevelSet>")
        .function("GetFunction", &CLevelSet::GetFunction)
        .function("SetFunction", &wrap_LevelSet_SetFunction)
        .function("GetTransform", &wrap_LevelSet_GetTransform)
        .function("SetTransform", &wrap_LevelSet_SetTransform)
        .function("GetChannelName", &CLevelSet::GetChannelName)
        .function("SetChannelName", &CLevelSet::SetChannelName)
        .function("SetMinFeatureSize", &CLevelSet::SetMinFeatureSize)
        .function("GetMinFeatureSize", &CLevelSet::GetMinFeatureSize)
        .function("SetFallBackValue", &CLevelSet::SetFallBackValue)
        .function("GetFallBackValue", &CLevelSet::GetFallBackValue)
        .function("SetMeshBBoxOnly", &CLevelSet::SetMeshBBoxOnly)
        .function("GetMeshBBoxOnly", &CLevelSet::GetMeshBBoxOnly)
        .function("SetMesh", &wrap_LevelSet_SetMesh)
        .function("GetMesh", &CLevelSet::GetMesh)
        .function("GetVolumeData", &CLevelSet::GetVolumeData)
        .function("SetVolumeData", &wrap_LevelSet_SetVolumeData)
    ;
    class_<CBeamLattice, base<CBase>>("CBeamLattice")
        .smart_ptr<std::shared_ptr<CBeamLattice>>("shared_ptr<CBeamLattice>")
        .function("GetMinLength", &CBeamLattice::GetMinLength)
        .function("SetMinLength", &CBeamLattice::SetMinLength)
        .function("GetClipping", &wrap_BeamLattice_GetClipping)
        .function("SetClipping", &CBeamLattice::SetClipping)
        .function("GetRepresentation", &wrap_BeamLattice_GetRepresentation)
        .function("SetRepresentation", &CBeamLattice::SetRepresentation)
        .function("GetBallOptions", &wrap_BeamLattice_GetBallOptions)
        .function("SetBallOptions", &CBeamLattice::SetBallOptions)
        .function("GetBeamCount", &CBeamLattice::GetBeamCount)
        .function("GetBeam", &wrap_BeamLattice_GetBeam)
        .function("AddBeam", &wrap_BeamLattice_AddBeam)
        .function("SetBeam", &wrap_BeamLattice_SetBeam)
        .function("SetBeams", &wrap_BeamLattice_SetBeams)
        .function("GetBeams", &wrap_BeamLattice_GetBeams)
        .function("GetBallCount", &CBeamLattice::GetBallCount)
        .function("GetBall", &wrap_BeamLattice_GetBall)
        .function("AddBall", &wrap_BeamLattice_AddBall)
        .function("SetBall", &wrap_BeamLattice_SetBall)
        .function("SetBalls", &wrap_BeamLattice_SetBalls)
        .function("GetBalls", &wrap_BeamLattice_GetBalls)
        .function("GetBeamSetCount", &CBeamLattice::GetBeamSetCount)
        .function("AddBeamSet", &CBeamLattice::AddBeamSet)
        .function("GetBeamSet", &CBeamLattice::GetBeamSet)
    ;
    class_<CFunctionReference, base<CBase>>("CFunctionReference")
        .smart_ptr<std::shared_ptr<CFunctionReference>>("shared_ptr<CFunctionReference>")
        .function("GetFunctionResourceID", &CFunctionReference::GetFunctionResourceID)
        .function("SetFunctionResourceID", &CFunctionReference::SetFunctionResourceID)
        .function("GetTransform", &wrap_FunctionReference_GetTransform)
        .function("SetTransform", &wrap_FunctionReference_SetTransform)
        .function("GetChannelName", &CFunctionReference::GetChannelName)
        .function("SetChannelName", &CFunctionReference::SetChannelName)
        .function("SetMinFeatureSize", &CFunctionReference::SetMinFeatureSize)
        .function("GetMinFeatureSize", &CFunctionReference::GetMinFeatureSize)
        .function("SetFallBackValue", &CFunctionReference::SetFallBackValue)
        .function("GetFallBackValue", &CFunctionReference::GetFallBackValue)
    ;
    class_<CVolumeDataColor, base<CFunctionReference>>("CVolumeDataColor")
        .smart_ptr<std::shared_ptr<CVolumeDataColor>>("shared_ptr<CVolumeDataColor>")
    ;
    class_<CMaterialMapping, base<CFunctionReference>>("CMaterialMapping")
        .smart_ptr<std::shared_ptr<CMaterialMapping>>("shared_ptr<CMaterialMapping>")
    ;
    class_<CVolumeDataComposite, base<CBase>>("CVolumeDataComposite")
        .smart_ptr<std::shared_ptr<CVolumeDataComposite>>("shared_ptr<CVolumeDataComposite>")
        .function("GetBaseMaterialGroup", &CVolumeDataComposite::GetBaseMaterialGroup)
        .function("SetBaseMaterialGroup", &wrap_VolumeDataComposite_SetBaseMaterialGroup)
        .function("GetMaterialMappingCount", &CVolumeDataComposite::GetMaterialMappingCount)
        .function("GetMaterialMapping", &CVolumeDataComposite::GetMaterialMapping)
        .function("AddMaterialMapping", &wrap_VolumeDataComposite_AddMaterialMapping)
        .function("RemoveMaterialMapping", &CVolumeDataComposite::RemoveMaterialMapping)
    ;
    class_<CVolumeDataProperty, base<CFunctionReference>>("CVolumeDataProperty")
        .smart_ptr<std::shared_ptr<CVolumeDataProperty>>("shared_ptr<CVolumeDataProperty>")
        .function("GetName", &CVolumeDataProperty::GetName)
        .function("SetIsRequired", &CVolumeDataProperty::SetIsRequired)
        .function("IsRequired", &CVolumeDataProperty::IsRequired)
    ;
    class_<CVolumeData, base<CResource>>("CVolumeData")
        .smart_ptr<std::shared_ptr<CVolumeData>>("shared_ptr<CVolumeData>")
        .function("GetComposite", &CVolumeData::GetComposite)
        .function("CreateNewComposite", &CVolumeData::CreateNewComposite)
        .function("RemoveComposite", &CVolumeData::RemoveComposite)
        .function("GetColor", &CVolumeData::GetColor)
        .function("CreateNewColor", &wrap_VolumeData_CreateNewColor)
        .function("RemoveColor", &CVolumeData::RemoveColor)
        .function("GetPropertyCount", &CVolumeData::GetPropertyCount)
        .function("GetProperty", &CVolumeData::GetProperty)
        .function("AddPropertyFromFunction", &wrap_VolumeData_AddPropertyFromFunction)
        .function("RemoveProperty", &CVolumeData::RemoveProperty)
    ;
    class_<CComponent, base<CBase>>("CComponent")
        .smart_ptr<std::shared_ptr<CComponent>>("shared_ptr<CComponent>")
        .function("GetObjectResource", &CComponent::GetObjectResource)
        .function("GetObjectResourceID", &CComponent::GetObjectResourceID)
        .function("GetUUID", &wrap_Component_GetUUID)
        .function("SetUUID", &CComponent::SetUUID)
        .function("HasTransform", &CComponent::HasTransform)
        .function("GetTransform", &wrap_Component_GetTransform)
        .function("SetTransform", &wrap_Component_SetTransform)
    ;
    class_<CComponentsObject, base<CObject>>("CComponentsObject")
        .smart_ptr<std::shared_ptr<CComponentsObject>>("shared_ptr<CComponentsObject>")
        .function("AddComponent", &wrap_ComponentsObject_AddComponent)
        .function("GetComponent", &CComponentsObject::GetComponent)
        .function("GetComponentCount", &CComponentsObject::GetComponentCount)
    ;
    class_<CBeamSet, base<CBase>>("CBeamSet")
        .smart_ptr<std::shared_ptr<CBeamSet>>("shared_ptr<CBeamSet>")
        .function("SetName", &CBeamSet::SetName)
        .function("GetName", &CBeamSet::GetName)
        .function("SetIdentifier", &CBeamSet::SetIdentifier)
        .function("GetIdentifier", &CBeamSet::GetIdentifier)
        .function("GetReferenceCount", &CBeamSet::GetReferenceCount)
        .function("SetReferences", &CBeamSet::SetReferences)
        .function("GetReferences", &wrap_BeamSet_GetReferences)
        .function("GetBallReferenceCount", &CBeamSet::GetBallReferenceCount)
        .function("SetBallReferences", &CBeamSet::SetBallReferences)
        .function("GetBallReferences", &wrap_BeamSet_GetBallReferences)
    ;
    class_<CBaseMaterialGroup, base<CResource>>("CBaseMaterialGroup")
        .smart_ptr<std::shared_ptr<CBaseMaterialGroup>>("shared_ptr<CBaseMaterialGroup>")
        .function("GetCount", &CBaseMaterialGroup::GetCount)
        .function("GetAllPropertyIDs", &wrap_BaseMaterialGroup_GetAllPropertyIDs)
        .function("AddMaterial", &wrap_BaseMaterialGroup_AddMaterial)
        .function("RemoveMaterial", &CBaseMaterialGroup::RemoveMaterial)
        .function("GetName", &CBaseMaterialGroup::GetName)
        .function("SetName", &CBaseMaterialGroup::SetName)
        .function("SetDisplayColor", &wrap_BaseMaterialGroup_SetDisplayColor)
        .function("GetDisplayColor", &wrap_BaseMaterialGroup_GetDisplayColor)
    ;
    class_<CColorGroup, base<CResource>>("CColorGroup")
        .smart_ptr<std::shared_ptr<CColorGroup>>("shared_ptr<CColorGroup>")
        .function("GetCount", &CColorGroup::GetCount)
        .function("GetAllPropertyIDs", &wrap_ColorGroup_GetAllPropertyIDs)
        .function("AddColor", &wrap_ColorGroup_AddColor)
        .function("RemoveColor", &CColorGroup::RemoveColor)
        .function("SetColor", &wrap_ColorGroup_SetColor)
        .function("GetColor", &wrap_ColorGroup_GetColor)
    ;
    class_<CTexture2DGroup, base<CResource>>("CTexture2DGroup")
        .smart_ptr<std::shared_ptr<CTexture2DGroup>>("shared_ptr<CTexture2DGroup>")
        .function("GetCount", &CTexture2DGroup::GetCount)
        .function("GetAllPropertyIDs", &wrap_Texture2DGroup_GetAllPropertyIDs)
        .function("AddTex2Coord", &wrap_Texture2DGroup_AddTex2Coord)
        .function("GetTex2Coord", &wrap_Texture2DGroup_GetTex2Coord)
        .function("RemoveTex2Coord", &CTexture2DGroup::RemoveTex2Coord)
        .function("GetTexture2D", &CTexture2DGroup::GetTexture2D)
    ;
    class_<CCompositeMaterials, base<CResource>>("CCompositeMaterials")
        .smart_ptr<std::shared_ptr<CCompositeMaterials>>("shared_ptr<CCompositeMaterials>")
        .function("GetCount", &CCompositeMaterials::GetCount)
        .function("GetAllPropertyIDs", &wrap_CompositeMaterials_GetAllPropertyIDs)
        .function("GetBaseMaterialGroup", &CCompositeMaterials::GetBaseMaterialGroup)
        .function("AddComposite", &wrap_CompositeMaterials_AddComposite)
        .function("RemoveComposite", &CCompositeMaterials::RemoveComposite)
        .function("GetComposite", &wrap_CompositeMaterials_GetComposite)
    ;
    class_<CMultiPropertyGroup, base<CResource>>("CMultiPropertyGroup")
        .smart_ptr<std::shared_ptr<CMultiPropertyGroup>>("shared_ptr<CMultiPropertyGroup>")
        .function("GetCount", &CMultiPropertyGroup::GetCount)
        .function("GetAllPropertyIDs", &wrap_MultiPropertyGroup_GetAllPropertyIDs)
        .function("AddMultiProperty", &CMultiPropertyGroup::AddMultiProperty)
        .function("SetMultiProperty", &CMultiPropertyGroup::SetMultiProperty)
        .function("GetMultiProperty", &wrap_MultiPropertyGroup_GetMultiProperty)
        .function("RemoveMultiProperty", &CMultiPropertyGroup::RemoveMultiProperty)
        .function("GetLayerCount", &CMultiPropertyGroup::GetLayerCount)
        .function("AddLayer", &wrap_MultiPropertyGroup_AddLayer)
        .function("GetLayer", &wrap_MultiPropertyGroup_GetLayer)
        .function("RemoveLayer", &CMultiPropertyGroup::RemoveLayer)
    ;
    class_<CImage3D, base<CResource>>("CImage3D")
        .smart_ptr<std::shared_ptr<CImage3D>>("shared_ptr<CImage3D>")
        .function("GetName", &CImage3D::GetName)
        .function("SetName", &CImage3D::SetName)
        .function("IsImageStack", &CImage3D::IsImageStack)
    ;
    class_<CImageStack, base<CImage3D>>("CImageStack")
        .smart_ptr<std::shared_ptr<CImageStack>>("shared_ptr<CImageStack>")
        .function("GetRowCount", &CImageStack::GetRowCount)
        .function("SetRowCount", &CImageStack::SetRowCount)
        .function("GetColumnCount", &CImageStack::GetColumnCount)
        .function("SetColumnCount", &CImageStack::SetColumnCount)
        .function("GetSheetCount", &CImageStack::GetSheetCount)
        .function("GetSheet", &CImageStack::GetSheet)
        .function("SetSheet", &wrap_ImageStack_SetSheet)
        .function("CreateEmptySheet", &CImageStack::CreateEmptySheet)
        .function("CreateSheetFromBuffer", &CImageStack::CreateSheetFromBuffer)
        .function("CreateSheetFromFile", &CImageStack::CreateSheetFromFile)
    ;
    class_<CAttachment, base<CBase>>("CAttachment")
        .smart_ptr<std::shared_ptr<CAttachment>>("shared_ptr<CAttachment>")
        .function("GetPath", &CAttachment::GetPath)
        .function("SetPath", &CAttachment::SetPath)
        .function("PackagePart", &CAttachment::PackagePart)
        .function("GetRelationShipType", &CAttachment::GetRelationShipType)
        .function("SetRelationShipType", &CAttachment::SetRelationShipType)
        .function("WriteToFile", &CAttachment::WriteToFile)
        .function("ReadFromFile", &CAttachment::ReadFromFile)
        // .function("ReadFromCallback", &wrap_Attachment_ReadFromCallback) // Skipped due to callback
        .function("GetStreamSize", &CAttachment::GetStreamSize)
        .function("WriteToBuffer", &wrap_Attachment_WriteToBuffer)
        .function("ReadFromBuffer", &CAttachment::ReadFromBuffer)
    ;
    class_<CTexture2D, base<CResource>>("CTexture2D")
        .smart_ptr<std::shared_ptr<CTexture2D>>("shared_ptr<CTexture2D>")
        .function("GetAttachment", &CTexture2D::GetAttachment)
        .function("SetAttachment", &wrap_Texture2D_SetAttachment)
        .function("GetContentType", &CTexture2D::GetContentType)
        .function("SetContentType", &CTexture2D::SetContentType)
        .function("GetTileStyleUV", &wrap_Texture2D_GetTileStyleUV)
        .function("SetTileStyleUV", &CTexture2D::SetTileStyleUV)
        .function("GetFilter", &CTexture2D::GetFilter)
        .function("SetFilter", &CTexture2D::SetFilter)
    ;
    class_<CImplicitPort, base<CBase>>("CImplicitPort")
        .smart_ptr<std::shared_ptr<CImplicitPort>>("shared_ptr<CImplicitPort>")
        .function("GetIdentifier", &CImplicitPort::GetIdentifier)
        .function("SetIdentifier", &CImplicitPort::SetIdentifier)
        .function("GetDisplayName", &CImplicitPort::GetDisplayName)
        .function("SetDisplayName", &CImplicitPort::SetDisplayName)
        .function("SetType", &CImplicitPort::SetType)
        .function("GetType", &CImplicitPort::GetType)
        .function("GetReference", &CImplicitPort::GetReference)
        .function("SetReference", &CImplicitPort::SetReference)
    ;
    class_<CIterator, base<CBase>>("CIterator")
        .smart_ptr<std::shared_ptr<CIterator>>("shared_ptr<CIterator>")
        .function("MoveNext", &CIterator::MoveNext)
        .function("MovePrevious", &CIterator::MovePrevious)
        .function("Count", &CIterator::Count)
    ;
    class_<CImplicitPortIterator, base<CIterator>>("CImplicitPortIterator")
        .smart_ptr<std::shared_ptr<CImplicitPortIterator>>("shared_ptr<CImplicitPortIterator>")
        .function("GetCurrent", &CImplicitPortIterator::GetCurrent)
    ;
    class_<CImplicitNode, base<CBase>>("CImplicitNode")
        .smart_ptr<std::shared_ptr<CImplicitNode>>("shared_ptr<CImplicitNode>")
        .function("GetIdentifier", &CImplicitNode::GetIdentifier)
        .function("SetIdentifier", &CImplicitNode::SetIdentifier)
        .function("GetDisplayName", &CImplicitNode::GetDisplayName)
        .function("SetDisplayName", &CImplicitNode::SetDisplayName)
        .function("GetTag", &CImplicitNode::GetTag)
        .function("SetTag", &CImplicitNode::SetTag)
        .function("GetNodeType", &CImplicitNode::GetNodeType)
        .function("AddInput", &CImplicitNode::AddInput)
        .function("GetInputs", &CImplicitNode::GetInputs)
        .function("AddOutput", &CImplicitNode::AddOutput)
        .function("GetOutputs", &CImplicitNode::GetOutputs)
        .function("FindInput", &CImplicitNode::FindInput)
        .function("FindOutput", &CImplicitNode::FindOutput)
        .function("AreTypesValid", &CImplicitNode::AreTypesValid)
    ;
    class_<COneInputNode, base<CImplicitNode>>("COneInputNode")
        .smart_ptr<std::shared_ptr<COneInputNode>>("shared_ptr<COneInputNode>")
        .function("GetInputA", &COneInputNode::GetInputA)
        .function("GetOutputResult", &COneInputNode::GetOutputResult)
    ;
    class_<CSinNode, base<COneInputNode>>("CSinNode")
        .smart_ptr<std::shared_ptr<CSinNode>>("shared_ptr<CSinNode>")
    ;
    class_<CCosNode, base<COneInputNode>>("CCosNode")
        .smart_ptr<std::shared_ptr<CCosNode>>("shared_ptr<CCosNode>")
    ;
    class_<CTanNode, base<COneInputNode>>("CTanNode")
        .smart_ptr<std::shared_ptr<CTanNode>>("shared_ptr<CTanNode>")
    ;
    class_<CArcSinNode, base<COneInputNode>>("CArcSinNode")
        .smart_ptr<std::shared_ptr<CArcSinNode>>("shared_ptr<CArcSinNode>")
    ;
    class_<CArcCosNode, base<COneInputNode>>("CArcCosNode")
        .smart_ptr<std::shared_ptr<CArcCosNode>>("shared_ptr<CArcCosNode>")
    ;
    class_<CArcTanNode, base<COneInputNode>>("CArcTanNode")
        .smart_ptr<std::shared_ptr<CArcTanNode>>("shared_ptr<CArcTanNode>")
    ;
    class_<CSinhNode, base<COneInputNode>>("CSinhNode")
        .smart_ptr<std::shared_ptr<CSinhNode>>("shared_ptr<CSinhNode>")
    ;
    class_<CCoshNode, base<COneInputNode>>("CCoshNode")
        .smart_ptr<std::shared_ptr<CCoshNode>>("shared_ptr<CCoshNode>")
    ;
    class_<CTanhNode, base<COneInputNode>>("CTanhNode")
        .smart_ptr<std::shared_ptr<CTanhNode>>("shared_ptr<CTanhNode>")
    ;
    class_<CRoundNode, base<COneInputNode>>("CRoundNode")
        .smart_ptr<std::shared_ptr<CRoundNode>>("shared_ptr<CRoundNode>")
    ;
    class_<CCeilNode, base<COneInputNode>>("CCeilNode")
        .smart_ptr<std::shared_ptr<CCeilNode>>("shared_ptr<CCeilNode>")
    ;
    class_<CFloorNode, base<COneInputNode>>("CFloorNode")
        .smart_ptr<std::shared_ptr<CFloorNode>>("shared_ptr<CFloorNode>")
    ;
    class_<CSignNode, base<COneInputNode>>("CSignNode")
        .smart_ptr<std::shared_ptr<CSignNode>>("shared_ptr<CSignNode>")
    ;
    class_<CFractNode, base<COneInputNode>>("CFractNode")
        .smart_ptr<std::shared_ptr<CFractNode>>("shared_ptr<CFractNode>")
    ;
    class_<CAbsNode, base<COneInputNode>>("CAbsNode")
        .smart_ptr<std::shared_ptr<CAbsNode>>("shared_ptr<CAbsNode>")
    ;
    class_<CExpNode, base<COneInputNode>>("CExpNode")
        .smart_ptr<std::shared_ptr<CExpNode>>("shared_ptr<CExpNode>")
    ;
    class_<CLogNode, base<COneInputNode>>("CLogNode")
        .smart_ptr<std::shared_ptr<CLogNode>>("shared_ptr<CLogNode>")
    ;
    class_<CLog2Node, base<COneInputNode>>("CLog2Node")
        .smart_ptr<std::shared_ptr<CLog2Node>>("shared_ptr<CLog2Node>")
    ;
    class_<CLog10Node, base<COneInputNode>>("CLog10Node")
        .smart_ptr<std::shared_ptr<CLog10Node>>("shared_ptr<CLog10Node>")
    ;
    class_<CLengthNode, base<COneInputNode>>("CLengthNode")
        .smart_ptr<std::shared_ptr<CLengthNode>>("shared_ptr<CLengthNode>")
    ;
    class_<CTransposeNode, base<COneInputNode>>("CTransposeNode")
        .smart_ptr<std::shared_ptr<CTransposeNode>>("shared_ptr<CTransposeNode>")
    ;
    class_<CInverseNode, base<COneInputNode>>("CInverseNode")
        .smart_ptr<std::shared_ptr<CInverseNode>>("shared_ptr<CInverseNode>")
    ;
    class_<CSqrtNode, base<COneInputNode>>("CSqrtNode")
        .smart_ptr<std::shared_ptr<CSqrtNode>>("shared_ptr<CSqrtNode>")
    ;
    class_<CResourceIdNode, base<CImplicitNode>>("CResourceIdNode")
        .smart_ptr<std::shared_ptr<CResourceIdNode>>("shared_ptr<CResourceIdNode>")
        .function("SetResource", &wrap_ResourceIdNode_SetResource)
        .function("GetResource", &CResourceIdNode::GetResource)
        .function("GetOutputValue", &CResourceIdNode::GetOutputValue)
    ;
    class_<CTwoInputNode, base<COneInputNode>>("CTwoInputNode")
        .smart_ptr<std::shared_ptr<CTwoInputNode>>("shared_ptr<CTwoInputNode>")
        .function("GetInputB", &CTwoInputNode::GetInputB)
    ;
    class_<CAdditionNode, base<CTwoInputNode>>("CAdditionNode")
        .smart_ptr<std::shared_ptr<CAdditionNode>>("shared_ptr<CAdditionNode>")
    ;
    class_<CSubtractionNode, base<CTwoInputNode>>("CSubtractionNode")
        .smart_ptr<std::shared_ptr<CSubtractionNode>>("shared_ptr<CSubtractionNode>")
    ;
    class_<CMultiplicationNode, base<CTwoInputNode>>("CMultiplicationNode")
        .smart_ptr<std::shared_ptr<CMultiplicationNode>>("shared_ptr<CMultiplicationNode>")
    ;
    class_<CDivisionNode, base<CTwoInputNode>>("CDivisionNode")
        .smart_ptr<std::shared_ptr<CDivisionNode>>("shared_ptr<CDivisionNode>")
    ;
    class_<CDotNode, base<CTwoInputNode>>("CDotNode")
        .smart_ptr<std::shared_ptr<CDotNode>>("shared_ptr<CDotNode>")
    ;
    class_<CCrossNode, base<CTwoInputNode>>("CCrossNode")
        .smart_ptr<std::shared_ptr<CCrossNode>>("shared_ptr<CCrossNode>")
    ;
    class_<CArcTan2Node, base<CTwoInputNode>>("CArcTan2Node")
        .smart_ptr<std::shared_ptr<CArcTan2Node>>("shared_ptr<CArcTan2Node>")
    ;
    class_<CMatVecMultiplicationNode, base<CTwoInputNode>>("CMatVecMultiplicationNode")
        .smart_ptr<std::shared_ptr<CMatVecMultiplicationNode>>("shared_ptr<CMatVecMultiplicationNode>")
    ;
    class_<CMinNode, base<CTwoInputNode>>("CMinNode")
        .smart_ptr<std::shared_ptr<CMinNode>>("shared_ptr<CMinNode>")
    ;
    class_<CMaxNode, base<CTwoInputNode>>("CMaxNode")
        .smart_ptr<std::shared_ptr<CMaxNode>>("shared_ptr<CMaxNode>")
    ;
    class_<CFmodNode, base<CTwoInputNode>>("CFmodNode")
        .smart_ptr<std::shared_ptr<CFmodNode>>("shared_ptr<CFmodNode>")
    ;
    class_<CModNode, base<CTwoInputNode>>("CModNode")
        .smart_ptr<std::shared_ptr<CModNode>>("shared_ptr<CModNode>")
    ;
    class_<CPowNode, base<CTwoInputNode>>("CPowNode")
        .smart_ptr<std::shared_ptr<CPowNode>>("shared_ptr<CPowNode>")
    ;
    class_<CSelectNode, base<COneInputNode>>("CSelectNode")
        .smart_ptr<std::shared_ptr<CSelectNode>>("shared_ptr<CSelectNode>")
        .function("GetInputB", &CSelectNode::GetInputB)
        .function("GetInputC", &CSelectNode::GetInputC)
        .function("GetInputD", &CSelectNode::GetInputD)
    ;
    class_<CClampNode, base<COneInputNode>>("CClampNode")
        .smart_ptr<std::shared_ptr<CClampNode>>("shared_ptr<CClampNode>")
        .function("GetInputMin", &CClampNode::GetInputMin)
        .function("GetInputMax", &CClampNode::GetInputMax)
    ;
    class_<CComposeVectorNode, base<CImplicitNode>>("CComposeVectorNode")
        .smart_ptr<std::shared_ptr<CComposeVectorNode>>("shared_ptr<CComposeVectorNode>")
        .function("GetInputX", &CComposeVectorNode::GetInputX)
        .function("GetInputY", &CComposeVectorNode::GetInputY)
        .function("GetInputZ", &CComposeVectorNode::GetInputZ)
        .function("GetOutputResult", &CComposeVectorNode::GetOutputResult)
    ;
    class_<CVectorFromScalarNode, base<COneInputNode>>("CVectorFromScalarNode")
        .smart_ptr<std::shared_ptr<CVectorFromScalarNode>>("shared_ptr<CVectorFromScalarNode>")
    ;
    class_<CDecomposeVectorNode, base<CImplicitNode>>("CDecomposeVectorNode")
        .smart_ptr<std::shared_ptr<CDecomposeVectorNode>>("shared_ptr<CDecomposeVectorNode>")
        .function("GetInputA", &CDecomposeVectorNode::GetInputA)
        .function("GetOutputX", &CDecomposeVectorNode::GetOutputX)
        .function("GetOutputY", &CDecomposeVectorNode::GetOutputY)
        .function("GetOutputZ", &CDecomposeVectorNode::GetOutputZ)
    ;
    class_<CComposeMatrixNode, base<CImplicitNode>>("CComposeMatrixNode")
        .smart_ptr<std::shared_ptr<CComposeMatrixNode>>("shared_ptr<CComposeMatrixNode>")
        .function("GetInputM00", &CComposeMatrixNode::GetInputM00)
        .function("GetInputM01", &CComposeMatrixNode::GetInputM01)
        .function("GetInputM02", &CComposeMatrixNode::GetInputM02)
        .function("GetInputM03", &CComposeMatrixNode::GetInputM03)
        .function("GetInputM10", &CComposeMatrixNode::GetInputM10)
        .function("GetInputM11", &CComposeMatrixNode::GetInputM11)
        .function("GetInputM12", &CComposeMatrixNode::GetInputM12)
        .function("GetInputM13", &CComposeMatrixNode::GetInputM13)
        .function("GetInputM20", &CComposeMatrixNode::GetInputM20)
        .function("GetInputM21", &CComposeMatrixNode::GetInputM21)
        .function("GetInputM22", &CComposeMatrixNode::GetInputM22)
        .function("GetInputM23", &CComposeMatrixNode::GetInputM23)
        .function("GetInputM30", &CComposeMatrixNode::GetInputM30)
        .function("GetInputM31", &CComposeMatrixNode::GetInputM31)
        .function("GetInputM32", &CComposeMatrixNode::GetInputM32)
        .function("GetInputM33", &CComposeMatrixNode::GetInputM33)
        .function("GetOutputResult", &CComposeMatrixNode::GetOutputResult)
    ;
    class_<CMatrixFromRowsNode, base<CImplicitNode>>("CMatrixFromRowsNode")
        .smart_ptr<std::shared_ptr<CMatrixFromRowsNode>>("shared_ptr<CMatrixFromRowsNode>")
        .function("GetInputA", &CMatrixFromRowsNode::GetInputA)
        .function("GetInputB", &CMatrixFromRowsNode::GetInputB)
        .function("GetInputC", &CMatrixFromRowsNode::GetInputC)
        .function("GetInputD", &CMatrixFromRowsNode::GetInputD)
        .function("GetOutputResult", &CMatrixFromRowsNode::GetOutputResult)
    ;
    class_<CMatrixFromColumnsNode, base<CImplicitNode>>("CMatrixFromColumnsNode")
        .smart_ptr<std::shared_ptr<CMatrixFromColumnsNode>>("shared_ptr<CMatrixFromColumnsNode>")
        .function("GetInputA", &CMatrixFromColumnsNode::GetInputA)
        .function("GetInputB", &CMatrixFromColumnsNode::GetInputB)
        .function("GetInputC", &CMatrixFromColumnsNode::GetInputC)
        .function("GetInputD", &CMatrixFromColumnsNode::GetInputD)
        .function("GetOutputResult", &CMatrixFromColumnsNode::GetOutputResult)
    ;
    class_<CConstantNode, base<CImplicitNode>>("CConstantNode")
        .smart_ptr<std::shared_ptr<CConstantNode>>("shared_ptr<CConstantNode>")
        .function("SetConstant", &CConstantNode::SetConstant)
        .function("GetConstant", &CConstantNode::GetConstant)
        .function("GetOutputValue", &CConstantNode::GetOutputValue)
    ;
    class_<CConstVecNode, base<CImplicitNode>>("CConstVecNode")
        .smart_ptr<std::shared_ptr<CConstVecNode>>("shared_ptr<CConstVecNode>")
        .function("SetVector", &wrap_ConstVecNode_SetVector)
        .function("GetVector", &wrap_ConstVecNode_GetVector)
        .function("GetOutputVector", &CConstVecNode::GetOutputVector)
    ;
    class_<CConstMatNode, base<CImplicitNode>>("CConstMatNode")
        .smart_ptr<std::shared_ptr<CConstMatNode>>("shared_ptr<CConstMatNode>")
        .function("SetMatrix", &wrap_ConstMatNode_SetMatrix)
        .function("GetMatrix", &wrap_ConstMatNode_GetMatrix)
        .function("GetOutputMatrix", &CConstMatNode::GetOutputMatrix)
    ;
    class_<CMeshNode, base<CImplicitNode>>("CMeshNode")
        .smart_ptr<std::shared_ptr<CMeshNode>>("shared_ptr<CMeshNode>")
        .function("GetInputMesh", &CMeshNode::GetInputMesh)
        .function("GetInputPos", &CMeshNode::GetInputPos)
        .function("GetOutputDistance", &CMeshNode::GetOutputDistance)
    ;
    class_<CUnsignedMeshNode, base<CImplicitNode>>("CUnsignedMeshNode")
        .smart_ptr<std::shared_ptr<CUnsignedMeshNode>>("shared_ptr<CUnsignedMeshNode>")
        .function("GetInputMesh", &CUnsignedMeshNode::GetInputMesh)
        .function("GetInputPos", &CUnsignedMeshNode::GetInputPos)
        .function("GetOutputDistance", &CUnsignedMeshNode::GetOutputDistance)
    ;
    class_<CBeamLatticeNode, base<CImplicitNode>>("CBeamLatticeNode")
        .smart_ptr<std::shared_ptr<CBeamLatticeNode>>("shared_ptr<CBeamLatticeNode>")
        .function("GetInputBeamLattice", &CBeamLatticeNode::GetInputBeamLattice)
        .function("GetInputPos", &CBeamLatticeNode::GetInputPos)
        .function("GetOutputDistance", &CBeamLatticeNode::GetOutputDistance)
        .function("SetAccurateRange", &CBeamLatticeNode::SetAccurateRange)
        .function("GetAccurateRange", &CBeamLatticeNode::GetAccurateRange)
    ;
    class_<CFunctionGradientNode, base<CImplicitNode>>("CFunctionGradientNode")
        .smart_ptr<std::shared_ptr<CFunctionGradientNode>>("shared_ptr<CFunctionGradientNode>")
        .function("GetInputFunctionID", &CFunctionGradientNode::GetInputFunctionID)
        .function("GetInputPos", &CFunctionGradientNode::GetInputPos)
        .function("GetInputStep", &CFunctionGradientNode::GetInputStep)
        .function("SetScalarOutputName", &CFunctionGradientNode::SetScalarOutputName)
        .function("GetScalarOutputName", &CFunctionGradientNode::GetScalarOutputName)
        .function("SetVectorInputName", &CFunctionGradientNode::SetVectorInputName)
        .function("GetVectorInputName", &CFunctionGradientNode::GetVectorInputName)
        .function("GetOutputNormalizedGradient", &CFunctionGradientNode::GetOutputNormalizedGradient)
        .function("GetOutputGradient", &CFunctionGradientNode::GetOutputGradient)
        .function("GetOutputMagnitude", &CFunctionGradientNode::GetOutputMagnitude)
    ;
    class_<CNormalizeDistanceNode, base<CImplicitNode>>("CNormalizeDistanceNode")
        .smart_ptr<std::shared_ptr<CNormalizeDistanceNode>>("shared_ptr<CNormalizeDistanceNode>")
        .function("GetInputFunctionID", &CNormalizeDistanceNode::GetInputFunctionID)
        .function("GetInputPos", &CNormalizeDistanceNode::GetInputPos)
        .function("GetInputStep", &CNormalizeDistanceNode::GetInputStep)
        .function("SetScalarOutputName", &CNormalizeDistanceNode::SetScalarOutputName)
        .function("GetScalarOutputName", &CNormalizeDistanceNode::GetScalarOutputName)
        .function("SetVectorInputName", &CNormalizeDistanceNode::SetVectorInputName)
        .function("GetVectorInputName", &CNormalizeDistanceNode::GetVectorInputName)
        .function("GetOutputResult", &CNormalizeDistanceNode::GetOutputResult)
    ;
    class_<CFunctionCallNode, base<CImplicitNode>>("CFunctionCallNode")
        .smart_ptr<std::shared_ptr<CFunctionCallNode>>("shared_ptr<CFunctionCallNode>")
        .function("GetInputFunctionID", &CFunctionCallNode::GetInputFunctionID)
    ;
    class_<CNodeIterator, base<CIterator>>("CNodeIterator")
        .smart_ptr<std::shared_ptr<CNodeIterator>>("shared_ptr<CNodeIterator>")
        .function("GetCurrent", &CNodeIterator::GetCurrent)
    ;
    class_<CFunction, base<CResource>>("CFunction")
        .smart_ptr<std::shared_ptr<CFunction>>("shared_ptr<CFunction>")
        .function("GetDisplayName", &CFunction::GetDisplayName)
        .function("SetDisplayName", &CFunction::SetDisplayName)
        .function("AddInput", &CFunction::AddInput)
        .function("GetInputs", &CFunction::GetInputs)
        .function("RemoveInput", &wrap_Function_RemoveInput)
        .function("AddOutput", &CFunction::AddOutput)
        .function("GetOutputs", &CFunction::GetOutputs)
        .function("RemoveOutput", &wrap_Function_RemoveOutput)
        .function("FindInput", &CFunction::FindInput)
        .function("FindOutput", &CFunction::FindOutput)
    ;
    class_<CImplicitFunction, base<CFunction>>("CImplicitFunction")
        .smart_ptr<std::shared_ptr<CImplicitFunction>>("shared_ptr<CImplicitFunction>")
        .function("GetIdentifier", &CImplicitFunction::GetIdentifier)
        .function("SetIdentifier", &CImplicitFunction::SetIdentifier)
        .function("AddNode", &CImplicitFunction::AddNode)
        .function("AddSinNode", &CImplicitFunction::AddSinNode)
        .function("AddCosNode", &CImplicitFunction::AddCosNode)
        .function("AddTanNode", &CImplicitFunction::AddTanNode)
        .function("AddArcSinNode", &CImplicitFunction::AddArcSinNode)
        .function("AddArcCosNode", &CImplicitFunction::AddArcCosNode)
        .function("AddArcTan2Node", &CImplicitFunction::AddArcTan2Node)
        .function("AddSinhNode", &CImplicitFunction::AddSinhNode)
        .function("AddCoshNode", &CImplicitFunction::AddCoshNode)
        .function("AddTanhNode", &CImplicitFunction::AddTanhNode)
        .function("AddRoundNode", &CImplicitFunction::AddRoundNode)
        .function("AddCeilNode", &CImplicitFunction::AddCeilNode)
        .function("AddFloorNode", &CImplicitFunction::AddFloorNode)
        .function("AddSignNode", &CImplicitFunction::AddSignNode)
        .function("AddFractNode", &CImplicitFunction::AddFractNode)
        .function("AddAbsNode", &CImplicitFunction::AddAbsNode)
        .function("AddExpNode", &CImplicitFunction::AddExpNode)
        .function("AddLogNode", &CImplicitFunction::AddLogNode)
        .function("AddLog2Node", &CImplicitFunction::AddLog2Node)
        .function("AddLog10Node", &CImplicitFunction::AddLog10Node)
        .function("AddLengthNode", &CImplicitFunction::AddLengthNode)
        .function("AddTransposeNode", &CImplicitFunction::AddTransposeNode)
        .function("AddInverseNode", &CImplicitFunction::AddInverseNode)
        .function("AddSqrtNode", &CImplicitFunction::AddSqrtNode)
        .function("AddResourceIdNode", &CImplicitFunction::AddResourceIdNode)
        .function("AddAdditionNode", &CImplicitFunction::AddAdditionNode)
        .function("AddSubtractionNode", &CImplicitFunction::AddSubtractionNode)
        .function("AddMultiplicationNode", &CImplicitFunction::AddMultiplicationNode)
        .function("AddDivisionNode", &CImplicitFunction::AddDivisionNode)
        .function("AddDotNode", &CImplicitFunction::AddDotNode)
        .function("AddCrossNode", &CImplicitFunction::AddCrossNode)
        .function("AddMatVecMultiplicationNode", &CImplicitFunction::AddMatVecMultiplicationNode)
        .function("AddMinNode", &CImplicitFunction::AddMinNode)
        .function("AddMaxNode", &CImplicitFunction::AddMaxNode)
        .function("AddFmodNode", &CImplicitFunction::AddFmodNode)
        .function("AddPowNode", &CImplicitFunction::AddPowNode)
        .function("AddSelectNode", &CImplicitFunction::AddSelectNode)
        .function("AddClampNode", &CImplicitFunction::AddClampNode)
        .function("AddComposeVectorNode", &CImplicitFunction::AddComposeVectorNode)
        .function("AddVectorFromScalarNode", &CImplicitFunction::AddVectorFromScalarNode)
        .function("AddDecomposeVectorNode", &CImplicitFunction::AddDecomposeVectorNode)
        .function("AddComposeMatrixNode", &CImplicitFunction::AddComposeMatrixNode)
        .function("AddMatrixFromRowsNode", &CImplicitFunction::AddMatrixFromRowsNode)
        .function("AddMatrixFromColumnsNode", &CImplicitFunction::AddMatrixFromColumnsNode)
        .function("AddConstantNode", &CImplicitFunction::AddConstantNode)
        .function("AddConstVecNode", &CImplicitFunction::AddConstVecNode)
        .function("AddConstMatNode", &CImplicitFunction::AddConstMatNode)
        .function("AddMeshNode", &CImplicitFunction::AddMeshNode)
        .function("AddUnsignedMeshNode", &CImplicitFunction::AddUnsignedMeshNode)
        .function("AddBeamLatticeNode", &CImplicitFunction::AddBeamLatticeNode)
        .function("AddFunctionGradientNode", &CImplicitFunction::AddFunctionGradientNode)
        .function("AddNormalizeDistanceNode", &CImplicitFunction::AddNormalizeDistanceNode)
        .function("AddFunctionCallNode", &CImplicitFunction::AddFunctionCallNode)
        .function("GetNodes", &CImplicitFunction::GetNodes)
        .function("RemoveNode", &wrap_ImplicitFunction_RemoveNode)
        .function("AddLink", &wrap_ImplicitFunction_AddLink)
        .function("AddLinkByNames", &CImplicitFunction::AddLinkByNames)
        .function("Clear", &CImplicitFunction::Clear)
        .function("SortNodesTopologically", &CImplicitFunction::SortNodesTopologically)
    ;
    class_<CFunctionFromImage3D, base<CFunction>>("CFunctionFromImage3D")
        .smart_ptr<std::shared_ptr<CFunctionFromImage3D>>("shared_ptr<CFunctionFromImage3D>")
        .function("GetImage3D", &CFunctionFromImage3D::GetImage3D)
        .function("SetImage3D", &wrap_FunctionFromImage3D_SetImage3D)
        .function("SetFilter", &CFunctionFromImage3D::SetFilter)
        .function("GetFilter", &CFunctionFromImage3D::GetFilter)
        .function("SetTileStyles", &CFunctionFromImage3D::SetTileStyles)
        .function("GetTileStyles", &wrap_FunctionFromImage3D_GetTileStyles)
        .function("GetOffset", &CFunctionFromImage3D::GetOffset)
        .function("SetOffset", &CFunctionFromImage3D::SetOffset)
        .function("GetScale", &CFunctionFromImage3D::GetScale)
        .function("SetScale", &CFunctionFromImage3D::SetScale)
    ;
    class_<CBuildItem, base<CBase>>("CBuildItem")
        .smart_ptr<std::shared_ptr<CBuildItem>>("shared_ptr<CBuildItem>")
        .function("GetObjectResource", &CBuildItem::GetObjectResource)
        .function("GetUUID", &wrap_BuildItem_GetUUID)
        .function("SetUUID", &CBuildItem::SetUUID)
        .function("GetObjectResourceID", &CBuildItem::GetObjectResourceID)
        .function("HasObjectTransform", &CBuildItem::HasObjectTransform)
        .function("GetObjectTransform", &wrap_BuildItem_GetObjectTransform)
        .function("SetObjectTransform", &wrap_BuildItem_SetObjectTransform)
        .function("GetPartNumber", &CBuildItem::GetPartNumber)
        .function("SetPartNumber", &CBuildItem::SetPartNumber)
        .function("GetMetaDataGroup", &CBuildItem::GetMetaDataGroup)
        .function("GetOutbox", &wrap_BuildItem_GetOutbox)
    ;
    class_<CBuildItemIterator, base<CBase>>("CBuildItemIterator")
        .smart_ptr<std::shared_ptr<CBuildItemIterator>>("shared_ptr<CBuildItemIterator>")
        .function("MoveNext", &CBuildItemIterator::MoveNext)
        .function("MovePrevious", &CBuildItemIterator::MovePrevious)
        .function("GetCurrent", &CBuildItemIterator::GetCurrent)
        .function("Clone", &CBuildItemIterator::Clone)
        .function("Count", &CBuildItemIterator::Count)
    ;
    class_<CSlice, base<CBase>>("CSlice")
        .smart_ptr<std::shared_ptr<CSlice>>("shared_ptr<CSlice>")
        .function("SetVertices", &wrap_Slice_SetVertices)
        .function("GetVertices", &wrap_Slice_GetVertices)
        .function("GetVertexCount", &CSlice::GetVertexCount)
        .function("AddPolygon", &CSlice::AddPolygon)
        .function("GetPolygonCount", &CSlice::GetPolygonCount)
        .function("SetPolygonIndices", &CSlice::SetPolygonIndices)
        .function("GetPolygonIndices", &wrap_Slice_GetPolygonIndices)
        .function("GetPolygonIndexCount", &CSlice::GetPolygonIndexCount)
        .function("GetZTop", &CSlice::GetZTop)
    ;
    class_<CSliceStack, base<CResource>>("CSliceStack")
        .smart_ptr<std::shared_ptr<CSliceStack>>("shared_ptr<CSliceStack>")
        .function("GetBottomZ", &CSliceStack::GetBottomZ)
        .function("GetSliceCount", &CSliceStack::GetSliceCount)
        .function("GetSlice", &CSliceStack::GetSlice)
        .function("AddSlice", &CSliceStack::AddSlice)
        .function("GetSliceRefCount", &CSliceStack::GetSliceRefCount)
        .function("AddSliceStackReference", &wrap_SliceStack_AddSliceStackReference)
        .function("GetSliceStackReference", &CSliceStack::GetSliceStackReference)
        .function("CollapseSliceReferences", &CSliceStack::CollapseSliceReferences)
        .function("SetOwnPath", &CSliceStack::SetOwnPath)
        .function("GetOwnPath", &CSliceStack::GetOwnPath)
    ;
    class_<CConsumer, base<CBase>>("CConsumer")
        .smart_ptr<std::shared_ptr<CConsumer>>("shared_ptr<CConsumer>")
        .function("GetConsumerID", &CConsumer::GetConsumerID)
        .function("GetKeyID", &CConsumer::GetKeyID)
        .function("GetKeyValue", &CConsumer::GetKeyValue)
    ;
    class_<CAccessRight, base<CBase>>("CAccessRight")
        .smart_ptr<std::shared_ptr<CAccessRight>>("shared_ptr<CAccessRight>")
        .function("GetConsumer", &CAccessRight::GetConsumer)
        .function("GetWrappingAlgorithm", &CAccessRight::GetWrappingAlgorithm)
        .function("GetMgfAlgorithm", &CAccessRight::GetMgfAlgorithm)
        .function("GetDigestMethod", &CAccessRight::GetDigestMethod)
    ;
    class_<CContentEncryptionParams, base<CBase>>("CContentEncryptionParams")
        .smart_ptr<std::shared_ptr<CContentEncryptionParams>>("shared_ptr<CContentEncryptionParams>")
        .function("GetEncryptionAlgorithm", &CContentEncryptionParams::GetEncryptionAlgorithm)
        .function("GetKey", &wrap_ContentEncryptionParams_GetKey)
        .function("GetInitializationVector", &wrap_ContentEncryptionParams_GetInitializationVector)
        .function("GetAuthenticationTag", &wrap_ContentEncryptionParams_GetAuthenticationTag)
        .function("SetAuthenticationTag", &CContentEncryptionParams::SetAuthenticationTag)
        .function("GetAdditionalAuthenticationData", &wrap_ContentEncryptionParams_GetAdditionalAuthenticationData)
        .function("GetDescriptor", &CContentEncryptionParams::GetDescriptor)
        .function("GetKeyUUID", &CContentEncryptionParams::GetKeyUUID)
    ;
    class_<CResourceData, base<CBase>>("CResourceData")
        .smart_ptr<std::shared_ptr<CResourceData>>("shared_ptr<CResourceData>")
        .function("GetPath", &CResourceData::GetPath)
        .function("GetEncryptionAlgorithm", &CResourceData::GetEncryptionAlgorithm)
        .function("GetCompression", &CResourceData::GetCompression)
        .function("GetAdditionalAuthenticationData", &wrap_ResourceData_GetAdditionalAuthenticationData)
    ;
    class_<CResourceDataGroup, base<CBase>>("CResourceDataGroup")
        .smart_ptr<std::shared_ptr<CResourceDataGroup>>("shared_ptr<CResourceDataGroup>")
        .function("GetKeyUUID", &CResourceDataGroup::GetKeyUUID)
        .function("AddAccessRight", &wrap_ResourceDataGroup_AddAccessRight)
        .function("FindAccessRightByConsumer", &wrap_ResourceDataGroup_FindAccessRightByConsumer)
        .function("RemoveAccessRight", &wrap_ResourceDataGroup_RemoveAccessRight)
    ;
    class_<CKeyStore, base<CBase>>("CKeyStore")
        .smart_ptr<std::shared_ptr<CKeyStore>>("shared_ptr<CKeyStore>")
        .function("AddConsumer", &CKeyStore::AddConsumer)
        .function("GetConsumerCount", &CKeyStore::GetConsumerCount)
        .function("GetConsumer", &CKeyStore::GetConsumer)
        .function("RemoveConsumer", &wrap_KeyStore_RemoveConsumer)
        .function("FindConsumer", &CKeyStore::FindConsumer)
        .function("GetResourceDataGroupCount", &CKeyStore::GetResourceDataGroupCount)
        .function("AddResourceDataGroup", &CKeyStore::AddResourceDataGroup)
        .function("GetResourceDataGroup", &CKeyStore::GetResourceDataGroup)
        .function("RemoveResourceDataGroup", &wrap_KeyStore_RemoveResourceDataGroup)
        .function("FindResourceDataGroup", &wrap_KeyStore_FindResourceDataGroup)
        .function("AddResourceData", &wrap_KeyStore_AddResourceData)
        .function("RemoveResourceData", &wrap_KeyStore_RemoveResourceData)
        .function("FindResourceData", &wrap_KeyStore_FindResourceData)
        .function("GetResourceDataCount", &CKeyStore::GetResourceDataCount)
        .function("GetResourceData", &CKeyStore::GetResourceData)
        .function("GetUUID", &wrap_KeyStore_GetUUID)
        .function("SetUUID", &CKeyStore::SetUUID)
    ;
    class_<CModel, base<CBase>>("CModel")
        .smart_ptr<std::shared_ptr<CModel>>("shared_ptr<CModel>")
        .function("RootModelPart", &CModel::RootModelPart)
        .function("FindOrCreatePackagePart", &CModel::FindOrCreatePackagePart)
        .function("SetUnit", &CModel::SetUnit)
        .function("GetUnit", &CModel::GetUnit)
        .function("GetLanguage", &CModel::GetLanguage)
        .function("SetLanguage", &CModel::SetLanguage)
        .function("QueryWriter", &CModel::QueryWriter)
        .function("QueryReader", &CModel::QueryReader)
        .function("GetResourceByID", &CModel::GetResourceByID)
        .function("GetTexture2DByID", &CModel::GetTexture2DByID)
        .function("GetPropertyTypeByID", &CModel::GetPropertyTypeByID)
        .function("GetBaseMaterialGroupByID", &CModel::GetBaseMaterialGroupByID)
        .function("GetTexture2DGroupByID", &CModel::GetTexture2DGroupByID)
        .function("GetCompositeMaterialsByID", &CModel::GetCompositeMaterialsByID)
        .function("GetMultiPropertyGroupByID", &CModel::GetMultiPropertyGroupByID)
        .function("GetMeshObjectByID", &CModel::GetMeshObjectByID)
        .function("GetComponentsObjectByID", &CModel::GetComponentsObjectByID)
        .function("GetColorGroupByID", &CModel::GetColorGroupByID)
        .function("GetSliceStackByID", &CModel::GetSliceStackByID)
        .function("GetLevelSetByID", &CModel::GetLevelSetByID)
        .function("GetBuildUUID", &wrap_Model_GetBuildUUID)
        .function("SetBuildUUID", &CModel::SetBuildUUID)
        .function("GetBuildItems", &CModel::GetBuildItems)
        .function("GetOutbox", &wrap_Model_GetOutbox)
        .function("GetResources", &CModel::GetResources)
        .function("GetObjects", &CModel::GetObjects)
        .function("GetMeshObjects", &CModel::GetMeshObjects)
        .function("GetComponentsObjects", &CModel::GetComponentsObjects)
        .function("GetTexture2Ds", &CModel::GetTexture2Ds)
        .function("GetBaseMaterialGroups", &CModel::GetBaseMaterialGroups)
        .function("GetColorGroups", &CModel::GetColorGroups)
        .function("GetTexture2DGroups", &CModel::GetTexture2DGroups)
        .function("GetCompositeMaterials", &CModel::GetCompositeMaterials)
        .function("GetMultiPropertyGroups", &CModel::GetMultiPropertyGroups)
        .function("GetSliceStacks", &CModel::GetSliceStacks)
        .function("GetImage3Ds", &CModel::GetImage3Ds)
        .function("MergeToModel", &CModel::MergeToModel)
        .function("MergeFromModel", &wrap_Model_MergeFromModel)
        .function("AddMeshObject", &CModel::AddMeshObject)
        .function("AddComponentsObject", &CModel::AddComponentsObject)
        .function("AddSliceStack", &CModel::AddSliceStack)
        .function("AddTexture2DFromAttachment", &wrap_Model_AddTexture2DFromAttachment)
        .function("AddBaseMaterialGroup", &CModel::AddBaseMaterialGroup)
        .function("AddColorGroup", &CModel::AddColorGroup)
        .function("AddTexture2DGroup", &wrap_Model_AddTexture2DGroup)
        .function("AddCompositeMaterials", &wrap_Model_AddCompositeMaterials)
        .function("AddMultiPropertyGroup", &CModel::AddMultiPropertyGroup)
        .function("AddImageStack", &CModel::AddImageStack)
        .function("GetImageStackByID", &CModel::GetImageStackByID)
        .function("AddBuildItem", &wrap_Model_AddBuildItem)
        .function("RemoveBuildItem", &wrap_Model_RemoveBuildItem)
        .function("GetMetaDataGroup", &CModel::GetMetaDataGroup)
        .function("AddAttachment", &CModel::AddAttachment)
        .function("RemoveAttachment", &wrap_Model_RemoveAttachment)
        .function("GetAttachment", &CModel::GetAttachment)
        .function("FindAttachment", &CModel::FindAttachment)
        .function("GetAttachmentCount", &CModel::GetAttachmentCount)
        .function("HasPackageThumbnailAttachment", &CModel::HasPackageThumbnailAttachment)
        .function("CreatePackageThumbnailAttachment", &CModel::CreatePackageThumbnailAttachment)
        .function("GetPackageThumbnailAttachment", &CModel::GetPackageThumbnailAttachment)
        .function("RemovePackageThumbnailAttachment", &CModel::RemovePackageThumbnailAttachment)
        .function("AddCustomContentType", &CModel::AddCustomContentType)
        .function("RemoveCustomContentType", &CModel::RemoveCustomContentType)
        // .function("SetRandomNumberCallback", &wrap_Model_SetRandomNumberCallback) // Skipped due to callback
        .function("GetKeyStore", &CModel::GetKeyStore)
        .function("GetFunctions", &CModel::GetFunctions)
        .function("AddImplicitFunction", &CModel::AddImplicitFunction)
        .function("AddFunctionFromImage3D", &wrap_Model_AddFunctionFromImage3D)
        .function("AddVolumeData", &CModel::AddVolumeData)
        .function("AddLevelSet", &CModel::AddLevelSet)
        .function("GetLevelSets", &CModel::GetLevelSets)
        .function("RemoveResource", &wrap_Model_RemoveResource)
    ;
    // CWrapper global bindings
    class_<CWrapper>("CWrapper")
        .constructor<>()
        .function("GetLibraryVersion", &wrap_Wrapper_GetLibraryVersion)
        .function("GetPrereleaseInformation", &wrap_Wrapper_GetPrereleaseInformation)
        .function("GetBuildInformation", &wrap_Wrapper_GetBuildInformation)
        .function("GetSpecificationVersion", &wrap_Wrapper_GetSpecificationVersion)
        .function("CreateModel", &CWrapper::CreateModel)
        .function("Release", &wrap_Wrapper_Release)
        .function("Acquire", &wrap_Wrapper_Acquire)
        .function("SetJournal", &CWrapper::SetJournal)
        .function("GetLastError", &wrap_Wrapper_GetLastError)
        // .function("GetSymbolLookupMethod", &CWrapper::GetSymbolLookupMethod) // Explicitly skipped (Returns a void pointer)
        .function("RetrieveProgressMessage", &wrap_Wrapper_RetrieveProgressMessage)
        .function("RGBAToColor", &wrap_Wrapper_RGBAToColor)
        .function("FloatRGBAToColor", &wrap_Wrapper_FloatRGBAToColor)
        .function("ColorToRGBA", &wrap_Wrapper_ColorToRGBA)
        .function("ColorToFloatRGBA", &wrap_Wrapper_ColorToFloatRGBA)
        .function("GetIdentityTransform", &wrap_Wrapper_GetIdentityTransform)
        .function("GetUniformScaleTransform", &wrap_Wrapper_GetUniformScaleTransform)
        .function("GetScaleTransform", &wrap_Wrapper_GetScaleTransform)
        .function("GetTranslationTransform", &wrap_Wrapper_GetTranslationTransform)
    ;
}
