/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ColorGroup extends Resource {

	public ColorGroup(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the count of base materials in this Color Group.
	 *
	 * @return returns the count of colors within this color group.
	 * @throws Lib3MFException
	 */
	public int getCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_getcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * returns all the PropertyIDs of all colors within this group
	 *
	 * @return PropertyID of the color in the color group.
	 * @throws Lib3MFException
	 */
	public int[] getAllPropertyIDs() throws Lib3MFException {
		Pointer countNeededPropertyIDs = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededPropertyIDs, Pointer.NULL}));
		long countPropertyIDs = countNeededPropertyIDs.getLong(0);
		Pointer bufferPropertyIDs = new Memory(Math.max(1, 4 * countPropertyIDs));
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_getallpropertyids.invokeInt(new java.lang.Object[]{mHandle, countPropertyIDs, countNeededPropertyIDs, bufferPropertyIDs}));
		return bufferPropertyIDs.getIntArray(0, (int)countPropertyIDs);
	}

	/**
	 * Adds a new value.
	 *
	 * @param theColor The new color
	 * @return PropertyID of the new color within this color group.
	 * @throws Lib3MFException
	 */
	public int addColor(Color theColor) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		theColor.writeToPointer(bufferTheColor, 0);
		Pointer bufferPropertyID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_addcolor.invokeInt(new java.lang.Object[]{mHandle, bufferTheColor, bufferPropertyID}));
		return bufferPropertyID.getInt(0);
	}

	/**
	 * Removes a color from the color group.
	 *
	 * @param propertyID PropertyID of the color to be removed from the color group.
	 * @throws Lib3MFException
	 */
	public void removeColor(int propertyID) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_removecolor.invokeInt(new java.lang.Object[]{mHandle, propertyID}));
	}

	/**
	 * Sets a color value.
	 *
	 * @param propertyID PropertyID of a color within this color group.
	 * @param theColor The color
	 * @throws Lib3MFException
	 */
	public void setColor(int propertyID, Color theColor) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		theColor.writeToPointer(bufferTheColor, 0);
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_setcolor.invokeInt(new java.lang.Object[]{mHandle, propertyID, bufferTheColor}));
	}

	/**
	 * Sets a color value.
	 *
	 * @param propertyID PropertyID of a color within this color group.
	 * @return The color
	 * @throws Lib3MFException
	 */
	public Color getColor(int propertyID) throws Lib3MFException {
		Pointer bufferTheColor = new Memory(Color.SIZE);
		mWrapper.checkError(this, mWrapper.lib3mf_colorgroup_getcolor.invokeInt(new java.lang.Object[]{mHandle, propertyID, bufferTheColor}));
		Color theColor = new Color();
		theColor.readFromPointer(bufferTheColor, 0);
		return theColor;
	}


}

