/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.vertx;

import io.smallrye.faulttolerance.core.util.RunnableWrapper;
import io.vertx.core.Context;
import java.util.concurrent.Executor;

final class VertxExecutor
implements Executor {
    private final Context vertxContext;
    private final boolean offloadToWorkerThread;

    VertxExecutor(Context vertxContext, boolean offloadToWorkerThread) {
        this.vertxContext = vertxContext;
        this.offloadToWorkerThread = offloadToWorkerThread;
    }

    @Override
    public void execute(Runnable runnable) {
        Runnable wrappedRunnable = RunnableWrapper.INSTANCE.wrap(runnable);
        if (this.vertxContext.isEventLoopContext() && this.offloadToWorkerThread) {
            this.vertxContext.executeBlocking(() -> {
                wrappedRunnable.run();
                return null;
            }, false);
        } else {
            this.vertxContext.runOnContext(ignored -> wrappedRunnable.run());
        }
    }
}

