/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.process.Logging;
import io.smallrye.common.process.PipelineExecutionException;
import io.smallrye.common.process.PipelineRunner;
import io.smallrye.common.process.ProcessBuilderImpl;
import io.smallrye.common.process.ProcessExecutionException;
import io.smallrye.common.process.ProcessUtil;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;

final class ProcessRunner<O>
extends PipelineRunner<O> {
    private static final VarHandle taskCountHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "taskCount", VarHandle.class, MethodHandles.lookup().lookupClass(), Integer.TYPE);
    private static final int STATUS_WAITING = 0;
    private static final int STATUS_STARTED = 1;
    private static final int STATUS_FAILED = 2;
    private final CopyOnWriteArraySet<Thread> waiters = new CopyOnWriteArraySet<Thread>(List.of(Thread.currentThread()));
    private volatile int status;
    O result;
    private volatile int taskCount;

    ProcessRunner(ProcessBuilderImpl<O> processBuilder, PipelineRunner<O> prev) {
        super(processBuilder, prev);
    }

    void taskComplete() {
        int oldVal = taskCountHandle.getAndAdd(this, -1);
        if (oldVal == 1) {
            this.waiters.removeIf(thread -> {
                LockSupport.unpark(thread);
                return true;
            });
        }
    }

    CompletableFuture<O> runAsync() {
        CompletableFuture cf = new CompletableFuture();
        ThreadFactory tf = ProcessRunner.threadFactory();
        this.asyncThread = tf.newThread(() -> {
            if (this.awaitOk()) {
                Thread shutdownHook = this.registerHook();
                this.await();
                try {
                    cf.complete(this.complete());
                }
                catch (Throwable t) {
                    cf.completeExceptionally(t);
                }
                finally {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
            }
        });
        if (this.asyncThread == null) {
            throw new PipelineExecutionException("Failed to start process thread(s)", ProcessRunner.noThread(tf));
        }
        this.asyncThread.setName("process-async-handler");
        this.initialize(tf);
        return cf;
    }

    O run() {
        this.initialize(ProcessRunner.threadFactory());
        Thread shutdownHook = this.registerHook();
        try {
            this.await();
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        return this.complete();
    }

    private void initialize(ThreadFactory tf) {
        int taskCnt;
        try {
            taskCnt = this.createThreads(tf, this, null);
        }
        catch (IOException e) {
            throw new PipelineExecutionException("Failed to create process thread(s)", e);
        }
        try {
            this.taskCount = taskCnt;
            this.startThreads();
        }
        catch (Throwable t) {
            this.status = 2;
            this.unpark();
            throw new PipelineExecutionException("Failed to start process thread(s)", t);
        }
        try {
            int depth = this.processBuilder.depth;
            ArrayList<Process> processes = new ArrayList<Process>(depth);
            List<ProcessBuilder> processBuilders = Arrays.asList(new ProcessBuilder[depth]);
            try {
                this.startProcesses(depth, processes, processBuilders);
            }
            catch (Throwable t) {
                processes.forEach(ProcessUtil::destroyAllForcibly);
                throw t;
            }
        }
        catch (Throwable t) {
            this.status = 2;
            this.unpark();
            throw new PipelineExecutionException("Failed to start process pipeline", t);
        }
        this.status = 1;
        this.unpark();
    }

    private void await() {
        int cnt = this.taskCount;
        if (cnt != 0) {
            this.waiters.add(Thread.currentThread());
        }
        do {
            Thread.interrupted();
            LockSupport.park(this);
        } while ((cnt = this.taskCount) != 0);
    }

    private Thread registerHook() {
        Thread shutdownHook = new Thread(() -> {
            int cnt = this.taskCount;
            if (cnt != 0) {
                this.waiters.add(Thread.currentThread());
                do {
                    Logging.log.debugf("Waiting for processes to exit (%d subtasks remaining)", cnt);
                    Thread.interrupted();
                    LockSupport.park(this);
                } while ((cnt = this.taskCount) != 0);
                Logging.log.debug("All process exit tasks are complete");
            }
        }, "pipeline-shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    private O complete() {
        ArrayList<ProcessExecutionException> problems = new ArrayList<ProcessExecutionException>(4);
        this.collectProblems(problems);
        switch (problems.size()) {
            case 0: {
                break;
            }
            case 1: {
                throw (ProcessExecutionException)problems.get(0);
            }
            default: {
                PipelineExecutionException ex = new PipelineExecutionException("Pipeline execution failed");
                problems.forEach(ex::addSuppressed);
                throw ex;
            }
        }
        return this.result;
    }

    private static ThreadFactory threadFactory() {
        return task -> new Thread(() -> {
            Logging.log.trace("Starting process thread");
            try {
                task.run();
            }
            finally {
                Logging.log.trace("Ending process thread");
            }
        });
    }

    boolean awaitOk() {
        while (this.status == 0) {
            LockSupport.park(this);
        }
        Logging.log.trace("Process thread released");
        return this.status == 1;
    }
}

