/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;

public class SerializeExecutionsByKey<K> {
    private static final Logger LOG = Logger.getLogger(SerializeExecutionsByKey.class);
    private final ConcurrentHashMap<K, ReentrantLock> cacheInteractions = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSerialized(K key, Runnable task) {
        ReentrantLock lock = this.cacheInteractions.computeIfAbsent(key, s -> new ReentrantLock());
        try {
            lock.lock();
            ReentrantLock existingLock = this.cacheInteractions.putIfAbsent(key, lock);
            if (existingLock != lock) {
                LOG.debugf("Concurrent execution detected for key '%s'.", key);
            }
            task.run();
        }
        finally {
            lock.unlock();
            this.cacheInteractions.remove(key, lock);
        }
    }
}

