/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.BootstrapMethodEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPool;
import io.github.dmlloyd.classfile.constantpool.LoadableConstantEntry;
import io.github.dmlloyd.classfile.constantpool.MethodHandleEntry;
import io.github.dmlloyd.classfile.impl.AbstractPoolEntry;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.Util;
import java.util.List;

public final class BootstrapMethodEntryImpl
implements BootstrapMethodEntry {
    final int index;
    final int hash;
    private final ConstantPool constantPool;
    private final AbstractPoolEntry.MethodHandleEntryImpl handle;
    private final List<LoadableConstantEntry> arguments;

    BootstrapMethodEntryImpl(ConstantPool constantPool, int bsmIndex, int hash, AbstractPoolEntry.MethodHandleEntryImpl handle, List<LoadableConstantEntry> arguments) {
        this.index = bsmIndex;
        this.hash = hash;
        this.constantPool = constantPool;
        this.handle = handle;
        this.arguments = List.copyOf(arguments);
    }

    @Override
    public ConstantPool constantPool() {
        return this.constantPool;
    }

    @Override
    public MethodHandleEntry bootstrapMethod() {
        return this.handle;
    }

    @Override
    public List<LoadableConstantEntry> arguments() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        BootstrapMethodEntry e;
        return obj instanceof BootstrapMethodEntry && (e = (BootstrapMethodEntry)obj).bootstrapMethod().equals(this.handle) && e.arguments().equals(this.arguments);
    }

    static int computeHashCode(AbstractPoolEntry.MethodHandleEntryImpl handle, List<? extends LoadableConstantEntry> arguments) {
        return 31 * handle.hashCode() + arguments.hashCode() | 0x40000000;
    }

    @Override
    public int bsmIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hash;
    }

    void writeTo(BufWriterImpl writer) {
        writer.writeIndex(this.bootstrapMethod());
        Util.writeListIndices(writer, this.arguments());
    }
}

