/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.hibernate.annotations.Nationalized;
import org.keycloak.models.jpa.converter.MapStringConverter;
import org.keycloak.models.jpa.entities.RealmEntity;

@Entity
@IdClass(value=RealmLocalizationTextEntityKey.class)
@Table(name="REALM_LOCALIZATIONS")
public class RealmLocalizationTextsEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REALM_ID")
    private RealmEntity realm;
    @Id
    @Column(name="LOCALE")
    private String locale;
    @Nationalized
    @Column(name="TEXTS")
    @Convert(converter=MapStringConverter.class)
    private Map<String, String> texts;

    public Map<String, String> getTexts() {
        return this.texts;
    }

    public void setTexts(Map<String, String> texts) {
        this.texts = texts;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public RealmEntity getRealm() {
        return this.realm;
    }

    public void setRealm(RealmEntity realm) {
        this.realm = realm;
    }

    public String toString() {
        return "LocalizationTextEntity{text='" + String.valueOf(this.texts) + "', locale='" + this.locale + "', realm='" + String.valueOf(this.realm) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmLocalizationTextsEntity that = (RealmLocalizationTextsEntity)o;
        return Objects.equals(this.realm, that.realm) && Objects.equals(this.locale, that.locale) && Objects.equals(this.texts, that.texts);
    }

    public int hashCode() {
        return Objects.hash(this.realm, this.locale, this.texts);
    }

    public static class RealmLocalizationTextEntityKey
    implements Serializable {
        private RealmEntity realm;
        private String locale;

        public RealmEntity getRealm() {
            return this.realm;
        }

        public void setRealm(RealmEntity realm) {
            this.realm = realm;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmLocalizationTextEntityKey that = (RealmLocalizationTextEntityKey)o;
            return Objects.equals(this.realm, that.realm) && Objects.equals(this.locale, that.locale);
        }

        public int hashCode() {
            return Objects.hash(this.realm, this.locale);
        }
    }
}

