/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.github;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.http.simple.SimpleHttpRequest;
import org.keycloak.http.simple.SimpleHttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.util.BasicAuthHelper;

public class GitHubIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    public static final String DEFAULT_BASE_URL = "https://github.com";
    public static final String AUTH_FRAGMENT = "/login/oauth/authorize";
    public static final String TOKEN_FRAGMENT = "/login/oauth/access_token";
    public static final String DEFAULT_AUTH_URL = "https://github.com/login/oauth/authorize";
    public static final String DEFAULT_TOKEN_URL = "https://github.com/login/oauth/access_token";
    @Deprecated
    public static final String AUTH_URL = "https://github.com/login/oauth/authorize";
    @Deprecated
    public static final String TOKEN_URL = "https://github.com/login/oauth/access_token";
    public static final String DEFAULT_API_URL = "https://api.github.com";
    public static final String APPLICATIONS_FRAGMENT = "/applications";
    public static final String PROFILE_FRAGMENT = "/user";
    public static final String EMAIL_FRAGMENT = "/user/emails";
    public static final String DEFAULT_APPLICATIONS_URL = "https://api.github.com/applications";
    public static final String DEFAULT_PROFILE_URL = "https://api.github.com/user";
    public static final String DEFAULT_EMAIL_URL = "https://api.github.com/user/emails";
    @Deprecated
    public static final String PROFILE_URL = "https://api.github.com/user";
    @Deprecated
    public static final String EMAIL_URL = "https://api.github.com/user/emails";
    public static final String DEFAULT_SCOPE = "user:email";
    protected static final String BASE_URL_KEY = "baseUrl";
    protected static final String API_URL_KEY = "apiUrl";
    protected static final String GITHUB_JSON_FORMAT_KEY = "githubJsonFormat";
    protected static final String EMAIL_URL_KEY = "emailUrl";
    private final String authUrl;
    private final String tokenUrl;
    private final String profileUrl;
    private final String emailUrl;
    private final boolean githubJsonFormat;

    public GitHubIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        String baseUrl = GitHubIdentityProvider.getUrlFromConfig(config, BASE_URL_KEY, DEFAULT_BASE_URL);
        String apiUrl = GitHubIdentityProvider.getUrlFromConfig(config, API_URL_KEY, DEFAULT_API_URL);
        this.authUrl = baseUrl + AUTH_FRAGMENT;
        this.tokenUrl = baseUrl + TOKEN_FRAGMENT;
        this.profileUrl = apiUrl + PROFILE_FRAGMENT;
        this.emailUrl = apiUrl + EMAIL_FRAGMENT;
        config.setAuthorizationUrl(this.authUrl);
        config.setTokenUrl(this.tokenUrl);
        config.setUserInfoUrl(this.profileUrl);
        config.getConfig().put(EMAIL_URL_KEY, this.emailUrl);
        this.githubJsonFormat = Boolean.parseBoolean(config.getConfig().getOrDefault(GITHUB_JSON_FORMAT_KEY, "false"));
    }

    protected static String getUrlFromConfig(OAuth2IdentityProviderConfig config, String key, String defaultValue) {
        String url = (String)config.getConfig().get(key);
        if (url == null || url.trim().isEmpty()) {
            url = defaultValue;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return this.profileUrl;
    }

    @Override
    public SimpleHttpRequest authenticateTokenRequest(SimpleHttpRequest tokenRequest) {
        SimpleHttpRequest simpleHttp = super.authenticateTokenRequest(tokenRequest);
        if (this.githubJsonFormat) {
            simpleHttp.acceptJson();
        }
        return simpleHttp;
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "id"), this.getConfig());
        String username = this.getJsonProperty(profile, "login");
        user.setUsername(username);
        user.setName(this.getJsonProperty(profile, "name"));
        user.setEmail(this.getJsonProperty(profile, "email"));
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
        return user;
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        BrokeredIdentityContext brokeredIdentityContext;
        block10: {
            SimpleHttpResponse response = SimpleHttp.create((KeycloakSession)this.session).doGet(this.profileUrl).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json").asResponse();
            try {
                if (Response.Status.fromStatusCode((int)response.getStatus()).getFamily() != Response.Status.Family.SUCCESSFUL) {
                    logger.warnf("Profile endpoint returned an error (%d): %s", (Object)response.getStatus(), (Object)response.asString());
                    throw new IdentityBrokerException("Profile could not be retrieved from the github endpoint");
                }
                JsonNode profile = response.asJson();
                logger.tracef("profile retrieved from github: %s", (Object)profile);
                BrokeredIdentityContext user = this.extractIdentityFromProfile(null, profile);
                if (user.getEmail() == null) {
                    user.setEmail(this.searchEmail(accessToken));
                }
                brokeredIdentityContext = user;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IdentityBrokerException("Profile could not be retrieved from the github endpoint", (Throwable)e);
                }
            }
            response.close();
        }
        return brokeredIdentityContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String searchEmail(String accessToken) {
        try (SimpleHttpResponse response = SimpleHttp.create((KeycloakSession)this.session).doGet(this.emailUrl).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json").asResponse();){
            JsonNode mail;
            JsonNode primary;
            if (Response.Status.fromStatusCode((int)response.getStatus()).getFamily() != Response.Status.Family.SUCCESSFUL) {
                logger.warnf("Primary email endpoint returned an error (%d): %s", (Object)response.getStatus(), (Object)response.asString());
                throw new IdentityBrokerException("Primary email could not be retrieved from the github endpoint");
            }
            JsonNode emails = response.asJson();
            logger.tracef("emails retrieved from github: %s", (Object)emails);
            if (!emails.isArray()) throw new IdentityBrokerException("Primary email from github is not found in the user's email list.");
            Iterator loop = emails.elements();
            do {
                if (!loop.hasNext()) throw new IdentityBrokerException("Primary email from github is not found in the user's email list.");
            } while ((primary = (mail = (JsonNode)loop.next()).get("primary")) == null || !primary.asBoolean());
            String string = this.getJsonProperty(mail, "email");
            return string;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Primary email could not be retrieved from the github endpoint", (Throwable)e);
        }
    }

    private void verifyToken(String accessToken) throws IOException {
        String tokenUrl = "https://api.github.com/applications/" + this.getConfig().getClientId() + "/token";
        SimpleHttpResponse response = SimpleHttp.create((KeycloakSession)this.session).doPost(tokenUrl).header("Authorization", BasicAuthHelper.createHeader((String)this.getConfig().getClientId(), (String)this.getConfig().getClientSecret())).json(Map.of("access_token", accessToken)).asResponse();
        JsonNode jsonNodeResponse = response.asJson();
        if (response.getStatus() != 200) {
            String errorMessage = this.getJsonProperty(jsonNodeResponse, "message");
            throw new RuntimeException("Error message: " + errorMessage);
        }
        JsonNode appNode = jsonNodeResponse.get("app");
        if (appNode == null || appNode.isNull()) {
            throw new RuntimeException("Invalid token check response: 'app' field is missing.");
        }
        String clientId = this.getJsonProperty(appNode, "client_id");
        if (!this.getConfig().getClientId().equals(clientId)) {
            throw new RuntimeException("Client ID does not match the client_id in the access token check response.");
        }
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalTokenV2Impl(TokenExchangeContext tokenExchangeContext) {
        String subjectToken = (String)tokenExchangeContext.getFormParams().getFirst((Object)"subject_token");
        if (subjectToken == null) {
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        try {
            this.verifyToken(subjectToken);
            return this.doGetFederatedIdentity(subjectToken);
        }
        catch (Exception e) {
            throw new ErrorResponseException("invalid_token", e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

