/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.ForeignKey;
import java.util.EnumSet;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.model.internal.ToOneFkSecondPass;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Value;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.type.ForeignKeyDirection;

public class OneToOneSecondPass
implements SecondPass {
    private final PropertyData inferredData;
    private final PropertyHolder propertyHolder;
    private final String mappedBy;
    private final String ownerEntity;
    private final NotFoundAction notFoundAction;
    private final OnDeleteAction onDeleteAction;
    private final boolean optional;
    private final EnumSet<CascadeType> cascadeStrategy;
    private final AnnotatedJoinColumns joinColumns;
    private final MetadataBuildingContext buildingContext;
    private final String referencedEntityName;
    private final boolean annotatedEntity;

    public OneToOneSecondPass(String mappedBy, String ownerEntity, PropertyHolder propertyHolder, PropertyData inferredData, String referencedEntityName, boolean annotatedEntity, NotFoundAction notFoundAction, OnDeleteAction onDeleteAction, boolean optional, EnumSet<CascadeType> cascadeStrategy, AnnotatedJoinColumns columns, MetadataBuildingContext buildingContext) {
        this.ownerEntity = ownerEntity;
        this.mappedBy = mappedBy;
        this.propertyHolder = propertyHolder;
        this.referencedEntityName = referencedEntityName;
        this.buildingContext = buildingContext;
        this.notFoundAction = notFoundAction;
        this.inferredData = inferredData;
        this.annotatedEntity = annotatedEntity;
        this.onDeleteAction = onDeleteAction;
        this.optional = optional;
        this.cascadeStrategy = cascadeStrategy;
        this.joinColumns = columns;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        OneToOne value = new OneToOne(this.buildingContext, this.propertyHolder.getTable(), this.propertyHolder.getPersistentClass());
        String propertyName = this.inferredData.getPropertyName();
        value.setPropertyName(propertyName);
        value.setReferencedEntityName(this.referencedEntityName);
        MemberDetails property = this.inferredData.getAttributeMember();
        ToOneBinder.defineFetchingStrategy(value, property, this.inferredData, this.propertyHolder);
        value.setOnDeleteAction(this.onDeleteAction);
        value.setConstrained(!this.optional);
        value.setForeignKeyType(this.getForeignKeyDirection());
        ToOneBinder.bindForeignKeyNameAndDefinition(value, property, (ForeignKey)property.getDirectAnnotationUsage(ForeignKey.class), this.buildingContext);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setMemberDetails(property);
        binder.setValue(value);
        binder.setCascade(this.cascadeStrategy);
        binder.setAccessType(this.inferredData.getDefaultAccess());
        binder.setBuildingContext(this.buildingContext);
        binder.setHolder(this.propertyHolder);
        LazyGroup lazyGroupAnnotation = (LazyGroup)property.getDirectAnnotationUsage(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            binder.setLazyGroup(lazyGroupAnnotation.value());
        }
        Property result = binder.makeProperty();
        result.setOptional(this.optional);
        if (this.mappedBy == null) {
            this.bindOwned(persistentClasses, value, propertyName, result);
        } else {
            this.bindUnowned(persistentClasses, value, result);
        }
        binder.callAttributeBindersInSecondPass(result);
        value.sortProperties();
    }

    private ForeignKeyDirection getForeignKeyDirection() {
        return this.mappedBy == null ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT;
    }

    private void bindUnowned(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, Property property) {
        oneToOne.setMappedByProperty(this.mappedBy);
        String targetEntityName = oneToOne.getReferencedEntityName();
        PersistentClass targetEntity = persistentClasses.get(targetEntityName);
        if (targetEntity == null) {
            String problem = this.annotatedEntity ? " which does not belong to the same persistence unit" : " which is not an '@Entity' type";
            throw new MappingException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' targets the type '" + targetEntityName + "'" + problem);
        }
        Property targetProperty = this.targetProperty(oneToOne, targetEntity);
        Value targetPropertyValue = targetProperty.getValue();
        if (targetPropertyValue instanceof OneToOne) {
            this.propertyHolder.addProperty(property, this.inferredData.getAttributeMember(), this.inferredData.getDeclaringClass());
        } else if (targetPropertyValue instanceof ManyToOne) {
            this.bindTargetManyToOne(persistentClasses, oneToOne, property, targetEntity, targetProperty);
        } else {
            throw new AnnotationException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is 'mappedBy' a property named '" + this.mappedBy + "' of the target entity type '" + targetEntityName + "' which is not a '@OneToOne' or '@ManyToOne' association");
        }
        BinderHelper.checkMappedByType(this.mappedBy, targetPropertyValue, oneToOne.getPropertyName(), this.propertyHolder, persistentClasses);
    }

    /*
     * Unable to fully structure code
     */
    private void bindTargetManyToOne(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, Property property, PersistentClass targetEntity, Property targetProperty) {
        otherSideJoin = null;
        for (Join otherSideJoinValue : targetEntity.getJoins()) {
            if (!otherSideJoinValue.containsProperty(targetProperty)) continue;
            otherSideJoin = otherSideJoinValue;
            break;
        }
        if (otherSideJoin != null) {
            mappedByJoin = this.buildJoinFromMappedBySide(persistentClasses.get(this.ownerEntity), targetProperty, otherSideJoin);
            manyToOne = this.createManyToOne(oneToOne, mappedByJoin);
            property.setValue(manyToOne);
            for (Column column : otherSideJoin.getKey().getColumns()) {
                copy = column.clone();
                copy.setValue(manyToOne);
                manyToOne.addColumn(copy);
            }
            mappedByJoin.addProperty(property);
        } else {
            this.propertyHolder.addProperty(property, this.inferredData.getAttributeMember(), this.inferredData.getDeclaringClass());
        }
        oneToOne.setReferencedPropertyName(this.mappedBy);
        if (this.mappedBy == null) ** GOTO lbl-1000
        var9_10 = targetEntity.getIdentifier();
        if (var9_10 instanceof Component) {
            compositeId = (Component)var9_10;
            ** if (!compositeId.matchesAllProperties((String[])new String[]{this.mappedBy})) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl28
        }
lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
lbl28:
        // 2 sources

        referenceToPrimaryKey = v0;
        oneToOne.setReferenceToPrimaryKey(referenceToPrimaryKey);
        propertyRef = oneToOne.getReferencedPropertyName();
        if (propertyRef != null) {
            this.buildingContext.getMetadataCollector().addUniquePropertyReference(oneToOne.getReferencedEntityName(), propertyRef);
        }
    }

    private ManyToOne createManyToOne(OneToOne oneToOne, Join mappedByJoin) {
        ManyToOne manyToOne = new ManyToOne(this.buildingContext, mappedByJoin.getTable());
        manyToOne.setNotFoundAction(this.notFoundAction);
        manyToOne.setOnDeleteAction(oneToOne.getOnDeleteAction());
        manyToOne.setFetchMode(oneToOne.getFetchMode());
        manyToOne.setLazy(oneToOne.isLazy());
        manyToOne.setReferencedEntityName(oneToOne.getReferencedEntityName());
        manyToOne.setReferencedPropertyName(this.mappedBy);
        manyToOne.setUnwrapProxy(oneToOne.isUnwrapProxy());
        manyToOne.markAsLogicalOneToOne();
        return manyToOne;
    }

    private Property targetProperty(OneToOne oneToOne, PersistentClass targetEntity) {
        try {
            Property targetProperty = BinderHelper.findPropertyByName(targetEntity, this.mappedBy);
            if (targetProperty != null) {
                return targetProperty;
            }
        }
        catch (MappingException mappingException) {
            // empty catch block
        }
        throw new AnnotationException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is 'mappedBy' a property named '" + this.mappedBy + "' which does not exist in the target entity type '" + oneToOne.getReferencedEntityName() + "'");
    }

    private void bindOwned(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, String propertyName, Property property) {
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(oneToOne, this.joinColumns, true, this.annotatedEntity, this.propertyHolder.getPersistentClass(), StringHelper.qualify(this.propertyHolder.getPath(), propertyName), this.buildingContext);
        secondPass.doSecondPass(persistentClasses);
        this.propertyHolder.addProperty(property, this.inferredData.getAttributeMember(), this.inferredData.getDeclaringClass());
    }

    private Join buildJoinFromMappedBySide(PersistentClass persistentClass, Property otherSideProperty, Join originalJoin) {
        SortableValue value;
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        join.setTable(originalJoin.getTable());
        join.setInverse(true);
        DependantValue key = new DependantValue(this.buildingContext, join.getTable(), persistentClass.getIdentifier());
        if (this.notFoundAction != null) {
            join.disableForeignKeyCreation();
        }
        join.setKey(key);
        join.setOptional(true);
        key.setOnDeleteAction(null);
        for (Column column : otherSideProperty.getValue().getColumns()) {
            Column copy = column.clone();
            copy.setValue(key);
            key.addColumn(copy);
        }
        Value value2 = otherSideProperty.getValue();
        if (value2 instanceof SortableValue && !(value = (SortableValue)((Object)value2)).isSorted()) {
            key.sortProperties();
        }
        persistentClass.addJoin(join);
        return join;
    }
}

