/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Objects;
import org.apache.kafka.server.common.OffsetAndEpoch;

public final class ValidOffsetAndEpoch {
    private final Kind kind;
    private final OffsetAndEpoch offsetAndEpoch;

    private ValidOffsetAndEpoch(Kind kind, OffsetAndEpoch offsetAndEpoch) {
        this.kind = kind;
        this.offsetAndEpoch = offsetAndEpoch;
    }

    public Kind kind() {
        return this.kind;
    }

    public OffsetAndEpoch offsetAndEpoch() {
        return this.offsetAndEpoch;
    }

    public static ValidOffsetAndEpoch diverging(OffsetAndEpoch offsetAndEpoch) {
        return new ValidOffsetAndEpoch(Kind.DIVERGING, offsetAndEpoch);
    }

    public static ValidOffsetAndEpoch snapshot(OffsetAndEpoch offsetAndEpoch) {
        return new ValidOffsetAndEpoch(Kind.SNAPSHOT, offsetAndEpoch);
    }

    public static ValidOffsetAndEpoch valid(OffsetAndEpoch offsetAndEpoch) {
        return new ValidOffsetAndEpoch(Kind.VALID, offsetAndEpoch);
    }

    public static ValidOffsetAndEpoch valid() {
        return ValidOffsetAndEpoch.valid(new OffsetAndEpoch(-1L, -1));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ValidOffsetAndEpoch that = (ValidOffsetAndEpoch)obj;
        return this.kind == that.kind && this.offsetAndEpoch.equals((Object)that.offsetAndEpoch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.offsetAndEpoch});
    }

    public String toString() {
        return String.format("ValidOffsetAndEpoch(kind=%s, offsetAndEpoch=%s)", new Object[]{this.kind, this.offsetAndEpoch});
    }

    public static enum Kind {
        DIVERGING,
        SNAPSHOT,
        VALID;

    }
}

