/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.kafka.common.utils.Utils;

public final class PropertiesUtils {
    public static void writePropertiesFile(Properties props, String path, boolean fsync) throws IOException {
        File tempFile = new File(path + ".tmp");
        try (FileOutputStream fos = new FileOutputStream(tempFile, false);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter pw = new PrintWriter(osw);){
            props.store(pw, "");
            fos.flush();
            if (fsync) {
                fos.getFD().sync();
            }
        }
        File targetFile = new File(path);
        try {
            Utils.atomicMoveWithFallback((Path)tempFile.toPath(), (Path)targetFile.toPath(), (boolean)fsync);
        }
        catch (Throwable e) {
            Utils.delete((File)tempFile);
            throw e;
        }
    }

    public static Properties readPropertiesFile(String path) throws IOException {
        Properties props = new Properties();
        try (InputStream propStream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            props.load(propStream);
        }
        return props;
    }

    static int loadRequiredIntProp(Properties props, String keyName) {
        String value = props.getProperty(keyName);
        if (value == null) {
            throw new RuntimeException("Failed to find " + keyName);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to read " + keyName + " as a base-10 number.", e);
        }
    }
}

