/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;

public class ProduceRequestResult {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final TopicPartition topicPartition;
    private final List<ProduceRequestResult> dependentResults = new ArrayList<ProduceRequestResult>();
    private volatile Long baseOffset = null;
    private volatile long logAppendTime = -1L;
    private volatile Function<Integer, RuntimeException> errorsByIndex;

    public ProduceRequestResult(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
    }

    public void set(long baseOffset, long logAppendTime, Function<Integer, RuntimeException> errorsByIndex) {
        this.baseOffset = baseOffset;
        this.logAppendTime = logAppendTime;
        this.errorsByIndex = errorsByIndex;
    }

    public void done() {
        if (this.baseOffset == null) {
            throw new IllegalStateException("The method `set` must be invoked before this method.");
        }
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependent(ProduceRequestResult dependentResult) {
        List<ProduceRequestResult> list = this.dependentResults;
        synchronized (list) {
            this.dependentResults.add(dependentResult);
        }
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitAllDependents() throws InterruptedException {
        ArrayDeque<ProduceRequestResult> toWait = new ArrayDeque<ProduceRequestResult>();
        toWait.add(this);
        while (!toWait.isEmpty()) {
            ProduceRequestResult current = (ProduceRequestResult)toWait.poll();
            current.latch.await();
            List<ProduceRequestResult> list = current.dependentResults;
            synchronized (list) {
                toWait.addAll(current.dependentResults);
            }
        }
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public boolean hasLogAppendTime() {
        return this.logAppendTime != -1L;
    }

    public long logAppendTime() {
        return this.logAppendTime;
    }

    public RuntimeException error(int batchIndex) {
        if (this.errorsByIndex == null) {
            return null;
        }
        return this.errorsByIndex.apply(batchIndex);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean completed() {
        return this.latch.getCount() == 0L;
    }
}

