/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinNativePaths;", "", "<init>", "()V", "validPropertiesNames", "", "", "kotlinNativeHome", "getKotlinNativeHome", "()Ljava/lang/String;", "defaultHomePath", "Ljava/io/File;", "homePath", "getHomePath", "()Ljava/io/File;", "util"})
@SourceDebugExtension(value={"SMAP\nKotlinNativePaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNativePaths.kt\norg/jetbrains/kotlin/utils/KotlinNativePaths\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class KotlinNativePaths {
    @NotNull
    public static final KotlinNativePaths INSTANCE = new KotlinNativePaths();
    @NotNull
    private static final List<String> validPropertiesNames;

    private KotlinNativePaths() {
    }

    private final String getKotlinNativeHome() {
        String string;
        block1: {
            for (String p0 : (Iterable)validPropertiesNames) {
                boolean bl = false;
                String string2 = System.getProperty(p0);
                if (string2 == null) continue;
                string = string2;
                break block1;
            }
            string = null;
        }
        return string;
    }

    private final File defaultHomePath() {
        File jarPath = PathUtil.getResourcePathForClass(this.getClass());
        if (!(jarPath.toPath().endsWith(Paths.get("konan/lib/kotlin-native.jar", new String[0])) || jarPath.toPath().endsWith(Paths.get("konan/lib/kotlin-native-compiler-embeddable.jar", new String[0])))) {
            boolean bl = false;
            File classesPath = Intrinsics.areEqual((Object)FilesKt.getExtension((File)jarPath), (Object)"jar") ? jarPath : jarPath.getParentFile();
            String string = StringsKt.trimIndent((String)("\n                    Cannot determine a compiler distribution directory.\n                    A path to compiler classes is not a part of a distribution: " + classesPath.getAbsolutePath() + ".\n                    Please set the konan.home system property to specify the distribution path manually.\n                "));
            throw new IllegalStateException(string.toString());
        }
        File file = jarPath.getParentFile().getParentFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return file;
    }

    @NotNull
    public final File getHomePath() {
        Object object;
        block3: {
            block2: {
                object = this.getKotlinNativeHome();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                File file = FilesKt.normalize((File)new File(it));
                object = file;
                if (file != null) break block3;
            }
            object = this.defaultHomePath();
        }
        return object;
    }

    static {
        Object[] objectArray = new String[]{"kotlin.native.home", "org.jetbrains.kotlin.native.home", "konan.home"};
        validPropertiesNames = CollectionsKt.listOf((Object[])objectArray);
    }
}

