/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import tim.prune.data.CoordFormatters;
import tim.prune.data.FractionalSeconds;

public class Coordinate {
    private static final int NUMDIGITS_DEFAULT = -1;
    private static final CoordFormatters _coordFormatters = new CoordFormatters();
    private final Cardinal _cardinal;
    private final FractionalSeconds _value;
    private final String _originalString;
    private final Format _originalFormat;
    private final double _asDouble;
    private static char _localDecimalChar = '\u0000';

    private Coordinate(Cardinal cardinal, String string, Format format, double d, FractionalSeconds fractionalSeconds) {
        this._cardinal = cardinal;
        this._originalString = string;
        this._originalFormat = format;
        this._asDouble = d;
        this._value = fractionalSeconds;
    }

    public static Coordinate parse(String string, Cardinal cardinal, Cardinal cardinal2) {
        FractionalSeconds fractionalSeconds;
        Format format;
        boolean bl;
        String string2 = string == null ? "" : string.trim();
        int n = string2.length();
        if (n == 0) {
            return null;
        }
        Cardinal cardinal3 = Coordinate.getCardinal(string2, cardinal, cardinal2);
        boolean bl2 = cardinal3 != Cardinal.NO_CARDINAL;
        long[] lArray = new long[4];
        int[] nArray = new int[4];
        boolean[] blArray = new boolean[5];
        ParseResult parseResult = Coordinate.parseString(string2, lArray, nArray, blArray);
        int n2 = parseResult.numFields;
        boolean bl3 = bl = parseResult.isNegative && cardinal3 == Cardinal.NO_CARDINAL;
        if (!bl2) {
            Cardinal cardinal4 = cardinal3 = bl ? cardinal2 : cardinal;
        }
        if (n2 == 2) {
            if (!blArray[1]) {
                format = bl2 ? Format.DEG : Format.DEG_WITHOUT_CARDINAL;
                fractionalSeconds = new FractionalSeconds(lArray[0], lArray[1], nArray[1]);
            } else {
                format = Format.DEG_MIN;
                if (lArray[1] >= 60L) {
                    return null;
                }
                fractionalSeconds = new FractionalSeconds(lArray[0], lArray[1], 0L, 0);
            }
        } else {
            if (n2 == 3 && !blArray[1] && blArray[2] && Coordinate.isJustNumber(string2)) {
                double d = Math.abs(Double.parseDouble(string2));
                return new Coordinate(cardinal3, string2, Format.DEG, d, null);
            }
            if (n2 == 3 && !blArray[2]) {
                if (lArray[1] >= 60L) {
                    return null;
                }
                format = Format.DEG_MIN;
                fractionalSeconds = new FractionalSeconds(lArray[0], lArray[1], lArray[2], nArray[2]);
            } else if (n2 == 4 || n2 == 3) {
                if (lArray[1] >= 60L || lArray[2] >= 60L) {
                    return null;
                }
                format = Format.DEG_MIN_SEC;
                fractionalSeconds = new FractionalSeconds(lArray[0], lArray[1], lArray[2], lArray[3], nArray[3]);
            } else {
                return null;
            }
        }
        double d = fractionalSeconds.getDouble();
        if (cardinal3 == cardinal2) {
            d = -d;
        }
        return new Coordinate(cardinal3, string2, format, d, fractionalSeconds);
    }

    public Coordinate wrapTo180Degrees() {
        if (this._value == null) {
            if (this._asDouble >= -180.0 && this._asDouble <= 180.0) {
                return this;
            }
            double d = (this._asDouble + 180.0) % 360.0 - 180.0;
            boolean bl = this._asDouble > 0.0;
            boolean bl2 = d > 0.0;
            Cardinal cardinal = bl == bl2 ? this._cardinal : this._cardinal.getOpposite();
            return new Coordinate(d, cardinal);
        }
        if (this._value.isWithinOneEightyDegrees()) {
            return this;
        }
        FractionalSeconds fractionalSeconds = this._value.wrapToThreeSixtyDegrees();
        if (fractionalSeconds.isWithinOneEightyDegrees()) {
            return new Coordinate(this._cardinal, this._originalString, this._originalFormat, fractionalSeconds.getDouble(), fractionalSeconds);
        }
        boolean bl = this._asDouble > 0.0;
        fractionalSeconds = fractionalSeconds.invert();
        double d = bl ? -fractionalSeconds.getDouble() : fractionalSeconds.getDouble();
        return new Coordinate(this._cardinal.getOpposite(), this._originalString, this._originalFormat, d, fractionalSeconds);
    }

    private static ParseResult parseString(String string, long[] lArray, int[] nArray, boolean[] blArray) {
        int n = 0;
        boolean bl = false;
        try {
            int n2 = string.length();
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c >= '0' && c <= '9') {
                    if (!bl2) {
                        bl2 = true;
                        nArray[++n - 1] = 0;
                    }
                    if (nArray[n - 1] < 18) {
                        lArray[n - 1] = lArray[n - 1] * 10L + (long)(c - 48);
                        int n4 = n - 1;
                        nArray[n4] = nArray[n4] + 1;
                    }
                } else if (c == '-' && n == 0 && !bl2) {
                    bl = true;
                } else {
                    bl2 = false;
                    if (c != ',' && c != '.') {
                        blArray[n] = true;
                    }
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return new ParseResult(n, bl);
    }

    static Cardinal getCardinal(String string, Cardinal cardinal, Cardinal cardinal2) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.equals("")) {
            return Cardinal.NO_CARDINAL;
        }
        char c = string2.charAt(0);
        char c2 = string2.charAt(string2.length() - 1);
        Cardinal cardinal3 = Coordinate.getCardinal(c, cardinal, cardinal2);
        if (cardinal3 == Cardinal.NO_CARDINAL) {
            cardinal3 = Coordinate.getCardinal(c2, cardinal, cardinal2);
        }
        return cardinal3;
    }

    static Cardinal getCardinal(char c, Cardinal cardinal, Cardinal cardinal2) {
        String string = "" + Character.toUpperCase(c);
        if (string.equals(cardinal.printable)) {
            return cardinal;
        }
        if (string.equals(cardinal2.printable)) {
            return cardinal2;
        }
        return Cardinal.NO_CARDINAL;
    }

    Coordinate(double d, Cardinal cardinal) {
        this._asDouble = d;
        this._value = null;
        this._cardinal = cardinal;
        NumberFormat numberFormat = _coordFormatters.getLocalFormatter(6);
        this._originalString = numberFormat.format(this._asDouble);
        this._originalFormat = Format.DEG_WITHOUT_CARDINAL;
    }

    public double getDouble() {
        return this._asDouble;
    }

    public boolean equals(Object object) {
        return object instanceof Coordinate && this._asDouble == ((Coordinate)object)._asDouble;
    }

    public String output(Format format) {
        return this.output(format, -1);
    }

    public String output(Format format, int n) {
        if (format == Format.NONE) {
            return this._originalString;
        }
        if (format == this._originalFormat && n == -1) {
            return this._originalString;
        }
        if (format == Format.DECIMAL_FORCE_POINT && this._originalFormat == Format.DEG_WITHOUT_CARDINAL && n == -1 && this._originalString.indexOf(46) > 0 && this._originalString.indexOf(44) < 0) {
            return this._originalString;
        }
        int n2 = n == -1 ? Coordinate.getNumDigits(format) : n;
        FractionalSeconds fractionalSeconds = this._value != null ? this._value : FractionalSeconds.fromDouble(this._asDouble, n2);
        switch (format) {
            case DEG_MIN_SEC: {
                fractionalSeconds = fractionalSeconds.roundToSeconds(n2);
                return String.valueOf(this._cardinal.printable) + Coordinate.threeDigitString(fractionalSeconds.getWholeDegrees()) + '\u00b0' + Coordinate.twoDigitString(fractionalSeconds.getWholeMinutes()) + '\'' + Coordinate.twoDigitString(fractionalSeconds.getWholeSeconds()) + Coordinate.getLocalDecimalChar() + fractionalSeconds.getFractionSeconds() + '\"';
            }
            case DEG_MIN: {
                fractionalSeconds = fractionalSeconds.roundToMinutes(n2);
                return String.valueOf(this._cardinal.printable) + Coordinate.threeDigitString(fractionalSeconds.getWholeDegrees()) + '\u00b0' + Coordinate.twoDigitString(fractionalSeconds.getWholeMinutes()) + Coordinate.getLocalDecimalChar() + fractionalSeconds.getFractionMinutes() + '\'';
            }
            case DEG: 
            case DEG_WITHOUT_CARDINAL: 
            case DECIMAL_FORCE_POINT: {
                NumberFormat numberFormat;
                NumberFormat numberFormat2 = numberFormat = format == Format.DECIMAL_FORCE_POINT ? _coordFormatters.getUkFormatter(n2) : _coordFormatters.getLocalFormatter(n2);
                if (format == Format.DEG) {
                    return String.valueOf(this._cardinal.printable) + ' ' + numberFormat.format(Math.abs(this._asDouble));
                }
                return numberFormat.format(this._asDouble);
            }
            case DEG_MIN_SEC_WITH_SPACES: {
                fractionalSeconds = fractionalSeconds.roundToSeconds(n2);
                return fractionalSeconds.getWholeDegrees() + " " + fractionalSeconds.getWholeMinutes() + " " + fractionalSeconds.getWholeSeconds() + '.' + fractionalSeconds.getFractionSeconds();
            }
            case JUST_CARDINAL: {
                return this._cardinal.printable;
            }
        }
        return this._originalString;
    }

    private static char getLocalDecimalChar() {
        if (_localDecimalChar == '\u0000') {
            NumberFormat numberFormat = _coordFormatters.getLocalFormatter(3);
            _localDecimalChar = numberFormat instanceof DecimalFormat ? ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator() : (char)46;
        }
        return _localDecimalChar;
    }

    private static int getNumDigits(Format format) {
        switch (format) {
            case DEG_MIN_SEC: 
            case DEG_MIN_SEC_WITH_SPACES: {
                return 3;
            }
            case DEG_MIN: {
                return 6;
            }
            default: {
                return 8;
            }
            case JUST_CARDINAL: 
        }
        return 0;
    }

    private static String twoDigitString(int n) {
        if (n <= 0) {
            return "00";
        }
        if (n < 10) {
            return "0" + n;
        }
        if (n < 100) {
            return "" + n;
        }
        return "" + n % 100;
    }

    private static String threeDigitString(int n) {
        if (n <= 0) {
            return "000";
        }
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return "" + n % 1000;
    }

    public static Coordinate interpolate(Coordinate coordinate, Coordinate coordinate2, double d, Cardinal cardinal, Cardinal cardinal2) {
        double d2;
        double d3;
        double d4 = coordinate.getDouble();
        return new Coordinate(d3, (d3 = d4 + ((d2 = coordinate2.getDouble()) - d4) * d) >= 0.0 ? cardinal : cardinal2);
    }

    private static boolean isJustNumber(String string) {
        boolean bl = false;
        try {
            double d = Double.parseDouble(string);
            bl = d >= -180.0 && d <= 360.0;
        }
        catch (NumberFormatException numberFormatException) {}
        return bl;
    }

    public String toString() {
        return this._originalString;
    }

    public static Format getCoordinateFormatForDisplay(String string) {
        if (Format.DEG.toString().equals(string)) {
            return Format.DEG;
        }
        if (Format.DEG_MIN.toString().equals(string)) {
            return Format.DEG_MIN;
        }
        if (Format.DEG_MIN_SEC.toString().equals(string)) {
            return Format.DEG_MIN_SEC;
        }
        return Format.NONE;
    }

    public static enum Cardinal {
        NORTH("N"),
        EAST("E"),
        SOUTH("S"),
        WEST("W"),
        NO_CARDINAL("");

        public final String printable;

        private Cardinal(String string2) {
            this.printable = string2;
        }

        public Cardinal getOpposite() {
            switch (this) {
                case NORTH: {
                    return SOUTH;
                }
                case SOUTH: {
                    return NORTH;
                }
                case EAST: {
                    return WEST;
                }
                case WEST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Cannot find opposite cardinal of " + (Object)((Object)this));
        }
    }

    public static enum Format {
        DEG_MIN_SEC,
        DEG_MIN,
        DEG,
        DEG_WITHOUT_CARDINAL,
        DEG_MIN_SEC_WITH_SPACES,
        JUST_CARDINAL,
        DECIMAL_FORCE_POINT,
        NONE;

    }

    private static class ParseResult {
        public final int numFields;
        public final boolean isNegative;

        ParseResult(int n, boolean bl) {
            this.numFields = n;
            this.isNegative = bl;
        }
    }
}

