/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import java.util.List;
import tim.prune.cmd.Command;
import tim.prune.cmd.PointReference;
import tim.prune.data.TrackInfo;

public class RearrangePointsCmd
extends Command {
    private final List<Integer> _indexes;

    public RearrangePointsCmd(List<Integer> list) {
        this(null, list);
    }

    protected RearrangePointsCmd(RearrangePointsCmd rearrangePointsCmd, List<Integer> list) {
        super(rearrangePointsCmd);
        this._indexes = list;
    }

    public static RearrangePointsCmd from(List<PointReference> list) {
        return new RearrangePointsCmd(RearrangePointsCmd.convertReferencesToIntegers(list));
    }

    @Override
    public int getUpdateFlags() {
        return 2;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this.getInverse() == null) {
            return false;
        }
        return trackInfo.getTrack().rearrangePoints(this._indexes);
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        try {
            return new RearrangePointsCmd(this, this.makeOppositeIndexes());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            return null;
        }
    }

    private List<Integer> makeOppositeIndexes() {
        Integer[] integerArray = new Integer[this._indexes.size()];
        int n = 0;
        while (n < this._indexes.size()) {
            integerArray[this._indexes.get((int)n).intValue()] = n;
            ++n;
        }
        return List.of(integerArray);
    }

    private static List<Integer> convertReferencesToIntegers(List<PointReference> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (PointReference pointReference : list) {
            arrayList.add(pointReference.getIndex());
        }
        return arrayList;
    }
}

