---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Contentful delivery API token'
---

## Description

The response body contains content that matches the pattern of a Contentful delivery API token was identified. The Contentful Delivery API (CDA) is a read-only API for delivering content from Contentful to apps, websites and other media. Content is delivered as JSON data, and images, videos and other media as files. A malicious actor with access to this token has read only access to entries.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the delivery API token:

- Sign in and visit <https://app.contentful.com/>
- Select the gear icon in the upper-right corner, and then select "API Keys"
- Find the API key that was detected, and select the name in the table of API keys
- Select "Delete" in the upper-right corner
- When prompted, select "Delete" Note this also deletes the preview API token. Generating a new set of API keys is required.

For more information, please see the developer [documentation on authentication](https://www.contentful.com/developers/docs/references/authentication/#the-content-delivery-and-preview-api).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.23 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
