---
stage: AI-powered
group: Editor Extensions
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Connect and use GitLab Duo in Visual Studio.
title: GitLab extension for Visual Studio
---

The [GitLab extension](https://marketplace.visualstudio.com/items?itemName=GitLab.GitLabExtensionForVisualStudio)
integrates GitLab with Visual Studio for Windows. GitLab for Visual Studio supports
[GitLab Duo Code Suggestions](../../user/project/repository/code_suggestions/_index.md)
and [GitLab Duo Chat](../../user/gitlab_duo_chat/_index.md#use-gitlab-duo-chat-in-visual-studio-for-windows).

To install and configure the extension, see [Install and set up](setup.md).

Report any issues, bugs, or feature requests in the
[`gitlab-visual-studio-extension` issue tracker](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/issues).

## Update the extension

To update your extension to the latest version:

1. In Visual Studio, go to **Extensions** > **Manage Extensions...**.
1. Select the **Updates** tab.
1. Search for **GitLab** published by **GitLab (`gitlab.com`)**.
1. Select **Update** on the extension to update to the latest version.

## Related topics

- [Open issues for this plugin](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/issues/)
- [View source code](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension)
- [GitLab Language Server documentation](../language_server/_index.md)

## Troubleshooting

For troubleshooting information about the extension, see
[troubleshooting](visual_studio_troubleshooting.md).
