/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import ghidra.features.codecompare.graphanalysis.DataVertex;

public class DataNGram
implements Comparable<DataNGram> {
    int weight;
    int depth;
    int hash;
    DataVertex root;

    public DataNGram(DataVertex node, int weight, int depth, int hash) {
        this.depth = depth;
        this.weight = weight;
        this.hash = hash;
        this.root = node;
    }

    @Override
    public int compareTo(DataNGram other) {
        if (this.weight > other.weight) {
            return -1;
        }
        if (this.weight < other.weight) {
            return 1;
        }
        if (this.depth > other.depth) {
            return -1;
        }
        if (this.depth < other.depth) {
            return 1;
        }
        if (this.hash > other.hash) {
            return -1;
        }
        if (this.hash < other.hash) {
            return 1;
        }
        if (this.root.uid > other.root.uid) {
            return -1;
        }
        if (this.root.uid < other.root.uid) {
            return 1;
        }
        return other.root.graph.side.compareTo(this.root.graph.side);
    }

    public boolean equalHash(DataNGram other) {
        if (other == null) {
            return false;
        }
        return this.weight == other.weight && this.depth == other.depth && this.hash == other.hash;
    }

    public boolean graphsDiffer(DataNGram other) {
        return this.root.graph != other.root.graph;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("d=").append(this.depth);
        buffer.append(" h=").append(this.hash);
        buffer.append(" w=").append(this.weight);
        buffer.append(" vert=").append(this.root.uid);
        return buffer.toString();
    }
}

