/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import java.awt.Color;
import java.util.Comparator;
import java.util.function.Function;

public enum ColorSorter implements Comparator<Color>
{
    RGB("Red, Green, Blue", c -> c.getRed(), c -> c.getGreen(), c -> c.getBlue()),
    RBG("Red, Blue, Green", c -> c.getRed(), c -> c.getBlue(), c -> c.getGreen()),
    GRB("Green, Red, Blue", c -> c.getGreen(), c -> c.getRed(), c -> c.getBlue()),
    GBR("Green, Blue, Red", c -> c.getGreen(), c -> c.getBlue(), c -> c.getRed()),
    BRG("Blue, Red, Green", c -> c.getBlue(), c -> c.getRed(), c -> c.getGreen()),
    BGR("Blue, Green, Red", c -> c.getBlue(), c -> c.getGreen(), c -> c.getRed());

    private String name;
    private ColorFunction colorFunction1;
    private ColorFunction colorFunction2;
    private ColorFunction colorFunction3;

    private ColorSorter(String name, ColorFunction f1, ColorFunction f2, ColorFunction f3) {
        this.name = name;
        this.colorFunction1 = f1;
        this.colorFunction2 = f2;
        this.colorFunction3 = f3;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compare(Color o1, Color o2) {
        int v2;
        int v1 = (Integer)this.colorFunction1.apply(o1);
        int result = v1 - (v2 = ((Integer)this.colorFunction1.apply(o2)).intValue());
        if (result == 0 && (result = (v1 = ((Integer)this.colorFunction2.apply(o1)).intValue()) - (v2 = ((Integer)this.colorFunction2.apply(o2)).intValue())) == 0) {
            v1 = (Integer)this.colorFunction3.apply(o1);
            v2 = (Integer)this.colorFunction3.apply(o2);
            result = v1 - v2;
        }
        return result;
    }

    static interface ColorFunction
    extends Function<Color, Integer> {
    }
}

