/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import ghidra.file.formats.cart.CartInvalidARC4KeyException;
import ghidra.file.formats.cart.CartV1StreamDecryptor;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class CartV1Decryptor {
    private byte[] arc4Key;

    public static byte[] decrypt(byte[] arc4Key, byte[] encryptedBuffer) throws CartInvalidARC4KeyException, CancelledException, IOException {
        return CartV1Decryptor.decrypt(arc4Key, encryptedBuffer, null);
    }

    public static byte[] decrypt(byte[] arc4Key, byte[] encryptedBuffer, TaskMonitor monitor) throws CartInvalidARC4KeyException, CancelledException, IOException {
        CartV1Decryptor decryptor = new CartV1Decryptor(arc4Key);
        return decryptor.decrypt(encryptedBuffer, monitor);
    }

    public static String decryptToString(byte[] arc4Key, byte[] encryptedBuffer) throws CartInvalidARC4KeyException, IOException {
        return CartV1Decryptor.decryptToString(arc4Key, encryptedBuffer, null);
    }

    public static String decryptToString(byte[] arc4Key, byte[] encryptedBuffer, TaskMonitor monitor) throws CartInvalidARC4KeyException, IOException {
        CartV1Decryptor decryptor = new CartV1Decryptor(arc4Key);
        return decryptor.decryptToString(encryptedBuffer, monitor);
    }

    public CartV1Decryptor(byte[] arc4Key) throws CartInvalidARC4KeyException {
        this.setKey(arc4Key);
    }

    public void throwIfInvalid() throws CartInvalidARC4KeyException {
        this.throwIfInvalid(this.arc4Key);
    }

    public void throwIfInvalid(byte[] proposedARC4Key) throws CartInvalidARC4KeyException {
        if (proposedARC4Key == null) {
            throw new CartInvalidARC4KeyException("Invalid null CaRT key.");
        }
        if (proposedARC4Key.length != 16) {
            throw new CartInvalidARC4KeyException("Invalid CaRT key length.");
        }
    }

    public void setKey(byte[] arc4Key) throws CartInvalidARC4KeyException {
        this.throwIfInvalid(arc4Key);
        this.arc4Key = arc4Key;
    }

    public byte[] decrypt(byte[] encryptedBuffer) throws CartInvalidARC4KeyException, IOException {
        return this.decrypt(encryptedBuffer, null);
    }

    public byte[] decrypt(byte[] encryptedBuffer, TaskMonitor monitor) throws CartInvalidARC4KeyException, IOException {
        try {
            CartV1StreamDecryptor decryptor = new CartV1StreamDecryptor(new ByteArrayInputStream(encryptedBuffer), this.arc4Key);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            FSUtilities.streamCopy((InputStream)decryptor, (OutputStream)buffer, (TaskMonitor)TaskMonitor.dummyIfNull((TaskMonitor)monitor));
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public String decryptToString(byte[] encryptedBuffer) throws CartInvalidARC4KeyException, IOException {
        return this.decryptToString(encryptedBuffer, null);
    }

    public String decryptToString(byte[] encryptedBuffer, TaskMonitor monitor) throws CartInvalidARC4KeyException, IOException {
        byte[] decryptedBuffer = this.decrypt(encryptedBuffer, monitor);
        if (decryptedBuffer != null) {
            return new String(decryptedBuffer, StandardCharsets.UTF_8);
        }
        return null;
    }

    protected byte[] getARC4Key() {
        return this.arc4Key;
    }
}

