/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.isf;

import db.DBHandle;
import generic.test.AbstractGTest;
import ghidra.GhidraTestApplicationLayout;
import ghidra.base.project.GhidraProject;
import ghidra.dbg.isf.IsfClientHandler;
import ghidra.dbg.isf.IsfConnectionHandler;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.ProjectData;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import utility.application.ApplicationLayout;

public class IsfServer
extends Thread {
    private ServerSocket server;
    private boolean running = false;
    private GhidraProject project;
    private int port = 54321;
    private IsfClientHandler handler;
    private Map<String, DataTypeManager> managers = new HashMap<String, DataTypeManager>();

    public IsfServer(GhidraProject project, int port) {
        this.project = project;
        this.port = port;
        this.handler = new IsfClientHandler(this);
    }

    public void startServer() {
        try {
            this.server = new ServerSocket(this.port);
            this.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start server");
        }
    }

    public void stopServer() {
        this.running = false;
        this.interrupt();
        for (DataTypeManager m : this.managers.values()) {
            m.close();
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Msg.info((Object)this, (Object)"Listening for a connection...");
                Socket socket = this.server.accept();
                socket.setTcpNoDelay(true);
                Msg.info((Object)this, (Object)"Connected - starting handler...");
                IsfConnectionHandler connectionHandler = new IsfConnectionHandler(socket, this.handler);
                connectionHandler.start();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTypeManager getDataTypeManager(String ns) {
        Map<String, DataTypeManager> map = this.managers;
        synchronized (map) {
            if (this.managers.containsKey(ns)) {
                return this.managers.get(ns);
            }
            try {
                DataTypeManager dtm = ns.endsWith(".gdt") ? this.openAsArchive(ns) : (ns.endsWith(".gzf") ? this.openAsDatabase(ns) : this.openAsDomainFile(ns));
                this.managers.put(ns, dtm);
                return dtm;
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)(ns + " undefined namespace (should be .gdt, .gzf, or domain file)"));
                return null;
            }
        }
    }

    private DataTypeManager openAsDomainFile(String ns) throws Exception {
        ProjectData projectData = this.project.getProjectData();
        DomainFile df = projectData.getFile(ns);
        Program program = (Program)df.getDomainObject((Object)this, false, false, TaskMonitor.DUMMY);
        return program.getDataTypeManager();
    }

    private DataTypeManager openAsArchive(String ns) throws Exception {
        File gdt = new File(ns);
        return FileDataTypeManager.openFileArchive((File)gdt, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTypeManager openAsDatabase(String ns) throws Exception {
        File gzf = new File(ns);
        TaskMonitor dummy = TaskMonitor.DUMMY;
        PackedDatabase db = PackedDatabase.getPackedDatabase((File)gzf, (TaskMonitor)dummy);
        ProgramDB p = null;
        try (DBHandle dbh = db.openForUpdate(dummy);){
            p = new ProgramDB(dbh, OpenMode.UPDATE, dummy, (Object)this);
        }
        if (!(p = new ProgramDB(dbh = db.openForUpdate(dummy), OpenMode.UPGRADE, dummy, (Object)this)).isChanged()) {
            throw new RuntimeException(String.valueOf(p) + " uses an older version and was not upgraded.");
        }
        return p.getListing().getDataTypeManager();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        GhidraTestApplicationLayout layout = new GhidraTestApplicationLayout(new File(AbstractGTest.getTestDirectoryPath()));
        HeadlessGhidraApplicationConfiguration config = new HeadlessGhidraApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)config);
        IsfServer server = new IsfServer(null, 54321);
        server.startServer();
    }
}

