/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.search;

import generic.json.Json;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Function;

public class TextMatch {
    private Function function;
    private AddressSet addresses;
    private LocationReferenceContext context;
    private int lineNumber;
    private String searchText;
    private boolean isMultiLine;

    TextMatch(Function function, AddressSet addresses, int lineNumber, String searchText, LocationReferenceContext context, boolean isMultiLine) {
        this.function = function;
        this.addresses = addresses;
        this.lineNumber = lineNumber;
        this.searchText = searchText;
        this.context = context;
        this.isMultiLine = isMultiLine;
    }

    public Function getFunction() {
        return this.function;
    }

    public LocationReferenceContext getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Address getAddress() {
        if (this.addresses.isEmpty()) {
            return this.function.getEntryPoint();
        }
        return this.addresses.getFirstRange().getMinAddress();
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String toString() {
        return Json.toString((Object)this, (String[])new String[]{"function", "context", "searchText"});
    }
}

