/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBigInt;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.json.JsonParser;
import org.mozilla.javascript.xml.XMLObject;

public final class NativeJSON
extends ScriptableObject {
    private static final long serialVersionUID = -4567599697595654984L;
    private static final String JSON_TAG = "JSON";
    private static final int MAX_STRINGIFY_GAP_LENGTH = 10;

    static void init(Scriptable scriptable, boolean bl) {
        NativeJSON nativeJSON = new NativeJSON();
        nativeJSON.setPrototype(NativeJSON.getObjectPrototype(scriptable));
        nativeJSON.setParentScope(scriptable);
        nativeJSON.defineProperty(scriptable, "parse", 2, NativeJSON::parse, 2, 3);
        nativeJSON.defineProperty(scriptable, "stringify", 3, NativeJSON::stringify, 2, 3);
        nativeJSON.defineProperty("toSource", (Object)JSON_TAG, 7);
        nativeJSON.defineProperty(SymbolKey.TO_STRING_TAG, (Object)JSON_TAG, 3);
        ScriptableObject.defineProperty(scriptable, JSON_TAG, nativeJSON, 2);
        if (bl) {
            nativeJSON.sealObject();
        }
    }

    private NativeJSON() {
    }

    @Override
    public String getClassName() {
        return JSON_TAG;
    }

    private static Object parse(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        Object object = null;
        if (objectArray.length > 1) {
            object = objectArray[1];
        }
        if (object instanceof Callable) {
            return NativeJSON.parse(context, scriptable, string, (Callable)object);
        }
        return NativeJSON.parse(context, scriptable, string);
    }

    private static Object stringify(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object = Undefined.instance;
        Object object2 = null;
        Object object3 = null;
        if (objectArray.length > 0) {
            object = objectArray[0];
            if (objectArray.length > 1) {
                object2 = objectArray[1];
                if (objectArray.length > 2) {
                    object3 = objectArray[2];
                }
            }
        }
        return NativeJSON.stringify(context, scriptable, object, object2, object3);
    }

    private static Object parse(Context context, Scriptable scriptable, String string) {
        try {
            return new JsonParser(context, scriptable).parseValue(string);
        }
        catch (JsonParser.ParseException parseException) {
            throw ScriptRuntime.constructError("SyntaxError", parseException.getMessage());
        }
    }

    public static Object parse(Context context, Scriptable scriptable, String string, Callable callable) {
        Object object = NativeJSON.parse(context, scriptable, string);
        Scriptable scriptable2 = context.newObject(scriptable);
        scriptable2.put("", scriptable2, object);
        return NativeJSON.walk(context, scriptable, callable, scriptable2, "");
    }

    private static Object walk(Context context, Scriptable scriptable, Callable callable, Scriptable scriptable2, Object object) {
        Object object2;
        block10: {
            object2 = object instanceof Number ? scriptable2.get(((Number)object).intValue(), scriptable2) : scriptable2.get((String)object, scriptable2);
            if (!(object2 instanceof Scriptable)) break block10;
            Scriptable scriptable3 = (Scriptable)object2;
            if (scriptable3 instanceof NativeArray) {
                long l = ((NativeArray)scriptable3).getLength();
                for (long i = 0L; i < l; ++i) {
                    Object object3;
                    if (i > Integer.MAX_VALUE) {
                        String string = Long.toString(i);
                        object3 = NativeJSON.walk(context, scriptable, callable, scriptable3, string);
                        if (object3 == Undefined.instance) {
                            scriptable3.delete(string);
                            continue;
                        }
                        scriptable3.put(string, scriptable3, object3);
                        continue;
                    }
                    int n = (int)i;
                    object3 = NativeJSON.walk(context, scriptable, callable, scriptable3, n);
                    if (object3 == Undefined.instance) {
                        scriptable3.delete(n);
                        continue;
                    }
                    scriptable3.put(n, scriptable3, object3);
                }
            } else {
                Object[] objectArray;
                for (Object object4 : objectArray = scriptable3.getIds()) {
                    Object object5 = NativeJSON.walk(context, scriptable, callable, scriptable3, object4);
                    if (object5 == Undefined.instance) {
                        if (object4 instanceof Number) {
                            scriptable3.delete(((Number)object4).intValue());
                            continue;
                        }
                        scriptable3.delete((String)object4);
                        continue;
                    }
                    if (object4 instanceof Number) {
                        scriptable3.put(((Number)object4).intValue(), scriptable3, object5);
                        continue;
                    }
                    scriptable3.put((String)object4, scriptable3, object5);
                }
            }
        }
        return callable.call(context, scriptable, scriptable2, new Object[]{object, object2});
    }

    private static String repeat(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static Object stringify(Context context, Scriptable scriptable, Object object, Object object2, Object object3) {
        IdScriptableObject idScriptableObject;
        String string = "";
        String string2 = "";
        Object[] objectArray = null;
        Callable callable = null;
        if (object2 instanceof Callable) {
            callable = (Callable)object2;
        } else if (object2 instanceof NativeArray) {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            idScriptableObject = (NativeArray)object2;
            for (int n : ((NativeArray)idScriptableObject).getIndexIds()) {
                Object object4 = ((NativeArray)idScriptableObject).get(n, (Scriptable)idScriptableObject);
                if (object4 instanceof String) {
                    linkedHashSet.add(object4);
                    continue;
                }
                if (!(object4 instanceof Number) && !(object4 instanceof NativeString) && !(object4 instanceof NativeNumber)) continue;
                linkedHashSet.add(ScriptRuntime.toString(object4));
            }
            objectArray = new Object[linkedHashSet.size()];
            int n = 0;
            for (Object object4 : linkedHashSet) {
                ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object4);
                objectArray[n++] = stringIdOrIndex.stringId == null ? Integer.valueOf(stringIdOrIndex.index) : stringIdOrIndex.stringId;
            }
        }
        if (object3 instanceof NativeNumber) {
            object3 = ScriptRuntime.toNumber(object3);
        } else if (object3 instanceof NativeString) {
            object3 = ScriptRuntime.toString(object3);
        }
        if (object3 instanceof Number) {
            int n = (int)ScriptRuntime.toInteger(object3);
            string2 = (n = Math.min(10, n)) > 0 ? NativeJSON.repeat(' ', n) : "";
        } else if (object3 instanceof String && (string2 = (String)object3).length() > 10) {
            string2 = string2.substring(0, 10);
        }
        StringifyState stringifyState = new StringifyState(context, scriptable, string, string2, callable, objectArray);
        idScriptableObject = new NativeObject();
        idScriptableObject.setParentScope(scriptable);
        idScriptableObject.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        idScriptableObject.defineProperty("", object, 0);
        return NativeJSON.str("", idScriptableObject, stringifyState);
    }

    private static Object str(Object object, Scriptable scriptable, StringifyState stringifyState) {
        Object object2;
        Object object3;
        Object object4 = null;
        Object object5 = null;
        String string = null;
        int n = 0;
        if (object instanceof String) {
            string = (String)object;
            object4 = NativeJSON.getProperty(scriptable, string);
        } else {
            n = ((Number)object).intValue();
            object4 = NativeJSON.getProperty(scriptable, n);
        }
        if (object4 instanceof Scriptable && NativeJSON.hasProperty((Scriptable)object4, "toJSON")) {
            object3 = NativeJSON.getProperty((Scriptable)object4, "toJSON");
            if (object3 instanceof Callable) {
                object4 = NativeJSON.callMethod(stringifyState.cx, (Scriptable)object4, "toJSON", new Object[]{string == null ? Integer.toString(n) : string});
            }
        } else if (object4 instanceof BigInteger && NativeJSON.hasProperty((Scriptable)(object3 = ScriptRuntime.toObject(stringifyState.cx, stringifyState.scope, object4)), "toJSON") && (object2 = NativeJSON.getProperty((Scriptable)object3, "toJSON")) instanceof Callable) {
            object4 = NativeJSON.callMethod(stringifyState.cx, (Scriptable)object3, "toJSON", new Object[]{string == null ? Integer.toString(n) : string});
        }
        if (stringifyState.replacer != null) {
            object4 = stringifyState.replacer.call(stringifyState.cx, stringifyState.scope, scriptable, new Object[]{object, object4});
        }
        if (ScriptRuntime.isSymbol(object4)) {
            return Undefined.instance;
        }
        if (object4 instanceof NativeNumber) {
            object4 = ScriptRuntime.toNumber(object4);
        } else if (object4 instanceof NativeString) {
            object4 = ScriptRuntime.toString(object4);
        } else if (object4 instanceof NativeBoolean) {
            object4 = ((NativeBoolean)object4).getDefaultValue(ScriptRuntime.BooleanClass);
        } else if (stringifyState.cx.getLanguageVersion() >= 200 && object4 instanceof NativeBigInt) {
            object4 = ((NativeBigInt)object4).getDefaultValue(ScriptRuntime.BigIntegerClass);
        } else if (object4 instanceof NativeJavaObject) {
            object5 = ((NativeJavaObject)object4).unwrap();
            if (!(object5 instanceof Map || object5 instanceof Collection || object5.getClass().isArray())) {
                object4 = object5;
            } else {
                object5 = null;
            }
        } else if (object4 instanceof XMLObject) {
            object4 = object4.toString();
        }
        if (object4 == null) {
            return "null";
        }
        if (object4.equals(Boolean.TRUE)) {
            return "true";
        }
        if (object4.equals(Boolean.FALSE)) {
            return "false";
        }
        if (object4 instanceof CharSequence) {
            return NativeJSON.quote(object4.toString());
        }
        if (object4 instanceof Number) {
            if (object4 instanceof BigInteger) {
                throw ScriptRuntime.typeErrorById("msg.json.cant.serialize", "BigInt");
            }
            double d = ((Number)object4).doubleValue();
            if (!Double.isNaN(d) && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                return ScriptRuntime.toString(object4);
            }
            return "null";
        }
        if (object5 != null) {
            return NativeJSON.javaToJSON(object4, stringifyState);
        }
        if (object4 instanceof Scriptable && !(object4 instanceof Callable)) {
            if (NativeJSON.isObjectArrayLike(object4)) {
                return NativeJSON.ja((Scriptable)object4, stringifyState);
            }
            return NativeJSON.jo((Scriptable)object4, stringifyState);
        }
        return Undefined.instance;
    }

    private static String join(Collection<Object> collection, String string) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Iterator<Object> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(iterator.next().toString());
        while (iterator.hasNext()) {
            stringBuilder.append(string).append(iterator.next());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String jo(Scriptable scriptable, StringifyState stringifyState) {
        void var7_12;
        Object[] objectArray;
        Object object2;
        Object object3 = scriptable;
        Object object4 = null;
        if (scriptable instanceof Wrapper) {
            object3 = object4 = ((Wrapper)((Object)scriptable)).unwrap();
        }
        if (stringifyState.stack.search(object3) != -1) {
            throw ScriptRuntime.typeErrorById("msg.cyclic.value", object3.getClass().getName());
        }
        stringifyState.stack.push(object3);
        if (object4 instanceof Map) {
            object2 = (Map)object4;
            objectArray = stringifyState.cx.newObject(stringifyState.scope);
            for (Map.Entry object5 : object2.entrySet()) {
                int n;
                Object object;
                if (object5.getKey() instanceof Symbol) continue;
                Object object6 = Context.javaToJS(object5.getValue(), stringifyState.scope, stringifyState.cx);
                if (object5.getKey() instanceof String) {
                    object = (String)object5.getKey();
                    n = 5;
                } else {
                    object = object5.getKey().toString();
                    n = 0;
                }
                try {
                    ScriptableObject.defineProperty((Scriptable)objectArray, (String)object, object6, n);
                }
                catch (EcmaError ecmaError) {}
            }
            scriptable = objectArray;
        }
        object2 = stringifyState.indent;
        stringifyState.indent = stringifyState.indent + stringifyState.gap;
        objectArray = null;
        objectArray = stringifyState.propertyList != null ? stringifyState.propertyList : scriptable.getIds();
        LinkedList linkedList = new LinkedList();
        for (Object object : objectArray) {
            Object object7 = NativeJSON.str(object, scriptable, stringifyState);
            if (object7 == Undefined.instance) continue;
            String string = NativeJSON.quote(object.toString()) + ":";
            if (stringifyState.gap.length() > 0) {
                string = string + " ";
            }
            string = string + object7;
            linkedList.add(string);
        }
        if (linkedList.isEmpty()) {
            String string = "{}";
        } else if (stringifyState.gap.length() == 0) {
            String string = '{' + NativeJSON.join(linkedList, ",") + '}';
        } else {
            String string = ",\n" + stringifyState.indent;
            String string2 = NativeJSON.join(linkedList, string);
            String string3 = "{\n" + stringifyState.indent + string2 + '\n' + (String)object2 + '}';
        }
        stringifyState.stack.pop();
        stringifyState.indent = object2;
        return var7_12;
    }

    private static String ja(Scriptable scriptable, StringifyState stringifyState) {
        String string;
        Object object4;
        Object object2 = scriptable;
        Object object3 = null;
        if (scriptable instanceof Wrapper) {
            object2 = object3 = ((Wrapper)((Object)scriptable)).unwrap();
        }
        if (stringifyState.stack.search(object2) != -1) {
            throw ScriptRuntime.typeErrorById("msg.cyclic.value", object2.getClass().getName());
        }
        stringifyState.stack.push(object2);
        String string2 = stringifyState.indent;
        stringifyState.indent = stringifyState.indent + stringifyState.gap;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (object3 != null) {
            int n;
            Object[] objectArray = null;
            if (object3.getClass().isArray()) {
                int n2 = Array.getLength(object3);
                objectArray = new Object[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = Context.javaToJS(Array.get(object3, n), stringifyState.scope, stringifyState.cx);
                }
            } else if (object3 instanceof Collection) {
                Collection collection = (Collection)object3;
                objectArray = new Object[collection.size()];
                n = 0;
                for (Object object4 : collection) {
                    objectArray[n++] = Context.javaToJS(object4, stringifyState.scope, stringifyState.cx);
                }
            }
            if (objectArray != null) {
                scriptable = stringifyState.cx.newArray(stringifyState.scope, objectArray);
            }
        }
        long l = ((NativeArray)scriptable).getLength();
        for (long i = 0L; i < l; ++i) {
            object4 = i > Integer.MAX_VALUE ? NativeJSON.str(Long.toString(i), scriptable, stringifyState) : NativeJSON.str((int)i, scriptable, stringifyState);
            if (object4 == Undefined.instance) {
                linkedList.add("null");
                continue;
            }
            linkedList.add(object4);
        }
        if (linkedList.isEmpty()) {
            string = "[]";
        } else if (stringifyState.gap.length() == 0) {
            string = '[' + NativeJSON.join(linkedList, ",") + ']';
        } else {
            String string3 = ",\n" + stringifyState.indent;
            object4 = NativeJSON.join(linkedList, string3);
            string = "[\n" + stringifyState.indent + (String)object4 + '\n' + string2 + ']';
        }
        stringifyState.stack.pop();
        stringifyState.indent = string2;
        return string;
    }

    private static String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append('\"');
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        stringBuilder.append("\\u");
                        String string2 = String.format("%04x", c);
                        stringBuilder.append(string2);
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private static Object javaToJSON(Object object, StringifyState stringifyState) {
        object = stringifyState.cx.getJavaToJSONConverter().apply(object);
        object = Context.javaToJS(object, stringifyState.scope, stringifyState.cx);
        NativeObject nativeObject = new NativeObject();
        nativeObject.setParentScope(stringifyState.scope);
        nativeObject.setPrototype(ScriptableObject.getObjectPrototype(stringifyState.scope));
        nativeObject.defineProperty("", object, 0);
        return NativeJSON.str("", nativeObject, stringifyState);
    }

    private static boolean isObjectArrayLike(Object object) {
        if (object instanceof NativeArray) {
            return true;
        }
        if (object instanceof NativeJavaObject) {
            Object object2 = ((NativeJavaObject)object).unwrap();
            return object2 instanceof Collection || object2.getClass().isArray();
        }
        return false;
    }

    private static class StringifyState {
        Stack<Object> stack = new Stack();
        String indent;
        String gap;
        Callable replacer;
        Object[] propertyList;
        Context cx;
        Scriptable scope;

        StringifyState(Context context, Scriptable scriptable, String string, String string2, Callable callable, Object[] objectArray) {
            this.cx = context;
            this.scope = scriptable;
            this.indent = string;
            this.gap = string2;
            this.replacer = callable;
            this.propertyList = objectArray;
        }
    }
}

