/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;

public class MySQLPackage
implements DBPScriptObject,
DBPScriptObjectExt,
DBSObjectContainer,
DBPRefreshableObject,
DBSProcedureContainer,
DBSPackage,
DBPQualifiedObject {
    private MySQLCatalog catalog;
    private String name;
    private String description;
    private boolean persisted;
    private final ProceduresCache proceduresCache = new ProceduresCache();
    private String sourceDeclaration;
    private String sourceDefinition;

    public MySQLPackage(MySQLCatalog catalog, ResultSet dbResult) {
        this.catalog = catalog;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        this.persisted = true;
    }

    public MySQLPackage(MySQLCatalog catalog, String name) {
        this.catalog = catalog;
        this.name = name;
        this.persisted = false;
    }

    public DBPDataSource getDataSource() {
        return this.catalog.getDataSource();
    }

    public DBSObject getParentObject() {
        return this.catalog;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this});
    }

    @Property(viewable=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public MySQLCatalog getCatalog() {
        return this.catalog;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBCException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = this.readSource(monitor, false);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String sourceDeclaration) {
        this.sourceDeclaration = sourceDeclaration;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getExtendedDefinitionText(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sourceDefinition == null && monitor != null) {
            this.sourceDefinition = this.readSource(monitor, true);
        }
        return this.sourceDefinition;
    }

    public void setExtendedDefinitionText(String source) {
        this.sourceDefinition = source;
    }

    @Association
    public Collection<MySQLProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public MySQLProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (MySQLProcedure)this.proceduresCache.getObject(monitor, (DBSObject)this, uniqueName);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.proceduresCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return MySQLProcedure.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.proceduresCache.clearCache();
        this.sourceDeclaration = null;
        this.sourceDefinition = null;
        return this;
    }

    /*
     * Loose catch block
     */
    private String readSource(DBRProgressMonitor monitor, boolean isBody) throws DBCException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read package declaration");){
            JDBCResultSet dbResult;
            JDBCPreparedStatement dbStat;
            block21: {
                String string;
                block23: {
                    block22: {
                        dbStat = session.prepareStatement("SHOW CREATE PACKAGE" + (isBody ? " BODY" : "") + " " + this.getFullyQualifiedName(DBPEvaluationContext.DML));
                        dbResult = dbStat.executeQuery();
                        if (!dbResult.next()) break block21;
                        string = JDBCUtils.safeGetString((ResultSet)dbResult, (String)(isBody ? "Create Package Body" : "Create Package"));
                        if (dbResult == null) break block22;
                        dbResult.close();
                    }
                    if (dbStat == null) break block23;
                    dbStat.close();
                }
                return string;
            }
            try {
                try {
                    throw new DBCException("Package '" + this.getName() + "' not found");
                    {
                        catch (Throwable throwable) {
                            if (dbResult != null) {
                                try {
                                    dbResult.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (dbStat != null) {
                        try {
                            dbStat.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
    }

    static class ProceduresCache
    extends JDBCObjectCache<MySQLPackage, MySQLProcedure> {
        ProceduresCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLPackage owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT P.*,CASE WHEN A.DATA_TYPE IS NULL THEN 'PROCEDURE' ELSE 'FUNCTION' END as PROCEDURE_TYPE FROM ALL_PROCEDURES P\nLEFT OUTER JOIN ALL_ARGUMENTS A ON A.OWNER=P.OWNER AND A.PACKAGE_NAME=P.OBJECT_NAME AND A.OBJECT_NAME=P.PROCEDURE_NAME AND A.ARGUMENT_NAME IS NULL AND A.DATA_LEVEL=0\nWHERE P.OWNER=? AND P.OBJECT_NAME=?\nORDER BY P.PROCEDURE_NAME");
            dbStat.setString(1, owner.getCatalog().getName());
            dbStat.setString(2, owner.getName());
            return dbStat;
        }

        protected MySQLProcedure fetchObject(@NotNull JDBCSession session, @NotNull MySQLPackage owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLProcedure(owner.getCatalog(), (ResultSet)dbResult);
        }
    }
}

