/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oceanbase.ui.internal.Activator;
import org.jkiss.dbeaver.ext.oceanbase.ui.internal.OceanbaseMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class OceanbaseConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(OceanbaseConnectionPage.class);
    private static final ImageDescriptor logoImage = Activator.getImageDescriptor("icons/ob_logo.png");
    private Text portText;
    private Text hostText;
    private Text databaseText;
    private Text tenantText;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        ModifyListener textListener = e -> this.evaluateURL();
        Composite addrGroup = new Composite(composite, 0);
        GridLayout gl = new GridLayout(1, false);
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Composite hostGroup = UIUtils.createTitledComposite((Composite)addrGroup, (String)OceanbaseMessages.oceanbase_connection_page_label_connection, (int)4, (int)768);
        Label hostLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)OceanbaseMessages.oceanbase_connection_page_label_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(hostGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        Label portLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)OceanbaseMessages.oceanbase_connection_page_label_port);
        portLabel.setLayoutData((Object)new GridData(128));
        this.portText = new Text(hostGroup, 2048);
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 5;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        Label databaseLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)OceanbaseMessages.oceanbase_connection_page_label_database);
        databaseLabel.setLayoutData((Object)new GridData(128));
        this.databaseText = new Text(hostGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.databaseText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.databaseText);
        this.databaseText.addModifyListener(textListener);
        Label tenantLabel = UIUtils.createControlLabel((Composite)hostGroup, (String)OceanbaseMessages.oceanbase_connection_page_label_tenant);
        tenantLabel.setLayoutData((Object)new GridData(128));
        this.tenantText = new Text(hostGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.tenantText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.tenantText);
        this.tenantText.addModifyListener(textListener);
        this.createAuthPanel(addrGroup, 1);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    public boolean isComplete() {
        return super.isComplete() && this.hostText != null && this.databaseText != null && this.portText != null && this.tenantText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        DBPDataSourceContainer activeDataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = activeDataSource.getConnectionConfiguration();
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        } else {
            this.hostText.setText("localhost");
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            this.portText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostPort()));
        } else if (this.site.getDriver().getDefaultPort() != null) {
            this.portText.setText(this.site.getDriver().getDefaultPort());
        } else {
            this.portText.setText("");
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.databaseText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
            this.tenantText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.databaseText != null) {
            connectionInfo.setDatabaseName(this.databaseText.getText().trim());
        }
        if (this.tenantText != null) {
            connectionInfo.setServerName(this.tenantText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "oceanbase_native";
    }

    private void evaluateURL() {
        this.site.updateButtons();
    }
}

