﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/VirtualNodeData.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AppMesh {
namespace Model {
/**
 * <zonbook></zonbook><xhtml></xhtml><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualNodeOutput">AWS
 * API Reference</a></p>
 */
class CreateVirtualNodeResult {
 public:
  AWS_APPMESH_API CreateVirtualNodeResult() = default;
  AWS_APPMESH_API CreateVirtualNodeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPMESH_API CreateVirtualNodeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The full description of your virtual node following the create call.</p>
   */
  inline const VirtualNodeData& GetVirtualNode() const { return m_virtualNode; }
  template <typename VirtualNodeT = VirtualNodeData>
  void SetVirtualNode(VirtualNodeT&& value) {
    m_virtualNodeHasBeenSet = true;
    m_virtualNode = std::forward<VirtualNodeT>(value);
  }
  template <typename VirtualNodeT = VirtualNodeData>
  CreateVirtualNodeResult& WithVirtualNode(VirtualNodeT&& value) {
    SetVirtualNode(std::forward<VirtualNodeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateVirtualNodeResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  VirtualNodeData m_virtualNode;

  Aws::String m_requestId;
  bool m_virtualNodeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
