/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.RevisionId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a0\u0010\b\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u001a\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002\u00a8\u0006\u0018"}, d2={"createDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "e", "Lcom/intellij/history/core/tree/Entry;", "createCurrentDiffContent", "path", "", "entry", "changeSetId", "", "calculator", "Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "progress", "Lcom/intellij/history/integration/ui/models/RevisionProcessingProgress;", "from", "", "to", "createUnavailableContent", "Lcom/intellij/diff/contents/DocumentContent;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public final class EntryDiffContentKt {
    @NotNull
    public static final DiffContent createDiffContent(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull Entry e) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        byte[] content = e.getContent().getBytes();
        VirtualFile virtualFile = gateway.findVirtualFile(e.getPath());
        if (virtualFile != null) {
            DocumentContent documentContent = DiffContentFactoryEx.getInstanceEx().createDocumentFromBytes(project, content, virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"createDocumentFromBytes(...)");
            return (DiffContent)documentContent;
        }
        FileType fileType = gateway.getFileType(e.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        DocumentContent documentContent = DiffContentFactoryEx.getInstanceEx().createDocumentFromBytes(project, content, fileType2, e.getName());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"createDocumentFromBytes(...)");
        return (DiffContent)documentContent;
    }

    @NotNull
    public static final DiffContent createCurrentDiffContent(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Document document = (Document)ActionsKt.runReadAction(() -> EntryDiffContentKt.createCurrentDiffContent$lambda$0(gateway, path));
        if (document == null) {
            return (DiffContent)EntryDiffContentKt.createUnavailableContent();
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, document);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        return (DiffContent)documentContent;
    }

    @NotNull
    public static final DiffContent createDiffContent(@NotNull IdeaGateway gateway, @NotNull Entry entry, long changeSetId, @NotNull SelectionCalculator calculator, @NotNull RevisionProcessingProgress progress) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)calculator, (String)"calculator");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        String string = calculator.getSelectionFor(new RevisionId.ChangeSet(changeSetId), (Progress)progress).getBlockContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBlockContent(...)");
        String content = string;
        VirtualFile virtualFile = gateway.findVirtualFile(entry.getPath());
        if (virtualFile != null) {
            DocumentContent documentContent = DiffContentFactory.getInstance().create(content, virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
            return (DiffContent)documentContent;
        }
        FileType fileType = gateway.getFileType(entry.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        DocumentContent documentContent = DiffContentFactory.getInstance().create(content, fileType2);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        return (DiffContent)documentContent;
    }

    @NotNull
    public static final DiffContent createCurrentDiffContent(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull String path, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (DiffContent)ActionsKt.runReadAction(() -> EntryDiffContentKt.createCurrentDiffContent$lambda$1(gateway, path, from, to, project));
    }

    private static final DocumentContent createUnavailableContent() {
        DocumentContent documentContent = DiffContentFactory.getInstance().create(LocalHistoryBundle.message("content.not.available", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        return documentContent;
    }

    private static final Document createCurrentDiffContent$lambda$0(IdeaGateway $gateway, String $path) {
        return $gateway.getDocument($path);
    }

    private static final DocumentContent createCurrentDiffContent$lambda$1(IdeaGateway $gateway, String $path, int $from, int $to, Project $project) {
        Document document = $gateway.getDocument($path);
        if (document == null) {
            return EntryDiffContentKt.createUnavailableContent();
        }
        int fromOffset = document.getLineStartOffset($from);
        int toOffset = document.getLineEndOffset($to);
        DocumentContent documentContent = DiffContentFactory.getInstance().createFragment($project, document, new TextRange(fromOffset, toOffset));
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"createFragment(...)");
        return documentContent;
    }
}

